DROP TABLE IF EXISTS `%DB_PREFIX%admin`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%admin` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `admin_name` varchar(60) NOT NULL,
  `admin_pwd` char(32) NOT NULL,
  `last_login_time` int(11) unsigned DEFAULT '0',
  `last_login_ip` varchar(40) DEFAULT NULL,
  `login_count` mediumint(8) unsigned DEFAULT '0',
  `create_time` int(11) unsigned NOT NULL,
  `update_time` int(11) unsigned NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  `role_id` smallint(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `admin_user` (`admin_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `%DB_PREFIX%admin` (`id`, `admin_name`, `admin_pwd`, `last_login_time`, `last_login_ip`, `login_count`, `create_time`, `update_time`, `status`, `role_id`) VALUES
(1, 'fanwe', '6714ccb93be0fda4e51f206b91b46358', 1313570043, '127.0.0.1', 0, 0, 0, 1, 1);

DROP TABLE IF EXISTS `%DB_PREFIX%admin_log`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `log_module` varchar(60) NOT NULL DEFAULT '',
  `log_action` varchar(60) NOT NULL DEFAULT '',
  `data_id` int(11) NOT NULL COMMENT '操作的相关数据主键',
  `log_time` int(11) NOT NULL,
  `admin_id` mediumint(8) NOT NULL DEFAULT '0',
  `ip` varchar(60) NOT NULL DEFAULT '',
  `log_result` tinyint(1) NOT NULL COMMENT '0:失败 1:成功',
  `log_msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%ask`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%ask` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) DEFAULT '',
  `sort` smallint(5) DEFAULT '100',
  `uid` int(11) DEFAULT NULL,
  `user_name` char(15) DEFAULT NULL,
  `create_time` int(11) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `thread_count` int(11) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

INSERT INTO `%DB_PREFIX%ask` (`aid`, `name`, `sort`, `uid`, `user_name`, `create_time`, `status`, `thread_count`) VALUES
(1, '服装搭配', 100, 0, '', 1308802605, 1, 0),
(2, '美容美妆', 99, 0, '', 1308802605, 1, 0),
(3, '配件饰品', 98, 0, '', 1308802605, 1, 0),
(4, '塑身美体', 97, 0, '', 1308802605, 1, 0),
(5, '鞋帽箱包', 96, 0, '', 1308802605, 1, 0),
(6, '礼物推荐', 95, 0, '', 1308802605, 1, 0),
(7, '家居母婴', 94, 0, '', 1308802605, 1, 0),
(8, '食品保健', 93, 0, '', 1308802605, 1, 0),
(9, '数码家电', 92, 0, '', 1308802605, 1, 0),
(10, '真假鉴别', 91, 0, '', 1308802605, 1, 0),
(11, '方维答疑', 90, 0, '', 1308802605, 1, 0),
(12, '五六折答疑', 89, 0, '', 1308802605, 1, 0),
(13, '淘宝答疑', 88, 0, '', 1308802605, 1, 0),
(14, '其他', 87, 0, '', 1308802605, 1, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%ask_fields`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%ask_fields` (
  `aid` smallint(6) unsigned NOT NULL,
  `desc` text NOT NULL,
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  `seo_desc` varchar(255) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%ask_fields` (`aid`, `desc`, `seo_keywords`, `seo_desc`, `logo`) VALUES
(1, '', '', '', ''),
(2, '', '', '', ''),
(3, '', '', '', ''),
(4, '', '', '', ''),
(5, '', '', '', ''),
(6, '', '', '', ''),
(7, '', '', '', ''),
(8, '', '', '', ''),
(9, '', '', '', ''),
(10, '', '', '', ''),
(11, '', '', '', ''),
(12, '', '', '', ''),
(13, '', '', '', ''),
(14, '', '', '', '');

DROP TABLE IF EXISTS `%DB_PREFIX%ask_post`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%ask_post` (
  `pid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tid` int(11) DEFAULT NULL,
  `share_id` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `user_name` char(15) DEFAULT '',
  `content` text,
  `is_best` tinyint(1) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `tid` (`tid`),
  KEY `uid` (`uid`),
  KEY `share_id` USING BTREE (`share_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%ask_thread`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%ask_thread` (
  `tid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) NOT NULL,
  `share_id` int(11) DEFAULT NULL,
  `title` varchar(80) DEFAULT '',
  `content` text,
  `uid` int(11) DEFAULT NULL,
  `user_name` char(15) DEFAULT '',
  `is_solve` tinyint(1) DEFAULT '0',
  `is_top` tinyint(1) DEFAULT '0',
  `is_best` tinyint(1) DEFAULT '0',
  `sort` smallint(5) DEFAULT '100',
  `status` tinyint(1) DEFAULT '1',
  `post_count` int(11) DEFAULT '0',
  `click_count` int(11) DEFAULT '0',
  `lastpost` int(11) DEFAULT '0',
  `lastposter` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `aid` (`aid`),
  KEY `uid` (`uid`),
  KEY `share_id` USING BTREE (`share_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%expression`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%expression` (
  `expression_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL DEFAULT 'tusiji',
  `emotion` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL,
  PRIMARY KEY (`expression_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=135 ;

INSERT INTO `%DB_PREFIX%expression` (`expression_id`, `title`, `type`, `emotion`, `filename`) VALUES
(19, '傲慢', 'qq', '[傲慢]', 'aoman.gif'),
(20, '白眼', 'qq', '[白眼]', 'baiyan.gif'),
(21, '鄙视', 'qq', '[鄙视]', 'bishi.gif'),
(22, '闭嘴', 'qq', '[闭嘴]', 'bizui.gif'),
(23, '擦汗', 'qq', '[擦汗]', 'cahan.gif'),
(24, '菜刀', 'qq', '[菜刀]', 'caidao.gif'),
(25, '差劲', 'qq', '[差劲]', 'chajin.gif'),
(26, '欢庆', 'qq', '[欢庆]', 'cheer.gif'),
(27, '虫子', 'qq', '[虫子]', 'chong.gif'),
(28, '呲牙', 'qq', '[呲牙]', 'ciya.gif'),
(29, '捶打', 'qq', '[捶打]', 'da.gif'),
(30, '大便', 'qq', '[大便]', 'dabian.gif'),
(31, '大兵', 'qq', '[大兵]', 'dabing.gif'),
(32, '大叫', 'qq', '[大叫]', 'dajiao.gif'),
(33, '大哭', 'qq', '[大哭]', 'daku.gif'),
(34, '蛋糕', 'qq', '[蛋糕]', 'dangao.gif'),
(35, '发怒', 'qq', '[发怒]', 'fanu.gif'),
(36, '刀', 'qq', '[刀]', 'dao.gif'),
(37, '得意', 'qq', '[得意]', 'deyi.gif'),
(38, '凋谢', 'qq', '[凋谢]', 'diaoxie.gif'),
(39, '饿', 'qq', '[饿]', 'er.gif'),
(40, '发呆', 'qq', '[发呆]', 'fadai.gif'),
(41, '发抖', 'qq', '[发抖]', 'fadou.gif'),
(42, '饭', 'qq', '[饭]', 'fan.gif'),
(43, '飞吻', 'qq', '[飞吻]', 'feiwen.gif'),
(44, '奋斗', 'qq', '[奋斗]', 'fendou.gif'),
(45, '尴尬', 'qq', '[尴尬]', 'gangga.gif'),
(46, '给力', 'qq', '[给力]', 'geili.gif'),
(47, '勾引', 'qq', '[勾引]', 'gouyin.gif'),
(48, '鼓掌', 'qq', '[鼓掌]', 'guzhang.gif'),
(49, '哈哈', 'qq', '[哈哈]', 'haha.gif'),
(50, '害羞', 'qq', '[害羞]', 'haixiu.gif'),
(51, '哈欠', 'qq', '[哈欠]', 'haqian.gif'),
(52, '花', 'qq', '[花]', 'hua.gif'),
(53, '坏笑', 'qq', '[坏笑]', 'huaixiao.gif'),
(54, '挥手', 'qq', '[挥手]', 'huishou.gif'),
(55, '回头', 'qq', '[回头]', 'huitou.gif'),
(56, '激动', 'qq', '[激动]', 'jidong.gif'),
(57, '惊恐', 'qq', '[惊恐]', 'jingkong.gif'),
(58, '惊讶', 'qq', '[惊讶]', 'jingya.gif'),
(59, '咖啡', 'qq', '[咖啡]', 'kafei.gif'),
(60, '可爱', 'qq', '[可爱]', 'keai.gif'),
(61, '可怜', 'qq', '[可怜]', 'kelian.gif'),
(62, '磕头', 'qq', '[磕头]', 'ketou.gif'),
(63, '示爱', 'qq', '[示爱]', 'kiss.gif'),
(64, '酷', 'qq', '[酷]', 'ku.gif'),
(65, '难过', 'qq', '[难过]', 'kuaikule.gif'),
(66, '骷髅', 'qq', '[骷髅]', 'kulou.gif'),
(67, '困', 'qq', '[困]', 'kun.gif'),
(68, '篮球', 'qq', '[篮球]', 'lanqiu.gif'),
(69, '冷汗', 'qq', '[冷汗]', 'lenghan.gif'),
(70, '流汗', 'qq', '[流汗]', 'liuhan.gif'),
(71, '流泪', 'qq', '[流泪]', 'liulei.gif'),
(72, '礼物', 'qq', '[礼物]', 'liwu.gif'),
(73, '爱心', 'qq', '[爱心]', 'love.gif'),
(74, '骂人', 'qq', '[骂人]', 'ma.gif'),
(75, '不开心', 'qq', '[不开心]', 'nanguo.gif'),
(76, '不好', 'qq', '[不好]', 'no.gif'),
(77, '很好', 'qq', '[很好]', 'ok.gif'),
(78, '佩服', 'qq', '[佩服]', 'peifu.gif'),
(79, '啤酒', 'qq', '[啤酒]', 'pijiu.gif'),
(80, '乒乓', 'qq', '[乒乓]', 'pingpang.gif'),
(81, '撇嘴', 'qq', '[撇嘴]', 'pizui.gif'),
(82, '强', 'qq', '[强]', 'qiang.gif'),
(83, '亲亲', 'qq', '[亲亲]', 'qinqin.gif'),
(84, '出丑', 'qq', '[出丑]', 'qioudale.gif'),
(85, '足球', 'qq', '[足球]', 'qiu.gif'),
(86, '拳头', 'qq', '[拳头]', 'quantou.gif'),
(87, '弱', 'qq', '[弱]', 'ruo.gif'),
(88, '色', 'qq', '[色]', 'se.gif'),
(89, '闪电', 'qq', '[闪电]', 'shandian.gif'),
(90, '胜利', 'qq', '[胜利]', 'shengli.gif'),
(91, '衰', 'qq', '[衰]', 'shuai.gif'),
(92, '睡觉', 'qq', '[睡觉]', 'shuijiao.gif'),
(93, '太阳', 'qq', '[太阳]', 'taiyang.gif'),
(96, '啊', 'tusiji', '[啊]', 'aa.gif'),
(97, '暗爽', 'tusiji', '[暗爽]', 'anshuang.gif'),
(98, 'byebye', 'tusiji', '[byebye]', 'baibai.gif'),
(99, '不行', 'tusiji', '[不行]', 'buxing.gif'),
(100, '戳眼', 'tusiji', '[戳眼]', 'chuoyan.gif'),
(101, '很得意', 'tusiji', '[很得意]', 'deyi.gif'),
(102, '顶', 'tusiji', '[顶]', 'ding.gif'),
(103, '抖抖', 'tusiji', '[抖抖]', 'douxiong.gif'),
(104, '哼', 'tusiji', '[哼]', 'heng.gif'),
(105, '挥汗', 'tusiji', '[挥汗]', 'huihan.gif'),
(106, '昏迷', 'tusiji', '[昏迷]', 'hunmi.gif'),
(107, '互拍', 'tusiji', '[互拍]', 'hupai.gif'),
(108, '瞌睡', 'tusiji', '[瞌睡]', 'keshui.gif'),
(109, '笼子', 'tusiji', '[笼子]', 'longzi.gif'),
(110, '听歌', 'tusiji', '[听歌]', 'music.gif'),
(111, '奶瓶', 'tusiji', '[奶瓶]', 'naiping.gif'),
(112, '扭背', 'tusiji', '[扭背]', 'niubei.gif'),
(113, '拍砖', 'tusiji', '[拍砖]', 'paizhuan.gif'),
(114, '飘过', 'tusiji', '[飘过]', 'piaoguo.gif'),
(115, '揉脸', 'tusiji', '[揉脸]', 'roulian.gif'),
(116, '闪闪', 'tusiji', '[闪闪]', 'shanshan.gif'),
(117, '生日', 'tusiji', '[生日]', 'shengri.gif'),
(118, '摊手', 'tusiji', '[摊手]', 'tanshou.gif'),
(119, '躺坐', 'tusiji', '[躺坐]', 'tanzuo.gif'),
(120, '歪头', 'tusiji', '[歪头]', 'waitou.gif'),
(121, '我踢', 'tusiji', '[我踢]', 'woti.gif'),
(122, '无聊', 'tusiji', '[无聊]', 'wuliao.gif'),
(123, '醒醒', 'tusiji', '[醒醒]', 'xingxing.gif'),
(124, '睡了', 'tusiji', '[睡了]', 'xixishui.gif'),
(125, '旋转', 'tusiji', '[旋转]', 'xuanzhuan.gif'),
(126, '摇晃', 'tusiji', '[摇晃]', 'yaohuang.gif'),
(127, '耶', 'tusiji', '[耶]', 'yeah.gif'),
(128, '郁闷', 'tusiji', '[郁闷]', 'yumen.gif'),
(129, '晕厥', 'tusiji', '[晕厥]', 'yunjue.gif'),
(130, '砸', 'tusiji', '[砸]', 'za.gif'),
(131, '震荡', 'tusiji', '[震荡]', 'zhendang.gif'),
(132, '撞墙', 'tusiji', '[撞墙]', 'zhuangqiang.gif'),
(133, '转头', 'tusiji', '[转头]', 'zhuantou.gif'),
(134, '抓墙', 'tusiji', '[抓墙]', 'zhuaqiang.gif');

DROP TABLE IF EXISTS `%DB_PREFIX%forum`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%forum` (
  `fid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) DEFAULT '',
  `uid` int(11) DEFAULT '0',
  `user_name` char(15) DEFAULT '',
  `parent_id` smallint(6) DEFAULT '0',
  `sort` smallint(5) DEFAULT '100',
  `create_time` int(11) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `thread_count` int(11) DEFAULT '0',
  PRIMARY KEY (`fid`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=43 ;

INSERT INTO `%DB_PREFIX%forum` (`fid`, `name`, `uid`, `user_name`, `parent_id`, `sort`, `create_time`, `status`, `thread_count`) VALUES
(1, '购物实拍', 0, '', 0, 1, 1310766076, 1, 0),
(2, '方维Show', 0, '', 0, 2, 1310766092, 1, 0),
(3, '服装配饰', 0, '', 0, 3, 1310766101, 1, 0),
(4, '时尚潮流', 0, '', 0, 4, 1310766108, 1, 0),
(5, '败家俱乐部', 0, '', 0, 5, 1310766115, 1, 0),
(6, '美容保养', 0, '', 0, 6, 1310766123, 1, 0),
(7, '家居生活', 0, '', 0, 7, 1310766131, 1, 0),
(8, '方维大水塘', 0, '', 0, 8, 1310766143, 1, 5),
(9, '方维活动吧', 0, '', 0, 9, 1310766160, 1, 0),
(10, '网购', 0, '', 1, 10, 1310766185, 1, 0),
(11, '实体', 0, '', 1, 11, 1310766193, 1, 0),
(12, '港台', 0, '', 1, 12, 1310766229, 1, 0),
(13, '海外', 0, '', 1, 13, 1310766237, 1, 0),
(14, '搭配日记', 0, '', 2, 14, 1310766257, 1, 0),
(15, '彩妆look', 0, '', 2, 15, 1310766270, 1, 0),
(16, '清新素颜', 0, '', 2, 16, 1310766280, 1, 0),
(17, '其它', 0, '', 2, 17, 1310766288, 1, 0),
(18, '时尚单品', 0, '', 3, 18, 1310766316, 1, 0),
(19, '风格搭配', 0, '', 3, 19, 1310766328, 1, 0),
(20, '就爱配饰', 0, '', 3, 20, 1310766337, 1, 0),
(21, '鞋包控', 0, '', 3, 21, 1310766346, 1, 0),
(22, '品牌大片', 0, '', 4, 22, 1310766364, 1, 0),
(23, '明星look', 0, '', 4, 23, 1310766377, 1, 0),
(24, '街拍&名博', 0, '', 4, 24, 1310766385, 1, 0),
(25, '其它', 0, '', 4, 25, 1310766394, 1, 0),
(26, '败家攻略', 0, '', 5, 26, 1310766411, 1, 0),
(27, '收藏夹', 0, '', 5, 27, 1310766418, 1, 0),
(28, '淘宝潮流榜', 0, '', 5, 28, 1310766425, 1, 0),
(29, '其它', 0, '', 5, 29, 1310766432, 1, 0),
(30, '护肤', 0, '', 6, 30, 1310766446, 1, 0),
(31, '靓妆', 0, '', 6, 31, 1310766455, 1, 0),
(32, '美甲&香水', 0, '', 6, 32, 1310766487, 1, 0),
(33, '美体', 0, '', 6, 33, 1310766498, 1, 0),
(34, '其它', 0, '', 6, 34, 1310766506, 1, 0),
(35, '吃喝玩乐', 0, '', 7, 35, 1310766521, 1, 0),
(36, '我爱我家', 0, '', 7, 36, 1310766530, 1, 0),
(37, '小物&DIY', 0, '', 7, 37, 1310766541, 1, 0),
(38, '手机数码', 0, '', 7, 38, 1310766549, 1, 0),
(39, '亲子乐园', 0, '', 7, 39, 1310766558, 1, 0),
(40, '其它', 0, '', 7, 40, 1310766567, 1, 0),
(41, '试用报告', 0, '', 9, 41, 1310766590, 1, 0),
(42, '随便说说', 0, '', 9, 42, 1310766598, 1, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%forum_fields`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%forum_fields` (
  `fid` smallint(6) unsigned NOT NULL,
  `desc` text,
  `seo_keywords` varchar(255) NOT NULL DEFAULT '',
  `seo_desc` varchar(255) NOT NULL DEFAULT '',
  `logo` varchar(255) NOT NULL DEFAULT '',
  `img` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`fid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%forum_fields` (`fid`, `desc`, `seo_keywords`, `seo_desc`, `logo`, `img`) VALUES
(1, '血拼归来啰！包裹到手啦! 新货入荷要上蘑菇街来秀一秀。无论是得意的宝贝，还是恼人的次品，与 蘑菇们一起分享吧。', '', '', './public/upload/images/201108/18/4e4c3d36ef43a.jpg', './public/upload/images/201108/18/4e4c3d3700552.jpg'),
(2, '小蘑菇们，来蘑菇街露个脸，互相熟悉一下吧。当然笑笑更cute哦：）', '', '', './public/upload/images/201108/18/4e4c3d8103d07.png', './public/upload/images/201108/18/4e4c3d81044b3.jpg'),
(3, '新衣上身，美的冒泡，子曰独美美不如众美美，还不秀出来？：）', '', '', './public/upload/images/201108/18/4e4c3db681396.jpg', './public/upload/images/201108/18/4e4c3db6819aa.jpg'),
(4, '搜寻最in的潮牌潮品，关注最新鲜的时尚资讯，一切尽在时尚潮流吧~\r\n关注时尚，打造属于你的个性穿搭，你也能够成为 时尚达人！\r\n赶紧跟随我们的脚步 HIGH起来吧~ GO ！', '', '', './public/upload/images/201108/18/4e4c3e173115f.jpg', './public/upload/images/201108/18/4e4c3e1731781.jpg'),
(5, '把你收藏的好店、好商品分享给大家吧！地球人都会感谢你的。', '', '', './public/upload/images/201108/18/4e4c3e686baf3.jpg', './public/upload/images/201108/18/4e4c3e686c0ef.jpg'),
(6, '白嫩嫩，水当当，佛说又美又白的水蘑菇是靠保养出来滴：）', '', '', './public/upload/images/201108/18/4e4c3ea63269d.jpg', './public/upload/images/201108/18/4e4c3ea632c94.jpg'),
(7, '家居小物，吃喝玩乐，手机数码…………大家给力的聊吧！', '', '', './public/upload/images/201108/18/4e4c3ed3eb234.jpg', './public/upload/images/201108/18/4e4c3ed3eb824.jpg'),
(8, '无主题的主题吧，欢迎扎堆唠嗑。', '', '', './public/upload/images/201108/18/4e4c3ef744f84.png', './public/upload/images/201108/18/4e4c3ef7455b1.jpg'),
(9, '蘑菇街官方活动吧，来许下你的礼物愿望吧，蘑菇街帮你实现。', '', '', './public/upload/images/201108/18/4e4c3f1ab95aa.png', './public/upload/images/201108/18/4e4c3f1ab9b72.jpg'),
(10, '', '', '', '', ''),
(11, '', '', '', '', ''),
(12, '', '', '', '', ''),
(13, '', '', '', '', ''),
(14, '', '', '', '', ''),
(15, '', '', '', '', ''),
(16, '', '', '', '', ''),
(17, '', '', '', '', ''),
(18, '', '', '', '', ''),
(19, '', '', '', '', ''),
(20, '', '', '', '', ''),
(21, '', '', '', '', ''),
(22, '', '', '', '', ''),
(23, '', '', '', '', ''),
(24, '', '', '', '', ''),
(25, '', '', '', '', ''),
(26, '', '', '', '', ''),
(27, '', '', '', '', ''),
(28, '', '', '', '', ''),
(29, '', '', '', '', ''),
(30, '', '', '', '', ''),
(31, '', '', '', '', ''),
(32, '', '', '', '', ''),
(33, '', '', '', '', ''),
(34, '', '', '', '', ''),
(35, '', '', '', '', ''),
(36, '', '', '', '', ''),
(37, '', '', '', '', ''),
(38, '', '', '', '', ''),
(39, '', '', '', '', ''),
(40, '', '', '', '', ''),
(41, '', '', '', '', ''),
(42, '', '', '', '', '');

DROP TABLE IF EXISTS `%DB_PREFIX%forum_post`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%forum_post` (
  `pid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tid` int(11) DEFAULT NULL,
  `share_id` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `user_name` char(15) DEFAULT '',
  `content` text,
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `tid` (`tid`),
  KEY `uid` (`uid`),
  KEY `share_id` USING BTREE (`share_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%forum_thread`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%forum_thread` (
  `tid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fid` smallint(6) NOT NULL,
  `share_id` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `title` varchar(100) DEFAULT '',
  `content` text,
  `is_top` tinyint(1) DEFAULT '0',
  `is_best` tinyint(1) DEFAULT '0',
  `is_event` tinyint(1) NOT NULL DEFAULT '0',
  `sort` smallint(5) DEFAULT '100',
  `status` tinyint(1) DEFAULT '1',
  `post_count` smallint(6) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  `click_count` int(11) NOT NULL DEFAULT '0',
  `lastpost` int(11) NOT NULL DEFAULT '0',
  `lastposter` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `share_id` USING BTREE (`share_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=6;

INSERT INTO `%DB_PREFIX%forum_thread` (`tid`, `fid`, `share_id`, `uid`, `title`, `content`, `is_top`, `is_best`, `is_event`, `sort`, `status`, `post_count`, `create_time`, `click_count`, `lastpost`, `lastposter`) VALUES
(1, 8, 1, 1, '招聘信息', '招聘信息', 0, 0, 0, 100, 1, 0, 1313002941, 0, 0, 0),
(2, 8, 2, 1, '联系我们', '联系我们', 0, 0, 0, 100, 1, 0, 1313004433, 0, 0, 0),
(3, 8, 3, 1, '新手指南', '新手指南', 0, 0, 0, 100, 1, 0, 1312928032, 0, 0, 0),
(4, 8, 4, 1, '意见簿', '意见簿', 0, 0, 0, 100, 1, 0, 1312930138, 0, 0, 0),
(5, 8, 5, 1, '申请达人', '申请达人', 0, 0, 0, 100, 1, 0, 1313021857, 0, 0, 0);


DROP TABLE IF EXISTS `%DB_PREFIX%friend_link`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%friend_link` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `img` varchar(255) NOT NULL DEFAULT '',
  `width` int(11) NOT NULL DEFAULT '0',
  `height` int(11) NOT NULL DEFAULT '0',
  `sort` smallint(5) NOT NULL DEFAULT '100',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

INSERT INTO `%DB_PREFIX%friend_link` (`id`, `name`, `url`, `img`, `width`, `height`, `sort`, `status`) VALUES
(1, '方维', 'http://www.fanwe.com/', '', 0, 0, 100, 1),
(2, '方维分享官方站', 'http://fx.wzuan.com/', '', 0, 0, 100, 1),
(3, '狗扑源码社区', 'http://bbs.gope.cn/', '', 0, 0, 100, 1),
(4, '淘宝刷信誉', 'http://www.shuak.com/', '', 0, 0, 100, 1);

DROP TABLE IF EXISTS `%DB_PREFIX%goods_category`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%goods_category` (
  `cate_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) DEFAULT '0',
  `cate_name` varchar(80) DEFAULT '',
  `short_name` varchar(60) NOT NULL DEFAULT '',
  `cate_code` varchar(80) DEFAULT '',
  `cate_icon` varchar(255) DEFAULT '',
  `desc` varchar(255) DEFAULT '',
  `seo_keywords` varchar(255) DEFAULT '',
  `seo_desc` varchar(255) DEFAULT '',
  `create_time` int(11) DEFAULT '0',
  `sort` smallint(6) NOT NULL DEFAULT '100',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `is_index` tinyint(1) NOT NULL DEFAULT '0',
  `is_root` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`cate_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=41 ;

INSERT INTO `%DB_PREFIX%goods_category` (`cate_id`, `parent_id`, `cate_name`, `short_name`, `cate_code`, `cate_icon`, `desc`, `seo_keywords`, `seo_desc`, `create_time`, `sort`, `status`, `is_index`, `is_root`) VALUES
(1, 0, '逛街啦！', '最新分享', '', './public/upload/images/201108/03/4e38bfee1e8c2.png', '告诉大家你爱的宝贝', '', '', 1312313198, 100, 1, 0, 1),
(2, 0, '上装', '上装', 'coats', './public/upload/images/201108/03/4e38c0bba963c.png', '告诉大家你爱的上装', '', '', 1312313403, 100, 1, 1, 0),
(3, 0, '下装', '下装', 'pants', './public/upload/images/201108/03/4e38c0e27b92f.png', '告诉大家你爱的下装', '', '', 1312313442, 100, 1, 1, 0),
(4, 0, '鞋子', '鞋子', 'shoes', './public/upload/images/201108/03/4e38c0ff4dd7b.png', '告诉大家你爱的鞋子', '', '', 1312313471, 100, 1, 1, 0),
(5, 0, '包包', '包包', 'bags', './public/upload/images/201108/03/4e38c1331dede.png', '告诉大家你爱的包包', '', '', 1312313523, 100, 1, 1, 0),
(6, 0, '配饰', '配饰', 'accessories', './public/upload/images/201108/03/4e38c15488fc5.png', '告诉大家你爱的配饰', '', '', 1312313556, 100, 1, 1, 0),
(7, 0, '美妆', '美妆', 'beauties', './public/upload/images/201108/03/4e38c189a9d38.png', '告诉大家你爱的美妆', '', '', 1312313609, 100, 1, 1, 0),
(8, 0, '家居', '家居', 'home', './public/upload/images/201108/03/4e38c1a893442.png', '告诉大家你爱的家居', '', '', 1312313640, 100, 1, 1, 0),
(9, 1, '百变style', '', '', '', '', '', '', 1312313702, 100, 1, 0, 0),
(10, 1, '酷感夏日', '', '', '', '', '', '', 1312313722, 100, 1, 0, 0),
(11, 1, '人气top', '', '', '', '', '', '', 1312313730, 100, 1, 0, 0),
(12, 1, '流行元素', '', '', '', '', '', '', 1312313739, 100, 1, 0, 0),
(13, 1, '潮流hunter', '', '', '', '', '', '', 1312313747, 100, 1, 0, 0),
(14, 2, 'T台热荐', '', '', '', '', '', '', 1312313773, 100, 1, 0, 0),
(15, 2, '潮流趋势', '', '', '', '', '', '', 1312313780, 100, 1, 0, 0),
(16, 2, '最夯风格', '', '', '', '', '', '', 1312313788, 100, 1, 0, 0),
(17, 2, '专属衣厨', '', '', '', '', '', '', 1312313797, 100, 1, 0, 0),
(18, 2, '内衣', '', '', '', '', '', '', 1312313805, 100, 1, 0, 0),
(19, 3, '流行元素', '', '', '', '', '', '', 1312313825, 100, 1, 0, 0),
(20, 3, '裙子vs裤子', '', '', '', '', '', '', 1312313834, 100, 1, 0, 0),
(21, 3, '牛仔很忙', '', '', '', '', '', '', 1312313845, 100, 1, 0, 0),
(22, 4, '类别', '', '', '', '', '', '', 1312313893, 100, 1, 0, 0),
(23, 4, '鞋型', '', '', '', '', '', '', 1312313900, 100, 1, 0, 0),
(24, 4, '风格&元素', '', '', '', '', '', '', 1312313909, 100, 1, 0, 0),
(25, 4, '流行大集合', '', '', '', '', '', '', 1312313920, 100, 1, 0, 0),
(26, 5, '有型有款', '', '', '', '', '', '', 1312313938, 100, 1, 0, 0),
(27, 5, '风格&元素', '', '', '', '', '', '', 1312313947, 100, 1, 0, 0),
(28, 5, '潮流风向标', '', '', '', '', '', '', 1312313956, 100, 1, 0, 0),
(29, 6, '配件', '', '', '', '', '', '', 1312313971, 100, 1, 0, 0),
(30, 6, '风格', '', '', '', '', '', '', 1312313979, 100, 1, 0, 0),
(31, 6, '元素', '', '', '', '', '', '', 1312313987, 100, 1, 0, 0),
(32, 7, '护肤', '', '', '', '', '', '', 1312314004, 100, 1, 0, 0),
(33, 7, '彩妆', '', '', '', '', '', '', 1312314011, 100, 1, 0, 0),
(34, 7, '热门品牌', '', '', '', '', '', '', 1312314020, 100, 1, 0, 0),
(35, 7, '热门讨论', '', '', '', '', '', '', 1312314028, 100, 1, 0, 0),
(36, 8, '生活&趣玩', '', '', '', '', '', '', 1312314041, 100, 1, 0, 0),
(37, 8, '瓶瓶&罐罐', '', '', '', '', '', '', 1312314052, 100, 1, 0, 0),
(38, 8, '文具控', '', '', '', '', '', '', 1312314060, 100, 1, 0, 0),
(39, 8, '收纳控', '', '', '', '', '', '', 1312314068, 100, 1, 0, 0),
(40, 8, '数码控', '', '', '', '', '', '', 1312314077, 100, 1, 0, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%goods_category_tags`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%goods_category_tags` (
  `cate_id` smallint(6) NOT NULL,
  `tag_id` smallint(6) NOT NULL,
  `weight` smallint(6) NOT NULL DEFAULT '1',
  KEY `cate_id` (`cate_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%goods_category_tags` (`cate_id`, `tag_id`, `weight`) VALUES
(9, 1, 0),
(9, 2, 0),
(9, 3, 0),
(9, 4, 0),
(9, 5, 0),
(9, 6, 0),
(9, 7, 0),
(9, 8, 0),
(9, 9, 0),
(10, 10, 0),
(10, 11, 0),
(10, 12, 0),
(10, 13, 0),
(10, 14, 0),
(10, 15, 0),
(10, 16, 0),
(10, 17, 0),
(10, 18, 0),
(10, 19, 0),
(11, 20, 0),
(11, 21, 0),
(11, 22, 0),
(11, 23, 0),
(11, 24, 0),
(11, 25, 0),
(11, 26, 0),
(11, 27, 0),
(11, 28, 0),
(11, 29, 0),
(11, 30, 0),
(12, 31, 0),
(12, 32, 0),
(12, 33, 0),
(12, 34, 0),
(12, 35, 0),
(12, 36, 0),
(12, 37, 0),
(12, 38, 0),
(12, 39, 0),
(12, 40, 0),
(12, 41, 0),
(12, 42, 0),
(13, 43, 0),
(13, 44, 0),
(13, 45, 0),
(13, 46, 0),
(13, 47, 0),
(13, 48, 0),
(13, 49, 0),
(13, 50, 0),
(13, 51, 0),
(13, 52, 0),
(13, 53, 0),
(13, 54, 0),
(13, 55, 0),
(13, 56, 0),
(14, 16, 0),
(14, 26, 0),
(14, 11, 0),
(14, 57, 0),
(14, 22, 0),
(14, 58, 0),
(14, 10, 0),
(14, 17, 0),
(14, 59, 0),
(15, 60, 0),
(15, 61, 0),
(15, 62, 0),
(15, 32, 0),
(15, 2, 0),
(15, 40, 0),
(15, 63, 0),
(15, 64, 0),
(15, 65, 0),
(15, 66, 0),
(15, 67, 0),
(15, 68, 0),
(16, 69, 0),
(16, 70, 0),
(16, 71, 0),
(16, 72, 0),
(16, 73, 0),
(16, 4, 0),
(16, 74, 0),
(16, 5, 0),
(16, 1, 0),
(17, 75, 0),
(17, 76, 0),
(17, 11, 0),
(17, 77, 0),
(17, 78, 0),
(17, 79, 0),
(17, 59, 0),
(18, 80, 0),
(18, 81, 0),
(18, 82, 0),
(18, 83, 0),
(18, 84, 0),
(19, 85, 0),
(19, 86, 0),
(19, 42, 0),
(19, 65, 0),
(19, 87, 0),
(19, 88, 0),
(19, 36, 0),
(19, 89, 0),
(19, 90, 0),
(20, 91, 0),
(20, 92, 0),
(20, 93, 0),
(20, 94, 0),
(20, 95, 0),
(20, 96, 0),
(20, 97, 0),
(20, 98, 0),
(20, 15, 0),
(20, 99, 0),
(20, 21, 0),
(20, 100, 0),
(21, 101, 0),
(21, 102, 0),
(21, 103, 0),
(21, 104, 0),
(21, 105, 0),
(21, 106, 0),
(21, 107, 0),
(22, 13, 0),
(22, 108, 0),
(22, 109, 0),
(22, 23, 0),
(22, 110, 0),
(22, 111, 0),
(22, 112, 0),
(22, 113, 0),
(22, 114, 0),
(22, 115, 0),
(22, 116, 0),
(22, 12, 0),
(22, 117, 0),
(22, 118, 0),
(22, 119, 0),
(23, 120, 0),
(23, 121, 0),
(23, 122, 0),
(23, 123, 0),
(23, 124, 0),
(23, 125, 0),
(23, 126, 0),
(23, 127, 0),
(23, 128, 0),
(23, 129, 0),
(23, 37, 0),
(24, 130, 0),
(24, 131, 0),
(24, 132, 0),
(24, 55, 0),
(24, 133, 0),
(24, 134, 0),
(24, 65, 0),
(24, 85, 0),
(24, 135, 0),
(24, 32, 0),
(24, 136, 0),
(24, 1, 0),
(24, 137, 0),
(25, 138, 0),
(25, 139, 0),
(25, 140, 0),
(25, 141, 0),
(25, 142, 0),
(25, 53, 0),
(25, 143, 0),
(25, 144, 0),
(25, 145, 0),
(25, 146, 0),
(26, 27, 0),
(26, 28, 0),
(26, 147, 0),
(26, 148, 0),
(26, 149, 0),
(26, 150, 0),
(26, 151, 0),
(26, 152, 0),
(26, 153, 0),
(26, 154, 0),
(26, 155, 0),
(26, 156, 0),
(26, 157, 0),
(26, 158, 0),
(26, 159, 0),
(26, 160, 0),
(26, 161, 0),
(26, 162, 0),
(26, 163, 0),
(26, 164, 0),
(27, 2, 0),
(27, 1, 0),
(27, 165, 0),
(27, 166, 0),
(27, 167, 0),
(27, 64, 0),
(27, 168, 0),
(27, 169, 0),
(27, 32, 0),
(27, 65, 0),
(27, 170, 0),
(27, 171, 0),
(28, 172, 0),
(28, 173, 0),
(28, 38, 0),
(28, 174, 0),
(28, 175, 0),
(28, 176, 0),
(28, 177, 0),
(28, 178, 0),
(28, 179, 0),
(28, 180, 0),
(29, 18, 0),
(29, 181, 0),
(29, 182, 0),
(29, 183, 0),
(29, 184, 0),
(29, 185, 0),
(29, 186, 0),
(29, 187, 0),
(29, 188, 0),
(29, 189, 0),
(29, 190, 0),
(29, 191, 0),
(29, 192, 0),
(29, 193, 0),
(29, 194, 0),
(29, 195, 0),
(29, 196, 0),
(30, 197, 0),
(30, 198, 0),
(30, 2, 0),
(30, 199, 0),
(30, 60, 0),
(30, 6, 0),
(30, 200, 0),
(30, 201, 0),
(30, 9, 0),
(30, 202, 0),
(30, 203, 0),
(30, 204, 0),
(31, 205, 0),
(31, 206, 0),
(31, 207, 0),
(31, 208, 0),
(31, 209, 0),
(31, 210, 0),
(31, 211, 0),
(31, 212, 0),
(31, 213, 0),
(32, 214, 0),
(32, 215, 0),
(32, 216, 0),
(32, 217, 0),
(32, 218, 0),
(32, 219, 0),
(33, 232, 0),
(32, 221, 0),
(32, 220, 0),
(32, 223, 0),
(33, 235, 0),
(33, 231, 0),
(33, 230, 0),
(32, 227, 0),
(33, 234, 0),
(33, 233, 0),
(33, 236, 0),
(33, 237, 0),
(33, 238, 0),
(33, 239, 0),
(33, 240, 0),
(34, 241, 0),
(34, 242, 0),
(34, 243, 0),
(34, 244, 0),
(34, 245, 0),
(34, 246, 0),
(34, 247, 0),
(34, 248, 0),
(34, 249, 0),
(34, 250, 0),
(34, 251, 0),
(35, 224, 0),
(35, 225, 0),
(35, 252, 0),
(35, 253, 0),
(35, 226, 0),
(35, 254, 0),
(35, 227, 0),
(35, 228, 0),
(35, 229, 0),
(35, 255, 0),
(36, 256, 0),
(36, 257, 0),
(36, 258, 0),
(36, 259, 0),
(36, 260, 0),
(36, 261, 0),
(36, 198, 0),
(36, 262, 0),
(36, 263, 0),
(37, 264, 0),
(37, 265, 0),
(37, 266, 0),
(37, 267, 0),
(37, 268, 0),
(37, 269, 0),
(37, 270, 0),
(38, 271, 0),
(38, 272, 0),
(38, 273, 0),
(38, 274, 0),
(38, 275, 0),
(38, 276, 0),
(38, 277, 0),
(38, 278, 0),
(38, 279, 0),
(38, 280, 0),
(39, 281, 0),
(39, 282, 0),
(39, 283, 0),
(39, 153, 0),
(39, 284, 0),
(39, 285, 0),
(40, 286, 0),
(40, 287, 0),
(40, 288, 0),
(40, 289, 0),
(40, 290, 0),
(40, 291, 0),
(40, 292, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%goods_tags`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%goods_tags` (
  `tag_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(100) DEFAULT NULL,
  `tag_code` varchar(100) NOT NULL DEFAULT '',
  `sort` smallint(5) NOT NULL DEFAULT '100',
  `is_hot` tinyint(1) NOT NULL,
  `count` int(11) NOT NULL,
  PRIMARY KEY (`tag_id`),
  UNIQUE KEY `tag_code` (`tag_code`),
  UNIQUE KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=293 ;

INSERT INTO `%DB_PREFIX%goods_tags` (`tag_id`, `tag_name`, `tag_code`, `sort`, `is_hot`, `count`) VALUES
(1, '欧美', '欧美', 100, 0, 0),
(2, '复古', '复古', 100, 0, 0),
(3, '海军', '海军', 100, 0, 0),
(4, '度假', '度假', 100, 0, 0),
(5, '日系', '日系', 100, 0, 0),
(6, '田园', '田园', 100, 0, 0),
(7, '清新', '清新', 100, 0, 0),
(8, '休闲', '休闲', 100, 0, 0),
(9, '波西米亚', '波西米亚', 100, 0, 0),
(10, 'T恤', 'T恤', 100, 0, 0),
(11, '背心', '背心', 100, 0, 0),
(12, '凉鞋', '凉鞋', 100, 0, 0),
(13, '拖鞋', '拖鞋', 100, 0, 0),
(14, '短裤', '短裤', 100, 0, 0),
(15, '半身裙', '半身裙', 100, 0, 0),
(16, '衬衫', '衬衫', 100, 0, 0),
(17, '连衣裙', '连衣裙', 100, 0, 0),
(18, '帽子', '帽子', 100, 0, 0),
(19, '坡跟鞋', '坡跟鞋', 100, 0, 0),
(20, '短袖', '短袖', 100, 0, 0),
(21, '连体裤', '连体裤', 100, 0, 0),
(22, '罩衫', '罩衫', 100, 0, 0),
(23, '帆布鞋', '帆布鞋', 100, 0, 0),
(24, '长裙', '长裙', 100, 0, 0),
(25, '罗马鞋', '罗马鞋', 100, 0, 0),
(26, '泳衣', '泳衣', 100, 0, 0),
(27, '单肩包', '单肩包', 100, 0, 0),
(28, '钱包', '钱包', 100, 0, 0),
(29, '防晒衣', '防晒衣', 100, 0, 0),
(30, '夏日美包', '夏日美包', 100, 0, 0),
(31, '七夕', '七夕', 100, 0, 0),
(32, '波点', '波点', 100, 0, 0),
(33, '显瘦', '显瘦', 100, 0, 0),
(34, '字母', '字母', 100, 0, 0),
(35, '雪纺', '雪纺', 100, 0, 0),
(36, '条纹', '条纹', 100, 0, 0),
(37, '厚底', '厚底', 100, 0, 0),
(38, '荧光色', '荧光色', 100, 0, 0),
(39, '露肩', '露肩', 100, 0, 0),
(40, '动物纹', '动物纹', 100, 0, 0),
(41, '印花', '印花', 100, 0, 0),
(42, '糖果色', '糖果色', 100, 0, 0),
(43, '蓝精灵', '蓝精灵', 100, 0, 0),
(44, 'lena同款', 'lena同款', 100, 0, 0),
(45, '星座', '星座', 100, 0, 0),
(46, '轻松熊', '轻松熊', 100, 0, 0),
(47, '城市猎人', '城市猎人', 100, 0, 0),
(48, '西瓜', '西瓜', 100, 0, 0),
(49, '街拍', '街拍', 100, 0, 0),
(50, '兔子', '兔子', 100, 0, 0),
(51, '大嘴猴', '大嘴猴', 100, 0, 0),
(52, '猫头鹰', '猫头鹰', 100, 0, 0),
(53, '徐濠萦', '徐濠萦', 100, 0, 0),
(54, '绯闻女孩', '绯闻女孩', 100, 0, 0),
(55, 'vivi同款', 'vivi同款', 100, 0, 0),
(56, 'hello kitty', 'hello kitty', 100, 0, 0),
(57, '防晒衫', '防晒衫', 100, 0, 0),
(58, '透视装', '透视装', 100, 0, 0),
(59, '雪纺衫', '雪纺衫', 100, 0, 0),
(60, '简约', '简约', 100, 0, 0),
(61, '卡通', '卡通', 100, 0, 0),
(62, 'BF风', 'BF风', 100, 0, 0),
(63, '撞色', '撞色', 100, 0, 0),
(64, '拼接', '拼接', 100, 0, 0),
(65, '蕾丝', '蕾丝', 100, 0, 0),
(66, '钩花', '钩花', 100, 0, 0),
(67, '军装', '军装', 100, 0, 0),
(68, '透视', '透视', 100, 0, 0),
(69, 'OL', 'OL', 100, 0, 0),
(70, '公主', '公主', 100, 0, 0),
(71, '森系', '森系', 100, 0, 0),
(72, '学院', '学院', 100, 0, 0),
(73, '中性', '中性', 100, 0, 0),
(74, '英伦', '英伦', 100, 0, 0),
(75, '娃娃衫', '娃娃衫', 100, 0, 0),
(76, 'T裙', 'T裙', 100, 0, 0),
(77, '马甲', '马甲', 100, 0, 0),
(78, '露肩T', '露肩T', 100, 0, 0),
(79, '短T', '短T', 100, 0, 0),
(80, '文胸', '文胸', 100, 0, 0),
(81, '小可爱', '小可爱', 100, 0, 0),
(82, '睡衣', '睡衣', 100, 0, 0),
(83, '家居服', '家居服', 100, 0, 0),
(84, '美体衣', '美体衣', 100, 0, 0),
(85, '碎花', '碎花', 100, 0, 0),
(86, '做旧', '做旧', 100, 0, 0),
(87, '卡其', '卡其', 100, 0, 0),
(88, '百搭', '百搭', 100, 0, 0),
(89, '破洞', '破洞', 100, 0, 0),
(90, '星条旗', '星条旗', 100, 0, 0),
(91, '运动裤', '运动裤', 100, 0, 0),
(92, '卡其裤', '卡其裤', 100, 0, 0),
(93, '迷你裙', '迷你裙', 100, 0, 0),
(94, '直筒裤', '直筒裤', 100, 0, 0),
(95, '纱裙', '纱裙', 100, 0, 0),
(96, '铅笔裤', '铅笔裤', 100, 0, 0),
(97, '休闲裤', '休闲裤', 100, 0, 0),
(98, '哈伦裤', '哈伦裤', 100, 0, 0),
(99, '蓬蓬裙', '蓬蓬裙', 100, 0, 0),
(100, '阔腿裤', '阔腿裤', 100, 0, 0),
(101, '牛仔裙', '牛仔裙', 100, 0, 0),
(102, '高腰', '高腰', 100, 0, 0),
(103, '垮裤', '垮裤', 100, 0, 0),
(104, '七分裤', '七分裤', 100, 0, 0),
(105, '九分裤', '九分裤', 100, 0, 0),
(106, '五分裤', '五分裤', 100, 0, 0),
(107, '背带裤', '背带裤', 100, 0, 0),
(108, '洞洞鞋', '洞洞鞋', 100, 0, 0),
(109, '靴子', '靴子', 100, 0, 0),
(110, '单鞋', '单鞋', 100, 0, 0),
(111, '娃娃鞋', '娃娃鞋', 100, 0, 0),
(112, '板鞋', '板鞋', 100, 0, 0),
(113, '果冻鞋', '果冻鞋', 100, 0, 0),
(114, '雨鞋', '雨鞋', 100, 0, 0),
(115, '家居鞋', '家居鞋', 100, 0, 0),
(116, '松糕鞋', '松糕鞋', 100, 0, 0),
(117, '摇摇鞋', '摇摇鞋', 100, 0, 0),
(118, '平底鞋', '平底鞋', 100, 0, 0),
(119, '人字拖', '人字拖', 100, 0, 0),
(120, '平跟', '平跟', 100, 0, 0),
(121, '高跟', '高跟', 100, 0, 0),
(122, '粗跟', '粗跟', 100, 0, 0),
(123, '坡跟', '坡跟', 100, 0, 0),
(124, '低帮', '低帮', 100, 0, 0),
(125, '高帮', '高帮', 100, 0, 0),
(126, '鱼嘴', '鱼嘴', 100, 0, 0),
(127, '圆头', '圆头', 100, 0, 0),
(128, '尖头', '尖头', 100, 0, 0),
(129, '防水台', '防水台', 100, 0, 0),
(130, '罗马', '罗马', 100, 0, 0),
(131, '裸色', '裸色', 100, 0, 0),
(132, '草编', '草编', 100, 0, 0),
(133, '木底', '木底', 100, 0, 0),
(134, '镂空', '镂空', 100, 0, 0),
(135, '豹纹', '豹纹', 100, 0, 0),
(136, '花朵', '花朵', 100, 0, 0),
(137, '复古英伦', '复古英伦', 100, 0, 0),
(138, '恋爱七夕', '恋爱七夕', 100, 0, 0),
(139, '匡威', '匡威', 100, 0, 0),
(140, 'adidas', 'adidas', 100, 0, 0),
(141, '小辣椒', '小辣椒', 100, 0, 0),
(142, '踏浪海滩', '踏浪海滩', 100, 0, 0),
(143, '糖果季', '糖果季', 100, 0, 0),
(144, '小清新', '小清新', 100, 0, 0),
(145, '布洛克', '布洛克', 100, 0, 0),
(146, 'Brogue', 'Brogue', 100, 0, 0),
(147, '旅行箱', '旅行箱', 100, 0, 0),
(148, '手提包', '手提包', 100, 0, 0),
(149, '斜挎包', '斜挎包', 100, 0, 0),
(150, '双肩包', '双肩包', 100, 0, 0),
(151, '手拿包', '手拿包', 100, 0, 0),
(152, '相机包', '相机包', 100, 0, 0),
(153, '卡包', '卡包', 100, 0, 0),
(154, '零钱包', '零钱包', 100, 0, 0),
(155, '托特包', '托特包', 100, 0, 0),
(156, '信封包', '信封包', 100, 0, 0),
(157, '邮差包', '邮差包', 100, 0, 0),
(158, '草编包', '草编包', 100, 0, 0),
(159, '链条包', '链条包', 100, 0, 0),
(160, '公文包', '公文包', 100, 0, 0),
(161, '环保袋', '环保袋', 100, 0, 0),
(162, '机车包', '机车包', 100, 0, 0),
(163, '水桶包', '水桶包', 100, 0, 0),
(164, '帆布包', '帆布包', 100, 0, 0),
(165, '通勤', '通勤', 100, 0, 0),
(166, '牛仔', '牛仔', 100, 0, 0),
(167, '漆皮', '漆皮', 100, 0, 0),
(168, '格纹', '格纹', 100, 0, 0),
(169, '菱格', '菱格', 100, 0, 0),
(170, '流苏', '流苏', 100, 0, 0),
(171, '铆钉', '铆钉', 100, 0, 0),
(172, '鳄鱼纹', '鳄鱼纹', 100, 0, 0),
(173, '创意包包', '创意包包', 100, 0, 0),
(174, '鸵鸟纹', '鸵鸟纹', 100, 0, 0),
(175, '购物袋', '购物袋', 100, 0, 0),
(176, '大牌同款', '大牌同款', 100, 0, 0),
(177, '迷你包包', '迷你包包', 100, 0, 0),
(178, '手机袋', '手机袋', 100, 0, 0),
(179, 'IT', 'IT', 100, 0, 0),
(180, 'Bag', 'Bag', 100, 0, 0),
(181, '鸭舌帽', '鸭舌帽', 100, 0, 0),
(182, '发饰', '发饰', 100, 0, 0),
(183, '丝巾', '丝巾', 100, 0, 0),
(184, '镜框', '镜框', 100, 0, 0),
(185, '项链', '项链', 100, 0, 0),
(186, '耳钉', '耳钉', 100, 0, 0),
(187, '胸针', '胸针', 100, 0, 0),
(188, '腰带', '腰带', 100, 0, 0),
(189, '手链', '手链', 100, 0, 0),
(190, '发带', '发带', 100, 0, 0),
(191, '手表', '手表', 100, 0, 0),
(192, '手镯 戒指', '手镯 戒指', 100, 0, 0),
(193, '吊坠', '吊坠', 100, 0, 0),
(194, '草帽', '草帽', 100, 0, 0),
(195, '墨镜', '墨镜', 100, 0, 0),
(196, '耳环', '耳环', 100, 0, 0),
(197, '蓝色幻想', '蓝色幻想', 100, 0, 0),
(198, 'Zakka', 'Zakka', 100, 0, 0),
(199, '手作', '手作', 100, 0, 0),
(200, '海洋', '海洋', 100, 0, 0),
(201, '卖萌', '卖萌', 100, 0, 0),
(202, 'ROCK', 'ROCK', 100, 0, 0),
(203, 'SWATCH', 'SWATCH', 100, 0, 0),
(204, '施华洛世奇', '施华洛世奇', 100, 0, 0),
(205, '奈良美智', '奈良美智', 100, 0, 0),
(206, '羽毛', '羽毛', 100, 0, 0),
(207, '陶饰', '陶饰', 100, 0, 0),
(208, '水晶', '水晶', 100, 0, 0),
(209, '珍珠', '珍珠', 100, 0, 0),
(210, '心心相印', '心心相印', 100, 0, 0),
(211, '编织', '编织', 100, 0, 0),
(212, '玫瑰金', '玫瑰金', 100, 0, 0),
(213, '天使之翼', '天使之翼', 100, 0, 0),
(214, '清洁', '清洁', 100, 0, 0),
(215, '爽肤水', '爽肤水', 100, 0, 0),
(216, '喷雾', '喷雾', 100, 0, 0),
(217, '精华素', '精华素', 100, 0, 0),
(218, '去角质', '去角质', 100, 0, 0),
(219, '唇膏', '唇膏', 100, 0, 0),
(220, '面膜', '面膜', 100, 0, 0),
(221, '乳霜', '乳霜', 100, 0, 0),
(222, '眼霜', '眼霜', 100, 0, 0),
(223, '眼唇膜', '眼唇膜', 100, 0, 0),
(224, '防晒', '防晒', 100, 0, 0),
(225, '隔离', '隔离', 100, 0, 0),
(226, '保湿', '保湿', 100, 0, 0),
(227, '美白', '美白', 100, 0, 0),
(228, '祛痘', '祛痘', 100, 0, 0),
(229, '控油', '控油', 100, 0, 0),
(230, '美甲', '美甲', 100, 0, 0),
(231, '香水', '香水', 100, 0, 0),
(232, '唇彩', '唇彩', 100, 0, 0),
(233, '腮红', '腮红', 100, 0, 0),
(234, '睫毛膏', '睫毛膏', 100, 0, 0),
(235, '眼影', '眼影', 100, 0, 0),
(236, '眼线', '眼线', 100, 0, 0),
(237, 'BB霜', 'BB霜', 100, 0, 0),
(238, '蜜粉', '蜜粉', 100, 0, 0),
(239, '粉底', '粉底', 100, 0, 0),
(240, '化妆刷', '化妆刷', 100, 0, 0),
(241, 'MAC', 'MAC', 100, 0, 0),
(242, '资生堂', '资生堂', 100, 0, 0),
(243, '嘉娜宝', '嘉娜宝', 100, 0, 0),
(244, 'KOSE', 'KOSE', 100, 0, 0),
(245, '贝玲妃', '贝玲妃', 100, 0, 0),
(246, '水宝宝', '水宝宝', 100, 0, 0),
(247, '倩碧', '倩碧', 100, 0, 0),
(248, '露得清', '露得清', 100, 0, 0),
(249, 'Kiehl''s', 'Kiehl''s', 100, 0, 0),
(250, '爱丽小屋', '爱丽小屋', 100, 0, 0),
(251, '雅漾', '雅漾', 100, 0, 0),
(252, '卸妆', '卸妆', 100, 0, 0),
(253, '手工皂', '手工皂', 100, 0, 0),
(254, '毛孔', '毛孔', 100, 0, 0),
(255, '药妆', '药妆', 100, 0, 0),
(256, '抱枕', '抱枕', 100, 0, 0),
(257, '玩偶', '玩偶', 100, 0, 0),
(258, '灯饰', '灯饰', 100, 0, 0),
(259, '摆件', '摆件', 100, 0, 0),
(260, '厨具', '厨具', 100, 0, 0),
(261, '餐具', '餐具', 100, 0, 0),
(262, '伞', '伞', 100, 0, 0),
(263, '闹钟', '闹钟', 100, 0, 0),
(264, '马克杯', '马克杯', 100, 0, 0),
(265, '杯具', '杯具', 100, 0, 0),
(266, '储蓄罐', '储蓄罐', 100, 0, 0),
(267, '铁盒', '铁盒', 100, 0, 0),
(268, '密封罐', '密封罐', 100, 0, 0),
(269, '保温杯', '保温杯', 100, 0, 0),
(270, '玻璃器皿', '玻璃器皿', 100, 0, 0),
(271, '创意礼品', '创意礼品', 100, 0, 0),
(272, '笔', '笔', 100, 0, 0),
(273, '笔记本', '笔记本', 100, 0, 0),
(274, '相册', '相册', 100, 0, 0),
(275, '明信片', '明信片', 100, 0, 0),
(276, '笔袋', '笔袋', 100, 0, 0),
(277, '钥匙扣', '钥匙扣', 100, 0, 0),
(278, '笔筒', '笔筒', 100, 0, 0),
(279, '贴纸', '贴纸&胶带', 100, 0, 0),
(280, '胶带', '胶带', 100, 0, 0),
(281, '纸巾盒', '纸巾盒', 100, 0, 0),
(282, '橱柜', '橱柜', 100, 0, 0),
(283, '收纳箱', '收纳箱', 100, 0, 0),
(284, '眼镜盒', '眼镜盒', 100, 0, 0),
(285, '首饰盒', '首饰盒', 100, 0, 0),
(286, '保护壳', '保护壳', 100, 0, 0),
(287, '相机', '相机', 100, 0, 0),
(288, '拍立得', '拍立得', 100, 0, 0),
(289, '電話', '電話', 100, 0, 0),
(290, 'LOMO', 'LOMO', 100, 0, 0),
(291, '耳机', '耳机', 100, 0, 0),
(292, '手机链', '手机链', 100, 0, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%ip_banned`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%ip_banned` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `ip1` smallint(3) NOT NULL DEFAULT '0',
  `ip2` smallint(3) NOT NULL DEFAULT '0',
  `ip3` smallint(3) NOT NULL DEFAULT '0',
  `ip4` smallint(3) NOT NULL DEFAULT '0',
  `admin` varchar(15) NOT NULL DEFAULT '',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `expiration` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%manage_log`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%manage_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rec_id` int(11) NOT NULL DEFAULT '0',
  `module` varchar(60) NOT NULL DEFAULT '',
  `action` varchar(60) NOT NULL DEFAULT '',
  `uid` int(11) NOT NULL DEFAULT '0',
  `user_name` varchar(60) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `create_time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%medal`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%medal` (
  `mid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT '',
  `image` varchar(255) DEFAULT '',
  `give_type` tinyint(1) DEFAULT NULL,
  `expiration` int(11) DEFAULT '0',
  `permission` text,
  `desc` text,
  `sort` smallint(5) DEFAULT '100',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%nav`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%nav` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `cid` smallint(6) NOT NULL DEFAULT '0',
  `url` varchar(255) NOT NULL DEFAULT '',
  `sort` smallint(5) NOT NULL DEFAULT '100',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `is_fix` tinyint(1) NOT NULL DEFAULT '0',
  `target` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=10 ;

INSERT INTO `%DB_PREFIX%nav` (`id`, `name`, `cid`, `url`, `sort`, `status`, `is_fix`, `target`) VALUES
(1, '申请达人贴子', 3, '/club.php?action=detail&tid=5', 100, 1, 1, 1),
(2, '购物分享', 4, '/book.php?action=shopping', 100, 1, 0, 0),
(3, '主题Club', 4, '/club.php?action=index', 100, 1, 0, 0),
(4, '达人秀', 4, '/daren.php?action=index', 100, 1, 0, 0),
(5, '招聘信息', 5, '/club.php?action=detail&tid=1', 100, 1, 0, 0),
(6, '联系我们', 5, '/club.php?action=detail&tid=2', 100, 1, 0, 0),
(7, '新手指南', 6, '/club.php?action=detail&tid=3', 100, 1, 0, 0),
(8, '意见簿', 6, '/club.php?action=detail&tid=4', 100, 1, 0, 0),
(9, '商家服务', 6, 'mailto:service@fanwe.com', 100, 1, 0, 1);

DROP TABLE IF EXISTS `%DB_PREFIX%nav_category`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%nav_category` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) NOT NULL DEFAULT '0',
  `name` varchar(60) NOT NULL DEFAULT '',
  `sort` smallint(5) NOT NULL DEFAULT '100',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `is_fix` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=7 ;

INSERT INTO `%DB_PREFIX%nav_category` (`id`, `parent_id`, `name`, `sort`, `status`, `is_fix`) VALUES
(1, 0, '主导航', 100, 1, 1),
(2, 0, '底部导航', 100, 1, 1),
(3, 0, '固定链接', 100, 1, 1),
(4, 2, '网站', 100, 1, 0),
(5, 2, '团队', 100, 1, 0),
(6, 2, '帮助', 100, 1, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%pub_schedule`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%pub_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `data` text NOT NULL,
  `pub_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%region`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%region` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `sort` smallint(5) NOT NULL DEFAULT '100',
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=574 ;

INSERT INTO `%DB_PREFIX%region` (`id`, `parent_id`, `name`, `sort`) VALUES
(1, 0, '北京', 100),
(2, 0, '上海', 100),
(3, 0, '重庆', 100),
(4, 0, '安徽', 100),
(5, 0, '福建', 100),
(6, 0, '甘肃', 100),
(7, 0, '广东', 100),
(8, 0, '广西', 100),
(9, 0, '贵州', 100),
(10, 0, '海南', 100),
(11, 0, '河北', 100),
(12, 0, '黑龙江', 100),
(13, 0, '河南', 100),
(14, 0, '香港', 100),
(15, 0, '湖北', 100),
(16, 0, '湖南', 100),
(17, 0, '江苏', 100),
(18, 0, '江西', 100),
(19, 0, '吉林', 100),
(20, 0, '辽宁', 100),
(21, 0, '澳门', 100),
(22, 0, '内蒙古', 100),
(23, 0, '宁夏', 100),
(24, 0, '青海', 100),
(25, 0, '山东', 100),
(26, 0, '山西', 100),
(27, 0, '陕西', 100),
(28, 0, '四川', 100),
(29, 0, '台湾', 100),
(30, 0, '天津', 100),
(31, 0, '新疆', 100),
(32, 0, '西藏', 100),
(33, 0, '云南', 100),
(34, 0, '浙江', 100),
(35, 0, '海外', 100),
(36, 1, '东城', 100),
(37, 1, '西城', 100),
(38, 1, '崇文', 100),
(39, 1, '宣武', 100),
(40, 1, '朝阳', 100),
(41, 1, '丰台', 100),
(42, 1, '石景山', 100),
(43, 1, '海淀', 100),
(44, 1, '门头沟', 100),
(45, 1, '房山', 100),
(46, 1, '通州', 100),
(47, 1, '顺义', 100),
(48, 1, '昌平', 100),
(49, 1, '大兴', 100),
(50, 1, '平谷', 100),
(51, 1, '怀柔', 100),
(52, 1, '密云', 100),
(53, 1, '延庆', 100),
(54, 2, '崇明', 100),
(55, 2, '黄浦', 100),
(56, 2, '卢湾', 100),
(57, 2, '徐汇', 100),
(58, 2, '长宁', 100),
(59, 2, '静安', 100),
(60, 2, '普陀', 100),
(61, 2, '闸北', 100),
(62, 2, '虹口', 100),
(63, 2, '杨浦', 100),
(64, 2, '闵行', 100),
(65, 2, '宝山', 100),
(66, 2, '嘉定', 100),
(67, 2, '浦东', 100),
(68, 2, '金山', 100),
(69, 2, '松江', 100),
(70, 2, '青浦', 100),
(71, 2, '南汇', 100),
(72, 2, '奉贤', 100),
(73, 3, '万州', 100),
(74, 3, '涪陵', 100),
(75, 3, '渝中', 100),
(76, 3, '大渡口', 100),
(77, 3, '江北', 100),
(78, 3, '沙坪坝', 100),
(79, 3, '九龙坡', 100),
(80, 3, '南岸', 100),
(81, 3, '北碚', 100),
(82, 3, '万盛', 100),
(83, 3, '双挢', 100),
(84, 3, '渝北', 100),
(85, 3, '巴南', 100),
(86, 3, '黔江', 100),
(87, 3, '长寿', 100),
(88, 3, '綦江', 100),
(89, 3, '潼南', 100),
(90, 3, '铜梁', 100),
(91, 3, '大足', 100),
(92, 3, '荣昌', 100),
(93, 3, '壁山', 100),
(94, 3, '梁平', 100),
(95, 3, '城口', 100),
(96, 3, '丰都', 100),
(97, 3, '垫江', 100),
(98, 3, '武隆', 100),
(99, 3, '忠县', 100),
(100, 3, '开县', 100),
(101, 3, '云阳', 100),
(102, 3, '奉节', 100),
(103, 3, '巫山', 100),
(104, 3, '巫溪', 100),
(105, 3, '石柱', 100),
(106, 3, '秀山', 100),
(107, 3, '酉阳', 100),
(108, 3, '彭水', 100),
(109, 3, '江津', 100),
(110, 3, '合川', 100),
(111, 3, '永川', 100),
(112, 3, '南川', 100),
(113, 4, '合肥', 100),
(114, 4, '安庆', 100),
(115, 4, '蚌埠', 100),
(116, 4, '亳州', 100),
(117, 4, '巢湖', 100),
(118, 4, '滁州', 100),
(119, 4, '阜阳', 100),
(120, 4, '贵池', 100),
(121, 4, '淮北', 100),
(122, 4, '淮化', 100),
(123, 4, '淮南', 100),
(124, 4, '黄山', 100),
(125, 4, '九华山', 100),
(126, 4, '六安', 100),
(127, 4, '马鞍山', 100),
(128, 4, '宿州', 100),
(129, 4, '铜陵', 100),
(130, 4, '屯溪', 100),
(131, 4, '芜湖', 100),
(132, 4, '宣城', 100),
(133, 5, '福州', 100),
(134, 5, '福安', 100),
(135, 5, '龙岩', 100),
(136, 5, '南平', 100),
(137, 5, '宁德', 100),
(138, 5, '莆田', 100),
(139, 5, '泉州', 100),
(140, 5, '三明', 100),
(141, 5, '邵武', 100),
(142, 5, '石狮', 100),
(143, 5, '永安', 100),
(144, 5, '武夷山', 100),
(145, 5, '厦门', 100),
(146, 5, '漳州', 100),
(147, 6, '兰州', 100),
(148, 6, '白银', 100),
(149, 6, '定西', 100),
(150, 6, '敦煌', 100),
(151, 6, '甘南', 100),
(152, 6, '金昌', 100),
(153, 6, '酒泉', 100),
(154, 6, '临夏', 100),
(155, 6, '平凉', 100),
(156, 6, '天水', 100),
(157, 6, '武都', 100),
(158, 6, '武威', 100),
(159, 6, '西峰', 100),
(160, 6, '张掖', 100),
(161, 7, '广州', 100),
(162, 7, '潮阳', 100),
(163, 7, '潮州', 100),
(164, 7, '澄海', 100),
(165, 7, '东莞', 100),
(166, 7, '佛山', 100),
(167, 7, '河源', 100),
(168, 7, '惠州', 100),
(169, 7, '江门', 100),
(170, 7, '揭阳', 100),
(171, 7, '开平', 100),
(172, 7, '茂名', 100),
(173, 7, '梅州', 100),
(174, 7, '清远', 100),
(175, 7, '汕头', 100),
(176, 7, '汕尾', 100),
(177, 7, '韶关', 100),
(178, 7, '深圳', 100),
(179, 7, '顺德', 100),
(180, 7, '阳江', 100),
(181, 7, '英德', 100),
(182, 7, '云浮', 100),
(183, 7, '增城', 100),
(184, 7, '湛江', 100),
(185, 7, '肇庆', 100),
(186, 7, '中山', 100),
(187, 7, '珠海', 100),
(188, 8, '南宁', 100),
(189, 8, '百色', 100),
(190, 8, '北海', 100),
(191, 8, '桂林', 100),
(192, 8, '防城港', 100),
(193, 8, '河池', 100),
(194, 8, '贺州', 100),
(195, 8, '柳州', 100),
(196, 8, '钦州', 100),
(197, 8, '梧州', 100),
(198, 8, '玉林', 100),
(199, 9, '贵阳', 100),
(200, 9, '安顺', 100),
(201, 9, '毕节', 100),
(202, 9, '都匀', 100),
(203, 9, '凯里', 100),
(204, 9, '六盘水', 100),
(205, 9, '铜仁', 100),
(206, 9, '兴义', 100),
(207, 9, '玉屏', 100),
(208, 9, '遵义', 100),
(209, 10, '海口', 100),
(210, 10, '儋县', 100),
(211, 10, '陵水', 100),
(212, 10, '琼海', 100),
(213, 10, '三亚', 100),
(214, 10, '通什', 100),
(215, 10, '万宁', 100),
(216, 11, '石家庄', 100),
(217, 11, '保定', 100),
(218, 11, '北戴河', 100),
(219, 11, '沧州', 100),
(220, 11, '承德', 100),
(221, 11, '丰润', 100),
(222, 11, '邯郸', 100),
(223, 11, '衡水', 100),
(224, 11, '廊坊', 100),
(225, 11, '南戴河', 100),
(226, 11, '秦皇岛', 100),
(227, 11, '唐山', 100),
(228, 11, '新城', 100),
(229, 11, '邢台', 100),
(230, 11, '张家口', 100),
(231, 12, '哈尔滨', 100),
(232, 12, '北安', 100),
(233, 12, '大庆', 100),
(234, 12, '大兴安岭', 100),
(235, 12, '鹤岗', 100),
(236, 12, '黑河', 100),
(237, 12, '佳木斯', 100),
(238, 12, '鸡西', 100),
(239, 12, '牡丹江', 100),
(240, 12, '齐齐哈尔', 100),
(241, 12, '七台河', 100),
(242, 12, '双鸭山', 100),
(243, 12, '绥化', 100),
(244, 12, '伊春', 100),
(245, 13, '郑州', 100),
(246, 13, '安阳', 100),
(247, 13, '鹤壁', 100),
(248, 13, '潢川', 100),
(249, 13, '焦作', 100),
(250, 13, '济源', 100),
(251, 13, '开封', 100),
(252, 13, '漯河', 100),
(253, 13, '洛阳', 100),
(254, 13, '南阳', 100),
(255, 13, '平顶山', 100),
(256, 13, '濮阳', 100),
(257, 13, '三门峡', 100),
(258, 13, '商丘', 100),
(259, 13, '新乡', 100),
(260, 13, '信阳', 100),
(261, 13, '许昌', 100),
(262, 13, '周口', 100),
(263, 13, '驻马店', 100),
(264, 14, '香港', 100),
(265, 14, '九龙', 100),
(266, 14, '新界', 100),
(267, 15, '武汉', 100),
(268, 15, '恩施', 100),
(269, 15, '鄂州', 100),
(270, 15, '黄冈', 100),
(271, 15, '黄石', 100),
(272, 15, '荆门', 100),
(273, 15, '荆州', 100),
(274, 15, '潜江', 100),
(275, 15, '十堰', 100),
(276, 15, '随州', 100),
(277, 15, '武穴', 100),
(278, 15, '仙桃', 100),
(279, 15, '咸宁', 100),
(280, 15, '襄阳', 100),
(281, 15, '襄樊', 100),
(282, 15, '孝感', 100),
(283, 15, '宜昌', 100),
(284, 16, '长沙', 100),
(285, 16, '常德', 100),
(286, 16, '郴州', 100),
(287, 16, '衡阳', 100),
(288, 16, '怀化', 100),
(289, 16, '吉首', 100),
(290, 16, '娄底', 100),
(291, 16, '邵阳', 100),
(292, 16, '湘潭', 100),
(293, 16, '益阳', 100),
(294, 16, '岳阳', 100),
(295, 16, '永州', 100),
(296, 16, '张家界', 100),
(297, 16, '株洲', 100),
(298, 17, '南京', 100),
(299, 17, '常熟', 100),
(300, 17, '常州', 100),
(301, 17, '海门', 100),
(302, 17, '淮安', 100),
(303, 17, '江都', 100),
(304, 17, '江阴', 100),
(305, 17, '昆山', 100),
(306, 17, '连云港', 100),
(307, 17, '南通', 100),
(308, 17, '启东', 100),
(309, 17, '沭阳', 100),
(310, 17, '宿迁', 100),
(311, 17, '苏州', 100),
(312, 17, '太仓', 100),
(313, 17, '泰州', 100),
(314, 17, '同里', 100),
(315, 17, '无锡', 100),
(316, 17, '徐州', 100),
(317, 17, '盐城', 100),
(318, 17, '扬州', 100),
(319, 17, '宜兴', 100),
(320, 17, '仪征', 100),
(321, 17, '张家港', 100),
(322, 17, '镇江', 100),
(323, 17, '周庄', 100),
(324, 18, '南昌', 100),
(325, 18, '抚州', 100),
(326, 18, '赣州', 100),
(327, 18, '吉安', 100),
(328, 18, '景德镇', 100),
(329, 18, '井冈山', 100),
(330, 18, '九江', 100),
(331, 18, '庐山', 100),
(332, 18, '萍乡', 100),
(333, 18, '上饶', 100),
(334, 18, '新余', 100),
(335, 18, '宜春', 100),
(336, 18, '鹰潭', 100),
(337, 19, '长春', 100),
(338, 19, '白城', 100),
(339, 19, '白山', 100),
(340, 19, '珲春', 100),
(341, 19, '辽源', 100),
(342, 19, '梅河', 100),
(343, 19, '吉林', 100),
(344, 19, '四平', 100),
(345, 19, '松原', 100),
(346, 19, '通化', 100),
(347, 19, '延吉', 100),
(348, 20, '沈阳', 100),
(349, 20, '鞍山', 100),
(350, 20, '本溪', 100),
(351, 20, '朝阳', 100),
(352, 20, '大连', 100),
(353, 20, '丹东', 100),
(354, 20, '抚顺', 100),
(355, 20, '阜新', 100),
(356, 20, '葫芦岛', 100),
(357, 20, '锦州', 100),
(358, 20, '辽阳', 100),
(359, 20, '盘锦', 100),
(360, 20, '铁岭', 100),
(361, 20, '营口', 100),
(362, 21, '澳门', 100),
(363, 22, '呼和浩特', 100),
(364, 22, '阿拉善盟', 100),
(365, 22, '包头', 100),
(366, 22, '赤峰', 100),
(367, 22, '东胜', 100),
(368, 22, '海拉尔', 100),
(369, 22, '集宁', 100),
(370, 22, '临河', 100),
(371, 22, '通辽', 100),
(372, 22, '乌海', 100),
(373, 22, '乌兰浩特', 100),
(374, 22, '锡林浩特', 100),
(375, 23, '银川', 100),
(376, 23, '固源', 100),
(377, 23, '石嘴山', 100),
(378, 23, '吴忠', 100),
(379, 24, '西宁', 100),
(380, 24, '德令哈', 100),
(381, 24, '格尔木', 100),
(382, 24, '共和', 100),
(383, 24, '海东', 100),
(384, 24, '海晏', 100),
(385, 24, '玛沁', 100),
(386, 24, '同仁', 100),
(387, 24, '玉树', 100),
(388, 25, '济南', 100),
(389, 25, '滨州', 100),
(390, 25, '兖州', 100),
(391, 25, '德州', 100),
(392, 25, '东营', 100),
(393, 25, '菏泽', 100),
(394, 25, '济宁', 100),
(395, 25, '莱芜', 100),
(396, 25, '聊城', 100),
(397, 25, '临沂', 100),
(398, 25, '蓬莱', 100),
(399, 25, '青岛', 100),
(400, 25, '曲阜', 100),
(401, 25, '日照', 100),
(402, 25, '泰安', 100),
(403, 25, '潍坊', 100),
(404, 25, '威海', 100),
(405, 25, '烟台', 100),
(406, 25, '枣庄', 100),
(407, 25, '淄博', 100),
(408, 26, '太原', 100),
(409, 26, '长治', 100),
(410, 26, '大同', 100),
(411, 26, '候马', 100),
(412, 26, '晋城', 100),
(413, 26, '离石', 100),
(414, 26, '临汾', 100),
(415, 26, '宁武', 100),
(416, 26, '朔州', 100),
(417, 26, '忻州', 100),
(418, 26, '阳泉', 100),
(419, 26, '榆次', 100),
(420, 26, '运城', 100),
(421, 27, '西安', 100),
(422, 27, '安康', 100),
(423, 27, '宝鸡', 100),
(424, 27, '汉中', 100),
(425, 27, '渭南', 100),
(426, 27, '商州', 100),
(427, 27, '绥德', 100),
(428, 27, '铜川', 100),
(429, 27, '咸阳', 100),
(430, 27, '延安', 100),
(431, 27, '榆林', 100),
(432, 28, '成都', 100),
(433, 28, '巴中', 100),
(434, 28, '达川', 100),
(435, 28, '德阳', 100),
(436, 28, '都江堰', 100),
(437, 28, '峨眉山', 100),
(438, 28, '涪陵', 100),
(439, 28, '广安', 100),
(440, 28, '广元', 100),
(441, 28, '九寨沟', 100),
(442, 28, '康定', 100),
(443, 28, '乐山', 100),
(444, 28, '泸州', 100),
(445, 28, '马尔康', 100),
(446, 28, '绵阳', 100),
(447, 28, '眉山', 100),
(448, 28, '南充', 100),
(449, 28, '内江', 100),
(450, 28, '攀枝花', 100),
(451, 28, '遂宁', 100),
(452, 28, '汶川', 100),
(453, 28, '西昌', 100),
(454, 28, '雅安', 100),
(455, 28, '宜宾', 100),
(456, 28, '自贡', 100),
(457, 28, '资阳', 100),
(458, 29, '台北', 100),
(459, 29, '基隆', 100),
(460, 29, '台南', 100),
(461, 29, '台中', 100),
(462, 29, '高雄', 100),
(463, 29, '屏东', 100),
(464, 29, '南投', 100),
(465, 29, '云林', 100),
(466, 29, '新竹', 100),
(467, 29, '彰化', 100),
(468, 29, '苗栗', 100),
(469, 29, '嘉义', 100),
(470, 29, '花莲', 100),
(471, 29, '桃园', 100),
(472, 29, '宜兰', 100),
(473, 29, '台东', 100),
(474, 29, '金门', 100),
(475, 29, '马祖', 100),
(476, 29, '澎湖', 100),
(477, 30, '天津', 100),
(478, 30, '和平', 100),
(479, 30, '东丽', 100),
(480, 30, '河东', 100),
(481, 30, '西青', 100),
(482, 30, '河西', 100),
(483, 30, '津南', 100),
(484, 30, '南开', 100),
(485, 30, '北辰', 100),
(486, 30, '河北', 100),
(487, 30, '武清', 100),
(488, 30, '红挢', 100),
(489, 30, '塘沽', 100),
(490, 30, '汉沽', 100),
(491, 30, '大港', 100),
(492, 30, '宁河', 100),
(493, 30, '静海', 100),
(494, 30, '宝坻', 100),
(495, 30, '蓟县', 100),
(496, 31, '乌鲁木齐', 100),
(497, 31, '阿克苏', 100),
(498, 31, '阿勒泰', 100),
(499, 31, '阿图什', 100),
(500, 31, '博乐', 100),
(501, 31, '昌吉', 100),
(502, 31, '东山', 100),
(503, 31, '哈密', 100),
(504, 31, '和田', 100),
(505, 31, '喀什', 100),
(506, 31, '克拉玛依', 100),
(507, 31, '库车', 100),
(508, 31, '库尔勒', 100),
(509, 31, '奎屯', 100),
(510, 31, '石河子', 100),
(511, 31, '塔城', 100),
(512, 31, '吐鲁番', 100),
(513, 31, '伊宁', 100),
(514, 32, '拉萨', 100),
(515, 32, '阿里', 100),
(516, 32, '昌都', 100),
(517, 32, '林芝', 100),
(518, 32, '那曲', 100),
(519, 32, '日喀则', 100),
(520, 32, '山南', 100),
(521, 33, '昆明', 100),
(522, 33, '大理', 100),
(523, 33, '保山', 100),
(524, 33, '楚雄', 100),
(525, 33, '东川', 100),
(526, 33, '个旧', 100),
(527, 33, '景洪', 100),
(528, 33, '开远', 100),
(529, 33, '临沧', 100),
(530, 33, '丽江', 100),
(531, 33, '六库', 100),
(532, 33, '潞西', 100),
(533, 33, '曲靖', 100),
(534, 33, '思茅', 100),
(535, 33, '文山', 100),
(536, 33, '西双版纳', 100),
(537, 33, '玉溪', 100),
(538, 33, '中甸', 100),
(539, 33, '昭通', 100),
(540, 34, '杭州', 100),
(541, 34, '安吉', 100),
(542, 34, '慈溪', 100),
(543, 34, '定海', 100),
(544, 34, '奉化', 100),
(545, 34, '海盐', 100),
(546, 34, '黄岩', 100),
(547, 34, '湖州', 100),
(548, 34, '嘉兴', 100),
(549, 34, '金华', 100),
(550, 34, '临安', 100),
(551, 34, '临海', 100),
(552, 34, '丽水', 100),
(553, 34, '宁波', 100),
(554, 34, '瓯海', 100),
(555, 34, '平湖', 100),
(556, 34, '千岛湖', 100),
(557, 34, '衢州', 100),
(558, 34, '江山', 100),
(559, 34, '瑞安', 100),
(560, 34, '绍兴', 100),
(561, 34, '嵊州', 100),
(562, 34, '台州', 100),
(563, 34, '温岭', 100),
(564, 34, '温州', 100),
(565, 34, '余姚', 100),
(566, 34, '舟山', 100),
(567, 35, '欧洲', 100),
(568, 35, '北美', 100),
(569, 35, '南美', 100),
(570, 35, '亚洲', 100),
(571, 35, '非洲', 100),
(572, 35, '大洋洲', 100),
(573, 0, '测试', 100);

DROP TABLE IF EXISTS `%DB_PREFIX%role`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `%DB_PREFIX%role` (`id`, `name`, `status`) VALUES
(1, '超级管理员', 1);

DROP TABLE IF EXISTS `%DB_PREFIX%role_access`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%role_access` (
  `role_id` smallint(6) unsigned NOT NULL,
  `node_id` smallint(6) unsigned NOT NULL,
  KEY `role_id` (`role_id`),
  KEY `node_id` (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%role_access` (`role_id`, `node_id`) VALUES
(1, 174),
(1, 167),
(1, 160),
(1, 153),
(1, 149),
(1, 143),
(1, 137),
(1, 131),
(1, 124),
(1, 118),
(1, 111),
(1, 105),
(1, 98),
(1, 92),
(1, 83),
(1, 76),
(1, 69),
(1, 61),
(1, 58),
(1, 57),
(1, 56),
(1, 55),
(1, 47),
(1, 40),
(1, 33),
(1, 26),
(1, 24),
(1, 22),
(1, 15),
(1, 12),
(1, 9),
(1, 6),
(1, 3);

DROP TABLE IF EXISTS `%DB_PREFIX%role_nav`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%role_nav` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `sort` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT INTO `%DB_PREFIX%role_nav` (`id`, `name`, `status`, `sort`) VALUES
(2, '分享', 1, 2),
(3, '主题', 1, 3),
(4, '会员', 1, 4),
(5, '权限', 1, 5),
(6, '数据库', 1, 6),
(7, '系统', 1, 7),
(8, '前台', 1, 6);

DROP TABLE IF EXISTS `%DB_PREFIX%role_node`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%role_node` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `action` varchar(60) NOT NULL DEFAULT '',
  `action_name` varchar(60) NOT NULL DEFAULT '',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `module` varchar(60) NOT NULL DEFAULT '',
  `module_name` varchar(60) NOT NULL DEFAULT '',
  `nav_id` mediumint(8) NOT NULL DEFAULT '0' COMMENT '从属于哪个模块组, 为0时表示不属于菜单节点',
  `sort` smallint(5) NOT NULL DEFAULT '0',
  `auth_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '授权模式：1:模块授权(module) 2:操作授权(action) 0:节点授权(node)',
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=162 ;

INSERT INTO `%DB_PREFIX%role_node` (`id`, `action`, `action_name`, `status`, `module`, `module_name`, `nav_id`, `sort`, `auth_type`, `is_show`) VALUES
(1, '', '', 1, 'SysConf', '系统管理', 7, 10, 1, 0),
(2, 'index', '系统设置', 1, 'SysConf', '系统管理', 7, 10, 0, 1),
(3, 'update', '更新设置', 1, 'SysConf', '系统管理', 7, 10, 0, 0),
(4, '', '', 1, 'Cache', '缓存管理', 7, 10, 1, 0),
(5, 'system', '清除系统缓存', 1, 'Cache', '缓存管理', 7, 10, 0, 1),
(6, 'custom', '清除程序缓存', 1, 'Cache', '缓存管理', 7, 10, 0, 1),
(7, '', '', 1, 'TempFile', '临时文件管理', 7, 10, 1, 0),
(8, 'index', '临时文件列表', 1, 'TempFile', '临时文件管理', 7, 10, 0, 1),
(9, 'clear', '清除临时文件', 1, 'TempFile', '临时文件管理', 7, 10, 0, 0),
(10, '', '', 1, 'AdminLog', '操作日志管理', 7, 10, 1, 0),
(11, 'index', '操作日志列表', 1, 'AdminLog', '操作日志管理', 7, 10, 0, 1),
(12, 'remove', '删除操作日志', 1, 'AdminLog', '操作日志管理', 7, 10, 0, 0),
(13, '', '', 1, 'Region', '城市管理', 7, 10, 1, 0),
(14, 'index', '城市列表', 1, 'Region', '城市管理', 7, 10, 0, 1),
(15, 'add', '添加城市', 1, 'Region', '城市管理', 7, 10, 0, 1),
(16, 'update', '更新城市', 1, 'Region', '城市管理', 7, 10, 0, 0),
(17, 'remove', '删除城市', 1, 'Region', '城市管理', 7, 10, 0, 0),
(18, 'editfield', '修改城市字段', 1, 'Region', '城市管理', 7, 10, 0, 0),
(19, 'togglestatus', '切换城市状态', 1, 'Region', '城市管理', 7, 10, 0, 0),
(20, '', '', 1, 'DataBase', '数据库操作', 6, 10, 1, 0),
(21, 'index', '数据库备份', 1, 'DataBase', '数据库操作', 6, 10, 0, 1),
(22, 'dump', '备份操作', 1, 'DataBase', '数据库操作', 6, 10, 0, 0),
(23, 'delete', '删除操作', 1, 'DataBase', '数据库操作', 6, 10, 0, 0),
(24, 'restore', '恢复操作', 1, 'DataBase', '数据库操作', 6, 10, 0, 0),
(25, '', '', 1, 'Sql', 'SQL操作', 6, 10, 1, 0),
(26, 'index', 'SQL操作', 1, 'Sql', 'SQL操作', 6, 10, 0, 1),
(27, 'execute', '执行SQL', 1, 'Sql', 'SQL操作', 6, 10, 0, 0),
(28, '', '', 1, 'Admin', '管理员管理', 5, 10, 1, 0),
(29, 'index', '管理员列表', 1, 'Admin', '管理员管理', 5, 10, 0, 1),
(30, 'add', '添加管理员', 1, 'Admin', '管理员管理', 5, 10, 0, 1),
(31, 'update', '更新管理员', 1, 'Admin', '管理员管理', 5, 10, 0, 0),
(32, 'remove', '删除管理员', 1, 'Admin', '管理员管理', 5, 10, 0, 0),
(33, 'editfield', '修改管理员字段', 1, 'Admin', '管理员管理', 5, 10, 0, 0),
(34, 'togglestatus', '切换管理员状态', 1, 'Admin', '管理员管理', 5, 10, 0, 0),
(35, '', '', 1, 'Role', '权限组管理', 5, 10, 1, 0),
(36, 'index', '角色列表', 1, 'Role', '权限组管理', 5, 10, 0, 1),
(37, 'add', '添加角色', 1, 'Role', '权限组管理', 5, 10, 0, 1),
(38, 'update', '更新角色', 1, 'Role', '权限组管理', 5, 10, 0, 0),
(39, 'remove', '删除角色', 1, 'Role', '权限组管理', 5, 10, 0, 0),
(40, 'editfield', '修改角色字段', 1, 'Role', '权限组管理', 5, 10, 0, 0),
(41, 'togglestatus', '切换角色状态', 1, 'Role', '权限组管理', 5, 10, 0, 0),
(42, '', '', 1, 'RoleNode', '权限节点管理', 5, 10, 1, 0),
(43, 'index', '节点列表', 1, 'RoleNode', '权限节点管理', 5, 10, 0, 1),
(44, 'add', '添加节点', 1, 'RoleNode', '权限节点管理', 5, 10, 0, 1),
(45, 'update', '更新节点', 1, 'RoleNode', '权限节点管理', 5, 10, 0, 0),
(46, 'remove', '删除节点', 1, 'RoleNode', '权限节点管理', 5, 10, 0, 0),
(47, 'editfield', '修改节点字段', 1, 'RoleNode', '权限节点管理', 5, 10, 0, 0),
(48, 'togglestatus', '切换节点状态', 1, 'RoleNode', '权限节点管理', 5, 10, 0, 0),
(49, '', '', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 1, 0),
(50, 'index', '菜单列表', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 0, 1),
(51, 'add', '添加菜单', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 0, 1),
(52, 'update', '更新菜单', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 0, 0),
(53, 'remove', '删除菜单', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 0, 0),
(54, 'editfield', '修改菜单字段', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 0, 0),
(55, 'togglestatus', '切换菜单状态', 1, 'RoleNav', '后台导航菜单管理', 5, 10, 0, 0),
(56, '', '', 1, 'User', '会员管理', 4, 10, 1, 0),
(57, 'index', '会员列表', 1, 'User', '会员管理', 4, 10, 0, 1),
(58, 'add', '添加会员', 1, 'User', '会员管理', 4, 10, 0, 1),
(59, 'update', '更新会员', 1, 'User', '会员管理', 4, 10, 0, 0),
(60, 'remove', '删除会员', 1, 'User', '会员管理', 4, 10, 0, 0),
(61, 'editfield', '修改会员字段', 1, 'User', '会员管理', 4, 10, 0, 0),
(62, 'togglestatus', '切换会员状态', 1, 'User', '会员管理', 4, 10, 0, 0),
(63, '', '', 1, 'UserDaren', '达人管理', 4, 10, 1, 0),
(64, 'index', '达人列表', 1, 'UserDaren', '达人管理', 4, 10, 0, 1),
(65, 'add', '添加达人', 1, 'UserDaren', '达人管理', 4, 10, 0, 1),
(66, 'update', '更新达人', 1, 'UserDaren', '达人管理', 4, 10, 0, 0),
(67, 'remove', '删除达人', 1, 'UserDaren', '达人管理', 4, 10, 0, 0),
(68, 'editfield', '修改达人字段', 1, 'UserDaren', '达人管理', 4, 10, 0, 0),
(69, 'togglestatus', '切换达人状态', 1, 'UserDaren', '达人管理', 4, 10, 0, 0),
(70, '', '', 1, 'UserGroup', '会员组管理', 4, 10, 1, 0),
(71, 'index', '会员组列表', 1, 'UserGroup', '会员组管理', 4, 10, 0, 1),
(72, 'add', '添加会员组', 1, 'UserGroup', '会员组管理', 4, 10, 0, 1),
(73, 'update', '更新会员组', 1, 'UserGroup', '会员组管理', 4, 10, 0, 0),
(74, 'remove', '删除会员组', 1, 'UserGroup', '会员组管理', 4, 10, 0, 0),
(75, 'editfield', '修改会员组字段', 1, 'UserGroup', '会员组管理', 4, 10, 0, 0),
(76, 'togglestatus', '切换会员组状态', 1, 'UserGroup', '会员组管理', 4, 10, 0, 0),
(77, '', '', 1, 'Forum', '论坛分类管理', 3, 10, 1, 0),
(78, 'index', '分类列表', 1, 'Forum', '论坛分类管理', 3, 10, 0, 1),
(79, 'add', '添加分类', 1, 'Forum', '论坛分类管理', 3, 10, 0, 1),
(80, 'update', '更新分类', 1, 'Forum', '论坛分类管理', 3, 10, 0, 0),
(81, 'remove', '删除分类', 1, 'Forum', '论坛分类管理', 3, 10, 0, 0),
(82, 'editfield', '修改分类字段', 1, 'Forum', '论坛分类管理', 3, 10, 0, 0),
(83, 'togglestatus', '切换分类状态', 1, 'Forum', '论坛分类管理', 3, 10, 0, 0),
(84, '', '', 1, 'ForumThread', '论坛主题管理', 3, 10, 1, 0),
(85, 'index', '主题列表', 1, 'ForumThread', '论坛主题管理', 3, 10, 0, 1),
(86, 'update', '更新主题', 1, 'ForumThread', '论坛主题管理', 3, 10, 0, 0),
(87, 'remove', '删除主题', 1, 'ForumThread', '论坛主题管理', 3, 10, 0, 0),
(88, 'editfield', '修改主题字段', 1, 'ForumThread', '论坛主题管理', 3, 10, 0, 0),
(89, 'togglestatus', '切换主题状态', 1, 'ForumThread', '论坛主题管理', 3, 10, 0, 0),
(90, '', '', 1, 'Ask', '问答分类管理', 3, 10, 1, 0),
(91, 'index', '分类列表', 1, 'Ask', '问答分类管理', 3, 10, 0, 1),
(92, 'add', '添加分类', 1, 'Ask', '问答分类管理', 3, 10, 0, 1),
(93, 'update', '更新分类', 1, 'Ask', '问答分类管理', 3, 10, 0, 0),
(94, 'remove', '删除分类', 1, 'Ask', '问答分类管理', 3, 10, 0, 0),
(95, 'editfield', '修改分类字段', 1, 'Ask', '问答分类管理', 3, 10, 0, 0),
(96, 'togglestatus', '切换分类状态', 1, 'Ask', '问答分类管理', 3, 10, 0, 0),
(97, '', '', 1, 'AskThread', '问答主题管理', 3, 10, 1, 0),
(98, 'index', '主题列表', 1, 'AskThread', '问答主题管理', 3, 10, 0, 1),
(99, 'update', '更新主题', 1, 'AskThread', '问答主题管理', 3, 10, 0, 0),
(100, 'remove', '删除主题', 1, 'AskThread', '问答主题管理', 3, 10, 0, 0),
(101, 'editfield', '修改主题字段', 1, 'AskThread', '问答主题管理', 3, 10, 0, 0),
(102, 'togglestatus', '切换主题状态', 1, 'AskThread', '问答主题管理', 3, 10, 0, 0),
(103, '', '', 1, 'Share', '分享管理', 2, 10, 1, 0),
(104, 'index', '分享列表', 1, 'Share', '分享管理', 2, 10, 0, 1),
(105, 'update', '更新分享', 1, 'Share', '分享管理', 2, 10, 0, 0),
(106, 'remove', '删除分享', 1, 'Share', '分享管理', 2, 10, 0, 0),
(107, 'editfield', '修改分享字段', 1, 'Share', '分享管理', 2, 10, 0, 0),
(108, 'togglestatus', '切换分享状态', 1, 'Share', '分享管理', 2, 10, 0, 0),
(109, '', '', 1, 'GoodsCategory', '分享分类管理', 2, 10, 1, 0),
(110, 'index', '分类列表', 1, 'GoodsCategory', '分享分类管理', 2, 10, 0, 1),
(111, 'add', '添加分类', 1, 'GoodsCategory', '分享分类管理', 2, 10, 0, 1),
(112, 'update', '更新分类', 1, 'GoodsCategory', '分享分类管理', 2, 10, 0, 0),
(113, 'remove', '删除分类', 1, 'GoodsCategory', '分享分类管理', 2, 10, 0, 0),
(114, 'editfield', '修改分类字段', 1, 'GoodsCategory', '分享分类管理', 2, 10, 0, 0),
(115, 'togglestatus', '切换分类状态', 1, 'GoodsCategory', '分享分类管理', 2, 10, 0, 0),
(116, '', '', 1, 'GoodsCategoryTags', '分享分类关联标签管理', 2, 10, 1, 0),
(117, 'index', '标签列表', 1, 'GoodsCategoryTags', '分享分类关联标签管理', 2, 10, 0, 0),
(118, 'setting', '设置标签', 1, 'GoodsCategoryTags', '分享分类关联标签管理', 2, 10, 0, 0),
(119, 'remove', '删除分类', 1, 'GoodsCategoryTags', '分享分类关联标签管理', 2, 10, 0, 0),
(120, 'togglestatus', '切换分类状态', 1, 'GoodsCategoryTags', '分享分类关联标签管理', 2, 10, 0, 0),
(121, '', '', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 1, 0),
(122, 'index', '标签列表', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 0, 1),
(123, 'add', '添加标签', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 0, 1),
(124, 'update', '更新标签', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 0, 0),
(125, 'remove', '删除标签', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 0, 0),
(126, 'editfield', '修改标签字段', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 0, 0),
(127, 'togglestatus', '切换标签状态', 1, 'GoodsTags', '分享分类标签管理', 2, 10, 0, 0),
(128, '', '', 1, 'ShopCategory', '店铺分类管理', 2, 10, 1, 0),
(129, 'index', '分类列表', 1, 'ShopCategory', '店铺分类管理', 2, 10, 0, 1),
(130, 'add', '添加分类', 1, 'ShopCategory', '店铺分类管理', 2, 10, 0, 1),
(131, 'update', '更新分类', 1, 'ShopCategory', '店铺分类管理', 2, 10, 0, 0),
(132, 'remove', '删除分类', 1, 'ShopCategory', '店铺分类管理', 2, 10, 0, 0),
(133, 'editfield', '修改分类字段', 1, 'ShopCategory', '店铺分类管理', 2, 10, 0, 0),
(134, 'togglestatus', '切换分类状态', 1, 'ShopCategory', '店铺分类管理', 2, 10, 0, 0),
(135, '', '', 1, 'Shop', '店铺管理', 2, 10, 1, 0),
(136, 'index', '店铺列表', 1, 'Shop', '店铺管理', 2, 10, 0, 1),
(137, 'update', '更新店铺', 1, 'Shop', '店铺管理', 2, 10, 0, 0),
(138, 'remove', '删除店铺', 1, 'Shop', '店铺管理', 2, 10, 0, 0),
(139, 'editfield', '修改店铺字段', 1, 'Shop', '店铺管理', 2, 10, 0, 0),
(140, 'togglestatus', '切换店铺状态', 1, 'Shop', '店铺管理', 2, 10, 0, 0),
(141, '', '', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 1, 0),
(142, 'index', '分类列表', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 0, 1),
(143, 'add', '添加分类', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 0, 1),
(144, 'update', '更新分类', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 0, 0),
(145, 'remove', '删除分类', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 0, 0),
(146, 'editfield', '修改分类字段', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 0, 0),
(147, 'togglestatus', '切换分类状态', 1, 'NavCategory', '前台菜单分类管理', 8, 10, 0, 0),
(148, '', '', 1, 'Nav', '前台菜单管理', 8, 10, 1, 0),
(149, 'index', '菜单列表', 1, 'Nav', '前台菜单管理', 8, 10, 0, 1),
(150, 'add', '添加菜单', 1, 'Nav', '前台菜单管理', 8, 10, 0, 1),
(151, 'update', '更新菜单', 1, 'Nav', '前台菜单管理', 8, 10, 0, 0),
(152, 'remove', '删除菜单', 1, 'Nav', '前台菜单管理', 8, 10, 0, 0),
(153, 'editfield', '修改菜单字段', 1, 'Nav', '前台菜单管理', 8, 10, 0, 0),
(154, 'togglestatus', '切换菜单状态', 1, 'Nav', '前台菜单管理', 8, 10, 0, 0),
(155, '', '', 1, 'FriendLink', '友情链接管理', 8, 10, 1, 0),
(156, 'index', '链接列表', 1, 'FriendLink', '友情链接管理', 8, 10, 0, 1),
(157, 'add', '添加链接', 1, 'FriendLink', '友情链接管理', 8, 10, 0, 1),
(158, 'update', '更新链接', 1, 'FriendLink', '友情链接管理', 8, 10, 0, 0),
(159, 'remove', '删除链接', 1, 'FriendLink', '友情链接管理', 8, 10, 0, 0),
(160, 'editfield', '修改链接字段', 1, 'FriendLink', '友情链接管理', 8, 10, 0, 0),
(161, 'togglestatus', '切换链接状态', 1, 'FriendLink', '友情链接管理', 8, 10, 0, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%second`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%second` (
  `sid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(150) DEFAULT '',
  `sort` smallint(5) DEFAULT '100',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%second_goods`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%second_goods` (
  `gid` int(11) NOT NULL AUTO_INCREMENT,
  `sid` smallint(6) NOT NULL,
  `share_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT '',
  `content` text,
  `price` decimal(10,2) DEFAULT '0.00',
  `alipay_id` varchar(100) DEFAULT '',
  `city_id` int(11) DEFAULT '0',
  `uid` int(11) DEFAULT '0',
  `user_name` char(15) DEFAULT '',
  `create_time` int(11) DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`gid`),
  UNIQUE KEY `share_id` (`share_id`),
  KEY `sid` (`sid`),
  KEY `city_id` (`city_id`),
  KEY `uid` (`uid`),
  KEY `sid_city` (`sid`,`city_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%sessions`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%sessions` (
  `sid` char(6) NOT NULL DEFAULT '',
  `ip1` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ip2` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ip3` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ip4` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `user_name` char(15) NOT NULL DEFAULT '',
  `gid` smallint(6) unsigned NOT NULL DEFAULT '0',
  `shop_id` int(11) NOT NULL DEFAULT '0',
  `share_id` int(11) NOT NULL DEFAULT '0',
  `last_activity` int(10) unsigned NOT NULL DEFAULT '0',
  `last_update` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `uid` (`uid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%share`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share` (
  `share_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `user_name` varchar(60) DEFAULT '',
  `parent_id` int(11) DEFAULT '0',
  `rec_id` int(11) NOT NULL DEFAULT '0',
  `rec_share_id` int(11) DEFAULT '0',
  `content` text,
  `collect_count` int(11) DEFAULT '0',
  `comment_count` int(11) DEFAULT '0',
  `relay_count` int(11) DEFAULT '0',
  `click_count` int(11) NOT NULL DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  `title` varchar(255) NOT NULL DEFAULT '',
  `type` enum('default','ask','ershou','fav','comments','ask_post','bar','bar_post') NOT NULL DEFAULT 'default' COMMENT 'default:默认(default时，parent_id指向本表， 即转发),bar:主题,ershou:二手,ask:问答,ask_post:问答回复,comments:评论,fav:喜欢,bar:论坛,bar_post:论坛回复',
  `share_data` enum('goods','photo','default','goods_photo') NOT NULL DEFAULT 'default',
  `base_id` int(11) NOT NULL COMMENT '原创主题的ID，本贴为原创，则base_id为0',
  `is_best` tinyint(1) DEFAULT '0',
  `is_rec_best` tinyint(1) NOT NULL DEFAULT '0',
  `collect_share` varchar(60) DEFAULT '',
  PRIMARY KEY (`share_id`),
  KEY `uid` (`uid`),
  KEY `share_data` (`share_data`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

INSERT INTO `%DB_PREFIX%share` (`share_id`, `uid`, `user_name`, `parent_id`, `rec_id`, `rec_share_id`, `content`, `collect_count`, `comment_count`, `relay_count`, `click_count`, `create_time`, `title`, `type`, `share_data`, `base_id`, `is_best`, `is_rec_best`, `collect_share`) VALUES
(1, 1, '', 0, 1, 0, '招聘信息', 0, 0, 0, 0, 1313002941, '招聘信息', 'bar', 'default', 0, 0, 0, ''),
(2, 1, '', 0, 2, 0, '联系我们', 0, 0, 0, 0, 1313004433, '联系我们', 'bar', 'default', 0, 0, 0, ''),
(3, 1, '', 0, 3, 0, '新手指南', 0, 0, 0, 0, 1312928032, '新手指南', 'bar', 'default', 0, 0, 0, ''),
(4, 1, '', 0, 4, 0, '意见簿', 0, 0, 0, 0, 1312930138, '意见簿', 'bar', 'default', 0, 0, 0, ''),
(5, 1, '', 0, 5, 0, '申请达人', 0, 0, 0, 0, 1313021857, '申请达人', 'bar', 'default', 0, 0, 0, '');

DROP TABLE IF EXISTS `%DB_PREFIX%sharegoods_module`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%sharegoods_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `is_install` tinyint(1) NOT NULL,
  `name` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `logo` varchar(255) DEFAULT '',
  `url` varchar(255) NOT NULL,
  `sort` smallint(5) DEFAULT '100',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `%DB_PREFIX%sharegoods_module` (`id`, `class`, `domain`, `status`, `is_install`, `name`, `icon`, `logo`, `url`, `sort`) VALUES
(1, 'taobao', 'http://item.taobao.com,http://item.tmall.com', 1, 1, '淘宝', './public/upload/business/taobao.gif', '', '', 100);

DROP TABLE IF EXISTS `%DB_PREFIX%share_category`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_category` (
  `share_id` int(11) NOT NULL,
  `cate_id` int(11) NOT NULL,
  KEY `share_id` (`share_id`),
  KEY `cate_id` (`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%share_comment`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_comment` (
  `comment_id` int(11) NOT NULL AUTO_INCREMENT,
  `share_id` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `parent_id` int(11) DEFAULT '0',
  `content` text,
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`comment_id`),
  KEY `share_id` (`share_id`),
  KEY `uid` (`uid`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%share_goods`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_goods` (
  `goods_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `share_id` int(11) NOT NULL,
  `shop_id` int(11) NOT NULL,
  `img` varchar(255) DEFAULT '',
  `name` varchar(255) DEFAULT '',
  `url` varchar(255) DEFAULT '',
  `price` decimal(10,2) DEFAULT '0.00',
  `cate_id` int(11) NOT NULL DEFAULT '0',
  `taoke_url` varchar(255) DEFAULT '',
  `sort` smallint(5) DEFAULT '10',
  PRIMARY KEY (`goods_id`),
  KEY `uid` (`uid`),
  KEY `share_id` (`share_id`),
  KEY `shop_id` (`shop_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%share_image_sizes`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_image_sizes` (
  `id` varchar(60) NOT NULL DEFAULT '',
  `width` smallint(5) DEFAULT '0',
  `height` smallint(5) DEFAULT '0',
  `is_cut` tinyint(1) DEFAULT '0',
  `is_water` tinyint(1) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%share_image_sizes` (`id`, `width`, `height`, `is_cut`, `is_water`, `status`) VALUES
('image_1', 200, 200, 1, 0, 1),
('image_2', 100, 100, 1, 0, 1),
('image_3', 150, 170, 1, 0, 1),
('image_4', 90, 70, 1, 0, 1),
('image_5', 32, 32, 1, 0, 1),
('image_6', 180, 999, 0, 0, 1),
('image_7', 468, 468, 0, 0, 1),
('image_8', 80, 80, 1, 0, 1),
('image_9', 160, 160, 0, 0, 1);

DROP TABLE IF EXISTS `%DB_PREFIX%share_match`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_match` (
  `share_id` int(11) NOT NULL,
  `content_match` text NOT NULL,
  PRIMARY KEY (`share_id`),
  FULLTEXT KEY `content_match` (`content_match`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%share_photo`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_photo` (
  `photo_id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `share_id` int(11) NOT NULL,
  `img` varchar(255) DEFAULT '',
  `sort` smallint(5) DEFAULT '10',
  PRIMARY KEY (`photo_id`),
  KEY `uid` (`uid`),
  KEY `share_id` (`share_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%share_tags`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%share_tags` (
  `share_id` int(11) NOT NULL,
  `tag_name` varchar(100) DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  KEY `share_id` (`share_id`),
  KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%shop`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%shop` (
  `shop_id` int(11) NOT NULL AUTO_INCREMENT,
  `cate_id` smallint(6) NOT NULL DEFAULT '0',
  `shop_name` varchar(255) DEFAULT '',
  `shop_logo` varchar(255) DEFAULT '',
  `shop_url` varchar(255) DEFAULT '',
  `recommend_count` int(11) DEFAULT '0',
  `taoke_url` varchar(255) DEFAULT '',
  PRIMARY KEY (`shop_id`),
  KEY `cate_id` (`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%shop_category`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%shop_category` (
  `cate_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parent_id` smallint(6) DEFAULT NULL,
  `name` varchar(100) DEFAULT '',
  `code` varchar(100) DEFAULT '',
  `sort` smallint(5) DEFAULT '100',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`cate_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%sys_conf`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%sys_conf` (
  `name` varchar(80) NOT NULL DEFAULT '',
  `val` text NOT NULL,
  `status` tinyint(1) NOT NULL,
  `sort` int(11) NOT NULL,
  `list_type` tinyint(1) NOT NULL COMMENT '0:手动输入 1:单选 2:下拉 3:文本域 4:图像',
  `val_arr` varchar(255) NOT NULL COMMENT '可选的值的集合。序列化存放',
  `group_id` tinyint(2) NOT NULL,
  `is_show` tinyint(1) NOT NULL DEFAULT '1',
  `is_js` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%sys_conf` (`name`, `val`, `status`, `sort`, `list_type`, `val_arr`, `group_id`, `is_show`, `is_js`) VALUES
('SITE_NAME', '方维', 1, 1, 0, '', 1, 1, 0),
('SITE_TITLE', '方维购物分享', 1, 2, 0, '', 1, 1, 0),
('SITE_KEYWORDS', '方维,方维购物分享,网购,淘宝网购物,淘宝网导购', 1, 12, 3, '', 1, 1, 0),
('SITE_DESCRIPTION', '方维购物分享是一个纯买家社区，百万网友一起淘宝网购物，挖掘好店、分享网购，您可以获得最可靠的店铺排行和淘宝网购物分享。', 1, 13, 3, '', 1, 1, 0),
('SITE_TMPL', 'fanwe', 1, 6, 2, '', 1, 1, 0),
('SYS_ADMIN', 'fanwe', 1, 7, 0, '', 1, 1, 0),
('SITE_LOGO', './logo.gif', 1, 3, 4, '', 1, 1, 0),
('FOOTER_HTML', '<p>\r\n	方维购物分享系统 系统版本：v1.31版权所有&copy; 资源提供：<a href="http://bbs.gope.cn/" target="_blank" ><font color="red">狗扑源码社区</font></a></p>\r\n', 1, 14, 5, '方维购物分享系统 系统版本：v1.31版权所有© 方维\r\n', 1, 1, 0),
('TAO_KE_KEY', '28541890', 1, 10, 0, '', 4, 1, 0),
('EXPIRED_TIME', '3600', 1, 8, 0, '', 1, 1, 0),
('SYS_VERSION', '1.0', 1, 10, 0, '', 1, 0, 0),
('TIME_ZONE', '8', 1, 9, 0, '', 1, 1, 0),
('DEFAULT_LANG', 'zh-cn', 1, 10, 2, '', 1, 1, 0),
('APP_LOG', '1', 1, 11, 2, '0,1', 1, 1, 0),
('FOOT_LOGO', './foot_logo.gif', 1, 4, 4, '', 1, 1, 0),
('LINK_LOGO', './link_logo.gif', 1, 5, 4, '', 1, 1, 0),
('BG_COLOR', '#ffffff', 1, 10, 0, '', 2, 1, 0),
('MAX_UPLOAD', '2048', 1, 10, 0, '', 2, 1, 0),
('ALLOW_UPLOAD_EXTS', 'jpg,gif,png,jpeg', 1, 10, 0, '', 2, 1, 0),
('WATER_MARK', '1', 1, 10, 1, '0,1', 2, 1, 0),
('BIG_WIDTH', '500', 1, 10, 0, '', 2, 1, 0),
('BIG_HEIGHT', '0', 1, 10, 0, '', 2, 1, 0),
('SMALL_WIDTH', '200', 1, 10, 0, '', 2, 1, 0),
('SMALL_HEIGHT', '0', 1, 10, 0, '', 2, 1, 0),
('WATER_IMAGE', '', 1, 10, 4, '', 2, 1, 0),
('WATER_POSITION', '5', 1, 10, 2, '1,2,3,4,5', 2, 1, 0),
('WATER_ALPHA', '50', 1, 10, 0, '', 2, 1, 0),
('AUTO_GEN_IMAGE', '0', 1, 10, 2, '0,1', 2, 1, 0),
('URL_MODEL', '0', 1, 10, 2, '0,1', 1, 1, 0),
('TAO_APP_KEY', '12300965', 1, 10, 0, ' ', 4, 1, 0),
('TAO_APP_SECRET', '329b93d2fee4b48dcfcdf12438c5fbd8', 1, 10, 0, ' ', 4, 1, 0),
('SITE_SERVICE_EMAIL', 'service@fanwe.com', 1, 9, 0, '', 1, 1, 0),
('SHARE_GOODS_COUNT', '3', 1, 10, 0, '', 3, 1, 1),
('SHARE_PIC_COUNT', '3', 1, 10, 0, '', 3, 1, 1),
('SHARE_TAG_COUNT', '10', 1, 10, 0, '', 3, 1, 1),
('SMTP_SERVER', '', 1, 10, 0, '', 5, 1, 0),
('SMTP_PORT', '25', 1, 10, 0, '', 5, 1, 0),
('SMTP_ACCOUNT', '', 1, 10, 0, '', 5, 1, 0),
('SMTP_PASSWORD', '', 1, 10, 0, '', 5, 1, 0),
('SMTP_IS_SSL', '0', 1, 10, 1, '0,1', 5, 1, 0),
('SMTP_AUTH', '1', 1, 10, 1, '0,1', 5, 1, 0);

DROP TABLE IF EXISTS `%DB_PREFIX%user`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user` (
  `uid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gid` smallint(6) NOT NULL,
  `email` varchar(60) DEFAULT '',
  `user_name` varchar(60) DEFAULT '',
  `user_name_match` text,
  `password` char(32) DEFAULT '',
  `credits` int(11) DEFAULT '0',
  `reg_time` int(11) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  `email_status` tinyint(1) DEFAULT '0',
  `avatar_status` tinyint(1) DEFAULT '0',
  `is_daren` tinyint(1) DEFAULT '0',
  `sina_id` varchar(255) NOT NULL,
  `sina_app_key` varchar(255) NOT NULL,
  `sina_app_secret` varchar(255) NOT NULL,
  `sina_syn_weibo` tinyint(1) NOT NULL DEFAULT '1',
  `sina_syn_topic` tinyint(1) NOT NULL DEFAULT '1',
  `tqq_id` varchar(255) NOT NULL,
  `tqq_app_key` varchar(255) NOT NULL,
  `tqq_app_secret` varchar(255) NOT NULL,
  `tqq_syn_weibo` tinyint(1) NOT NULL DEFAULT '1',
  `tqq_syn_topic` tinyint(1) NOT NULL DEFAULT '1',
  `qq_id` varchar(255) NOT NULL,
  `taobao_id` varchar(255) NOT NULL,
  PRIMARY KEY (`uid`),
  UNIQUE KEY `user_name` (`user_name`),
  KEY `gid` (`gid`),
  KEY `email` USING BTREE (`email`),
  FULLTEXT KEY `user_name_match` (`user_name_match`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

INSERT INTO `%DB_PREFIX%user` (`uid`, `gid`, `email`, `user_name`, `user_name_match`, `password`, `credits`, `reg_time`, `status`, `email_status`, `avatar_status`, `is_daren`, `sina_id`, `sina_app_key`, `sina_app_secret`, `sina_syn_weibo`, `sina_syn_topic`, `tqq_id`, `tqq_app_key`, `tqq_app_secret`, `tqq_syn_weibo`, `tqq_syn_topic`, `qq_id`, `taobao_id`) VALUES
(1, 7, 'admin@fanwe.com', 'admin', 'ux20998 ux20139 ux27979 ux35797', '21232f297a57a5a743894a0e4a801fc3', 0, 1313024742, 1, 0, 0, 0, '', '', '', 1, 1, '', '', '', 1, 1, '', '');

DROP TABLE IF EXISTS `%DB_PREFIX%user_attention`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_attention` (
  `uid` int(11) NOT NULL,
  `user_name` char(15) DEFAULT NULL,
  `rec_id` int(11) DEFAULT NULL,
  `share_id` int(11) DEFAULT NULL,
  `type` enum('bar','ershou','ask','default') DEFAULT 'default' COMMENT 'default:默认,bar:主题,ershou:二手,ask:问答',
  `create_time` int(11) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_authority`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_authority` (
  `uid` int(11) NOT NULL,
  `module` varchar(60) NOT NULL DEFAULT '',
  `action` varchar(60) NOT NULL DEFAULT '',
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_category`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_category` (
  `id` smallint(6) NOT NULL,
  `name` varchar(100) DEFAULT '',
  `cate_desc` text,
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%user_category` (`id`, `name`, `cate_desc`, `status`) VALUES
(1, '技能', '告诉大家自己最擅长的美丽技能吧！', 1),
(2, '小情结', '自己的那些美丽小情结！', 1),
(3, '爱什么范', '大声告诉全世界，你爱什么范儿？', 1),
(4, '时尚从业', '我是时尚从业者！', 1);

DROP TABLE IF EXISTS `%DB_PREFIX%user_category_tags`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_category_tags` (
  `tag_id` smallint(6) NOT NULL,
  `cate_id` smallint(6) NOT NULL,
  KEY `tag_id` (`tag_id`),
  KEY `cate_id` (`cate_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%user_category_tags` (`tag_id`, `cate_id`) VALUES
(1, 1),
(2, 1),
(3, 1),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 1),
(16, 1),
(17, 1),
(18, 2),
(19, 2),
(20, 2),
(21, 2),
(22, 2),
(23, 2),
(24, 2),
(25, 2),
(26, 2),
(27, 2),
(28, 2),
(29, 2),
(30, 2),
(31, 2),
(32, 2),
(33, 2),
(34, 2),
(35, 2),
(36, 2),
(37, 2),
(38, 2),
(39, 2),
(40, 2),
(41, 2),
(42, 2),
(43, 2),
(44, 3),
(45, 3),
(46, 3),
(47, 3),
(48, 3),
(49, 3),
(50, 3),
(51, 3),
(52, 3),
(53, 3),
(54, 3),
(55, 3),
(56, 3),
(57, 3),
(58, 3),
(59, 3),
(60, 3),
(61, 3),
(62, 3),
(63, 3),
(64, 3),
(65, 4),
(66, 4),
(67, 4),
(68, 4),
(69, 4),
(70, 4),
(71, 4),
(72, 4);

DROP TABLE IF EXISTS `%DB_PREFIX%user_collect`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_collect` (
  `uid` int(11) NOT NULL,
  `c_uid` int(11) DEFAULT NULL,
  `rec_id` int(11) DEFAULT NULL,
  `share_id` int(11) DEFAULT '0',
  `type` tinyint(4) DEFAULT '0' COMMENT '0:普通 1:论坛 2:问答 3:二手',
  `create_time` int(11) DEFAULT '0',
  KEY `uid` (`uid`),
  KEY `c_uid` (`c_uid`),
  KEY `rec_id` (`rec_id`),
  KEY `share_id` (`share_id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_count`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_count` (
  `uid` int(11) NOT NULL,
  `follows` int(11) DEFAULT '0',
  `fans` int(11) DEFAULT '0',
  `collects` int(11) DEFAULT '0',
  `favs` int(11) DEFAULT '0',
  `threads` int(11) DEFAULT '0',
  `photos` int(11) DEFAULT '0',
  `goods` int(11) DEFAULT '0',
  `ask` int(11) DEFAULT '0',
  `ask_posts` int(11) DEFAULT '0',
  `ask_best_posts` int(11) DEFAULT '0',
  `shares` int(11) DEFAULT '0',
  `forums` int(11) NOT NULL DEFAULT '0',
  `forum_posts` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%user_count` (`uid`, `follows`, `fans`, `collects`, `favs`, `threads`, `photos`, `goods`, `ask`, `ask_posts`, `ask_best_posts`, `shares`, `forums`, `forum_posts`) VALUES
(1, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 5, 0, 0);


DROP TABLE IF EXISTS `%DB_PREFIX%user_daren`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_daren` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `cid` smallint(6) DEFAULT '0',
  `img` varchar(255) NOT NULL DEFAULT '',
  `gift_name` varchar(255) DEFAULT '',
  `gift_url` varchar(255) DEFAULT '',
  `sponsor_name` varchar(255) DEFAULT '',
  `sponsor_url` varchar(255) DEFAULT '',
  `is_best` tinyint(1) DEFAULT '0',
  `is_index` tinyint(1) NOT NULL DEFAULT '0',
  `index_img` varchar(255) NOT NULL DEFAULT '',
  `day_time` int(11) DEFAULT '0',
  `reason` varchar(255) DEFAULT '',
  `create_time` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `uid` (`uid`),
  KEY `cid` (`cid`),
  KEY `is_index` (`is_index`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%user_follow`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_follow` (
  `f_uid` int(11) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `create_time` int(11) DEFAULT '0',
  KEY `uid` (`uid`),
  KEY `f_uid` (`f_uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_group`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_group` (
  `gid` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) DEFAULT '',
  `type` enum('system','user') DEFAULT NULL,
  `stars` tinyint(1) DEFAULT '0',
  `color` varchar(8) DEFAULT '',
  `icon` varchar(255) DEFAULT '',
  `credits_higher` int(11) DEFAULT '0',
  `credits_lower` int(11) DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

INSERT INTO `%DB_PREFIX%user_group` (`gid`, `name`, `type`, `stars`, `color`, `icon`, `credits_higher`, `credits_lower`, `status`) VALUES
(1, '前台管理员', 'system', 0, '', '', 0, 0, 1),
(2, '分享管理员', 'system', 0, '', '', 0, 0, 1),
(3, '论坛管理员', 'system', 0, '', '', 0, 0, 1),
(4, '问答管理员', 'system', 0, '', '', 0, 0, 1),
(5, '闲置管理员', 'system', 0, '', '', 0, 0, 1),
(6, '游客', 'system', 0, '', '', 0, 0, 1),
(7, '普通会员', 'system', 0, '', '', 0, 0, 1);

DROP TABLE IF EXISTS `%DB_PREFIX%user_group_authority`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_group_authority` (
  `gid` int(11) NOT NULL,
  `module` varchar(60) NOT NULL DEFAULT '',
  `action` varchar(60) NOT NULL DEFAULT '',
  KEY `uid` (`gid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%user_group_authority` (`gid`, `module`, `action`) VALUES
(1, 'club', 'edit'),
(1, 'club', 'top'),
(1, 'club', 'best'),
(1, 'share', 'delete'),
(1, 'share', 'edit'),
(1, 'share', 'best'),
(2, 'share', 'delete'),
(2, 'share', 'edit'),
(2, 'share', 'best'),
(3, 'club', 'delete'),
(3, 'club', 'edit'),
(3, 'club', 'top'),
(3, 'club', 'best'),
(4, 'ask', 'delete'),
(4, 'ask', 'edit'),
(4, 'ask', 'top'),
(4, 'ask', 'best'),
(1, 'club', 'delete'),
(1, 'ask', 'best'),
(1, 'ask', 'top'),
(1, 'ask', 'edit'),
(1, 'ask', 'delete');

DROP TABLE IF EXISTS `%DB_PREFIX%user_medal`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_medal` (
  `uid` int(11) NOT NULL,
  `mid` int(11) NOT NULL,
  KEY `uid` (`uid`),
  KEY `mid` (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_me_tags`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_me_tags` (
  `uid` int(11) NOT NULL,
  `tag_name` varchar(100) DEFAULT NULL,
  `tag_name_match` text,
  KEY `uid` (`uid`),
  KEY `tag_name` (`tag_name`),
  FULLTEXT KEY `tag_name_match` (`tag_name_match`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_msg`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_msg` (
  `mid` int(11) NOT NULL AUTO_INCREMENT,
  `author_id` int(11) DEFAULT NULL COMMENT 'author_id为0时为系统消息',
  `title` varchar(255) DEFAULT NULL,
  `content` varchar(255) DEFAULT '',
  `create_time` int(11) DEFAULT '0',
  `status` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`mid`),
  KEY `author_id` (`author_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

DROP TABLE IF EXISTS `%DB_PREFIX%user_msg_rel`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_msg_rel` (
  `mid` int(11) NOT NULL,
  `uid` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_notice`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_notice` (
  `uid` int(11) NOT NULL,
  `type` tinyint(1) DEFAULT '0',
  `num` int(11) DEFAULT '0',
  `create_time` int(11) DEFAULT '0',
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_profile`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_profile` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `nick_name` varchar(60) DEFAULT '',
  `gender` tinyint(1) DEFAULT '0',
  `birth_year` smallint(6) DEFAULT '0',
  `birth_month` smallint(6) DEFAULT '0',
  `birth_day` smallint(4) DEFAULT '0',
  `reside_province` int(11) DEFAULT '0',
  `reside_city` int(11) DEFAULT '0',
  `school` varchar(100) DEFAULT '',
  `workplace` varchar(100) DEFAULT '',
  `occupation` smallint(6) DEFAULT '0',
  `weibo` varchar(255) DEFAULT '',
  `hobby` varchar(255) DEFAULT '',
  `introduce` text,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `%DB_PREFIX%user_profile` (`uid`, `nick_name`, `gender`, `birth_year`, `birth_month`, `birth_day`, `reside_province`, `reside_city`, `school`, `workplace`, `occupation`, `weibo`, `hobby`, `introduce`) VALUES
(1, '', 0, 0, 0, 0, 5, 133, '', '', 0, '', '', '');

DROP TABLE IF EXISTS `%DB_PREFIX%user_statistics`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_statistics` (
  `uid` int(11) NOT NULL,
  `rec_id` int(11) DEFAULT NULL,
  `rec_data` text,
  `type` varchar(50) DEFAULT '',
  `time_type` varchar(20) DEFAULT '',
  `now_num` int(11) DEFAULT '0',
  `before_num` int(11) DEFAULT '0',
  `statistic_time` int(11) DEFAULT '0',
  PRIMARY KEY (`uid`),
  KEY `type` (`type`,`time_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `%DB_PREFIX%user_status`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_status` (
  `uid` int(11) NOT NULL,
  `reg_ip` char(15) DEFAULT '',
  `last_ip` char(15) DEFAULT '',
  `last_time` int(11) DEFAULT '0',
  `last_activity` int(11) DEFAULT '0',
  `active_hash` varchar(255) DEFAULT '',
  `reset_hash` varchar(255) DEFAULT '',
  `edit_name_count` smallint(5) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

INSERT INTO `%DB_PREFIX%user_status` (`uid`, `reg_ip`, `last_ip`, `last_time`, `last_activity`, `active_hash`, `reset_hash`, `edit_name_count`) VALUES
(1, '127.0.0.1', '', 0, 0, '', '', 0);

DROP TABLE IF EXISTS `%DB_PREFIX%user_tags`;
CREATE TABLE IF NOT EXISTS `%DB_PREFIX%user_tags` (
  `tag_id` smallint(6) NOT NULL AUTO_INCREMENT,
  `tag_name` varchar(100) DEFAULT '',
  `sort` smallint(5) DEFAULT '100',
  PRIMARY KEY (`tag_id`),
  KEY `tag_name` (`tag_name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=73 ;

INSERT INTO `%DB_PREFIX%user_tags` (`tag_id`, `tag_name`, `sort`) VALUES
(1, '擅长找白菜', 100),
(2, '擅长找白菜', 100),
(3, '擅长搭配', 100),
(4, '擅长找差价', 100),
(5, '擅长找同款', 100),
(6, '擅长找原单', 100),
(7, '擅长组团', 100),
(8, '擅长找好店', 100),
(9, '擅长分享团购', 100),
(10, '擅长护肤', 100),
(11, '擅长彩妆', 100),
(12, '擅长美白', 100),
(13, '擅长护发', 100),
(14, '擅长减重', 100),
(15, '擅长淘包包', 100),
(16, '擅长淘配饰', 100),
(17, '擅长淘鞋子', 100),
(18, '格子控', 100),
(19, '细节控', 100),
(20, '豹纹控', 100),
(21, '黑色控', 100),
(22, '丝袜控', 100),
(23, '色彩控', 100),
(24, '条纹控', 100),
(25, '波点控', 100),
(26, '白菜控', 100),
(27, '蓝色控', 100),
(28, '衬衫控', 100),
(29, '蕾丝控', 100),
(30, '原单控', 100),
(31, '美瞳控', 100),
(32, '蝴蝶结控', 100),
(33, '粉色控', 100),
(34, '鞋子控', 100),
(35, '牛仔控', 100),
(36, '碎花控', 100),
(37, '平底鞋控', 100),
(38, '高跟鞋控', 100),
(39, '真丝控', 100),
(40, '护肤控', 100),
(41, '饰品控', 100),
(42, '面膜控', 100),
(43, '棉麻控', 100),
(44, '学院风格', 100),
(45, '欧美风格', 100),
(46, '混搭风格', 100),
(47, '甜美风格', 100),
(48, '清新风格', 100),
(49, '英伦风格', 100),
(50, 'vintage复古风格', 100),
(51, 'BF风格', 100),
(52, '极简风格', 100),
(53, '中性风格', 100),
(54, '朋克风格', 100),
(55, '摇滚风格', 100),
(56, '森女风格', 100),
(57, '洛丽塔风格', 100),
(58, '公主风格', 100),
(59, '名媛风格', 100),
(60, '波西米亚风格', 100),
(61, '民族风格', 100),
(62, '休闲风格', 100),
(63, '御姐风格', 100),
(64, '性感风格', 100),
(65, '模特', 100),
(66, '造型师', 100),
(67, '品牌工作人员', 100),
(68, '美容编辑', 100),
(69, '时尚编辑', 100),
(70, '时尚媒体', 100),
(71, '时装买手', 100),
(72, '我在其它网站是达人', 100);