<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class Index_block extends Controller
{
	function Index_block()
	{
		parent::Controller();
		check_is_login();
		$this->load->database();
	}
	function index()
	{
		$this->load->config('top_config');
		$data = array(
			'index_block' => get_cache('index_block'),
			'catalog'	=> get_cache('industry_catalog'),
			'credit' => $this->config->item('credit')
		);
		$this->load->view(TPL_FOLDER."index_block",$data);
	}
	
	function save_index_block()
	{
		$index_block = $this->input->post('index_block');
		if( ! is_array($index_block))
		{
			$tx_msg="<li>版块不能为空.</li>";
			echo_msg($tx_msg,'','no');
		}
		
		$a = array();
		foreach($index_block as $v)
		{
			$t = explode('|',$v);
			$a[] = array('title'=>filter_str($t[0]),'cid'=>$t[1],'q'=>$t[2],'start_commission_rate'=>$t[3],'end_commission_rate'=>$t[4],'start_credit'=>$t[5],'end_credit'=>$t[6],'sorts'=>$t[7],'num'=>$t[8]);
		}
		if(save_cache('index_block',$a))
		{
			$tx_msg="<li>首页板块修改成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>首页板块修改失败.</li>";
			echo_msg($tx_msg,'','no');
		}
	}
}
?>