<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class Industry_catalog extends Controller
{
	
	function Industry_catalog()
	{
		parent::Controller();
		check_is_login();
		$this->load->database();
		$this->load->model("tadmin/Industry_catalog_model");
		$this->load->library('form_validation');
	}
	function index()
	{
		$data=array(
			'catalog_list'=>$this->common_model->get_records('SELECT id,cat_name,seqorder FROM '.$this->db->dbprefix.'shop_industry_catalog WHERE parent_id = 0 ORDER BY seqorder ASC,id DESC')
		);
		$this->load->view(TPL_FOLDER."industry_catalog_list",$data);
	}
	
	function sort_record()
	{
		$this->form_validation->set_rules("rd_id","排序项","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}

		if($this->Industry_catalog_model->sort_record())
		{
			$this->_write_cache();
			$tx_msg="<li>记录排序成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录排序失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function del_record()
	{
		$this->form_validation->set_rules("rd_id","删除的记录","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}
		if($this->Industry_catalog_model->del_record())
		{
			$this->_write_cache();
			$tx_msg="<li>记录删除成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录删除失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function re_cache()
	{
		$this->_write_cache();
		echo_msg('<li>缓存生成成功.</li>','','yes');
	}
	
	function _write_cache()
	{
		$cat = $this->common_model->get_records('SELECT id,cat_name FROM '.$this->db->dbprefix.'shop_industry_catalog WHERE parent_id = 0 ORDER BY seqorder ASC,id DESC');
		save_cache('industry_catalog',$cat);
		unset($cat);
	}
}
?>