<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class News extends Controller
{
	function News()
	{
		parent::Controller();
		check_is_login();
		$this->load->model("tadmin/News_model");
		$this->load->library('form_validation');
		$this->load->database();
	}

	function index()
	{
		parse_str($_SERVER['QUERY_STRING'],$get);
		$sql = 'SELECT n.id,n.pic_path,n.title,n.is_push,n.create_date,n.seqorder,n.hits,n.is_create,(SELECT cat_name FROM '.$this->db->dbprefix.'shop_news_catalog WHERE queue = n.catalog_id) AS cat_name,(SELECT COUNT(*) FROM '.$this->db->dbprefix.'shop_news_goods WHERE nid = n.id) AS goods FROM '.$this->db->dbprefix.'shop_news AS n WHERE n.is_trash = 0';
		if(isset($get['s_catalog_id'])&&$get['s_catalog_id']!='')
		{
			$sql .= " AND n.catalog_id like '%,".$get['s_catalog_id'].",%'";
		}
		if(isset($get['s_keyword'])&&$get['s_keyword']!='')
		{
			$sql .= " AND n.title like '%".$get['s_keyword']."%'";
		}
		$sql .= ' ORDER BY n.seqorder ASC,n.id DESC';
		$page = array(
			'per_page' => 20,
			'page_base' => CTL_FOLDER."news/index",
			'sql'  => $sql
		);
		$query = $this->common_model->get_page_records($page);
		$data = array(
			'query'		=> $query['query'],
			'paginate'	=> $query['paginate'],
			'catalog_list'	=> $this->News_model->get_catalog_records(),
			'trash_num'  => $this->News_model->get_trash_num()
		);
		$this->load->view(TPL_FOLDER."news_list",$data);
	}
	
	function add_record_view()
	{
		$data = array(
			'catalog_list'	=> $this->News_model->get_catalog_records()
		);
		$this->load->view(TPL_FOLDER."news_add",$data);
	}
	
	function trash_back()
	{
		$this->form_validation->set_rules("rd_id","记录ID","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}
		if($this->News_model->trash_back())
		{
			$tx_msg="<li>记录还原成功，请返回文章列表查看.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录还原失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function get_trash()
	{
		parse_str($_SERVER['QUERY_STRING'],$get);
		$sql = 'SELECT n.id,n.pic_path,n.title,n.create_date,n.seqorder,n.hits,(SELECT cat_name FROM '.$this->db->dbprefix.'shop_news_catalog WHERE queue = n.catalog_id) AS cat_name FROM '.$this->db->dbprefix.'shop_news AS n WHERE n.is_trash = 1';
		if(isset($get['s_catalog_id'])&&$get['s_catalog_id']!='')
		{
			$sql .= " AND n.catalog_id like '%,".$get['s_catalog_id'].",%'";
		}
		if(isset($get['s_keyword'])&&$get['s_keyword']!='')
		{
			$sql .= " AND n.title like '%".$get['s_keyword']."%'";
		}
		$sql .= ' ORDER BY n.seqorder ASC,n.id DESC';
		$page = array(
			'per_page' => 15,
			'page_base' => CTL_FOLDER."news/get_trash",
			'sql'  => $sql
		);
		$query = $this->common_model->get_page_records($page);
		$data = array(
			'query'		=> $query['query'],
			'paginate'	=> $query['paginate'],
			'catalog_list'	=> $this->News_model->get_catalog_records()
		);
		$this->load->view(TPL_FOLDER."news_trash",$data);
	}
	
	function sort_record()
	{
		$this->form_validation->set_rules("rd_id","排序项","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}

		if($this->News_model->sort_record())
		{
			$tx_msg="<li>记录排序成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录排序失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function add_record()
	{
		$this->form_validation->set_rules("title","标题","trim|required");
		$tx_msg="";
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg.=validation_errors();
		}
		$up_img=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"pic",'suffix'=>UP_IMAGES_EXT));
		if(!$up_img['status'])
		{
			$tx_msg.=$up_img['upload_errors'];
		}
		if($tx_msg!="")
		{
			echo_msg($tx_msg);
		}
		
		$more_pic_id=$this->input->post("more_pic_id");
		$more_pic_array=array();
		if(is_array($more_pic_id))
		{
			foreach($more_pic_id as $value)
			{
				$more_pic=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"more_pic".$value,'suffix'=>UP_IMAGES_EXT));
				if($more_pic['status']&&$more_pic['file_path']!='')
				{
					$more_pic_array[]=array('title'=>$this->input->post("pic_name".$value),'pic_path'=>$more_pic['file_path']);
				}
			}
		}
		
		if($this->News_model->add_record($up_img,$more_pic_array))
		{
			
			$tx_msg="<li>记录添加成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录添加失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function edit_record()
	{
		$rd_id=$this->uri->segment(4,0);
		parse_str($_SERVER['QUERY_STRING'],$get);
		if(!$rd_id) 
		{
			$tx_msg="<li>ID参数有误.</li>";
			echo_msg($tx_msg);
		}
		$edit_data=$this->News_model->get_record($rd_id);
		$goods = $this->common_model->get_records('SELECT * FROM '.$this->db->dbprefix.'shop_news_goods WHERE nid = '.$rd_id);
		$data=array(
			'edit_data'=>$edit_data,
			'url'=>$get['url'],
			'goods'=>$goods,
			'pic' => $this->common_model->get_records('SELECT * FROM '.$this->db->dbprefix.'shop_news_image WHERE nid = ? ORDER BY id ASC',array($rd_id)),
			'catalog_list'=>$this->News_model->get_catalog_records()
		);
		$this->load->view(TPL_FOLDER."news_edit",$data);
	}
	
	function edit_copy_record()
	{
		$rd_id=$this->uri->segment(4,0);
		parse_str($_SERVER['QUERY_STRING'],$get);
		if(!$rd_id) 
		{
			$tx_msg="<li>ID参数有误.</li>";
			echo_msg($tx_msg);
		}
		$edit_data=$this->News_model->get_record($rd_id);
		$goods = $this->common_model->get_records('SELECT * FROM '.$this->db->dbprefix.'shop_news_goods WHERE nid = '.$rd_id);
		$data=array(
			'edit_data'=>$edit_data,
			'url'=>$get['url'],
			'goods'=>$goods,
			'pic' => $this->common_model->get_records('SELECT * FROM '.$this->db->dbprefix.'shop_news_image WHERE nid = ? ORDER BY id ASC',array($rd_id)),
			'catalog_list'=>$this->News_model->get_catalog_records()
		);
		$this->load->view(TPL_FOLDER."news_copy",$data);
	}
	
	function save_record()
	{
		$this->form_validation->set_rules("title","标题","trim|required");
		$this->form_validation->set_rules("rd_id","记录ID","trim|integer");
		$tx_msg="";
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg.=validation_errors();
		}
		$up_img=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"pic",'suffix'=>UP_IMAGES_EXT));
		if(!$up_img['status'])
		{
			$tx_msg.=$up_img['upload_errors'];
		}
		if($tx_msg!="")
		{
			echo_msg($tx_msg);
		}
		
		$more_pic_id=$this->input->post("more_pic_id");
		$more_pic_array=array();
		if(is_array($more_pic_id))
		{
			foreach($more_pic_id as $value)
			{
				$more_pic=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"more_pic".$value,'suffix'=>UP_IMAGES_EXT));
				if($more_pic['status']&&$more_pic['file_path']!='')
				{
					$more_pic_array[]=array('title'=>$this->input->post("pic_name".$value),'pic_path'=>$more_pic['file_path']);
				}
			}
		}
		
		if($this->News_model->save_record($up_img,$more_pic_array))
		{
			
			$tx_msg="<li>记录修改成功.</li>";
			echo_msg($tx_msg,$this->input->post('url'),'yes');
		}
		else
		{
			$tx_msg="<li>记录修改失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function save_copy_record()
	{
		$this->form_validation->set_rules("title","标题","trim|required");
		$tx_msg="";
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg.=validation_errors();
		}
		$up_img=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"pic",'suffix'=>UP_IMAGES_EXT));
		if(!$up_img['status'])
		{
			$tx_msg.=$up_img['upload_errors'];
		}
		if($tx_msg!="")
		{
			echo_msg($tx_msg);
		}
		
		$more_pic_id=$this->input->post("more_pic_id");
		$more_pic_array=array();
		if(is_array($more_pic_id))
		{
			foreach($more_pic_id as $value)
			{
				$more_pic=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"more_pic".$value,'suffix'=>UP_IMAGES_EXT));
				if($more_pic['status']&&$more_pic['file_path']!='')
				{
					$more_pic_array[]=array('title'=>$this->input->post("pic_name".$value),'pic_path'=>$more_pic['file_path']);
				}
			}
		}
		$orig_pic_id=$this->input->post("orig_pic_id");
		if(is_array($orig_pic_id))
		{
			foreach($orig_pic_id as $value)
			{
				$more_pic_array[]=array('title'=>$this->input->post("orig_pic_name".$value),'pic_path'=>$this->input->post("orig_pic_path".$value));
			}
		}
		
		if($this->News_model->save_copy_record($up_img,$more_pic_array))
		{
			
			$tx_msg="<li>记录添加成功.</li>";
			echo_msg($tx_msg,$this->input->post('url'),'yes');
		}
		else
		{
			$tx_msg="<li>记录添加失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function put_in_trash()
	{
		$this->form_validation->set_rules("rd_id","记录ID","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}
		if($this->News_model->put_in_trash())
		{
			$tx_msg="<li>记录放入回收站成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录放入回收站失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function del_record()
	{
		$this->form_validation->set_rules("rd_id","删除的记录","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}
		if($this->News_model->del_record())
		{
			
			$tx_msg="<li>记录删除成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录删除失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function to_catalog()
	{
		$this->form_validation->set_rules("rd_id","移动的项","required");
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg=validation_errors();
			echo_msg($tx_msg);
		}
		if($this->News_model->to_catalog())
		{
			
			$tx_msg="<li>记录转移到分类成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>记录转移到分类失败.</li>";
			echo_msg($tx_msg);
		}
	}
	
	function ajax_del_more_pic()
	{
		$rd_id=$this->input->post('rd_id');
		if(!$rd_id) 
		{
			die("0");
		}
		if($this->News_model->ajax_del_more_pic($rd_id))
		{
			
			echo "1";
		}
		else
		{
			echo "0";
		}
	}

}
?>