<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class News_index extends Controller
{
	function News_index()
	{
		parent::Controller();
		check_is_login();
		$this->load->database();
	}
	function index()
	{
		$data = array(
			'news_index' => get_cache('news_index'),
			'ncatalog'	=> $this->_parse_catalog(0)
		);
		$this->load->view(TPL_FOLDER."news_index",$data);
	}
	
	function _parse_catalog($id)
	{
		static $catalog_arr=array();
		$this->db->where('parent_id',$id);
		$this->db->order_by('seqorder','asc');
		$this->db->order_by('id','desc');
		$query=$this->db->get("shop_news_catalog");
		foreach($query->result() as $row)
		{
			$catalog_arr[]=$row;
			if($row->is_has_chd==1)
			{
				$this->_parse_catalog($row->id);
			}
		}
		return $catalog_arr;
	}
	
	function save_news_index()
	{
		$news_index = $this->input->post('news_index');
		if( ! is_array($news_index))
		{
			$tx_msg="<li>版块不能为空.</li>";
			echo_msg($tx_msg,'','no');
		}
		
		$a = array();
		foreach($news_index as $v)
		{
			$t = explode('|',$v);
			$a[] = array('title'=>filter_str($t[0]),'cid'=>$t[1],'num'=>$t[2],'tpl'=>$t[3]);
		}
		if(save_cache('news_index',$a))
		{
			$tx_msg="<li>板块修改成功.</li>";
			echo_msg($tx_msg,'','yes');
		}
		else
		{
			$tx_msg="<li>板块修改失败.</li>";
			echo_msg($tx_msg,'','no');
		}
	}
}
?>