<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class Site_config extends Controller
{
	function Site_config()
	{
		parent::Controller();
		check_is_login();
		$this->load->library('form_validation');
	}
	function index()
	{
		$this->load->config("shop_site_config");
		$this->load->config("shop_email_config");
		$this->load->config("top_config");
		$data=array(
			'edit_data' => $this->config->config
		);
		$this->load->view(TPL_FOLDER."site_config",$data);
	}
	
	function save_record()
	{
		$this->form_validation->set_rules("sys_site_name","网站名称","trim|require");
		$this->form_validation->set_rules("sys_site_title","网站标题","trim|require");
		$this->form_validation->set_rules("sys_site_keyword","META关键字","trim|require");
		$this->form_validation->set_rules("sys_site_description","META描述","trim|require");
		$this->form_validation->set_rules("sys_site_copyright","网站版权","trim|require");
		$this->form_validation->set_rules('smtp_email','发信邮箱','required|valid_email');
		$this->form_validation->set_rules('cache_time','API数据缓存周期','integer');
		$this->form_validation->set_rules("sys_cache_time","网页缓存周期","integer");
		
		$tx_msg="";
		if($this->form_validation->run()==FALSE)
		{
			$tx_msg.=validation_errors();
		}
		$sys_site_logo=do_upload(array('up_path'=>UP_IMAGES_PATH,'form_name'=>"sys_site_logo",'suffix'=>UP_IMAGES_EXT));
		if(!$sys_site_logo['status'])
		{
			$tx_msg.=$sys_site_logo['upload_errors'];
		}
		
		$appkey =strip_quotes($this->input->post('appkey'));
		$secretkey = strip_quotes($this->input->post('secretkey'));
		if( ! is_array($appkey) || ! is_array($secretkey))
		{
			$tx_msg .= '<li>appkey 或secretkey 填写有误</li>';
		}
		
		if($tx_msg!="")
		{
			echo_msg($tx_msg);
		}
		$this->load->helper('file');
		$this->load->helper('string');
		$string=read_file(APPPATH.'config/shop_site_config'.EXT);
		$config['sys_site_name'] = strip_quotes($this->input->post("sys_site_name"));
		$config['sys_site_title'] = strip_quotes($this->input->post("sys_site_title"));
		if($sys_site_logo['file_path'])
		{
			$config['sys_site_logo'] = $sys_site_logo['file_path'];
		}
		else
		{
			$config['sys_site_logo'] = strip_quotes($this->input->post("pic_path1"));
		}
		$config['sys_site_keyword'] = strip_quotes($this->input->post("sys_site_keyword"));
		$config['sys_site_description'] = strip_quotes($this->input->post("sys_site_description"));
		$config['sys_site_copyright'] = strip_quotes($this->input->post("sys_site_copyright"));
		$config['sys_cache_time'] = strip_quotes($this->input->post("sys_cache_time"));
		$config['sys_tongji'] = $this->_safe_html($this->input->post("sys_tongji"));
		$reg ='/\$config\[\'(.+?)\'\][^\r\n]+/is';
		preg_match_all( $reg ,$string , $out  );
		if( $out[1] )
		{
			$old = $new = array();
			foreach( $out[1] as $k => $v )
			{
				if(isset($config[strtolower($v)]))
				{
					$old[] = $out[0][$k];
					$new[] = '$config[\''.strtolower($v).'\'] = \''.$config[strtolower($v)].'\';';
				}				
			}
			if( $new )
			{
				$string = str_replace( $old , $new , $string );
				write_file(APPPATH.'config/shop_site_config'.EXT, $string);
			}
		}
		unset($config); unset($out);unset($old); unset($new);
		
		$string=read_file(APPPATH.'config/shop_email_config'.EXT);
		$config['smtp_host'] = strip_quotes($this->input->post("smtp_host"));
		$config['smtp_user'] = strip_quotes($this->input->post("smtp_user"));
		$config['smtp_pass'] = strip_quotes($this->input->post("smtp_pass"));
		$config['smtp_email'] = strip_quotes($this->input->post("smtp_email"));
		$reg ='/\$config\[\'(.+?)\'\][^\r\n]+/is';
		preg_match_all( $reg ,$string , $out  );
		if( $out[1] )
		{
			//$old = $new = array();
			foreach( $out[1] as $k => $v )
			{
				if(isset($config[strtolower($v)]))
				{
					$old[] = $out[0][$k];
					$new[] = '$config[\''.strtolower($v).'\'] = \''.$config[strtolower($v)].'\';';
				}			
			}
			if( $new )
			{
				$string = str_replace( $old , $new , $string );
				write_file(APPPATH.'config/shop_email_config'.EXT, $string);
			}
		}
		unset($config); unset($out);unset($old); unset($new);
		
		$string=read_file(APPPATH.'config/top_config'.EXT);
		$config['cache_time'] = strip_quotes($this->input->post("cache_time"));
		$reg ='/\$config\[\'(.+?)\'\][^\r\n]+/is';
		preg_match_all( $reg ,$string , $out  );
		if( $out[1] )
		{
			//$old = $new = array();
			foreach( $out[1] as $k => $v )
			{
				if(isset($config[strtolower($v)]))
				{
					$old[] = $out[0][$k];
					$new[] = '$config[\''.strtolower($v).'\'] = \''.$config[strtolower($v)].'\';';
				}			
			}
			if( $new)
			{
				$string = str_replace( $old , $new , $string );
			}
		}
		unset($config); unset($out);unset($old); unset($new);
		
		$reg = '/\$config\[\'appkey\'\][^\r\n]+;/is';
		preg_match_all( $reg ,$string , $out  );
		if(isset($out[0][0]))
		{
			$str = '$config[\'appkey\'] = array(';
			foreach($appkey as $k=>$v)
			{
				$str .= "array('appkey'=>'{$v}','secretkey'=>'{$secretkey[$k]}'),";
			}
			$str = rtrim($str,',');
			$str .= ');';
			$string = str_replace($out[0][0],$str,$string);
		}
		write_file(APPPATH.'config/top_config'.EXT, $string);
		echo_msg('<li>配置修改成功</li>','','yes');
	}
	
	function _safe_html($str)
	{
		$str = trim($str);
		if (strlen($str) <= 0)
		{
		  return $str;
		}
		$search = array ("/\r\n/","/\r/","/\n/","/\t/");
		$replace = array ('','','','');
		$str = @preg_replace($search, $replace, $str);
		$str = htmlentities($str, ENT_QUOTES);
		return $str;
	}

}
?>