<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class Tb_search extends Controller
{
	function Tb_search()
	{
		parent::Controller();
		$this->load->database();
		$this->load->library('TopClient','','top');
	}
	
	function get_search_form()
	{
		$data = array(
			'industry_catalog' => get_cache('industry_catalog'),
			'credit' => $this->config->item('credit')
		);
		echo $this->load->view(TPL_FOLDER.'tb_search_form',$data,true);
	}
	
	function get_gsearch_form()
	{
		$data = array(
			'industry_catalog' => get_cache('industry_catalog'),
			'credit' => $this->config->item('credit')
		);
		echo $this->load->view(TPL_FOLDER.'tb_gsearch_form',$data,true);
	}
	
	function get_catalog()
	{
		header("Content-Type:application/json");
		$stype = $this->input->post('stype');
		$json = '{';
		if($stype == 'goods')
		{
			$catalog = get_cache('industry_catalog');
			$i = 1;
			foreach($catalog as $v)
			{
				if(count($catalog) == $i) $json .= $v->id.':"'.$v->cat_name.'"';
				else $json .= $v->id.':"'.$v->cat_name.'",';
				$i++;
			}
		}
		elseif($stype == 'shop')
		{
			$catalog = get_cache('shop_catalog');
			$i = 1;
			foreach($catalog as $v)
			{
				if(count($catalog) == $i) $json .= $v->id.':"'.$v->cat_name.'"';
				else $json .= $v->id.':"'.$v->cat_name.'",';
				$i++;
			}
		}
		$json .= '}';
		echo $json;
	}
	
	function get_search_shop()
	{
		$keyword = unescape($this->input->post('keyword'));
		$cid = $this->input->post('cid');
		$start_commission = $this->input->post('start_commission');
		$end_commission = $this->input->post('end_commission');
		$start_credit = $this->input->post('start_credit');
		$end_credit = $this->input->post('end_credit');
		$page_no = $this->input->post('page_no');
		$page_size = 20;
		if( ! $page_no) $page_no = 1;
		
		$this->load->library('top/TaobaokeShopsGetRequest','','req');
		$this->req->setFields('click_url,shop_title,commission_rate,seller_credit,shop_type,auction_count,total_auction');
		$this->req->setPageSize($page_size);
		if($keyword) $this->req->setKeyword($keyword);
		if($cid) $this->req->setCid($cid);
		if($start_commission) $this->req->setStartCommissionrate($start_commission);
		if($end_commission) $this->req->setEndCommissionrate($end_commission);
		if($start_credit) $this->req->setStartCredit($start_credit);
		if($end_credit) $this->req->setEndCredit($end_credit);
		if($page_no) $this->req->setPageNo($page_no);
		
		$resp = $this->top->execute($this->req);
		if($resp && isset($resp['taobaoke_shops']['taobaoke_shop']))
		{
			$paginate = $this->_get_page_nav($resp['total_results'],$page_no,$page_size);
			$data = array(
				'paginate' => $paginate
			);
			if(isset($resp['taobaoke_shops']['taobaoke_shop']['shop_title']))
			$data['query'] = array($resp['taobaoke_shops']['taobaoke_shop']);
			else $data['query'] = $resp['taobaoke_shops']['taobaoke_shop'];
			echo $this->load->view(TPL_FOLDER.'get_search_shop',$data,true);
		}
		else
		{
			echo '很抱歉搜索不到您要的店铺，请修改搜索条件，重新提交';
		}
	}
	
	function get_search_goods()
	{
		$keyword = unescape($this->input->post('keyword'));
		$cid = $this->input->post('cid');
		$start_commission = $this->input->post('start_commission');
		$end_commission = $this->input->post('end_commission');
		$start_credit = $this->input->post('start_credit');
		$end_credit = $this->input->post('end_credit');
		$page_no = $this->input->post('page_no');
		$page_size = 20;
		if( ! $page_no) $page_no = 1;
		
		$this->load->library('top/TaobaokeItemsGetRequest','','req');
		$this->req->setFields('num_iid,title,pic_url,price,click_url,commission,commission_num');
		$this->req->setPageSize($page_size);
		if($keyword) $this->req->setKeyword($keyword);
		if($cid) $this->req->setCid($cid);
		if($start_commission) $this->req->setStartCommissionrate($start_commission);
		if($end_commission) $this->req->setEndCommissionrate($end_commission);
		if($start_credit) $this->req->setStartCredit($start_credit);
		if($end_credit) $this->req->setEndCredit($end_credit);
		if($page_no) $this->req->setPageNo($page_no);
		$this->req->setSort('commissionNum_desc');
		
		$resp = $this->top->execute($this->req);
		if($resp && isset($resp['taobaoke_items']['taobaoke_item']))
		{
			$paginate = $this->_get_page_nav($resp['total_results'],$page_no,$page_size);
			$data = array(
				'paginate' => $paginate
			);
			if(isset($resp['taobaoke_items']['taobaoke_item']['num_iid']))
			$data['query'] = array($resp['taobaoke_items']['taobaoke_item']);
			else $data['query'] = $resp['taobaoke_items']['taobaoke_item'];
			echo $this->load->view(TPL_FOLDER.'get_search_goods',$data,true);
		}
		else
		{
			echo '很抱歉搜索不到您要的商品，请修改搜索条件，重新提交';
		}
	}
	
	function _get_page_nav($t,$c,$p)
	{
		$str = '';
		if( ! $c) $c = 1;
		if($t > 0 && $p > 0)
		{
			$page_total = ceil($t / $p) ;
			if( $page_total >= 99) $page_total = 99;
			if($c > $page_total) $c = $page_total;
			if($page_total > 1)
			{
				if(($s = $c - 4) < 0) $s = 1;
				if(($e = $c + 4) > $page_total) $e = $page_total;
				if($c > 1) $str .= '<a href="javascript:get_tb_data(1)">&lsaquo; 首页 </a> &nbsp;&nbsp; ';
				if($c > 1) $str .= '<a href="javascript:get_tb_data('.($c-1).')">上一页</a> &nbsp;&nbsp; ';
				for($i = $s; $i <= $e ; $i++)
				{
					if($i == $c) $str .= '<a href="javascript:get_tb_data('.$i.')" style="color:#FF0000">'.$i.'</a> &nbsp; ';
					else $str .= '<a href="javascript:get_tb_data('.$i.')">'.$i.'</a> &nbsp; ';
				}
				if($c < $page_total) $str .= '<a href="javascript:get_tb_data('.($c+1).')">下一页</a> &nbsp;&nbsp; ';
				if($c < $page_total) $str .= '<a href="javascript:get_tb_data('.$page_total.')">尾页  &rsaquo; </a>';
			}
		}
		$str .= '总共找到： '.$t.' 条记录.';
		return $str;
	}
}
?>