<?php if( ! defined('BASEPATH')) exit('No direct script access allowed');
class News_model extends Model
{
	function News_model()
	{
		parent::Model();
	}
	
	function add_record($f_path,$more_pic)
	{
		$data=array(
			'title'=>filter_str($this->input->post("title")),
			'catalog_id'=>$this->input->post("catalog_id"),
			'seqorder'=>$this->input->post("seqorder"),
			'keyword'=>filter_str($this->input->post("keyword")),
			'description'=>filter_str($this->input->post("description")),
			'is_trash'=>$this->input->post('is_trash')?1:0,
			'tpl'=>$this->input->post('tpl'),
			'is_push'=>$this->input->post('is_push')?1:0,
			'summary'=>$this->input->post("summary"),
			'author'=>filter_str($this->input->post("author")),
			'source'=>filter_str($this->input->post("source")),
			'content'=>$this->input->post("content"),
			'create_date'=>strtotime($this->input->post("create_date"))
		);
		if($f_path['file_path'])
		{
			$data['pic_path']=$f_path['file_path'];
		}
		else
		{
			$data['pic_path']=$this->input->post("pic_path");
		}
		$this->db->insert("shop_news",$data);
		$nid = $this->db->insert_id();
		$num_iid = $this->input->post('num_iid');
		$gtitle = $this->input->post('gtitle');
		$pic_url = $this->input->post('pic_url');
		$click_url = $this->input->post('click_url');
		$price = $this->input->post('price');
		$i = 0;
		if(is_array($num_iid))
		{
			foreach($num_iid as $v)
			{
				$data = array(
					'nid' => $nid,
					'num_iid' => $v,
					'title' => $gtitle[$i],
					'pic_url' => $pic_url[$i],
					'click_url' => $click_url[$i],
					'price' => $price[$i]
				);
				$i++;
				$this->db->insert("shop_news_goods",$data);
			}
		}
		if( ! empty($more_pic))
		{
			foreach($more_pic as $pic_row)
			{
				$pic_row['nid']=$nid;
				$this->db->insert("shop_news_image",$pic_row);
			}
		}
		return TRUE;
	}
	
	function get_record($id)
	{
		$query=$this->db->get_where("shop_news",array('id'=>$id));
		if($query->num_rows()>0)
		{
			return $query->row_array();
		}
	}
	
	function get_catalog_records()
	{
		return $this->parse_catalog(0);
	}
	
	function sort_record()
	{
		$rd_id=$this->input->post("rd_id");
		if(!is_array($rd_id))
		{
			return FALSE;
		}
		foreach($rd_id as $row)
		{
			$sort_value=$this->input->post("sort".$row)?(int)$this->input->post("sort".$row):0;
			$this->db->update("shop_news",array('seqorder'=>$sort_value),array('id'=>$row));
		}
		return TRUE;
	}
	
	function save_record($f_path,$more_pic)
	{
		$rd_id=$this->input->post("rd_id");
		
		$data=array(
			'title'=>filter_str($this->input->post("title")),
			'catalog_id'=>$this->input->post("catalog_id"),
			'seqorder'=>$this->input->post("seqorder"),
			'keyword'=>filter_str($this->input->post("keyword")),
			'description'=>filter_str($this->input->post("description")),
			'author'=>filter_str($this->input->post("author")),
			'source'=>filter_str($this->input->post("source")),
			'summary'=>$this->input->post("summary"),
			'tpl'=>$this->input->post('tpl'),
			'is_push'=>$this->input->post('is_push')?1:0,
			'is_create'=>0,
			'is_trash'=>$this->input->post('is_trash')?1:0,
			'create_date'=>strtotime($this->input->post("create_date")),
			'content'=>$this->input->post("content")
		);
		if($f_path['file_path'])
		{
			$data['pic_path']=$f_path['file_path'];
		}
		else
		{
			$data['pic_path']=$this->input->post("pic_path");
		}
		$this->db->update("shop_news",$data,array('id'=>$rd_id));
		
		$this->db->simple_query('DELETE FROM '.$this->db->dbprefix.'shop_news_goods WHERE nid = '.$rd_id);
		$num_iid = $this->input->post('num_iid');
		$gtitle = $this->input->post('gtitle');
		$pic_url = $this->input->post('pic_url');
		$click_url = $this->input->post('click_url');
		$price = $this->input->post('price');
		$i = 0;
		if(is_array($num_iid))
		{
			foreach($num_iid as $v)
			{
				$data = array(
					'nid' => $rd_id,
					'num_iid' => $v,
					'title' => $gtitle[$i],
					'pic_url' => $pic_url[$i],
					'click_url' => $click_url[$i],
					'price' => $price[$i]
				);
				$i++;
				$this->db->insert("shop_news_goods",$data);
			}
		}
		if(!empty($more_pic))
		{
			foreach($more_pic as $pic_row)
			{
				$pic_row['nid']=$rd_id;
				$this->db->insert("shop_news_image",$pic_row);
			}
		}
		return TRUE;
	}
	
	function save_copy_record($f_path,$more_pic)
	{
		$data=array(
			'title'=>filter_str($this->input->post("title")),
			'catalog_id'=>$this->input->post("catalog_id"),
			'seqorder'=>$this->input->post("seqorder"),
			'keyword'=>filter_str($this->input->post("keyword")),
			'description'=>filter_str($this->input->post("description")),
			'author'=>filter_str($this->input->post("author")),
			'source'=>filter_str($this->input->post("source")),
			'summary'=>$this->input->post("summary"),
			'tpl'=>$this->input->post('tpl'),
			'is_push'=>$this->input->post('is_push')?1:0,
			'is_trash'=>$this->input->post('is_trash')?1:0,
			'create_date'=>strtotime($this->input->post("create_date")),
			'content'=>$this->input->post("content")
		);
		if($f_path['file_path'])
		{
			$data['pic_path']=$f_path['file_path'];
		}
		else
		{
			$data['pic_path']=$this->input->post("pic_path");
		}
		$this->db->insert("shop_news",$data);
		$nid = $this->db->insert_id();
		$num_iid = $this->input->post('num_iid');
		$gtitle = $this->input->post('gtitle');
		$pic_url = $this->input->post('pic_url');
		$click_url = $this->input->post('click_url');
		$price = $this->input->post('price');
		$i = 0;
		if(is_array($num_iid))
		{
			foreach($num_iid as $v)
			{
				$data = array(
					'nid' => $nid,
					'num_iid' => $v,
					'title' => $gtitle[$i],
					'pic_url' => $pic_url[$i],
					'click_url' => $click_url[$i],
					'price' => $price[$i]
				);
				$i++;
				$this->db->insert("shop_news_goods",$data);
			}
		}
		if(!empty($more_pic))
		{
			foreach($more_pic as $pic_row)
			{
				$pic_row['nid']=$nid;
				$this->db->insert("shop_news_image",$pic_row);
			}
		}
		return TRUE;
	}
	
	function put_in_trash()
	{
		$rd_id=$this->input->post("rd_id");
		if(!is_array($rd_id))
		{
			return FALSE;
		}
		$this->db->where_in("id",$rd_id);
		$this->db->update('shop_news',array('is_trash'=>1));
		return TRUE;
	}
	
	function trash_back()
	{
		$rd_id=$this->input->post("rd_id");
		if(!is_array($rd_id))
		{
			return FALSE;
		}
		$this->db->where_in("id",$rd_id);
		$this->db->update('shop_news',array('is_trash'=>0));
		return TRUE;
	}
	
	function del_record()
	{
		$rd_id=$this->input->post("rd_id");
		if(!is_array($rd_id))
		{
			return FALSE;
		}
		$this->db->where_in("id",$rd_id);
		$this->db->delete("shop_news");
		$this->db->where_in("nid",$rd_id);
		$this->db->delete("shop_news_goods");
		$this->db->where_in("nid",$rd_id);
		$this->db->delete("shop_news_image");
		foreach($rd_id as $id)
		{
			@unlink(create_link($id,'x'));
		}
		return TRUE;
	}
	
	function to_catalog()
	{
		$rd_id=$this->input->post("rd_id");
		if(!is_array($rd_id))
		{
			return FALSE;
		}
		$data=array(
			'catalog_id'=>$this->input->post('to_catalog_id')
		);
		$this->db->where_in("id",$rd_id);
		$this->db->update('shop_news',$data);
		return TRUE;
	}
	
	
	function get_trash_num()
	{
		$this->db->where('is_trash',1);
		$this->db->from('shop_news');
		return $this->db->count_all_results();
	}
	
	function parse_catalog($id)
	{
		static $catalog_arr=array();
		$this->db->where('parent_id',$id);
		$this->db->order_by('seqorder','desc');
		$this->db->order_by('id','desc');
		$query=$this->db->get("shop_news_catalog");
		foreach($query->result() as $row)
		{
			$catalog_arr[]=$row;
			if($row->is_has_chd==1)
			{
				$this->parse_catalog($row->id);
			}
		}
		return $catalog_arr;
	}
	
	function ajax_del_more_pic($rd_id)
	{
		$this->db->where("id",$rd_id);
		$this->db->delete("shop_news_image");
		if($this->db->affected_rows())
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
}
?>