--
-- 数据库: `db_taokecms`
--

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_admin`
--

DROP TABLE IF EXISTS `{dbprefix}shop_admin`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_admin` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `user_name` varchar(50) NOT NULL default '',
  `password` varchar(50) NOT NULL default '',
  `email` varchar(255) NOT NULL default '',
  `user_role` tinyint(1) unsigned NOT NULL default '0',
  `user_limit` varchar(255) default NULL,
  `last_login_ip` varchar(50) default NULL,
  `last_login_time` int(10) unsigned default NULL,
  `hits` int(10) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `user_name` (`user_name`),
  KEY `password` (`password`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

--
-- 转存表中的数据 `{dbprefix}shop_admin`
--

INSERT INTO `{dbprefix}shop_admin` (`id`, `user_name`, `password`, `email`, `user_role`, `user_limit`, `last_login_ip`, `last_login_time`, `hits`, `create_date`) VALUES
(12, 'admin', '1df8b2ec4926b9cd2c5022304430f861', 'admin@admin.com', 1, '0', '192.168.1.168', 1351586655, 8, 1350800543);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_ads`
--

DROP TABLE IF EXISTS `{dbprefix}shop_ads`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_ads` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `width` smallint(5) unsigned NOT NULL default '0',
  `height` smallint(5) unsigned NOT NULL default '0',
  `is_pic` tinyint(1) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `remark` varchar(50) default NULL,
  `hplink` varchar(500) default NULL,
  `file_path` varchar(255) default NULL,
  `js_code` text,
  PRIMARY KEY  (`id`),
  KEY `is_pic` (`is_pic`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `{dbprefix}shop_ads`
--

INSERT INTO `{dbprefix}shop_ads` (`id`, `width`, `height`, `is_pic`, `title`, `remark`, `hplink`, `file_path`, `js_code`) VALUES
(1, 950, 100, 1, '秋装新品', '首页-顶部通栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxn%2F7bvn0ay1GG3mL4l6gTCGFAA3W2Bjmp%2Bnk%2BoYOCTDmUs2wX%2B%2Bq2AdJklR75pXajpk8HKgXx3eWapPq%2Bph9gGXgUs7FxrAgKCGMqlPspBUG5JxjI5bDBpY88UpXUGtvUrToyW6XAnPYNjrug0Xg3OcKkYKVfdbqDA%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/5e57c3e07349d3cb4edb77e3fcc4c5aa.jpg', ''),
(2, 950, 100, 1, '秋装', '文章列表页-顶部通栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxn%2F7bvn0ay1GG3mL4lxblLA0HStYonuCHVWAHtspuHWUnQV1CZ5dkITbSPL1N%2BDHakKsxJdIT4vKHY8avVXakStReevH79nL6w9fusEt%2B84DmDijccUl6578vcW%2Foijd1259WWet7gMlKeubgSPHb2mO%2BeDV1z2pDw%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/d77fb11af72ea272c5530fb55c274da0.jpg', ''),
(3, 228, 246, 1, '39.8包邮', '文章列表页-右栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxn%2F7bvn0ay1GG3mJE%2B3OnGtVRSv3J6u%2BH9tALg3Nk6buS9BGFb2mtQf9ZW2kKr2yHfHZ1t5O2j1pXCxx086j0e79FNVpCifuEEhFTzZTAs6k11gxOuuFzCWSXyDPcfVU8VVu3bjU%2B9x3rSFUaXpoqoQKc8dr4O9rMA%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/c16454b4a7829850e15f65358d1dcc1f.jpg', ''),
(4, 950, 100, 1, '这个秋季与众不同', '文章详细页-顶部通栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxn%2F7bvn0ay1GG3mL4lxblLA0HStYonuCHVWAHtspuHWUnQV1CZ5dkITbSPL1N%2BDHakk%2B9eJ38qqG%2ByNqam8BdS2zbIbW3MM7dcx6Ct6u4q3lHxGO8K0%2BZhhcGHQaANp3D4M9HUuPXmSvgpFjlXuAKZ2VHFELakle%2Bg%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/d55a3d2b07b29cefaeb6b33ef6434f37.jpg', ''),
(5, 228, 246, 1, '包邮专区', '文章详细页-右栏', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CFcRfH0G7DbPkiN9MMOClUnYruwzjfERu4rfPw6lYRCEa8EsODyedzIKQfROUgG4Mm0r%2BHrOxH7trCZRMlpzrD1qJmkGNk1zjmCbqeCcc2bD63LSPkLltD0nOnoBouL3ssIxb89ayWdh65Vybu0O5j0%2Bkv9UNmDSM46C5jh2A%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/c16454b4a7829850e15f65358d1dcc1f.jpg', '');

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_email_template`
--

DROP TABLE IF EXISTS `{dbprefix}shop_email_template`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_email_template` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `shuo_ming` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `status` tinyint(3) unsigned NOT NULL default '0',
  `content` text,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

--
-- 转存表中的数据 `{dbprefix}shop_email_template`
--

INSERT INTO `{dbprefix}shop_email_template` (`id`, `shuo_ming`, `title`, `status`, `content`) VALUES
(1, '管理员忘记密码', '您的后台管理员新密码', 1, '<p>您好!<br />\n您于 {tpl_send_time} 修改了后台管理员密码<br />\n管理员帐号： {tpl_user_name}<br />\n修改后的新密码为：{tpl_user_password}<br />\n登陆地址：<a target="_blank" href="{tpl_admin_login_url}">{tpl_admin_login_url}</a><br />\n温馨提示：建议您尽快登录网站管理后台,并重新设置您的管理密码。</p>');

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_flash`
--

DROP TABLE IF EXISTS `{dbprefix}shop_flash`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_flash` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL default '',
  `hplink` varchar(500) default NULL,
  `pic_path` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=5 ;

--
-- 转存表中的数据 `{dbprefix}shop_flash`
--

INSERT INTO `{dbprefix}shop_flash` (`id`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES
(2, '小外套', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxn%2F7bvn0ay1GG3mJE%2BtQwP4Y%2BZbTzh2cle0WodL%2FNscp0%2Fi7plD7iwuIASyfSvaaTjYym%2Fc%2BPgiCcbjNxbl%2BzpZz87Ok8oCaNPAE68j0qJLQUFmDQ1PkqmOwsP%2ByBoJOAGpVNt%2BQVignF1wyz0pQl3V1s6FhOJ8cmA%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/2e800c40425447f551d5d5a1bb7de157.jpg', 0),
(3, '毛衣风暴', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CFcRfH0G7DbPkiN9MMOClUlRS9FI3A1qno1%2BzHot3TKOM4kpD5HccyOJT20wavWVjXFhVLy0EO%2Bjnf3UJxj0w45hRnNRovNOZeu4Ry%2BVchqMUN4hy%2BZEljky2BvuWKGmNbDs6Flziu%2BJizXvBnEK8%2B3cDsqLaNq5WoDO7IzpA%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/7f340771b4197053f892a47d83ceb9ab.jpg', 0),
(4, '光感丝绒', 'http://s.click.taobao.com/t?e=zGU34CA7K%2BPkqB07S4%2FK0CITy7klxn%2F7bvn0ay1GG3mJFWs2hc%2Fnqk%2FvlMWilyFaYqcFe%2BT1kDEjF9TLMmv9jCaaKXqwIHMb3jrBHgfuVfi6ZEaYpcmf%2FYils0w%2B7VPtI8QJcoQmw68LX9CKrwWk0jaXitQyZ8lELJjuLvjt1mJ38UHzcf7W4EOSVZ9BAw%3D%3D&spm=2014.12274879.1.0', 'uploadfiles/images/20121028/080906d4cf42101b9ff60411a87f78ad.jpg', 0);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_industry_catalog`
--

DROP TABLE IF EXISTS `{dbprefix}shop_industry_catalog`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_industry_catalog` (
  `id` bigint(20) unsigned NOT NULL default '0',
  `cat_name` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `parent_id` bigint(20) unsigned NOT NULL default '0',
  `deep_id` tinyint(2) unsigned NOT NULL default '0',
  `queue` varchar(255) NOT NULL default '0',
  `is_has_chd` tinyint(1) unsigned NOT NULL default '0',
  KEY `id` (`id`),
  KEY `is_has_chd` (`is_has_chd`),
  KEY `parent_id` (`parent_id`),
  KEY `queue` (`queue`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- 转存表中的数据 `{dbprefix}shop_industry_catalog`
--

INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50025707, '景点门票/度假线路/旅游服务', 66, 0, 0, ',50025707,', 1),
(30, '男装', 2, 0, 0, ',30,', 1),
(50008164, '住宅家具', 65, 0, 0, ',50008164,', 1),
(50020611, '商业/办公家具', 64, 0, 0, ',50020611,', 1),
(50023904, '国货精品数码', 19, 0, 0, ',50023904,', 1),
(50010788, '彩妆/香水/美妆工具', 10, 0, 0, ',50010788,', 1),
(1801, '美容护肤/美体/精油', 11, 0, 0, ',1801,', 1),
(1512, '手机', 15, 0, 0, ',1512,', 0),
(14, '数码相机/单反相机/摄像机', 18, 0, 0, ',14,', 1),
(1201, 'MP3/MP4/iPod/录音笔', 62, 0, 0, ',1201,', 0),
(1101, '笔记本电脑', 16, 0, 0, ',1101,', 0),
(50019780, '平板电脑/MID', 17, 0, 0, ',50019780,', 0),
(50018222, '台式机/一体机/服务器', 60, 0, 0, ',50018222,', 1),
(11, '电脑硬件/显示器/电脑周边', 12, 0, 0, ',11,', 1),
(50018264, '网络设备/网络相关', 59, 0, 0, ',50018264,', 1),
(50008090, '3C数码配件市场', 58, 0, 0, ',50008090,', 1),
(50012164, '闪存卡/U盘/存储/移动硬盘', 57, 0, 0, ',50012164,', 1),
(50007218, '办公设备/耗材/相关服务', 56, 0, 0, ',50007218,', 1),
(50022125, '水族马尾绣', 0, 50021971, 3, ',50020857,50021045,50021971,50022125,', 0),
(50022703, '大家电', 54, 0, 0, ',50022703,', 1),
(50011972, '影音电器', 55, 0, 0, ',50011972,', 1),
(50012100, '生活电器', 20, 0, 0, ',50012100,', 1),
(50012082, '厨房电器', 21, 0, 0, ',50012082,', 1),
(50002768, '个人护理/保健/按摩器材', 53, 0, 0, ',50002768,', 1),
(27, '家装主材', 52, 0, 0, ',27,', 1),
(50020332, '基础建材', 51, 0, 0, ',50020332,', 1),
(50020485, '五金/工具', 50, 0, 0, ',50020485,', 1),
(50020579, '电子/电工', 49, 0, 0, ',50020579,', 1),
(50020808, '家居饰品', 48, 0, 0, ',50020808,', 1),
(50011949, '特价酒店/特色客栈/公寓旅馆', 47, 0, 0, ',50011949,', 1),
(21, '居家日用/婚庆/创意礼品', 46, 0, 0, ',21,', 1),
(50016349, '厨房/餐饮用具', 45, 0, 0, ',50016349,', 1),
(50016348, '清洁/卫浴/收纳/整理用具', 44, 0, 0, ',50016348,', 1),
(50008163, '床上用品/布艺软饰', 43, 0, 0, ',50008163,', 1),
(35, '奶粉/辅食/营养品', 42, 0, 0, ',35,', 1),
(50014812, '尿片/洗护/喂哺/推车床', 41, 0, 0, ',50014812,', 1),
(50022517, '孕妇装/孕产妇用品/营养', 40, 0, 0, ',50022517,', 1),
(50008165, '童装/童鞋/亲子装', 8, 0, 0, ',50008165,', 1),
(50020276, '品牌保健品', 39, 0, 0, ',50020276,', 0),
(50020275, '传统滋补品/其他保健营养品', 38, 0, 0, ',50020275,', 1),
(50002766, '零食/坚果/茶叶/特产', 15, 0, 0, ',50002766,', 1),
(50016422, '粮油/蔬果/水产/速食', 37, 0, 0, ',50016422,', 1),
(50022123, '仡佬族藤编', 2, 50021969, 3, ',50020857,50021045,50021969,50022123,', 0),
(50010728, '运动/瑜伽/健身/球迷用品', 36, 0, 0, ',50010728,', 1),
(50013886, '户外/登山/野营/旅行用品', 35, 0, 0, ',50013886,', 1),
(50011699, '运动服/运动包/颈环配件', 34, 0, 0, ',50011699,', 1),
(50022122, '仡佬族剪纸', 1, 50021969, 3, ',50020857,50021045,50021969,50022122,', 0),
(50022121, '仡佬族铁画', 0, 50021969, 3, ',50020857,50021045,50021969,50022121,', 0),
(50007216, '鲜花速递/花卉仿真/绿植园艺', 33, 0, 0, ',50007216,', 1),
(26, '汽车/用品/配件/改装/摩托', 32, 0, 0, ',26,', 1),
(50005700, '品牌手表/流行手表', 31, 0, 0, ',50005700,', 0),
(50011740, '流行男鞋', 5, 0, 0, ',50011740,', 1),
(16, '女装/女士精品', 1, 0, 0, ',16,', 1),
(50006843, '女鞋', 3, 0, 0, ',50006843,', 1),
(50006842, '箱包皮具/热销女包/男包', 7, 0, 0, ',50006842,', 1),
(1625, '女士内衣/男士内衣/家居服', 6, 0, 0, ',1625,', 1),
(50010404, '服饰配件/皮带/帽子/围巾', 14, 0, 0, ',50010404,', 1),
(50011397, '珠宝/钻石/翡翠/黄金', 30, 0, 0, ',50011397,', 1),
(28, 'ZIPPO/瑞士军刀/眼镜', 29, 0, 0, ',28,', 1),
(33, '书籍/杂志/报纸', 27, 0, 0, ',33,', 1),
(34, '音乐/影视/明星/音像', 28, 0, 0, ',34,', 1),
(50017300, '乐器/吉他/钢琴/配件', 26, 0, 0, ',50017300,', 1),
(29, '宠物/宠物食品及用品', 25, 0, 0, ',29,', 1),
(50012029, '运动鞋new', 13, 0, 0, ',50012029,', 1),
(50013864, '饰品/流行首饰/时尚饰品新', 9, 0, 0, ',50013864,', 1),
(50022120, '畲族编织物', 3, 50021968, 3, ',50020857,50021045,50021968,50022120,', 0),
(50022119, '畲族蜡染技', 2, 50021968, 3, ',50020857,50021045,50021968,50022119,', 0),
(50022118, '畲家银艺', 1, 50021968, 3, ',50020857,50021045,50021968,50022118,', 0),
(50022117, '畲族彩带', 0, 50021968, 3, ',50020857,50021045,50021968,50022117,', 0),
(50023575, '房产/租房/新房/二手房/委托服务', 23, 0, 0, ',50023575,', 1),
(50023717, 'OTC药品/医疗器械/隐形眼镜/计生用品', 22, 0, 0, ',50023717,', 1),
(50022116, '佤族木鼓', 1, 50021967, 3, ',50020857,50021045,50021967,50022116,', 0),
(50022115, '牦牛骨雕', 0, 50021967, 3, ',50020857,50021045,50021967,50022115,', 0),
(50024971, '新车/二手车', 63, 0, 0, ',50024971,', 1),
(50022114, '傈僳族古币装饰', 2, 50021966, 3, ',50020857,50021045,50021966,50022114,', 0),
(50022113, '傈僳族麻编工艺', 1, 50021966, 3, ',50020857,50021045,50021966,50022113,', 0),
(50022111, '黎锦', 4, 50021965, 3, ',50020857,50021045,50021965,50022111,', 0),
(50022110, '椰雕', 3, 50021965, 3, ',50020857,50021045,50021965,50022110,', 0),
(50022109, '麻编工艺', 2, 50021965, 3, ',50020857,50021045,50021965,50022109,', 0),
(50022108, '黎族酒海', 1, 50021965, 3, ',50020857,50021045,50021965,50022108,', 0),
(50022107, '黎族独木器', 0, 50021965, 3, ',50020857,50021045,50021965,50022107,', 0),
(50022106, '煤精', 3, 50021964, 3, ',50020857,50021045,50021964,50022106,', 0),
(50022105, '乡花', 2, 50021964, 3, ',50020857,50021045,50021964,50022105,', 0),
(50022104, '扳指', 1, 50021964, 3, ',50020857,50021045,50021964,50022104,', 0),
(50022103, '滕氏布糊画', 0, 50021964, 3, ',50020857,50021045,50021964,50022103,', 0),
(50022705, '朝鲜族手工刺绣', 2, 50021963, 3, ',50020857,50021045,50021963,50022705,', 0),
(50022102, '朝鲜族民俗工艺娃娃', 1, 50021963, 3, ',50020857,50021045,50021963,50022102,', 0),
(50022101, '朝鲜族葫芦工艺品', 0, 50021963, 3, ',50020857,50021045,50021963,50022101,', 0),
(50022100, '苗婆鱼银排圈、颈胸饰', 5, 50021962, 3, ',50020857,50021045,50021962,50022100,', 0),
(50022099, '布依族蜡染', 4, 50021962, 3, ',50020857,50021045,50021962,50022099,', 0),
(50022098, '布依族土花布', 3, 50021962, 3, ',50020857,50021045,50021962,50022098,', 0),
(50022097, '布依地毯', 2, 50021962, 3, ',50020857,50021045,50021962,50022097,', 0),
(50022096, '布依族花背带', 1, 50021962, 3, ',50020857,50021045,50021962,50022096,', 0),
(50022095, '绣花鞋', 0, 50021962, 3, ',50020857,50021045,50021962,50022095,', 0),
(50022092, '漆器（矮脚盘）', 4, 50021961, 3, ',50020857,50021045,50021961,50022092,', 0),
(50022091, '制陶工艺', 3, 50021961, 3, ',50020857,50021045,50021961,50022091,', 0),
(50022090, '刺绣', 2, 50021961, 3, ',50020857,50021045,50021961,50022090,', 0),
(50022089, '银器工艺', 1, 50021961, 3, ',50020857,50021045,50021961,50022089,', 0),
(50022088, '擀毡', 0, 50021961, 3, ',50020857,50021045,50021961,50022088,', 0),
(50022087, '胡西它尔', 8, 50021960, 3, ',50020857,50021045,50021960,50022087,', 0),
(50022086, '都塔尔', 7, 50021960, 3, ',50020857,50021045,50021960,50022086,', 0),
(50022085, '维吾尔刺绣', 6, 50021960, 3, ',50020857,50021045,50021960,50022085,', 0),
(50022084, '沙玛瓦', 5, 50021960, 3, ',50020857,50021045,50021960,50022084,', 0),
(50022083, '沙木沙克小刀', 4, 50021960, 3, ',50020857,50021045,50021960,50022083,', 0),
(50022082, '维吾尔族花帽', 3, 50021960, 3, ',50020857,50021045,50021960,50022082,', 0),
(50022081, '艾德莱斯绸', 2, 50021960, 3, ',50020857,50021045,50021960,50022081,', 0),
(50022080, '维吾尔族土陶', 1, 50021960, 3, ',50020857,50021045,50021960,50022080,', 0),
(50022079, '维吾尔族挂毯', 0, 50021960, 3, ',50020857,50021045,50021960,50022079,', 0),
(50022078, '回族头饰', 6, 50021959, 3, ',50020857,50021045,50021959,50022078,', 0),
(50022077, '回族太斯必哈', 5, 50021959, 3, ',50020857,50021045,50021959,50022077,', 0),
(50022076, '回族漆器工艺屏风', 4, 50021959, 3, ',50020857,50021045,50021959,50022076,', 0),
(50022075, '回族贺兰石', 3, 50021959, 3, ',50020857,50021045,50021959,50022075,', 0),
(50022074, '麦加圣地经文盘', 2, 50021959, 3, ',50020857,50021045,50021959,50022074,', 0),
(50022073, '穆斯林工艺项链', 1, 50021959, 3, ',50020857,50021045,50021959,50022073,', 0),
(50022072, '阿拉伯经书盒', 0, 50021959, 3, ',50020857,50021045,50021959,50022072,', 0),
(50022660, '其他', 8, 50021958, 3, ',50020857,50021045,50021958,50022660,', 0),
(50022071, '蒙古族别致腰带', 7, 50021958, 3, ',50020857,50021045,50021958,50022071,', 0),
(50022070, '蒙古族佩饰', 6, 50021958, 3, ',50020857,50021045,50021958,50022070,', 0),
(50022069, '蒙古皮画', 5, 50021958, 3, ',50020857,50021045,50021958,50022069,', 0),
(50022068, '蒙古碗', 4, 50021958, 3, ',50020857,50021045,50021958,50022068,', 0),
(50022067, '蒙古族皮囊酒壶', 3, 50021958, 3, ',50020857,50021045,50021958,50022067,', 0),
(50022066, '蒙古族鼻烟壶', 2, 50021958, 3, ',50020857,50021045,50021958,50022066,', 0),
(50022065, '蒙古刀', 1, 50021958, 3, ',50020857,50021045,50021958,50022065,', 0),
(50022064, '蒙古族竹雕画', 0, 50021958, 3, ',50020857,50021045,50021958,50022064,', 0),
(50022659, '其他', 6, 50021922, 3, ',50020857,50021045,50021922,50022659,', 0),
(50022063, '藏族曼扎盘', 5, 50021922, 3, ',50020857,50021045,50021922,50022063,', 0),
(50022062, '藏族唐卡', 4, 50021922, 3, ',50020857,50021045,50021922,50022062,', 0),
(50022061, '藏族哈达', 3, 50021922, 3, ',50020857,50021045,50021922,50022061,', 0),
(50022060, '藏族贲巴壶', 2, 50021922, 3, ',50020857,50021045,50021922,50022060,', 0),
(50022059, '西藏古代铜雕', 1, 50021922, 3, ',50020857,50021045,50021922,50022059,', 0),
(50022058, '藏族绘画', 0, 50021922, 3, ',50020857,50021045,50021922,50022058,', 0),
(50022057, '壮绣', 4, 50021921, 3, ',50020857,50021045,50021921,50022057,', 0),
(50022056, '壮族儿帽', 3, 50021921, 3, ',50020857,50021045,50021921,50022056,', 0),
(50022055, '壮族花山崖壁画', 2, 50021921, 3, ',50020857,50021045,50021921,50022055,', 0),
(50022054, '铜鼓', 1, 50021921, 3, ',50020857,50021045,50021921,50022054,', 0),
(50022053, '壮锦', 0, 50021921, 3, ',50020857,50021045,50021921,50022053,', 0),
(50022658, '其他', 3, 50021920, 3, ',50020857,50021045,50021920,50022658,', 0),
(50022050, '傣锦', 2, 50021920, 3, ',50020857,50021045,50021920,50022050,', 0),
(50022049, '傣家竹编', 1, 50021920, 3, ',50020857,50021045,50021920,50022049,', 0),
(50022048, '傣族挂包', 0, 50021920, 3, ',50020857,50021045,50021920,50022048,', 0),
(50022657, '其他', 3, 50021919, 3, ',50020857,50021045,50021919,50022657,', 0),
(50022047, '哈萨克族雕刻', 2, 50021919, 3, ',50020857,50021045,50021919,50022047,', 0),
(50022046, '哈萨克族刺绣', 1, 50021919, 3, ',50020857,50021045,50021919,50022046,', 0),
(50022045, '哈萨克族花毡', 0, 50021919, 3, ',50020857,50021045,50021919,50022045,', 0),
(50022656, '其他', 3, 50021918, 3, ',50020857,50021045,50021918,50022656,', 0),
(50022044, '白族草编工艺', 2, 50021918, 3, ',50020857,50021045,50021918,50022044,', 0),
(50022043, '白族扎染', 1, 50021918, 3, ',50020857,50021045,50021918,50022043,', 0),
(50022042, '白族木雕', 0, 50021918, 3, ',50020857,50021045,50021918,50022042,', 0),
(50022655, '其他', 8, 50021917, 3, ',50020857,50021045,50021917,50022655,', 0),
(50022041, '苗族长角帽', 7, 50021917, 3, ',50020857,50021045,50021917,50022041,', 0),
(50022040, '苗族剪纸', 6, 50021917, 3, ',50020857,50021045,50021917,50022040,', 0),
(50022039, '苗族泥哨', 5, 50021917, 3, ',50020857,50021045,50021917,50022039,', 0),
(50022038, '苗族马尾斗笠', 4, 50021917, 3, ',50020857,50021045,50021917,50022038,', 0),
(50022037, '苗族挑花', 3, 50021917, 3, ',50020857,50021045,50021917,50022037,', 0),
(50022036, '苗族织锦', 2, 50021917, 3, ',50020857,50021045,50021917,50022036,', 0),
(50022035, '苗族蜡染', 1, 50021917, 3, ',50020857,50021045,50021917,50022035,', 0),
(50022034, '苗族银饰', 0, 50021917, 3, ',50020857,50021045,50021917,50022034,', 0),
(50021850, '电子巡更系统', 8, 50021841, 3, ',27,50021794,50021841,50021850,', 0),
(50021849, '停车场控制机/道闸', 7, 50021841, 3, ',27,50021794,50021841,50021849,', 0),
(50021848, '排队机/叫号器', 6, 50021841, 3, ',27,50021794,50021841,50021848,', 0),
(50021847, '门禁机', 5, 50021841, 3, ',27,50021794,50021841,50021847,', 0),
(50021846, '门禁智能卡', 4, 50021841, 3, ',27,50021794,50021841,50021846,', 0),
(50021845, '门禁读卡器', 3, 50021841, 3, ',27,50021794,50021841,50021845,', 0),
(50021844, '楼宇对讲设备', 2, 50021841, 3, ',27,50021794,50021841,50021844,', 0),
(50021843, '楼层显示器', 1, 50021841, 3, ',27,50021794,50021841,50021843,', 0),
(50021842, '电控锁', 0, 50021841, 3, ',27,50021794,50021841,50021842,', 0),
(50006050, '置物架', 7, 50021829, 3, ',27,50002409,50021829,50006050,', 0),
(50021834, '微波炉支架', 4, 50021829, 3, ',27,50002409,50021829,50021834,', 0),
(50021833, '锅盖架', 3, 50021829, 3, ',27,50002409,50021829,50021833,', 0),
(50021832, '刀架', 2, 50021829, 3, ',27,50002409,50021829,50021832,', 0),
(50021830, '支架挂钩', 0, 50021829, 3, ',27,50002409,50021829,50021830,', 0),
(50013355, '其它厨房配用件', 8, 50021820, 3, ',27,50002409,50021820,50013355,', 0),
(50021827, '厨用垃圾桶', 2, 50021820, 3, ',27,50002409,50021820,50021827,', 0),
(50021826, '米桶', 1, 50021820, 3, ',27,50002409,50021820,50021826,', 0),
(50021825, '拉篮', 0, 50021820, 3, ',27,50002409,50021820,50021825,', 0),
(50021819, '人体感应开关', 3, 50021815, 3, ',27,50021794,50021815,50021819,', 0),
(50021818, '电源控制器', 2, 50021815, 3, ',27,50021794,50021815,50021818,', 0),
(50021817, '家用场景面板', 1, 50021815, 3, ',27,50021794,50021815,50021817,', 0),
(50021816, '遥控开关', 0, 50021815, 3, ',27,50021794,50021815,50021816,', 0),
(50021814, '室内新风系统', 4, 50021809, 3, ',27,50021794,50021809,50021814,', 0),
(50021813, '窗帘电机控制系统', 3, 50021809, 3, ',27,50021794,50021809,50021813,', 0),
(50021812, '门窗控制器', 2, 50021809, 3, ',27,50021794,50021809,50021812,', 0),
(50021811, '地暖控制面板', 1, 50021809, 3, ',27,50021794,50021809,50021811,', 0),
(50021810, '空调控制面板', 0, 50021809, 3, ',27,50021794,50021809,50021810,', 0),
(50021808, '影音多媒体中央控制系统', 2, 50021805, 3, ',27,50021794,50021805,50021808,', 0),
(50021807, '背景音乐控制器', 1, 50021805, 3, ',27,50021794,50021805,50021807,', 0),
(50021806, '背景音乐主机', 0, 50021805, 3, ',27,50021794,50021805,50021806,', 0),
(50021804, '调光控制台', 2, 50021801, 3, ',27,50021794,50021801,50021804,', 0),
(50021803, '调光硅箱', 1, 50021801, 3, ',27,50021794,50021801,50021803,', 0),
(50021802, '调光面板', 0, 50021801, 3, ',27,50021794,50021801,50021802,', 0),
(50021800, '水槽套餐', 1, 50021798, 3, ',27,50002409,50021798,50021800,', 0),
(50006046, '水槽单品', 1, 50021798, 3, ',27,50002409,50021798,50006046,', 0),
(50006049, '沥水篮', 3, 50021793, 3, ',27,50002409,50021793,50006049,', 0),
(50021828, '沥水板', 3, 50021793, 3, ',27,50002409,50021793,50021828,', 0),
(50006047, '水槽皂液器', 3, 50021793, 3, ',27,50002409,50021793,50006047,', 0),
(50006048, '水槽下水器', 3, 50021793, 3, ',27,50002409,50021793,50006048,', 0),
(50022539, '剃须清洁刷', 65, 50009146, 2, ',50016348,50009146,50022539,', 0),
(50022556, '焗油工具', 70, 50009146, 2, ',50016348,50009146,50022556,', 0),
(50021623, '其他阀门', 6, 50021616, 3, ',50020485,50020490,50021616,50021623,', 0),
(50021622, '底阀', 5, 50021616, 3, ',50020485,50020490,50021616,50021622,', 0),
(50021621, '旋塞阀', 4, 50021616, 3, ',50020485,50020490,50021616,50021621,', 0),
(50021620, '截止阀', 3, 50021616, 3, ',50020485,50020490,50021616,50021620,', 0),
(50021619, '止回阀', 2, 50021616, 3, ',50020485,50020490,50021616,50021619,', 0),
(50021618, '闸阀', 1, 50021616, 3, ',50020485,50020490,50021616,50021618,', 0),
(50021617, '球阀', 0, 50021616, 3, ',50020485,50020490,50021616,50021617,', 0),
(50021287, '其他起重工具', 5, 50021267, 3, ',50020485,50020494,50021267,50021287,', 0),
(50021286, '卷扬机', 4, 50021267, 3, ',50020485,50020494,50021267,50021286,', 0),
(50021285, '升降台', 3, 50021267, 3, ',50020485,50020494,50021267,50021285,', 0),
(50021284, '起重滑车', 2, 50021267, 3, ',50020485,50020494,50021267,50021284,', 0),
(50021283, '起重钳', 1, 50021267, 3, ',50020485,50020494,50021267,50021283,', 0),
(50021282, '千斤顶', 0, 50021267, 3, ',50020485,50020494,50021267,50021282,', 0),
(50021281, '其他液压工具', 13, 50021266, 3, ',50020485,50020494,50021266,50021281,', 0),
(50021280, '法兰分离器', 12, 50021266, 3, ',50020485,50020494,50021266,50021280,', 0),
(50021279, '液压螺栓拉伸器', 11, 50021266, 3, ',50020485,50020494,50021266,50021279,', 0),
(50021278, '液压装卸车', 10, 50021266, 3, ',50020485,50020494,50021266,50021278,', 0),
(50021274, '螺帽破开器', 6, 50021266, 3, ',50020485,50020494,50021266,50021274,', 0),
(50021273, '钢丝绳切断机', 5, 50021266, 3, ',50020485,50020494,50021266,50021273,', 0),
(50021272, '液压开孔器', 4, 50021266, 3, ',50020485,50020494,50021266,50021272,', 0),
(50021271, '弯排机', 3, 50021266, 3, ',50020485,50020494,50021266,50021271,', 0),
(50021270, '液压弯管机', 2, 50021266, 3, ',50020485,50020494,50021266,50021270,', 0),
(50021269, '液压机/油压机', 1, 50021266, 3, ',50020485,50020494,50021266,50021269,', 0),
(50021268, '液压冲孔机/切排机', 0, 50021266, 3, ',50020485,50020494,50021266,50021268,', 0),
(50009249, '其它', 5, 50009246, 3, ',28,50000467,50009246,50009249,', 0),
(50009248, '充气打火机', 3, 50009246, 3, ',28,50000467,50009246,50009248,', 0),
(50009247, '一次性打火机', 1, 50009246, 3, ',28,50000467,50009246,50009247,', 0),
(290805, '煤油打火机', 0, 50009246, 3, ',28,50000467,50009246,290805,', 0),
(50009245, '通条', 0, 50009240, 3, ',28,2909,50009240,50009245,', 0),
(50009242, '烟斗清洁用品', 0, 50009240, 3, ',28,2909,50009240,50009242,', 0),
(50009244, '烟斗包', 0, 50009240, 3, ',28,2909,50009240,50009244,', 0),
(50009243, '烟刀', 0, 50009240, 3, ',28,2909,50009240,50009243,', 0),
(50009241, '压棒及相关工具', 0, 50009240, 3, ',28,2909,50009240,50009241,', 0),
(50008868, '老电影资料海报', 0, 50008864, 3, ',23,50001931,50008864,50008868,', 0),
(50008866, '电影道具/周边', 0, 50008864, 3, ',23,50001931,50008864,50008866,', 0),
(50008865, '电影拷贝', 0, 50008864, 3, ',23,50001931,50008864,50008865,', 0),
(50008867, '放映机', 0, 50008864, 3, ',23,50001931,50008864,50008867,', 0),
(50008592, '其它收藏品', 10, 50008584, 3, ',23,50001931,50008584,50008592,', 0),
(50009204, '战争军事纪念品', 9, 50008584, 3, ',23,50001931,50008584,50009204,', 0),
(50009198, '纪念品', 8, 50008584, 3, ',23,50001931,50008584,50009198,', 0),
(50008589, '军模/兵人', 7, 50008584, 3, ',23,50001931,50008584,50008589,', 0),
(50008586, '纪念军表', 6, 50008584, 3, ',23,50001931,50008584,50008586,', 0),
(50008591, '肩章/臂章/领章/略表/胸标', 5, 50008584, 3, ',23,50001931,50008584,50008591,', 0),
(50008588, '军帽/军包/鞋', 4, 50008584, 3, ',23,50001931,50008584,50008588,', 0),
(50008587, '国外军装/军服', 2, 50008584, 3, ',23,50001931,50008584,50008587,', 0),
(50008590, '徽章/纪念章', 1, 50008584, 3, ',23,50001931,50008584,50008590,', 0),
(50019378, '广告毛巾/礼品毛巾', 39, 50008260, 3, ',50008163,50012791,50008260,50019378,', 0),
(50019376, '桌布/桌旗定制定做', 37, 50008260, 3, ',50008163,50012791,50008260,50019376,', 0),
(50019375, '沙发垫/沙发套定制定做', 36, 50008260, 3, ',50008163,50012791,50008260,50019375,', 0),
(50019374, '凉席定制定做', 35, 50008260, 3, ',50008163,50012791,50008260,50019374,', 0),
(50019373, '床垫定制定做', 34, 50008260, 3, ',50008163,50012791,50008260,50019373,', 0),
(50019370, '被子/被芯定制', 33, 50008260, 3, ',50008163,50012791,50008260,50019370,', 0),
(290903, '套件定制', 32, 50008260, 3, ',50008163,50012791,50008260,290903,', 0),
(50008265, '其他定制', 7, 50008260, 3, ',50008163,50012791,50008260,50008265,', 0),
(50008264, '枕套定制', 5, 50008260, 3, ',50008163,50012791,50008260,50008264,', 0),
(50008263, '被套定制', 4, 50008260, 3, ',50008163,50012791,50008260,50008263,', 0),
(50008262, '床罩定制', 3, 50008260, 3, ',50008163,50012791,50008260,50008262,', 0),
(50008261, '靠垫定制', 1, 50008260, 3, ',50008163,50012791,50008260,50008261,', 0),
(50008093, '床单定制定做', 0, 50008260, 3, ',50008163,50012791,50008260,50008093,', 0),
(50008252, '其他', 11, 50008247, 3, ',50008163,50012791,50008247,50008252,', 0),
(50017193, '婴童凉席', 10, 50008247, 3, ',50008163,50012791,50008247,50017193,', 0),
(50017192, '婴童多件套', 8, 50008247, 3, ',50008163,50012791,50008247,50017192,', 0),
(50017191, '婴童床单/被套', 7, 50008247, 3, ',50008163,50012791,50008247,50017191,', 0),
(50008251, '婴童枕头/枕芯', 5, 50008247, 3, ',50008163,50012791,50008247,50008251,', 0),
(50019372, '婴童睡袋', 4, 50008247, 3, ',50008163,50012791,50008247,50019372,', 0),
(50008250, '婴童抱被/被子/毯子', 3, 50008247, 3, ',50008163,50012791,50008247,50008250,', 0),
(50008249, '婴童蚊帐', 2, 50008247, 3, ',50008163,50012791,50008247,50008249,', 0),
(50000512, '婴童四件套', 0, 50008247, 3, ',50008163,50012791,50008247,50000512,', 0),
(50008248, '婴童三件套', 0, 50008247, 3, ',50008163,50012791,50008247,50008248,', 0),
(50003123, '综合类菜谱', 4, 50008124, 3, ',33,50003112,50008124,50003123,', 0),
(50008121, '鲁菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008121,', 0),
(50008127, '鄂菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008127,', 0),
(50008125, '苏菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008125,', 0),
(50008126, '粤菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008126,', 0),
(50008137, '烹饪其它', 0, 50008124, 3, ',33,50003112,50008124,50008137,', 0),
(50008134, '烘焙Diy/点心制作', 0, 50008124, 3, ',33,50003112,50008124,50008134,', 0),
(50008133, '火锅制作', 0, 50008124, 3, ',33,50003112,50008124,50008133,', 0),
(50008128, '湘菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008128,', 0),
(50008131, '浙菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008131,', 0),
(50008132, '徽菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008132,', 0),
(50008138, '家常菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008138,', 0),
(50008123, '八大菜系', 0, 50008124, 3, ',33,50003112,50008124,50008123,', 0),
(50008122, '京菜制作', 0, 50008124, 3, ',33,50003112,50008124,50008122,', 0),
(50025795, '床刷', 14, 50007063, 3, ',50016348,50003949,50007063,50025795,', 0),
(50025794, '精密仪器刷', 13, 50007063, 3, ',50016348,50003949,50007063,50025794,', 0),
(50019046, '卫生间用刷', 12, 50007063, 3, ',50016348,50003949,50007063,50019046,', 0),
(50019045, '衣物用刷', 11, 50007063, 3, ',50016348,50003949,50007063,50019045,', 0),
(50007065, '其它', 10, 50007063, 3, ',50016348,50003949,50007063,50007065,', 0),
(50004413, '厨房用刷', 3, 50007063, 3, ',50016348,50003949,50007063,50004413,', 0),
(50000183, '化学其它', 8, 50007055, 3, ',33,50000177,50007055,50000183,', 0),
(50007058, '高分子化学', 0, 50007055, 3, ',33,50000177,50007055,50007058,', 0),
(50007059, '物理化学', 0, 50007055, 3, ',33,50000177,50007055,50007059,', 0),
(50007057, '有机化学', 0, 50007055, 3, ',33,50000177,50007055,50007057,', 0),
(50007056, '无机化学', 0, 50007055, 3, ',33,50000177,50007055,50007056,', 0),
(50007061, '应用化学', 0, 50007055, 3, ',33,50000177,50007055,50007061,', 0),
(50007060, '分析化学', 0, 50007055, 3, ',33,50000177,50007055,50007060,', 0),
(50001942, '其它', 20, 50006740, 3, ',50008163,290209,50006740,50001942,', 0),
(50003497, '纸巾盒/纸巾套', 13, 50006740, 3, ',50008163,290209,50006740,50003497,', 0),
(50006750, '首饰盒', 7, 50006740, 3, ',50008163,290209,50006740,50006750,', 0),
(50006744, '婴儿用品', 6, 50006740, 3, ',50008163,290209,50006740,50006744,', 0),
(50006822, '家居用品', 5, 50006740, 3, ',50008163,290209,50006740,50006822,', 0),
(50006749, '手机链/立体绣', 4, 50006740, 3, ',50008163,290209,50006740,50006749,', 0),
(50006743, '书签', 3, 50006740, 3, ',50008163,290209,50006740,50006743,', 0),
(50006742, '杯垫', 2, 50006740, 3, ',50008163,290209,50006740,50006742,', 0),
(50006741, '钥匙扣', 1, 50006740, 3, ',50008163,290209,50006740,50006741,', 0),
(50001944, '其它', 20, 50006732, 3, ',50008163,290209,50006732,50001944,', 0),
(50006828, '剪刀', 13, 50006732, 3, ',50008163,290209,50006732,50006828,', 0),
(50006748, '针扎针插', 12, 50006732, 3, ',50008163,290209,50006732,50006748,', 0),
(50006747, '线盒', 11, 50006732, 3, ',50008163,290209,50006732,50006747,', 0),
(50006745, '绕线板', 9, 50006732, 3, ',50008163,290209,50006732,50006745,', 0),
(50006739, '串珠针', 8, 50006732, 3, ',50008163,290209,50006732,50006739,', 0),
(50006746, '拆线器/拆线刀', 7, 50006732, 3, ',50008163,290209,50006732,50006746,', 0),
(50006738, '绣针', 6, 50006732, 3, ',50008163,290209,50006732,50006738,', 0),
(50006737, '水溶笔', 5, 50006732, 3, ',50008163,290209,50006732,50006737,', 0),
(50006736, '线号签/线号贴', 4, 50006732, 3, ',50008163,290209,50006732,50006736,', 0),
(50006734, '绣绷', 2, 50006732, 3, ',50008163,290209,50006732,50006734,', 0),
(50006733, '绣架', 1, 50006732, 3, ',50008163,290209,50006732,50006733,', 0),
(50005666, '计算机组成与系统结构', 0, 50005661, 3, ',33,3306,50005661,50005666,', 0),
(50005669, '硬件描述语言', 0, 50005661, 3, ',33,3306,50005661,50005669,', 0),
(50005665, '电路板/集成电路', 0, 50005661, 3, ',33,3306,50005661,50005665,', 0),
(50005670, '数字逻辑', 0, 50005661, 3, ',33,3306,50005661,50005670,', 0),
(50005664, '微机原理', 0, 50005661, 3, ',33,3306,50005661,50005664,', 0),
(50005673, '嵌入式开发', 0, 50005661, 3, ',33,3306,50005661,50005673,', 0),
(50005662, '单片机', 0, 50005661, 3, ',33,3306,50005661,50005662,', 0),
(50005668, 'DSP', 0, 50005661, 3, ',33,3306,50005661,50005668,', 0),
(50005667, 'BIOS', 0, 50005661, 3, ',33,3306,50005661,50005667,', 0),
(50005585, '软件项目管理', 0, 50005579, 3, ',33,3306,50005579,50005585,', 0),
(50005582, '软件需求分析与评估', 0, 50005579, 3, ',33,3306,50005579,50005582,', 0),
(50005581, '软件过程', 0, 50005579, 3, ',33,3306,50005579,50005581,', 0),
(50005589, '软件质量', 0, 50005579, 3, ',33,3306,50005579,50005589,', 0),
(50005588, '软件维护', 0, 50005579, 3, ',33,3306,50005579,50005588,', 0),
(50005587, '软件工程原理与软件开发', 0, 50005579, 3, ',33,3306,50005579,50005587,', 0),
(50005590, '软件安全性', 0, 50005579, 3, ',33,3306,50005579,50005590,', 0),
(50005583, 'ISO 9000', 0, 50005579, 3, ',33,3306,50005579,50005583,', 0),
(50005584, 'CMM', 0, 50005579, 3, ',33,3306,50005579,50005584,', 0),
(50005562, '高加索语系', 0, 50005552, 3, ',33,3331,50005552,50005562,', 0),
(50005567, '非洲诸语言', 0, 50005552, 3, ',33,3331,50005552,50005567,', 0),
(50005557, '阿尔泰语系', 0, 50005552, 3, ',33,3331,50005552,50005557,', 0),
(50005564, '闪-含语系', 0, 50005552, 3, ',33,3331,50005552,50005564,', 0),
(50005706, '语言文字其它', 0, 50005552, 3, ',33,3331,50005552,50005706,', 0),
(50005553, '语言学', 0, 50005552, 3, ',33,3331,50005552,50005553,', 0),
(50005568, '美洲诸语言', 0, 50005552, 3, ',33,3331,50005552,50005568,', 0),
(50005554, '汉语', 0, 50005552, 3, ',33,3331,50005552,50005554,', 0),
(50005556, '汉藏语系', 0, 50005552, 3, ',33,3331,50005552,50005556,', 0),
(50005570, '大洋洲诸语言', 0, 50005552, 3, ',33,3331,50005552,50005570,', 0),
(50005566, '印欧语系', 0, 50005552, 3, ',33,3331,50005552,50005566,', 0),
(50005560, '南岛语系', 0, 50005552, 3, ',33,3331,50005552,50005560,', 0),
(50005559, '南印语系', 0, 50005552, 3, ',33,3331,50005552,50005559,', 0),
(50005558, '南亚语系', 0, 50005552, 3, ',33,3331,50005552,50005558,', 0),
(50005563, '乌拉尔系', 0, 50005552, 3, ',33,3331,50005552,50005563,', 0),
(50005555, '中国少数民族语言', 0, 50005552, 3, ',33,3331,50005552,50005555,', 0),
(50005540, '芭蕾舞', 0, 50005529, 3, ',33,50000054,50005529,50005540,', 0),
(50005533, '舞蹈表演学', 0, 50005529, 3, ',33,50000054,50005529,50005533,', 0),
(50005546, '舞蹈组织、机构', 0, 50005529, 3, ',33,50000054,50005529,50005546,', 0),
(50005530, '舞蹈理论', 0, 50005529, 3, ',33,50000054,50005529,50005530,', 0),
(50005547, '舞蹈演出', 0, 50005529, 3, ',33,50000054,50005529,50005547,', 0),
(50005531, '舞蹈技术和方法', 0, 50005529, 3, ',33,50000054,50005529,50005531,', 0),
(50005536, '舞蹈图谱', 0, 50005529, 3, ',33,50000054,50005529,50005536,', 0),
(50005705, '舞蹈其它', 0, 50005529, 3, ',33,50000054,50005529,50005705,', 0),
(50005549, '舞蹈事业史', 0, 50005529, 3, ',33,50000054,50005529,50005549,', 0),
(50005534, '舞台美术、舞台技术', 0, 50005529, 3, ',33,50000054,50005529,50005534,', 0),
(50005532, '编导学', 0, 50005529, 3, ',33,50000054,50005529,50005532,', 0),
(50005548, '生活舞蹈', 0, 50005529, 3, ',33,50000054,50005529,50005548,', 0),
(50005537, '民间舞蹈、民族舞蹈', 0, 50005529, 3, ',33,50000054,50005529,50005537,', 0),
(50005542, '歌舞', 0, 50005529, 3, ',33,50000054,50005529,50005542,', 0),
(50005545, '各种舞剧', 0, 50005529, 3, ',33,50000054,50005529,50005545,', 0),
(50005539, '古典舞蹈', 0, 50005529, 3, ',33,50000054,50005529,50005539,', 0),
(50005535, '化装服装服饰', 0, 50005529, 3, ',33,50000054,50005529,50005535,', 0),
(50005544, '其它舞蹈', 0, 50005529, 3, ',33,50000054,50005529,50005544,', 0),
(50005538, '儿童舞蹈', 0, 50005529, 3, ',33,50000054,50005529,50005538,', 0),
(50005543, '交际舞', 0, 50005529, 3, ',33,50000054,50005529,50005543,', 0),
(50005421, '音乐理论', 0, 50005420, 3, ',33,50000054,50005420,50005421,', 0),
(50005422, '音乐物理学、音乐生理学', 0, 50005420, 3, ',33,50000054,50005420,50005422,', 0),
(50005430, '音乐工艺学', 0, 50005420, 3, ',33,50000054,50005420,50005430,', 0),
(50000059, '音乐其它', 0, 50005420, 3, ',33,50000054,50005420,50000059,', 0),
(50005439, '音乐作品综合集', 0, 50005420, 3, ',33,50000054,50005420,50005439,', 0),
(50005447, '音乐事业', 0, 50005420, 3, ',33,50000054,50005420,50005447,', 0),
(50005434, '键盘、簧乐理论和演奏法', 0, 50005420, 3, ',33,50000054,50005420,50005434,', 0),
(50008875, '西洋乐器', 0, 50005420, 3, ',33,50000054,50005420,50008875,', 0),
(50005429, '舞蹈音乐理论', 0, 50005420, 3, ',33,50000054,50005420,50005429,', 0),
(50005443, '舞蹈乐曲', 0, 50005420, 3, ',33,50000054,50005420,50005443,', 0),
(50005432, '管乐理论和演奏法', 0, 50005420, 3, ',33,50000054,50005420,50005432,', 0),
(50005437, '电子乐器', 0, 50005420, 3, ',33,50000054,50005420,50005437,', 0),
(50005445, '民族器乐曲', 0, 50005420, 3, ',33,50000054,50005420,50005445,', 0),
(50005440, '歌曲', 0, 50005420, 3, ',33,50000054,50005420,50005440,', 0),
(50005442, '曲艺音乐乐曲', 0, 50005420, 3, ',33,50000054,50005420,50005442,', 0),
(50005426, '指挥', 0, 50005420, 3, ',33,50000054,50005420,50005426,', 0),
(50005435, '打击乐理论和演奏法', 0, 50005420, 3, ',33,50000054,50005420,50005435,', 0),
(50005428, '戏剧音乐理论', 0, 50005420, 3, ',33,50000054,50005420,50005428,', 0),
(50005441, '戏剧音乐、配乐音乐曲谱', 0, 50005420, 3, ',33,50000054,50005420,50005441,', 0),
(50005433, '弹拨乐理论和演奏法', 0, 50005420, 3, ',33,50000054,50005420,50005433,', 0),
(50005427, '声乐理论', 0, 50005420, 3, ',33,50000054,50005420,50005427,', 0),
(50005424, '基本乐科', 0, 50005420, 3, ',33,50000054,50005420,50005424,', 0),
(50005436, '器乐合奏理论和演奏法', 0, 50005420, 3, ',33,50000054,50005420,50005436,', 0),
(50005446, '各国音乐作品', 0, 50005420, 3, ',33,50000054,50005420,50005446,', 0),
(50005444, '各国器乐曲', 0, 50005420, 3, ',33,50000054,50005420,50005444,', 0),
(50005425, '作曲理论', 0, 50005420, 3, ',33,50000054,50005420,50005425,', 0),
(50005423, '乐律学', 0, 50005420, 3, ',33,50000054,50005420,50005423,', 0),
(50005438, '中国民族乐器', 0, 50005420, 3, ',33,50000054,50005420,50005438,', 0),
(50005395, '音乐、音效', 0, 50005385, 3, ',33,50000054,50005385,50005395,', 0),
(50005411, '艺术片', 0, 50005385, 3, ',33,50000054,50005385,50005411,', 0),
(50005413, '科教片', 0, 50005385, 3, ',33,50000054,50005385,50005413,', 0),
(50005410, '硬件/设备', 0, 50005385, 3, ',33,50000054,50005385,50005410,', 0),
(50005419, '电影评奖电影节', 0, 50005385, 3, ',33,50000054,50005385,50005419,', 0),
(50005402, '电影机械及器材', 0, 50005385, 3, ',33,50000054,50005385,50005402,', 0),
(50005386, '电影、电视艺术理论', 0, 50005385, 3, ',33,50000054,50005385,50005386,', 0),
(50005396, '电影、电视分镜头', 0, 50005385, 3, ',33,50000054,50005385,50005396,', 0),
(50005417, '电影、电视事业其他', 0, 50005385, 3, ',33,50000054,50005385,50005417,', 0),
(50005392, '特技', 0, 50005385, 3, ',33,50000054,50005385,50005392,', 0),
(50005390, '照明', 0, 50005385, 3, ',33,50000054,50005385,50005390,', 0),
(50005406, '流通和放映', 0, 50005385, 3, ',33,50000054,50005385,50005406,', 0),
(50005405, '洗印厂', 0, 50005385, 3, ',33,50000054,50005385,50005405,', 0),
(50005400, '洗印', 0, 50005385, 3, ',33,50000054,50005385,50005400,', 0),
(50005394, '服装', 0, 50005385, 3, ',33,50000054,50005385,50005394,', 0),
(50005407, '放映技术', 0, 50005385, 3, ',33,50000054,50005385,50005407,', 0),
(50005391, '拟音', 0, 50005385, 3, ',33,50000054,50005385,50005391,', 0),
(50005401, '技术检查', 0, 50005385, 3, ',33,50000054,50005385,50005401,', 0),
(50000060, '影视艺术', 0, 50005385, 3, ',33,50000054,50005385,50000060,', 0),
(50005399, '影视技术', 0, 50005385, 3, ',33,50000054,50005385,50005399,', 0),
(50005388, '影视人员', 0, 50005385, 3, ',33,50000054,50005385,50005388,', 0),
(50005409, '影片保护', 0, 50005385, 3, ',33,50000054,50005385,50005409,', 0),
(50005416, '幻灯', 0, 50005385, 3, ',33,50000054,50005385,50005416,', 0),
(50005415, '各类影视片', 0, 50005385, 3, ',33,50000054,50005385,50005415,', 0),
(50005393, '化妆、舞台妆', 0, 50005385, 3, ',33,50000054,50005385,50005393,', 0),
(50005404, '制片厂', 0, 50005385, 3, ',33,50000054,50005385,50005404,', 0),
(50005418, '专业影展回顾展', 0, 50005385, 3, ',33,50000054,50005385,50005418,', 0),
(50005379, '话剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005379,', 0),
(50005374, '舞台美术', 0, 50005370, 3, ',33,50000141,50005370,50005374,', 0),
(50005375, '舞台技术', 0, 50005370, 3, ',33,50000141,50005370,50005375,', 0),
(50005378, '歌舞剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005378,', 0),
(50005377, '歌剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005377,', 0),
(50005381, '曲艺艺术', 0, 50005370, 3, ',33,50000141,50005370,50005381,', 0),
(50005373, '戏剧表演学', 0, 50005370, 3, ',33,50000141,50005370,50005373,', 0),
(50005371, '戏剧艺术理论', 0, 50005370, 3, ',33,50000141,50005370,50005371,', 0),
(50005713, '戏剧其它', 0, 50005370, 3, ',33,50000141,50005370,50005713,', 0),
(50005384, '戏剧事业', 0, 50005370, 3, ',33,50000141,50005370,50005384,', 0),
(50005372, '导演学', 0, 50005370, 3, ',33,50000141,50005370,50005372,', 0),
(50005380, '地方剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005380,', 0),
(50005383, '各国戏剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005383,', 0),
(50005382, '其他剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005382,', 0),
(50005376, '京剧艺术', 0, 50005370, 3, ',33,50000141,50005370,50005376,', 0),
(50005354, '建筑艺术理论', 0, 50005353, 3, ',33,50000054,50005353,50005354,', 0),
(50005365, '建筑艺术图集', 0, 50005353, 3, ',33,50000054,50005353,50005365,', 0),
(50000058, '建筑艺术其它', 0, 50005353, 3, ',33,50000054,50005353,50000058,', 0),
(50005364, '建筑艺术作品的保护、修缮和仿造', 0, 50005353, 3, ',33,50000054,50005353,50005364,', 0),
(50005357, '建筑艺术传统', 0, 50005353, 3, ',33,50000054,50005353,50005357,', 0),
(50005355, '建筑美学', 0, 50005353, 3, ',33,50000054,50005353,50005355,', 0),
(50005361, '建筑与文学和音乐的关系', 0, 50005353, 3, ',33,50000054,50005353,50005361,', 0),
(50005360, '建筑与工艺美术的关系', 0, 50005353, 3, ',33,50000054,50005353,50005360,', 0),
(50005362, '建筑与城市规划、环境布置的关系', 0, 50005353, 3, ',33,50000054,50005353,50005362,', 0),
(50005359, '建筑与其他艺术、科学的关系', 0, 50005353, 3, ',33,50000054,50005353,50005359,', 0),
(50005350, '装饰美术', 0, 50005342, 3, ',33,50000054,50005342,50005350,', 0),
(50005347, '纺织工艺美术', 0, 50005342, 3, ',33,50000054,50005342,50005347,', 0),
(50005352, '民间工艺美术', 0, 50005342, 3, ',33,50000054,50005342,50005352,', 0),
(50005343, '工艺美术理论', 0, 50005342, 3, ',33,50000054,50005342,50005343,', 0),
(50005704, '工艺美术其它', 0, 50005342, 3, ',33,50000054,50005342,50005704,', 0),
(50005345, '工艺美术作品综合集', 0, 50005342, 3, ',33,50000054,50005342,50005345,', 0),
(50005346, '图案集', 0, 50005342, 3, ',33,50000054,50005342,50005346,', 0),
(50005344, '图案学', 0, 50005342, 3, ',33,50000054,50005342,50005344,', 0),
(50005348, '印染工艺美术', 0, 50005342, 3, ',33,50000054,50005342,50005348,', 0),
(50005338, '舞台摄影', 0, 50005329, 3, ',33,50000054,50005329,50005338,', 0),
(50005337, '生活摄影', 0, 50005329, 3, ',33,50000054,50005329,50005337,', 0),
(50005339, '特技摄影', 0, 50005329, 3, ',33,50000054,50005329,50005339,', 0),
(50005330, '摄影评论/欣赏', 0, 50005329, 3, ',33,50000054,50005329,50005330,', 0),
(50005341, '摄影艺术理论', 0, 50005329, 3, ',33,50000054,50005329,50005341,', 0),
(50005332, '摄影艺术史', 0, 50005329, 3, ',33,50000054,50005329,50005332,', 0),
(50005331, '摄影艺术创作方法', 0, 50005329, 3, ',33,50000054,50005329,50005331,', 0),
(50005333, '室内摄影', 0, 50005329, 3, ',33,50000054,50005329,50005333,', 0),
(50005340, '夜间摄影', 0, 50005329, 3, ',33,50000054,50005329,50005340,', 0),
(50005318, '书法材料、工具的使用与保管', 10, 50005312, 3, ',33,50000054,50005312,50005318,', 0),
(50005315, '美术字', 0, 50005312, 3, ',33,50000054,50005312,50005315,', 0),
(50005325, '篆刻法', 0, 50005312, 3, ',33,50000054,50005312,50005325,', 0),
(50005326, '碑帖/印谱', 0, 50005312, 3, ',33,50000054,50005312,50005326,', 0),
(50005319, '碑帖', 0, 50005312, 3, ',33,50000054,50005312,50005319,', 0),
(50005314, '硬笔字', 0, 50005312, 3, ',33,50000054,50005312,50005314,', 0),
(50005327, '现代印谱', 0, 50005312, 3, ',33,50000054,50005312,50005327,', 0),
(50005313, '毛笔字', 0, 50005312, 3, ',33,50000054,50005312,50005313,', 0),
(50005328, '拼音/外文书法', 0, 50005312, 3, ',33,50000054,50005312,50005328,', 0),
(50005316, '少数民族文字', 0, 50005312, 3, ',33,50000054,50005312,50005316,', 0),
(50005322, '五大字体书法', 0, 50005312, 3, ',33,50000054,50005312,50005322,', 0),
(50000057, '书法/篆刻其它', 0, 50005312, 3, ',33,50000054,50005312,50000057,', 0),
(50005306, '绘画范本/作品集', 0, 50005301, 3, ',33,50000054,50005301,50005306,', 0),
(50005302, '绘画理论', 0, 50005301, 3, ',33,50000054,50005301,50005302,', 0),
(50005303, '绘画技法', 0, 50005301, 3, ',33,50000054,50005301,50005303,', 0),
(50005304, '绘画作品综合集', 0, 50005301, 3, ',33,50000054,50005301,50005304,', 0),
(50005309, '素描、速写', 0, 50005301, 3, ',33,50000054,50005301,50005309,', 0),
(50005311, '粉画、蜡笔画', 0, 50005301, 3, ',33,50000054,50005301,50005311,', 0),
(50005308, '漆画、涂料画', 0, 50005301, 3, ',33,50000054,50005301,50005308,', 0),
(50000109, '油画', 0, 50005301, 3, ',33,50000054,50005301,50000109,', 0),
(50005310, '水彩、水粉', 0, 50005301, 3, ',33,50000054,50005301,50005310,', 0),
(50005307, '民族技法画', 0, 50005301, 3, ',33,50000054,50005301,50005307,', 0),
(50000108, '国画', 0, 50005301, 3, ',33,50000054,50005301,50000108,', 0),
(50000112, '其它', 0, 50005301, 3, ',33,50000054,50005301,50000112,', 0),
(50005714, '雕塑艺术其它', 0, 50005288, 3, ',33,50000054,50005288,50005714,', 0),
(50005289, '雕塑理论', 0, 50005288, 3, ',33,50000054,50005288,50005289,', 0),
(50005291, '雕塑材料和工具书籍', 0, 50005288, 3, ',33,50000054,50005288,50005291,', 0),
(50005290, '雕塑技法', 0, 50005288, 3, ',33,50000054,50005288,50005290,', 0),
(50005292, '雕塑作品的修复和保管', 0, 50005288, 3, ',33,50000054,50005288,50005292,', 0),
(50005296, '金属雕刻书籍', 0, 50005288, 3, ',33,50000054,50005288,50005296,', 0),
(50005297, '竹刻、竹雕书籍', 0, 50005288, 3, ',33,50000054,50005288,50005297,', 0),
(50005295, '石刻、石雕书籍', 0, 50005288, 3, ',33,50000054,50005288,50005295,', 0),
(50005298, '漆雕书籍', 0, 50005288, 3, ',33,50000054,50005288,50005298,', 0),
(50005299, '泥塑、塑像书籍', 0, 50005288, 3, ',33,50000054,50005288,50005299,', 0),
(50005300, '各类材质雕塑', 0, 50005288, 3, ',33,50000054,50005288,50005300,', 0),
(50005279, '艺术理论基本问题', 0, 50005274, 3, ',33,50000054,50005274,50005279,', 0),
(50005282, '艺术方法论', 0, 50005274, 3, ',33,50000054,50005274,50005282,', 0),
(50005284, '艺术技法', 0, 50005274, 3, ',33,50000054,50005274,50005284,', 0),
(50005277, '艺术心理学/社会学等', 0, 50005274, 3, ',33,50000054,50005274,50005277,', 0),
(50005280, '艺术工作者', 0, 50005274, 3, ',33,50000054,50005274,50005280,', 0),
(50005703, '艺术史', 0, 50005274, 3, ',33,50000054,50005274,50005703,', 0),
(50005281, '艺术创作方法', 0, 50005274, 3, ',33,50000054,50005274,50005281,', 0),
(50005278, '艺术与其他科学', 0, 50005274, 3, ',33,50000054,50005274,50005278,', 0),
(50005285, '世界各国艺术概况', 0, 50005274, 3, ',33,50000054,50005274,50005285,', 0),
(50000038, '财富', 0, 50005169, 3, ',33,50004870,50005169,50000038,', 0),
(50000037, '读者文摘', 0, 50005169, 3, ',33,50004870,50005169,50000037,', 0),
(50000041, '福布斯', 0, 50005169, 3, ',33,50004870,50005169,50000041,', 0),
(50000039, '时代周刊', 0, 50005169, 3, ',33,50004870,50005169,50000039,', 0),
(50000036, '国家地理', 0, 50005169, 3, ',33,50004870,50005169,50000036,', 0),
(50004891, '原版杂志其它', 0, 50005169, 3, ',33,50004870,50005169,50004891,', 0),
(50000042, '其他', 0, 50005169, 3, ',33,50004870,50005169,50000042,', 0),
(50000040, '人物', 0, 50005169, 3, ',33,50004870,50005169,50000040,', 0),
(50004994, '音乐类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004994,', 0),
(50004988, '财经类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004988,', 0),
(50004989, '汽车类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004989,', 0),
(50004990, '服饰类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004990,', 0),
(50004992, '旅游类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004992,', 0),
(50004995, '其它类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004995,', 0),
(50004993, '保健类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004993,', 0),
(50004987, '体育类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004987,', 0),
(50004991, 'IT类期刊订阅', 0, 50004979, 3, ',33,50001378,50004979,50004991,', 0),
(50004985, '音乐类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004985,', 0),
(50004982, '财经类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004982,', 0),
(50004981, '新闻类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004981,', 0),
(50004984, '军事类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004984,', 0),
(50004986, '其它类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004986,', 0),
(50004980, '体育类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004980,', 0),
(50004983, 'IT类报纸订阅', 0, 50004978, 3, ',33,50001378,50004978,50004983,', 0),
(50003126, '婚恋其它', 7, 50004845, 3, ',33,50003112,50004845,50003126,', 0),
(50004847, '恋爱', 0, 50004845, 3, ',33,50003112,50004845,50004847,', 0),
(50004846, '婚姻', 0, 50004845, 3, ',33,50003112,50004845,50004846,', 0),
(50004848, '两性之间', 0, 50004845, 3, ',33,50003112,50004845,50004848,', 0),
(50000179, '农业科学其它', 8, 50004782, 3, ',33,50004788,50004782,50000179,', 0),
(50004783, '畜牧/养殖', 0, 50004782, 3, ',33,50004788,50004782,50004783,', 0),
(50004784, '渔业', 0, 50004782, 3, ',33,50004788,50004782,50004784,', 0),
(50004785, '林业', 0, 50004782, 3, ',33,50004788,50004782,50004785,', 0),
(50004787, '园艺', 0, 50004782, 3, ',33,50004788,50004782,50004787,', 0),
(50004786, '农业基础科学', 0, 50004782, 3, ',33,50004788,50004782,50004786,', 0),
(50050321, '城市规划', 6, 50004753, 3, ',33,50004788,50004753,50050321,', 0),
(50050320, '建筑史', 5, 50004753, 3, ',33,50004788,50004753,50050320,', 0),
(50050319, '物业管理', 4, 50004753, 3, ',33,50004788,50004753,50050319,', 0),
(50050318, '装饰装修', 3, 50004753, 3, ',33,50004788,50004753,50050318,', 0),
(50050317, '园林景观', 2, 50004753, 3, ',33,50004788,50004753,50050317,', 0),
(50050316, '房地产开发管理', 1, 50004753, 3, ',33,50004788,50004753,50050316,', 0),
(50004762, '高层建筑', 0, 50004753, 3, ',33,50004788,50004753,50004762,', 0),
(50004759, '装修', 0, 50004753, 3, ',33,50004788,50004753,50004759,', 0),
(50004755, '水利水电', 0, 50004753, 3, ',33,50004788,50004753,50004755,', 0),
(50004758, '房屋建筑设备', 0, 50004753, 3, ',33,50004788,50004753,50004758,', 0),
(50004761, '建筑设计', 0, 50004753, 3, ',33,50004788,50004753,50004761,', 0),
(50004756, '建筑结构', 0, 50004753, 3, ',33,50004788,50004753,50004756,', 0),
(50004754, '建筑理论', 0, 50004753, 3, ',33,50004788,50004753,50004754,', 0),
(50004765, '建筑材料', 0, 50004753, 3, ',33,50004788,50004753,50004765,', 0),
(50004763, '建筑施工', 0, 50004753, 3, ',33,50004788,50004753,50004763,', 0),
(50004766, '建筑其它', 0, 50004753, 3, ',33,50004788,50004753,50004766,', 0),
(50004764, '市政工程', 0, 50004753, 3, ',33,50004788,50004753,50004764,', 0),
(50004757, '地下建筑', 0, 50004753, 3, ',33,50004788,50004753,50004757,', 0),
(50004760, '土力学/地基基础工程', 0, 50004753, 3, ',33,50004788,50004753,50004760,', 0),
(50003121, '美容书籍', 2, 50004651, 3, ',33,50004645,50004651,50003121,', 0),
(50004653, '美体', 0, 50004651, 3, ',33,50004645,50004651,50004653,', 0),
(50004654, '化妆', 0, 50004651, 3, ',33,50004645,50004651,50004654,', 0),
(50004656, '网络游戏', 0, 50004646, 3, ',33,50004645,50004646,50004656,', 0),
(50004657, '棋牌', 0, 50004646, 3, ',33,50004645,50004646,50004657,', 0),
(50004655, '智力游戏', 0, 50004646, 3, ',33,50004645,50004646,50004655,', 0),
(50003168, '建筑工程类职称考试其它', 22, 50004546, 3, ',33,50000072,50004546,50003168,', 0),
(50004549, '勘察设计注册公用设备工程师', 0, 50004546, 3, ',33,50000072,50004546,50004549,', 0),
(50004547, '全国造价工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004547,', 0),
(50004553, '全国监理工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004553,', 0),
(50004556, '全国注册结构工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004556,', 0),
(50023804, '家居服务', 12, 0, 0, ',50023804,', 1),
(50023282, '美发护发/假发', 16, 0, 0, ',50023282,', 1),
(50018004, '电子词典/电纸书/文化用品', 29, 0, 0, ',50018004,', 1),
(50020857, '特色手工艺', 48, 0, 0, ',50020857,', 1),
(50025110, '电影/演出/体育赛事', 322, 0, 0, ',50025110,', 1),
(50004554, '全国注册电气工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004554,', 0),
(50024451, '外卖/外送/订餐服务', 318, 0, 0, ',50024451,', 1),
(50024612, '外卖/外送/订餐服务（垂直市场）', 319, 0, 0, ',50024612,', 1),
(50023878, '自用闲置转让', 310, 0, 0, ',50023878,', 1),
(50004559, '全国注册建筑师考试', 0, 50004546, 3, ',33,50000072,50004546,50004559,', 0),
(50004551, '全国注册安全工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004551,', 0),
(50004558, '全国注册咨询工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004558,', 0),
(23, '古董/邮币/字画/收藏', 150, 0, 0, ',23,', 1),
(50004562, '全国房地产经纪人考试', 0, 50004546, 3, ',33,50000072,50004546,50004562,', 0),
(50004561, '全国房地产估价师考试', 0, 50004546, 3, ',33,50000072,50004546,50004561,', 0),
(25, '玩具/模型/动漫/早教/益智', 140, 0, 0, ',25,', 1),
(50025111, '本地化生活服务', 323, 0, 0, ',50025111,', 1),
(150701, '手机挂件/手机链', 1, 1507, 3, ',50008090,50024094,1507,150701,', 0),
(50004557, '全国岩土工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004557,', 0),
(50025705, '洗护清洁剂/卫生巾/纸/香薰', 327, 0, 0, ',50025705,', 1),
(50025706, '贵金属', 328, 0, 0, ',50025706,', 0),
(50026316, '茶/酒/冲饮', 330, 0, 0, ',50026316,', 1),
(50004548, '全国室内建筑师考试', 0, 50004546, 3, ',33,50000072,50004546,50004548,', 0),
(50004560, '全国土木工程师考试', 0, 50004546, 3, ',33,50000072,50004546,50004560,', 0),
(50004565, '全国二级建造师考试', 0, 50004546, 3, ',33,50000072,50004546,50004565,', 0),
(50004563, '全国一级建造师考试', 0, 50004546, 3, ',33,50000072,50004546,50004563,', 0),
(50004543, '药学考试', 0, 50004541, 3, ',33,50000072,50004541,50004543,', 0),
(50004544, '护士考试', 0, 50004541, 3, ',33,50000072,50004541,50004544,', 0),
(50004542, '执业医师', 0, 50004541, 3, ',33,50000072,50004541,50004542,', 0),
(50004545, '卫生资格考试', 0, 50004541, 3, ',33,50000072,50004541,50004545,', 0),
(50000105, '医药卫生类职称考试其它', 0, 50004541, 3, ',33,50000072,50004541,50000105,', 0),
(50007037, '中国营养师', 0, 50004541, 3, ',33,50000072,50004541,50007037,', 0),
(50011685, '考研英语', 12, 50004525, 3, ',33,50000072,50004525,50011685,', 0),
(50000085, '考研其它', 11, 50004525, 3, ',33,50000072,50004525,50000085,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50004538, '金融联考', 0, 50004525, 3, ',33,50000072,50004525,50004538,', 0),
(50004530, '考研数学', 0, 50004525, 3, ',33,50000072,50004525,50004530,', 0),
(50004529, '考研政治', 0, 50004525, 3, ',33,50000072,50004525,50004529,', 0),
(50004526, '考研大纲', 0, 50004525, 3, ',33,50000072,50004525,50004526,', 0),
(50004531, '考研医学', 0, 50004525, 3, ',33,50000072,50004525,50004531,', 0),
(50004532, '考研专业书', 0, 50004525, 3, ',33,50000072,50004525,50004532,', 0),
(50004537, '法硕联考', 0, 50004525, 3, ',33,50000072,50004525,50004537,', 0),
(50004540, '在职硕士考试', 0, 50004525, 3, ',33,50000072,50004525,50004540,', 0),
(50004539, '同等学力考试', 0, 50004525, 3, ',33,50000072,50004525,50004539,', 0),
(50004535, 'MPA联考', 0, 50004525, 3, ',33,50000072,50004525,50004535,', 0),
(50004533, 'MPAcc联考', 0, 50004525, 3, ',33,50000072,50004525,50004533,', 0),
(50000086, 'MBA联考', 0, 50004525, 3, ',33,50000072,50004525,50000086,', 0),
(50004536, 'GCT联考', 0, 50004525, 3, ',33,50000072,50004525,50004536,', 0),
(50000098, '其它外语', 20, 50004514, 3, ',33,50000072,50004514,50000098,', 0),
(50000091, '雅思/IELTS', 0, 50004514, 3, ',33,50000072,50004514,50000091,', 0),
(50004599, '英语翻译资格考试', 0, 50004514, 3, ',33,50000072,50004514,50004599,', 0),
(50000093, '英语四六级', 0, 50004514, 3, ',33,50000072,50004514,50000093,', 0),
(50004597, '英语口语考试', 0, 50004514, 3, ',33,50000072,50004514,50004597,', 0),
(50004600, '英语口译资格考试', 0, 50004514, 3, ',33,50000072,50004514,50004600,', 0),
(50000097, '职称英语', 0, 50004514, 3, ',33,50000072,50004514,50000097,', 0),
(50000090, '管理类研究生报考/GMAT', 0, 50004514, 3, ',33,50000072,50004514,50000090,', 0),
(50000089, '研究生报考/GRE', 0, 50004514, 3, ',33,50000072,50004514,50000089,', 0),
(50004602, '法语考试', 0, 50004514, 3, ',33,50000072,50004514,50004602,', 0),
(50000096, '日语考试', 0, 50004514, 3, ',33,50000072,50004514,50000096,', 0),
(50000088, '托福/TOEFL', 0, 50004514, 3, ',33,50000072,50004514,50000088,', 0),
(50004603, '德语考试', 0, 50004514, 3, ',33,50000072,50004514,50004603,', 0),
(50000095, '剑桥商务英语/BEC', 0, 50004514, 3, ',33,50000072,50004514,50000095,', 0),
(50000092, '其它外语考试', 0, 50004514, 3, ',33,50000072,50004514,50000092,', 0),
(50000094, '公共英语/PET', 0, 50004514, 3, ',33,50000072,50004514,50000094,', 0),
(50004598, '专业英语四八级', 0, 50004514, 3, ',33,50000072,50004514,50004598,', 0),
(50004596, 'TOEIC', 0, 50004514, 3, ',33,50000072,50004514,50004596,', 0),
(50004517, '财经类教材', 0, 50004513, 3, ',33,50000072,50004513,50004517,', 0),
(50000079, '自学考试其它', 0, 50004513, 3, ',33,50000072,50004513,50000079,', 0),
(50004518, '理工农医类教材', 0, 50004513, 3, ',33,50000072,50004513,50004518,', 0),
(50004516, '文法类教材', 0, 50004513, 3, ',33,50000072,50004513,50004516,', 0),
(50004515, '公共课教材', 0, 50004513, 3, ',33,50000072,50004513,50004515,', 0),
(50004607, '音乐类', 0, 50004481, 3, ',33,50000072,50004481,50004607,', 0),
(50004605, '音乐基础知识', 0, 50004481, 3, ',33,50000072,50004481,50004605,', 0),
(50004616, '色彩写生', 0, 50004481, 3, ',33,50000072,50004481,50004616,', 0),
(50004611, '舞蹈类', 0, 50004481, 3, ',33,50000072,50004481,50004611,', 0),
(50004617, '绘画类', 0, 50004481, 3, ',33,50000072,50004481,50004617,', 0),
(50004614, '国际标准舞', 0, 50004481, 3, ',33,50000072,50004481,50004614,', 0),
(50004619, '体育类', 0, 50004481, 3, ',33,50000072,50004481,50004619,', 0),
(50004618, '书法', 0, 50004481, 3, ',33,50000072,50004481,50004618,', 0),
(50004612, '中国民族民间舞', 0, 50004481, 3, ',33,50000072,50004481,50004612,', 0),
(50007034, '跟单员', 0, 50004480, 3, ',33,50000072,50004480,50007034,', 0),
(50000102, '财税外贸保险类职称考试其它', 11, 50004480, 3, ',33,50000072,50004480,50000102,', 0),
(50004572, '证券从业资格考试', 0, 50004480, 3, ',33,50000072,50004480,50004572,', 0),
(50004583, '英国特许公认会计师ACCA', 0, 50004480, 3, ',33,50000072,50004480,50004583,', 0),
(50004586, '美国管理会计师考试', 0, 50004480, 3, ',33,50000072,50004480,50004586,', 0),
(50004581, '统计专业技术资格考试', 0, 50004480, 3, ',33,50000072,50004480,50004581,', 0),
(50004579, '注册审计师执业资格考试', 0, 50004480, 3, ',33,50000072,50004480,50004579,', 0),
(50004567, '注册税务师考试', 0, 50004480, 3, ',33,50000072,50004480,50004567,', 0),
(50004591, '经济专业技术资格 ( 经济师 )', 0, 50004480, 3, ',33,50000072,50004480,50004591,', 0),
(50004578, '注册统计师考试', 0, 50004480, 3, ',33,50000072,50004480,50004578,', 0),
(50004566, '注册会计师考试', 0, 50004480, 3, ',33,50000072,50004480,50004566,', 0),
(50004587, '国际会计师专业资格考试', 0, 50004480, 3, ',33,50000072,50004480,50004587,', 0),
(50004570, '初级会计职称考试', 0, 50004480, 3, ',33,50000072,50004480,50004570,', 0),
(50004569, '会计从业资格考试', 0, 50004480, 3, ',33,50000072,50004480,50004569,', 0),
(50004571, '中级会计职称考试', 0, 50004480, 3, ',33,50000072,50004480,50004571,', 0),
(50002975, '面向对象', 0, 50002761, 3, ',33,3306,50002761,50002975,', 0),
(50002977, '计算机数学/离散数学', 0, 50002761, 3, ',33,3306,50002761,50002977,', 0),
(50002978, '编译原理', 0, 50002761, 3, ',33,3306,50002761,50002978,', 0),
(50002974, '算法与复杂性', 0, 50002761, 3, ',33,3306,50002761,50002974,', 0),
(50002976, '数据结构', 0, 50002761, 3, ',33,3306,50002761,50002976,', 0),
(50002980, '并行理论', 0, 50002761, 3, ',33,3306,50002761,50002980,', 0),
(50002979, '分布式理论', 0, 50002761, 3, ',33,3306,50002761,50002979,', 0),
(50002973, '遥感信息系统', 0, 50002759, 3, ',33,3306,50002759,50002973,', 0),
(50002972, '计算机仿真', 0, 50002759, 3, ',33,3306,50002759,50002972,', 0),
(50002968, '管理信息系统', 0, 50002759, 3, ',33,3306,50002759,50002968,', 0),
(50002969, '地理信息系统', 0, 50002759, 3, ',33,3306,50002759,50002969,', 0),
(50002971, '信息系统原理及其它', 0, 50002759, 3, ',33,3306,50002759,50002971,', 0),
(50002970, '人工智能', 0, 50002759, 3, ',33,3306,50002759,50002970,', 0),
(50002966, '计算机硬件基础知识', 0, 50002757, 3, ',33,3306,50002757,50002966,', 0),
(50002967, '电脑组装与维修', 0, 50002757, 3, ',33,3306,50002757,50002967,', 0),
(50002957, '计算机网络原理与应用', 0, 50002755, 3, ',33,3306,50002755,50002957,', 0),
(50002960, '网络安全', 0, 50002755, 3, ',33,3306,50002755,50002960,', 0),
(50002961, '网络协议与设备', 0, 50002755, 3, ',33,3306,50002755,50002961,', 0),
(50005710, '网络与数字通讯其它', 0, 50002755, 3, ',33,3306,50002755,50005710,', 0),
(50002959, '组网与网络服务', 0, 50002755, 3, ',33,3306,50002755,50002959,', 0),
(50002962, 'Web服务器系统软件', 0, 50002755, 3, ',33,3306,50002755,50002962,', 0),
(50005216, '其它', 20, 50000508, 3, ',28,50000467,50000508,50005216,', 0),
(50000509, '打火机用油', 12, 50000508, 3, ',28,50000467,50000508,50000509,', 0),
(50005215, '棉芯', 10, 50000508, 3, ',28,50000467,50000508,50005215,', 0),
(50005214, '火石', 8, 50000508, 3, ',28,50000467,50000508,50005214,', 0),
(50005213, '礼盒', 6, 50000508, 3, ',28,50000467,50000508,50005213,', 0),
(50005212, '油壶', 4, 50000508, 3, ',28,50000467,50000508,50005212,', 0),
(50005211, '皮套', 2, 50000508, 3, ',28,50000467,50000508,50005211,', 0),
(50003064, '财务/统计软件', 0, 50000163, 3, ',33,3306,50000163,50003064,', 0),
(50003066, '排版/输入法', 0, 50000163, 3, ',33,3306,50000163,50003066,', 0),
(50003057, '办公自动化教程', 0, 50000163, 3, ',33,3306,50000163,50003057,', 0),
(50002774, '其它', 0, 50000163, 3, ',33,3306,50000163,50002774,', 0),
(50000164, 'Word', 0, 50000163, 3, ',33,3306,50000163,50000164,', 0),
(50000167, 'Outlook', 0, 50000163, 3, ',33,3306,50000163,50000167,', 0),
(50003055, 'OFFICE', 0, 50000163, 3, ',33,3306,50000163,50003055,', 0),
(50003056, 'Microsoft Project', 0, 50000163, 3, ',33,3306,50000163,50003056,', 0),
(50003062, 'LOTUS NOTES/DOMINO', 0, 50000163, 3, ',33,3306,50000163,50003062,', 0),
(50000165, 'Excel', 0, 50000163, 3, ',33,3306,50000163,50000165,', 0),
(50003063, 'ERP/PDM', 0, 50000163, 3, ',33,3306,50000163,50003063,', 0),
(50000151, '金庸', 0, 50000143, 3, ',33,50004674,50000143,50000151,', 0),
(50000153, '梁羽生', 0, 50000143, 3, ',33,50004674,50000143,50000153,', 0),
(50000152, '古龙', 0, 50000143, 3, ',33,50004674,50000143,50000152,', 0),
(50000154, '其它', 0, 50000143, 3, ',33,50004674,50000143,50000154,', 0),
(50000099, '全国计算机等级考试', 16, 50000077, 3, ',33,50000072,50000077,50000099,', 0),
(50000101, '计算机考试其它', 15, 50000077, 3, ',33,50000072,50000077,50000101,', 0),
(50003166, '全国计算机应用技术NIT', 14, 50000077, 3, ',33,50000072,50000077,50003166,', 0),
(50007040, '计算机各级考试', 11, 50000077, 3, ',33,50000072,50000077,50007040,', 0),
(50003165, '系统分析员', 8, 50000077, 3, ',33,50000072,50000077,50003165,', 0),
(50003160, '计算机软件专业技术资格和水平', 6, 50000077, 3, ',33,50000072,50000077,50003160,', 0),
(50003167, 'Adobe认证', 5, 50000077, 3, ',33,50000072,50000077,50003167,', 0),
(50003163, 'Oracle认证', 4, 50000077, 3, ',33,50000072,50000077,50003163,', 0),
(50003161, 'SUN认证', 3, 50000077, 3, ',33,50000072,50000077,50003161,', 0),
(50003158, 'Cisco认证', 2, 50000077, 3, ',33,50000072,50000077,50003158,', 0),
(50000100, 'Microsoft认证', 1, 50000077, 3, ',33,50000072,50000077,50000100,', 0),
(50007036, '高考试题汇编', 0, 50000074, 3, ',33,50000072,50000074,50007036,', 0),
(50007035, '高考名校教材', 0, 50000074, 3, ',33,50000072,50000074,50007035,', 0),
(50000084, '高考', 0, 50000074, 3, ',33,50000072,50000074,50000084,', 0),
(50000082, '小学升初中', 0, 50000074, 3, ',33,50000072,50000074,50000082,', 0),
(50000087, '升学考试其它', 0, 50000074, 3, ',33,50000072,50000074,50000087,', 0),
(50000083, '中考', 0, 50000074, 3, ',33,50000072,50000074,50000083,', 0),
(50000081, '成考其它', 22, 50000073, 3, ',33,50000072,50000073,50000081,', 0),
(50004523, '成人高考辅导', 0, 50000073, 3, ',33,50000072,50000073,50004523,', 0),
(50000080, '成人高考模拟试卷', 0, 50000073, 3, ',33,50000072,50000073,50000080,', 0),
(50004521, '成人高考教材', 0, 50000073, 3, ',33,50000072,50000073,50004521,', 0),
(50003067, '行业/职业英语', 0, 333110, 3, ',33,3331,333110,50003067,', 0),
(50003068, '英语学习方法', 0, 333110, 3, ',33,3331,333110,50003068,', 0),
(50003070, '生活英语', 0, 333110, 3, ',33,3331,333110,50003070,', 0),
(50003069, '求职英语', 0, 333110, 3, ',33,3331,333110,50003069,', 0),
(50003071, '娱乐/休闲英语', 0, 333110, 3, ',33,3331,333110,50003071,', 0),
(50003072, '商务英语', 0, 333110, 3, ',33,3331,333110,50003072,', 0),
(50002983, '词典/手册', 0, 330611, 3, ',33,3306,330611,50002983,', 0),
(50002982, '计算机英语', 0, 330611, 3, ',33,3306,330611,50002982,', 0),
(50002985, '计算机文化/传媒/法律', 0, 330611, 3, ',33,3306,330611,50002985,', 0),
(50002981, '计算机入门教材', 0, 330611, 3, ',33,3306,330611,50002981,', 0),
(50002984, '手册', 0, 330611, 3, ',33,3306,330611,50002984,', 0),
(330608, '网页设计其它', 8, 330610, 3, ',33,3306,330610,330608,', 0),
(50002955, '网页设计工具其它', 1, 330610, 3, ',33,3306,330610,50002955,', 0),
(50005639, 'XSL', 0, 330610, 3, ',33,3306,330610,50005639,', 0),
(50005636, 'XML/SGML', 0, 330610, 3, ',33,3306,330610,50005636,', 0),
(50005637, 'WebSphere', 0, 330610, 3, ',33,3306,330610,50005637,', 0),
(50005640, 'VRML', 0, 330610, 3, ',33,3306,330610,50005640,', 0),
(50005641, 'SOAP', 0, 330610, 3, ',33,3306,330610,50005641,', 0),
(50005649, 'Macromedia', 0, 330610, 3, ',33,3306,330610,50005649,', 0),
(50005635, 'MFC', 0, 330610, 3, ',33,3306,330610,50005635,', 0),
(50005638, 'JSP', 0, 330610, 3, ',33,3306,330610,50005638,', 0),
(50005645, 'HTML/DHTML/XHTML', 0, 330610, 3, ',33,3306,330610,50005645,', 0),
(50005646, 'GoLive', 0, 330610, 3, ',33,3306,330610,50005646,', 0),
(50005647, 'Flash MX', 0, 330610, 3, ',33,3306,330610,50005647,', 0),
(50005651, 'Fireworks', 0, 330610, 3, ',33,3306,330610,50005651,', 0),
(50005650, 'Dreamweaver', 0, 330610, 3, ',33,3306,330610,50005650,', 0),
(50005654, 'Director/Lingo/Shockwave', 0, 330610, 3, ',33,3306,330610,50005654,', 0),
(50005642, 'CSS', 0, 330610, 3, ',33,3306,330610,50005642,', 0),
(50005653, 'Authorware', 0, 330610, 3, ',33,3306,330610,50005653,', 0),
(50005643, 'ASP/ASP+', 0, 330610, 3, ',33,3306,330610,50005643,', 0),
(50005644, 'ASP.NET', 0, 330610, 3, ',33,3306,330610,50005644,', 0),
(50002941, '音频/视频信号处理', 0, 330607, 3, ',33,3306,330607,50002941,', 0),
(50002937, '计算机图形学', 0, 330607, 3, ',33,3306,330607,50002937,', 0),
(50002942, '多媒体教学', 0, 330607, 3, ',33,3306,330607,50002942,', 0),
(50002938, '多媒体技术', 0, 330607, 3, ',33,3306,330607,50002938,', 0),
(50002939, '多媒体信息与通信', 0, 330607, 3, ',33,3306,330607,50002939,', 0),
(50002773, '图形图像其它', 0, 330607, 3, ',33,3306,330607,50002773,', 0),
(50002936, '图形和多媒体处理软件', 0, 330607, 3, ',33,3306,330607,50002936,', 0),
(50002964, '数据库系统实例', 0, 330606, 3, ',33,3306,330606,50002964,', 0),
(50002965, '数据库系统原理', 0, 330606, 3, ',33,3306,330606,50002965,', 0),
(50005709, '数据库系统其它', 0, 330606, 3, ',33,3306,330606,50005709,', 0),
(50002963, '数据处理', 0, 330606, 3, ',33,3306,330606,50002963,', 0),
(50005686, 'Sybase', 0, 330606, 3, ',33,3306,330606,50005686,', 0),
(50005694, 'SQL Server', 0, 330606, 3, ',33,3306,330606,50005694,', 0),
(50005687, 'Oracle', 0, 330606, 3, ',33,3306,330606,50005687,', 0),
(50005697, 'MySQL/SQL', 0, 330606, 3, ',33,3306,330606,50005697,', 0),
(50005684, 'JDBC', 0, 330606, 3, ',33,3306,330606,50005684,', 0),
(50005685, 'InterBase', 0, 330606, 3, ',33,3306,330606,50005685,', 0),
(50005689, 'Informix', 0, 330606, 3, ',33,3306,330606,50005689,', 0),
(50005698, 'GIS/MapInfo', 0, 330606, 3, ',33,3306,330606,50005698,', 0),
(50005695, 'Foxpro/foxbase', 0, 330606, 3, ',33,3306,330606,50005695,', 0),
(50005691, 'DB2', 0, 330606, 3, ',33,3306,330606,50005691,', 0),
(50005693, 'Access', 0, 330606, 3, ',33,3306,330606,50005693,', 0),
(50005690, 'ADO&ADO.NET', 0, 330606, 3, ',33,3306,330606,50005690,', 0),
(50005595, '计算机过程控制', 0, 330603, 3, ',33,3306,330603,50005595,', 0),
(50005711, '计算机辅助设计其它', 0, 330603, 3, ',33,3306,330603,50005711,', 0),
(50002991, '计算机建筑', 0, 330603, 3, ',33,3306,330603,50002991,', 0),
(50005683, 'Visual Lisp', 0, 330603, 3, ',33,3306,330603,50005683,', 0),
(50002993, 'UG/UniGraphics', 0, 330603, 3, ',33,3306,330603,50002993,', 0),
(50005682, 'SolidWorks', 0, 330603, 3, ',33,3306,330603,50005682,', 0),
(50002988, 'ProEngineer', 0, 330603, 3, ',33,3306,330603,50002988,', 0),
(50005674, 'MDT/Inventor', 0, 330603, 3, ',33,3306,330603,50005674,', 0),
(50002989, 'MATLAB', 0, 330603, 3, ',33,3306,330603,50002989,', 0),
(50005679, 'EDA', 0, 330603, 3, ',33,3306,330603,50005679,', 0),
(50005681, 'CAXA', 0, 330603, 3, ',33,3306,330603,50005681,', 0),
(50002990, 'CAD/CAM/CAE', 0, 330603, 3, ',33,3306,330603,50002990,', 0),
(50005593, 'AutoDesk', 0, 330603, 3, ',33,3306,330603,50005593,', 0),
(50002987, 'AutoCAD', 0, 330603, 3, ',33,3306,330603,50002987,', 0),
(50005678, 'ANSYS', 0, 330603, 3, ',33,3306,330603,50005678,', 0),
(50005659, '网络操作系统', 0, 330602, 3, ',33,3306,330602,50005659,', 0),
(50005657, '操作系统教程', 0, 330602, 3, ',33,3306,330602,50005657,', 0),
(50002943, '操作系统实例', 0, 330602, 3, ',33,3306,330602,50002943,', 0),
(50002944, '操作系统原理与分类', 0, 330602, 3, ',33,3306,330602,50002944,', 0),
(50002945, '操作系统其它', 0, 330602, 3, ',33,3306,330602,50002945,', 0),
(50005656, '各类操作系统', 0, 330602, 3, ',33,3306,330602,50005656,', 0),
(50005606, '高级程序语言', 0, 330601, 3, ',33,3306,330601,50005606,', 0),
(50005609, '程序设计方法学', 0, 330601, 3, ',33,3306,330601,50005609,', 0),
(50002950, '程序设计工具', 0, 330601, 3, ',33,3306,330601,50002950,', 0),
(50005624, '注册表', 0, 330601, 3, ',33,3306,330601,50005624,', 0),
(50005603, '汇编语言', 0, 330601, 3, ',33,3306,330601,50005603,', 0),
(50002947, '基础教学语言', 0, 330601, 3, ',33,3306,330601,50002947,', 0),
(50005708, '其它程序设计语言', 0, 330601, 3, ',33,3306,330601,50005708,', 0),
(50002771, '其它', 0, 330601, 3, ',33,3306,330601,50002771,', 0),
(50005627, '中级程序设计语言', 0, 330601, 3, ',33,3306,330601,50005627,', 0),
(50005607, 'kylix', 0, 330601, 3, ',33,3306,330601,50005607,', 0),
(50005614, 'Zope', 0, 330601, 3, ',33,3306,330601,50005614,', 0),
(50002948, 'Windows编程接口', 0, 330601, 3, ',33,3306,330601,50002948,', 0),
(50005618, 'Windows CE', 0, 330601, 3, ',33,3306,330601,50005618,', 0),
(50005621, 'Win32 API', 0, 330601, 3, ',33,3306,330601,50005621,', 0),
(50002946, 'Visual Studio系列其它', 0, 330601, 3, ',33,3306,330601,50002946,', 0),
(50005628, 'Visual C++.NET', 0, 330601, 3, ',33,3306,330601,50005628,', 0),
(50005629, 'Visual C++', 0, 330601, 3, ',33,3306,330601,50005629,', 0),
(50005623, 'VCL', 0, 330601, 3, ',33,3306,330601,50005623,', 0),
(50002954, 'VBScript', 0, 330601, 3, ',33,3306,330601,50002954,', 0),
(50000170, 'VB', 0, 330601, 3, ',33,3306,330601,50000170,', 0),
(50005613, 'Tcl/Tk', 0, 330601, 3, ',33,3306,330601,50005613,', 0),
(50005626, 'STL', 0, 330601, 3, ',33,3306,330601,50005626,', 0),
(50005612, 'Python', 0, 330601, 3, ',33,3306,330601,50005612,', 0),
(50005611, 'Prolog', 0, 330601, 3, ',33,3306,330601,50005611,', 0),
(50002952, 'PHP', 0, 330601, 3, ',33,3306,330601,50002952,', 0),
(50005604, 'PERL', 0, 330601, 3, ',33,3306,330601,50005604,', 0),
(50000169, 'Java其它', 0, 330601, 3, ',33,3306,330601,50000169,', 0),
(50002953, 'JavaScript', 0, 330601, 3, ',33,3306,330601,50002953,', 0),
(50005622, 'JINI', 0, 330601, 3, ',33,3306,330601,50005622,', 0),
(50005602, 'IDL', 0, 330601, 3, ',33,3306,330601,50005602,', 0),
(50005616, 'Delphi', 0, 330601, 3, ',33,3306,330601,50005616,', 0),
(50000168, 'C语言其它', 0, 330601, 3, ',33,3306,330601,50000168,', 0),
(50005620, 'CORBA', 0, 330601, 3, ',33,3306,330601,50005620,', 0),
(50005633, 'C++ Builder', 0, 330601, 3, ',33,3306,330601,50005633,', 0),
(50005630, 'C++', 0, 330601, 3, ',33,3306,330601,50005630,', 0),
(50005632, 'C#', 0, 330601, 3, ',33,3306,330601,50005632,', 0),
(50005631, 'C', 0, 330601, 3, ',33,3306,330601,50005631,', 0),
(50005605, 'Basic', 0, 330601, 3, ',33,3306,330601,50005605,', 0),
(50005619, 'ActiveX', 0, 330601, 3, ',33,3306,330601,50005619,', 0),
(50002949, 'ASP/ASP+', 0, 330601, 3, ',33,3306,330601,50002949,', 0),
(50007043, '秘书资格证书考试', 0, 330209, 3, ',33,50000072,330209,50007043,', 0),
(50008485, '电子商务师', 0, 330209, 3, ',33,50000072,330209,50008485,', 0),
(50004947, '物流师', 0, 330209, 3, ',33,50000072,330209,50004947,', 0),
(50004946, '物业管理员', 0, 330209, 3, ',33,50000072,330209,50004946,', 0),
(50000106, '执业考试其它', 0, 330209, 3, ',33,50000072,330209,50000106,', 0),
(50007044, '导游员资格考试', 0, 330209, 3, ',33,50000072,330209,50007044,', 0),
(50007042, '公关员资格考试', 0, 330209, 3, ',33,50000072,330209,50007042,', 0),
(50008484, '企业培训师', 0, 330209, 3, ',33,50000072,330209,50008484,', 0),
(50023772, '卡通贴纸/磁性贴', 79, 50008876, 2, ',25,50008876,50023772,', 0),
(50023771, '早教闪卡/潜能开发卡', 78, 50008876, 2, ',25,50008876,50023771,', 0),
(50023459, '马车配件', 8, 50023363, 2, ',50010728,50023363,50023459,', 0),
(50023458, '马术场地用具', 7, 50023363, 2, ',50010728,50023363,50023458,', 0),
(50023457, '马术文化用品', 6, 50023363, 2, ',50010728,50023363,50023457,', 0),
(50023456, '马匹保健', 5, 50023363, 2, ',50010728,50023363,50023456,', 0),
(50023455, '马匹清洁/马房用品', 4, 50023363, 2, ',50010728,50023363,50023455,', 0),
(50023454, '马球用品', 3, 50023363, 2, ',50010728,50023363,50023454,', 1),
(50023453, '马匹装备', 2, 50023363, 2, ',50010728,50023363,50023453,', 1),
(50023449, '鞍具系列', 1, 50023363, 2, ',50010728,50023363,50023449,', 1),
(50023448, '骑士装备', 0, 50023363, 2, ',50010728,50023363,50023448,', 1),
(50023328, '其它染发烫发产品', 2, 50023294, 2, ',50023282,50023294,50023328,', 0),
(50023327, '烫发水', 1, 50023294, 2, ',50023282,50023294,50023327,', 0),
(50023326, '染发膏', 0, 50023294, 2, ',50023282,50023294,50023326,', 0),
(50023325, '其它假发', 8, 50023283, 2, ',50023282,50023283,50023325,', 0),
(50023324, '假发配件/工具', 7, 50023283, 2, ',50023282,50023283,50023324,', 0),
(50023290, '假发发箍', 6, 50023283, 2, ',50023282,50023283,50023290,', 0),
(50023289, '直发片', 5, 50023283, 2, ',50023282,50023283,50023289,', 0),
(50023288, '卷发片', 4, 50023283, 2, ',50023282,50023283,50023288,', 0),
(50023287, '发包/丸子', 3, 50023283, 2, ',50023282,50023283,50023287,', 0),
(50023286, '马尾', 2, 50023283, 2, ',50023282,50023283,50023286,', 0),
(50023285, '刘海片', 1, 50023283, 2, ',50023282,50023283,50023285,', 0),
(50023284, '整顶假发', 0, 50023283, 2, ',50023282,50023283,50023284,', 0),
(50025901, '车罩', 10, 50023243, 2, ',50016348,50023243,50025901,', 0),
(50025900, '电视罩', 9, 50023243, 2, ',50016348,50023243,50025900,', 0),
(50025899, '餐桌罩', 8, 50023243, 2, ',50016348,50023243,50025899,', 0),
(50025898, '沙发罩', 7, 50023243, 2, ',50016348,50023243,50025898,', 0),
(50025897, '床罩', 6, 50023243, 2, ',50016348,50023243,50025897,', 0),
(50023260, '其他防尘罩', 5, 50023243, 2, ',50016348,50023243,50023260,', 0),
(50023248, '电扇/风扇防尘罩', 4, 50023243, 2, ',50016348,50023243,50023248,', 0),
(50023247, '冰箱防尘罩', 3, 50023243, 2, ',50016348,50023243,50023247,', 0),
(50023246, '鞋罩/靴罩/鞋袋', 2, 50023243, 2, ',50016348,50023243,50023246,', 0),
(50023245, '大衣/西服罩', 1, 50023243, 2, ',50016348,50023243,50023245,', 0),
(50023244, '被子防尘袋', 0, 50023243, 2, ',50016348,50023243,50023244,', 0),
(50023238, '其他美容清洁用品', 27, 50023206, 2, ',29,50023206,50023238,', 0),
(50023259, '美容台', 26, 50023206, 2, ',29,50023206,50023259,', 0),
(50023258, '止血粉', 25, 50023206, 2, ',29,50023206,50023258,', 0),
(50023237, '针梳', 24, 50023206, 2, ',29,50023206,50023237,', 0),
(50023236, '排梳', 23, 50023206, 2, ',29,50023206,50023236,', 0),
(50023235, '脚掌滋润/防滑/护理', 22, 50023206, 2, ',29,50023206,50023235,', 0),
(50023231, '指甲剪', 21, 50023206, 2, ',29,50023206,50023231,', 0),
(50023230, '电推剪', 20, 50023206, 2, ',29,50023206,50023230,', 0),
(50023228, '美容剪', 19, 50023206, 2, ',29,50023206,50023228,', 0),
(50023226, '吹风机', 18, 50023206, 2, ',29,50023206,50023226,', 0),
(50023224, '吹水机', 17, 50023206, 2, ',29,50023206,50023224,', 0),
(50023223, '美容服', 16, 50023206, 2, ',29,50023206,50023223,', 0),
(50023222, '粘毛器', 15, 50023206, 2, ',29,50023206,50023222,', 0),
(50023221, '拾便器', 14, 50023206, 2, ',29,50023206,50023221,', 0),
(50023220, '狗厕所', 13, 50023206, 2, ',29,50023206,50023220,', 0),
(50023219, '猫砂铲', 12, 50023206, 2, ',29,50023206,50023219,', 0),
(50023218, '猫砂盆/猫厕所', 11, 50023206, 2, ',29,50023206,50023218,', 0),
(50023217, '猫砂', 10, 50023206, 2, ',29,50023206,50023217,', 0),
(50023216, '浴池/浴盆', 9, 50023206, 2, ',29,50023206,50023216,', 0),
(50023215, '尿片/尿垫/护垫', 8, 50023206, 2, ',29,50023206,50023215,', 0),
(50023214, '牙具', 7, 50023206, 2, ',29,50023206,50023214,', 0),
(50023213, '口腔清洁', 6, 50023206, 2, ',29,50023206,50023213,', 0),
(50023212, '耳部清洁', 5, 50023206, 2, ',29,50023206,50023212,', 0),
(50023211, '眼部清洁', 4, 50023206, 2, ',29,50023206,50023211,', 0),
(50023210, '毛巾/浴巾/吸水毛巾', 3, 50023206, 2, ',29,50023206,50023210,', 0),
(50023209, '洗澡/按摩刷', 2, 50023206, 2, ',29,50023206,50023209,', 0),
(50023208, '香水/除味剂', 1, 50023206, 2, ',29,50023206,50023208,', 0),
(50023207, '香波浴液', 0, 50023206, 2, ',29,50023206,50023207,', 0),
(50026276, '绳子', 10, 50023189, 2, ',50016348,50023189,50026276,', 0),
(50025896, '桌脚垫', 9, 50023189, 2, ',50016348,50023189,50025896,', 0),
(50025895, '抽气泵', 8, 50023189, 2, ',50016348,50023189,50025895,', 0),
(50025894, '其他整理用品', 7, 50023189, 2, ',50016348,50023189,50025894,', 0),
(50025893, '橡皮筋/尼龙绳', 6, 50023189, 2, ',50016348,50023189,50025893,', 0),
(50023242, '双面贴物器', 5, 50023189, 2, ',50016348,50023189,50023242,', 0),
(50023202, '整理架/置物架/收纳架', 4, 50023189, 2, ',50016348,50023189,50023202,', 0),
(50023201, '整理隔板', 3, 50023189, 2, ',50016348,50023189,50023201,', 0),
(50023200, '夹子/收纳夹子', 2, 50023189, 2, ',50016348,50023189,50023200,', 0),
(50023190, '理线器/集线器/绕线器', 1, 50023189, 2, ',50016348,50023189,50023190,', 0),
(50003460, '挂钩/粘钩', 0, 50023189, 2, ',50016348,50023189,50003460,', 0),
(50023114, '羽绒马甲', 3, 50023110, 2, ',50011699,50023110,50023114,', 0),
(50023113, '棉马甲', 2, 50023110, 2, ',50011699,50023110,50023113,', 0),
(50023111, '单马甲', 0, 50023110, 2, ',50011699,50023110,50023111,', 0),
(50013238, '运动连衣裙', 9, 50023109, 2, ',50011699,50023109,50013238,', 0),
(50011726, '运动半身裙', 0, 50023109, 2, ',50011699,50023109,50011726,', 0),
(50023108, '运动中长裤／短裤', 2, 50023105, 2, ',50011699,50023105,50023108,', 0),
(50023107, '运动长裤', 1, 50023105, 2, ',50011699,50023105,50023107,', 0),
(50023106, '运动牛仔裤', 0, 50023105, 2, ',50011699,50023105,50023106,', 0),
(50023104, '其它运动配件', 1, 50023102, 2, ',50011699,50023102,50023104,', 0),
(50023103, '颈环/腕环', 0, 50023102, 2, ',50011699,50023102,50023103,', 0),
(50023359, '钱包卡袋', 5, 50023095, 2, ',50011699,50023095,50023359,', 0),
(50023100, '运动鼓包/旅行包', 4, 50023095, 2, ',50011699,50023095,50023100,', 0),
(50023099, '运动单肩挎包/手拎包', 3, 50023095, 2, ',50011699,50023095,50023099,', 0),
(50023098, '运动腰包', 2, 50023095, 2, ',50011699,50023095,50023098,', 0),
(50023097, '运动单肩斜挎包', 1, 50023095, 2, ',50011699,50023095,50023097,', 0),
(50023096, '运动单/双肩背包', 0, 50023095, 2, ',50011699,50023095,50023096,', 0),
(50011157, '美容小工具', 4, 50023068, 2, ',21,50023068,50011157,', 0),
(50023072, '美体用品', 3, 50023068, 2, ',21,50023068,50023072,', 0),
(50023071, '减肥用品', 2, 50023068, 2, ',21,50023068,50023071,', 0),
(50023070, '塑型用品', 1, 50023068, 2, ',21,50023068,50023070,', 0),
(50023069, '增高用品', 0, 50023068, 2, ',21,50023068,50023069,', 0),
(50023094, '训练防护衣裤', 3, 50022891, 2, ',50011699,50022891,50023094,', 0),
(50022893, '健身套装', 2, 50022891, 2, ',50011699,50022891,50022893,', 0),
(50022892, '健身裤', 1, 50022891, 2, ',50011699,50022891,50022892,', 0),
(50022890, '健身衣', 0, 50022891, 2, ',50011699,50022891,50022890,', 0),
(50023117, '其他大家电配件', 12, 50022734, 2, ',50022703,50022734,50023117,', 0),
(50022739, '洗衣机配件', 6, 50022734, 2, ',50022703,50022734,50022739,', 0),
(50022738, '烟机灶具配件', 5, 50022734, 2, ',50022703,50022734,50022738,', 0),
(50022737, '冷柜/酒柜/便携冷热箱配件', 4, 50022734, 2, ',50022703,50022734,50022737,', 0),
(50022736, '冰箱配件', 3, 50022734, 2, ',50022703,50022734,50022736,', 0),
(50026084, '空调配件', 2, 50022734, 2, ',50022703,50022734,50026084,', 0),
(50022735, '家庭影院配件', 1, 50022734, 2, ',50022703,50022734,50022735,', 0),
(50025785, '电视机配件', 0, 50022734, 2, ',50022703,50022734,50025785,', 1),
(50022654, 'LED开关电源', 2, 50022651, 2, ',50020579,50022651,50022654,', 0),
(50022653, 'LED显示屏', 1, 50022651, 2, ',50020579,50022651,50022653,', 0),
(50026549, '一次性餐桌用品套装', 11, 50022523, 2, ',50016349,50022523,50026549,', 0),
(50024806, '可降解餐具/环保餐具', 10, 50022523, 2, ',50016349,50022523,50024806,', 0),
(50022532, '一次性封口膜/缠绕膜', 8, 50022523, 2, ',50016349,50022523,50022532,', 0),
(50022531, '一次性桌布', 7, 50022523, 2, ',50016349,50022523,50022531,', 0),
(50022530, '一次性筷子', 6, 50022523, 2, ',50016349,50022523,50022530,', 0),
(50022529, '一次性手套', 5, 50022523, 2, ',50016349,50022523,50022529,', 0),
(50022528, '一次性餐盒', 4, 50022523, 2, ',50016349,50022523,50022528,', 0),
(50022527, '保鲜袋', 3, 50022523, 2, ',50016349,50022523,50022527,', 0),
(50022526, '保鲜膜', 2, 50022523, 2, ',50016349,50022523,50022526,', 0),
(50022525, '纸杯', 1, 50022523, 2, ',50016349,50022523,50022525,', 0),
(50022524, '塑杯', 0, 50022523, 2, ',50016349,50022523,50022524,', 0),
(50013857, '推车配件', 15, 50022520, 2, ',50014812,50022520,50013857,', 0),
(50006081, '学步车', 10, 50022520, 2, ',50014812,50022520,50006081,', 0),
(50013200, '双胞胎推车', 2, 50022520, 2, ',50014812,50022520,50013200,', 0),
(50013199, '三轮推车', 1, 50022520, 2, ',50014812,50022520,50013199,', 0),
(50010218, '四轮推车', 0, 50022520, 2, ',50014812,50022520,50010218,', 0),
(50013407, '插头', 20, 50022516, 2, ',50020579,50022516,50013407,', 0),
(50003472, '转换插头', 12, 50022516, 2, ',50020579,50022516,50003472,', 0),
(350615, '接线板', 0, 50022516, 2, ',50020579,50022516,350615,', 0),
(50022698, '其他扇', 11, 50022440, 2, ',50020808,50022440,50022698,', 0),
(50022696, '蕾丝扇', 10, 50022440, 2, ',50020808,50022440,50022696,', 0),
(50022695, '塑料扇', 9, 50022440, 2, ',50020808,50022440,50022695,', 0),
(50022449, '纸扇', 8, 50022440, 2, ',50020808,50022440,50022449,', 0),
(50022448, '烤漆扇', 7, 50022440, 2, ',50020808,50022440,50022448,', 0),
(50022447, '香木扇', 6, 50022440, 2, ',50020808,50022440,50022447,', 0),
(50022446, '竹扇', 5, 50022440, 2, ',50020808,50022440,50022446,', 0),
(50022445, '檀木扇', 4, 50022440, 2, ',50020808,50022440,50022445,', 0),
(50022444, '缅木扇', 3, 50022440, 2, ',50020808,50022440,50022444,', 0),
(50022443, '羽毛扇', 2, 50022440, 2, ',50020808,50022440,50022443,', 0),
(50022442, '娟扇', 1, 50022440, 2, ',50020808,50022440,50022442,', 0),
(50022441, '真丝扇', 0, 50022440, 2, ',50020808,50022440,50022441,', 0),
(50022421, '其他', 4, 50022373, 2, ',50008164,50022373,50022421,', 0),
(50022420, '性爱秋千', 3, 50022373, 2, ',50008164,50022373,50022420,', 0),
(50022419, '情趣沙发', 2, 50022373, 2, ',50008164,50022373,50022419,', 0),
(50022418, '性爱椅', 1, 50022373, 2, ',50008164,50022373,50022418,', 0),
(50022417, '情趣床/红床', 0, 50022373, 2, ',50008164,50022373,50022417,', 0),
(50022371, '进户门', 8, 50022357, 2, ',27,50022357,50022371,', 0),
(50022363, '门附件', 7, 50022357, 2, ',27,50022357,50022363,', 1),
(50022362, '防火门', 6, 50022357, 2, ',27,50022357,50022362,', 0),
(50022361, '庭院门', 5, 50022357, 2, ',27,50022357,50022361,', 0),
(50022360, '移门', 4, 50022357, 2, ',27,50022357,50022360,', 0),
(50022358, '室内门', 2, 50022357, 2, ',27,50022357,50022358,', 0),
(50025058, '竹地板', 7, 50022271, 2, ',27,50022271,50025058,', 0),
(50022292, '地板附件', 6, 50022271, 2, ',27,50022271,50022292,', 1),
(50022291, '特殊用途地板', 5, 50022271, 2, ',27,50022271,50022291,', 1),
(50022290, '地板革（PVC地板）', 4, 50022271, 2, ',27,50022271,50022290,', 0),
(50022289, '强化复合地板', 3, 50022271, 2, ',27,50022271,50022289,', 0),
(50022288, '实木复合地板', 2, 50022271, 2, ',27,50022271,50022288,', 0),
(50022287, '实木地板', 1, 50022271, 2, ',27,50022271,50022287,', 0),
(50024693, '抛晶砖', 6, 50022270, 2, ',27,50022270,50024693,', 0),
(50022286, '釉面砖', 5, 50022270, 2, ',27,50022270,50022286,', 0),
(50022275, '瓷砖装饰附件', 4, 50022270, 2, ',27,50022270,50022275,', 1),
(50022274, '马赛克', 3, 50022270, 2, ',27,50022270,50022274,', 0),
(50022273, '玻化砖', 2, 50022270, 2, ',27,50022270,50022273,', 0),
(50022272, '通体砖', 1, 50022270, 2, ',27,50022270,50022272,', 0),
(50013511, '仿古砖（包括文化石）', 1, 50022270, 2, ',27,50022270,50013511,', 0),
(50022267, '楼梯立柱', 4, 50022263, 2, ',27,50022263,50022267,', 0),
(50022266, '楼梯扶手', 3, 50022263, 2, ',27,50022263,50022266,', 0),
(50022265, '缩颈龙骨', 2, 50022263, 2, ',27,50022263,50022265,', 0),
(50022264, '楼梯踏步板', 1, 50022263, 2, ',27,50022263,50022264,', 0),
(50006060, '整体楼梯', 0, 50022263, 2, ',27,50022263,50006060,', 0),
(50022571, '圆床垫', 3, 50021837, 2, ',50008164,50021837,50022571,', 0),
(50020625, '水床垫', 2, 50021837, 2, ',50008164,50021837,50020625,', 0),
(50021840, '床垫', 1, 50021837, 2, ',50008164,50021837,50021840,', 0),
(50021841, '楼宇智能系统', 5, 50021794, 2, ',27,50021794,50021841,', 1),
(50021815, '电源控制系统', 4, 50021794, 2, ',27,50021794,50021815,', 1),
(50021809, '电器控制系统', 3, 50021794, 2, ',27,50021794,50021809,', 1),
(50021805, '影音控制系统', 2, 50021794, 2, ',27,50021794,50021805,', 1),
(50021801, '灯光控制系统', 1, 50021794, 2, ',27,50021794,50021801,', 1),
(50013224, '其它智能家居用品', 0, 50021794, 2, ',27,50021794,50013224,', 0),
(50021160, '车底检查镜', 3, 50021153, 2, ',50020579,50021153,50021160,', 0),
(50021159, '无线电波探测仪', 2, 50021153, 2, ',50020579,50021153,50021159,', 0),
(50021154, '金属探测器', 0, 50021153, 2, ',50020579,50021153,50021154,', 0),
(50021263, '其他胶带', 20, 50021133, 2, ',50007218,50021133,50021263,', 0),
(50021262, '沥青胶带', 19, 50021133, 2, ',50007218,50021133,50021262,', 0),
(50021261, '铝箔胶带', 18, 50021133, 2, ',50007218,50021133,50021261,', 0),
(50021260, '海绵胶带', 17, 50021133, 2, ',50007218,50021133,50021260,', 0),
(50021259, '纤维胶带', 16, 50021133, 2, ',50007218,50021133,50021259,', 0),
(50021258, '玻璃布胶带', 15, 50021133, 2, ',50007218,50021133,50021258,', 0),
(50021257, '布胶带', 14, 50021133, 2, ',50007218,50021133,50021257,', 0),
(50021256, '特氟龙胶带', 13, 50021133, 2, ',50007218,50021133,50021256,', 0),
(50021255, '玛拉胶带', 12, 50021133, 2, ',50007218,50021133,50021255,', 0),
(50021254, 'pvc胶带', 11, 50021133, 2, ',50007218,50021133,50021254,', 0),
(50021253, 'opp胶带', 10, 50021133, 2, ',50007218,50021133,50021253,', 0),
(50021252, 'pet胶带', 9, 50021133, 2, ',50007218,50021133,50021252,', 0),
(50021251, 'pe胶带', 8, 50021133, 2, ',50007218,50021133,50021251,', 0),
(50021250, 'bopp胶带', 7, 50021133, 2, ',50007218,50021133,50021250,', 0),
(50021249, '牛皮纸胶带', 6, 50021133, 2, ',50007218,50021133,50021249,', 0),
(50021248, '美纹纸胶带', 5, 50021133, 2, ',50007218,50021133,50021248,', 0),
(50021247, '警示胶带', 4, 50021133, 2, ',50007218,50021133,50021247,', 0),
(50021246, '双面胶带', 3, 50021133, 2, ',50007218,50021133,50021246,', 0),
(50021245, '工业胶带', 2, 50021133, 2, ',50007218,50021133,50021245,', 0),
(50021244, '包装胶带', 1, 50021133, 2, ',50007218,50021133,50021244,', 0),
(50021243, '电工胶带', 0, 50021133, 2, ',50007218,50021133,50021243,', 0),
(50018947, '办公线材', 138, 50021132, 2, ',50007218,50021132,50018947,', 0),
(50021294, '其他绳索、扎带', 6, 50021132, 2, ',50007218,50021132,50021294,', 0),
(50021293, '捆扎绳', 5, 50021132, 2, ',50007218,50021132,50021293,', 0),
(50021292, '束线带', 4, 50021132, 2, ',50007218,50021132,50021292,', 0),
(50021291, '结束带', 3, 50021132, 2, ',50007218,50021132,50021291,', 0),
(50021290, '行李绳', 2, 50021132, 2, ',50007218,50021132,50021290,', 0),
(50021289, '捆绑带', 1, 50021132, 2, ',50007218,50021132,50021289,', 0),
(50021288, '打包带', 0, 50021132, 2, ',50007218,50021132,50021288,', 0),
(50021152, '警铃', 20, 50021120, 2, ',50020579,50021120,50021152,', 0),
(50021151, '报警灯', 19, 50021120, 2, ',50020579,50021120,50021151,', 0),
(50021150, '报警喇叭\\警号', 18, 50021120, 2, ',50020579,50021120,50021150,', 0),
(50021149, '消防稳压电源', 17, 50021120, 2, ',50020579,50021120,50021149,', 0),
(50021148, '壁挂广播控制柜', 16, 50021120, 2, ',50020579,50021120,50021148,', 0),
(50021147, '壁挂消防广播功放', 15, 50021120, 2, ',50020579,50021120,50021147,', 0),
(50021146, '吸顶式消防广播音箱', 14, 50021120, 2, ',50020579,50021120,50021146,', 0),
(50021145, '报警按钮', 13, 50021120, 2, ',50020579,50021120,50021145,', 0),
(50021144, '回路板', 12, 50021120, 2, ',50020579,50021120,50021144,', 0),
(50021143, '总线控制盘', 11, 50021120, 2, ',50020579,50021120,50021143,', 0),
(50021142, '气体灭火控制盘', 10, 50021120, 2, ',50020579,50021120,50021142,', 0),
(50021141, '火灾显示盘', 9, 50021120, 2, ',50020579,50021120,50021141,', 0),
(50021129, '报警模块', 8, 50021120, 2, ',50020579,50021120,50021129,', 0),
(50021128, '消防控制柜/控制箱', 7, 50021120, 2, ',50020579,50021120,50021128,', 0),
(50021127, '消防电话', 6, 50021120, 2, ',50020579,50021120,50021127,', 0),
(50021121, '喷淋头', 0, 50021120, 2, ',50020579,50021120,50021121,', 0),
(50008403, '安防配件', 38, 50021105, 2, ',50020579,50021105,50008403,', 0),
(50021119, '断电报警器', 6, 50021105, 2, ',50020579,50021105,50021119,', 0),
(50021118, '家用气体检测报警器', 5, 50021105, 2, ',50020579,50021105,50021118,', 0),
(50021117, '家用单机温感探测器', 4, 50021105, 2, ',50020579,50021105,50021117,', 0),
(50021116, '家用单机烟感探测器', 3, 50021105, 2, ',50020579,50021105,50021116,', 0),
(50021115, '智能电子脉冲围栏系统', 2, 50021105, 2, ',50020579,50021105,50021115,', 0),
(50021112, '报警主机', 1, 50021105, 2, ',50020579,50021105,50021112,', 0),
(50021106, '入侵检测设备', 0, 50021105, 2, ',50020579,50021105,50021106,', 1),
(50021104, '监控器材配件', 17, 50021057, 2, ',50020579,50021057,50021104,', 0),
(50021096, '成套监控系统', 16, 50021057, 2, ',50020579,50021057,50021096,', 0),
(50021095, '监控显示器', 15, 50021057, 2, ',50020579,50021057,50021095,', 0),
(50021094, '音频跟随器', 14, 50021057, 2, ',50020579,50021057,50021094,', 0),
(50021093, '音频采集卡', 13, 50021057, 2, ',50020579,50021057,50021093,', 0),
(50021092, '音频切换器', 12, 50021057, 2, ',50020579,50021057,50021092,', 0),
(50021091, '识音器/集音器', 11, 50021057, 2, ',50020579,50021057,50021091,', 0),
(50021090, '视频监控测试仪', 10, 50021057, 2, ',50020579,50021057,50021090,', 0),
(50021089, '云台', 9, 50021057, 2, ',50020579,50021057,50021089,', 0),
(50021084, '光端机', 8, 50021057, 2, ',50020579,50021057,50021084,', 0),
(50021083, '视频转换器', 7, 50021057, 2, ',50020579,50021057,50021083,', 0),
(50021082, '字符叠加器', 6, 50021057, 2, ',50020579,50021057,50021082,', 0),
(50021081, '视频解码器', 5, 50021057, 2, ',50020579,50021057,50021081,', 0),
(50021080, '画面分割器', 4, 50021057, 2, ',50020579,50021057,50021080,', 0),
(50021077, '视频采集卡', 3, 50021057, 2, ',50020579,50021057,50021077,', 1),
(50021076, '视频矩阵服务器', 2, 50021057, 2, ',50020579,50021057,50021076,', 0),
(50021073, '硬盘录像机/DVR', 1, 50021057, 2, ',50020579,50021057,50021073,', 1),
(50021060, '监控摄像机', 0, 50021057, 2, ',50020579,50021057,50021060,', 1),
(50025604, '佛珠/念珠', 10, 50021048, 2, ',50020857,50021048,50025604,', 1),
(50022569, '其他宗教工艺品', 4, 50021048, 2, ',50020857,50021048,50022569,', 0),
(50021052, '伊斯兰教工艺品', 3, 50021048, 2, ',50020857,50021048,50021052,', 0),
(50021051, '佛教工艺品', 2, 50021048, 2, ',50020857,50021048,50021051,', 0),
(50021050, '道教工艺品', 1, 50021048, 2, ',50020857,50021048,50021050,', 0),
(50021049, '基督教工艺品', 0, 50021048, 2, ',50020857,50021048,50021049,', 0),
(50022014, '其他国家特色', 8, 50021046, 2, ',50020857,50021046,50022014,', 0),
(50022013, '埃及特色', 7, 50021046, 2, ',50020857,50021046,50022013,', 0),
(50022012, '波西米亚特色', 6, 50021046, 2, ',50020857,50021046,50022012,', 0),
(50022011, '巴基斯坦特色', 5, 50021046, 2, ',50020857,50021046,50022011,', 0),
(50022010, '印度特色', 4, 50021046, 2, ',50020857,50021046,50022010,', 0),
(50022009, '俄罗斯特色', 3, 50021046, 2, ',50020857,50021046,50022009,', 0),
(50022008, '越南特色', 2, 50021046, 2, ',50020857,50021046,50022008,', 0),
(50022007, '北欧特色', 1, 50021046, 2, ',50020857,50021046,50022007,', 0),
(50022006, '泰国特色', 0, 50021046, 2, ',50020857,50021046,50022006,', 0),
(50022005, '赫哲族特色', 53, 50021045, 2, ',50020857,50021045,50022005,', 1),
(50022004, '珞巴族特色', 52, 50021045, 2, ',50020857,50021045,50022004,', 1),
(50022003, '门巴族特色', 51, 50021045, 2, ',50020857,50021045,50022003,', 1),
(50022002, '高山族特色', 50, 50021045, 2, ',50020857,50021045,50022002,', 1),
(50022001, '鄂伦春族特色', 49, 50021045, 2, ',50020857,50021045,50022001,', 1),
(50022000, '独龙族特色', 48, 50021045, 2, ',50020857,50021045,50022000,', 1),
(50021999, '塔塔尔族特色', 47, 50021045, 2, ',50020857,50021045,50021999,', 1),
(50021998, '京族特色', 46, 50021045, 2, ',50020857,50021045,50021998,', 1),
(50021997, '裕固族特色', 45, 50021045, 2, ',50020857,50021045,50021997,', 1),
(50021996, '保安族特色', 44, 50021045, 2, ',50020857,50021045,50021996,', 1),
(50021995, '德昂族特色', 43, 50021045, 2, ',50020857,50021045,50021995,', 1),
(50021994, '鄂温克族特色', 42, 50021045, 2, ',50020857,50021045,50021994,', 1),
(50021993, '俄罗斯族特色', 41, 50021045, 2, ',50020857,50021045,50021993,', 1),
(50021992, '乌孜别克族特色', 40, 50021045, 2, ',50020857,50021045,50021992,', 1),
(50021991, '怒族特色', 39, 50021045, 2, ',50020857,50021045,50021991,', 1),
(50021990, '塔吉克族特色', 38, 50021045, 2, ',50020857,50021045,50021990,', 1),
(50021989, '普米族特色', 37, 50021045, 2, ',50020857,50021045,50021989,', 1),
(50021988, '阿昌族特色', 36, 50021045, 2, ',50020857,50021045,50021988,', 1),
(50021987, '毛南族特色', 35, 50021045, 2, ',50020857,50021045,50021987,', 0),
(50021986, '撒拉族特色', 34, 50021045, 2, ',50020857,50021045,50021986,', 1),
(50021985, '布朗族特色', 33, 50021045, 2, ',50020857,50021045,50021985,', 1),
(50021984, '基诺族特色', 32, 50021045, 2, ',50020857,50021045,50021984,', 1),
(50021983, '锡伯族特色', 31, 50021045, 2, ',50020857,50021045,50021983,', 1),
(50021982, '侗族特色', 30, 50021045, 2, ',50020857,50021045,50021982,', 1),
(50021981, '哈尼族特色', 29, 50021045, 2, ',50020857,50021045,50021981,', 1),
(50021980, '土家族特色', 28, 50021045, 2, ',50020857,50021045,50021980,', 1),
(50021979, '羌族特色', 27, 50021045, 2, ',50020857,50021045,50021979,', 1),
(50021978, '仫佬族特色', 26, 50021045, 2, ',50020857,50021045,50021978,', 1),
(50021977, '达斡尔族特色', 25, 50021045, 2, ',50020857,50021045,50021977,', 1),
(50021976, '土族特色', 24, 50021045, 2, ',50020857,50021045,50021976,', 1),
(50021975, '柯尔克孜族特色', 23, 50021045, 2, ',50020857,50021045,50021975,', 1),
(50021974, '景颇族特色', 22, 50021045, 2, ',50020857,50021045,50021974,', 1),
(50021973, '纳西族特色', 21, 50021045, 2, ',50020857,50021045,50021973,', 1),
(50021972, '东乡族特色', 20, 50021045, 2, ',50020857,50021045,50021972,', 1),
(50021971, '水族特色', 19, 50021045, 2, ',50020857,50021045,50021971,', 1),
(50021970, '拉祜族特色', 18, 50021045, 2, ',50020857,50021045,50021970,', 1),
(50021969, '仡佬族特色', 17, 50021045, 2, ',50020857,50021045,50021969,', 1),
(50021968, '畲族特色', 16, 50021045, 2, ',50020857,50021045,50021968,', 1),
(50021967, '佤族特色', 15, 50021045, 2, ',50020857,50021045,50021967,', 1),
(50021966, '傈僳族特色', 14, 50021045, 2, ',50020857,50021045,50021966,', 1),
(50021965, '黎族特色', 13, 50021045, 2, ',50020857,50021045,50021965,', 1),
(50021964, '满族特色', 12, 50021045, 2, ',50020857,50021045,50021964,', 1),
(50021963, '朝鲜族特色', 11, 50021045, 2, ',50020857,50021045,50021963,', 1),
(50021962, '布依族特色', 10, 50021045, 2, ',50020857,50021045,50021962,', 1),
(50021961, '彝族特色', 9, 50021045, 2, ',50020857,50021045,50021961,', 1),
(50021960, '维吾尔族特色', 8, 50021045, 2, ',50020857,50021045,50021960,', 1),
(50021959, '回族特色', 7, 50021045, 2, ',50020857,50021045,50021959,', 1),
(50021958, '蒙古族特色', 6, 50021045, 2, ',50020857,50021045,50021958,', 1),
(50021922, '藏族特色', 5, 50021045, 2, ',50020857,50021045,50021922,', 1),
(50021921, '壮族特色', 4, 50021045, 2, ',50020857,50021045,50021921,', 1),
(50021920, '傣族特色', 3, 50021045, 2, ',50020857,50021045,50021920,', 1),
(50021919, '哈萨克族特色', 2, 50021045, 2, ',50020857,50021045,50021919,', 1),
(50021918, '白族特色', 1, 50021045, 2, ',50020857,50021045,50021918,', 1),
(50021917, '苗族特色', 0, 50021045, 2, ',50020857,50021045,50021917,', 1),
(50021044, '电线管配件', 1, 50021042, 2, ',50020579,50021042,50021044,', 0),
(50021043, '电线管', 0, 50021042, 2, ',50020579,50021042,50021043,', 0),
(50013504, '护套线', 16, 50021033, 2, ',50020579,50021033,50013504,', 0),
(50021040, '电缆线', 6, 50021033, 2, ',50020579,50021033,50021040,', 0),
(50021039, '电话线', 5, 50021033, 2, ',50020579,50021033,50021039,', 0),
(50021038, '音响线', 4, 50021033, 2, ',50020579,50021033,50021038,', 0),
(50021037, '视频线', 3, 50021033, 2, ',50020579,50021033,50021037,', 0),
(50021036, '网络线', 2, 50021033, 2, ',50020579,50021033,50021036,', 0),
(50021034, '单芯线', 0, 50021033, 2, ',50020579,50021033,50021034,', 0),
(50003473, '其它断路器', 24, 50021027, 2, ',50020579,50021027,50003473,', 0),
(50021031, '漏电保护器', 3, 50021027, 2, ',50020579,50021027,50021031,', 0),
(50021028, '空气开关', 0, 50021027, 2, ',50020579,50021027,50021028,', 0),
(50013402, '双控开关', 23, 50021011, 2, ',50020579,50021011,50013402,', 0),
(50022496, '其它开关', 15, 50021011, 2, ',50020579,50021011,50022496,', 0),
(50021026, '插卡取电开关', 14, 50021011, 2, ',50020579,50021011,50021026,', 0),
(50021025, '浴霸专用开关', 13, 50021011, 2, ',50020579,50021011,50021025,', 0),
(50021023, '智能开关', 11, 50021011, 2, ',50020579,50021011,50021023,', 0),
(50021022, '防溅盒', 10, 50021011, 2, ',50020579,50021011,50021022,', 0),
(50021020, '感应开关', 8, 50021011, 2, ',50020579,50021011,50021020,', 0),
(50021019, '触摸开关', 7, 50021011, 2, ',50020579,50021011,50021019,', 0),
(50021018, '门铃开关', 6, 50021011, 2, ',50020579,50021011,50021018,', 0),
(50021017, '调光开关', 5, 50021011, 2, ',50020579,50021011,50021017,', 0),
(50021016, '调速开关', 4, 50021011, 2, ',50020579,50021011,50021016,', 0),
(50021014, '多控开关', 2, 50021011, 2, ',50020579,50021011,50021014,', 0),
(50021013, '单控开关', 1, 50021011, 2, ',50020579,50021011,50021013,', 0),
(50021012, '遥控开关', 0, 50021011, 2, ',50020579,50021011,50021012,', 0),
(50013408, '其它电工配件', 21, 50020998, 2, ',50020579,50020998,50013408,', 0),
(50022300, '保险丝', 12, 50020998, 2, ',50020579,50020998,50022300,', 0),
(50022299, '电工胶带', 11, 50020998, 2, ',50020579,50020998,50022299,', 0),
(50021009, '汇流排', 10, 50020998, 2, ',50020579,50020998,50021009,', 0),
(50021008, '电度表', 9, 50020998, 2, ',50020579,50020998,50021008,', 0),
(50021005, '电视分配器', 6, 50020998, 2, ',50020579,50020998,50021005,', 0),
(50021003, '电笔', 4, 50020998, 2, ',50020579,50020998,50021003,', 0),
(50021001, '接线端子', 2, 50020998, 2, ',50020579,50020998,50021001,', 0),
(50020997, '强电布线箱', 1, 50020995, 2, ',50020579,50020995,50020997,', 0),
(50020996, '弱电布线箱', 0, 50020995, 2, ',50020579,50020995,50020996,', 0),
(50020987, '固定型', 1, 50020985, 2, ',50020579,50020985,50020987,', 0),
(50020986, '起动型', 0, 50020985, 2, ',50020579,50020985,50020986,', 0),
(50003858, '加速度继电器', 9, 50020978, 2, ',50020579,50020978,50003858,', 0),
(50020982, '温度继电器', 3, 50020978, 2, ',50020579,50020978,50020982,', 0),
(50020981, '时间继电器', 2, 50020978, 2, ',50020579,50020978,50020981,', 0),
(50020980, '固态继电器', 1, 50020978, 2, ',50020579,50020978,50020980,', 0),
(50020979, '电磁继电器', 0, 50020978, 2, ',50020579,50020978,50020979,', 0),
(50020977, '普通稳压器', 1, 50020975, 2, ',50020579,50020975,50020977,', 0),
(50020976, '电子变压器', 0, 50020975, 2, ',50020579,50020975,50020976,', 0),
(50020970, '晾衣架配件', 10, 50020966, 2, ',27,50020966,50020970,', 1),
(50020969, '固定式晾衣架', 2, 50020966, 2, ',27,50020966,50020969,', 0),
(50020968, '伸缩晾衣架', 1, 50020966, 2, ',27,50020966,50020968,', 0),
(50020967, '升降晾衣架', 0, 50020966, 2, ',27,50020966,50020967,', 0),
(50022250, '暖气片/散热器', 7, 50020906, 2, ',27,50020906,50022250,', 0),
(50022249, '低温热水辐射地暖', 6, 50020906, 2, ',27,50020906,50022249,', 1),
(50022244, '低温电热辐射地暖系统', 5, 50020906, 2, ',27,50020906,50022244,', 1),
(50021957, '其他', 11, 50020856, 2, ',50020808,50020856,50021957,', 0),
(50023383, '创意礼品', 10, 50020856, 2, ',50020808,50020856,50023383,', 0),
(50023380, '节日饰品', 9, 50020856, 2, ',50020808,50020856,50023380,', 0),
(50021956, '扭曲雕塑品', 8, 50020856, 2, ',50020808,50020856,50021956,', 0),
(50021955, '空中吊饰', 7, 50020856, 2, ',50020808,50020856,50021955,', 0),
(50021954, '搞怪杯子', 6, 50020856, 2, ',50020808,50020856,50021954,', 0),
(50021953, '创意门挡', 5, 50020856, 2, ',50020808,50020856,50021953,', 0),
(50021952, '女巫布艺', 4, 50020856, 2, ',50020808,50020856,50021952,', 0),
(50021951, '百变造型香皂', 3, 50020856, 2, ',50020808,50020856,50021951,', 0),
(50021950, '椰子壳', 2, 50020856, 2, ',50020808,50020856,50021950,', 0),
(50021949, '海螺/贝壳/珊瑚', 1, 50020856, 2, ',50020808,50020856,50021949,', 0),
(50021948, '幸运星/瓶', 0, 50020856, 2, ',50020808,50020856,50021948,', 0),
(50022439, '彩纸伞', 5, 50020851, 2, ',50020808,50020851,50022439,', 0),
(50022438, '油纸伞', 4, 50020851, 2, ',50020808,50020851,50022438,', 0),
(50022437, '仿丝伞', 3, 50020851, 2, ',50020808,50020851,50022437,', 0),
(50022436, '仿绸伞', 2, 50020851, 2, ',50020808,50020851,50022436,', 0),
(50022435, '花布伞', 1, 50020851, 2, ',50020808,50020851,50022435,', 0),
(50022434, '双丝伞', 0, 50020851, 2, ',50020808,50020851,50022434,', 0),
(50021933, '挂钟/落地钟', 1, 50020850, 2, ',50020808,50020850,50021933,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50021932, '台钟/闹钟', 0, 50020850, 2, ',50020808,50020850,50021932,', 0),
(50021926, '无味蜡烛', 3, 50020848, 2, ',50020808,50020848,50021926,', 0),
(50021927, '香薰蜡烛', 2, 50020848, 2, ',50020808,50020848,50021927,', 0),
(50021925, '烛台', 0, 50020848, 2, ',50020808,50020848,50021925,', 0),
(50021923, '照片/画片', 1, 50020841, 2, ',50020808,50020841,50021923,', 0),
(50021924, '照片墙', 0, 50020841, 2, ',50020808,50020841,50021924,', 0),
(50003454, '其他贴饰', 79, 50020840, 2, ',50020808,50020840,50003454,', 0),
(50011416, '马桶帖', 78, 50020840, 2, ',50020808,50020840,50011416,', 0),
(50011415, '开关贴', 7, 50020840, 2, ',50020808,50020840,50011415,', 0),
(50021915, '电脑贴', 5, 50020840, 2, ',50020808,50020840,50021915,', 0),
(50003338, '瓷砖/玻璃贴', 4, 50020840, 2, ',50020808,50020840,50003338,', 0),
(50013325, '冰箱贴', 3, 50020840, 2, ',50020808,50020840,50013325,', 0),
(50011738, '墙贴', 2, 50020840, 2, ',50020808,50020840,50011738,', 0),
(50023266, '装饰纸巾盒', 9, 50020836, 2, ',50020808,50020836,50023266,', 0),
(50021890, '果盘/果篓', 8, 50020836, 2, ',50020808,50020836,50021890,', 0),
(50021889, '装饰坐盘/挂盘', 7, 50020836, 2, ',50020808,50020836,50021889,', 0),
(50021888, '饰品盒', 6, 50020836, 2, ',50020808,50020836,50021888,', 0),
(50020905, '音乐盒', 5, 50020836, 2, ',50020808,50020836,50020905,', 0),
(50020904, '装饰烟灰缸', 4, 50020836, 2, ',50020808,50020836,50020904,', 0),
(50020903, '储物罐', 3, 50020836, 2, ',50020808,50020836,50020903,', 0),
(50020902, '阳光罐/月光罐', 2, 50020836, 2, ',50020808,50020836,50020902,', 0),
(50020900, '装饰碗/盆', 0, 50020836, 2, ',50020808,50020836,50020900,', 0),
(50020897, '炭雕（不含挂盘）', 4, 50020834, 2, ',50020808,50020834,50020897,', 0),
(50020896, '玉雕', 3, 50020834, 2, ',50020808,50020834,50020896,', 0),
(50020895, '木雕', 2, 50020834, 2, ',50020808,50020834,50020895,', 0),
(50020894, '石雕', 1, 50020834, 2, ',50020808,50020834,50020894,', 0),
(50020893, '根雕', 0, 50020834, 2, ',50020808,50020834,50020893,', 0),
(50020833, '其他', 1, 50020681, 2, ',50020611,50020681,50020833,', 0),
(50020830, '骨灰盒', 0, 50020681, 2, ',50020611,50020681,50020830,', 0),
(50020829, '其他', 13, 50020680, 2, ',50020611,50020680,50020829,', 0),
(50025204, '护理屏风', 12, 50020680, 2, ',50020611,50020680,50025204,', 0),
(50025202, '输液椅', 11, 50020680, 2, ',50020611,50020680,50025202,', 0),
(50025203, '牙科椅', 10, 50020680, 2, ',50020611,50020680,50025203,', 0),
(50020827, '助行器', 8, 50020680, 2, ',50020611,50020680,50020827,', 0),
(50020825, '护理床/理疗床', 6, 50020680, 2, ',50020611,50020680,50020825,', 0),
(50020824, '牵引椅', 5, 50020680, 2, ',50020611,50020680,50020824,', 0),
(50020823, '坐便椅', 4, 50020680, 2, ',50020611,50020680,50020823,', 0),
(50020822, '轮椅', 3, 50020680, 2, ',50020611,50020680,50020822,', 0),
(50020821, '医药架', 2, 50020680, 2, ',50020611,50020680,50020821,', 0),
(50015738, '实验柜', 28, 50020679, 2, ',50020611,50020679,50015738,', 0),
(50020817, '其他', 5, 50020679, 2, ',50020611,50020679,50020817,', 0),
(50020816, '实验台', 4, 50020679, 2, ',50020611,50020679,50020816,', 0),
(50020815, '黑板', 3, 50020679, 2, ',50020611,50020679,50020815,', 0),
(50020814, '演讲台', 2, 50020679, 2, ',50020611,50020679,50020814,', 0),
(50020813, '课桌椅', 1, 50020679, 2, ',50020611,50020679,50020813,', 0),
(50020811, '其他', 13, 50020677, 2, ',50020611,50020677,50020811,', 0),
(50020810, '工具车', 12, 50020677, 2, ',50020611,50020677,50020810,', 0),
(50024427, '毛巾柜', 10, 50020677, 2, ',50020611,50020677,50024427,', 0),
(50020807, '理发镜台', 9, 50020677, 2, ',50020611,50020677,50020807,', 0),
(50020806, '美甲台', 8, 50020677, 2, ',50020611,50020677,50020806,', 0),
(50020802, '大工椅/师傅椅', 6, 50020677, 2, ',50020611,50020677,50020802,', 0),
(50020801, '美发椅', 4, 50020677, 2, ',50020611,50020677,50020801,', 0),
(50020797, '美容/美发床', 2, 50020677, 2, ',50020611,50020677,50020797,', 0),
(50020790, '其他', 17, 50020675, 2, ',50020611,50020675,50020790,', 0),
(50020784, '沐浴桶', 14, 50020675, 2, ',50020611,50020675,50020784,', 0),
(50020781, '足浴盆', 12, 50020675, 2, ',50020611,50020675,50020781,', 0),
(50020777, '足浴/桑拿沙发', 9, 50020675, 2, ',50020611,50020675,50020777,', 0),
(50020775, '移动汗蒸房', 8, 50020675, 2, ',50020611,50020675,50020775,', 0),
(50020771, '桑拿手牌', 5, 50020675, 2, ',50020611,50020675,50020771,', 0),
(50020749, '酒吧凳', 11, 50020674, 2, ',50020611,50020674,50020749,', 0),
(50020760, '其他', 9, 50020674, 2, ',50020611,50020674,50020760,', 0),
(50020757, '卡座', 7, 50020674, 2, ',50020611,50020674,50020757,', 0),
(50020752, '红酒架/柜', 4, 50020674, 2, ',50020611,50020674,50020752,', 0),
(50020750, '跳舞台', 3, 50020674, 2, ',50020611,50020674,50020750,', 0),
(50020747, '酒吧椅', 1, 50020674, 2, ',50020611,50020674,50020747,', 0),
(50020745, '酒吧台', 0, 50020674, 2, ',50020611,50020674,50020745,', 0),
(50023272, '落地衣帽架', 12, 50020673, 2, ',50020611,50020673,50023272,', 0),
(50023271, '服装标签', 11, 50020673, 2, ',50020611,50020673,50023271,', 0),
(50023270, '吊环', 10, 50020673, 2, ',50020611,50020673,50023270,', 0),
(50023269, '挂钩', 9, 50020673, 2, ',50020611,50020673,50023269,', 0),
(50023268, '衣架', 8, 50020673, 2, ',50020611,50020673,50023268,', 0),
(50023267, '服装展示架', 7, 50020673, 2, ',50020611,50020673,50023267,', 0),
(50015532, '服装模特', 6, 50020673, 2, ',50020611,50020673,50015532,', 0),
(50020742, '其他', 6, 50020673, 2, ',50020611,50020673,50020742,', 0),
(50020737, '试鞋凳', 3, 50020673, 2, ',50020611,50020673,50020737,', 0),
(50020727, '餐盘收集车', 11, 50020672, 2, ',50020611,50020672,50020727,', 0),
(50020724, '餐柜', 9, 50020672, 2, ',50020611,50020672,50020724,', 0),
(50020722, '转盘', 8, 50020672, 2, ',50020611,50020672,50020722,', 0),
(50020721, '冷藏展示柜', 7, 50020672, 2, ',50020611,50020672,50020721,', 0),
(50020719, '面包展柜', 6, 50020672, 2, ',50020611,50020672,50020719,', 0),
(50020718, '卡座', 5, 50020672, 2, ',50020611,50020672,50020718,', 0),
(50020717, '沙发', 4, 50020672, 2, ',50020611,50020672,50020717,', 0),
(50020716, '餐台椅', 3, 50020672, 2, ',50020611,50020672,50020716,', 0),
(50020715, '火锅桌', 2, 50020672, 2, ',50020611,50020672,50020715,', 0),
(50005513, '餐车', 1, 50020672, 2, ',50020611,50020672,50005513,', 0),
(50020714, '餐台', 1, 50020672, 2, ',50020611,50020672,50020714,', 0),
(50020713, '餐台脚', 0, 50020672, 2, ',50020611,50020672,50020713,', 0),
(50020712, '美化丰富空间设施', 4, 50020671, 2, ',50020611,50020671,50020712,', 1),
(50020711, '信息服务设施', 3, 50020671, 2, ',50020611,50020671,50020711,', 1),
(50020710, '公共卫生服务设施', 2, 50020671, 2, ',50020611,50020671,50020710,', 1),
(50020709, '交通服务设施', 1, 50020671, 2, ',50020611,50020671,50020709,', 1),
(50020708, '公共休闲服务设施', 0, 50020671, 2, ',50020611,50020671,50020708,', 1),
(50022432, '卷发球', 63, 50009146, 2, ',50016348,50009146,50022432,', 0),
(50022428, '发圈/发网', 64, 50009146, 2, ',50016348,50009146,50022428,', 0),
(50006226, '其它电动工具', 69, 50020646, 2, ',50020485,50020646,50006226,', 0),
(50006225, '热溶胶枪', 67, 50020646, 2, ',50020485,50020646,50006225,', 0),
(50013388, '云石片', 66, 50020646, 2, ',50020485,50020646,50013388,', 0),
(50013374, '电锯片', 65, 50020646, 2, ',50020485,50020646,50013374,', 0),
(50013385, '电动批头', 63, 50020646, 2, ',50020485,50020646,50013385,', 0),
(50013369, '砂轮机', 62, 50020646, 2, ',50020485,50020646,50013369,', 0),
(50013376, '抛光机', 61, 50020646, 2, ',50020485,50020646,50013376,', 0),
(50013373, '修边机', 60, 50020646, 2, ',50020485,50020646,50013373,', 0),
(50013370, '雕刻机', 59, 50020646, 2, ',50020485,50020646,50013370,', 0),
(50020649, '电锯（新）', 58, 50020646, 2, ',50020485,50020646,50020649,', 1),
(50006219, '电钻', 55, 50020646, 2, ',50020485,50020646,50006219,', 0),
(50006222, '电锤', 54, 50020646, 2, ',50020485,50020646,50006222,', 0),
(50013387, '电剪', 53, 50020646, 2, ',50020485,50020646,50013387,', 0),
(50013378, '角磨机', 51, 50020646, 2, ',50020485,50020646,50013378,', 0),
(50013377, '砂纸机', 50, 50020646, 2, ',50020485,50020646,50013377,', 0),
(50013368, '电刨', 49, 50020646, 2, ',50020485,50020646,50013368,', 0),
(50013367, '切割机', 43, 50020646, 2, ',50020485,50020646,50013367,', 0),
(50013364, '电动螺丝批', 41, 50020646, 2, ',50020485,50020646,50013364,', 0),
(50020656, '界铝机', 12, 50020646, 2, ',50020485,50020646,50020656,', 0),
(50020655, '电动坡口机', 11, 50020646, 2, ',50020485,50020646,50020655,', 0),
(50020654, '光饰机', 10, 50020646, 2, ',50020485,50020646,50020654,', 0),
(50020653, '砂带机', 9, 50020646, 2, ',50020485,50020646,50020653,', 0),
(50020652, '螺丝机', 8, 50020646, 2, ',50020485,50020646,50020652,', 0),
(50020651, '电动套丝机', 7, 50020646, 2, ',50020485,50020646,50020651,', 0),
(50006218, '电磨/角磨机', 6, 50020646, 2, ',50020485,50020646,50006218,', 0),
(50020650, '倒角机', 5, 50020646, 2, ',50020485,50020646,50020650,', 0),
(50020648, '磨刀机', 3, 50020646, 2, ',50020485,50020646,50020648,', 0),
(50020647, '电动扳手', 2, 50020646, 2, ',50020485,50020646,50020647,', 1),
(50013386, '直磨机', 1, 50020646, 2, ',50020485,50020646,50013386,', 0),
(50020965, '其他', 15, 50020618, 2, ',50008164,50020618,50020965,', 0),
(50022495, '藏箱/扣箱', 14, 50020618, 2, ',50008164,50020618,50022495,', 0),
(50015841, '儿童玩具储物箱', 13, 50020618, 2, ',50008164,50020618,50015841,', 0),
(50020964, '家用保险箱', 3, 50020618, 2, ',50008164,50020618,50020964,', 0),
(50020963, '家用药箱', 2, 50020618, 2, ',50008164,50020618,50020963,', 0),
(50020962, '遮挡箱/钥匙盒', 1, 50020618, 2, ',50008164,50020618,50020962,', 0),
(50020961, '衣箱', 0, 50020618, 2, ',50008164,50020618,50020961,', 0),
(50020960, '其他', 3, 50020617, 2, ',50008164,50020617,50020960,', 0),
(50020959, '浴室镜', 2, 50020617, 2, ',50008164,50020617,50020959,', 0),
(50020958, '化妆镜', 1, 50020617, 2, ',50008164,50020617,50020958,', 0),
(50020957, '试衣镜', 0, 50020617, 2, ',50008164,50020617,50020957,', 0),
(50020956, '榻榻米辅料', 5, 50020615, 2, ',50008164,50020615,50020956,', 0),
(50024773, '和室门/窗', 4, 50020615, 2, ',50008164,50020615,50024773,', 0),
(50020953, '和室椅', 3, 50020615, 2, ',50008164,50020615,50020953,', 0),
(50020952, '升降桌', 2, 50020615, 2, ',50008164,50020615,50020952,', 0),
(50020951, '和室几桌', 1, 50020615, 2, ',50008164,50020615,50020951,', 0),
(50020950, '榻榻米垫', 0, 50020615, 2, ',50008164,50020615,50020950,', 0),
(50020949, '其他', 4, 50020614, 2, ',50008164,50020614,50020949,', 0),
(50020948, '根雕凳子', 3, 50020614, 2, ',50008164,50020614,50020948,', 0),
(50020947, '根雕茶桌', 2, 50020614, 2, ',50008164,50020614,50020947,', 0),
(50020946, '根雕花架', 1, 50020614, 2, ',50008164,50020614,50020946,', 0),
(50020945, '根雕茶几', 0, 50020614, 2, ',50008164,50020614,50020945,', 0),
(50020696, '蔬菜篮/水果篮', 31, 50020612, 2, ',50020611,50020612,50020696,', 0),
(50015735, '行李柜', 25, 50020612, 2, ',50020611,50020612,50015735,', 0),
(50020705, '其他', 23, 50020612, 2, ',50020611,50020612,50020705,', 0),
(50020704, '寄存柜', 22, 50020612, 2, ',50020611,50020612,50020704,', 0),
(50007018, '平板手推车/工具车', 15, 50020612, 2, ',50020611,50020612,50007018,', 0),
(50020697, '口香糖柜', 15, 50020612, 2, ',50020611,50020612,50020697,', 0),
(50020692, '米粮桶', 10, 50020612, 2, ',50020611,50020612,50020692,', 0),
(50020691, '购物篮/购物车', 9, 50020612, 2, ',50020611,50020612,50020691,', 0),
(50007020, '收银台', 5, 50020612, 2, ',50020611,50020612,50007020,', 0),
(50020684, '堆高车/装卸车', 2, 50020612, 2, ',50020611,50020612,50020684,', 0),
(50020610, '钢结构阳光房', 1, 50020608, 2, ',50020332,50020608,50020610,', 0),
(50020609, '铝合金阳光房', 0, 50020608, 2, ',50020332,50020608,50020609,', 0),
(50020974, '标准表', 3, 50020606, 2, ',50020579,50020606,50020974,', 0),
(50020973, '变频器', 2, 50020606, 2, ',50020579,50020606,50020973,', 0),
(50020972, '节能控制器', 1, 50020606, 2, ',50020579,50020606,50020972,', 0),
(50020971, '定时器', 0, 50020606, 2, ',50020579,50020606,50020971,', 0),
(50020605, '太阳能灯', 2, 50020602, 2, ',50020579,50020602,50020605,', 0),
(50020604, '太阳能电池组件', 1, 50020602, 2, ',50020579,50020602,50020604,', 0),
(50020603, '太阳能充电器', 0, 50020602, 2, ',50020579,50020602,50020603,', 0),
(50020601, '电源转换器', 1, 50020599, 2, ',50020579,50020599,50020601,', 0),
(50020600, '电池转换器器', 0, 50020599, 2, ',50020579,50020599,50020600,', 0),
(50020598, '地插底盒', 1, 50020596, 2, ',50020579,50020596,50020598,', 0),
(50020597, '开关/插座底盒', 0, 50020596, 2, ',50020579,50020596,50020597,', 0),
(50020595, '地插', 9, 50020585, 2, ',50020579,50020585,50020595,', 0),
(50020594, '电话+电视插座', 8, 50020585, 2, ',50020579,50020585,50020594,', 0),
(50020593, '电脑+电视插座', 7, 50020585, 2, ',50020579,50020585,50020593,', 0),
(50020592, '电脑+电话插座', 6, 50020585, 2, ',50020579,50020585,50020592,', 0),
(50020591, '带开关插座', 5, 50020585, 2, ',50020579,50020585,50020591,', 0),
(50020590, '音频插座', 4, 50020585, 2, ',50020579,50020585,50020590,', 0),
(50020589, '电话插座', 3, 50020585, 2, ',50020579,50020585,50020589,', 0),
(50020588, '电视插座', 2, 50020585, 2, ',50020579,50020585,50020588,', 0),
(50013403, '电源插座', 2, 50020585, 2, ',50020579,50020585,50013403,', 0),
(50020587, '电脑插座', 1, 50020585, 2, ',50020579,50020585,50020587,', 0),
(50013500, '多功能浴霸', 78, 50020573, 2, ',27,50020573,50013500,', 0),
(50020622, '风暖式浴霸', 1, 50020573, 2, ',27,50020573,50020622,', 0),
(50020619, '灯暖式浴霸', 0, 50020573, 2, ',27,50020573,50020619,', 0),
(50023322, '推拉力计', 36, 50020519, 2, ',50020485,50020519,50023322,', 0),
(50023321, '气体探测仪', 35, 50020519, 2, ',50020485,50020519,50023321,', 0),
(50023320, '温湿度计', 34, 50020519, 2, ',50020485,50020519,50023320,', 0),
(50023319, '电阻测试仪', 33, 50020519, 2, ',50020485,50020519,50023319,', 0),
(50023318, '电镀电容表', 32, 50020519, 2, ',50020485,50020519,50023318,', 0),
(50023317, '水份仪', 31, 50020519, 2, ',50020485,50020519,50023317,', 0),
(50023316, '测速仪', 30, 50020519, 2, ',50020485,50020519,50023316,', 0),
(50023315, '气体检测仪', 29, 50020519, 2, ',50020485,50020519,50023315,', 0),
(50023314, '酸度计', 28, 50020519, 2, ',50020485,50020519,50023314,', 0),
(50023313, '干燥箱', 27, 50020519, 2, ',50020485,50020519,50023313,', 0),
(50023312, '墙体探测仪', 26, 50020519, 2, ',50020485,50020519,50023312,', 0),
(50023311, '测亩仪', 25, 50020519, 2, ',50020485,50020519,50023311,', 0),
(50023310, '电子秤', 24, 50020519, 2, ',50020485,50020519,50023310,', 0),
(50023309, '流量计', 23, 50020519, 2, ',50020485,50020519,50023309,', 0),
(50006227, '电热工具', 22, 50020519, 2, ',50020485,50020519,50006227,', 0),
(50006950, '其它仪表仪器', 21, 50020519, 2, ',50020485,50020519,50006950,', 0),
(50002420, '万用表', 20, 50020519, 2, ',50020485,50020519,50002420,', 0),
(50009118, '测线仪', 19, 50020519, 2, ',50020485,50020519,50009118,', 0),
(50008958, '转速表', 18, 50020519, 2, ',50020485,50020519,50008958,', 0),
(50008957, '压力表', 17, 50020519, 2, ',50020485,50020519,50008957,', 0),
(50008959, '经纬仪', 16, 50020519, 2, ',50020485,50020519,50008959,', 0),
(50008956, '兆欧表', 15, 50020519, 2, ',50020485,50020519,50008956,', 0),
(50008960, '测湿仪', 14, 50020519, 2, ',50020485,50020519,50008960,', 0),
(50008954, '照度仪', 13, 50020519, 2, ',50020485,50020519,50008954,', 0),
(50008949, '测温仪', 12, 50020519, 2, ',50020485,50020519,50008949,', 0),
(50008953, '风速仪', 11, 50020519, 2, ',50020485,50020519,50008953,', 0),
(50008955, '噪音仪', 10, 50020519, 2, ',50020485,50020519,50008955,', 0),
(50008952, '测厚仪', 9, 50020519, 2, ',50020485,50020519,50008952,', 0),
(50008948, '水平仪', 8, 50020519, 2, ',50020485,50020519,50008948,', 0),
(50008951, '温控仪', 7, 50020519, 2, ',50020485,50020519,50008951,', 0),
(50008950, '测距仪', 6, 50020519, 2, ',50020485,50020519,50008950,', 0),
(50008947, '水表', 5, 50020519, 2, ',50020485,50020519,50008947,', 0),
(50008946, '电表', 4, 50020519, 2, ',50020485,50020519,50008946,', 0),
(50006069, '钳形表', 3, 50020519, 2, ',50020485,50020519,50006069,', 0),
(50021555, '示波器', 2, 50020519, 2, ',50020485,50020519,50021555,', 0),
(50021553, '燃气表', 0, 50020519, 2, ',50020485,50020519,50021553,', 0),
(50021267, '起重工具', 1, 50020494, 2, ',50020485,50020494,50021267,', 1),
(50021266, '液压工具', 0, 50020494, 2, ',50020485,50020494,50021266,', 1),
(50021265, '其他刃具', 11, 50020493, 2, ',50020485,50020493,50021265,', 0),
(50022511, '板牙', 10, 50020493, 2, ',50020485,50020493,50022511,', 0),
(50022507, '丝锥', 9, 50020493, 2, ',50020485,50020493,50022507,', 1),
(50022500, '钻头', 8, 50020493, 2, ',50020485,50020493,50022500,', 1),
(50022372, '拉刀（新）', 7, 50020493, 2, ',50020485,50020493,50022372,', 0),
(50021234, '镗刀', 5, 50020493, 2, ',50020485,50020493,50021234,', 0),
(50021233, '滚刀', 4, 50020493, 2, ',50020485,50020493,50021233,', 0),
(50021232, '刨刀', 3, 50020493, 2, ',50020485,50020493,50021232,', 0),
(50021231, '车刀', 2, 50020493, 2, ',50020485,50020493,50021231,', 1),
(50021230, '铰刀类', 1, 50020493, 2, ',50020485,50020493,50021230,', 1),
(50021229, '铣刀类', 0, 50020493, 2, ',50020485,50020493,50021229,', 1),
(50021303, '卷/美发棒', 62, 50009146, 2, ',50016348,50009146,50021303,', 0),
(50013434, '其它紧固件', 13, 50020492, 2, ',50020485,50020492,50013434,', 0),
(50021226, '组合件和连接副', 12, 50020492, 2, ',50020485,50020492,50021226,', 0),
(50021225, '销', 11, 50020492, 2, ',50020485,50020492,50021225,', 0),
(50021224, '挡圈', 10, 50020492, 2, ',50020485,50020492,50021224,', 0),
(50021223, '垫圈', 9, 50020492, 2, ',50020485,50020492,50021223,', 0),
(50021221, '膨胀类', 7, 50020492, 2, ',50020485,50020492,50021221,', 1),
(50022232, '螺母', 5, 50020492, 2, ',50020485,50020492,50022232,', 0),
(50021219, '螺钉', 4, 50020492, 2, ',50020485,50020492,50021219,', 0),
(50021218, '螺柱', 3, 50020492, 2, ',50020485,50020492,50021218,', 0),
(50021217, '螺栓', 2, 50020492, 2, ',50020485,50020492,50021217,', 0),
(50021227, '铆钉', 1, 50020492, 2, ',50020485,50020492,50021227,', 1),
(50013431, '钉', 0, 50020492, 2, ',50020485,50020492,50013431,', 0),
(50008700, '电池/电力配件', 10, 50020491, 2, ',50020485,50020491,50008700,', 0),
(50021215, '其他机电五金', 9, 50020491, 2, ',50020485,50020491,50021215,', 0),
(50021214, '电机配件', 8, 50020491, 2, ',50020485,50020491,50021214,', 0),
(50021212, '焊接设备', 6, 50020491, 2, ',50020485,50020491,50021212,', 1),
(50021211, '电热设备', 5, 50020491, 2, ',50020485,50020491,50021211,', 1),
(50022225, '泵', 4, 50020491, 2, ',50020485,50020491,50022225,', 1),
(50021210, '变速机', 3, 50020491, 2, ',50020485,50020491,50021210,', 1),
(50021209, '内燃机', 2, 50020491, 2, ',50020485,50020491,50021209,', 1),
(50021208, '电动机', 1, 50020491, 2, ',50020485,50020491,50021208,', 0),
(50021207, '发电机', 0, 50020491, 2, ',50020485,50020491,50021207,', 1),
(50013467, '其他机械五金（新）', 30, 50020490, 2, ',50020485,50020490,50013467,', 0),
(50021198, '化工管道及配件', 28, 50020490, 2, ',50020485,50020490,50021198,', 0),
(50021197, '喷嘴/喷头/接头', 27, 50020490, 2, ',50020485,50020490,50021197,', 0),
(50021196, '托辊', 26, 50020490, 2, ',50020485,50020490,50021196,', 0),
(50021195, '吊钩/抓钩', 25, 50020490, 2, ',50020485,50020490,50021195,', 0),
(50021194, '吊滑车', 24, 50020490, 2, ',50020485,50020490,50021194,', 0),
(50021192, '工作台', 22, 50020490, 2, ',50020485,50020490,50021192,', 0),
(50021191, '管夹', 21, 50020490, 2, ',50020485,50020490,50021191,', 0),
(50021190, '滚筒', 20, 50020490, 2, ',50020485,50020490,50021190,', 0),
(50021189, '滑轮', 19, 50020490, 2, ',50020485,50020490,50021189,', 0),
(50021188, '炉头', 18, 50020490, 2, ',50020485,50020490,50021188,', 0),
(50021187, '分离设备', 17, 50020490, 2, ',50020485,50020490,50021187,', 0),
(50021186, '密封件', 16, 50020490, 2, ',50020485,50020490,50021186,', 0),
(50021185, '弹簧', 15, 50020490, 2, ',50020485,50020490,50021185,', 0),
(50006519, '法兰（新）', 6, 50020490, 2, ',50020485,50020490,50006519,', 0),
(50021616, '阀门', 5, 50020490, 2, ',50020485,50020490,50021616,', 1),
(50021167, '轴承附属件', 4, 50020490, 2, ',50020485,50020490,50021167,', 1),
(50022301, '滑动轴承', 2, 50020490, 2, ',50020485,50020490,50022301,', 0),
(50020570, '滚动轴承', 1, 50020490, 2, ',50020485,50020490,50020570,', 1),
(50020569, '传动件', 0, 50020490, 2, ',50020485,50020490,50020569,', 1),
(50020567, '其他气动工具', 19, 50020489, 2, ',50020485,50020489,50020567,', 0),
(50013399, '气动元件', 18, 50020489, 2, ',50020485,50020489,50013399,', 0),
(50013397, '施工除尘器', 17, 50020489, 2, ',50020485,50020489,50013397,', 0),
(50013379, '热风枪', 16, 50020489, 2, ',50020485,50020489,50013379,', 0),
(50013380, '吹风枪', 15, 50020489, 2, ',50020485,50020489,50013380,', 0),
(50020566, '气动工具配件', 13, 50020489, 2, ',50020485,50020489,50020566,', 0),
(50020565, '气动封箱机', 12, 50020489, 2, ',50020485,50020489,50020565,', 0),
(50020564, '气动搅拌机', 11, 50020489, 2, ',50020485,50020489,50020564,', 0),
(50020563, '气锤', 10, 50020489, 2, ',50020485,50020489,50020563,', 0),
(50020562, '气动捣固机', 9, 50020489, 2, ',50020485,50020489,50020562,', 0),
(50020561, '气动铆钉机', 8, 50020489, 2, ',50020485,50020489,50020561,', 0),
(50020560, '气铲/气锹', 7, 50020489, 2, ',50020485,50020489,50020560,', 0),
(50020559, '气镐', 6, 50020489, 2, ',50020485,50020489,50020559,', 0),
(50020558, '气动磨光机', 5, 50020489, 2, ',50020485,50020489,50020558,', 0),
(50020557, '气动冷压接钳', 4, 50020489, 2, ',50020485,50020489,50020557,', 0),
(50020556, '气钉枪', 3, 50020489, 2, ',50020485,50020489,50020556,', 0),
(50020555, '气动螺丝刀', 2, 50020489, 2, ',50020485,50020489,50020555,', 0),
(50020554, '气动棘轮扳手', 1, 50020489, 2, ',50020485,50020489,50020554,', 0),
(50020553, '气动扳手', 0, 50020489, 2, ',50020485,50020489,50020553,', 0),
(50013359, '涂刷工具', 24, 50020487, 2, ',50020485,50020487,50013359,', 1),
(50010463, '其他手动工具', 23, 50020487, 2, ',50020485,50020487,50010463,', 1),
(50020524, '农具', 21, 50020487, 2, ',50020485,50020487,50020524,', 1),
(50020523, '汽修汽保工具', 20, 50020487, 2, ',50020485,50020487,50020523,', 1),
(50020522, '电子电工工具', 19, 50020487, 2, ',50020485,50020487,50020522,', 1),
(50020521, '工具包/箱/车', 18, 50020487, 2, ',50020485,50020487,50020521,', 1),
(50020520, '工具组合套装', 17, 50020487, 2, ',50020485,50020487,50020520,', 1),
(50020518, '测量工具', 15, 50020487, 2, ',50020485,50020487,50020518,', 1),
(50020517, '焊接喷涂', 14, 50020487, 2, ',50020485,50020487,50020517,', 1),
(50020516, '锉、刨', 13, 50020487, 2, ',50020485,50020487,50020516,', 1),
(50020515, '锯和锯条', 12, 50020487, 2, ',50020485,50020487,50020515,', 1),
(50020514, '冲、撬棒', 11, 50020487, 2, ',50020485,50020487,50020514,', 1),
(50020513, '划线工具', 10, 50020487, 2, ',50020485,50020487,50020513,', 1),
(50020509, '斧', 9, 50020487, 2, ',50020485,50020487,50020509,', 1),
(50020512, '刀', 8, 50020487, 2, ',50020485,50020487,50020512,', 1),
(50020511, '剪', 7, 50020487, 2, ',50020485,50020487,50020511,', 1),
(50020510, '凿', 6, 50020487, 2, ',50020485,50020487,50020510,', 1),
(50020508, '锤', 5, 50020487, 2, ',50020485,50020487,50020508,', 1),
(50020507, '螺丝批、旋具头', 4, 50020487, 2, ',50020485,50020487,50020507,', 1),
(50020505, '套筒及配件', 2, 50020487, 2, ',50020485,50020487,50020505,', 1),
(50020504, '扳手', 1, 50020487, 2, ',50020485,50020487,50020504,', 1),
(50020503, '夹持类工具', 0, 50020487, 2, ',50020485,50020487,50020503,', 1),
(50020502, '其他五金件', 8, 50020486, 2, ',50020485,50020486,50020502,', 1),
(50013448, '绳/链/钩', 7, 50020486, 2, ',50020485,50020486,50013448,', 1),
(50020501, '家具五金', 6, 50020486, 2, ',50020485,50020486,50020501,', 1),
(50020500, '窗用配件', 5, 50020486, 2, ',50020485,50020486,50020500,', 1),
(50020499, '门用配件', 4, 50020486, 2, ',50020485,50020486,50020499,', 1),
(50020498, '插销', 3, 50020486, 2, ',50020485,50020486,50020498,', 1),
(50020497, '拉手', 2, 50020486, 2, ',50020485,50020486,50020497,', 1),
(50020496, '合页', 1, 50020486, 2, ',50020485,50020486,50020496,', 1),
(50020495, '锁具', 0, 50020486, 2, ',50020485,50020486,50020495,', 1),
(50020484, '砂岩雕刻', 3, 50020480, 2, ',50020332,50020480,50020484,', 0),
(50020482, '砂岩背景墙', 1, 50020480, 2, ',50020332,50020480,50020482,', 0),
(50013512, '大理石制品', 11, 50020472, 2, ',50020332,50020472,50013512,', 0),
(50021502, '其它', 7, 50020472, 2, ',50020332,50020472,50021502,', 0),
(50020479, '啡岗纹系列', 6, 50020472, 2, ',50020332,50020472,50020479,', 0),
(50020478, '爵士白系列', 5, 50020472, 2, ',50020332,50020472,50020478,', 0),
(50020477, '黑墨玉系列', 4, 50020472, 2, ',50020332,50020472,50020477,', 0),
(50020476, '晚霞红系列', 3, 50020472, 2, ',50020332,50020472,50020476,', 0),
(50020475, '墨绿玉系列', 2, 50020472, 2, ',50020332,50020472,50020475,', 0),
(50020474, '雪花白系列', 1, 50020472, 2, ',50020332,50020472,50020474,', 0),
(50020473, '米黄系列', 0, 50020472, 2, ',50020332,50020472,50020473,', 0),
(50020466, '其它', 6, 50020459, 2, ',50020332,50020459,50020466,', 0),
(50020465, '亚克力板', 5, 50020459, 2, ',50020332,50020459,50020465,', 0),
(50020464, '金箔', 4, 50020459, 2, ',50020332,50020459,50020464,', 0),
(50020463, '有机玻璃板', 3, 50020459, 2, ',50020332,50020459,50020463,', 0),
(50020462, '透光石', 2, 50020459, 2, ',50020332,50020459,50020462,', 0),
(50020461, '有机玻璃棒', 1, 50020459, 2, ',50020332,50020459,50020461,', 0),
(50020460, '装饰性吸音材料', 0, 50020459, 2, ',50020332,50020459,50020460,', 0),
(50013518, '彩绘玻璃', 9, 50020449, 2, ',50020332,50020449,50013518,', 0),
(50020457, '普通平板玻璃', 7, 50020449, 2, ',50020332,50020449,50020457,', 0),
(50020456, '磨沙玻璃', 6, 50020449, 2, ',50020332,50020449,50020456,', 0),
(50020455, '艺术玻璃', 5, 50020449, 2, ',50020332,50020449,50020455,', 0),
(50020454, '钢化玻璃', 4, 50020449, 2, ',50020332,50020449,50020454,', 0),
(50020453, '防弹玻璃', 3, 50020449, 2, ',50020332,50020449,50020453,', 0),
(50020452, '夹胶玻璃', 2, 50020449, 2, ',50020332,50020449,50020452,', 0),
(50020451, '中空玻璃', 1, 50020449, 2, ',50020332,50020449,50020451,', 0),
(50020450, '玻璃砖', 0, 50020449, 2, ',50020332,50020449,50020450,', 0),
(50020448, '实木梁托', 2, 50020445, 2, ',50020332,50020445,50020448,', 0),
(50020447, '其它木雕', 1, 50020445, 2, ',50020332,50020445,50020447,', 0),
(50020446, '通花板', 0, 50020445, 2, ',50020332,50020445,50020446,', 0),
(50022514, '睡袋', 44, 50012791, 2, ',50008163,50012791,50022514,', 0),
(50008246, '凉席/竹席/藤席/草席/牛皮席', 42, 50012791, 2, ',50008163,50012791,50008246,', 0),
(210111, '蚊帐/床幔', 41, 50012791, 2, ',50008163,50012791,210111,', 0),
(50008260, '床品定制/定做', 38, 50012791, 2, ',50008163,50012791,50008260,', 1),
(50008247, '婴童床品', 29, 50012791, 2, ',50008163,50012791,50008247,', 1),
(50008824, '婚庆床品', 23, 50012791, 2, ',50008163,50012791,50008824,', 0),
(50010888, '枕套/枕巾', 12, 50012791, 2, ',50008163,50012791,50010888,', 0),
(210103, '床单/床裙/床笠/床罩', 11, 50012791, 2, ',50008163,50012791,210103,', 0),
(50001865, '被套', 10, 50012791, 2, ',50008163,50012791,50001865,', 0),
(50008565, '床垫/床褥/床护垫/榻榻米床垫', 5, 50012791, 2, ',50008163,50012791,50008565,', 0),
(50002777, '枕头/枕芯/保健枕/颈椎枕', 4, 50012791, 2, ',50008163,50012791,50002777,', 0),
(50010825, '被子/蚕丝被/羽绒被/棉被', 1, 50012791, 2, ',50008163,50012791,50010825,', 0),
(50008779, '床品套件/四件套/多件套', 0, 50012791, 2, ',50008163,50012791,50008779,', 0),
(50005064, '其它收藏品鉴定/保养用具', 5, 50005060, 2, ',23,50005060,50005064,', 0),
(50005063, '玉器鉴定/保养工具', 4, 50005060, 2, ',23,50005060,50005063,', 0),
(50005062, '古玩鉴定/保养工具', 3, 50005060, 2, ',23,50005060,50005062,', 0),
(50008606, '钱币收藏用具用品', 2, 50005060, 2, ',23,50005060,50008606,', 0),
(50005061, '集邮用具用品', 1, 50005060, 2, ',23,50005060,50005061,', 0),
(50005268, '其它MP3/MP4配件', 27, 50005051, 2, ',50008090,50005051,50005268,', 0),
(120802, '耳机配件', 19, 50005051, 2, ',50008090,50005051,120802,', 0),
(50023279, 'MP3/MP4连接线', 18, 50005051, 2, ',50008090,50005051,50023279,', 0),
(50023278, 'MP3/MP4保护套', 17, 50005051, 2, ',50008090,50005051,50023278,', 0),
(50023277, '耳塞保护套', 15, 50005051, 2, ',50008090,50005051,50023277,', 0),
(50005263, 'MP3/MP4充电器', 12, 50005051, 2, ',50008090,50005051,50005263,', 0),
(50023280, 'MP3/MP4耳机', 11, 50005051, 2, ',50008090,50005051,50023280,', 0),
(50006247, 'MP4屏幕保护膜', 5, 50005051, 2, ',50008090,50005051,50006247,', 0),
(50005265, 'MP3/MP4支架', 5, 50005051, 2, ',50008090,50005051,50005265,', 0),
(50005262, 'FM/MP3发射器', 3, 50005051, 2, ',50008090,50005051,50005262,', 0),
(50021704, '耳机线夹', 2, 50005051, 2, ',50008090,50005051,50021704,', 0),
(50004968, '其它培训课程', 11, 50004960, 2, ',33,50004960,50004968,', 0),
(50004963, '人力资源培训课程', 9, 50004960, 2, ',33,50004960,50004963,', 0),
(50004962, '采购物流培训课程', 8, 50004960, 2, ',33,50004960,50004962,', 0),
(50004961, '经营管理培训课程', 7, 50004960, 2, ',33,50004960,50004961,', 0),
(50004967, 'MBA课程', 5, 50004960, 2, ',33,50004960,50004967,', 0),
(50004966, '市场销售培训课程', 4, 50004960, 2, ',33,50004960,50004966,', 0),
(50004965, '财税金融培训课程', 3, 50004960, 2, ',33,50004960,50004965,', 0),
(50004964, '团队沟通培训课程', 2, 50004960, 2, ',33,50004960,50004964,', 0),
(50008878, '淘宝大学指定培训课程', 1, 50004960, 2, ',33,50004960,50008878,', 0),
(333805, '人物/传记其它', 20, 50004925, 2, ',33,50004925,333805,', 0),
(50004927, '领袖/政治人物', 0, 50004925, 2, ',33,50004925,50004927,', 0),
(50004938, '音乐家', 0, 50004925, 2, ',33,50004925,50004938,', 0),
(50004933, '财经人物', 0, 50004925, 2, ',33,50004925,50004933,', 0),
(50004934, '艺术家/建筑设计', 0, 50004925, 2, ',33,50004925,50004934,', 0),
(50004926, '综合', 0, 50004925, 2, ',33,50004925,50004926,', 0),
(50004931, '科学家', 0, 50004925, 2, ',33,50004925,50004931,', 0),
(50004930, '法律人物', 0, 50004925, 2, ',33,50004925,50004930,', 0),
(50004942, '普通百姓', 0, 50004925, 2, ',33,50004925,50004942,', 0),
(50004940, '文学家', 0, 50004925, 2, ',33,50004925,50004940,', 0),
(50004937, '教育家', 0, 50004925, 2, ',33,50004925,50004937,', 0),
(50004935, '宗教人物', 0, 50004925, 2, ',33,50004925,50004935,', 0),
(50004939, '娱乐圈/影星/歌星', 0, 50004925, 2, ',33,50004925,50004939,', 0),
(50004928, '哲学家', 0, 50004925, 2, ',33,50004925,50004928,', 0),
(50004936, '历史人物', 0, 50004925, 2, ',33,50004925,50004936,', 0),
(50004932, '医学家', 0, 50004925, 2, ',33,50004925,50004932,', 0),
(50004929, '军事人物', 0, 50004925, 2, ',33,50004925,50004929,', 0),
(50004941, '体育界', 0, 50004925, 2, ',33,50004925,50004941,', 0),
(3309, '政治军事其它', 11, 50004893, 2, ',33,50004893,3309,', 0),
(50004916, '领袖著作', 0, 50004893, 2, ',33,50004893,50004916,', 0),
(50004915, '时政', 0, 50004893, 2, ',33,50004893,50004915,', 0),
(50004911, '政治理论', 0, 50004893, 2, ',33,50004893,50004911,', 0),
(50004914, '外交/国际关系', 0, 50004893, 2, ',33,50004893,50004914,', 0),
(50004919, '军事理论', 0, 50004893, 2, ',33,50004893,50004919,', 0),
(50004922, '军事技术', 0, 50004893, 2, ',33,50004893,50004922,', 0),
(50004924, '兵器', 0, 50004893, 2, ',33,50004893,50004924,', 0),
(50004918, '公共管理', 0, 50004893, 2, ',33,50004893,50004918,', 0),
(50004917, '党政读物', 0, 50004893, 2, ',33,50004893,50004917,', 0),
(50004923, '中外战争纪实', 0, 50004893, 2, ',33,50004893,50004923,', 0),
(50004912, '中国政治', 0, 50004893, 2, ',33,50004893,50004912,', 0),
(50004920, '中国军事', 0, 50004893, 2, ',33,50004893,50004920,', 0),
(50004913, '世界政治', 0, 50004893, 2, ',33,50004893,50004913,', 0),
(50004921, '世界军事', 0, 50004893, 2, ',33,50004893,50004921,', 0),
(50004875, '艺术类原版书', 0, 50004870, 2, ',33,50004870,50004875,', 0),
(50004882, '自然科学类原版书', 0, 50004870, 2, ',33,50004870,50004882,', 0),
(50004871, '考试类原版书', 0, 50004870, 2, ',33,50004870,50004871,', 0),
(50004883, '经济类原版书', 0, 50004870, 2, ',33,50004870,50004883,', 0),
(50004884, '管理类原版书', 0, 50004870, 2, ',33,50004870,50004884,', 0),
(50004874, '科普读物原版书', 0, 50004870, 2, ',33,50004870,50004874,', 0),
(50004881, '科学技术类原版书', 0, 50004870, 2, ',33,50004870,50004881,', 0),
(50004876, '社会科学类原版书', 0, 50004870, 2, ',33,50004870,50004876,', 0),
(50004880, '生活类原版书', 0, 50004870, 2, ',33,50004870,50004880,', 0),
(50004886, '法律类原版书', 0, 50004870, 2, ',33,50004870,50004886,', 0),
(50004878, '旅游类原版书', 0, 50004870, 2, ',33,50004870,50004878,', 0),
(50004872, '文学类原版书', 0, 50004870, 2, ',33,50004870,50004872,', 0),
(50004885, '文化类原版书', 0, 50004870, 2, ',33,50004870,50004885,', 0),
(50004890, '工具书原版书', 0, 50004870, 2, ',33,50004870,50004890,', 0),
(50004873, '小说类原版书', 0, 50004870, 2, ',33,50004870,50004873,', 0),
(50004879, '娱乐时尚类原版书', 0, 50004870, 2, ',33,50004870,50004879,', 0),
(50005169, '原版期刊杂志', 0, 50004870, 2, ',33,50004870,50005169,', 1),
(50004892, '原版其它', 0, 50004870, 2, ',33,50004870,50004892,', 0),
(50004889, '儿童读物原版书', 0, 50004870, 2, ',33,50004870,50004889,', 0),
(50004877, '健康类原版书', 0, 50004870, 2, ',33,50004870,50004877,', 0),
(50004887, '人文社科类原版书', 0, 50004870, 2, ',33,50004870,50004887,', 0),
(50004852, '起名儿', 0, 50004849, 2, ',33,50004849,50004852,', 0),
(50002832, '家庭教育其它', 0, 50004849, 2, ',33,50004849,50002832,', 0),
(50004855, '好家长妙诀', 0, 50004849, 2, ',33,50004849,50004855,', 0),
(50004854, '启蒙/认知卡片', 0, 50004849, 2, ',33,50004849,50004854,', 0),
(50004850, '准父母读物', 0, 50004849, 2, ',33,50004849,50004850,', 0),
(50004853, '儿童营养健康', 0, 50004849, 2, ',33,50004849,50004853,', 0),
(333203, '地图其它', 1, 50004835, 2, ',33,50004835,333203,', 0),
(50004837, '生活地图', 0, 50004835, 2, ',33,50004835,50004837,', 0),
(50004836, '旅游地图册/集', 0, 50004835, 2, ',33,50004835,50004836,', 0),
(50004843, '国家/地区概况', 0, 50004835, 2, ',33,50004835,50004843,', 0),
(50004841, '中国行政区划图', 0, 50004835, 2, ',33,50004835,50004841,', 0),
(50004840, '世界行政区划图册/集', 0, 50004835, 2, ',33,50004835,50004840,', 0),
(50004839, '世界行政区划图', 0, 50004835, 2, ',33,50004835,50004839,', 0),
(50050276, '司法鉴定', 13, 50004816, 2, ',33,50004816,50050276,', 0),
(50050275, '刑法', 12, 50004816, 2, ',33,50004816,50050275,', 0),
(50050274, '商法', 11, 50004816, 2, ',33,50004816,50050274,', 0),
(50050273, '民法', 10, 50004816, 2, ',33,50004816,50050273,', 0),
(50050272, '劳动与社会保障法', 9, 50004816, 2, ',33,50004816,50050272,', 0),
(50050270, '港澳台地区法律', 8, 50004816, 2, ',33,50004816,50050270,', 0),
(50050268, '法律实务', 7, 50004816, 2, ',33,50004816,50050268,', 0),
(50050266, '犯罪学', 6, 50004816, 2, ',33,50004816,50050266,', 0),
(50050264, '经济法', 5, 50004816, 2, ',33,50004816,50050264,', 0),
(50050262, '宪法', 4, 50004816, 2, ',33,50004816,50050262,', 0),
(3340, '法律其它', 3, 50004816, 2, ',33,50004816,3340,', 0),
(50004825, '高等法律教材', 0, 50004816, 2, ',33,50004816,50004825,', 0),
(50004818, '法律知识读物', 0, 50004816, 2, ',33,50004816,50004818,', 0),
(50004823, '法律法规', 0, 50004816, 2, ',33,50004816,50004823,', 0),
(50004822, '法律文书写作', 0, 50004816, 2, ',33,50004816,50004822,', 0),
(50004817, '法学理论', 0, 50004816, 2, ',33,50004816,50004817,', 0),
(50004819, '司法案例/司法解释', 0, 50004816, 2, ',33,50004816,50004819,', 0),
(50004824, '司法制度', 0, 50004816, 2, ',33,50004816,50004824,', 0),
(50004826, '世界各国法律', 0, 50004816, 2, ',33,50004816,50004826,', 0),
(333802, '文化其它', 31, 50004806, 2, ',33,50004806,333802,', 0),
(50004813, '神秘现象', 0, 50004806, 2, ',33,50004806,50004813,', 0),
(50004810, '文化评述', 0, 50004806, 2, ',33,50004806,50004810,', 0),
(50004807, '文化理论', 0, 50004806, 2, ',33,50004806,50004807,', 0),
(50004815, '地域文化', 0, 50004806, 2, ',33,50004806,50004815,', 0),
(50004809, '中国民俗', 0, 50004806, 2, ',33,50004806,50004809,', 0),
(50004808, '中国文化', 0, 50004806, 2, ',33,50004806,50004808,', 0),
(50004812, '世界文化', 0, 50004806, 2, ',33,50004806,50004812,', 0),
(50050328, '电子/通信', 91, 50004788, 2, ',33,50004788,50050328,', 1),
(50000180, '轻工业', 9, 50004788, 2, ',33,50004788,50000180,', 0),
(50004790, '工业技术其它', 9, 50004788, 2, ',33,50004788,50004790,', 0),
(50004802, '航空航天', 0, 50004788, 2, ',33,50004788,50004802,', 0),
(50004957, '自动化技术', 0, 50004788, 2, ',33,50004788,50004957,', 0),
(50004793, '能源与动力工程', 0, 50004788, 2, ',33,50004788,50004793,', 0),
(50004792, '矿业技术', 0, 50004788, 2, ',33,50004788,50004792,', 0),
(50004955, '石油 天然气工业', 0, 50004788, 2, ',33,50004788,50004955,', 0),
(50004798, '电子电路', 0, 50004788, 2, ',33,50004788,50004798,', 0),
(50004803, '电力电工', 0, 50004788, 2, ',33,50004788,50004803,', 0),
(50004795, '电信通信', 0, 50004788, 2, ',33,50004788,50004795,', 0),
(50004791, '环境科学', 0, 50004788, 2, ',33,50004788,50004791,', 0),
(50004799, '汽车', 0, 50004788, 2, ',33,50004788,50004799,', 0),
(50004797, '机械工程', 0, 50004788, 2, ',33,50004788,50004797,', 0),
(50004753, '建筑/水利', 0, 50004788, 2, ',33,50004788,50004753,', 1),
(50004800, '家用电器', 0, 50004788, 2, ',33,50004788,50004800,', 0),
(50004794, '原子能技术', 0, 50004788, 2, ',33,50004788,50004794,', 0),
(50004796, '化学工业', 0, 50004788, 2, ',33,50004788,50004796,', 0),
(50004801, '冶金工业', 0, 50004788, 2, ',33,50004788,50004801,', 0),
(50004782, '农业', 0, 50004788, 2, ',33,50004788,50004782,', 1),
(50004956, '交通/运输', 0, 50004788, 2, ',33,50004788,50004956,', 0),
(50019271, '护理学', 3, 50004767, 2, ',33,50004767,50019271,', 0),
(3342, '医学其它', 2, 50004767, 2, ',33,50004767,3342,', 0),
(50004771, '耳鼻喉科学', 0, 50004767, 2, ',33,50004767,50004771,', 0),
(50004777, '老年病学', 0, 50004767, 2, ',33,50004767,50004777,', 0),
(50004770, '眼科学', 0, 50004767, 2, ',33,50004767,50004770,', 0),
(50004769, '皮肤病/性病', 0, 50004767, 2, ',33,50004767,50004769,', 0),
(50004778, '急救急诊', 0, 50004767, 2, ',33,50004767,50004778,', 0),
(50004781, '影像医学', 0, 50004767, 2, ',33,50004767,50004781,', 0),
(50004772, '妇产科学', 0, 50004767, 2, ',33,50004767,50004772,', 0),
(50004774, '外科学', 0, 50004767, 2, ',33,50004767,50004774,', 0),
(50004776, '基础医学', 0, 50004767, 2, ',33,50004767,50004776,', 0),
(50004768, '口腔科学', 0, 50004767, 2, ',33,50004767,50004768,', 0),
(50004775, '内科学', 0, 50004767, 2, ',33,50004767,50004775,', 0),
(50004773, '儿科学', 0, 50004767, 2, ',33,50004767,50004773,', 0),
(50004779, '中医', 0, 50004767, 2, ',33,50004767,50004779,', 0),
(50003127, '孕产妇保健', 8, 50004743, 2, ',33,50004743,50003127,', 0),
(50004747, '饮食营养 食疗', 0, 50004743, 2, ',33,50004743,50004747,', 0),
(50004744, '男性健康', 0, 50004743, 2, ',33,50004743,50004744,', 0),
(50004751, '性保健', 0, 50004743, 2, ',33,50004743,50004751,', 0),
(50004752, '心理健康', 0, 50004743, 2, ',33,50004743,50004752,', 0),
(50004749, '常见病防治', 0, 50004743, 2, ',33,50004743,50004749,', 0),
(50004750, '家庭医生', 0, 50004743, 2, ',33,50004743,50004750,', 0),
(50004745, '女性健康', 0, 50004743, 2, ',33,50004743,50004745,', 0),
(333403, '健身', 0, 50004743, 2, ',33,50004743,333403,', 0),
(50004746, '中老年保健', 0, 50004743, 2, ',33,50004743,50004746,', 0),
(50004748, '中医养生', 0, 50004743, 2, ',33,50004743,50004748,', 0),
(50003129, '旅游其它', 9, 50004725, 2, ',33,50004725,50003129,', 0),
(50004729, '非洲', 0, 50004725, 2, ',33,50004725,50004729,', 0),
(50004731, '美洲', 0, 50004725, 2, ',33,50004725,50004731,', 0),
(50004733, '特色旅游', 0, 50004725, 2, ',33,50004725,50004733,', 0),
(50004730, '欧洲', 0, 50004725, 2, ',33,50004725,50004730,', 0),
(50004735, '旅游随笔', 0, 50004725, 2, ',33,50004725,50004735,', 0),
(50004739, '旅游理论与实务', 0, 50004725, 2, ',33,50004725,50004739,', 0),
(50004736, '旅游摄影/画册', 0, 50004725, 2, ',33,50004725,50004736,', 0),
(50004734, '旅游小百科', 0, 50004725, 2, ',33,50004725,50004734,', 0),
(50004738, '导游专业用书', 0, 50004725, 2, ',33,50004725,50004738,', 0),
(50004732, '大洋洲', 0, 50004725, 2, ',33,50004725,50004732,', 0),
(50004727, '国外游(综合)', 0, 50004725, 2, ',33,50004725,50004727,', 0),
(50004728, '亚洲', 0, 50004725, 2, ',33,50004725,50004728,', 0),
(50000178, '科普读物其它', 20, 50004707, 2, ',33,50004707,50000178,', 0),
(50004720, '鸟类', 0, 50004707, 2, ',33,50004707,50004720,', 0),
(50004712, '自然灾害', 0, 50004707, 2, ',33,50004707,50004712,', 0),
(50004713, '生态', 0, 50004707, 2, ',33,50004707,50004713,', 0),
(50000186, '环境保护/治理', 0, 50004707, 2, ',33,50004707,50000186,', 0),
(50004711, '海洋生物', 0, 50004707, 2, ',33,50004707,50004711,', 0),
(50004717, '海洋', 0, 50004707, 2, ',33,50004707,50004717,', 0),
(50004719, '河流', 0, 50004707, 2, ',33,50004707,50004719,', 0),
(50004718, '气象', 0, 50004707, 2, ',33,50004707,50004718,', 0),
(50004710, '植物', 0, 50004707, 2, ',33,50004707,50004710,', 0),
(50004716, '星体观测', 0, 50004707, 2, ',33,50004707,50004716,', 0),
(50004721, '昆虫', 0, 50004707, 2, ',33,50004707,50004721,', 0),
(50004715, '地震', 0, 50004707, 2, ',33,50004707,50004715,', 0),
(50004708, '历史学', 0, 50004707, 2, ',33,50004707,50004708,', 0),
(50004709, '动物', 0, 50004707, 2, ',33,50004707,50004709,', 0),
(50004714, '人类', 0, 50004707, 2, ',33,50004707,50004714,', 0),
(50050293, '金融与投资', 91, 50004687, 2, ',33,50004687,50050293,', 1),
(50003155, '经济其它', 20, 50004687, 2, ',33,50004687,50003155,', 0),
(50000064, '贸易/WTO', 1, 50004687, 2, ',33,50004687,50000064,', 0),
(50004691, '通货膨胀', 0, 50004687, 2, ',33,50004687,50004691,', 0),
(50004690, '贸易政策', 0, 50004687, 2, ',33,50004687,50004690,', 0),
(50004689, '统计 审计', 0, 50004687, 2, ',33,50004687,50004689,', 0),
(50004699, '经济理论', 0, 50004687, 2, ',33,50004687,50004699,', 0),
(50004695, '经济法', 0, 50004687, 2, ',33,50004687,50004695,', 0),
(50004697, '经济史', 0, 50004687, 2, ',33,50004687,50004697,', 0),
(50003157, '税务理论/实用税务', 0, 50004687, 2, ',33,50004687,50003157,', 0),
(50004694, '各部门经济', 0, 50004687, 2, ',33,50004687,50004694,', 0),
(50004688, '区域经济', 0, 50004687, 2, ',33,50004687,50004688,', 0),
(50000071, '保险业', 0, 50004687, 2, ',33,50004687,50000071,', 0),
(50004692, '中国经济', 0, 50004687, 2, ',33,50004687,50004692,', 0),
(50004693, '世界及各国经济概况', 0, 50004687, 2, ',33,50004687,50004693,', 0),
(50050256, '港澳台小说', 27, 50004674, 2, ',33,50004674,50050256,', 0),
(50050255, '青春小说', 26, 50004674, 2, ',33,50004674,50050255,', 0),
(50050254, '都市/情感小说', 25, 50004674, 2, ',33,50004674,50050254,', 0),
(50050253, '官场小说', 24, 50004674, 2, ',33,50004674,50050253,', 0),
(50050252, '乡土小说', 23, 50004674, 2, ',33,50004674,50050252,', 0),
(50050251, '网络小说', 22, 50004674, 2, ',33,50004674,50050251,', 0),
(50050250, '职场小说', 21, 50004674, 2, ',33,50004674,50050250,', 0),
(50005701, '其它小说', 20, 50004674, 2, ',33,50004674,50005701,', 0),
(50004677, '影视同期书', 19, 50004674, 2, ',33,50004674,50004677,', 0),
(50004676, '世界名著', 18, 50004674, 2, ',33,50004674,50004676,', 0),
(50004675, '作品集', 17, 50004674, 2, ',33,50004674,50004675,', 0),
(50000146, '历史小说', 6, 50004674, 2, ',33,50004674,50000146,', 0),
(50000145, '侦探小说', 5, 50004674, 2, ',33,50004674,50000145,', 0),
(50000144, '科幻小说', 4, 50004674, 2, ',33,50004674,50000144,', 0),
(50000150, '外国小说', 3, 50004674, 2, ',33,50004674,50000150,', 0),
(50000143, '武侠小说', 2, 50004674, 2, ',33,50004674,50000143,', 1),
(50000142, '言情小说', 1, 50004674, 2, ',33,50004674,50000142,', 0),
(50003604, '玄幻小说', 0, 50004674, 2, ',33,50004674,50003604,', 0),
(50003143, '恐怖/惊悚小说', 0, 50004674, 2, ',33,50004674,50003143,', 0),
(50003146, '历史其它', 20, 50004658, 2, ',33,50004658,50003146,', 0),
(50004663, '文物/考古', 0, 50004658, 2, ',33,50004658,50004663,', 0),
(50004664, '地方史志', 0, 50004658, 2, ',33,50004658,50004664,', 0),
(50004659, '史学理论', 0, 50004658, 2, ',33,50004658,50004659,', 0),
(50004660, '历史知识读物', 0, 50004658, 2, ',33,50004658,50004660,', 0),
(50004661, '中国史', 0, 50004658, 2, ',33,50004658,50004661,', 0),
(50004662, '世界史', 0, 50004658, 2, ',33,50004658,50004662,', 0),
(50005702, '娱乐时尚其它', 50, 50004645, 2, ',33,50004645,50005702,', 0),
(50000046, '明星写真', 13, 50004645, 2, ',33,50004645,50000046,', 0),
(50003131, '星座/占卜/测试', 11, 50004645, 2, ',33,50004645,50003131,', 0),
(50003119, '服饰', 1, 50004645, 2, ',33,50004645,50003119,', 0),
(50004650, '读图时代', 0, 50004645, 2, ',33,50004645,50004650,', 0),
(50004651, '美容/美体/化妆', 0, 50004645, 2, ',33,50004645,50004651,', 1),
(50003211, '瑜伽', 0, 50004645, 2, ',33,50004645,50003211,', 0),
(50004646, '游戏', 0, 50004645, 2, ',33,50004645,50004646,', 1),
(50004649, '时尚DIY', 0, 50004645, 2, ',33,50004645,50004649,', 0),
(50004648, '打造丽质女人', 0, 50004645, 2, ',33,50004645,50004648,', 0),
(50003702, '宠物', 0, 50004645, 2, ',33,50004645,50003702,', 0),
(50004647, '减肥塑身', 0, 50004645, 2, ',33,50004645,50004647,', 0),
(50004626, '计算机报纸', 0, 50004621, 2, ',33,50004621,50004626,', 0),
(50004630, '艺术/摄影报纸', 0, 50004621, 2, ',33,50004621,50004630,', 0),
(50004640, '综合及其它报纸', 0, 50004621, 2, ',33,50004621,50004640,', 0),
(50004638, '烹饪/饮食报纸', 0, 50004621, 2, ',33,50004621,50004638,', 0),
(50004628, '汽车报纸', 0, 50004621, 2, ',33,50004621,50004628,', 0),
(50004623, '服饰/美容报纸', 0, 50004621, 2, ',33,50004621,50004623,', 0),
(50004624, '时尚报纸', 0, 50004621, 2, ',33,50004621,50004624,', 0),
(50004636, '旅游报纸', 0, 50004621, 2, ',33,50004621,50004636,', 0),
(50004632, '新闻/时事报纸', 0, 50004621, 2, ',33,50004621,50004632,', 0),
(50004625, '文摘/文学报纸', 0, 50004621, 2, ',33,50004621,50004625,', 0),
(50004635, '怀孕/育儿报纸', 0, 50004621, 2, ',33,50004621,50004635,', 0),
(50004622, '影视/娱乐/音乐报纸', 0, 50004621, 2, ',33,50004621,50004622,', 0),
(50004634, '家庭/情感/两性报纸', 0, 50004621, 2, ',33,50004621,50004634,', 0),
(50004637, '家居设计报纸', 0, 50004621, 2, ',33,50004621,50004637,', 0),
(50004639, '宠物报纸', 0, 50004621, 2, ',33,50004621,50004639,', 0),
(50004627, '商业/财经报纸', 0, 50004621, 2, ',33,50004621,50004627,', 0),
(50004633, '医疗保健报纸', 0, 50004621, 2, ',33,50004621,50004633,', 0),
(50004629, '体育运动报纸', 0, 50004621, 2, ',33,50004621,50004629,', 0),
(50004631, '人文地理报纸', 0, 50004621, 2, ',33,50004621,50004631,', 0),
(50003137, '心理学', 90, 50004620, 2, ',33,50004620,50003137,', 0),
(50004673, '社会科学其它', 28, 50004620, 2, ',33,50004620,50004673,', 0),
(333806, '新闻传播 出版', 27, 50004620, 2, ',33,50004620,333806,', 0),
(333803, '社会文化', 25, 50004620, 2, ',33,50004620,333803,', 0),
(50004670, '语言文字', 0, 50004620, 2, ',33,50004620,50004670,', 0),
(50004666, '社会科学总论', 0, 50004620, 2, ',33,50004620,50004666,', 0),
(50004667, '社会学', 0, 50004620, 2, ',33,50004620,50004667,', 0),
(50004668, '文化人类学', 0, 50004620, 2, ',33,50004620,50004668,', 0),
(50004671, '教育', 0, 50004620, 2, ',33,50004620,50004671,', 0),
(50004672, '图书馆学 档案学', 0, 50004620, 2, ',33,50004620,50004672,', 0),
(50024795, '糖缸', 23, 50004438, 2, ',50016349,50004438,50024795,', 0),
(50024794, '奶罐', 22, 50004438, 2, ',50016349,50004438,50024794,', 0),
(50011337, '咖啡套具', 21, 50004438, 2, ',50016349,50004438,50011337,', 0),
(50006783, '其它', 20, 50004438, 2, ',50016349,50004438,50006783,', 0),
(50006868, '打奶器', 7, 50004438, 2, ',50016349,50004438,50006868,', 0),
(50006867, '咖啡滤纸', 6, 50004438, 2, ',50016349,50004438,50006867,', 0),
(50006782, '咖啡勺', 5, 50004438, 2, ',50016349,50004438,50006782,', 0),
(50002254, '咖啡杯', 4, 50004438, 2, ',50016349,50004438,50002254,', 0),
(50002252, '配套器具', 3, 50004438, 2, ',50016349,50004438,50002252,', 0),
(50002251, '磨豆机/咖啡机', 2, 50004438, 2, ',50016349,50004438,50002251,', 0),
(50000347, '咖啡壶', 1, 50004438, 2, ',50016349,50004438,50000347,', 0),
(50024125, '拖把配件2', 55, 50003949, 2, ',50016348,50003949,50024125,', 0),
(50018843, '脸盆2', 53, 50003949, 2, ',50016348,50003949,50018843,', 0),
(50025798, '海绵擦', 50, 50003949, 2, ',50016348,50003949,50025798,', 0),
(50025793, '钢丝球', 49, 50003949, 2, ',50016348,50003949,50025793,', 0),
(50025792, '扫把及扫把头', 48, 50003949, 2, ',50016348,50003949,50025792,', 1),
(50025791, '抹布', 47, 50003949, 2, ',50016348,50003949,50025791,', 0),
(50019239, '静电除尘纸', 42, 50003949, 2, ',50016348,50003949,50019239,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50019234, '家务手套', 41, 50003949, 2, ',50016348,50003949,50019234,', 0),
(50019233, '除尘掸/掸头', 40, 50003949, 2, ',50016348,50003949,50019233,', 1),
(50016887, '簸箕', 38, 50003949, 2, ',50016348,50003949,50016887,', 0),
(50012526, '桌面吸尘器/桌面扫', 23, 50003949, 2, ',50016348,50003949,50012526,', 0),
(50012927, '百洁布', 14, 50003949, 2, ',50016348,50003949,50012927,', 0),
(50007063, '刷子', 13, 50003949, 2, ',50016348,50003949,50007063,', 1),
(50006850, '玻璃清洁器及配件', 12, 50003949, 2, ',50016348,50003949,50006850,', 0),
(50002131, '围裙/袖套', 11, 50003949, 2, ',50016348,50003949,50002131,', 0),
(50008340, '擦地拖鞋', 10, 50003949, 2, ',50016348,50003949,50008340,', 0),
(50012527, '垃圾桶/垃圾架', 9, 50003949, 2, ',50016348,50003949,50012527,', 1),
(50019469, '垃圾夹', 9, 50003949, 2, ',50016348,50003949,50019469,', 0),
(50004415, '垃圾袋', 8, 50003949, 2, ',50016348,50003949,50004415,', 0),
(50019044, '脸盆', 7, 50003949, 2, ',50016348,50003949,50019044,', 0),
(50019043, '水桶', 6, 50003949, 2, ',50016348,50003949,50019043,', 0),
(50025822, '拖把配件', 5, 50003949, 2, ',50016348,50003949,50025822,', 1),
(50026092, '水拖', 4, 50003949, 2, ',50016348,50003949,50026092,', 0),
(50025788, '胶棉拖把', 3, 50003949, 2, ',50016348,50003949,50025788,', 0),
(50025787, '平板拖把', 2, 50003949, 2, ',50016348,50003949,50025787,', 0),
(50003459, '旋转拖把', 1, 50003949, 2, ',50016348,50003949,50003459,', 0),
(50003792, '特殊相机', 12, 50003770, 2, ',14,50003770,50003792,', 0),
(50004196, '一次性相机', 11, 50003770, 2, ',14,50003770,50004196,', 0),
(50004195, '一次成像（拍立得）', 10, 50003770, 2, ',14,50003770,50004195,', 0),
(140114, '傻瓜相机', 9, 50003770, 2, ',14,50003770,140114,', 0),
(50003791, '大中幅相机', 7, 50003770, 2, ',14,50003770,50003791,', 0),
(50003790, '旁轴相机', 6, 50003770, 2, ',14,50003770,50003790,', 0),
(140115, '135胶片单反', 4, 50003770, 2, ',14,50003770,140115,', 0),
(50001948, '收藏相机', 0, 50003770, 2, ',14,50003770,50001948,', 0),
(50016444, '其他电脑周边/外设', 51, 50003321, 2, ',11,50003321,50016444,', 0),
(50003849, 'UPS电源', 40, 50003321, 2, ',11,50003321,50003849,', 0),
(110510, '图文信息/采集卡', 39, 50003321, 2, ',11,50003321,110510,', 0),
(110204, '软驱', 38, 50003321, 2, ',11,50003321,110204,', 0),
(50008209, 'CRT显示器', 23, 50003321, 2, ',11,50003321,50008209,', 0),
(50016573, '理线带/理线器', 15, 50003321, 2, ',11,50003321,50016573,', 0),
(50003333, '其它电脑周边', 14, 50003321, 2, ',11,50003321,50003333,', 0),
(50003336, '电脑专用MIC', 12, 50003321, 2, ',11,50003321,50003336,', 0),
(50003328, '无线电脑周边产品', 10, 50003321, 2, ',11,50003321,50003328,', 0),
(50003329, '光盘盒/CD包', 10, 50003321, 2, ',11,50003321,50003329,', 0),
(50003325, '保护屏/防尘罩', 7, 50003321, 2, ',11,50003321,50003325,', 0),
(50023708, '小风扇', 6, 50003321, 2, ',11,50003321,50023708,', 0),
(50023706, '耳麦', 4, 50003321, 2, ',11,50003321,50023706,', 0),
(110520, '鼠标垫/贴/腕垫', 2, 50003321, 2, ',11,50003321,110520,', 0),
(50011377, 'CMMB终端/电视棒', 1, 50003321, 2, ',11,50003321,50011377,', 0),
(50025381, '18650电池盒', 16, 50003312, 2, ',50008090,50003312,50025381,', 0),
(50025380, '18650电池', 15, 50003312, 2, ',50008090,50003312,50025380,', 0),
(50018906, '纽扣电池', 14, 50003312, 2, ',50008090,50003312,50018906,', 0),
(50003789, '其它数码充电套装', 12, 50003312, 2, ',50008090,50003312,50003789,', 0),
(50003311, '通用电池充电套装', 6, 50003312, 2, ',50008090,50003312,50003311,', 0),
(50003289, '相机/摄像机专用充电套装', 2, 50003312, 2, ',50008090,50003312,50003289,', 0),
(50011095, '普通干电池', 0, 50003312, 2, ',50008090,50003312,50011095,', 0),
(50003135, '其它生活书籍', 14, 50003112, 2, ',33,50003112,50003135,', 0),
(50003132, '幽默笑话书籍', 12, 50003112, 2, ',33,50003112,50003132,', 0),
(50003130, '养花书籍', 10, 50003112, 2, ',33,50003112,50003130,', 0),
(50003125, '理财/基金书籍', 6, 50003112, 2, ',33,50003112,50003125,', 0),
(50000067, '炒股书籍', 4, 50003112, 2, ',33,50003112,50000067,', 0),
(50004644, '饮食文化书籍', 0, 50003112, 2, ',33,50003112,50004644,', 0),
(50000061, '都市手工艺书籍', 0, 50003112, 2, ',33,50003112,50000061,', 0),
(50008120, '购房/置业书籍', 0, 50003112, 2, ',33,50003112,50008120,', 0),
(50008124, '菜谱烹饪类书籍', 0, 50003112, 2, ',33,50003112,50008124,', 1),
(50004641, '茶类书籍', 0, 50003112, 2, ',33,50003112,50004641,', 0),
(50004642, '生活百科书籍', 0, 50003112, 2, ',33,50003112,50004642,', 0),
(50004643, '爱车一族书籍', 0, 50003112, 2, ',33,50003112,50004643,', 0),
(50008119, '家居风水类书籍', 0, 50003112, 2, ',33,50003112,50008119,', 0),
(50000062, '家居装修书籍', 0, 50003112, 2, ',33,50003112,50000062,', 0),
(50004845, '婚恋书籍', 0, 50003112, 2, ',33,50003112,50004845,', 1),
(50008118, '博彩类书籍', 0, 50003112, 2, ',33,50003112,50008118,', 0),
(50024783, '餐垫', 28, 50002796, 2, ',50016349,50002796,50024783,', 0),
(50024780, '盘', 27, 50002796, 2, ',50016349,50002796,50024780,', 0),
(50024779, '碟', 26, 50002796, 2, ',50016349,50002796,50024779,', 0),
(50023875, '酒店餐具', 25, 50002796, 2, ',50016349,50002796,50023875,', 0),
(50022541, '定制餐具', 23, 50002796, 2, ',50016349,50002796,50022541,', 1),
(50022379, '配套瓷器', 22, 50002796, 2, ',50016349,50002796,50022379,', 1),
(50020216, '蟹八件', 21, 50002796, 2, ',50016349,50002796,50020216,', 0),
(215202, '其它', 20, 50002796, 2, ',50016349,50002796,215202,', 0),
(50006943, '饭盒/保温桶/保温提锅', 12, 50002796, 2, ',50016349,50002796,50006943,', 0),
(50006848, '扭曲勺', 11, 50002796, 2, ',50016349,50002796,50006848,', 0),
(50006759, '水果叉/水果签', 10, 50002796, 2, ',50016349,50002796,50006759,', 0),
(50009819, '便携/折叠餐具', 9, 50002796, 2, ',50016349,50002796,50009819,', 0),
(50006677, '西餐刀叉勺', 8, 50002796, 2, ',50016349,50002796,50006677,', 0),
(50009820, '其他餐具套装', 7, 50002796, 2, ',50016349,50002796,50009820,', 0),
(50006860, '韩国厨美餐具', 6, 50002796, 2, ',50016349,50002796,50006860,', 0),
(50005269, '筷子', 6, 50002796, 2, ',50016349,50002796,50005269,', 0),
(50002801, '瓶/罐', 6, 50002796, 2, ',50016349,50002796,50002801,', 0),
(50010419, '叉/勺/筷套装', 5, 50002796, 2, ',50016349,50002796,50010419,', 0),
(50002800, '餐具笼/架', 4, 50002796, 2, ',50016349,50002796,50002800,', 0),
(50002799, '盆', 3, 50002796, 2, ',50016349,50002796,50002799,', 0),
(50002798, '碗', 2, 50002796, 2, ',50016349,50002796,50002798,', 0),
(50002797, '餐具瓷器套装', 1, 50002796, 2, ',50016349,50002796,50002797,', 0),
(50002085, '果盆/果盘/果篮', 0, 50002796, 2, ',50016349,50002796,50002085,', 0),
(50008799, '遥控飞机零配件', 7, 50008737, 2, ',25,50008737,50008799,', 0),
(50008793, '遥控车升级件/零配件', 6, 50008737, 2, ',25,50008737,50008793,', 0),
(50002506, '模型制作工具/辅料耗材', 5, 50008737, 2, ',25,50008737,50002506,', 0),
(50008731, '其它二手/闲置', 7, 50008725, 2, ',27,50008725,50008731,', 0),
(50008730, '热水器/浴霸', 5, 50008725, 2, ',27,50008725,50008730,', 0),
(50008732, '电池/电力用品', 6, 50008725, 2, ',27,50008725,50008732,', 0),
(50008729, '电动/电热工具', 4, 50008725, 2, ',27,50008725,50008729,', 0),
(50021829, '厨房挂件', 13, 50002409, 2, ',27,50002409,50021829,', 1),
(50021820, '橱柜配用件', 12, 50002409, 2, ',27,50002409,50021820,', 1),
(50021798, '厨盆/水槽', 11, 50002409, 2, ',27,50002409,50021798,', 1),
(50021793, '水槽配件', 10, 50002409, 2, ',27,50002409,50021793,', 1),
(50020631, '厨柜', 9, 50002409, 2, ',27,50002409,50020631,', 1),
(50013354, '厨房龙头', 2, 50002409, 2, ',27,50002409,50013354,', 0),
(50012550, '烘培DIY器具', 24, 50002258, 2, ',50016349,50002258,50012550,', 1),
(50012549, '烧烤架炉/烧烤DIY用具', 23, 50002258, 2, ',50016349,50002258,50012549,', 1),
(50005894, '动漫模型杂志', 6, 50001965, 2, ',33,50001965,50005894,', 0),
(50002312, '画集/画册/写真', 4, 50001965, 2, ',33,50001965,50002312,', 0),
(50003350, '动漫小说', 3, 50001965, 2, ',33,50001965,50003350,', 0),
(50003434, '漫画书籍', 1, 50001965, 2, ',33,50001965,50003434,', 0),
(50008584, '战争纪念收藏品', 27, 50001931, 2, ',23,50001931,50008584,', 1),
(50001937, '其它趣味收集', 20, 50001931, 2, ',23,50001931,50001937,', 0),
(50008864, '电影道具/拷贝/周边收藏', 16, 50001931, 2, ',23,50001931,50008864,', 1),
(50008718, '雀巢系列收集', 15, 50001931, 2, ',23,50001931,50008718,', 0),
(50008470, '脸谱系列收集', 14, 50001931, 2, ',23,50001931,50008470,', 0),
(50008469, '球星球队系列收集', 13, 50001931, 2, ',23,50001931,50008469,', 0),
(50008658, '星巴克系列收集', 13, 50001931, 2, ',23,50001931,50008658,', 0),
(50008468, 'M&M系列收集', 12, 50001931, 2, ',23,50001931,50008468,', 0),
(50008464, '利是封收集', 11, 50001931, 2, ',23,50001931,50008464,', 0),
(50001932, '名人签名/历史收藏', 10, 50001931, 2, ',23,50001931,50001932,', 0),
(50008462, '酒瓶收藏', 9, 50001931, 2, ',23,50001931,50008462,', 0),
(50004473, '收藏类瓶/袋/包', 8, 50001931, 2, ',23,50001931,50004473,', 0),
(50001936, '香水瓶/香水配件', 7, 50001931, 2, ',23,50001931,50001936,', 0),
(50008660, '机器猫/哆啦A梦系列收集', 6, 50001931, 2, ',23,50001931,50008660,', 0),
(50008659, 'hello kitty系列收集', 5, 50001931, 2, ',23,50001931,50008659,', 0),
(50001935, '迪士尼/卡通系列', 4, 50001931, 2, ',23,50001931,50001935,', 0),
(50001934, '肯德基周边收集', 3, 50001931, 2, ',23,50001931,50001934,', 0),
(50008463, '麦当劳周边收集', 2, 50001931, 2, ',23,50001931,50008463,', 0),
(50003250, '其它服饰配件', 15, 50001739, 2, ',29,50001739,50003250,', 0),
(280909, '服装/用品定做', 12, 50001739, 2, ',29,50001739,280909,', 0),
(50018299, '宠物指甲套', 11, 50001739, 2, ',29,50001739,50018299,', 0),
(50003276, '宠物背包', 10, 50001739, 2, ',29,50001739,50003276,', 0),
(50003249, '挂饰/挂牌', 9, 50001739, 2, ',29,50001739,50003249,', 0),
(50015682, '生理裤', 8, 50001739, 2, ',29,50001739,50015682,', 0),
(50006122, '袜子', 7, 50001739, 2, ',29,50001739,50006122,', 0),
(50006121, '鞋子', 6, 50001739, 2, ',29,50001739,50006121,', 0),
(50023337, '头饰', 2, 50001739, 2, ',29,50001739,50023337,', 0),
(50023338, '围巾', 3, 50001739, 2, ',29,50001739,50023338,', 0),
(50023336, '帽子', 1, 50001739, 2, ',29,50001739,50023336,', 0),
(50003246, '宠物服装/雨衣', 0, 50001739, 2, ',29,50001739,50003246,', 0),
(50001407, '其它柜类', 37, 50001705, 2, ',50008164,50001705,50001407,', 0),
(50015642, '柜子配件', 36, 50001705, 2, ',50008164,50001705,50015642,', 1),
(50022489, '佛柜/佛龛', 35, 50001705, 2, ',50008164,50001705,50022489,', 0),
(50022455, '顶箱柜', 34, 50001705, 2, ',50008164,50001705,50022455,', 0),
(50015885, '书柜', 32, 50001705, 2, ',50008164,50001705,50015885,', 1),
(50015740, '斗柜', 31, 50001705, 2, ',50008164,50001705,50015740,', 0),
(50015739, '药柜', 30, 50001705, 2, ',50008164,50001705,50015739,', 0),
(50020645, '挂柜', 25, 50001705, 2, ',50008164,50001705,50020645,', 0),
(50015734, '门厅/玄关柜', 24, 50001705, 2, ',50008164,50001705,50015734,', 0),
(50015733, '角柜', 23, 50001705, 2, ',50008164,50001705,50015733,', 0),
(50008276, '餐边柜', 16, 50001705, 2, ',50008164,50001705,50008276,', 0),
(50001405, '酒柜', 15, 50001705, 2, ',50008164,50001705,50001405,', 0),
(211507, '鞋柜', 11, 50001705, 2, ',50008164,50001705,211507,', 0),
(50015746, '走入式衣柜', 9, 50001705, 2, ',50008164,50001705,50015746,', 0),
(50008399, '简易衣柜', 8, 50001705, 2, ',50008164,50001705,50008399,', 0),
(50015744, '衣柜', 7, 50001705, 2, ',50008164,50001705,50015744,', 0),
(50001382, '床头柜', 5, 50001705, 2, ',50008164,50001705,50001382,', 0),
(211509, '电视柜', 2, 50001705, 2, ',50008164,50001705,211509,', 0),
(50004979, '期刊订阅', 0, 50001378, 2, ',33,50001378,50004979,', 1),
(50004978, '报纸订阅', 0, 50001378, 2, ',33,50001378,50004978,', 1),
(50005089, '其它纪念品', 16, 50000813, 2, ',25,50000813,50005089,', 0),
(50013850, '名字贴', 15, 50000813, 2, ',25,50000813,50013850,', 0),
(50012248, '胎毛绣', 13, 50000813, 2, ',25,50000813,50012248,', 0),
(50012247, '胎毛挂坠/挂件', 12, 50000813, 2, ',25,50000813,50012247,', 0),
(50012246, '胎毛章', 11, 50000813, 2, ',25,50000813,50012246,', 0),
(50006937, '台历日历挂历', 5, 50000813, 2, ',25,50000813,50006937,', 0),
(50008349, '手镯/脚镯/长命锁', 4, 50000813, 2, ',25,50000813,50008349,', 0),
(50001689, '胎毛笔', 3, 50000813, 2, ',25,50000813,50001689,', 0),
(50000815, '纪念册', 2, 50000813, 2, ',25,50000813,50000815,', 0),
(50000814, '手脚印', 1, 50000813, 2, ',25,50000813,50000814,', 0),
(50025821, '除尘刷', 27, 50000569, 2, ',50016348,50000569,50025821,', 0),
(50025820, '叠衣板', 26, 50000569, 2, ',50016348,50000569,50025820,', 0),
(50025814, '领带架', 25, 50000569, 2, ',50016348,50000569,50025814,', 0),
(50025813, '晾衣杆', 24, 50000569, 2, ',50016348,50000569,50025813,', 0),
(50025812, '大型晒衣架', 23, 50000569, 2, ',50016348,50000569,50025812,', 0),
(50025811, '小型晒衣架', 22, 50000569, 2, ',50016348,50000569,50025811,', 0),
(50025810, '夹子', 21, 50000569, 2, ',50016348,50000569,50025810,', 0),
(50025809, '搓衣板', 20, 50000569, 2, ',50016348,50000569,50025809,', 0),
(50019238, '衣叉', 19, 50000569, 2, ',50016348,50000569,50019238,', 0),
(50005059, '其它用具', 18, 50000569, 2, ',50016348,50000569,50005059,', 0),
(50010472, '毛球修剪器', 11, 50000569, 2, ',50016348,50000569,50010472,', 0),
(50012928, '衣物除尘滚/粘毛滚', 10, 50000569, 2, ',50016348,50000569,50012928,', 0),
(50004201, '烫衣板及配件', 9, 50000569, 2, ',50016348,50000569,50004201,', 0),
(50010238, '洗护球', 8, 50000569, 2, ',50016348,50000569,50010238,', 0),
(50008360, '护洗袋', 7, 50000569, 2, ',50016348,50000569,50008360,', 0),
(50005057, '晒衣篮', 5, 50000569, 2, ',50016348,50000569,50005057,', 0),
(50009227, '裤架', 4, 50000569, 2, ',50016348,50000569,50009227,', 0),
(50024051, '衣帽架', 3, 50000569, 2, ',50016348,50000569,50024051,', 0),
(50005058, '衣架', 2, 50000569, 2, ',50016348,50000569,50005058,', 0),
(50006126, '置地/升降晾晒衣架', 1, 50000569, 2, ',50016348,50000569,50006126,', 0),
(50023572, 'Jobon', 28, 50000467, 2, ',28,50000467,50023572,', 0),
(50009246, '其它', 27, 50000467, 2, ',28,50000467,50009246,', 1),
(50005210, '防水万次火柴', 26, 50000467, 2, ',28,50000467,50005210,', 0),
(50000508, '打火机配件/工具', 22, 50000467, 2, ',28,50000467,50000508,', 1),
(50000506, '双枪', 20, 50000467, 2, ',28,50000467,50000506,', 0),
(50002149, 'Victory/威胜', 18, 50000467, 2, ',28,50000467,50002149,', 0),
(50005209, 'Tiger/虎牌', 16, 50000467, 2, ',28,50000467,50005209,', 0),
(50000507, 'Star/恒星', 14, 50000467, 2, ',28,50000467,50000507,', 0),
(50000504, 'STDupont/都彭', 12, 50000467, 2, ',28,50000467,50000504,', 0),
(50007183, 'Maslen/马狮麟', 11, 50000467, 2, ',28,50000467,50007183,', 0),
(50005208, 'IMCO', 10, 50000467, 2, ',28,50000467,50005208,', 0),
(50005923, 'Honest/百诚', 9, 50000467, 2, ',28,50000467,50005923,', 0),
(50005207, 'Givenchy/纪梵希', 8, 50000467, 2, ',28,50000467,50005207,', 0),
(50000505, 'Dunhill/登喜路', 6, 50000467, 2, ',28,50000467,50000505,', 0),
(50005206, 'Colibri/科乐比', 4, 50000467, 2, ',28,50000467,50005206,', 0),
(50005205, 'Cartier/卡地亚', 2, 50000467, 2, ',28,50000467,50005205,', 0),
(50003173, '其它科学技术', 28, 50000177, 2, ',33,50000177,50003173,', 0),
(50004701, '自然科学史/研究方法', 0, 50000177, 2, ',33,50000177,50004701,', 0),
(50000184, '生物学', 0, 50000177, 2, ',33,50000177,50000184,', 0),
(50004705, '生命科学', 0, 50000177, 2, ',33,50000177,50004705,', 0),
(50004706, '物理学', 0, 50000177, 2, ',33,50000177,50004706,', 0),
(50004702, '测绘', 0, 50000177, 2, ',33,50000177,50004702,', 0),
(50004704, '气象学', 0, 50000177, 2, ',33,50000177,50004704,', 0),
(50004703, '晶体学', 0, 50000177, 2, ',33,50000177,50004703,', 0),
(50000182, '数学/物理学', 0, 50000177, 2, ',33,50000177,50000182,', 0),
(50000185, '天文学', 0, 50000177, 2, ',33,50000177,50000185,', 0),
(50000188, '地理', 0, 50000177, 2, ',33,50000177,50000188,', 0),
(50007055, '化学', 0, 50000177, 2, ',33,50000177,50007055,', 1),
(50050260, '文学理论与批评', 25, 50000141, 2, ',33,50000141,50050260,', 0),
(50050259, '纪实文学', 24, 50000141, 2, ',33,50000141,50050259,', 0),
(50050258, '回忆录', 23, 50000141, 2, ',33,50000141,50050258,', 0),
(50050257, '文学史', 22, 50000141, 2, ',33,50000141,50050257,', 0),
(50000197, '文学其它', 21, 50000141, 2, ',33,50000141,50000197,', 0),
(50000149, '纪实/报告文学', 9, 50000141, 2, ',33,50000141,50000149,', 0),
(50000148, '中国现当代诗歌', 8, 50000141, 2, ',33,50000141,50000148,', 0),
(50000147, '现代/当代文学', 7, 50000141, 2, ',33,50000141,50000147,', 0),
(50004686, '民间文学', 0, 50000141, 2, ',33,50000141,50004686,', 0),
(50004678, '文集', 0, 50000141, 2, ',33,50000141,50004678,', 0),
(50004680, '文学理论', 0, 50000141, 2, ',33,50000141,50004680,', 0),
(50004954, '戏剧表演', 0, 50000141, 2, ',33,50000141,50004954,', 0),
(50005370, '戏剧', 0, 50000141, 2, ',33,50000141,50005370,', 1),
(50004685, '外国随笔', 0, 50000141, 2, ',33,50000141,50004685,', 0),
(50004682, '外国诗歌', 0, 50000141, 2, ',33,50000141,50004682,', 0),
(50004684, '中国现当代随笔', 0, 50000141, 2, ',33,50000141,50004684,', 0),
(50004681, '中国古诗词', 0, 50000141, 2, ',33,50000141,50004681,', 0),
(50004683, '中国古代随笔', 0, 50000141, 2, ',33,50000141,50004683,', 0),
(50050322, '教材', 22, 50000072, 2, ',33,50000072,50050322,', 1),
(330209, '其它类职称考试', 21, 50000072, 2, ',33,50000072,330209,', 1),
(50004481, '艺术体育类职称考试书籍', 20, 50000072, 2, ',33,50000072,50004481,', 1),
(50000194, '论文集', 12, 50000072, 2, ',33,50000072,50000194,', 0),
(50004541, '医药卫生类职称考试', 11, 50000072, 2, ',33,50000072,50004541,', 1),
(50000073, '成人高考', 10, 50000072, 2, ',33,50000072,50000073,', 1),
(50000074, '中考/高考', 9, 50000072, 2, ',33,50000072,50000074,', 1),
(50000077, '计算机等级考试/认证', 8, 50000072, 2, ',33,50000072,50000077,', 1),
(50004513, '自学考试', 7, 50000072, 2, ',33,50000072,50004513,', 1),
(50004525, '考研', 6, 50000072, 2, ',33,50000072,50004525,', 1),
(50004514, '外语考试', 5, 50000072, 2, ',33,50000072,50004514,', 1),
(50004546, '建筑工程类职称考试', 4, 50000072, 2, ',33,50000072,50004546,', 1),
(50000104, '公务员考试', 3, 50000072, 2, ',33,50000072,50000104,', 0),
(50004821, '司法考试', 2, 50000072, 2, ',33,50000072,50004821,', 0),
(50004480, '会计/证券/经济/金融职称考试', 1, 50000072, 2, ',33,50000072,50004480,', 1),
(50004522, '成人高考大纲', 0, 50000072, 2, ',33,50000072,50004522,', 0),
(50050309, '供应链管理', 13, 50000063, 2, ',33,50000063,50050309,', 0),
(50050308, '领导学', 12, 50000063, 2, ',33,50000063,50050308,', 0),
(50050307, '财务管理', 11, 50000063, 2, ',33,50000063,50050307,', 0),
(50050306, '战略管理', 10, 50000063, 2, ',33,50000063,50050306,', 0),
(333606, '管理其它', 9, 50000063, 2, ',33,50000063,333606,', 0),
(50000070, '管理学理论/MBA', 7, 50000063, 2, ',33,50000063,50000070,', 0),
(50000069, '电子商务', 6, 50000063, 2, ',33,50000063,50000069,', 0),
(50000068, '广告营销', 5, 50000063, 2, ',33,50000063,50000068,', 0),
(50000066, '金融投资', 3, 50000063, 2, ',33,50000063,50000066,', 0),
(50000065, '会计', 2, 50000063, 2, ',33,50000063,50000065,', 0),
(50003152, '商务谈判', 0, 50000063, 2, ',33,50000063,50003152,', 0),
(50003156, '商务写作', 0, 50000063, 2, ',33,50000063,50003156,', 0),
(50003149, '商业史传', 0, 50000063, 2, ',33,50000063,50003149,', 0),
(50003150, '创业企业和企业家', 0, 50000063, 2, ',33,50000063,50003150,', 0),
(50003148, '企业管理', 0, 50000063, 2, ',33,50000063,50003148,', 0),
(50003154, '人力资源', 0, 50000063, 2, ',33,50000063,50003154,', 0),
(50050261, '人体艺术', 12, 50000054, 2, ',33,50000054,50050261,', 0),
(50000198, '艺术其它', 11, 50000054, 2, ',33,50000054,50000198,', 0),
(50005420, '音乐', 0, 50000054, 2, ',33,50000054,50005420,', 1),
(50005288, '雕塑类书籍', 0, 50000054, 2, ',33,50000054,50005288,', 1),
(50005274, '艺术理论', 0, 50000054, 2, ',33,50000054,50005274,', 1),
(50005529, '舞蹈', 0, 50000054, 2, ',33,50000054,50005529,', 1),
(50004959, '考古', 0, 50000054, 2, ',33,50000054,50004959,', 0),
(50005301, '绘画', 0, 50000054, 2, ',33,50000054,50005301,', 1),
(50005385, '电影、电视艺术', 0, 50000054, 2, ',33,50000054,50005385,', 1),
(50004724, '民间艺术', 0, 50000054, 2, ',33,50000054,50004724,', 0),
(50004723, '收藏鉴赏', 0, 50000054, 2, ',33,50000054,50004723,', 0),
(50005329, '摄影艺术', 0, 50000054, 2, ',33,50000054,50005329,', 1),
(50005353, '建筑艺术', 0, 50000054, 2, ',33,50000054,50005353,', 1),
(50005342, '工艺美术', 0, 50000054, 2, ',33,50000054,50005342,', 1),
(50005312, '书法、篆刻', 0, 50000054, 2, ',33,50000054,50005312,', 1),
(333004, '自我实现 励志其它', 66, 50000049, 2, ',33,50000049,333004,', 0),
(50003124, '职场', 5, 50000049, 2, ',33,50000049,50003124,', 0),
(50004952, '谋略', 0, 50000049, 2, ',33,50000049,50004952,', 0),
(50004951, '礼仪', 0, 50000049, 2, ',33,50000049,50004951,', 0),
(50000052, '演讲/口才', 0, 50000049, 2, ',33,50000049,50000052,', 0),
(50000053, '求职/面试', 0, 50000049, 2, ',33,50000049,50000053,', 0),
(50004949, '成长 自我调节', 0, 50000049, 2, ',33,50000049,50004949,', 0),
(50000050, '成功', 0, 50000049, 2, ',33,50000049,50000050,', 0),
(333002, '励志', 0, 50000049, 2, ',33,50000049,333002,', 0),
(50000051, '修养/格言', 0, 50000049, 2, ',33,50000049,50000051,', 0),
(50003153, '人际沟通', 0, 50000049, 2, ',33,50000049,50003153,', 0),
(50024886, '制作教程', 3, 290503, 2, ',50007216,290503,50024886,', 0),
(50024885, '制作工具', 2, 290503, 2, ',50007216,290503,50024885,', 0),
(50024884, '制作材料', 1, 290503, 2, ',50007216,290503,50024884,', 0),
(50001945, '其它', 20, 290209, 2, ',50008163,290209,50001945,', 0),
(50001940, '原版绣图', 11, 290209, 2, ',50008163,290209,50001940,', 0),
(50006732, '十字绣工具', 7, 290209, 2, ',50008163,290209,50006732,', 1),
(50006740, '十字绣配件', 4, 290209, 2, ',50008163,290209,50006740,', 1),
(50006676, '绣线绣布', 3, 290209, 2, ',50008163,290209,50006676,', 0),
(50023141, '鱼缸等水族设备', 19, 217312, 2, ',29,217312,50023141,', 1),
(50023140, '水族教程', 18, 217312, 2, ',29,217312,50023140,', 0),
(50015701, '水族药品药剂', 17, 217312, 2, ',29,217312,50015701,', 0),
(50015703, '虾蟹等饲料', 16, 217312, 2, ',29,217312,50015703,', 0),
(50003923, '龟/鳖饲料', 15, 217312, 2, ',29,217312,50003923,', 0),
(50003253, '鱼饲料', 14, 217312, 2, ',29,217312,50003253,', 0),
(50003404, '其它水族宠物', 9, 217312, 2, ',29,217312,50003404,', 0),
(50015699, '螺', 6, 217312, 2, ',29,217312,50015699,', 0),
(50008467, '虾', 5, 217312, 2, ',29,217312,50008467,', 0),
(50015700, '蟹', 3, 217312, 2, ',29,217312,50015700,', 0),
(217313, '龟/鳖', 2, 217312, 2, ',29,217312,217313,', 0),
(50003251, '鱼', 1, 217312, 2, ',29,217312,50003251,', 0),
(50003245, '其它玩具', 8, 217311, 2, ',29,217311,50003245,', 0),
(50015685, '套装玩具', 7, 217311, 2, ',29,217311,50015685,', 0),
(50015684, '丝瓜络玩具', 6, 217311, 2, ',29,217311,50015684,', 0),
(50003239, '飞盘', 3, 217311, 2, ',29,217311,50003239,', 0),
(50003750, '逗猫棒', 3, 217311, 2, ',29,217311,50003750,', 0),
(50003241, '猫爬架', 3, 217311, 2, ',29,217311,50003241,', 0),
(50003280, '猫抓板', 3, 217311, 2, ',29,217311,50003280,', 0),
(50003240, '漏食球', 3, 217311, 2, ',29,217311,50003240,', 0),
(50003274, '绳结玩具', 2, 217311, 2, ',29,217311,50003274,', 0),
(50003243, '橡胶球/球形玩具', 1, 217311, 2, ',29,217311,50003243,', 0),
(50003242, '发声玩具', 0, 217311, 2, ',29,217311,50003242,', 0),
(50003931, '其它宠物用具', 4, 217302, 2, ',29,217302,50003931,', 0),
(50002614, '其它宠物粮食', 3, 217302, 2, ',29,217302,50002614,', 0),
(217308, '其它宠物', 1, 217302, 2, ',29,217302,217308,', 0),
(50003765, '其它酒具', 22, 215206, 2, ',50016349,215206,50003765,', 0),
(50011696, '漏斗', 21, 215206, 2, ',50016349,215206,50011696,', 0),
(50011695, '冰夹', 20, 215206, 2, ',50016349,215206,50011695,', 0),
(50011694, '挤柠檬器', 19, 215206, 2, ',50016349,215206,50011694,', 0),
(50011693, '酒签', 18, 215206, 2, ',50016349,215206,50011693,', 0),
(50011692, '醒酒器', 17, 215206, 2, ',50016349,215206,50011692,', 0),
(50011691, '开罐器', 16, 215206, 2, ',50016349,215206,50011691,', 0),
(50011690, '滤冰器', 15, 215206, 2, ',50016349,215206,50011690,', 0),
(50011689, '滤酒器', 14, 215206, 2, ',50016349,215206,50011689,', 0),
(50003766, '家用酒壶', 10, 215206, 2, ',50016349,215206,50003766,', 0),
(50003758, '橡木酒具', 9, 215206, 2, ',50016349,215206,50003758,', 0),
(50003764, '酒具套件', 8, 215206, 2, ',50016349,215206,50003764,', 0),
(50003762, '调酒器', 7, 215206, 2, ',50016349,215206,50003762,', 0),
(50003760, '开瓶器', 6, 215206, 2, ',50016349,215206,50003760,', 0),
(50003759, '酒盒', 5, 215206, 2, ',50016349,215206,50003759,', 0),
(50003757, '酒杯', 4, 215206, 2, ',50016349,215206,50003757,', 0),
(50003763, '酒塞', 3, 215206, 2, ',50016349,215206,50003763,', 0),
(50003761, '酒架', 2, 215206, 2, ',50016349,215206,50003761,', 0),
(50006760, '冰桶', 1, 215206, 2, ',50016349,215206,50006760,', 0),
(50001401, '其它办公家具', 17, 211503, 2, ',50020611,211503,50001401,', 0),
(50015507, '其它配件', 15, 211503, 2, ',50020611,211503,50015507,', 0),
(50015510, '公共休闲系列', 14, 211503, 2, ',50020611,211503,50015510,', 1),
(50015477, '报刊架', 12, 211503, 2, ',50020611,211503,50015477,', 0),
(50015474, '屏风隔断', 11, 211503, 2, ',50020611,211503,50015474,', 1),
(50015441, '会客沙发/茶几', 9, 211503, 2, ',50020611,211503,50015441,', 1),
(50015434, '接待台', 7, 211503, 2, ',50020611,211503,50015434,', 0),
(50015430, '钥匙箱', 5, 211503, 2, ',50020611,211503,50015430,', 0),
(50015435, '办公桌', 2, 211503, 2, ',50020611,211503,50015435,', 1),
(50023076, '办公柜类', 2, 211503, 2, ',50020611,211503,50023076,', 1),
(50015444, '办公椅', 0, 211503, 2, ',50020611,211503,50015444,', 1),
(50015962, '咖啡伴侣/辅料', 6, 210605, 2, ',50026316,210605,50015962,', 1),
(50008633, '即饮咖啡', 4, 210605, 2, ',50026316,210605,50008633,', 0),
(50015956, '咖啡豆/粉', 3, 210605, 2, ',50026316,210605,50015956,', 1),
(50002256, '速溶咖啡', 2, 210605, 2, ',50026316,210605,50002256,', 0),
(50023027, '防霉防蛀片', 17, 210207, 2, ',50025705,210207,50023027,', 0),
(50023029, '其他', 16, 210207, 2, ',50025705,210207,50023029,', 0),
(50017083, '灭鼠/杀虫剂', 9, 210207, 2, ',50025705,210207,50017083,', 0),
(50018987, '蚊香液', 2, 210207, 2, ',50025705,210207,50018987,', 0),
(50018986, '电蚊香器/电蚊香片', 1, 210207, 2, ',50025705,210207,50018986,', 0),
(50018985, '盘香/灭蟑香/蚊香盘', 0, 210207, 2, ',50025705,210207,50018985,', 0),
(50003814, '其他', 5, 164206, 2, ',50010404,164206,50003814,', 0),
(50003812, '婚纱裙撑', 2, 164206, 2, ',50010404,164206,50003812,', 0),
(50003811, '头纱', 1, 164206, 2, ',50010404,164206,50003811,', 0),
(50009041, '皇冠配饰', 0, 164206, 2, ',50010404,164206,50009041,', 0),
(50009042, '新娘头饰', 0, 164206, 2, ',50010404,164206,50009042,', 0),
(50009043, '婚纱手套', 0, 164206, 2, ',50010404,164206,50009043,', 0),
(50018948, '其它', 5, 111409, 2, ',50007218,111409,50018948,', 0),
(50018945, '油墨', 2, 111409, 2, ',50007218,111409,50018945,', 1),
(50050279, '天主教', 33, 3338, 2, ',33,3338,50050279,', 0),
(50050278, '犹太教', 32, 3338, 2, ',33,3338,50050278,', 0),
(50050277, '哲学流派', 31, 3338, 2, ',33,3338,50050277,', 0),
(333804, '哲学其它', 30, 3338, 2, ',33,3338,333804,', 0),
(333801, '宗教其它', 11, 3338, 2, ',33,3338,333801,', 0),
(50004898, '马克思主义哲学', 0, 3338, 2, ',33,3338,50004898,', 0),
(50004908, '道教', 0, 3338, 2, ',33,3338,50004908,', 0),
(50004903, '逻辑学', 0, 3338, 2, ',33,3338,50004903,', 0),
(50004904, '美学', 0, 3338, 2, ',33,3338,50004904,', 0),
(50004905, '宗教知识读物', 0, 3338, 2, ',33,3338,50004905,', 0),
(50004906, '宗教理论', 0, 3338, 2, ',33,3338,50004906,', 0),
(50004909, '基督教', 0, 3338, 2, ',33,3338,50004909,', 0),
(50004896, '哲学知识读物', 0, 3338, 2, ',33,3338,50004896,', 0),
(50004897, '哲学理论', 0, 3338, 2, ',33,3338,50004897,', 0),
(50004907, '佛教', 0, 3338, 2, ',33,3338,50004907,', 0),
(50004902, '伦理学', 0, 3338, 2, ',33,3338,50004902,', 0),
(50004910, '伊斯兰教', 0, 3338, 2, ',33,3338,50004910,', 0),
(50004901, '中国近代哲学', 0, 3338, 2, ',33,3338,50004901,', 0),
(50004900, '中国古代哲学', 0, 3338, 2, ',33,3338,50004900,', 0),
(50004899, '世界哲学', 0, 3338, 2, ',33,3338,50004899,', 0),
(333404, '其它体育', 24, 3334, 2, ',33,3334,333404,', 0),
(50003142, '竞技', 0, 3334, 2, ',33,3334,50003142,', 0),
(333401, '球类运动', 0, 3334, 2, ',33,3334,333401,', 0),
(50003140, '游泳', 0, 3334, 2, ',33,3334,50003140,', 0),
(333402, '武术', 0, 3334, 2, ',33,3334,333402,', 0),
(50003141, '棋类', 0, 3334, 2, ',33,3334,50003141,', 0),
(333204, '其它工具书', 22, 3332, 2, ',33,3332,333204,', 0),
(50003175, '计算机工具书', 0, 3332, 2, ',33,3332,50003175,', 0),
(50004830, '艺术工具书', 0, 3332, 2, ',33,3332,50004830,', 0),
(50004831, '科学技术工具书', 0, 3332, 2, ',33,3332,50004831,', 0),
(333201, '百科全书', 0, 3332, 2, ',33,3332,333201,', 0),
(333202, '汉语/辞典', 0, 3332, 2, ',33,3332,333202,', 0),
(50004829, '文学工具书', 0, 3332, 2, ',33,3332,50004829,', 0),
(50004833, '建筑工具书', 0, 3332, 2, ',33,3332,50004833,', 0),
(50003174, '外语/语言工具书', 0, 3332, 2, ',33,3332,50003174,', 0),
(50005572, '图书目录文摘索引', 0, 3332, 2, ',33,3332,50005572,', 0),
(50004975, '商务/经济/金融工具书', 0, 3332, 2, ',33,3332,50004975,', 0),
(50005573, '各国年鉴、年刊', 0, 3332, 2, ',33,3332,50005573,', 0),
(50004977, '历史工具书', 0, 3332, 2, ',33,3332,50004977,', 0),
(50004827, '医学工具书', 0, 3332, 2, ',33,3332,50004827,', 0),
(50005576, '中国辞典', 0, 3332, 2, ',33,3332,50005576,', 0),
(50004834, '中国年鉴、年刊', 0, 3332, 2, ',33,3332,50004834,', 0),
(50005575, '专科年鉴、年刊', 0, 3332, 2, ',33,3332,50005575,', 0),
(50005578, '专业辞典', 0, 3332, 2, ',33,3332,50005578,', 0),
(333114, '其它外语', 11, 3331, 2, ',33,3331,333114,', 0),
(50005552, '外国语言文字', 10, 3331, 2, ',33,3331,50005552,', 1),
(50000160, '双语读物', 8, 3331, 2, ',33,3331,50000160,', 0),
(50000159, '英语语法', 6, 3331, 2, ',33,3331,50000159,', 0),
(333110, '实用英语', 5, 3331, 2, ',33,3331,333110,', 1),
(333113, '法语', 4, 3331, 2, ',33,3331,333113,', 0),
(333111, '日语', 3, 3331, 2, ',33,3331,333111,', 0),
(333112, '德语', 2, 3331, 2, ',33,3331,333112,', 0),
(50003004, '词汇', 0, 3331, 2, ',33,3331,50003004,', 0),
(50003002, '翻译', 0, 3331, 2, ',33,3331,50003002,', 0),
(50002997, '教材', 0, 3331, 2, ',33,3331,50002997,', 0),
(50003006, '少儿英语', 0, 3331, 2, ',33,3331,50003006,', 0),
(50003000, '听力/口语', 0, 3331, 2, ',33,3331,50003000,', 0),
(50003001, '写作', 0, 3331, 2, ',33,3331,50003001,', 0),
(50003003, '专著', 0, 3331, 2, ',33,3331,50003003,', 0),
(331404, '其它儿童读物', 50, 3314, 2, ',33,3314,331404,', 0),
(50004867, '语言/文字', 0, 3314, 2, ',33,3314,50004867,', 0),
(50004861, '诗歌/散文', 0, 3314, 2, ',33,3314,50004861,', 0),
(331402, '绘画/漫画/连环画/卡通故事', 0, 3314, 2, ',33,3314,331402,', 0),
(50004859, '童话', 0, 3314, 2, ',33,3314,50004859,', 0),
(50004868, '百科/十万个为什么', 0, 3314, 2, ',33,3314,50004868,', 0),
(50004869, '生活常识', 0, 3314, 2, ',33,3314,50004869,', 0),
(50002836, '游戏/智力开发', 0, 3314, 2, ',33,3314,50002836,', 0),
(50004864, '成语故事/历史知识', 0, 3314, 2, ',33,3314,50004864,', 0),
(50002835, '幼儿/少儿英语', 0, 3314, 2, ',33,3314,50002835,', 0),
(50002831, '少儿艺术', 0, 3314, 2, ',33,3314,50002831,', 0),
(50004862, '少儿小说', 0, 3314, 2, ',33,3314,50004862,', 0),
(50002833, '小学教辅读物', 0, 3314, 2, ',33,3314,50002833,', 0),
(50004860, '寓言/传说/小故事', 0, 3314, 2, ',33,3314,50004860,', 0),
(50002837, '启蒙/认知', 0, 3314, 2, ',33,3314,50002837,', 0),
(50002830, '名著少儿读本', 0, 3314, 2, ',33,3314,50002830,', 0),
(50004866, '名人传记', 0, 3314, 2, ',33,3314,50004866,', 0),
(50000192, '儿童自然科学', 0, 3314, 2, ',33,3314,50000192,', 0),
(50004858, '儿童美术', 0, 3314, 2, ',33,3314,50004858,', 0),
(50004857, '儿童手工', 0, 3314, 2, ',33,3314,50004857,', 0),
(50004865, '传统文化', 0, 3314, 2, ',33,3314,50004865,', 0),
(50004856, '亲子读物', 0, 3314, 2, ',33,3314,50004856,', 0),
(50002834, '中学教辅读物', 0, 3314, 2, ',33,3314,50002834,', 0),
(330611, '其它计算机手册/词典/普及读物等', 1, 3306, 2, ',33,3306,330611,', 1),
(330605, '软件工程', 0, 3306, 2, ',33,3306,330605,', 0),
(330603, '计算机辅助设计和工程计算', 0, 3306, 2, ',33,3306,330603,', 1),
(50005579, '计算机软件工程', 0, 3306, 2, ',33,3306,50005579,', 1),
(330604, '计算机考试用书', 0, 3306, 2, ',33,3306,330604,', 0),
(330609, '计算机系统结构其它', 0, 3306, 2, ',33,3306,330609,', 0),
(50005661, '计算机系统结构', 0, 3306, 2, ',33,3306,50005661,', 1),
(50002757, '计算机硬件组装、维护与机房建设', 0, 3306, 2, ',33,3306,50002757,', 1),
(50002761, '计算机理论和方法', 0, 3306, 2, ',33,3306,50002761,', 1),
(50002758, '计算机安全与密码学', 0, 3306, 2, ',33,3306,50002758,', 0),
(50005707, '计算机/网络其它', 0, 3306, 2, ',33,3306,50005707,', 0),
(50002755, '网络通信', 0, 3306, 2, ',33,3306,50002755,', 1),
(330610, '网站设计/网页设计语言', 0, 3306, 2, ',33,3306,330610,', 1),
(330601, '程序设计', 0, 3306, 2, ',33,3306,330601,', 1),
(330606, '数据库与数据处理', 0, 3306, 2, ',33,3306,330606,', 1),
(330602, '操作系统', 0, 3306, 2, ',33,3306,330602,', 1),
(330607, '图形图像/多媒体', 0, 3306, 2, ',33,3306,330607,', 1),
(50000163, '办公自动化软件', 0, 3306, 2, ',33,3306,50000163,', 1),
(50002759, '信息系统', 0, 3306, 2, ',33,3306,50002759,', 1),
(290905, '其它', 18, 2909, 2, ',28,2909,290905,', 0),
(50009239, '卷烟器', 17, 2909, 2, ',28,2909,50009239,', 0),
(50003022, '火柴', 16, 2909, 2, ',28,2909,50003022,', 0),
(50001264, '雪茄剪/刀', 15, 2909, 2, ',28,2909,50001264,', 0),
(50007078, '戒烟产品', 14, 2909, 2, ',28,2909,50007078,', 0),
(50003699, '国草', 11, 2909, 2, ',28,2909,50003699,', 0),
(50009240, '烟斗相关配件', 10, 2909, 2, ',28,2909,50009240,', 1),
(50003601, '如烟', 9, 2909, 2, ',28,2909,50003601,', 0),
(290902, '烟盒', 7, 2909, 2, ',28,2909,290902,', 0),
(50003847, '烟斗架', 4, 2909, 2, ',28,2909,50003847,', 0),
(50003678, '烟嘴', 2, 2909, 2, ',28,2909,50003678,', 0),
(290901, '烟斗', 1, 2909, 2, ',28,2909,290901,', 0),
(50025865, '整蛊用品', 58, 2801, 2, ',21,2801,50025865,', 0),
(50025864, '书写板', 57, 2801, 2, ',21,2801,50025864,', 0),
(50025863, '荧光棒', 56, 2801, 2, ',21,2801,50025863,', 0),
(50025862, '充气用品', 55, 2801, 2, ',21,2801,50025862,', 0),
(50025861, '角色扮演类用品', 54, 2801, 2, ',21,2801,50025861,', 0),
(50025860, '装扮用品', 53, 2801, 2, ',21,2801,50025860,', 0),
(50025859, '哨子', 52, 2801, 2, ',21,2801,50025859,', 0),
(50025858, '门幅', 51, 2801, 2, ',21,2801,50025858,', 0),
(50025857, '圣诞装饰品', 50, 2801, 2, ',21,2801,50025857,', 0),
(50025856, '圣诞礼品', 49, 2801, 2, ',21,2801,50025856,', 0),
(50025855, '圣诞鹿', 48, 2801, 2, ',21,2801,50025855,', 0),
(50025854, '圣诞服饰', 47, 2801, 2, ',21,2801,50025854,', 0),
(50025853, '圣诞帽', 46, 2801, 2, ',21,2801,50025853,', 0),
(50025852, '圣诞袜', 45, 2801, 2, ',21,2801,50025852,', 0),
(50023063, '生肖用品', 44, 2801, 2, ',21,2801,50023063,', 0),
(50023062, '年历/万年历/挂历', 43, 2801, 2, ',21,2801,50023062,', 0),
(50023061, '节庆布艺用品', 42, 2801, 2, ',21,2801,50023061,', 0),
(50023060, '中国结', 41, 2801, 2, ',21,2801,50023060,', 0),
(50023059, '圣诞树', 40, 2801, 2, ',21,2801,50023059,', 0),
(50023052, '喷彩/喷雪', 39, 2801, 2, ',21,2801,50023052,', 0),
(50023049, '气球/飘空气球', 38, 2801, 2, ',21,2801,50023049,', 1),
(50023039, '婚庆布景/道具', 37, 2801, 2, ',21,2801,50023039,', 1),
(50023033, '灯', 36, 2801, 2, ',21,2801,50023033,', 1),
(50021420, '装饰灯', 32, 2801, 2, ',21,2801,50021420,', 0),
(50021419, '毛条', 31, 2801, 2, ',21,2801,50021419,', 0),
(50021417, '灯笼', 30, 2801, 2, ',21,2801,50021417,', 0),
(50021415, '挂饰/生肖挂饰', 29, 2801, 2, ',21,2801,50021415,', 0),
(50021413, '对联', 28, 2801, 2, ',21,2801,50021413,', 0),
(50003854, '其它婚庆用品', 25, 2801, 2, ',21,2801,50003854,', 0),
(50018427, '面具', 24, 2801, 2, ',21,2801,50018427,', 0),
(50018426, '蜡烛', 23, 2801, 2, ',21,2801,50018426,', 0),
(50026328, '烛台', 23, 2801, 2, ',21,2801,50026328,', 0),
(50018425, '礼花/礼炮', 21, 2801, 2, ',21,2801,50018425,', 0),
(50018424, '拉花', 20, 2801, 2, ',21,2801,50018424,', 0),
(50007278, '新娘配件', 15, 2801, 2, ',21,2801,50007278,', 0),
(50010042, '糖盒/糖盒配件', 5, 2801, 2, ',21,2801,50010042,', 0),
(50010022, '礼金簿/签名册', 4, 2801, 2, ',21,2801,50010022,', 0),
(50005251, '席位卡', 4, 2801, 2, ',21,2801,50005251,', 0),
(50010021, '红包/利是封', 3, 2801, 2, ',21,2801,50010021,', 0),
(50005250, '喜字/剪纸/贴纸', 3, 2801, 2, ',21,2801,50005250,', 0),
(50010020, '请柬', 2, 2801, 2, ',21,2801,50010020,', 0),
(50007125, '贺卡/卡片', 1, 2801, 2, ',21,2801,50007125,', 0),
(261804, '其它', 19, 2618, 2, ',26,2618,261804,', 0),
(261404, '顺风车/拼车', 15, 2618, 2, ',26,2618,261404,', 0),
(50003846, '加油卡', 14, 2618, 2, ',26,2618,50003846,', 0),
(261803, '驾驶培训/驾照', 11, 2618, 2, ',26,2618,261803,', 0),
(50000656, '泊位出租', 2, 2618, 2, ',26,2618,50000656,', 0),
(50019487, '普通/通勤自行车', 56, 2612, 2, ',50010728,2612,50019487,', 0),
(261801, '车辆出租', 1, 2618, 2, ',26,2618,261801,', 0),
(50018696, '更多自行车', 46, 2612, 2, ',50010728,2612,50018696,', 1),
(261203, '三轮车', 45, 2612, 2, ',50010728,2612,261203,', 0),
(50014817, '二手自行车', 44, 2612, 2, ',50010728,2612,50014817,', 1),
(50018729, '自行车修车工具', 41, 2612, 2, ',50010728,2612,50018729,', 1),
(50019291, '自行车/单车装备区', 40, 2612, 2, ',50010728,2612,50019291,', 1),
(50018695, '自行车零/配件区', 38, 2612, 2, ',50010728,2612,50018695,', 1),
(50010615, '骑行服饰/装备区', 37, 2612, 2, ',50010728,2612,50010615,', 1),
(50024908, '母子车/亲子车', 36, 2612, 2, ',50010728,2612,50024908,', 0),
(50018694, '双人/三人自行车', 34, 2612, 2, ',50010728,2612,50018694,', 0),
(50018693, '旅行自行车', 32, 2612, 2, ',50010728,2612,50018693,', 0),
(261204, '儿童自行车', 31, 2612, 2, ',50010728,2612,261204,', 0),
(50019775, 'Segway/思维车', 30, 2612, 2, ',50010728,2612,50019775,', 0),
(50016703, 'BMX小轮车', 25, 2612, 2, ',50010728,2612,50016703,', 0),
(261205, '折叠自行车', 24, 2612, 2, ',50010728,2612,261205,', 0),
(50018691, '山地自行车', 21, 2612, 2, ',50010728,2612,50018691,', 0),
(50018687, '公路自行车', 20, 2612, 2, ',50010728,2612,50018687,', 0),
(251203, '其它类', 17, 2512, 2, ',25,2512,251203,', 0),
(50013967, '拳击袋/拳击手套', 16, 2512, 2, ',25,2512,50013967,', 0),
(50016436, '吹泡泡', 15, 2512, 2, ',25,2512,50016436,', 0),
(50023778, '扔沙包/呼啦圈/投掷套圈', 14, 2512, 2, ',25,2512,50023778,', 0),
(50016438, '跳绳', 13, 2512, 2, ',25,2512,50016438,', 0),
(50023777, '跳跳玩具/跳跃类运动', 12, 2512, 2, ',25,2512,50023777,', 0),
(50007122, '球类玩具/球类运动', 10, 2512, 2, ',25,2512,50007122,', 0),
(50023789, '飞镖/射击/射箭类', 9, 2512, 2, ',25,2512,50023789,', 0),
(50008686, '飞盘/飞碟/竹蜻蜓类', 8, 2512, 2, ',25,2512,50008686,', 0),
(50019004, '传统/怀旧玩具', 5, 2512, 2, ',25,2512,50019004,', 0),
(50024421, '海洋球/波波球', 4, 2512, 2, ',25,2512,50024421,', 0),
(50008687, '儿童帐篷/游戏屋', 3, 2512, 2, ',25,2512,50008687,', 0),
(50008842, '摇马', 2, 2512, 2, ',25,2512,50008842,', 0),
(50004005, '外国钱币', 3, 2310, 2, ',23,2310,50004005,', 0),
(50003013, '其它钱币', 3, 2310, 2, ',23,2310,50003013,', 0),
(50012796, '中国当代钱币', 2, 2310, 2, ',23,2310,50012796,', 1),
(231002, '中国近代钱币', 1, 2310, 2, ',23,2310,231002,', 0),
(231001, '中国古代钱币', 0, 2310, 2, ',23,2310,231001,', 0),
(50019261, '其它邮品', 5, 2309, 2, ',23,2309,50019261,', 0),
(50002615, '打折邮品', 4, 2309, 2, ',23,2309,50002615,', 0),
(50019259, '外国邮品', 3, 2309, 2, ',23,2309,50019259,', 0),
(50003875, '新中国邮品', 2, 2309, 2, ',23,2309,50003875,', 0),
(50019260, '民/清邮品', 1, 2309, 2, ',23,2309,50019260,', 0),
(50001930, '其它', 8, 2303, 2, ',23,2303,50001930,', 0),
(50001929, '年历卡', 5, 2303, 2, ',23,2303,50001929,', 0),
(230302, '手机卡/手机充值卡', 2, 2303, 2, ',23,2303,230302,', 0),
(230303, '电话卡/田村卡', 1, 2303, 2, ',23,2303,230303,', 0),
(230104, '其它古玩杂项', 11, 2301, 2, ',23,2301,230104,', 0),
(50008472, '老兵器/历代武器', 10, 2301, 2, ',23,2301,50008472,', 0),
(50001950, '老织绣/老刺绣', 9, 2301, 2, ',23,2301,50001950,', 0),
(50005162, '核雕', 8, 2301, 2, ',23,2301,50005162,', 0),
(50019283, '烟具/鼻烟壶', 7, 2301, 2, ',23,2301,50019283,', 0),
(50019284, '老电器/老相机/老唱片', 6, 2301, 2, ',23,2301,50019284,', 0),
(50001952, '老紫砂', 5, 2301, 2, ',23,2301,50001952,', 0),
(50019273, '金银青铜器', 4, 2301, 2, ',23,2301,50019273,', 0),
(50002687, '陶器', 3, 2301, 2, ',23,2301,50002687,', 0),
(50022702, '香熏/精油皂', 8, 2165, 2, ',50025705,2165,50022702,', 0),
(50021853, '香熏蜡烛', 7, 2165, 2, ',50025705,2165,50021853,', 0),
(216501, '其它香熏产品', 6, 2165, 2, ',50025705,2165,216501,', 0),
(216505, '香熏香料', 4, 2165, 2, ',50025705,2165,216505,', 0),
(216502, '香熏精油', 1, 2165, 2, ',50025705,2165,216502,', 0),
(50006038, '其它除味器', 4, 2159, 2, ',27,2159,50006038,', 0),
(50013473, '保养系列', 2, 2159, 2, ',27,2159,50013473,', 1),
(50013472, '除味系列', 1, 2159, 2, ',27,2159,50013472,', 1),
(50013471, '环保系列', 0, 2159, 2, ',27,2159,50013471,', 1),
(50025806, '过滤器/净水器', 53, 2132, 2, ',50016348,2132,50025806,', 0),
(50025805, '卷纸器/纸巾架', 52, 2132, 2, ',50016348,2132,50025805,', 0),
(50025804, '花洒/淋蓬头', 51, 2132, 2, ',50016348,2132,50025804,', 0),
(50025803, '痰盂', 50, 2132, 2, ',50016348,2132,50025803,', 0),
(50025802, '粘钩', 49, 2132, 2, ',50016348,2132,50025802,', 0),
(50025801, '地垫', 48, 2132, 2, ',50016348,2132,50025801,', 0),
(50025800, '浴帘配件', 47, 2132, 2, ',50016348,2132,50025800,', 0),
(50003451, '浴室用品配件', 46, 2132, 2, ',50016348,2132,50003451,', 0),
(50006863, '水塞', 44, 2132, 2, ',50016348,2132,50006863,', 0),
(50006990, '管道疏通器', 34, 2132, 2, ',50016348,2132,50006990,', 0),
(50003452, '马桶套/马桶座圈', 33, 2132, 2, ',50016348,2132,50003452,', 0),
(50003841, '马桶刷/厕所刷', 28, 2132, 2, ',50016348,2132,50003841,', 0),
(50003821, '浴室用品套件', 26, 2132, 2, ',50016348,2132,50003821,', 0),
(50008626, '皂盒', 25, 2132, 2, ',50016348,2132,50008626,', 0),
(50006552, '乳液器', 24, 2132, 2, ',50016348,2132,50006552,', 0),
(50003817, '牙刷架/牙具座', 23, 2132, 2, ',50016348,2132,50003817,', 0),
(50018416, '挤牙膏器', 22, 2132, 2, ',50016348,2132,50018416,', 0),
(50006986, '毛巾挂/毛巾架', 21, 2132, 2, ',50016348,2132,50006986,', 0),
(50008627, '漱口杯', 20, 2132, 2, ',50016348,2132,50008627,', 0),
(50023404, '非便携式用镜', 11, 2132, 2, ',50016348,2132,50023404,', 1),
(50022718, '皂网/架', 10, 2132, 2, ',50016348,2132,50022718,', 0),
(50006856, '浴室角架/置物架', 9, 2132, 2, ',50016348,2132,50006856,', 0),
(50022717, '洗漱杯/杯架', 9, 2132, 2, ',50016348,2132,50022717,', 0),
(50018413, '浴帘杆', 8, 2132, 2, ',50016348,2132,50018413,', 0),
(50000565, '浴帘', 7, 2132, 2, ',50016348,2132,50000565,', 0),
(50011674, '足浴盆/足浴桶', 4, 2132, 2, ',50016348,2132,50011674,', 0),
(50011158, '沐浴桶/沐浴盆', 3, 2132, 2, ',50016348,2132,50011158,', 0),
(50010239, '人体秤/体重秤', 0, 2132, 2, ',50016348,2132,50010239,', 0),
(50026082, '茶道/香炉', 29, 2107, 2, ',50016349,2107,50026082,', 0),
(50026079, '茶宠摆件', 28, 2107, 2, ',50016349,2107,50026079,', 0),
(50024793, '茶托', 27, 2107, 2, ',50016349,2107,50024793,', 0),
(50024792, '茶夹', 26, 2107, 2, ',50016349,2107,50024792,', 0),
(50024791, '茶滤', 25, 2107, 2, ',50016349,2107,50024791,', 0),
(50024790, '闻香杯', 24, 2107, 2, ',50016349,2107,50024790,', 0),
(50024789, '茶海/公道杯', 23, 2107, 2, ',50016349,2107,50024789,', 0),
(50022377, '冲茶器', 22, 2107, 2, ',50016349,2107,50022377,', 0),
(50009225, '飘逸杯', 21, 2107, 2, ',50016349,2107,50009225,', 0),
(50000346, '其它', 20, 2107, 2, ',50016349,2107,50000346,', 0),
(50006766, '茶巾', 9, 2107, 2, ',50016349,2107,50006766,', 0),
(50006772, '茶匙', 8, 2107, 2, ',50016349,2107,50006772,', 0),
(50002260, '茶盘', 6, 2107, 2, ',50016349,2107,50002260,', 0),
(50002261, '茶道/零配', 5, 2107, 2, ',50016349,2107,50002261,', 0),
(50002262, '盖碗', 4, 2107, 2, ',50016349,2107,50002262,', 0),
(50006900, '茶杯', 3, 2107, 2, ',50016349,2107,50006900,', 0),
(50002263, '茶壶', 3, 2107, 2, ',50016349,2107,50002263,', 0),
(50002267, '花草茶具', 2, 2107, 2, ',50016349,2107,50002267,', 0),
(50002264, '整套茶具', 2, 2107, 2, ',50016349,2107,50002264,', 0),
(50002259, '功夫茶具', 2, 2107, 2, ',50016349,2107,50002259,', 0),
(50002265, '茶叶罐', 1, 2107, 2, ',50016349,2107,50002265,', 0),
(50011413, '其它制服', 11, 1624, 2, ',16,1624,50011413,', 0),
(50011412, '酒店工作制服', 10, 1624, 2, ',16,1624,50011412,', 0),
(50011411, '医护制服', 9, 1624, 2, ',16,1624,50011411,', 0),
(162403, '其它套装', 8, 1624, 2, ',16,1624,162403,', 0),
(162404, '休闲套装', 7, 1624, 2, ',16,1624,162404,', 0),
(162402, '职业女裤套装', 5, 1624, 2, ',16,1624,162402,', 0),
(162401, '职业女裙套装', 3, 1624, 2, ',16,1624,162401,', 0),
(50008903, '学生校服', 1, 1624, 2, ',16,1624,50008903,', 0),
(162207, '九分裤/七分裤', 12, 1622, 2, ',16,1622,162207,', 0),
(162203, '中裤/五分裤', 11, 1622, 2, ',16,1622,162203,', 0),
(162202, '短裤/热裤', 10, 1622, 2, ',16,1622,162202,', 0),
(50026651, '棉裤/羽绒裤', 4, 1622, 2, ',16,1622,50026651,', 0),
(50007068, '打底裤', 3, 1622, 2, ',16,1622,50007068,', 0),
(50022566, '西装裤/正装裤', 2, 1622, 2, ',16,1622,50022566,', 0),
(162201, '休闲裤', 1, 1622, 2, ',16,1622,162201,', 0),
(50012081, '国货精品手机', 2, 50023904, 1, ',50023904,50012081,', 0),
(50023945, '国货精品笔记本', 1, 50023904, 1, ',50023904,50023945,', 0),
(50026696, '专业回收', 28, 50023878, 1, ',50023878,50026696,', 0),
(50023914, '其他闲置', 27, 50023878, 1, ',50023878,50023914,', 0),
(50025252, '艺术品/收藏品/古董古玩', 25, 50023878, 1, ',50023878,50025252,', 1),
(50025248, '珠宝/黄金/手表', 24, 50023878, 1, ',50023878,50025248,', 1),
(50025255, '汽摩/电动车/自行车', 22, 50023878, 1, ',50023878,50025255,', 1),
(50025251, '书刊音像/文体用品', 21, 50023878, 1, ',50023878,50025251,', 1),
(50025254, '生活服务/票务/卡券', 20, 50023878, 1, ',50023878,50025254,', 1),
(50025253, '宠物/宠物用品', 19, 50023878, 1, ',50023878,50025253,', 1),
(50025247, '母婴/儿童用品/玩具', 18, 50023878, 1, ',50023878,50025247,', 1),
(50025245, '家用电器/影音设备', 17, 50023878, 1, ',50023878,50025245,', 1),
(50025246, '食品/保健品', 16, 50023878, 1, ',50023878,50025246,', 1),
(50025244, '家居/日用品', 15, 50023878, 1, ',50023878,50025244,', 1),
(50025250, '美容/美颜/香水', 14, 50023878, 1, ',50023878,50025250,', 1),
(50025249, '服装/服饰', 13, 50023878, 1, ',50023878,50025249,', 1),
(50025243, '数码3C产品', 12, 50023878, 1, ',50023878,50025243,', 1),
(50024607, '新鲜蛋糕', 89, 50050359, 1, ',50050359,50024607,', 0),
(50050725, '新鲜水果/水果制品', 65, 50050359, 1, ',50050359,50050725,', 1),
(50012382, '蛋/蛋制品', 64, 50050359, 1, ',50050359,50012382,', 1),
(50025680, '腌制蔬菜\\泡菜\\酱菜\\脱水蔬菜', 34, 50050359, 1, ',50050359,50025680,', 1),
(50010566, '新鲜蔬菜/蔬菜制品', 33, 50050359, 1, ',50050359,50010566,', 1),
(50016810, '生肉/鲜肉类', 32, 50050359, 1, ',50050359,50016810,', 1),
(50050643, '熟食\\凉拌\\凉菜\\私房菜', 4, 50050359, 1, ',50050359,50050643,', 1),
(50050372, '加工肉/肉制品（生食）', 2, 50050359, 1, ',50050359,50050372,', 1),
(50050371, '海鲜/水产品/制品', 1, 50050359, 1, ',50050359,50050371,', 1),
(50026811, '其他品牌保健营养品', 85, 50026800, 1, ',50026800,50026811,', 1),
(50026801, '品牌保健营养品', 84, 50026800, 1, ',50026800,50026801,', 1),
(50008141, '酒类', 65, 50026316, 1, ',50026316,50008141,', 1),
(210605, '速溶咖啡/咖啡豆/粉', 35, 50026316, 1, ',50026316,210605,', 1),
(50009857, '藕粉/麦片/冲饮品', 34, 50026316, 1, ',50026316,50009857,', 1),
(50003860, '天然粉粉食品', 25, 50026316, 1, ',50026316,50003860,', 0),
(50026398, '饮料/乳品', 22, 50026316, 1, ',50026316,50026398,', 1),
(50026397, '茶叶', 21, 50026316, 1, ',50026316,50026397,', 1),
(50002793, '电视机罩/电视机套/电视机防尘罩', 7, 50005494, 2, ',50008163,50005494,50002793,', 0),
(50002792, '电脑罩/电脑套/电脑防尘罩', 6, 50005494, 2, ',50008163,50005494,50002792,', 0),
(50002791, '空调罩/空调套/空调防尘罩', 5, 50005494, 2, ',50008163,50005494,50002791,', 0),
(50020778, '沙发套/沙发巾', 1, 50005494, 2, ',50008163,50005494,50020778,', 0),
(50024207, '旅游周边商品', 21, 50025707, 1, ',50025707,50024207,', 1),
(50019242, '邮轮/游船', 17, 50025707, 1, ',50025707,50019242,', 1),
(50014469, '租车（旅游包车、自行车租赁）', 11, 50025707, 1, ',50025707,50014469,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50012917, '巴士/地铁/交通卡券', 7, 50025707, 1, ',50025707,50012917,', 0),
(50012910, '旅游卡券/服务', 6, 50025707, 1, ',50025707,50012910,', 1),
(50012849, '旅游度假线路', 5, 50025707, 1, ',50025707,50012849,', 1),
(50017087, '景点门票', 0, 50025707, 1, ',50025707,50017087,', 1),
(210207, '驱虫用品', 11, 50025705, 1, ',50025705,210207,', 1),
(50012473, '纸品/湿巾', 10, 50025705, 1, ',50025705,50012473,', 1),
(50016889, '卫生巾/护垫/成人尿裤', 9, 50025705, 1, ',50025705,50016889,', 1),
(2165, '香熏用品', 8, 50025705, 1, ',50025705,2165,', 1),
(50018960, '室内除臭/芳香用品', 7, 50025705, 1, ',50025705,50018960,', 1),
(50018975, '衣物清洁剂/护理剂', 6, 50025705, 1, ',50025705,50018975,', 1),
(50018971, '家私/皮具护理品', 5, 50025705, 1, ',50025705,50018971,', 1),
(50012487, '家庭环境清洁剂', 4, 50025705, 1, ',50025705,50012487,', 1),
(50012482, '洗发沐浴/个人清洁', 0, 50025705, 1, ',50025705,50012482,', 1),
(50050489, '便民服务', 54, 50025111, 1, ',50025111,50050489,', 1),
(50050471, '本地摄影/摄像服务', 53, 50025111, 1, ',50025111,50050471,', 1),
(50050464, '家居服务', 51, 50025111, 1, ',50025111,50050464,', 1),
(50026535, '医疗服务', 50, 50025111, 1, ',50025111,50026535,', 1),
(50025132, '婚庆服务', 31, 50025111, 1, ',50025111,50025132,', 1),
(50025133, '汽车服务', 30, 50025111, 1, ',50025111,50025133,', 1),
(50025125, '保姆/护理/保洁', 29, 50025111, 1, ',50025111,50025125,', 1),
(50020126, '网络店铺代金券', 26, 50025111, 1, ',50025111,50020126,', 0),
(50014927, '教育培训', 11, 50025111, 1, ',50025111,50014927,', 1),
(50019084, '演出话剧', 21, 50025110, 1, ',50025110,50019084,', 1),
(50019086, '体育赛事', 1, 50025110, 1, ',50025110,50019086,', 0),
(50019077, '电影票', 0, 50025110, 1, ',50025110,50019077,', 0),
(50025012, '其它定制', 7, 50025004, 1, ',50025004,50025012,', 1),
(50025011, '新奇商品定制', 6, 50025004, 1, ',50025004,50025011,', 1),
(50014920, '个性定制产品', 6, 50025004, 1, ',50025004,50014920,', 1),
(50025010, '饰品定制', 5, 50025004, 1, ',50025004,50025010,', 1),
(50014854, '设计服务', 4, 50025004, 1, ',50025004,50014854,', 1),
(50025009, '服饰箱包定制', 4, 50025004, 1, ',50025004,50025009,', 1),
(50025008, '数码/办公定制', 3, 50025004, 1, ',50025004,50025008,', 1),
(50025007, '日用/装饰定制', 2, 50025004, 1, ',50025004,50025007,', 1),
(50050566, '二手整车销售（新）', 34, 50024971, 1, ',50024971,50050566,', 0),
(50050565, '新车整车销售(新)', 33, 50024971, 1, ',50024971,50050565,', 0),
(50024973, '新车全款', 32, 50024971, 1, ',50024971,50024973,', 0),
(50018718, '新车定金', 30, 50024971, 1, ',50024971,50018718,', 0),
(50011555, '二手整车', 29, 50024971, 1, ',50024971,50011555,', 0),
(50024765, '其他', 14, 50024612, 1, ',50024612,50024765,', 0),
(50024762, '生鲜蔬菜/食材半成品', 13, 50024612, 1, ',50024612,50024762,', 1),
(50024758, '水果/拼盘/果篮', 12, 50024612, 1, ',50024612,50024758,', 1),
(50024754, '鸭脖/卤味/特色小吃', 11, 50024612, 1, ',50024612,50024754,', 1),
(50024747, '面包/蛋糕/甜品', 10, 50024612, 1, ',50024612,50024747,', 1),
(50024739, '奶茶/咖啡/饮料', 9, 50024612, 1, ',50024612,50024739,', 1),
(50024734, '日韩料理/刺身', 8, 50024612, 1, ',50024612,50024734,', 1),
(50024723, '西餐/西式快餐', 7, 50024612, 1, ',50024612,50024723,', 1),
(50024717, '套餐/简餐', 6, 50024612, 1, ',50024612,50024717,', 1),
(50024710, '面食/饺子/包子/饼', 5, 50024612, 1, ',50024612,50024710,', 1),
(50024705, '米饭/炒饭/盖饭/粥', 4, 50024612, 1, ',50024612,50024705,', 1),
(50024704, '烧烤/烤肉/烤串', 3, 50024612, 1, ',50024612,50024704,', 0),
(50024703, '汤/煲/砂锅/火锅', 2, 50024612, 1, ',50024612,50024703,', 0),
(50024702, '热菜/炒菜/锅仔', 1, 50024612, 1, ',50024612,50024702,', 0),
(50024701, '冷菜/小菜', 0, 50024612, 1, ',50024612,50024701,', 0),
(50024484, '其他', 15, 50024451, 1, ',50024451,50024484,', 0),
(50024482, '生鲜蔬菜', 14, 50024451, 1, ',50024451,50024482,', 0),
(50024481, '水果/拼盘/果篮', 13, 50024451, 1, ',50024451,50024481,', 1),
(50024480, '鸭脖/卤味/特色小吃', 12, 50024451, 1, ',50024451,50024480,', 1),
(50024479, '面包/蛋糕/甜品', 11, 50024451, 1, ',50024451,50024479,', 1),
(50024478, '奶茶/咖啡/饮料', 10, 50024451, 1, ',50024451,50024478,', 1),
(50024477, '日韩料理/刺身', 9, 50024451, 1, ',50024451,50024477,', 1),
(50024476, '西餐/西式快餐', 8, 50024451, 1, ',50024451,50024476,', 1),
(50024504, '套餐/简餐', 6, 50024451, 1, ',50024451,50024504,', 0),
(50024470, '面食/饺子/包子/饼', 5, 50024451, 1, ',50024451,50024470,', 1),
(50024468, '米饭/炒饭/盖饭/粥', 4, 50024451, 1, ',50024451,50024468,', 1),
(50024467, '烧烤/烤肉/烤串', 3, 50024451, 1, ',50024451,50024467,', 0),
(50024466, '汤/煲/砂锅/火锅', 2, 50024451, 1, ',50024451,50024466,', 0),
(50024461, '热菜/炒菜/锅仔', 1, 50024451, 1, ',50024451,50024461,', 0),
(50024456, '冷菜/小菜', 0, 50024451, 1, ',50024451,50024456,', 0),
(50005497, '饮水机罩/饮水机套/饮水机防尘罩', 10, 50005494, 2, ',50008163,50005494,50005497,', 0),
(50003942, '洗衣机罩/洗衣机套/洗衣机防尘罩', 8, 50005494, 2, ',50008163,50005494,50003942,', 0),
(50005500, '微波炉套/微波炉罩/微波炉防尘罩', 9, 50005494, 2, ',50008163,50005494,50005500,', 0),
(50003457, '开关套', 15, 50005494, 2, ',50008163,50005494,50003457,', 0),
(50005502, '万能盖巾', 14, 50005494, 2, ',50008163,50005494,50005502,', 0),
(50005499, '钢琴罩/钢琴套/钢琴防尘罩', 13, 50005494, 2, ',50008163,50005494,50005499,', 0),
(50024641, '画具/画材/书法用品', 142, 50018004, 1, ',50018004,50024641,', 1),
(211707, '其它文化用品', 140, 50018004, 1, ',50018004,211707,', 0),
(50013477, '财会用品', 104, 50018004, 1, ',50018004,50013477,', 1),
(50005756, '绘图测量用品', 103, 50018004, 1, ',50018004,50005756,', 1),
(50005752, '教学演示/展示告示用品', 100, 50018004, 1, ',50018004,50005752,', 1),
(50012645, '收纳/陈列用品', 99, 50018004, 1, ',50018004,50012645,', 1),
(50016353, '印刷制品', 90, 50018004, 1, ',50018004,50016353,', 1),
(211708, '计算器', 80, 50018004, 1, ',50018004,211708,', 0),
(50005747, '裁剪用品', 67, 50018004, 1, ',50018004,50005747,', 1),
(50005736, '装订用品', 65, 50018004, 1, ',50018004,50005736,', 1),
(50005730, '胶粘用品', 64, 50018004, 1, ',50018004,50005730,', 1),
(50005757, '日常学习用品', 17, 50018004, 1, ',50018004,50005757,', 1),
(50012676, '纸张本册', 15, 50018004, 1, ',50018004,50012676,', 1),
(50012716, '笔类/书写工具', 14, 50018004, 1, ',50018004,50012716,', 1),
(50010731, '电子阅览器/电纸书', 4, 50018004, 1, ',50018004,50010731,', 0),
(50022537, '点读笔', 3, 50018004, 1, ',50018004,50022537,', 0),
(50022538, '点读机', 2, 50018004, 1, ',50018004,50022538,', 0),
(50008870, '电子辞典/学习机', 1, 50018004, 1, ',50018004,50008870,', 0),
(50024643, '切割/雕刻垫板', 11, 50005747, 2, ',50018004,50005747,50024643,', 0),
(50005751, '其它', 10, 50005747, 2, ',50018004,50005747,50005751,', 0),
(50005750, '美工刀', 3, 50005747, 2, ',50018004,50005747,50005750,', 0),
(50005749, '剪刀', 2, 50005747, 2, ',50018004,50005747,50005749,', 0),
(50005748, '裁纸/切纸/拆信刀', 1, 50005747, 2, ',50018004,50005747,50005748,', 0),
(50011755, '别针/回形针', 11, 50005736, 2, ',50018004,50005736,50011755,', 0),
(211711, '其它', 10, 50005736, 2, ',50018004,50005736,211711,', 0),
(50005120, '票夹/长尾夹', 7, 50005736, 2, ',50018004,50005736,50005120,', 0),
(50005743, '大头针', 6, 50005736, 2, ',50018004,50005736,50005743,', 0),
(50005741, '回形针座/盒', 4, 50005736, 2, ',50018004,50005736,50005741,', 0),
(50005742, '图钉/工字钉', 5, 50005736, 2, ',50018004,50005736,50005742,', 0),
(50005739, '订书钉', 3, 50005736, 2, ',50018004,50005736,50005739,', 0),
(50005738, '打孔机', 2, 50005736, 2, ',50018004,50005736,50005738,', 0),
(50005737, '订书机', 1, 50005736, 2, ',50018004,50005736,50005737,', 0),
(50005734, '其它', 30, 50005730, 2, ',50018004,50005730,50005734,', 0),
(50017301, '其他民族乐器', 45, 50017300, 1, ',50017300,50017301,', 1),
(50017304, '民族拉弦乐器', 44, 50017300, 1, ',50017300,50017304,', 1),
(50017303, '民族吹奏乐器', 43, 50017300, 1, ',50017300,50017303,', 1),
(50017302, '民族弹拨乐器', 42, 50017300, 1, ',50017300,50017302,', 1),
(50017310, '其他西洋乐器', 41, 50017300, 1, ',50017300,50017310,', 1),
(50017305, '乐器教材/曲谱', 40, 50017300, 1, ',50017300,50017305,', 1),
(50017321, '儿童玩具乐器', 39, 50017300, 1, ',50017300,50017321,', 1),
(50017320, '乐器定制/出租', 38, 50017300, 1, ',50017300,50017320,', 1),
(50017319, '乐器配件', 37, 50017300, 1, ',50017300,50017319,', 1),
(50017318, '乐器音箱', 36, 50017300, 1, ',50017300,50017318,', 1),
(50017312, '吉他/贝司', 30, 50017300, 1, ',50017300,50017312,', 0),
(50017322, '锣', 29, 50017300, 1, ',50017300,50017322,', 1),
(50017311, 'MIDI乐器/电脑音乐', 28, 50017300, 1, ',50017300,50017311,', 1),
(50017309, '鼓-西洋鼓', 26, 50017300, 1, ',50017300,50017309,', 1),
(50017325, '鼓-民族鼓', 25, 50017300, 1, ',50017300,50017325,', 1),
(50017308, '萨克斯风', 24, 50017300, 1, ',50017300,50017308,', 0),
(50017307, '口琴', 23, 50017300, 1, ',50017300,50017307,', 0),
(50017390, '陶笛', 22, 50017300, 1, ',50017300,50017390,', 0),
(50017664, '风琴', 19, 50017300, 1, ',50017300,50017664,', 0),
(50017505, '手卷钢琴', 19, 50017300, 1, ',50017300,50017505,', 0),
(50017504, '电子合成器', 18, 50017300, 1, ',50017300,50017504,', 0),
(50017381, '埙', 18, 50017300, 1, ',50017300,50017381,', 0),
(50017380, '葫芦丝', 17, 50017300, 1, ',50017300,50017380,', 0),
(50017662, '手风琴', 17, 50017300, 1, ',50017300,50017662,', 0),
(50017393, '二胡', 17, 50017300, 1, ',50017300,50017393,', 0),
(50017379, '箫', 16, 50017300, 1, ',50017300,50017379,', 0),
(50017367, '古琴', 16, 50017300, 1, ',50017300,50017367,', 0),
(50017661, '口风琴', 16, 50017300, 1, ',50017300,50017661,', 0),
(50017316, '钢琴', 15, 50017300, 1, ',50017300,50017316,', 0),
(50017378, '笛子', 15, 50017300, 1, ',50017300,50017378,', 0),
(50017391, '京胡', 15, 50017300, 1, ',50017300,50017391,', 0),
(50017503, '数码钢琴', 14, 50017300, 1, ',50017300,50017503,', 0),
(50017502, '电子琴', 13, 50017300, 1, ',50017300,50017502,', 0),
(50017306, '古筝', 12, 50017300, 1, ',50017300,50017306,', 0),
(50017510, '提琴配件', 11, 50017300, 1, ',50017300,50017510,', 1),
(50017509, '低音提琴/倍大提琴', 10, 50017300, 1, ',50017300,50017509,', 0),
(50017508, '大提琴', 9, 50017300, 1, ',50017300,50017508,', 0),
(50017507, '中提琴', 8, 50017300, 1, ',50017300,50017507,', 0),
(50017506, '小提琴', 7, 50017300, 1, ',50017300,50017506,', 0),
(50017476, '贝司-木贝司', 6, 50017300, 1, ',50017300,50017476,', 0),
(50017477, '贝司-电贝司', 5, 50017300, 1, ',50017300,50017477,', 0),
(50017313, '吉他配件', 4, 50017300, 1, ',50017300,50017313,', 1),
(50017473, '吉他-电箱吉他', 3, 50017300, 1, ',50017300,50017473,', 0),
(50017472, '吉他-古典吉他', 2, 50017300, 1, ',50017300,50017472,', 0),
(50017474, '吉他-电吉他', 1, 50017300, 1, ',50017300,50017474,', 0),
(50017471, '吉他-民谣吉他', 0, 50017300, 1, ',50017300,50017471,', 0),
(50019471, '办公电话', 26, 50008551, 2, ',50007218,50008551,50019471,', 0),
(50019464, '无线呼叫器', 25, 50008551, 2, ',50007218,50008551,50019464,', 0),
(50009078, '会议电话产品', 24, 50008551, 2, ',50007218,50008551,50009078,', 0),
(150805, '其它通信设备', 23, 50008551, 2, ',50007218,50008551,150805,', 0),
(150809, '电话管理系统', 22, 50008551, 2, ',50007218,50008551,150809,', 0),
(50012615, '通信设备配件', 15, 50008551, 2, ',50007218,50008551,50012615,', 0),
(150804, '电话录音设备', 13, 50008551, 2, ',50007218,50008551,150804,', 0),
(111202, '传真机', 7, 50008551, 2, ',50007218,50008551,111202,', 0),
(50012605, '传真机配件', 4, 50008551, 2, ',50007218,50008551,50012605,', 0),
(150807, '投币电话/磁卡电话', 3, 50008551, 2, ',50007218,50008551,150807,', 0),
(50003366, '寻呼设备', 3, 50008551, 2, ',50007218,50008551,50003366,', 0),
(150802, '电话交换机', 2, 50008551, 2, ',50007218,50008551,150802,', 0),
(50023392, '电动修脚器', 26, 50008548, 2, ',50002768,50008548,50023392,', 0),
(50005019, '其它美体瘦身', 18, 50008548, 2, ',50002768,50008548,50005019,', 0),
(50005016, '瘦身按摩贴', 17, 50008548, 2, ',50002768,50008548,50005016,', 0),
(50023393, '蜡疗机/手蜡机', 16, 50008548, 2, ',50002768,50008548,50023393,', 0),
(50005018, '甩脂/碎脂/溶脂机', 14, 50008548, 2, ',50002768,50008548,50005018,', 0),
(50002910, '电动瘦腿带/美腿仪', 13, 50008548, 2, ',50002768,50008548,50002910,', 0),
(350202, '女士脱毛/剃毛器', 11, 50008548, 2, ',50002768,50008548,350202,', 0),
(50005015, '电子瘦身带/瘦身腰带', 10, 50008548, 2, ',50002768,50008548,50005015,', 0),
(50005017, '电动丰胸仪', 9, 50008548, 2, ',50002768,50008548,50005017,', 0),
(50000118, '护理美甲器', 6, 50008548, 2, ',50002768,50008548,50000118,', 0),
(50002916, '背背佳/矫姿用品', 3, 50008548, 2, ',50002768,50008548,50002916,', 0),
(50005003, '其它美容/美体工具', 27, 50008545, 2, ',50002768,50008545,50005003,', 0),
(50005219, '瘦脸机/瘦脸工具', 21, 50008545, 2, ',50002768,50008545,50005219,', 0),
(50004998, '美容修剪器', 19, 50008545, 2, ',50002768,50008545,50004998,', 0),
(350208, '洁耳器', 19, 50008545, 2, ',50002768,50008545,350208,', 0),
(50004999, '睫毛卷翘器', 18, 50008545, 2, ',50002768,50008545,50004999,', 0),
(50005218, '鼻梁增高器', 17, 50008545, 2, ',50002768,50008545,50005218,', 0),
(50005217, '瘦身贴/溶脂带', 15, 50008545, 2, ',50002768,50008545,50005217,', 0),
(50003468, '脂肪测量仪', 2, 50008545, 2, ',50002768,50008545,50003468,', 0),
(350712, '体重秤/健康秤', 1, 50008545, 2, ',50002768,50008545,350712,', 0),
(350406, '其它日用家电', 340, 50008544, 2, ',50012100,50008544,350406,', 0),
(50002901, '保温碟/垫', 338, 50008544, 2, ',50012100,50008544,50002901,', 0),
(350409, '电子温湿度计', 339, 50008544, 2, ',50012100,50008544,350409,', 0),
(350307, '干手器', 155, 50008544, 2, ',50012100,50008544,350307,', 0),
(50008566, '电子灭蚊器', 154, 50008544, 2, ',50012100,50008544,50008566,', 0),
(50005926, '缝纫机', 153, 50008544, 2, ',50012100,50008544,50005926,', 0),
(50008383, '节电器', 102, 50008544, 2, ',50012100,50008544,50008383,', 0),
(50008372, '充气泵', 92, 50008544, 2, ',50012100,50008544,50008372,', 0),
(50002889, '暖手/脚宝', 28, 50008544, 2, ',50012100,50008544,50002889,', 0),
(350408, '换气扇/排气扇', 3, 50008544, 2, ',50012100,50008544,350408,', 0),
(50006278, '加香机', 3, 50008544, 2, ',50012100,50008544,50006278,', 0),
(50002899, '解毒/活氧机', 2, 50008544, 2, ',50012100,50008544,50002899,', 0),
(50002900, '其它厨房家电', 508, 50008543, 2, ',50012082,50008543,50002900,', 0),
(50011733, '炒菜机/烹饪锅', 507, 50008543, 2, ',50012082,50008543,50011733,', 0),
(50016465, '电蒸炉', 506, 50008543, 2, ',50012082,50008543,50016465,', 0),
(50005929, '保健/养生/煎药壶', 325, 50008543, 2, ',50012082,50008543,50005929,', 0),
(50013039, '绞肉/碎肉机', 104, 50008543, 2, ',50012082,50008543,50013039,', 0),
(50013609, '电热炉', 103, 50008543, 2, ',50012082,50008543,50013609,', 0),
(50008361, '豆芽机', 102, 50008543, 2, ',50012082,50008543,50008361,', 0),
(50008369, '电热饭盒', 102, 50008543, 2, ',50012082,50008543,50008369,', 0),
(50008368, '烹饪锅', 102, 50008543, 2, ',50012082,50008543,50008368,', 0),
(50008366, '炙烤炉', 102, 50008543, 2, ',50012082,50008543,50008366,', 0),
(50008362, '切片机/切肉机', 102, 50008543, 2, ',50012082,50008543,50008362,', 0),
(50008330, '电磁茶炉', 101, 50008543, 2, ',50012082,50008543,50008330,', 0),
(50013037, '巧克力喷泉机', 100, 50008543, 2, ',50012082,50008543,50013037,', 0),
(50013035, '果蔬消毒清洗机', 99, 50008543, 2, ',50012082,50008543,50013035,', 0),
(50003987, '电炸锅', 98, 50008543, 2, ',50012082,50008543,50003987,', 0),
(50006844, '面条机', 60, 50008543, 2, ',50012082,50008543,50006844,', 0),
(50004402, '芝士炉/电烤盘', 60, 50008543, 2, ',50012082,50008543,50004402,', 0),
(50002532, '爆米花机', 60, 50008543, 2, ',50012082,50008543,50002532,', 0),
(50005928, '洗碗机', 60, 50008543, 2, ',50012082,50008543,50005928,', 0),
(50004204, '冰淇淋机', 60, 50008543, 2, ',50012082,50008543,50004204,', 0),
(50003464, '三明治机', 60, 50008543, 2, ',50012082,50008543,50003464,', 0),
(50004399, '电动打蛋器', 41, 50008543, 2, ',50012082,50008543,50004399,', 0),
(50002896, '食物垃圾处理机', 30, 50008543, 2, ',50012082,50008543,50002896,', 0),
(50002533, '制/刨/碎/炒冰机', 30, 50008543, 2, ',50012082,50008543,50002533,', 0),
(50006845, '削皮机', 29, 50008543, 2, ',50012082,50008543,50006845,', 0),
(50005270, '筷子消毒机', 28, 50008543, 2, ',50012082,50008543,50005270,', 0),
(50003465, '早餐吧', 26, 50008543, 2, ',50012082,50008543,50003465,', 0),
(50024229, '游戏叠叠乐', 26, 50008528, 2, ',25,50008528,50024229,', 0),
(50023697, '儿童桌面游戏类', 24, 50008528, 2, ',25,50008528,50023697,', 0),
(50014245, '洗牌机/发牌机', 23, 50008528, 2, ',25,50008528,50014245,', 0),
(251103, '其它棋牌/桌面游戏', 22, 50008528, 2, ',25,50008528,251103,', 0),
(50006799, '多功能棋', 14, 50008528, 2, ',25,50008528,50006799,', 0),
(50005920, '四子棋/五子棋', 11, 50008528, 2, ',25,50008528,50005920,', 0),
(50005900, '飞行棋', 10, 50008528, 2, ',25,50008528,50005900,', 0),
(50005902, '跳棋', 9, 50008528, 2, ',25,50008528,50005902,', 0),
(50005897, '强手棋/大富翁棋', 8, 50008528, 2, ',25,50008528,50005897,', 0),
(251102, '麻将/牌九/色子', 5, 50008528, 2, ',25,50008528,251102,', 0),
(50005898, '围棋', 4, 50008528, 2, ',25,50008528,50005898,', 0),
(50005899, '中国象棋/国际象棋', 3, 50008528, 2, ',25,50008528,50005899,', 0),
(251101, '扑克', 2, 50008528, 2, ',25,50008528,251101,', 0),
(50019051, '桌游卡牌', 0, 50008528, 2, ',25,50008528,50019051,', 0),
(50019052, '桌游配件', 0, 50008528, 2, ',25,50008528,50019052,', 0),
(50012390, '奶油', 11, 50008430, 2, ',50002766,50008430,50012390,', 0),
(50012389, '奶精炼乳', 9, 50008430, 2, ',50002766,50008430,50012389,', 0),
(50016425, '芝士/西式奶酪', 8, 50008430, 2, ',50002766,50008430,50016425,', 0),
(50008435, '奶皮', 5, 50008430, 2, ',50002766,50008430,50008435,', 0),
(50008434, '奶干', 4, 50008430, 2, ',50002766,50008430,50008434,', 0),
(50008433, '奶酥', 3, 50008430, 2, ',50002766,50008430,50008433,', 0),
(50008432, '奶片', 2, 50008430, 2, ',50002766,50008430,50008432,', 0),
(50008431, '内蒙古奶酪', 1, 50008430, 2, ',50002766,50008430,50008431,', 0),
(50018939, '电子白板', 130, 50008352, 2, ',50007218,50008352,50018939,', 0),
(50022574, '翻页激光笔', 4, 50008352, 2, ',50007218,50008352,50022574,', 0),
(50018938, '投影胶片', 3, 50008352, 2, ',50007218,50008352,50018938,', 0),
(50008358, '其他配件', 2, 50008352, 2, ',50007218,50008352,50008358,', 0),
(50008355, '镜头', 1, 50008352, 2, ',50007218,50008352,50008355,', 0),
(50008353, '灯泡', 1, 50008352, 2, ',50007218,50008352,50008353,', 0),
(50010848, '投影机支架(三角架)', 1, 50008352, 2, ',50007218,50008352,50010848,', 0),
(50010849, '投影机摇控器', 1, 50008352, 2, ',50007218,50008352,50010849,', 0),
(50010847, '投影机吊架', 1, 50008352, 2, ',50007218,50008352,50010847,', 0),
(50008354, '幕布', 1, 50008352, 2, ',50007218,50008352,50008354,', 0),
(50008356, 'DIY配件', 1, 50008352, 2, ',50007218,50008352,50008356,', 0),
(50026550, '厨房小工具套装', 35, 50008281, 2, ',50016349,50008281,50026550,', 0),
(50024796, '厨房储物架/厨房置物架', 34, 50008281, 2, ',50016349,50008281,50024796,', 1),
(50022395, '水果分割器', 32, 50008281, 2, ',50016349,50008281,50022395,', 0),
(50022393, '滤水器/净水器', 31, 50008281, 2, ',50016349,50008281,50022393,', 0),
(50020214, '敲肉锤', 30, 50008281, 2, ',50016349,50008281,50020214,', 0),
(50006757, '手压式饮水器', 30, 50008281, 2, ',50016349,50008281,50006757,', 0),
(50008282, '其它', 29, 50008281, 2, ',50016349,50008281,50008282,', 0),
(50012792, '寿司DIY用具', 28, 50008281, 2, ',50016349,50008281,50012792,', 1),
(50006830, '绞肉机/碎肉宝', 25, 50008281, 2, ',50016349,50008281,50006830,', 0),
(50006771, '面条机/压面机', 26, 50008281, 2, ',50016349,50008281,50006771,', 0),
(50006754, '剥蒜器/压蒜器', 23, 50008281, 2, ',50016349,50008281,50006754,', 0),
(50008558, '多功能切菜器', 21, 50008281, 2, ',50016349,50008281,50008558,', 0),
(50006765, '包饺子器', 21, 50008281, 2, ',50016349,50008281,50006765,', 0),
(50006753, '搅拌棒', 20, 50008281, 2, ',50016349,50008281,50006753,', 0),
(50006946, '核桃夹', 12, 50008281, 2, ',50016349,50008281,50006946,', 0),
(50007062, '旋盖小宝', 12, 50008281, 2, ',50016349,50008281,50007062,', 0),
(50006758, '手动榨汁器', 12, 50008281, 2, ',50016349,50008281,50006758,', 0),
(50006847, '开橙器/剥橙器', 11, 50008281, 2, ',50016349,50008281,50006847,', 0),
(50006762, '鸡蛋加工', 10, 50008281, 2, ',50016349,50008281,50006762,', 1),
(350707, '封口夹/封口机/密封器', 9, 50008281, 2, ',50016349,50008281,350707,', 0),
(50012490, 'DIY模具', 8, 50008281, 2, ',50016349,50008281,50012490,', 0),
(50012488, '厨房电器配套用品', 7, 50008281, 2, ',50016349,50008281,50012488,', 1),
(50006756, '厨房点火器/点火棒', 5, 50008281, 2, ',50016349,50008281,50006756,', 0),
(50012950, '定时器/计时器/提醒器', 4, 50008281, 2, ',50016349,50008281,50012950,', 0),
(50009534, '厨房秤/计量秤', 3, 50008281, 2, ',50016349,50008281,50009534,', 1),
(50012489, '储物瓶罐/厨房储物器皿', 2, 50008281, 2, ',50016349,50008281,50012489,', 1),
(211502, '其它桌类', 47, 50008280, 2, ',50008164,50008280,211502,', 0),
(50015639, '桌子配件', 46, 50008280, 2, ',50008164,50008280,50015639,', 1),
(50022492, '经桌', 45, 50008280, 2, ',50008164,50008280,50022492,', 0),
(50022491, '供桌', 44, 50008280, 2, ',50008164,50008280,50022491,', 0),
(50015822, '棋桌', 25, 50008280, 2, ',50008164,50008280,50015822,', 0),
(50015821, '琴桌', 24, 50008280, 2, ',50008164,50008280,50015821,', 0),
(50010098, '麻将桌', 11, 50008280, 2, ',50008164,50008280,50010098,', 0),
(50015834, '儿童学习桌', 6, 50008280, 2, ',50008164,50008280,50015834,', 0),
(50001415, '折叠桌', 5, 50008280, 2, ',50008164,50008280,50001415,', 0),
(50001732, '书桌', 4, 50008280, 2, ',50008164,50008280,50001732,', 0),
(50001385, '梳妆台/桌', 3, 50008280, 2, ',50008164,50008280,50001385,', 0),
(50003823, '电脑桌', 2, 50008280, 2, ',50008164,50008280,50003823,', 0),
(50001403, '餐桌', 1, 50008280, 2, ',50008164,50008280,50001403,', 0),
(50018594, '定时器/计时器', 14, 50008275, 2, ',21,50008275,50018594,', 0),
(50007177, '立钟/落地钟', 5, 50008275, 2, ',21,50008275,50007177,', 0),
(50011664, '座钟', 4, 50008275, 2, ',21,50008275,50011664,', 0),
(50001284, '闹钟/投影钟', 2, 50008275, 2, ',21,50008275,50001284,', 0),
(50001283, '挂钟', 1, 50008275, 2, ',21,50008275,50001283,', 0),
(50008324, '其他架类', 38, 50008274, 2, ',50008164,50008274,50008324,', 0),
(50022487, '壁炉架', 37, 50008274, 2, ',50008164,50008274,50022487,', 0),
(50015929, '多宝格/博古架', 35, 50008274, 2, ',50008164,50008274,50015929,', 0),
(50015921, '家用雨伞架', 33, 50008274, 2, ',50008164,50008274,50015921,', 0),
(50015930, '面盆架', 26, 50008274, 2, ',50008164,50008274,50015930,', 0),
(50015842, '画架', 14, 50008274, 2, ',50008164,50008274,50015842,', 0),
(50005527, '花架/花几', 11, 50008274, 2, ',50008164,50008274,50005527,', 0),
(50015922, '酒架', 10, 50008274, 2, ',50008164,50008274,50015922,', 0),
(50015924, 'CD架', 8, 50008274, 2, ',50008164,50008274,50015924,', 0),
(50015745, '组合衣架', 8, 50008274, 2, ',50008164,50008274,50015745,', 0),
(50001412, '衣帽架', 7, 50008274, 2, ',50008164,50008274,50001412,', 0),
(50010417, '书报架', 5, 50008274, 2, ',50008164,50008274,50010417,', 0),
(50006533, '鞋架', 4, 50008274, 2, ',50008164,50008274,50006533,', 0),
(50001717, '格架', 3, 50008274, 2, ',50008164,50008274,50001717,', 0),
(50015931, '搁板/置物架', 2, 50008274, 2, ',50008164,50008274,50015931,', 0),
(50022699, '书架', 1, 50008274, 2, ',50008164,50008274,50022699,', 0),
(50008148, '其他酒类', 10, 50008141, 2, ',50026316,50008141,50008148,', 0),
(50008146, '啤酒', 9, 50008141, 2, ',50026316,50008141,50008146,', 0),
(50008145, '药酒', 8, 50008141, 2, ',50026316,50008141,50008145,', 0),
(50008147, '黄酒', 5, 50008141, 2, ',50026316,50008141,50008147,', 0),
(50008144, '国产白酒', 4, 50008141, 2, ',50026316,50008141,50008144,', 0),
(50013003, '葡萄酒', 2, 50008141, 2, ',50026316,50008141,50013003,', 0),
(50008142, '威士忌/进口烈酒', 1, 50008141, 2, ',50026316,50008141,50008142,', 0),
(50023605, '电动/遥控玩具', 6, 50007116, 2, ',25,50007116,50023605,', 1),
(50023645, '惯性/回力/滑行玩具', 1, 50007116, 2, ',25,50007116,50023645,', 0),
(50013863, '发条玩具', 0, 50007116, 2, ',25,50007116,50013863,', 0),
(290502, '其它园艺用品', 41, 50007010, 2, ',50007216,50007010,290502,', 0),
(50015191, '温度计/湿度计', 40, 50007010, 2, ',50007216,50007010,50015191,', 0),
(50015190, '打草绳等其他绳子', 39, 50007010, 2, ',50007216,50007010,50015190,', 0),
(50015189, '塑料薄膜', 38, 50007010, 2, ',50007216,50007010,50015189,', 0),
(50015188, '防护手套', 37, 50007010, 2, ',50007216,50007010,50015188,', 0),
(50015171, '取水/灌溉设备', 35, 50007010, 2, ',50007216,50007010,50015171,', 1),
(50015167, '摇臂/景观喷头', 34, 50007010, 2, ',50007216,50007010,50015167,', 1),
(50015163, '微喷/滴灌/接头类', 33, 50007010, 2, ',50007216,50007010,50015163,', 1),
(50015149, '水枪/地埋式喷头', 32, 50007010, 2, ',50007216,50007010,50015149,', 1),
(50015148, '小型喷雾壶', 31, 50007010, 2, ',50007216,50007010,50015148,', 0),
(50005910, '花园管/软管/包纱管', 18, 50007010, 2, ',50007216,50007010,50005910,', 0),
(50005908, '花园水泵', 16, 50007010, 2, ',50007216,50007010,50005908,', 0),
(50005909, '肥料/营养土/营养液', 17, 50007010, 2, ',50007216,50007010,50005909,', 0),
(50005905, '园艺/刀/剪/锯', 14, 50007010, 2, ',50007216,50007010,50005905,', 0),
(50005904, '割草机/草坪机', 11, 50007010, 2, ',50007216,50007010,50005904,', 0),
(50007048, '大型篱笆/栅栏', 2, 50007010, 2, ',50007216,50007010,50007048,', 0),
(50007047, '花卉药剂', 1, 50007010, 2, ',50007216,50007010,50007047,', 0),
(50007050, '铲/耙/锹/锄', 0, 50007010, 2, ',50007216,50007010,50007050,', 0),
(50007052, '花托/移动托盘', 0, 50007010, 2, ',50007216,50007010,50007052,', 0),
(50007053, '育苗盘/营养钵', 0, 50007010, 2, ',50007216,50007010,50007053,', 0),
(50007051, '洒水/浇水壶', 0, 50007010, 2, ',50007216,50007010,50007051,', 0),
(50007049, '水晶珠/玻璃珠', 0, 50007010, 2, ',50007216,50007010,50007049,', 0),
(50025891, '吸管', 41, 50006885, 2, ',50016349,50006885,50025891,', 0),
(50024782, '热水瓶', 40, 50006885, 2, ',50016349,50006885,50024782,', 1),
(50024781, '保温壶', 39, 50006885, 2, ',50016349,50006885,50024781,', 0),
(50022389, '水具套装', 37, 50006885, 2, ',50016349,50006885,50022389,', 0),
(50022387, '马克杯盖', 36, 50006885, 2, ',50016349,50006885,50022387,', 0),
(50003448, '杯垫', 35, 50006885, 2, ',50016349,50006885,50003448,', 0),
(215207, '其它', 33, 50006885, 2, ',50016349,50006885,215207,', 0),
(50011698, '防漏杯/密封杯', 32, 50006885, 2, ',50016349,50006885,50011698,', 0),
(50011684, '冷水壶', 31, 50006885, 2, ',50016349,50006885,50011684,', 1),
(50008735, '防漏杯盖', 20, 50006885, 2, ',50016349,50006885,50008735,', 0),
(50008525, '定制/广告杯', 20, 50006885, 2, ',50016349,50006885,50008525,', 0),
(50006887, '摇摇杯', 15, 50006885, 2, ',50016349,50006885,50006887,', 0),
(50006888, '吸管杯', 14, 50006885, 2, ',50016349,50006885,50006888,', 0),
(50006898, '奶杯/牛奶杯', 12, 50006885, 2, ',50016349,50006885,50006898,', 0),
(50006897, '随手杯', 11, 50006885, 2, ',50016349,50006885,50006897,', 0),
(50006896, '隔热杯', 10, 50006885, 2, ',50016349,50006885,50006896,', 0),
(50009226, '杯子套装/情侣对杯', 9, 50006885, 2, ',50016349,50006885,50009226,', 0),
(50011697, '运动壶/旅行壶', 7, 50006885, 2, ',50016349,50006885,50011697,', 0),
(50006865, '玻璃杯', 6, 50006885, 2, ',50016349,50006885,50006865,', 0),
(50006894, '太空杯', 5, 50006885, 2, ',50016349,50006885,50006894,', 0),
(50006119, '马克杯', 4, 50006885, 2, ',50016349,50006885,50006119,', 0),
(50006889, '保温杯', 3, 50006885, 2, ',50016349,50006885,50006889,', 0),
(50006998, '其它', 13, 50006583, 2, ',50008165,50006583,50006998,', 0),
(50014847, '口罩', 10, 50006583, 2, ',50008165,50006583,50014847,', 0),
(50019466, '耳套/耳暖', 12, 50006583, 2, ',50008165,50006583,50019466,', 0),
(50010547, '护手脚套', 6, 50006583, 2, ',50008165,50006583,50010547,', 0),
(50006997, '三件套', 5, 50006583, 2, ',50008165,50006583,50006997,', 0),
(50006996, '多件套 帽子、围巾、手套等组合', 4, 50006583, 2, ',50008165,50006583,50006996,', 0),
(50006995, '手套', 3, 50006583, 2, ',50008165,50006583,50006995,', 0),
(50006994, '围巾', 2, 50006583, 2, ',50008165,50006583,50006994,', 0),
(50006993, '帽子', 1, 50006583, 2, ',50008165,50006583,50006993,', 0),
(50023261, '烘鞋器', 23, 50006528, 2, ',21,50006528,50023261,', 0),
(50025847, '居家鞋', 23, 50006528, 2, ',21,50006528,50025847,', 0),
(350306, '其它', 20, 50006528, 2, ',21,50006528,350306,', 0),
(50006679, '靴撑/靴夹/鞋楦', 10, 50006528, 2, ',21,50006528,50006679,', 0),
(50006551, '鞋刷/鞋擦', 8, 50006528, 2, ',21,50006528,50006551,', 0),
(50006532, '鞋垫', 4, 50006528, 2, ',21,50006528,50006532,', 0),
(50006531, '鞋塞', 3, 50006528, 2, ',21,50006528,50006531,', 0),
(50006530, '鞋拔', 2, 50006528, 2, ',21,50006528,50006530,', 0),
(50009960, '鞋套', 2, 50006528, 2, ',21,50006528,50009960,', 0),
(50006529, '鞋套机', 1, 50006528, 2, ',21,50006528,50006529,', 0),
(50011359, '其它宜家临时类目', 65, 50006281, 2, ',50008164,50006281,50011359,', 1),
(50006285, '家具保养', 61, 50006281, 2, ',50008164,50006281,50006285,', 1),
(50008439, '宜家儿童用品', 56, 50006281, 2, ',50008164,50006281,50008439,', 1),
(50006297, '门厅和入口', 55, 50006281, 2, ',50008164,50006281,50006297,', 1),
(50006288, '桌子和椅子', 54, 50006281, 2, ',50008164,50006281,50006288,', 1),
(50006290, '浴室', 52, 50006281, 2, ',50008164,50006281,50006290,', 1),
(50006283, '办公', 52, 50006281, 2, ',50008164,50006281,50006283,', 1),
(50006284, '厨房', 51, 50006281, 2, ',50008164,50006281,50006284,', 1),
(50006293, '餐具', 49, 50006281, 2, ',50008164,50006281,50006293,', 1),
(50006294, '窗帘/地毯', 49, 50006281, 2, ',50008164,50006281,50006294,', 1),
(50006291, '烹饪用具', 48, 50006281, 2, ',50008164,50006281,50006291,', 1),
(50006296, '装饰品', 47, 50006281, 2, ',50008164,50006281,50006296,', 1),
(50006286, '床上纺织用品', 46, 50006281, 2, ',50008164,50006281,50006286,', 1),
(50006298, '其它宜家代购', 42, 50006281, 2, ',50008164,50006281,50006298,', 0),
(50011521, '瑞典食品', 25, 50006281, 2, ',50008164,50006281,50011521,', 1),
(50011497, '家具护理产品和五金配件', 24, 50006281, 2, ',50008164,50006281,50011497,', 1),
(50011508, '浴室家具', 23, 50006281, 2, ',50008164,50006281,50011508,', 1),
(50011512, '宜家儿童部', 22, 50006281, 2, ',50008164,50006281,50011512,', 1),
(50008442, '照明', 21, 50006281, 2, ',50008164,50006281,50008442,', 1),
(50011500, '厨柜和家电', 20, 50006281, 2, ',50008164,50006281,50011500,', 1),
(50011546, '椅子', 18, 50006281, 2, ',50008164,50006281,50011546,', 1),
(50011540, '桌子', 17, 50006281, 2, ',50008164,50006281,50011540,', 1),
(50011487, '烹饪和餐饮用品', 16, 50006281, 2, ',50008164,50006281,50011487,', 1),
(50006282, '储物家具', 15, 50006281, 2, ',50008164,50006281,50006282,', 1),
(50010318, '小型储物用品', 14, 50006281, 2, ',50008164,50006281,50010318,', 1),
(50006295, '衣物储物产品', 13, 50006281, 2, ',50008164,50006281,50006295,', 1),
(50011529, '装饰用品和镜子', 11, 50006281, 2, ',50008164,50006281,50011529,', 1),
(50011477, '纺织品和地毯', 10, 50006281, 2, ',50008164,50006281,50011477,', 1),
(50011443, '沙发套/养护用品', 9, 50006281, 2, ',50008164,50006281,50011443,', 0),
(50011438, '扶手椅', 8, 50006281, 2, ',50008164,50006281,50011438,', 1),
(50011441, '沙发床', 7, 50006281, 2, ',50008164,50006281,50011441,', 0),
(50010346, '沙发', 6, 50006281, 2, ',50008164,50006281,50010346,', 1),
(50011446, '床和床垫', 4, 50006281, 2, ',50008164,50006281,50011446,', 1),
(50006287, '床架/床垫', 5, 50006281, 2, ',50008164,50006281,50006287,', 1),
(50016369, '雨具', 37, 50006020, 2, ',50014812,50006020,50016369,', 0),
(50016368, '汽车安全座椅/安全背带', 36, 50006020, 2, ',50014812,50006020,50016368,', 1),
(50005962, '出行用品', 19, 50006020, 2, ',50014812,50006020,50005962,', 0),
(50006023, '学步带', 17, 50006020, 2, ',50014812,50006020,50006023,', 0),
(50005960, '背带/背袋', 16, 50006020, 2, ',50014812,50006020,50005960,', 0),
(50012820, '抱婴腰带/腰凳', 15, 50006020, 2, ',50014812,50006020,50012820,', 0),
(50006008, '其它', 46, 50006000, 2, ',50022517,50006000,50006008,', 0),
(50012415, '育儿背巾', 3, 50006020, 2, ',50014812,50006020,50012415,', 0),
(50015893, '美容胶带', 45, 50006000, 2, ',50022517,50006000,50015893,', 0),
(50023677, '孕妇马桶/座便器', 44, 50006000, 2, ',50022517,50006000,50023677,', 0),
(50017183, '一次性马桶垫纸', 43, 50006000, 2, ',50022517,50006000,50017183,', 0),
(50006005, '产妇卫生巾/护垫', 42, 50006000, 2, ',50022517,50006000,50006005,', 0),
(50015561, '看护垫/一次性床垫', 41, 50006000, 2, ',50022517,50006000,50015561,', 0),
(50015896, '一次性内裤', 40, 50006000, 2, ',50022517,50006000,50015896,', 0),
(50011810, '乳头矫正', 39, 50006000, 2, ',50022517,50006000,50011810,', 0),
(50006013, '乳头保护罩', 38, 50006000, 2, ',50022517,50006000,50006013,', 0),
(50011820, '乳房冷热敷', 37, 50006000, 2, ',50022517,50006000,50011820,', 0),
(50011801, '母乳储存保鲜', 36, 50006000, 2, ',50022517,50006000,50011801,', 0),
(50006014, '防溢乳垫', 35, 50006000, 2, ',50022517,50006000,50006014,', 0),
(50006015, '吸奶器', 34, 50006000, 2, ',50022517,50006000,50006015,', 0),
(50011819, '胎心仪', 33, 50006000, 2, ',50022517,50006000,50011819,', 0),
(50011829, '哺乳枕', 32, 50006000, 2, ',50022517,50006000,50011829,', 0),
(50006228, '护腰枕', 31, 50006000, 2, ',50022517,50006000,50006228,', 0),
(50015564, '月子牙刷', 30, 50006000, 2, ',50022517,50006000,50015564,', 0),
(50012363, '托腹带/保胎带', 29, 50006000, 2, ',50022517,50006000,50012363,', 0),
(50023676, '孕产妇湿巾/清洁棉', 28, 50006000, 2, ',50022517,50006000,50023676,', 0),
(50017184, '待产包', 27, 50006000, 2, ',50022517,50006000,50017184,', 0),
(50001410, '其它组合家具', 40, 50005963, 2, ',25,50005963,50001410,', 0),
(250801, '其它类', 37, 50005963, 2, ',25,50005963,250801,', 0),
(50005515, '儿童套房', 12, 50005963, 2, ',25,50005963,50005515,', 0),
(50016453, '儿童储物架/收纳架', 11, 50005963, 2, ',25,50005963,50016453,', 0),
(50016452, '沙发', 10, 50005963, 2, ',25,50005963,50016452,', 0),
(50001730, '儿童椅', 8, 50005963, 2, ',25,50005963,50001730,', 0),
(50023699, '儿童桌', 7, 50005963, 2, ',25,50005963,50023699,', 0),
(50006890, '成套桌椅', 6, 50005963, 2, ',25,50005963,50006890,', 0),
(50023698, '儿童书桌椅/写字台', 5, 50005963, 2, ',25,50005963,50023698,', 0),
(50005957, '其它', 19, 50005952, 2, ',50014812,50005952,50005957,', 0),
(50016330, '婴儿监护器', 18, 50005952, 2, ',50014812,50005952,50016330,', 0),
(50016224, '燃气旋钮保护罩', 17, 50005952, 2, ',50014812,50005952,50016224,', 0),
(50014849, '床护栏', 16, 50005952, 2, ',50014812,50005952,50014849,', 0),
(50016223, '门护栏', 15, 50005952, 2, ',50014812,50005952,50016223,', 0),
(50005969, '安全门卡', 11, 50005952, 2, ',50014812,50005952,50005969,', 0),
(50016222, '多功能安全锁', 10, 50005952, 2, ',50014812,50005952,50016222,', 0),
(50006503, '防触电保护', 9, 50005952, 2, ',50014812,50005952,50006503,', 0),
(50006502, '防撞角', 9, 50005952, 2, ',50014812,50005952,50006502,', 0),
(50012226, '防撞条', 8, 50005952, 2, ',50014812,50005952,50012226,', 0),
(50005982, '防丢提醒器', 7, 50005952, 2, ',50014812,50005952,50005982,', 0),
(50005959, '尿湿提醒器', 6, 50005952, 2, ',50014812,50005952,50005959,', 0),
(50005956, '蹬被提醒器', 4, 50005952, 2, ',50014812,50005952,50005956,', 0),
(50005953, '安全别针', 1, 50005952, 2, ',50014812,50005952,50005953,', 0),
(50005949, '高丽参', 4, 50005945, 2, ',50020275,50005945,50005949,', 0),
(50005948, '西洋参', 3, 50005945, 2, ',50020275,50005945,50005948,', 0),
(50005947, '人参/园参', 2, 50005945, 2, ',50020275,50005945,50005947,', 0),
(50005946, '山参', 1, 50005945, 2, ',50020275,50005945,50005946,', 0),
(50005778, '其它蜂产品', 8, 50005773, 2, ',50020275,50005773,50005778,', 0),
(50012591, '蜂蜡', 7, 50005773, 2, ',50020275,50005773,50012591,', 0),
(50012590, '蜂巢素', 6, 50005773, 2, ',50020275,50005773,50012590,', 0),
(50005777, '蜂花粉', 4, 50005773, 2, ',50020275,50005773,50005777,', 0),
(50005776, '蜂王浆', 3, 50005773, 2, ',50020275,50005773,50005776,', 0),
(50005775, '蜂胶', 2, 50005773, 2, ',50020275,50005773,50005775,', 0),
(50005774, '蜂蜜', 1, 50005773, 2, ',50020275,50005773,50005774,', 0),
(50024642, '视力保护器', 14, 50005757, 2, ',50018004,50005757,50024642,', 0),
(211704, '其它文具', 13, 50005757, 2, ',50018004,50005757,211704,', 0),
(50011937, '可爱印章/印泥', 12, 50005757, 2, ',50018004,50005757,50011937,', 0),
(50011905, '文具套装/礼盒', 9, 50005757, 2, ',50018004,50005757,50011905,', 0),
(50012909, '彩泥/橡皮泥', 8, 50005757, 2, ',50018004,50005757,50012909,', 0),
(50011403, '书皮', 6, 50005757, 2, ',50018004,50005757,50011403,', 0),
(50005122, '卷笔刀/削笔器', 5, 50005757, 2, ',50018004,50005757,50005122,', 0),
(211703, '橡皮', 2, 50005757, 2, ',50018004,50005757,211703,', 0),
(50005117, '握笔器', 4, 50005757, 2, ',50018004,50005757,50005117,', 0),
(211702, '文具盒/笔袋', 2, 50005757, 2, ',50018004,50005757,211702,', 0),
(50005119, '修正液/修正带/修正贴', 1, 50005757, 2, ',50018004,50005757,50005119,', 0),
(50005759, '书包', 1, 50005757, 2, ',50018004,50005757,50005759,', 0),
(50006839, '放大镜', 74, 50005756, 2, ',50018004,50005756,50006839,', 0),
(50024652, '显微镜', 11, 50005756, 2, ',50018004,50005756,50024652,', 0),
(50005758, '其它', 10, 50005756, 2, ',50018004,50005756,50005758,', 0),
(50005123, '算盘', 7, 50005756, 2, ',50018004,50005756,50005123,', 0),
(50005090, '各类尺/三角板', 2, 50005756, 2, ',50018004,50005756,50005090,', 0),
(50005113, '圆规', 1, 50005756, 2, ',50018004,50005756,50005113,', 0),
(50014808, '旗帜', 125, 50005752, 2, ',50018004,50005752,50014808,', 0),
(50018243, '地球仪', 76, 50005752, 2, ',50018004,50005752,50018243,', 0),
(50016239, '激光笔/教鞭', 25, 50005752, 2, ',50018004,50005752,50016239,', 0),
(50012734, '粉笔', 19, 50005752, 2, ',50018004,50005752,50012734,', 0),
(50024650, '教学仪器/实验器材', 18, 50005752, 2, ',50018004,50005752,50024650,', 0),
(50024649, '标志牌/提示牌', 17, 50005752, 2, ',50018004,50005752,50024649,', 0),
(50024648, '计划表', 16, 50005752, 2, ',50018004,50005752,50024648,', 0),
(50024647, '展板', 15, 50005752, 2, ',50018004,50005752,50024647,', 0),
(50024646, '软木板/照片板', 14, 50005752, 2, ',50018004,50005752,50024646,', 0),
(50005755, '其它', 13, 50005752, 2, ',50018004,50005752,50005755,', 0),
(50012723, '白板笔', 9, 50005752, 2, ',50018004,50005752,50012723,', 0),
(50005753, '板擦', 4, 50005752, 2, ',50018004,50005752,50005753,', 0),
(50005754, '绿板', 3, 50005752, 2, ',50018004,50005752,50005754,', 0),
(50003934, '白板', 2, 50005752, 2, ',50018004,50005752,50003934,', 0),
(50010956, '黑板', 1, 50005752, 2, ',50018004,50005752,50010956,', 0),
(50016061, '荧光板', 0, 50005752, 2, ',50018004,50005752,50016061,', 0),
(50024644, '刀片', 12, 50005747, 2, ',50018004,50005747,50024644,', 0),
(50050378, '食用油/调味油', 92, 50016422, 1, ',50016422,50050378,', 1),
(50025689, '方便速食', 86, 50016422, 1, ',50016422,50025689,', 1),
(50016443, '其他食品', 82, 50016422, 1, ',50016422,50016443,', 0),
(50010696, '烘焙原料/辅料/食品添加剂', 71, 50016422, 1, ',50016422,50010696,', 0),
(50025682, '南北干货/水产/肉类干货', 40, 50016422, 1, ',50016422,50025682,', 1),
(50009821, '调味品/果酱/沙拉', 39, 50016422, 1, ',50016422,50009821,', 1),
(50009837, '米/面粉/杂粮', 0, 50016422, 1, ',50016422,50009837,', 1),
(50022523, '一次性餐桌用品', 19, 50016349, 1, ',50016349,50022523,', 1),
(50002258, '烧烤/烘焙用具', 18, 50016349, 1, ',50016349,50002258,', 1),
(50008281, '厨用小工具/厨房储物', 16, 50016349, 1, ',50016349,50008281,', 1),
(50010101, '烹饪用具', 15, 50016349, 1, ',50016349,50010101,', 1),
(50014236, '保鲜容器/保鲜器皿', 14, 50016349, 1, ',50016349,50014236,', 1),
(215206, '酒壶/酒杯/酒具', 10, 50016349, 1, ',50016349,215206,', 1),
(2107, '茶具', 6, 50016349, 1, ',50016349,2107,', 1),
(50004438, '咖啡器具', 8, 50016349, 1, ',50016349,50004438,', 1),
(50002796, '餐具', 5, 50016349, 1, ',50016349,50002796,', 1),
(50006885, '杯子/水杯/水壶', 0, 50016349, 1, ',50016349,50006885,', 1),
(2132, '卫浴用具/卫浴配件', 39, 50016348, 1, ',50016348,2132,', 1),
(50023243, '家庭防尘用具', 38, 50016348, 1, ',50016348,50023243,', 1),
(50023189, '家庭整理用具', 37, 50016348, 1, ',50016348,50023189,', 1),
(50022707, '浴洗工具/配件', 13, 50016348, 1, ',50016348,50022707,', 0),
(50018683, '家庭收纳用具', 6, 50016348, 1, ',50016348,50018683,', 1),
(50000569, '衣物洗/晒/护理用具', 2, 50016348, 1, ',50016348,50000569,', 1),
(50003949, '家务/地板清洁用具', 1, 50016348, 1, ',50016348,50003949,', 1),
(50009146, '个人洗护清洁用具', 1, 50016348, 1, ',50016348,50009146,', 1),
(50022520, '婴儿手推车/学步车', 110, 50014812, 1, ',50014812,50022520,', 1),
(211112, '其它', 105, 50014812, 1, ',50014812,211112,', 0),
(50018396, '浴衣/浴盆/洗发帽/水温计', 103, 50014812, 1, ',50014812,50018396,', 1),
(50018394, '驱蚊/退烧/感冒贴', 101, 50014812, 1, ',50014812,50018394,', 0),
(50018391, '消毒/吸奶器/小家电', 99, 50014812, 1, ',50014812,50018391,', 1),
(50012466, '清洁液/洗衣液/柔顺剂', 32, 50014812, 1, ',50014812,50012466,', 1),
(50012448, '牙胶/牙刷/牙膏', 31, 50014812, 1, ',50014812,50012448,', 1),
(50005952, '防撞/提醒/安全/保护', 30, 50014812, 1, ',50014812,50005952,', 1),
(50006020, '背带/学步带/出行用品', 28, 50014812, 1, ',50014812,50006020,', 1),
(50012436, '理发器/指甲钳/体温计等日常护理小用品', 26, 50014812, 1, ',50014812,50012436,', 1),
(50009521, '水杯/餐具/研磨/附件', 25, 50014812, 1, ',50014812,50009521,', 1),
(50012412, '抱被/毛毯/床品', 22, 50014812, 1, ',50014812,50012412,', 1),
(50014248, '宝宝洗浴护肤品', 21, 50014812, 1, ',50014812,50014248,', 1),
(50018325, '口水巾/吸汗巾/饭兜/袖套', 20, 50014812, 1, ',50014812,50018325,', 1),
(50012711, '布尿裤/尿垫', 14, 50014812, 1, ',50014812,50012711,', 1),
(50013866, '童床/婴儿床/摇篮/餐椅', 9, 50014812, 1, ',50014812,50013866,', 1),
(50012805, '安抚奶嘴', 9, 50014812, 1, ',50014812,50012805,', 0),
(50012546, '湿巾', 8, 50014812, 1, ',50014812,50012546,', 0),
(50009523, '奶嘴(单卖)', 8, 50014812, 1, ',50014812,50009523,', 0),
(50009522, '奶瓶', 5, 50014812, 1, ',50014812,50009522,', 0),
(50018813, '纸尿裤/拉拉裤/纸尿片', 4, 50014812, 1, ',50014812,50018813,', 0),
(50009159, '木艺/木制类礼品', 5, 50008719, 2, ',23,50008719,50009159,', 0),
(50018395, '睡袋/凉席/枕头/蚊帐', 3, 50014812, 1, ',50014812,50018395,', 1),
(50008723, '陶瓷紫砂类礼品', 4, 50008719, 2, ',23,50008719,50008723,', 0),
(50008722, '书画类礼品', 3, 50008719, 2, ',23,50008719,50008722,', 0),
(50008721, '钱币邮票类礼品', 2, 50008719, 2, ',23,50008719,50008721,', 0),
(50008720, '玉器/玉石类礼品', 1, 50008719, 2, ',23,50008719,50008720,', 0),
(50008798, '其它', 39, 50008696, 2, ',27,50008696,50008798,', 0),
(50008698, '灯具配件', 5, 50008696, 2, ',27,50008696,50008698,', 0),
(50013525, '其它配件', 9, 50008696, 2, ',27,50008696,50013525,', 0),
(50013521, '玻璃窗配件', 4, 50008696, 2, ',27,50008696,50013521,', 1),
(50013523, '玻璃配件', 3, 50008696, 2, ',27,50008696,50013523,', 1),
(50013524, '贴墙纸配件', 2, 50008696, 2, ',27,50008696,50013524,', 1),
(50013522, '地板配件', 1, 50008696, 2, ',27,50008696,50013522,', 1),
(50013520, '贴砖配件', 0, 50008696, 2, ',27,50008696,50013520,', 1),
(50010687, '传真服务器', 79, 50008551, 2, ',50007218,50008551,50010687,', 0),
(217305, '鸟', 1, 50008604, 2, ',29,50008604,217305,', 0),
(50008650, '鸟食', 2, 50008604, 2, ',29,50008604,50008650,', 0),
(50023352, '鸟笼', 3, 50008604, 2, ',29,50008604,50023352,', 0),
(50003922, '鸟用具', 4, 50008604, 2, ',29,50008604,50003922,', 0),
(50009055, '医疗用品', 5, 50008604, 2, ',29,50008604,50009055,', 0),
(50008616, '牛肉类', 1, 50008613, 2, ',50002766,50008613,50008616,', 0),
(50009866, '猪肉类', 2, 50008613, 2, ',50002766,50008613,50009866,', 0),
(50008618, '鸭肉类', 4, 50008613, 2, ',50002766,50008613,50008618,', 0),
(50008630, '羊肉类', 5, 50008613, 2, ',50002766,50008613,50008630,', 0),
(50008617, '鸡肉类', 7, 50008613, 2, ',50002766,50008613,50008617,', 0),
(50009849, '鹅肉类', 8, 50008613, 2, ',50002766,50008613,50009849,', 0),
(50008628, '兔肉干/兔丁', 12, 50008613, 2, ',50002766,50008613,50008628,', 0),
(50009846, '驴肉', 13, 50008613, 2, ',50002766,50008613,50009846,', 0),
(50009848, '狗肉类', 14, 50008613, 2, ',50002766,50008613,50009848,', 0),
(50009854, '骆驼肉', 17, 50008613, 2, ',50002766,50008613,50009854,', 0),
(50019691, '豆干制品', 22, 50008613, 2, ',50002766,50008613,50019691,', 0),
(50008619, '其它肉制零食', 23, 50008613, 2, ',50002766,50008613,50008619,', 0),
(50006790, '蚁类/蚂蚁工坊', 0, 50008622, 2, ',29,50008622,50006790,', 0),
(50008623, '蜘蛛', 1, 50008622, 2, ',29,50008622,50008623,', 0),
(50008624, '蟋蟀', 2, 50008622, 2, ',29,50008622,50008624,', 0),
(50008625, '蝎类', 3, 50008622, 2, ',29,50008622,50008625,', 0),
(50023364, '蚕宝宝', 4, 50008622, 2, ',29,50008622,50023364,', 0),
(50008651, '爬虫/鸣虫食物', 11, 50008622, 2, ',29,50008622,50008651,', 0),
(50003936, '爬虫/鸣虫用具', 12, 50008622, 2, ',29,50008622,50003936,', 0),
(50009057, '爬虫/鸣虫医疗', 13, 50008622, 2, ',29,50008622,50009057,', 0),
(50008649, '其他爬虫/鸣虫', 21, 50008622, 2, ',29,50008622,50008649,', 0),
(50025640, '场地预定', 105, 50013886, 1, ',50013886,50025640,', 0),
(2203, '其它', 104, 50013886, 1, ',50013886,2203,', 0),
(50016382, '活动/培训', 103, 50013886, 1, ',50013886,50016382,', 0),
(50014757, '炉具/餐具/野餐烧烤用品', 102, 50013886, 1, ',50013886,50014757,', 1),
(50014762, '登山杖/手杖', 101, 50013886, 1, ',50013886,50014762,', 0),
(50014764, '洗漱清洁/护理用品', 100, 50013886, 1, ',50013886,50014764,', 1),
(50014763, '通讯/导航/户外表类', 99, 50013886, 1, ',50013886,50014763,', 1),
(50019712, '饮水用具/盛水容器', 98, 50013886, 1, ',50013886,50019712,', 1),
(50019601, '户外照明', 97, 50013886, 1, ',50013886,50019601,', 1),
(50019592, '望远镜/夜视仪/户外眼镜', 96, 50013886, 1, ',50013886,50019592,', 1),
(50019539, '帐篷/天幕/帐篷配件', 94, 50013886, 1, ',50013886,50019539,', 1),
(50014767, '地图/旅行指南/影像资料', 20, 50013886, 1, ',50013886,50014767,', 1),
(50014766, '干粮/户外食品', 19, 50013886, 1, ',50013886,50014766,', 0),
(50018158, '防护/救生装备', 17, 50013886, 1, ',50013886,50018158,', 1),
(50019007, '军迷服饰/军迷用品', 17, 50013886, 1, ',50013886,50019007,', 1),
(50016119, '旅行便携装备', 16, 50013886, 1, ',50013886,50016119,', 1),
(50013892, '户外休闲家具', 15, 50013886, 1, ',50013886,50013892,', 1),
(50014759, '刀具/多用工具', 10, 50013886, 1, ',50013886,50014759,', 1),
(50013891, '专项户外运动装备', 10, 50013886, 1, ',50013886,50013891,', 1),
(50015368, '服饰配件', 6, 50013886, 1, ',50013886,50015368,', 1),
(50019269, '户外鞋袜', 4, 50013886, 1, ',50013886,50019269,', 1),
(50014756, '防潮垫/地席/枕头', 3, 50013886, 1, ',50013886,50014756,', 1),
(50013908, '睡袋', 2, 50013886, 1, ',50013886,50013908,', 0),
(50013888, '户外服装', 2, 50013886, 1, ',50013886,50013888,', 1),
(50013887, '登山包/旅行包/户外包', 0, 50013886, 1, ',50013886,50013887,', 1),
(50014023, '垂钓装备', 0, 50013886, 1, ',50013886,50014023,', 1),
(50013882, '其它首饰', 18, 50013864, 1, ',50013864,50013882,', 0),
(50013881, '首饰盒/展示架', 17, 50013864, 1, ',50013864,50013881,', 0),
(50013880, '首饰保养鉴定', 16, 50013864, 1, ',50013864,50013880,', 0),
(50013879, 'DIY饰品配件', 15, 50013864, 1, ',50013864,50013879,', 0),
(50013878, '发饰', 14, 50013864, 1, ',50013864,50013878,', 0),
(50013877, '摆件', 13, 50013864, 1, ',50013864,50013877,', 0),
(50013876, '胸针', 12, 50013864, 1, ',50013864,50013876,', 0),
(50013875, '戒指/指环', 11, 50013864, 1, ',50013864,50013875,', 0),
(50013871, '脚链', 10, 50013864, 1, ',50013864,50013871,', 0),
(50013870, '手镯', 9, 50013864, 1, ',50013864,50013870,', 0),
(50013869, '手链', 8, 50013864, 1, ',50013864,50013869,', 0),
(50014227, '耳饰', 3, 50013864, 1, ',50013864,50014227,', 1),
(50013868, '项坠/吊坠', 2, 50013864, 1, ',50013864,50013868,', 0),
(50013865, '项链', 1, 50013864, 1, ',50013864,50013865,', 0),
(110507, '移动硬盘', 14, 50012164, 1, ',50012164,110507,', 0),
(50012167, '记忆棒', 4, 50012164, 1, ',50012164,50012167,', 0),
(50025240, '电脑/电脑配件', 11, 50023878, 1, ',50023878,50025240,', 1),
(50012166, '闪存卡', 3, 50012164, 1, ',50012164,50012166,', 0),
(50012165, 'U盘', 0, 50012164, 1, ',50012164,50012165,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50012135, '生活家电配件', 43, 50012100, 1, ',50012100,50012135,', 1),
(50008544, '其它生活家电', 42, 50012100, 1, ',50012100,50008544,', 1),
(50008542, '电话机(有绳/无绳/网络)', 37, 50012100, 1, ',50012100,50008542,', 0),
(50008563, '对讲机', 36, 50012100, 1, ',50012100,50008563,', 0),
(50006508, '超声波/蒸汽清洁机', 35, 50012100, 1, ',50012100,50006508,', 0),
(50022648, '蒸汽拖把', 34, 50012100, 1, ',50012100,50022648,', 0),
(50008555, '扫地机', 33, 50012100, 1, ',50012100,50008555,', 0),
(50008554, '吸尘器', 32, 50012100, 1, ',50012100,50008554,', 0),
(50002890, '干鞋器/擦鞋器', 25, 50012100, 1, ',50012100,50002890,', 0),
(350310, '毛球修剪器', 24, 50012100, 1, ',50012100,350310,', 0),
(50008553, '蒸汽刷/干洗刷', 23, 50012100, 1, ',50012100,50008553,', 0),
(50008552, '电熨斗', 21, 50012100, 1, ',50012100,50008552,', 0),
(50012101, '干衣机', 20, 50012100, 1, ',50012100,50012101,', 0),
(50013195, '挂烫机', 19, 50012100, 1, ',50012100,50013195,', 0),
(50018327, '吊扇', 17, 50012100, 1, ',50012100,50018327,', 0),
(50008557, '电风扇', 16, 50012100, 1, ',50012100,50008557,', 0),
(50017589, '空调扇', 14, 50012100, 1, ',50012100,50017589,', 0),
(50000360, '电热毯', 13, 50012100, 1, ',50012100,50000360,', 0),
(350404, '暖风机/取暖器', 12, 50012100, 1, ',50012100,350404,', 0),
(50017072, '抽湿器/除湿器', 10, 50012100, 1, ',50012100,50017072,', 0),
(350407, '加湿器', 9, 50012100, 1, ',50012100,350407,', 0),
(350402, '空气净化/氧吧', 8, 50012100, 1, ',50012100,350402,', 0),
(50012099, '厨房家电配件', 40, 50012082, 1, ',50012082,50012099,', 1),
(50008543, '其它厨房家电', 39, 50012082, 1, ',50012082,50008543,', 1),
(350709, '定时器/提醒器', 38, 50012082, 1, ',50012082,350709,', 0),
(50013021, '商用厨电', 37, 50012082, 1, ',50012082,50013021,', 1),
(50013007, '电热杯', 36, 50012082, 1, ',50012082,50013007,', 0),
(50004363, '电饼铛/可丽饼机', 34, 50012082, 1, ',50012082,50004363,', 0),
(50002898, '煮蛋器/蒸蛋器', 33, 50012082, 1, ',50012082,50002898,', 0),
(50002535, '酸奶机', 32, 50012082, 1, ',50012082,50002535,', 0),
(50003695, '电热水壶', 31, 50012082, 1, ',50012082,50003695,', 0),
(350507, '咖啡机', 30, 50012082, 1, ',50012082,350507,', 0),
(50018103, '面包机', 29, 50012082, 1, ',50012082,50018103,', 0),
(50000013, '多士炉', 28, 50012082, 1, ',50012082,50000013,', 0),
(50018218, '榨汁机', 26, 50012082, 1, ',50012082,50018218,', 0),
(50012097, '搅拌/料理机', 25, 50012082, 1, ',50012082,50012097,', 0),
(50008556, '豆浆机', 24, 50012082, 1, ',50012082,50008556,', 0),
(350504, '净水器', 23, 50012082, 1, ',50012082,350504,', 0),
(50002893, '饮水机', 22, 50012082, 1, ',50012082,50002893,', 0),
(350502, '电磁炉', 21, 50012082, 1, ',50012082,350502,', 0),
(50015397, '光波热波炉', 20, 50012082, 1, ',50012082,50015397,', 0),
(50002809, '微波炉', 19, 50012082, 1, ',50012082,50002809,', 0),
(50012959, '电锅煲类', 17, 50012082, 1, ',50012082,50012959,', 1),
(50002894, '电烤箱', 15, 50012082, 1, ',50012082,50002894,', 0),
(50012064, '其它运动鞋', 16, 50012029, 1, ',50012029,50012064,', 0),
(50012049, '运动拖鞋', 15, 50012029, 1, ',50012029,50012049,', 0),
(50012048, '运动沙滩鞋/凉鞋', 14, 50012029, 1, ',50012029,50012048,', 0),
(50012041, '综合训练鞋/室内健身鞋', 13, 50012029, 1, ',50012029,50012041,', 0),
(50026312, '儿童运动鞋', 12, 50012029, 1, ',50012029,50026312,', 0),
(50012044, '帆布鞋', 9, 50012029, 1, ',50012029,50012044,', 0),
(50012043, '板鞋/休闲鞋', 8, 50012029, 1, ',50012029,50012043,', 0),
(50012036, '跑步鞋', 6, 50012029, 1, ',50012029,50012036,', 0),
(50012038, '足球鞋', 3, 50012029, 1, ',50012029,50012038,', 0),
(50012037, '网球鞋', 2, 50012029, 1, ',50012029,50012037,', 0),
(50012031, '篮球鞋', 0, 50012029, 1, ',50012029,50012031,', 0),
(50011866, '影音家电配件', 20, 50011972, 1, ',50011972,50011866,', 1),
(50012934, '其他音箱', 19, 50011972, 1, ',50011972,50012934,', 0),
(50012149, '扩音器/录像机/世嘉', 18, 50011972, 1, ',50011972,50012149,', 1),
(50012148, '工程解决方案', 17, 50011972, 1, ',50011972,50012148,', 0),
(50012067, '随身听/便携视听/收音', 16, 50011972, 1, ',50011972,50012067,', 1),
(50003318, '麦克风/话筒', 15, 50011972, 1, ',50011972,50003318,', 0),
(50011973, 'CD机/卡座/黑胶音源', 12, 50011972, 1, ',50011972,50011973,', 0),
(50005009, '影碟机/DVD/蓝光/VCD/高清', 11, 50011972, 1, ',50011972,50005009,', 0),
(50005174, '硬盘播放器', 10, 50011972, 1, ',50011972,50005174,', 0),
(121616, '组合/迷你/卡通音响', 9, 50011972, 1, ',50011972,121616,', 0),
(50020192, '舞台设备', 7, 50011972, 1, ',50011972,50020192,', 1),
(50012142, 'Hifi音箱/功放/器材', 6, 50011972, 1, ',50011972,50012142,', 1),
(1205, '耳机/耳麦', 1, 50011972, 1, ',50011972,1205,', 0),
(50019784, '酒店客栈套餐', 17, 50011949, 1, ',50011949,50019784,', 1),
(50016161, '酒店客栈', 0, 50011949, 1, ',50011949,50016161,', 0),
(50012908, '雨鞋', 14, 50011740, 1, ',50011740,50012908,', 0),
(50012907, '高帮鞋', 13, 50011740, 1, ',50011740,50012907,', 0),
(50012906, '低帮鞋', 12, 50011740, 1, ',50011740,50012906,', 0),
(50011744, '帆布鞋', 6, 50011740, 1, ',50011740,50011744,', 0),
(50011743, '靴子', 5, 50011740, 1, ',50011740,50011743,', 0),
(50011746, '拖鞋', 4, 50011740, 1, ',50011740,50011746,', 0),
(50011745, '凉鞋', 3, 50011740, 1, ',50011740,50011745,', 0),
(50025242, '相机/摄像机', 10, 50023878, 1, ',50023878,50025242,', 1),
(50023095, '运动包袋', 31, 50011699, 1, ',50011699,50023095,', 1),
(50023102, '运动配件', 30, 50011699, 1, ',50011699,50023102,', 1),
(50023110, '运动马甲', 29, 50011699, 1, ',50011699,50023110,', 1),
(50023415, '运动球服', 28, 50011699, 1, ',50011699,50023415,', 1),
(50023109, '运动裙', 27, 50011699, 1, ',50011699,50023109,', 1),
(50023105, '运动裤', 26, 50011699, 1, ',50011699,50023105,', 1),
(50022891, '健身服装', 23, 50011699, 1, ',50011699,50022891,', 1),
(50022889, '运动POLO衫', 22, 50011699, 1, ',50011699,50022889,', 0),
(50022728, '运动套装', 21, 50011699, 1, ',50011699,50022728,', 0),
(50011704, '运动毛衣/线衫', 13, 50011699, 1, ',50011699,50011704,', 0),
(50011721, '运动羽绒服', 6, 50011699, 1, ',50011699,50011721,', 0),
(50011720, '运动棉衣', 5, 50011699, 1, ',50011699,50011720,', 0),
(50011739, '运动茄克/外套', 4, 50011699, 1, ',50011699,50011739,', 0),
(50011718, '运动风衣', 1, 50011699, 1, ',50011699,50011718,', 0),
(50011717, '运动卫衣/套头衫', 0, 50011699, 1, ',50011699,50011717,', 0),
(50013228, '运动T恤', 0, 50011699, 1, ',50011699,50013228,', 0),
(50008728, '灯饰灯具', 3, 50008725, 2, ',27,50008725,50008728,', 0),
(50008727, '五金工具', 2, 50008725, 2, ',27,50008725,50008727,', 0),
(50008726, '安防报警设备', 1, 50008725, 2, ',27,50008725,50008726,', 0),
(50009161, '生日报/纸质纪念礼品', 8, 50008719, 2, ',23,50008719,50009161,', 0),
(50008724, '其它收藏礼品', 9, 50008719, 2, ',23,50008719,50008724,', 0),
(50009160, '奥运类收藏礼品', 7, 50008719, 2, ',23,50008719,50009160,', 0),
(50009197, '雕刻艺术类礼品', 6, 50008719, 2, ',23,50008719,50009197,', 0),
(50011402, '红蓝宝石/贵重宝石', 19, 50011397, 1, ',50011397,50011402,', 0),
(50013963, '天然琥珀', 18, 50011397, 1, ',50011397,50013963,', 0),
(50011663, '专柜swarovski水晶', 10, 50011397, 1, ',50011397,50011663,', 0),
(50013957, '天然玉石', 8, 50011397, 1, ',50011397,50013957,', 0),
(50013964, '天然珍珠', 7, 50011397, 1, ',50011397,50013964,', 0),
(50011401, '铂金/PT', 6, 50011397, 1, ',50011397,50011401,', 0),
(50011400, '黄金K金', 5, 50011397, 1, ',50011397,50011400,', 0),
(50011399, '翡翠', 4, 50011397, 1, ',50011397,50011399,', 0),
(50011398, '钻石', 3, 50011397, 1, ',50011397,50011398,', 0),
(50010814, '其它彩妆', 40, 50010788, 1, ',50010788,50010814,', 0),
(50019246, '男士彩妆', 39, 50010788, 1, ',50010788,50019246,', 0),
(50010813, '身体彩绘', 36, 50010788, 1, ',50010788,50010813,', 0),
(50010812, '彩妆套装/彩妆盘', 35, 50010788, 1, ',50010788,50010812,', 0),
(50010817, '化妆/美容工具', 30, 50010788, 1, ',50010788,50010817,', 0),
(50019251, '化妆刷/刷包', 29, 50010788, 1, ',50010788,50019251,', 0),
(50010810, '指甲油/美甲产品', 28, 50010788, 1, ',50010788,50010810,', 0),
(50010800, '双眼皮贴/胶水', 24, 50010788, 1, ',50010788,50010800,', 0),
(50010808, '唇膏/口红', 23, 50010788, 1, ',50010788,50010808,', 0),
(50010807, '唇彩/唇蜜', 22, 50010788, 1, ',50010788,50010807,', 0),
(50010801, '唇笔/唇线笔', 21, 50010788, 1, ',50010788,50010801,', 0),
(50010936, '修颜/高光/阴影粉', 18, 50010788, 1, ',50010788,50010936,', 0),
(50010805, '腮红/胭脂', 17, 50010788, 1, ',50010788,50010805,', 0),
(50019254, '假睫毛/假睫毛工具', 12, 50010788, 1, ',50010788,50019254,', 0),
(50010794, '睫毛膏/睫毛增长液', 11, 50010788, 1, ',50010788,50010794,', 0),
(50010796, '眼影', 11, 50010788, 1, ',50010788,50010796,', 0),
(50010797, '眼线', 10, 50010788, 1, ',50010788,50010797,', 0),
(50010798, '眉笔/眉粉/眉膏', 9, 50010788, 1, ',50010788,50010798,', 0),
(50010792, '蜜粉/散粉', 7, 50010788, 1, ',50010788,50010792,', 0),
(50010790, '粉饼', 6, 50010788, 1, ',50010788,50010790,', 0),
(50010789, '粉底液/膏', 5, 50010788, 1, ',50010788,50010789,', 0),
(50010803, '遮瑕', 4, 50010788, 1, ',50010788,50010803,', 0),
(50013794, 'BB霜', 3, 50010788, 1, ',50010788,50013794,', 0),
(50010793, '隔离/妆前/打底', 2, 50010788, 1, ',50010788,50010793,', 0),
(50010815, '香水', 1, 50010788, 1, ',50010788,50010815,', 0),
(50010749, '其它运动用品', 92, 50010728, 1, ',50010728,50010749,', 0),
(50010745, '其他赛事纪念品', 91, 50010728, 1, ',50010728,50010745,', 0),
(50019500, '运动健身卡/会员卡', 90, 50010728, 1, ',50010728,50019500,', 0),
(50019501, '运动书籍/教材', 89, 50010728, 1, ',50010728,50019501,', 0),
(50019502, '运动护具/急救用品', 88, 50010728, 1, ',50010728,50019502,', 0),
(50019503, '慢跑(有氧运动)', 87, 50010728, 1, ',50010728,50019503,', 1),
(50018194, '冰球/速滑/冰上运动', 85, 50010728, 1, ',50010728,50018194,', 1),
(50018189, 'F1/赛车', 84, 50010728, 1, ',50010728,50018189,', 1),
(50023370, '击剑运动', 83, 50010728, 1, ',50010728,50023370,', 1),
(50023363, '马术运动', 82, 50010728, 1, ',50010728,50023363,', 1),
(50013253, '游乐场/体育场馆设施', 81, 50010728, 1, ',50010728,50013253,', 1),
(50018025, '毽子/空竹/民间运动', 68, 50010728, 1, ',50010728,50018025,', 1),
(50017269, '田径运动器材', 66, 50010728, 1, ',50010728,50017269,', 1),
(50018005, '飞镖/桌上足球/室内休闲', 58, 50010728, 1, ',50010728,50018005,', 1),
(50017871, '麻将/棋牌/益智类', 57, 50010728, 1, ',50010728,50017871,', 1),
(50017722, '台球', 55, 50010728, 1, ',50010728,50017722,', 1),
(50018096, '橄榄球', 54, 50010728, 1, ',50010728,50018096,', 1),
(50017117, '跑步机/大型健身器械', 51, 50010728, 1, ',50010728,50017117,', 1),
(50017085, '踏步机/中小型健身器材', 49, 50010728, 1, ',50010728,50017085,', 1),
(50017913, '跆拳道/武术/搏击', 42, 50010728, 1, ',50010728,50017913,', 1),
(50016472, '舞蹈/健美操/体操', 40, 50010728, 1, ',50010728,50016472,', 1),
(50016663, '瑜伽', 37, 50010728, 1, ',50010728,50016663,', 1),
(50016689, '轮滑/滑板/极限运动', 35, 50010728, 1, ',50010728,50016689,', 1),
(50019782, '电动车/电动车配件', 34, 50010728, 1, ',50010728,50019782,', 1),
(2612, '山地/公路/便携自行车', 33, 50010728, 1, ',50010728,2612,', 1),
(50010828, '跳舞毯', 32, 50010728, 1, ',50010728,50010828,', 0),
(50016729, '游泳', 31, 50010728, 1, ',50010728,50016729,', 1),
(50017757, '保龄球', 19, 50010728, 1, ',50010728,50017757,', 1),
(50017625, '壁球', 16, 50010728, 1, ',50010728,50017625,', 1),
(50017859, '棒球', 15, 50010728, 1, ',50010728,50017859,', 1),
(50017776, '高尔夫', 12, 50010728, 1, ',50010728,50017776,', 1),
(50017616, '排球', 11, 50010728, 1, ',50010728,50017616,', 1),
(50017077, '网球', 9, 50010728, 1, ',50010728,50017077,', 1),
(50013202, '篮球', 6, 50010728, 1, ',50010728,50013202,', 1),
(50013823, '足球', 4, 50010728, 1, ',50010728,50013823,', 1),
(50012937, '乒乓球', 2, 50010728, 1, ',50010728,50012937,', 1),
(50011556, '羽毛球', 1, 50010728, 1, ',50010728,50011556,', 1),
(50009047, '其他配件', 19, 50010404, 1, ',50010404,50009047,', 0),
(50009033, '制衣面料', 18, 50010404, 1, ',50010404,50009033,', 1),
(50010406, '鞋包/皮带配件', 17, 50010404, 1, ',50010404,50010406,', 1),
(50009035, '手帕', 15, 50010404, 1, ',50010404,50009035,', 0),
(50010410, '手套', 14, 50010404, 1, ',50010404,50010410,', 0),
(50009037, '耳套', 13, 50010404, 1, ',50010404,50009037,', 0),
(164206, '婚纱礼服配件', 12, 50010404, 1, ',50010404,164206,', 1),
(302909, '袖扣', 10, 50010404, 1, ',50010404,302909,', 0),
(50001248, '领带夹', 8, 50010404, 1, ',50010404,50001248,', 0),
(302902, '领带/领结', 6, 50010404, 1, ',50010404,302902,', 0),
(50011729, '运动颈环/手环/指环', 5, 50010404, 1, ',50010404,50011729,', 0),
(50009578, '围巾/手套/帽子套件', 4, 50010404, 1, ',50010404,50009578,', 1),
(50007003, '围巾/丝巾/披肩', 3, 50010404, 1, ',50010404,50007003,', 0),
(302910, '帽子', 2, 50010404, 1, ',50010404,302910,', 0),
(50009032, '腰带/皮带/腰链', 1, 50010404, 1, ',50010404,50009032,', 0),
(50016439, '宝宝海报/胎教海报', 76, 50008876, 2, ',25,50008876,50016439,', 0),
(50015823, '儿童MP3/故事机', 75, 50008876, 2, ',25,50008876,50015823,', 0),
(50023625, '音乐玩具/儿童乐器', 53, 50008876, 2, ',25,50008876,50023625,', 1),
(50014242, '早教书籍', 16, 50008876, 2, ',25,50008876,50014242,', 0),
(50013856, '早教VCD/DVD/CD', 13, 50008876, 2, ',25,50008876,50013856,', 0),
(50008857, '专业早教教具', 5, 50008876, 2, ',25,50008876,50008857,', 0),
(50008839, '多功能玩具台/游戏桌', 3, 50008876, 2, ',25,50008876,50008839,', 0),
(50008840, '数学学习板/计算架', 4, 50008876, 2, ',25,50008876,50008840,', 0),
(50008838, '早教机/点读学习', 2, 50008876, 2, ',25,50008876,50008838,', 0),
(50014111, '认知卡/识字卡/认知挂图', 1, 50008876, 2, ',25,50008876,50014111,', 0),
(50019037, '四驱车零配件/工具', 54, 50008737, 2, ',25,50008737,50019037,', 0),
(50015993, '不织布/贴片/绳/各材质辅料', 53, 50008737, 2, ',25,50008737,50015993,', 1),
(50008789, '遥控周边/设备', 8, 50008737, 2, ',25,50008737,50008789,', 0),
(50050203, '儿童队服/欧洲杯', 85, 50008165, 1, ',50008165,50050203,', 0),
(50050180, '运动套装', 84, 50008165, 1, ',50008165,50050180,', 0),
(50006217, '其它', 73, 50008165, 1, ',50008165,50006217,', 0),
(50006583, '帽子/围巾/口罩/手套/耳套/脚套', 71, 50008165, 1, ',50008165,50006583,', 1),
(50006584, '袜子', 69, 50008165, 1, ',50008165,50006584,', 0),
(50024824, '儿童配饰/发饰', 67, 50008165, 1, ',50008165,50024824,', 0),
(50023868, '儿童泳衣/裤', 65, 50008165, 1, ',50008165,50023868,', 0),
(50016450, '校服/校服定制', 61, 50008165, 1, ',50008165,50016450,', 0),
(50016012, '儿童舞蹈服/演出服', 60, 50008165, 1, ',50008165,50016012,', 0),
(50012340, '童鞋/婴儿鞋', 51, 50008165, 1, ',50008165,50012340,', 1),
(50012424, '亲子装/亲子时装', 47, 50008165, 1, ',50008165,50012424,', 0),
(50010540, '套装', 46, 50008165, 1, ',50008165,50010540,', 0),
(50010526, '羽绒服/羽绒内胆', 45, 50008165, 1, ',50008165,50010526,', 0),
(50010531, '棉袄/棉服', 44, 50008165, 1, ',50008165,50010531,', 0),
(50012308, '外套/夹克/大衣', 43, 50008165, 1, ',50008165,50012308,', 1),
(50010539, '毛衣/针织衫', 24, 50008165, 1, ',50008165,50010539,', 0),
(50010518, '卫衣/绒衫', 22, 50008165, 1, ',50008165,50010518,', 0),
(50010527, '衬衫', 13, 50008165, 1, ',50008165,50010527,', 0),
(50013189, 'T恤/吊带衫', 12, 50008165, 1, ',50008165,50013189,', 0),
(50012433, '内衣裤/睡衣', 8, 50008165, 1, ',50008165,50012433,', 0),
(50013618, '童装裤子', 7, 50008165, 1, ',50008165,50013618,', 0),
(50013693, '女童裙装', 6, 50008165, 1, ',50008165,50013693,', 0),
(50010524, '马甲/背心', 4, 50008165, 1, ',50008165,50010524,', 0),
(50010530, '披风/斗篷', 3, 50008165, 1, ',50008165,50010530,', 0),
(50012431, '肚围/护脐带/肚兜', 2, 50008165, 1, ',50008165,50012431,', 0),
(50010537, '连身衣/爬服/哈衣', 1, 50008165, 1, ',50008165,50010537,', 0),
(50014512, '婴儿礼盒', 0, 50008165, 1, ',50008165,50014512,', 0),
(50022397, '设计师家具', 81, 50008164, 1, ',50008164,50022397,', 0),
(50022373, '情趣家具', 80, 50008164, 1, ',50008164,50022373,', 1),
(50015771, '成套家具', 78, 50008164, 1, ',50008164,50015771,', 1),
(50015566, '二手/闲置专区', 77, 50008164, 1, ',50008164,50015566,', 1),
(50015568, '家具辅料', 75, 50008164, 1, ',50008164,50015568,', 1),
(50006281, '宜家IKEA', 74, 50008164, 1, ',50008164,50006281,', 1),
(50015230, '户外/庭院家具', 40, 50008164, 1, ',50008164,50015230,', 1),
(50015886, '案/台类', 39, 50008164, 1, ',50008164,50015886,', 1),
(50015915, '屏风/花窗', 38, 50008164, 1, ',50008164,50015915,', 1),
(50020614, '根雕类', 20, 50008164, 1, ',50008164,50020614,', 1),
(50020615, '榻榻米空间', 19, 50008164, 1, ',50008164,50020615,', 1),
(50020617, '镜子类', 18, 50008164, 1, ',50008164,50020617,', 1),
(50020618, '箱类', 15, 50008164, 1, ',50008164,50020618,', 1),
(50008274, '架类', 14, 50008164, 1, ',50008164,50008274,', 1),
(50008280, '桌类', 13, 50008164, 1, ',50008164,50008280,', 1),
(50015816, '几类', 10, 50008164, 1, ',50008164,50015816,', 1),
(50015455, '坐具类', 9, 50008164, 1, ',50008164,50015455,', 1),
(50020006, '沙发类', 8, 50008164, 1, ',50008164,50020006,', 1),
(50021837, '床垫类', 6, 50008164, 1, ',50008164,50021837,', 1),
(50015200, '床类', 5, 50008164, 1, ',50008164,50015200,', 1),
(50001705, '柜类', 4, 50008164, 1, ',50008164,50001705,', 1),
(50006101, '其它', 55, 50008163, 1, ',50008163,50006101,', 0),
(50017143, '缝纫DIY材料、工具及成品', 54, 50008163, 1, ',50008163,50017143,', 1),
(50010041, '布艺蛋糕/蛋糕毛巾', 53, 50008163, 1, ',50008163,50010041,', 0),
(50005033, '布料/面料/手工diy布料面料', 52, 50008163, 1, ',50008163,50005033,', 0),
(213002, '靠垫/抱枕', 51, 50008163, 1, ',50008163,213002,', 0),
(50012051, '家居拖鞋/凉拖/棉拖/居家鞋', 50, 50008163, 1, ',50008163,50012051,', 0),
(50010103, '毛巾/浴巾/浴袍', 49, 50008163, 1, ',50008163,50010103,', 1),
(50012791, '床上用品', 48, 50008163, 1, ',50008163,50012791,', 1),
(50024947, '背景墙软包/床头套/工艺软包', 46, 50008163, 1, ',50008163,50024947,', 1),
(50024925, '窗帘/门帘配件', 45, 50008163, 1, ',50008163,50024925,', 1),
(50024924, '其他帘类', 44, 50008163, 1, ',50008163,50024924,', 1),
(50024923, '窗帘/窗纱', 43, 50008163, 1, ',50008163,50024923,', 1),
(50024922, '十字绣/刺绣', 42, 50008163, 1, ',50008163,50024922,', 1),
(50024918, '餐桌布艺', 41, 50008163, 1, ',50008163,50024918,', 1),
(50002789, '挂帘/门帘/纱窗/配件', 39, 50008163, 1, ',50008163,50002789,', 0),
(50005494, '防尘罩/沙发套/空调罩', 37, 50008163, 1, ',50008163,50005494,', 1),
(50024797, '坐垫/椅垫/沙发垫', 27, 50008163, 1, ',50008163,50024797,', 1),
(290209, '十字绣/刺绣工具配件', 8, 50008163, 1, ',50008163,290209,', 1),
(50000584, '挂毯/壁毯', 4, 50008163, 1, ',50008163,50000584,', 0),
(50000582, '地毯', 4, 50008163, 1, ',50008163,50000582,', 0),
(50000583, '地垫', 3, 50008163, 1, ',50008163,50000583,', 0),
(50001871, '休闲毯/毛毯/绒毯', 1, 50008163, 1, ',50008163,50001871,', 0),
(50050622, '胶片相机配件', 180, 50008090, 1, ',50008090,50050622,', 1),
(50024102, '数码服务', 179, 50008090, 1, ',50008090,50024102,', 1),
(50024109, '数码周边', 178, 50008090, 1, ',50008090,50024109,', 1),
(50003312, '干电池/充电电池/套装', 177, 50008090, 1, ',50008090,50003312,', 1),
(50008482, '数码相框', 62, 50008090, 1, ',50008090,50008482,', 0),
(50005050, '蓝牙耳机', 45, 50008090, 1, ',50008090,50005050,', 0),
(50009211, '移动电源', 44, 50008090, 1, ',50008090,50009211,', 0),
(111703, '3G无线上网卡设备', 43, 50008090, 1, ',50008090,111703,', 0),
(50024101, '数码包/收纳/整理', 21, 50008090, 1, ',50008090,50024101,', 1),
(50018909, 'USB电脑周边', 18, 50008090, 1, ',50008090,50018909,', 1),
(50024099, '电子元器件市场', 17, 50008090, 1, ',50008090,50024099,', 1),
(50011826, '家电影音周边配件', 16, 50008090, 1, ',50008090,50011826,', 1),
(50024103, '摄像机配件', 14, 50008090, 1, ',50008090,50024103,', 0),
(50024104, '电教产品配件', 12, 50008090, 1, ',50008090,50024104,', 1),
(50020180, '电子书配件', 11, 50008090, 1, ',50008090,50020180,', 1),
(50005051, 'MP3/MP4配件', 10, 50008090, 1, ',50008090,50005051,', 1),
(50024098, '平板电脑配件', 9, 50008090, 1, ',50008090,50024098,', 1),
(50024097, '单反/单电相机配件', 7, 50008090, 1, ',50008090,50024097,', 1),
(50024096, '数码相机配件', 6, 50008090, 1, ',50008090,50024096,', 1),
(50024095, '笔记本电脑配件', 4, 50008090, 1, ',50008090,50024095,', 1),
(50024094, '手机配件', 3, 50008090, 1, ',50008090,50024094,', 1),
(50018326, '苹果专用配件', 1, 50008090, 1, ',50008090,50018326,', 1),
(50024400, '其它办公设备配件', 150, 50007218, 1, ',50007218,50024400,', 1),
(50024394, '门禁考勤器材', 149, 50007218, 1, ',50007218,50024394,', 1),
(50024389, '服务类', 148, 50007218, 1, ',50007218,50024389,', 1),
(50024369, '包装设备/标牌及耗材', 147, 50007218, 1, ',50007218,50024369,', 1),
(50024346, '点/验钞/收款机及配件', 146, 50007218, 1, ',50007218,50024346,', 1),
(50024300, '条码扫描/采集器材', 144, 50007218, 1, ',50007218,50024300,', 1),
(50024258, '多功能一体机及配件', 141, 50007218, 1, ',50007218,50024258,', 1),
(50024253, '磁盘刻录存储类', 140, 50007218, 1, ',50007218,50024253,', 1),
(50024248, '墨粉硒鼓耗材类', 139, 50007218, 1, ',50007218,50024248,', 1),
(50021133, '胶带', 137, 50007218, 1, ',50007218,50021133,', 1),
(50019250, '办公用纸', 134, 50007218, 1, ',50007218,50019250,', 1),
(50019240, '墨水', 132, 50007218, 1, ',50007218,50019240,', 0),
(140117, '胶卷', 120, 50007218, 1, ',50007218,140117,', 0),
(111409, '其它耗材', 111, 50007218, 1, ',50007218,111409,', 1),
(50012600, '办公设备配件及相关服务', 45, 50007218, 1, ',50007218,50012600,', 0),
(50008352, '投影机配件', 42, 50007218, 1, ',50007218,50008352,', 1),
(50008551, '传真/通信设备', 41, 50007218, 1, ',50007218,50008551,', 1),
(50001718, '保险箱', 21, 50007218, 1, ',50007218,50001718,', 0),
(50010757, '其它办公设备', 11, 50007218, 1, ',50007218,50010757,', 1),
(111201, '复合复印机', 10, 50007218, 1, ',50007218,111201,', 0),
(211710, '碎纸机', 9, 50007218, 1, ',50007218,211710,', 0),
(110501, '扫描仪', 8, 50007218, 1, ',50007218,110501,', 0),
(50021132, '绳索/扎带/办公线材', 7, 50007218, 1, ',50007218,50021132,', 1),
(111219, '投影机', 6, 50007218, 1, ',50007218,111219,', 0),
(110514, '打印机', 5, 50007218, 1, ',50007218,110514,', 0),
(50012601, '打印机配件', 0, 50007218, 1, ',50007218,50012601,', 1),
(50024880, '庭院植物/行道树木/果树', 17, 50007216, 1, ',50007216,50024880,', 0),
(50024879, '花卉/蔬果/草坪种子', 16, 50007216, 1, ',50007216,50024879,', 0),
(50007010, '园艺用品', 14, 50007216, 1, ',50007216,50007010,', 1),
(50024881, '创意迷你植物', 13, 50007216, 1, ',50007216,50024881,', 0),
(50024878, '花卉/绿植盆栽', 12, 50007216, 1, ',50007216,50024878,', 0),
(50009361, '花瓶/花器/花盆/花架', 11, 50007216, 1, ',50007216,50009361,', 0),
(290503, 'DIY仿真花材料', 10, 50007216, 1, ',50007216,290503,', 1),
(50015193, '仿真花/绿植/蔬果成品', 8, 50007216, 1, ',50007216,50015193,', 0),
(50015215, '追悼/奠仪用花', 7, 50007216, 1, ',50007216,50015215,', 0),
(50015210, '商务用花', 6, 50007216, 1, ',50007216,50015210,', 0),
(50009339, '婚礼鲜花布置', 5, 50007216, 1, ',50007216,50009339,', 1),
(50004417, '鲜果篮(预定与速递)', 4, 50007216, 1, ',50007216,50004417,', 0),
(50003023, '卡通花/巧克力花', 2, 50007216, 1, ',50007216,50003023,', 0),
(290501, '鲜花速递(同城)', 1, 50007216, 1, ',50007216,290501,', 0),
(50012047, '雨鞋', 9, 50006843, 1, ',50006843,50012047,', 0),
(50012042, '帆布鞋', 8, 50006843, 1, ',50006843,50012042,', 0),
(50012033, '拖鞋', 5, 50006843, 1, ',50006843,50012033,', 0),
(50012032, '凉鞋', 4, 50006843, 1, ',50006843,50012032,', 0),
(50012028, '靴子', 2, 50006843, 1, ',50006843,50012028,', 0),
(50012825, '高帮鞋', 1, 50006843, 1, ',50006843,50012825,', 0),
(50012027, '低帮鞋', 0, 50006843, 1, ',50006843,50012027,', 0),
(50050199, '旅行袋', 11, 50006842, 1, ',50006842,50050199,', 0),
(50026617, '箱包相关配件', 10, 50006842, 1, ',50006842,50026617,', 0),
(50012019, '旅行箱', 9, 50006842, 1, ',50006842,50012019,', 0),
(50012018, '钱包卡套', 8, 50006842, 1, ',50006842,50012018,', 0),
(50012010, '包袋', 0, 50006842, 1, ',50006842,50012010,', 0),
(1636, '唐装/中式服装', 12, 50008906, 2, ',16,50008906,1636,', 1),
(162703, '民族服装/舞台装', 3, 50008906, 2, ',16,50008906,162703,', 0),
(50008877, '其它早教玩具类', 81, 50008876, 2, ',25,50008876,50008877,', 0),
(50023774, '智能公仔/娃娃', 80, 50008876, 2, ',25,50008876,50023774,', 0),
(50011877, '各类配件', 52, 50002768, 1, ',50002768,50011877,', 1),
(350210, '其它个人护理', 51, 50002768, 1, ',50002768,350210,', 0),
(50023688, '经络保健器材', 50, 50002768, 1, ',50002768,50023688,', 1),
(50023690, '家用护理辅助器材', 49, 50002768, 1, ',50002768,50023690,', 1),
(50012083, '家用保健器材', 48, 50002768, 1, ',50002768,50012083,', 1),
(50023687, '健康检测仪器', 47, 50002768, 1, ',50002768,50023687,', 1),
(50018398, '按摩器材', 12, 50002768, 1, ',50002768,50018398,', 1),
(50008545, '美容/美体辅助工具', 6, 50002768, 1, ',50002768,50008545,', 1),
(50008548, '美体瘦身', 5, 50002768, 1, ',50002768,50008548,', 1),
(50023686, '美发工具', 2, 50002768, 1, ',50002768,50023686,', 1),
(50024626, '口腔护理', 1, 50002768, 1, ',50002768,50024626,', 1),
(50010567, '清洁美容工具', 0, 50002768, 1, ',50002768,50010567,', 1),
(50008430, '奶酪/乳制品/', 38, 50002766, 1, ',50002766,50008430,', 1),
(50009556, '鱿鱼丝/鱼干/海味即食', 21, 50002766, 1, ',50002766,50009556,', 1),
(50016091, '糖果零食/果冻/布丁', 11, 50002766, 1, ',50002766,50016091,', 1),
(50008055, '巧克力/DIY巧克力', 10, 50002766, 1, ',50002766,50008055,', 0),
(50010550, '饼干/糕点/小点心/膨化', 7, 50002766, 1, ',50002766,50010550,', 1),
(50008613, '牛肉干/猪肉脯/肉类熟食', 6, 50002766, 1, ',50002766,50008613,', 1),
(50012981, '山核桃/坚果/炒货', 5, 50002766, 1, ',50002766,50012981,', 1),
(50013061, '蜜饯/枣类/梅/果干', 4, 50002766, 1, ',50002766,50013061,', 1),
(50020206, '情趣家具', 58, 2813, 1, ',2813,50020206,', 1),
(50019651, '情趣内衣', 56, 2813, 1, ',2813,50019651,', 1),
(50019641, '情趣用品', 55, 2813, 1, ',2813,50019641,', 1),
(50019630, '女用器具', 54, 2813, 1, ',2813,50019630,', 1),
(50019617, '男用器具', 53, 2813, 1, ',2813,50019617,', 1),
(50012829, '计生用品', 52, 2813, 1, ',2813,50012829,', 1),
(50011991, '其他保养', 30, 1801, 1, ',1801,50011991,', 0),
(50011998, '手部保养', 28, 1801, 1, ',1801,50011998,', 0),
(50011988, '男士护理', 27, 1801, 1, ',1801,50011988,', 0),
(50011993, '面部护理套装', 26, 1801, 1, ',1801,50011993,', 0),
(50011997, '面部磨砂/去角质', 25, 1801, 1, ',1801,50011997,', 0),
(50011996, '面部按摩霜', 24, 1801, 1, ',1801,50011996,', 0),
(50011995, 'T区护理', 23, 1801, 1, ',1801,50011995,', 0),
(50011994, '唇部护理', 22, 1801, 1, ',1801,50011994,', 0),
(50011992, '精油芳疗', 15, 1801, 1, ',1801,50011992,', 1),
(50011987, '胸部护理', 14, 1801, 1, ',1801,50011987,', 0),
(50011983, '身体护理', 13, 1801, 1, ',1801,50011983,', 0),
(50011986, '眼部护理', 12, 1801, 1, ',1801,50011986,', 0),
(50011982, '防晒', 7, 1801, 1, ',1801,50011982,', 0),
(50011981, '面膜/面膜粉', 6, 1801, 1, ',1801,50011981,', 0),
(50011980, '乳液/面霜', 5, 1801, 1, ',1801,50011980,', 0),
(50011979, '面部精华', 4, 1801, 1, ',1801,50011979,', 0),
(50011978, '化妆水/爽肤水', 3, 1801, 1, ',1801,50011978,', 0),
(50011990, '卸妆', 1, 1801, 1, ',1801,50011990,', 0),
(50011977, '洁面', 2, 1801, 1, ',1801,50011977,', 0),
(50012787, '搭扣', 44, 1625, 1, ',1625,50012787,', 0),
(50012786, '插片/胸垫', 43, 1625, 1, ',1625,50012786,', 0),
(50012785, '吊袜带', 42, 1625, 1, ',1625,50012785,', 0),
(50012784, '肩带', 41, 1625, 1, ',1625,50012784,', 0),
(50008889, '乳贴', 28, 1625, 1, ',1625,50008889,', 0),
(50008890, '肚兜', 25, 1625, 1, ',1625,50008890,', 0),
(50008888, '抹胸', 23, 1625, 1, ',1625,50008888,', 0),
(50010394, '吊带/背心/T恤', 20, 1625, 1, ',1625,50010394,', 0),
(50006846, '短袜/打底袜/丝袜/美腿袜', 19, 1625, 1, ',1625,50006846,', 0),
(50012778, '保暖套装', 18, 1625, 1, ',1625,50012778,', 0),
(50012777, '保暖裤', 17, 1625, 1, ',1625,50012777,', 0),
(50008885, '保暖上装', 16, 1625, 1, ',1625,50008885,', 0),
(50012773, '睡袍/浴袍', 15, 1625, 1, ',1625,50012773,', 0),
(50012772, '睡衣/家居服套装', 14, 1625, 1, ',1625,50012772,', 0),
(50012771, '睡裙', 13, 1625, 1, ',1625,50012771,', 0),
(50012766, '睡裤/家居裤', 12, 1625, 1, ',1625,50012766,', 0),
(50008886, '睡衣上装', 11, 1625, 1, ',1625,50008886,', 0),
(50012781, '塑身连体衣', 9, 1625, 1, ',1625,50012781,', 0),
(50012776, '塑身分体套装', 8, 1625, 1, ',1625,50012776,', 0),
(50012775, '塑身腰封/腰夹', 7, 1625, 1, ',1625,50012775,', 0),
(50012774, '塑身美体裤', 6, 1625, 1, ',1625,50012774,', 0),
(50008884, '塑身美体衣', 5, 1625, 1, ',1625,50008884,', 0),
(50008882, '内裤', 3, 1625, 1, ',1625,50008882,', 0),
(50008883, '文胸套装', 2, 1625, 1, ',1625,50008883,', 0),
(50008881, '文胸', 1, 1625, 1, ',1625,50008881,', 0),
(50025966, '样图', 16, 50023804, 1, ',50023804,50025966,', 0),
(50025963, '家装效果图', 13, 50023804, 1, ',50023804,50025963,', 0),
(50025958, '家装平面图', 10, 50023804, 1, ',50023804,50025958,', 0),
(50023921, '家装工程监理', 8, 50023804, 1, ',50023804,50023921,', 1),
(50023810, '家庭装修施工', 6, 50023804, 1, ',50023804,50023810,', 1),
(50023809, '家庭装饰设计', 5, 50023804, 1, ',50023804,50023809,', 1),
(50024153, '计生用品', 3, 50023717, 1, ',50023717,50024153,', 1),
(50023722, '隐形眼镜/护理液', 2, 50023717, 1, ',50023717,50023722,', 1),
(50023720, 'OTC药品', 0, 50023717, 1, ',50023717,50023720,', 1),
(50023721, '医疗器械', 1, 50023717, 1, ',50023717,50023721,', 1),
(50026396, '新房垂直市场', 8, 50023575, 1, ',50023575,50026396,', 0),
(50023902, '其他房产服务', 6, 50023575, 1, ',50023575,50023902,', 0),
(50023579, '委托服务/中介服务', 3, 50023575, 1, ',50023575,50023579,', 0),
(50022429, '发贴', 61, 50009146, 2, ',50016348,50009146,50022429,', 0),
(50023598, '二手房/出售/卖房', 1, 50023575, 1, ',50023575,50023598,', 0),
(50023597, '租房/出租/租赁/日租短租', 0, 50023575, 1, ',50023575,50023597,', 0),
(50023294, '染发烫发', 3, 50023282, 1, ',50023282,50023294,', 1),
(50023293, '头发造型', 2, 50023282, 1, ',50023282,50023293,', 0),
(50023292, '洗发护发', 1, 50023282, 1, ',50023282,50023292,', 0),
(50023283, '假发/假发配件', 0, 50023282, 1, ',50023282,50023283,', 1),
(50022734, '大家电配件', 22, 50022703, 1, ',50022703,50022734,', 1),
(50018263, '烟灶消套装', 21, 50022703, 1, ',50022703,50018263,', 0),
(350503, '消毒柜', 20, 50022703, 1, ',50022703,350503,', 0),
(50015382, '燃气灶', 19, 50022703, 1, ',50022703,50015382,', 0),
(350511, '油烟机', 18, 50022703, 1, ',50022703,350511,', 0),
(350401, '空调', 11, 50022703, 1, ',50022703,350401,', 0),
(350301, '洗衣机', 10, 50022703, 1, ',50022703,350301,', 0),
(50015563, '酒柜', 9, 50022703, 1, ',50022703,50015563,', 0),
(50015558, '冷柜/便携冷热箱', 8, 50022703, 1, ',50022703,50015558,', 1),
(50003881, '冰箱', 7, 50022703, 1, ',50022703,50003881,', 0),
(50001813, '家庭影院', 6, 50022703, 1, ',50022703,50001813,', 0),
(50012136, '电视机', 5, 50022703, 1, ',50022703,50012136,', 1),
(50026471, '月子营养', 142, 50022517, 1, ',50022517,50026471,', 1),
(50026460, '孕产妇营养品', 141, 50022517, 1, ',50022517,50026460,', 1),
(50026457, '孕产妇护肤/洗护/祛纹', 140, 50022517, 1, ',50022517,50026457,', 1),
(50023696, '待删勿在此发布-月', 120, 50022517, 1, ',50022517,50023696,', 0),
(50005997, '待删勿在此发布-营', 57, 50022517, 1, ',50022517,50005997,', 0),
(50010392, '孕产妇奶粉', 56, 50022517, 1, ',50022517,50010392,', 0),
(50006000, '妈妈产前产后用品', 55, 50022517, 1, ',50022517,50006000,', 1),
(50011864, '早孕检测', 53, 50022517, 1, ',50022517,50011864,', 0),
(50005961, '妈咪包/袋', 52, 50022517, 1, ',50022517,50005961,', 0),
(50018397, '待删勿在此发布-护', 51, 50022517, 1, ',50022517,50018397,', 0),
(50023660, '束缚带/产妇瘦身塑体衣/盆骨矫正带', 50, 50022517, 1, ',50022517,50023660,', 1),
(50016687, '哺乳文胸/内裤/产检裤', 49, 50022517, 1, ',50022517,50016687,', 1),
(50023613, '家居服/哺乳装/秋衣裤', 48, 50022517, 1, ',50022517,50023613,', 1),
(50012314, '产妇帽/孕妇袜/孕妇鞋', 47, 50022517, 1, ',50022517,50012314,', 1),
(50023573, '孕妇裤/托腹裤', 46, 50022517, 1, ',50022517,50023573,', 0),
(50012354, '孕妇装', 45, 50022517, 1, ',50022517,50012354,', 1),
(50012374, '防辐射', 44, 50022517, 1, ',50022517,50012374,', 1),
(50025777, '葫芦', 33, 50020857, 1, ',50020857,50025777,', 0),
(2902, '禁止发布商品，后果自负(原民间工艺品)', 30, 50020857, 1, ',50020857,2902,', 0),
(50025557, '圣诞用品', 16, 50020857, 1, ',50020857,50025557,', 1),
(50025555, '其他特色工艺品', 14, 50020857, 1, ',50020857,50025555,', 0),
(50021048, '宗教工艺品', 3, 50020857, 1, ',50020857,50021048,', 1),
(50021047, '地区特色工艺品', 2, 50020857, 1, ',50020857,50021047,', 0),
(50021046, '海外工艺品', 1, 50020857, 1, ',50020857,50021046,', 1),
(50021045, '少数民族特色工艺品', 0, 50020857, 1, ',50020857,50021045,', 1),
(50022515, '牙签', 59, 50009146, 2, ',50016348,50009146,50022515,', 0),
(50022433, '造型板', 60, 50009146, 2, ',50016348,50009146,50022433,', 0),
(50024938, '花瓶/花器/仿真花/仿真饰品', 50, 50020808, 1, ',50020808,50024938,', 1),
(50022568, '其他工艺饰品', 48, 50020808, 1, ',50020808,50022568,', 0),
(50020854, '香薰炉', 47, 50020808, 1, ',50020808,50020854,', 0),
(50020855, '竹炭包', 46, 50020808, 1, ',50020808,50020855,', 0),
(50003462, '挂历/台历', 45, 50020808, 1, ',50020808,50003462,', 0),
(50022440, '工艺扇', 44, 50020808, 1, ',50020808,50022440,', 1),
(50010356, '工艺船', 43, 50020808, 1, ',50020808,50010356,', 0),
(50020856, '创意饰品', 30, 50020808, 1, ',50020808,50020856,', 1),
(50020839, '无框画（此类目已屏蔽）', 26, 50020808, 1, ',50020808,50020839,', 1),
(50020851, '工艺伞', 25, 50020808, 1, ',50020808,50020851,', 1),
(50020850, '家居钟饰/闹钟', 24, 50020808, 1, ',50020808,50020850,', 1),
(50020848, '蜡烛/烛台', 22, 50020808, 1, ',50020808,50020848,', 1),
(50020846, '风铃及配件', 20, 50020808, 1, ',50020808,50020846,', 0),
(50020845, '装饰挂钩', 19, 50020808, 1, ',50020808,50020845,', 0),
(50001290, '壁饰', 18, 50020808, 1, ',50020808,50001290,', 0),
(50020834, '雕刻工艺', 16, 50020808, 1, ',50020808,50020834,', 1),
(50020843, '装饰挂牌', 16, 50020808, 1, ',50020808,50020843,', 0),
(50020842, '装饰架/装饰搁板', 15, 50020808, 1, ',50020808,50020842,', 0),
(50020840, '贴饰', 13, 50020808, 1, ',50020808,50020840,', 1),
(50000561, '相框/画框', 11, 50020808, 1, ',50020808,50000561,', 0),
(50020836, '装饰器皿', 8, 50020808, 1, ',50020808,50020836,', 1),
(50020841, '照片/照片墙', 8, 50020808, 1, ',50020808,50020841,', 1),
(50005919, '无框画挂钟', 5, 50020808, 1, ',50020808,50005919,', 0),
(50002045, 'DIY/数字油画', 5, 50020808, 1, ',50020808,50002045,', 0),
(50021905, '国画/书法', 4, 50020808, 1, ',50020808,50021905,', 0),
(50021902, '油画', 2, 50020808, 1, ',50020808,50021902,', 0),
(50021907, '现代装饰画', 1, 50020808, 1, ',50020808,50021907,', 0),
(50020835, '摆件', 0, 50020808, 1, ',50020808,50020835,', 0),
(50020681, '殡葬业家具', 15, 50020611, 1, ',50020611,50020681,', 1),
(50020680, '医疗家具', 14, 50020611, 1, ',50020611,50020680,', 1),
(50020679, '校园教学家具', 13, 50020611, 1, ',50020611,50020679,', 1),
(50020677, '发廊/美容家具', 12, 50020611, 1, ',50020611,50020677,', 1),
(50020675, '桑拿/足浴/健身家具', 11, 50020611, 1, ',50020611,50020675,', 1),
(50020674, '娱乐/酒吧/KTV家具', 10, 50020611, 1, ',50020611,50020674,', 1),
(50020673, '服装店家具', 9, 50020611, 1, ',50020611,50020673,', 1),
(50020672, '餐饮/烘焙家具', 8, 50020611, 1, ',50020611,50020672,', 1),
(50015541, '酒店家具', 7, 50020611, 1, ',50020611,50015541,', 1),
(50020671, '城市家具', 6, 50020611, 1, ',50020611,50020671,', 1),
(50020612, '超市家具', 5, 50020611, 1, ',50020611,50020612,', 1),
(211503, '办公家具', 4, 50020611, 1, ',50020611,211503,', 1),
(50015518, '货架/展柜', 2, 50020611, 1, ',50020611,50015518,', 1),
(50022651, 'LED设备', 31, 50020579, 1, ',50020579,50022651,', 1),
(50013405, '交换器', 25, 50020579, 1, ',50020579,50013405,', 0),
(50013796, '其它', 22, 50020579, 1, ',50020579,50013796,', 0),
(50022516, '接线板/插头', 20, 50020579, 1, ',50020579,50022516,', 1),
(50021153, '安全检查设备', 19, 50020579, 1, ',50020579,50021153,', 1),
(50021120, '消防报警设备', 18, 50020579, 1, ',50020579,50021120,', 1),
(50021105, '防盗报警器材及系统', 17, 50020579, 1, ',50020579,50021105,', 1),
(50021057, '监控器材及系统', 16, 50020579, 1, ',50020579,50021057,', 1),
(50021042, '电工套管', 15, 50020579, 1, ',50020579,50021042,', 1),
(50021033, '电线', 13, 50020579, 1, ',50020579,50021033,', 1),
(50021027, '断路器', 12, 50020579, 1, ',50020579,50021027,', 1),
(50021011, '开关', 11, 50020579, 1, ',50020579,50021011,', 1),
(50020998, '电工配件', 10, 50020579, 1, ',50020579,50020998,', 1),
(50020995, '布线箱', 9, 50020579, 1, ',50020579,50020995,', 1),
(50020985, '蓄电池', 7, 50020579, 1, ',50020579,50020985,', 1),
(50020978, '继电器', 6, 50020579, 1, ',50020579,50020978,', 1),
(50020975, '变压器', 5, 50020579, 1, ',50020579,50020975,', 1),
(50020606, '节电器', 4, 50020579, 1, ',50020579,50020606,', 1),
(50020602, '太阳能电池', 3, 50020579, 1, ',50020579,50020602,', 1),
(50020585, '插座', 0, 50020579, 1, ',50020579,50020585,', 1),
(50020596, '底盒', 1, 50020579, 1, ',50020579,50020596,', 1),
(50020599, '转换器', 2, 50020579, 1, ',50020579,50020599,', 1),
(50020494, '液压/起重工具', 10, 50020485, 1, ',50020485,50020494,', 1),
(50020493, '刃具', 9, 50020485, 1, ',50020485,50020493,', 1),
(50020492, '紧固件', 8, 50020485, 1, ',50020485,50020492,', 1),
(50020491, '机电五金', 7, 50020485, 1, ',50020485,50020491,', 1),
(50020490, '机械五金', 6, 50020485, 1, ',50020485,50020490,', 1),
(50020489, '气动工具', 5, 50020485, 1, ',50020485,50020489,', 1),
(50020646, '电动工具', 3, 50020485, 1, ',50020485,50020646,', 1),
(50020519, '仪器仪表', 2, 50020485, 1, ',50020485,50020519,', 1),
(50020487, '手动工具', 1, 50020485, 1, ',50020485,50020487,', 1),
(50020486, '家用五金', 0, 50020485, 1, ',50020485,50020486,', 1),
(50020608, '阳光房', 71, 50020332, 1, ',50020332,50020608,', 1),
(50013226, '施工保护', 26, 50020332, 1, ',50020332,50013226,', 1),
(50020480, '砂岩', 24, 50020332, 1, ',50020332,50020480,', 1),
(50020472, '天然大理石', 23, 50020332, 1, ',50020332,50020472,', 1),
(50020459, '新型装饰材料', 21, 50020332, 1, ',50020332,50020459,', 1),
(50013508, '硅钙板', 20, 50020332, 1, ',50020332,50013508,', 0),
(50020449, '玻璃', 19, 50020332, 1, ',50020332,50020449,', 1),
(50020445, '雕花件系列', 18, 50020332, 1, ',50020332,50020445,', 1),
(50020442, '门窗密封条', 17, 50020332, 1, ',50020332,50020442,', 1),
(50020417, '石膏板', 15, 50020332, 1, ',50020332,50020417,', 1),
(50020412, '铝型材', 14, 50020332, 1, ',50020332,50020412,', 1),
(50020404, '钢材', 13, 50020332, 1, ',50020332,50020404,', 1),
(50020400, '隔热材料', 12, 50020332, 1, ',50020332,50020400,', 1),
(50020397, '隔音材料', 11, 50020332, 1, ',50020332,50020397,', 1),
(50020392, '其它基础建材', 10, 50020332, 1, ',50020332,50020392,', 1),
(50013517, '人造大理石', 8, 50020332, 1, ',50020332,50013517,', 0),
(50020372, '木方', 8, 50020332, 1, ',50020332,50020372,', 1),
(50020369, '线条', 7, 50020332, 1, ',50020332,50020369,', 1),
(50020358, '水泥', 5, 50020332, 1, ',50020332,50020358,', 1),
(50020362, '水管管材', 6, 50020332, 1, ',50020332,50020362,', 1),
(50020352, '沙/石', 4, 50020332, 1, ',50020332,50020352,', 1),
(50020348, '隔断墙', 3, 50020332, 1, ',50020332,50020348,', 1),
(50020341, '砖', 2, 50020332, 1, ',50020332,50020341,', 1),
(50020333, '板材', 1, 50020332, 1, ',50020332,50020333,', 1),
(50020421, '窗', 0, 50020332, 1, ',50020332,50020421,', 1),
(50050143, '新资源食品', 53, 50020275, 1, ',50020275,50050143,', 1),
(50020296, '其他传统滋补品', 51, 50020275, 1, ',50020275,50020296,', 1),
(50012186, '铁皮/石斛/枫斗', 29, 50020275, 1, ',50020275,50012186,', 0),
(50009980, '三七', 22, 50020275, 1, ',50020275,50009980,', 0),
(50015219, '阿胶膏方', 14, 50020275, 1, ',50020275,50015219,', 1),
(50015211, '雪蛤/林蛙油', 13, 50020275, 1, ',50020275,50015211,', 1),
(50015207, '枸杞及其制品', 12, 50020275, 1, ',50020275,50015207,', 1),
(50015194, '灵芝', 11, 50020275, 1, ',50020275,50015194,', 1),
(50015134, '鹿茸', 10, 50020275, 1, ',50020275,50015134,', 1),
(50008046, '冬虫夏草', 5, 50020275, 1, ',50020275,50008046,', 0),
(50005773, '蜂蜜/蜂产品', 4, 50020275, 1, ',50020275,50005773,', 1),
(50005945, '参类保健品', 3, 50020275, 1, ',50020275,50005945,', 1),
(50008044, '燕窝', 1, 50020275, 1, ',50020275,50008044,', 0),
(50015218, '药食同源食品', 0, 50020275, 1, ',50020275,50015218,', 1),
(50020280, '其他品牌保健品', 0, 50020275, 1, ',50020275,50020280,', 0),
(50020262, '电力猫', 66, 50018264, 1, ',50018264,50020262,', 0),
(50020174, '数码线材', 65, 50018264, 1, ',50018264,50020174,', 0),
(110809, '其它网络相关', 63, 50018264, 1, ',50018264,110809,', 0),
(50019812, '路由器/猫/网卡配件', 64, 50018264, 1, ',50018264,50019812,', 1),
(50019510, '语音视频', 62, 50018264, 1, ',50018264,50019510,', 1),
(50019494, '视频监控', 61, 50018264, 1, ',50018264,50019494,', 1),
(50019361, '机房布线', 60, 50018264, 1, ',50018264,50019361,', 1),
(50019341, '网络安全', 59, 50018264, 1, ',50018264,50019341,', 1),
(50019318, '网络设备', 58, 50018264, 1, ',50018264,50019318,', 1),
(50019309, '无线网络', 57, 50018264, 1, ',50018264,50019309,', 1),
(50016203, '电脑/网络工具', 55, 50018264, 1, ',50018264,50016203,', 1),
(50016195, '网络存储设备', 54, 50018264, 1, ',50018264,50016195,', 1),
(50016189, '光纤设备', 53, 50018264, 1, ',50018264,50016189,', 1),
(110805, '交换机', 26, 50018264, 1, ',50018264,110805,', 0),
(50016213, 'ADSL MODEM/宽带猫', 4, 50018264, 1, ',50018264,50016213,', 0),
(50016214, '网关', 2, 50018264, 1, ',50018264,50016214,', 0),
(110808, '路由器', 1, 50018264, 1, ',50018264,110808,', 0),
(50022650, '3G无线路由器', 1, 50018264, 1, ',50018264,50022650,', 0),
(110209, '网卡', 0, 50018264, 1, ',50018264,110209,', 0),
(50005118, '胶带/胶纸/胶条', 5, 50005730, 2, ',50018004,50005730,50005118,', 0),
(50005735, '胶带座/封箱器', 4, 50005730, 2, ',50018004,50005730,50005735,', 0),
(50005731, '胶水/固体胶', 1, 50005730, 2, ',50018004,50005730,50005731,', 0),
(50005503, '其它罩类/套类', 60, 50005494, 2, ',50008163,50005494,50005503,', 0),
(50005495, '遥控器套', 59, 50005494, 2, ',50008163,50005494,50005495,', 0),
(50003455, '电话套', 35, 50005494, 2, ',50008163,50005494,50003455,', 0),
(50001692, '酒瓶套', 26, 50005494, 2, ',50008163,50005494,50001692,', 0),
(50005501, '挂袋', 20, 50005494, 2, ',50008163,50005494,50005501,', 0),
(50005498, '门把手套', 18, 50005494, 2, ',50008163,50005494,50005498,', 0),
(50005496, '遥控器篮', 16, 50005494, 2, ',50008163,50005494,50005496,', 0),
(50010613, '工作站', 4, 50018222, 1, ',50018222,50010613,', 0),
(50010605, '服务器/Server', 3, 50018222, 1, ',50018222,50010605,', 0),
(110308, 'DIY兼容机', 2, 50018222, 1, ',50018222,110308,', 0),
(50018323, '一体机', 1, 50018222, 1, ',50018222,50018323,', 0),
(50008351, '台式整机', 0, 50018222, 1, ',50018222,50008351,', 0),
(50021851, 'DIY面膜工具', 52, 50009146, 2, ',50016348,50009146,50021851,', 0),
(50021852, '喷瓶/面霜分装瓶', 53, 50009146, 2, ',50016348,50009146,50021852,', 0),
(50007167, '洗漱包', 38, 50009146, 2, ',50016348,50009146,50007167,', 0),
(50005138, '剃须刀/刀片/刀架', 37, 50009146, 2, ',50016348,50009146,50005138,', 0),
(50021304, '洗脸刷/化妆刷', 36, 50009146, 2, ',50016348,50009146,50021304,', 0),
(50003818, '沐浴球/浴擦/浴刷', 29, 50009146, 2, ',50016348,50009146,50003818,', 0),
(50022426, '盘发器', 14, 50009146, 2, ',50016348,50009146,50022426,', 0),
(50006989, '束发带', 13, 50009146, 2, ',50016348,50009146,50006989,', 0),
(50003450, '干发帽', 12, 50009146, 2, ',50016348,50009146,50003450,', 0),
(213201, '浴帽', 9, 50009146, 2, ',50016348,50009146,213201,', 0),
(50009040, '布面料', 2, 50009033, 2, ',50010404,50009033,50009040,', 0),
(50009039, '毛线', 1, 50009033, 2, ',50010404,50009033,50009039,', 0),
(50018807, '糖果/泡芙/奶酪/肉肠/零食等', 83, 35, 1, ',35,50018807,', 0),
(50018808, '牛初乳/维生素/婴幼儿营养品', 81, 35, 1, ',35,50018808,', 1),
(50018801, '果泥/米粉/婴幼儿辅食', 80, 35, 1, ',35,50018801,', 1),
(50018596, '酱油/拌饭料/婴幼儿调味品', 77, 35, 1, ',35,50018596,', 0),
(50014813, '其它', 76, 35, 1, ',35,50014813,', 0),
(50016094, '羊奶粉/抗过敏/特殊配方奶粉', 71, 35, 1, ',35,50016094,', 1),
(211104, '婴幼儿奶粉', 5, 35, 1, ',35,211104,', 0),
(50011257, '育儿/儿童教育音像', 12, 34, 1, ',34,50011257,', 0),
(3412, '其它', 11, 34, 1, ',34,3412,', 0),
(50005273, '戏曲综艺', 9, 34, 1, ',34,50005273,', 0),
(50005272, '生活百科', 7, 34, 1, ',34,50005272,', 0),
(50003679, '动画碟', 6, 34, 1, ',34,50003679,', 0),
(50005271, '成人教育音像', 5, 34, 1, ',34,50005271,', 0),
(50003291, '电视剧', 3, 34, 1, ',34,50003291,', 0),
(50000201, '电影', 2, 34, 1, ',34,50000201,', 0),
(3415, '音乐CD/DVD', 1, 34, 1, ',34,3415,', 0),
(50050280, '心理学', 90, 33, 1, ',33,50050280,', 1),
(50026342, '网络原创', 89, 33, 1, ',33,50026342,', 1),
(50013002, '人文社科', 88, 33, 1, ',33,50013002,', 0),
(50004849, '育儿书籍', 86, 33, 1, ',33,50004849,', 1),
(3314, '儿童读物/教辅', 85, 33, 1, ',33,3314,', 1),
(50010689, '低于5元专区', 80, 33, 1, ',33,50010689,', 1),
(3338, '哲学和宗教', 51, 33, 1, ',33,3338,', 1),
(50000054, '艺术', 49, 33, 1, ',33,50000054,', 1),
(3332, '工具书/百科全书', 46, 33, 1, ',33,3332,', 1),
(50004743, '保健/心理类书籍', 44, 33, 1, ',33,50004743,', 1),
(50001378, '报刊订阅', 31, 33, 1, ',33,50001378,', 1),
(50000141, '文学', 30, 33, 1, ',33,50000141,', 1),
(3334, '体育运动', 29, 33, 1, ',33,3334,', 1),
(50000177, '自然科学', 26, 33, 1, ',33,50000177,', 1),
(50001965, '漫画/动漫小说', 25, 33, 1, ',33,50001965,', 1),
(50000049, '自我实现/励志', 24, 33, 1, ',33,50000049,', 1),
(50000063, '管理', 22, 33, 1, ',33,50000063,', 1),
(50004806, '文化', 20, 33, 1, ',33,50004806,', 1),
(50004674, '小说', 17, 33, 1, ',33,50004674,', 1),
(50000072, '考试/教材/论文', 16, 33, 1, ',33,50000072,', 1),
(50004960, '培训课程', 14, 33, 1, ',33,50004960,', 1),
(50004707, '科普读物', 13, 33, 1, ',33,50004707,', 1),
(50004620, '社会科学', 13, 33, 1, ',33,50004620,', 1),
(50005715, '淘宝网开店书籍专区', 13, 33, 1, ',33,50005715,', 0),
(50004816, '法律', 13, 33, 1, ',33,50004816,', 1),
(50010485, '期刊杂志', 13, 33, 1, ',33,50010485,', 0),
(50004893, '政治军事', 13, 33, 1, ',33,50004893,', 1),
(50004621, '报纸', 13, 33, 1, ',33,50004621,', 1),
(50004645, '娱乐时尚', 13, 33, 1, ',33,50004645,', 1),
(50004835, '地图/地理', 13, 33, 1, ',33,50004835,', 1),
(50004767, '医学卫生', 13, 33, 1, ',33,50004767,', 1),
(50004925, '传记', 13, 33, 1, ',33,50004925,', 1),
(50011016, '二手/闲置书', 13, 33, 1, ',33,50011016,', 0),
(50004870, '国外原版书/台版、港版书', 12, 33, 1, ',33,50004870,', 1),
(50004687, '经济', 11, 33, 1, ',33,50004687,', 1),
(3331, '外语/语言文字', 10, 33, 1, ',33,3331,', 1),
(3306, '计算机/网络', 9, 33, 1, ',33,3306,', 1),
(50003112, '生活', 8, 33, 1, ',33,50003112,', 1),
(50004725, '旅游', 4, 33, 1, ',33,50004725,', 1),
(50004658, '历史', 3, 33, 1, ',33,50004658,', 1),
(50004788, '工业/农业技术', 1, 33, 1, ',33,50004788,', 1),
(50005867, '工装制服', 84, 30, 1, ',30,50005867,', 0),
(50001748, '民族服装', 83, 30, 1, ',30,50001748,', 0),
(50011130, '西服套装', 80, 30, 1, ',30,50011130,', 0),
(50011129, '西裤', 78, 30, 1, ',30,50011129,', 0),
(50010160, '西服', 77, 30, 1, ',30,50010160,', 0),
(50011167, '羽绒服', 75, 30, 1, ',30,50011167,', 0),
(50011161, '皮衣', 74, 30, 1, ',30,50011161,', 0),
(50011165, '棉衣', 73, 30, 1, ',30,50011165,', 0),
(50025883, '呢大衣', 72, 30, 1, ',30,50025883,', 0),
(50011159, '风衣', 70, 30, 1, ',30,50011159,', 0),
(50010159, '卫衣', 69, 30, 1, ',30,50010159,', 0),
(50010158, '夹克', 68, 30, 1, ',30,50010158,', 0),
(50025884, '羽绒裤', 64, 30, 1, ',30,50025884,', 0),
(50011127, '皮裤', 66, 30, 1, ',30,50011127,', 0),
(50025885, '棉裤', 63, 30, 1, ',30,50025885,', 0),
(3035, '休闲裤', 62, 30, 1, ',30,3035,', 0),
(50010167, '牛仔裤', 61, 30, 1, ',30,50010167,', 0),
(50000557, '针织衫/毛衣', 57, 30, 1, ',30,50000557,', 0),
(50011123, '衬衫', 56, 30, 1, ',30,50011123,', 0),
(50010402, 'Polo衫', 55, 30, 1, ',30,50010402,', 0),
(50000436, 'T恤', 54, 30, 1, ',30,50000436,', 0),
(50011153, '背心/马甲', 53, 30, 1, ',30,50011153,', 0),
(50023358, '宠物附属品', 33, 29, 1, ',29,50023358,', 0),
(50023357, '畜牧用品', 32, 29, 1, ',29,50023357,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50023028, '宠物爱心助养/领养', 31, 29, 1, ',29,50023028,', 0),
(217302, '其它宠物', 30, 29, 1, ',29,217302,', 1),
(50015295, '美容/寄养/配种/托运等服务', 28, 29, 1, ',29,50015295,', 1),
(50015294, '马类及其用品', 27, 29, 1, ',29,50015294,', 1),
(50008604, '鸟类及用品', 26, 29, 1, ',29,50008604,', 1),
(50008622, '爬虫/鸣虫及其用品', 25, 29, 1, ',29,50008622,', 1),
(50015292, '兔类及其用品', 24, 29, 1, ',29,50015292,', 1),
(50015293, '仓鼠类及其它小宠', 23, 29, 1, ',29,50015293,', 1),
(217312, '水族世界', 22, 29, 1, ',29,217312,', 1),
(217311, '猫/狗玩具', 21, 29, 1, ',29,217311,', 1),
(50001739, '宠物服饰及配件', 19, 29, 1, ',29,50001739,', 1),
(50015289, '猫/狗医疗用品', 16, 29, 1, ',29,50015289,', 0),
(50015288, '猫/狗保健品', 15, 29, 1, ',29,50015288,', 0),
(50023206, '猫/狗美容清洁用品', 12, 29, 1, ',29,50023206,', 1),
(50015285, '猫/狗日用品', 11, 29, 1, ',29,50015285,', 1),
(50023067, '猫零食', 8, 29, 1, ',29,50023067,', 0),
(50023066, '猫主粮', 7, 29, 1, ',29,50023066,', 0),
(50016383, '猫咪', 5, 29, 1, ',29,50016383,', 0),
(50015262, '狗零食', 3, 29, 1, ',29,50015262,', 0),
(50015380, '犬主粮', 2, 29, 1, ',29,50015380,', 0),
(217309, '狗狗', 1, 29, 1, ',29,217309,', 0),
(50012709, '酒具', 23, 28, 1, ',28,50012709,', 0),
(2909, '烟具', 22, 28, 1, ',28,2909,', 1),
(50011896, '滴眼液、护眼用品', 21, 28, 1, ',28,50011896,', 0),
(50011888, '眼镜配件、护理剂', 20, 28, 1, ',28,50011888,', 1),
(50011893, '功能眼镜', 19, 28, 1, ',28,50011893,', 1),
(50010368, '太阳眼镜', 18, 28, 1, ',28,50010368,', 0),
(50011892, '框架眼镜', 17, 28, 1, ',28,50011892,', 0),
(50011895, '眼镜片', 16, 28, 1, ',28,50011895,', 0),
(50011894, '眼镜架', 15, 28, 1, ',28,50011894,', 0),
(290601, '瑞士军刀', 13, 28, 1, ',28,290601,', 0),
(50000467, '品牌打火机/其它打火机', 12, 28, 1, ',28,50000467,', 1),
(2908, 'ZIPPO/芝宝', 9, 28, 1, ',28,2908,', 0),
(50024852, '涂料（乳胶漆）', 89, 27, 1, ',27,50024852,', 1),
(50022357, '门', 76, 27, 1, ',27,50022357,', 1),
(50022271, '地板', 75, 27, 1, ',27,50022271,', 1),
(50022270, '瓷砖', 74, 27, 1, ',27,50022270,', 1),
(50022263, '楼梯', 73, 27, 1, ',27,50022263,', 1),
(50021794, '智能家居系统', 72, 27, 1, ',27,50021794,', 1),
(50020906, '地暖/暖气片/散热器', 69, 27, 1, ',27,50020906,', 1),
(50020573, '浴霸', 67, 27, 1, ',27,50020573,', 1),
(50020007, '卫浴用品', 66, 27, 1, ',27,50020007,', 1),
(50019835, '集成吊顶', 62, 27, 1, ',27,50019835,', 1),
(50008321, '其它', 38, 27, 1, ',27,50008321,', 0),
(50008725, '二手/闲置专区', 37, 27, 1, ',27,50008725,', 1),
(50008696, '配件专区', 35, 27, 1, ',27,50008696,', 1),
(2159, '环保/除味/保养', 29, 27, 1, ',27,2159,', 1),
(50013322, '墙纸', 15, 27, 1, ',27,50013322,', 1),
(50002409, '厨房', 12, 27, 1, ',27,50002409,', 1),
(50020966, '晾衣架/晾衣杆', 11, 27, 1, ',27,50020966,', 1),
(50013474, '热水器', 8, 27, 1, ',27,50013474,', 1),
(50013222, '油漆', 7, 27, 1, ',27,50013222,', 1),
(50013217, '光源', 5, 27, 1, ',27,50013217,', 1),
(50019935, '灯具灯饰', 4, 27, 1, ',27,50019935,', 1),
(50023950, '实体服务', 40, 26, 1, ',26,50023950,', 1),
(2618, '出租/培训/其它', 38, 26, 1, ',26,2618,', 1),
(50014648, '摩托车/骑士装备', 14, 26, 1, ',26,50014648,', 1),
(50018772, '车用清洗用品/清洗工具', 10, 26, 1, ',26,50018772,', 1),
(50014479, '汽车美容/保养/维修', 9, 26, 1, ',26,50014479,', 1),
(50018720, '汽车GPS导航仪及配件', 7, 26, 1, ',26,50018720,', 1),
(50014482, '汽车影音/车用电子/电器', 6, 26, 1, ',26,50014482,', 1),
(50018708, '汽车零配件', 4, 26, 1, ',26,50018708,', 1),
(50014481, '汽车外饰品/加装装潢/防护', 3, 26, 1, ',26,50014481,', 1),
(50014480, '汽车用品/内饰品', 2, 26, 1, ',26,50014480,', 1),
(50023509, '科学探索类玩具', 113, 25, 1, ',25,50023509,', 1),
(50019003, '其他玩具', 90, 25, 1, ',25,50019003,', 0),
(50000802, '儿童玩具其他', 89, 25, 1, ',25,50000802,', 0),
(50023507, '母婴线下服务', 88, 25, 1, ',25,50023507,', 1),
(50024060, '油动电动模型', 86, 25, 1, ',25,50024060,', 1),
(50024050, '电子/发光/充气/整蛊玩具', 85, 25, 1, ',25,50024050,', 1),
(50024048, '幼儿响铃/布书手偶/爬行健身', 84, 25, 1, ',25,50024048,', 1),
(50023508, '游乐/教学设备/大型设施', 79, 25, 1, ',25,50023508,', 1),
(50015127, '学习/绘画文具', 79, 25, 1, ',25,50015127,', 1),
(50023504, '积木/拆装/串珠/拼图/配对玩具', 76, 25, 1, ',25,50023504,', 1),
(50023502, '彩泥/手工制作/仿真/过家家玩具', 74, 25, 1, ',25,50023502,', 1),
(50007116, '电动/遥控/惯性/发条玩具', 71, 25, 1, ',25,50007116,', 1),
(50023498, '解锁/迷宫/魔方/悠悠球', 69, 25, 1, ',25,50023498,', 1),
(50008528, '棋牌/桌面游戏', 59, 25, 1, ',25,50008528,', 1),
(50000813, '宝宝纪念品/个性产品', 54, 25, 1, ',25,50000813,', 1),
(50015994, '聚会/魔术/cosplay用具', 52, 25, 1, ',25,50015994,', 1),
(50012404, '儿童包/背包/箱包', 52, 25, 1, ',25,50012404,', 1),
(50015988, '网游周边', 51, 25, 1, ',25,50015988,', 0),
(50003682, '卡通/动漫/游戏周边', 28, 25, 1, ',25,50003682,', 0),
(50016058, '高达/BJD/手办/机器人', 26, 25, 1, ',25,50016058,', 1),
(50008737, '玩具模型零件/工具/耗材/辅件', 25, 25, 1, ',25,50008737,', 1),
(50012455, '游泳池/泳衣/戏水玩具', 19, 25, 1, ',25,50012455,', 1),
(2512, '户外运动/休闲/传统玩具', 17, 25, 1, ',25,2512,', 1),
(50005963, '学习桌椅/儿童家具', 15, 25, 1, ',25,50005963,', 1),
(50008876, '早教/音乐/智能玩具', 14, 25, 1, ',25,50008876,', 1),
(50013198, '童车/儿童轮滑', 12, 25, 1, ',25,50013198,', 1),
(50024128, '静态模型', 7, 25, 1, ',25,50024128,', 1),
(50012770, '娃娃/配件', 2, 25, 1, ',25,50012770,', 0),
(50024158, '玉器', 40, 23, 1, ',23,50024158,', 1),
(50011975, '毛绒布艺类玩具', 1, 25, 1, ',25,50011975,', 0),
(50019306, '收藏知识图书/目录/报刊2', 39, 23, 1, ',23,50019306,', 0),
(50019296, '标牌章', 38, 23, 1, ',23,50019296,', 0),
(50019293, '宗教收藏品', 37, 23, 1, ',23,50019293,', 0),
(50019292, '当代仿古工艺品', 36, 23, 1, ',23,50019292,', 0),
(50019289, '文房四宝', 35, 23, 1, ',23,50019289,', 0),
(50019288, '文革时期收藏品', 34, 23, 1, ',23,50019288,', 0),
(2311, '其它收藏品', 33, 23, 1, ',23,2311,', 0),
(50005060, '收藏品保养/鉴定工具', 32, 23, 1, ',23,50005060,', 1),
(50001933, '可乐系列收藏(作废）', 30, 23, 1, ',23,50001933,', 0),
(50008583, '西洋收藏品', 25, 23, 1, ',23,50008583,', 0),
(50001931, '趣味收藏', 24, 23, 1, ',23,50001931,', 1),
(2903, '明星纪念品', 24, 23, 1, ',23,2903,', 0),
(50008719, '礼品类收藏品', 22, 23, 1, ',23,50008719,', 1),
(2316, '票证', 21, 23, 1, ',23,2316,', 0),
(2303, '磁卡/卡片', 19, 23, 1, ',23,2303,', 1),
(230202, '连环画', 18, 23, 1, ',23,230202,', 0),
(2306, '奇石/观赏石/矿物晶体', 17, 23, 1, ',23,2306,', 0),
(2305, '金石篆刻', 16, 23, 1, ',23,2305,', 0),
(50010104, '现当代艺术品', 14, 23, 1, ',23,50010104,', 1),
(50003583, '现代紫砂艺术', 13, 23, 1, ',23,50003583,', 0),
(50012880, '中国书画', 10, 23, 1, ',23,50012880,', 1),
(2317, '古董钟表', 9, 23, 1, ',23,2317,', 0),
(2304, '古董木艺', 8, 23, 1, ',23,2304,', 0),
(2301, '古玩杂项', 7, 23, 1, ',23,2301,', 1),
(50019262, '古瓷片', 6, 23, 1, ',23,50019262,', 0),
(230101, '古瓷器', 5, 23, 1, ',23,230101,', 0),
(2309, '邮品', 2, 23, 1, ',23,2309,', 1),
(2310, '钱币', 1, 23, 1, ',23,2310,', 1),
(50025839, '香薰用品', 118, 21, 1, ',21,50025839,', 1),
(50025838, '驱虫用品', 117, 21, 1, ',21,50025838,', 1),
(50023068, '美体/减肥/塑型/增高用具', 116, 21, 1, ',21,50023068,', 1),
(50006528, '鞋用品', 56, 21, 1, ',21,50006528,', 1),
(50012514, '防护用品', 55, 21, 1, ',21,50012514,', 1),
(50016434, '创意礼品', 54, 21, 1, ',21,50016434,', 1),
(50003948, '竹炭包', 53, 21, 1, ',21,50003948,', 1),
(50008275, '钟', 52, 21, 1, ',21,50008275,', 1),
(50012512, '保暖贴/怀炉/保暖用品', 51, 21, 1, ',21,50012512,', 1),
(50010464, '扇/迷你风扇/配件/冰垫/冰贴', 50, 21, 1, ',21,50010464,', 1),
(50010099, '伞/雨具/防雨/防潮', 49, 21, 1, ',21,50010099,', 1),
(50009206, '家用五金工具', 41, 21, 1, ',21,50009206,', 1),
(2801, '节日/派对庆典用品', 40, 21, 1, ',21,2801,', 1),
(50026577, '圣诞袜', 0, 21, 1, ',21,50026577,', 0),
(50025710, 'PSV专用配件', 26, 20, 1, ',20,50025710,', 1),
(50018230, '任天堂掌机配件', 25, 20, 1, ',20,50018230,', 1),
(50018225, '任天堂NGC/FC/N64/SFC 专用配件', 24, 20, 1, ',20,50018225,', 1),
(50018224, '世嘉 DC/MD/SS/SEGA 专用配件', 22, 20, 1, ',20,50018224,', 1),
(50018082, 'XBOX专用配件', 21, 20, 1, ',20,50018082,', 1),
(50012163, 'NDSI/NDSL专用配件', 17, 20, 1, ',20,50012163,', 1),
(50012162, 'PS2/PS3专用配件（包含PS1)', 16, 20, 1, ',20,50012162,', 1),
(50012161, 'WII专用配件/周边', 15, 20, 1, ',20,50012161,', 1),
(50012080, '摇杆', 13, 20, 1, ',20,50012080,', 0),
(50012160, 'PSP专用配件', 14, 20, 1, ',20,50012160,', 1),
(50012079, '方向盘', 12, 20, 1, ',20,50012079,', 0),
(50012834, '游戏软件', 5, 20, 1, ',20,50012834,', 1),
(50012068, '游戏手柄', 4, 20, 1, ',20,50012068,', 0),
(50017906, '家用游戏机/PS3/Wii/XBOX', 3, 20, 1, ',20,50017906,', 0),
(50017905, '游戏掌机/PSP/NDSL', 2, 20, 1, ',20,50017905,', 0),
(50008906, '唐装/民族服装/舞台服装', 97, 16, 1, ',16,50008906,', 1),
(50011404, '婚纱/旗袍/礼服', 96, 16, 1, ',16,50011404,', 1),
(1624, '职业套装/学生校服/工作制服', 95, 16, 1, ',16,1624,', 1),
(1629, '大码女装', 94, 16, 1, ',16,1629,', 0),
(50000852, '中老年女装', 93, 16, 1, ',16,50000852,', 0),
(50008905, '皮草', 28, 16, 1, ',16,50008905,', 0),
(50008904, '皮衣', 27, 16, 1, ',16,50008904,', 0),
(50008899, '羽绒服', 26, 16, 1, ',16,50008899,', 0),
(50013194, '毛呢外套', 24, 16, 1, ',16,50013194,', 0),
(50008900, '棉衣/棉服', 25, 16, 1, ',16,50008900,', 0),
(50008901, '风衣', 22, 16, 1, ',16,50008901,', 0),
(162103, '毛衣', 20, 16, 1, ',16,162103,', 0),
(50008898, '卫衣/绒衫', 16, 16, 1, ',16,50008898,', 0),
(50008897, '西装', 15, 16, 1, ',16,50008897,', 0),
(50011277, '短外套', 14, 16, 1, ',16,50011277,', 0),
(50000697, '毛针织衫', 13, 16, 1, ',16,50000697,', 0),
(162116, '蕾丝衫/雪纺衫', 12, 16, 1, ',16,162116,', 0),
(50013196, '马夹', 11, 16, 1, ',16,50013196,', 0),
(162105, '小背心/小吊带', 10, 16, 1, ',16,162105,', 0),
(1623, '半身裙', 9, 16, 1, ',16,1623,', 0),
(162205, '牛仔裤', 8, 16, 1, ',16,162205,', 0),
(1622, '裤子', 7, 16, 1, ',16,1622,', 1),
(162104, '衬衫', 6, 16, 1, ',16,162104,', 0),
(50000671, 'T恤', 5, 16, 1, ',16,50000671,', 0),
(50010850, '连衣裙', 4, 16, 1, ',16,50010850,', 0),
(50003793, 'LOMO', 8, 14, 1, ',14,50003793,', 0),
(50003770, '胶卷相机', 6, 14, 1, ',14,50003770,', 1),
(50021422, '单电微单', 5, 14, 1, ',14,50021422,', 0),
(140116, '单反镜头', 4, 14, 1, ',14,140116,', 0),
(1402, '数码摄像机', 3, 14, 1, ',14,1402,', 0),
(50003773, '专业数码单反', 2, 14, 1, ',14,50003773,', 0),
(1403, '普通数码相机', 1, 14, 1, ',14,1403,', 0),
(50019041, '绘图板配件', 45, 11, 1, ',11,50019041,', 0),
(50013014, '网络/高清播放器', 43, 11, 1, ',11,50013014,', 0),
(50003850, '其它卡类', 40, 11, 1, ',11,50003850,', 0),
(50003213, '硬盘盒', 36, 11, 1, ',11,50003213,', 0),
(110216, '电视卡/盒', 31, 11, 1, ',11,110216,', 0),
(110511, '手写输入/绘图板', 26, 11, 1, ',11,110511,', 0),
(50002415, '键鼠套装', 25, 11, 1, ',11,50002415,', 0),
(110508, '摄像头', 21, 11, 1, ',11,110508,', 0),
(50001810, '多媒体音箱', 16, 11, 1, ',11,50001810,', 0),
(50008759, '组装液晶显示器', 15, 11, 1, ',11,50008759,', 0),
(50003321, '电脑周边', 15, 11, 1, ',11,50003321,', 1),
(110205, '声卡', 14, 11, 1, ',11,110205,', 0),
(110212, '光驱/刻录/DVD', 13, 11, 1, ',11,110212,', 0),
(110215, '散热设备', 12, 11, 1, ',11,110215,', 0),
(50003848, '台机电源', 11, 11, 1, ',11,50003848,', 0),
(110206, '显卡', 9, 11, 1, ',11,110206,', 0),
(110211, '机箱', 10, 11, 1, ',11,110211,', 0),
(110201, '主板', 8, 11, 1, ',11,110201,', 0),
(50013151, '固态硬盘', 7, 11, 1, ',11,50013151,', 0),
(110207, '硬盘', 6, 11, 1, ',11,110207,', 0),
(110202, '内存', 5, 11, 1, ',11,110202,', 0),
(110203, 'CPU', 4, 11, 1, ',11,110203,', 0),
(110502, '品牌液晶显示器', 3, 11, 1, ',11,110502,', 0),
(110210, '键盘', 2, 11, 1, ',11,110210,', 0),
(50012307, '有线鼠标', 1, 11, 1, ',11,50012307,', 0),
(50012320, '无线鼠标', 0, 11, 1, ',11,50012320,', 0),
(20, '电玩/配件/游戏/攻略', 34, 0, 0, ',20,', 1),
(50019038, '沐浴按摩用品', 47, 50009146, 2, ',50016348,50009146,50019038,', 0),
(50025385, '手机', 9, 50023878, 1, ',50023878,50025385,', 1),
(50019039, '面扑/粉扑', 48, 50009146, 2, ',50016348,50009146,50019039,', 0),
(2813, '成人用品/避孕/计生用品', 196, 0, 0, ',2813,', 1),
(50006861, '搓脚板/洗脚刷/磨脚石', 45, 50009146, 2, ',50016348,50009146,50006861,', 0),
(50009201, '梳子/便携用镜', 44, 50009146, 2, ',50016348,50009146,50009201,', 1),
(50006685, '指甲刀/指甲钳', 42, 50009146, 2, ',50016348,50009146,50006685,', 1),
(50007005, '耳勺', 41, 50009146, 2, ',50016348,50009146,50007005,', 0),
(50025004, '个性定制/设计服务/DIY', 322, 0, 0, ',50025004,', 1),
(50026800, '保健品/膳食营养补充剂', 348, 0, 0, ',50026800,', 1),
(50050359, '水产肉类/新鲜蔬果/熟食', 350, 0, 0, ',50050359,', 1),
(50022126, '水族剪纸', 1, 50021971, 3, ',50020857,50021045,50021971,50022126,', 0),
(50022127, '水族背扇', 2, 50021971, 3, ',50020857,50021045,50021971,50022127,', 0),
(50022128, '水族围腰', 3, 50021971, 3, ',50020857,50021045,50021971,50022128,', 0),
(50022130, '东巴浮雕', 0, 50021973, 3, ',50020857,50021045,50021973,50022130,', 0),
(50022131, '纳西太阳鼓', 1, 50021973, 3, ',50020857,50021045,50021973,50022131,', 0),
(50022132, '转经筒', 2, 50021973, 3, ',50020857,50021045,50021973,50022132,', 0),
(50022133, '纳西东巴烟袋', 3, 50021973, 3, ',50020857,50021045,50021973,50022133,', 0),
(50022134, '景颇银泡', 0, 50021974, 3, ',50020857,50021045,50021974,50022134,', 0),
(50022135, '景颇族长刀', 1, 50021974, 3, ',50020857,50021045,50021974,50022135,', 0),
(50022136, '景颇族挎包', 2, 50021974, 3, ',50020857,50021045,50021974,50022136,', 0),
(50022137, '景颇族工艺美术', 3, 50021974, 3, ',50020857,50021045,50021974,50022137,', 0),
(50022138, '柯尔克孜帏幔', 0, 50021975, 3, ',50020857,50021045,50021975,50022138,', 0),
(50022139, '约尔麦克(毛线编)', 1, 50021975, 3, ',50020857,50021045,50021975,50022139,', 0),
(50022140, '土族盘绣', 0, 50021976, 3, ',50020857,50021045,50021976,50022140,', 0),
(50022141, '嘛呢石刻', 1, 50021976, 3, ',50020857,50021045,50021976,50022141,', 0),
(50022142, '土族刺绣', 2, 50021976, 3, ',50020857,50021045,50021976,50022142,', 0),
(50022143, '达斡尔族纸偶', 0, 50021977, 3, ',50020857,50021045,50021977,50022143,', 0),
(50022144, '达斡尔族桦树皮工艺', 1, 50021977, 3, ',50020857,50021045,50021977,50022144,', 0),
(50022145, '达斡尔族骨刻', 2, 50021977, 3, ',50020857,50021045,50021977,50022145,', 0),
(50022148, '土家族织锦', 0, 50021980, 3, ',50020857,50021045,50021980,50022148,', 0),
(50022149, '土家人头饰', 1, 50021980, 3, ',50020857,50021045,50021980,50022149,', 0),
(50022150, '土家族绣花鞋垫', 2, 50021980, 3, ',50020857,50021045,50021980,50022150,', 0),
(50022151, '土家族刺绣', 3, 50021980, 3, ',50020857,50021045,50021980,50022151,', 0),
(50022152, '土家手工布鞋', 4, 50021980, 3, ',50020857,50021045,50021980,50022152,', 0),
(50022153, '土家龙山编织', 5, 50021980, 3, ',50020857,50021045,50021980,50022153,', 0),
(50022154, '土家族木雕傩戏面具', 6, 50021980, 3, ',50020857,50021045,50021980,50022154,', 0),
(50022155, '哈尼族刺绣', 0, 50021981, 3, ',50020857,50021045,50021981,50022155,', 0),
(50022156, '哈尼族水烟筒', 1, 50021981, 3, ',50020857,50021045,50021981,50022156,', 0),
(50022157, '哈尼族“帕阿”', 2, 50021981, 3, ',50020857,50021045,50021981,50022157,', 0),
(50022158, '哈尼族挎包', 3, 50021981, 3, ',50020857,50021045,50021981,50022158,', 0),
(50022160, '锡伯族乐器', 0, 50021983, 3, ',50020857,50021045,50021983,50022160,', 0),
(50022161, '锡伯族刺绣', 1, 50021983, 3, ',50020857,50021045,50021983,50022161,', 0),
(50022162, '基诺族太阳鼓', 0, 50021984, 3, ',50020857,50021045,50021984,50022162,', 0),
(50022163, '基诺族龙龟', 1, 50021984, 3, ',50020857,50021045,50021984,50022163,', 0),
(50022164, '基诺族砍刀布尖顶帽', 2, 50021984, 3, ',50020857,50021045,50021984,50022164,', 0),
(50022165, '基诺族刺绣孔明印', 3, 50021984, 3, ',50020857,50021045,50021984,50022165,', 0),
(50022166, '布朗族竹器编织', 0, 50021985, 3, ',50020857,50021045,50021985,50022166,', 0),
(50022167, '布朗族雕刻', 1, 50021985, 3, ',50020857,50021045,50021985,50022167,', 0),
(50022168, '布朗族刺绣', 2, 50021985, 3, ',50020857,50021045,50021985,50022168,', 0),
(50022169, '撒拉族泥笛', 0, 50021986, 3, ',50020857,50021045,50021986,50022169,', 0),
(50022170, '撒拉族刺绣', 1, 50021986, 3, ',50020857,50021045,50021986,50022170,', 0),
(50022171, '撒拉族芦苇画', 2, 50021986, 3, ',50020857,50021045,50021986,50022171,', 0),
(50022172, '撒拉族羊皮筏', 3, 50021986, 3, ',50020857,50021045,50021986,50022172,', 0),
(50022173, '云子围棋', 0, 50021988, 3, ',50020857,50021045,50021988,50022173,', 0),
(50022174, '关刀佛刀', 1, 50021988, 3, ',50020857,50021045,50021988,50022174,', 0),
(50022175, '葫芦箫', 2, 50021988, 3, ',50020857,50021045,50021988,50022175,', 0),
(50022176, '普米族漆器', 0, 50021989, 3, ',50020857,50021045,50021989,50022176,', 0),
(50022177, '普米族竹编', 1, 50021989, 3, ',50020857,50021045,50021989,50022177,', 0),
(50022178, '核桃工艺品', 2, 50021989, 3, ',50020857,50021045,50021989,50022178,', 0),
(50022179, '塔吉克族鹰笛', 0, 50021990, 3, ',50020857,50021045,50021990,50022179,', 0),
(50022180, '英吉沙小刀', 1, 50021990, 3, ',50020857,50021045,50021990,50022180,', 0),
(50022181, '花毯', 2, 50021990, 3, ',50020857,50021045,50021990,50022181,', 0),
(50022182, '马鞍', 3, 50021990, 3, ',50020857,50021045,50021990,50022182,', 0),
(50022183, '怒族瓦猫', 0, 50021991, 3, ',50020857,50021045,50021991,50022183,', 0),
(50022184, '怒族紫陶', 1, 50021991, 3, ',50020857,50021045,50021991,50022184,', 0),
(50022185, '手鼓', 0, 50021992, 3, ',50020857,50021045,50021992,50022185,', 0),
(50022186, '乌孜别克族刺绣', 1, 50021992, 3, ',50020857,50021045,50021992,50022186,', 0),
(50022187, '胡西塔尔', 2, 50021992, 3, ',50020857,50021045,50021992,50022187,', 0),
(50022188, '鸵鸟蛋雕刻', 0, 50021993, 3, ',50020857,50021045,50021993,50022188,', 0),
(50022189, '皇室蛋雕', 1, 50021993, 3, ',50020857,50021045,50021993,50022189,', 0),
(50022190, '锡制酒具', 2, 50021993, 3, ',50020857,50021045,50021993,50022190,', 0),
(50022191, '银锡烛台', 3, 50021993, 3, ',50020857,50021045,50021993,50022191,', 0),
(50022193, '核桃工艺品', 0, 50021995, 3, ',50020857,50021045,50021995,50022193,', 0),
(50022194, '德昂族竹编', 1, 50021995, 3, ',50020857,50021045,50021995,50022194,', 0),
(50022195, '押花艺术画', 2, 50021995, 3, ',50020857,50021045,50021995,50022195,', 0),
(50022196, '葫芦丝', 3, 50021995, 3, ',50020857,50021045,50021995,50022196,', 0),
(50022197, '牙雕', 4, 50021995, 3, ',50020857,50021045,50021995,50022197,', 0),
(50022198, '保安腰刀', 0, 50021996, 3, ',50020857,50021045,50021996,50022198,', 0),
(50022199, '折花刀', 1, 50021996, 3, ',50020857,50021045,50021996,50022199,', 0),
(50022200, '狐皮风雪帽', 0, 50021997, 3, ',50020857,50021045,50021997,50022200,', 0),
(50022201, '毛毡', 1, 50021997, 3, ',50020857,50021045,50021997,50022201,', 0),
(50022202, '裕固族刺绣', 2, 50021997, 3, ',50020857,50021045,50021997,50022202,', 0),
(50022203, '京族葵帽（竹笠）', 0, 50021998, 3, ',50020857,50021045,50021998,50022203,', 0),
(50022204, '京族传统刺绣女褂', 1, 50021998, 3, ',50020857,50021045,50021998,50022204,', 0),
(50022205, '塔塔尔族地毯', 0, 50021999, 3, ',50020857,50021045,50021999,50022205,', 0),
(50022206, '塔塔尔族钵', 1, 50021999, 3, ',50020857,50021045,50021999,50022206,', 0),
(50022207, '独龙毯', 0, 50022000, 3, ',50020857,50021045,50022000,50022207,', 0),
(50022208, '独龙箭包', 1, 50022000, 3, ',50020857,50021045,50022000,50022208,', 0),
(50022209, '桦树皮工艺品', 0, 50022001, 3, ',50020857,50021045,50022001,50022209,', 0),
(50022210, '兽皮工艺品', 1, 50022001, 3, ',50020857,50021045,50022001,50022210,', 0),
(50022211, '鄂伦春剪纸', 2, 50022001, 3, ',50020857,50021045,50022001,50022211,', 0),
(50022212, '布贴画', 3, 50022001, 3, ',50020857,50021045,50022001,50022212,', 0),
(50022213, '高山族巫术箱', 0, 50022002, 3, ',50020857,50021045,50022002,50022213,', 0),
(50022214, '高山族彩绘木雕渔船', 1, 50022002, 3, ',50020857,50021045,50022002,50022214,', 0),
(50022215, '高山族冠饰', 2, 50022002, 3, ',50020857,50021045,50022002,50022215,', 0),
(50022216, '黑乌石雕', 0, 50022003, 3, ',50020857,50021045,50022003,50022216,', 0),
(50022217, '牦牛头骨工艺品', 1, 50022003, 3, ',50020857,50021045,50022003,50022217,', 0),
(50022218, '珞巴柳叶刀', 0, 50022004, 3, ',50020857,50021045,50022004,50022218,', 0),
(50022219, '珞巴族竹编', 1, 50022004, 3, ',50020857,50021045,50022004,50022219,', 0),
(50022220, '珞巴石锅和陶器', 2, 50022004, 3, ',50020857,50021045,50022004,50022220,', 0),
(50022221, '珞巴族弓箭', 3, 50022004, 3, ',50020857,50021045,50022004,50022221,', 0),
(50022222, '赫哲族鱼皮画', 0, 50022005, 3, ',50020857,50021045,50022005,50022222,', 0),
(50022223, '赫哲族鱼骨工艺', 1, 50022005, 3, ',50020857,50021045,50022005,50022223,', 0),
(50022226, '冲气泵', 0, 50022225, 3, ',50020485,50020491,50022225,50022226,', 0),
(50022227, '压力泵', 1, 50022225, 3, ',50020485,50020491,50022225,50022227,', 0),
(50022228, '水泵', 2, 50022225, 3, ',50020485,50020491,50022225,50022228,', 0),
(50022229, '电泵', 3, 50022225, 3, ',50020485,50020491,50022225,50022229,', 0),
(50021302, '棉签/棉棒/棉包', 49, 50009146, 2, ',50016348,50009146,50021302,', 0),
(50013396, '其他类型泵', 5, 50022225, 3, ',50020485,50020491,50022225,50013396,', 0),
(50022245, '地暖发热电缆', 0, 50022244, 3, ',27,50020906,50022244,50022245,', 0),
(50022246, '地暖发热电热膜', 1, 50022244, 3, ',27,50020906,50022244,50022246,', 0),
(50022247, '冷引线', 2, 50022244, 3, ',27,50020906,50022244,50022247,', 0),
(50022248, '感温探头', 3, 50022244, 3, ',27,50020906,50022244,50022248,', 0),
(50022253, '温控器', 4, 50022244, 3, ',27,50020906,50022244,50022253,', 0),
(50022254, '铝箔隔热膜', 5, 50022244, 3, ',27,50020906,50022244,50022254,', 0),
(50022234, '温度控制器', 0, 50022249, 3, ',27,50020906,50022249,50022234,', 0),
(50022235, '地暖专用管材', 1, 50022249, 3, ',27,50020906,50022249,50022235,', 0),
(50022236, '水力分压器', 2, 50022249, 3, ',27,50020906,50022249,50022236,', 0),
(50022237, '膨胀水箱', 3, 50022249, 3, ',27,50020906,50022249,50022237,', 0),
(50022238, '地暖阀门', 4, 50022249, 3, ',27,50020906,50022249,50022238,', 0),
(50022251, '分水器', 5, 50022249, 3, ',27,50020906,50022249,50022251,', 0),
(50022252, '地暖专用循环水泵', 6, 50022249, 3, ',27,50020906,50022249,50022252,', 0),
(50022276, '腰线', 0, 50022275, 3, ',27,50022270,50022275,50022276,', 0),
(50022277, '转角', 1, 50022275, 3, ',27,50022270,50022275,50022277,', 0),
(50022278, '股线', 2, 50022275, 3, ',27,50022270,50022275,50022278,', 0),
(50022279, '花片', 3, 50022275, 3, ',27,50022270,50022275,50022279,', 0),
(50022280, '地线', 4, 50022275, 3, ',27,50022270,50022275,50022280,', 0),
(50022281, '立柱', 5, 50022275, 3, ',27,50022270,50022275,50022281,', 0),
(50022422, '防静电地板', 0, 50022291, 3, ',27,50022271,50022291,50022422,', 0),
(50022423, '漏缝地板/格栅地板', 1, 50022291, 3, ',27,50022271,50022291,50022423,', 0),
(50022424, '防火地板', 2, 50022291, 3, ',27,50022271,50022291,50022424,', 0),
(50022425, '隔音地板', 3, 50022291, 3, ',27,50022271,50022291,50022425,', 0),
(50022293, '踢脚线', 0, 50022292, 3, ',27,50022271,50022292,50022293,', 0),
(50022294, '防潮膜（地板膜）', 1, 50022292, 3, ',27,50022271,50022292,50022294,', 0),
(50022295, '地板胶垫', 2, 50022292, 3, ',27,50022271,50022292,50022295,', 0),
(50022296, '收边条', 3, 50022292, 3, ',27,50022271,50022292,50022296,', 0),
(50022297, '地板弹簧', 4, 50022292, 3, ',27,50022271,50022292,50022297,', 0),
(50022298, '樟木块', 5, 50022292, 3, ',27,50022271,50022292,50022298,', 0),
(50022364, '门扇', 0, 50022363, 3, ',27,50022357,50022363,50022364,', 0),
(50022365, '门套线', 1, 50022363, 3, ',27,50022357,50022363,50022365,', 0),
(50022366, '门挡', 2, 50022363, 3, ',27,50022357,50022363,50022366,', 0),
(50022367, '封边', 3, 50022363, 3, ',27,50022357,50022363,50022367,', 0),
(50022368, '压条', 4, 50022363, 3, ',27,50022357,50022363,50022368,', 0),
(50022369, '开门机', 5, 50022363, 3, ',27,50022357,50022363,50022369,', 0),
(50022370, '门轨', 6, 50022363, 3, ',27,50022357,50022363,50022370,', 0),
(50022381, '调羹/饭勺', 0, 50022379, 3, ',50016349,50002796,50022379,50022381,', 0),
(50022383, '江中杯', 1, 50022379, 3, ',50016349,50002796,50022379,50022383,', 0),
(50022385, '牙签筒', 2, 50022379, 3, ',50016349,50002796,50022379,50022385,', 0),
(50022501, '扩孔钻', 0, 50022500, 3, ',50020485,50020493,50022500,50022501,', 0),
(50022502, '麻花钻', 1, 50022500, 3, ',50020485,50020493,50022500,50022502,', 0),
(50022503, '冲击钻头', 2, 50022500, 3, ',50020485,50020493,50022500,50022503,', 0),
(50022504, '电锤钻头', 3, 50022500, 3, ',50020485,50020493,50022500,50022504,', 0),
(50022505, '中心钻', 4, 50022500, 3, ',50020485,50020493,50022500,50022505,', 0),
(50022506, '其他钻', 5, 50022500, 3, ',50020485,50020493,50022500,50022506,', 0),
(50022508, '手用丝锥', 0, 50022507, 3, ',50020485,50020493,50022507,50022508,', 0),
(50022509, '机用丝锥', 1, 50022507, 3, ',50020485,50020493,50022507,50022509,', 0),
(50022512, '丝锥扳手', 2, 50022507, 3, ',50020485,50020493,50022507,50022512,', 0),
(50022510, '其他丝锥', 3, 50022507, 3, ',50020485,50020493,50022507,50022510,', 0),
(50022542, '瓷器套装', 0, 50022541, 3, ',50016349,50002796,50022541,50022542,', 0),
(50022543, '家用瓷器', 1, 50022541, 3, ',50016349,50002796,50022541,50022543,', 0),
(50023034, '荷花灯/河灯', 0, 50023033, 3, ',21,2801,50023033,50023034,', 0),
(50023035, '兔子灯', 1, 50023033, 3, ',21,2801,50023033,50023035,', 0),
(50023036, '南瓜灯', 2, 50023033, 3, ',21,2801,50023033,50023036,', 0),
(50023037, '孔明灯', 3, 50023033, 3, ',21,2801,50023033,50023037,', 0),
(50023038, '其他', 5, 50023033, 3, ',21,2801,50023033,50023038,', 0),
(50023040, '胸花', 0, 50023039, 3, ',21,2801,50023039,50023040,', 0),
(50023041, '婚庆公仔', 1, 50023039, 3, ',21,2801,50023039,50023041,', 0),
(50023042, '子孙桶', 2, 50023039, 3, ',21,2801,50023039,50023042,', 0),
(50023043, '婚庆印章', 3, 50023039, 3, ',21,2801,50023039,50023043,', 0),
(50023044, '花瓣/仿真花瓣', 4, 50023039, 3, ',21,2801,50023039,50023044,', 0),
(50023045, '婚庆展台/婚庆门亭', 5, 50023039, 3, ',21,2801,50023039,50023045,', 0),
(50023046, '拱门', 6, 50023039, 3, ',21,2801,50023039,50023046,', 0),
(50023047, '婚庆绢花', 7, 50023039, 3, ',21,2801,50023039,50023047,', 0),
(50023048, '其他用品', 8, 50023039, 3, ',21,2801,50023039,50023048,', 0),
(50026085, '手腕花', 9, 50023039, 3, ',21,2801,50023039,50026085,', 0),
(50023051, '飘空气球', 1, 50023049, 3, ',21,2801,50023049,50023051,', 0),
(50018423, '气球', 19, 50023049, 3, ',21,2801,50023049,50018423,', 0),
(50001399, '文件柜', 0, 50023076, 3, ',50020611,211503,50023076,50001399,', 0),
(50015429, '更衣柜', 3, 50023076, 3, ',50020611,211503,50023076,50015429,', 0),
(50015493, '柜子配件', 4, 50023076, 3, ',50020611,211503,50023076,50015493,', 0),
(50015433, '矮柜', 4, 50023076, 3, ',50020611,211503,50023076,50015433,', 0),
(50023078, '保险柜（新增）', 14, 50023076, 3, ',50020611,211503,50023076,50023078,', 0),
(50023084, '其他柜类（新增）', 20, 50023076, 3, ',50020611,211503,50023076,50023084,', 0),
(50023142, '水草及肥料', 0, 50023141, 3, ',29,217312,50023141,50023142,', 0),
(50023143, '鱼缸/水族箱', 1, 50023141, 3, ',29,217312,50023141,50023143,', 0),
(50023144, '过滤设备', 2, 50023141, 3, ',29,217312,50023141,50023144,', 0),
(50023145, '照明器材', 3, 50023141, 3, ',29,217312,50023141,50023145,', 0),
(50023146, '潜水泵', 4, 50023141, 3, ',29,217312,50023141,50023146,', 0),
(50023147, '二氧化碳设备', 5, 50023141, 3, ',29,217312,50023141,50023147,', 0),
(50023148, '温控设备', 6, 50023141, 3, ',29,217312,50023141,50023148,', 0),
(50023149, '冲氧泵', 7, 50023141, 3, ',29,217312,50023141,50023149,', 0),
(50023150, '造景/装饰', 8, 50023141, 3, ',29,217312,50023141,50023150,', 0),
(50023151, '鱼缸清洁用具', 9, 50023141, 3, ',29,217312,50023141,50023151,', 0),
(50023152, '杀菌消毒设备', 10, 50023141, 3, ',29,217312,50023141,50023152,', 0),
(50023153, '喂食器', 11, 50023141, 3, ',29,217312,50023141,50023153,', 0),
(50023154, '定时器/自控系统', 12, 50023141, 3, ',29,217312,50023141,50023154,', 0),
(50023155, '水温计', 13, 50023141, 3, ',29,217312,50023141,50023155,', 0),
(50023156, 'pH计', 14, 50023141, 3, ',29,217312,50023141,50023156,', 0),
(50023157, '孵化器', 15, 50023141, 3, ',29,217312,50023141,50023157,', 0),
(50023158, '其它水族用具设备', 16, 50023141, 3, ',29,217312,50023141,50023158,', 0),
(50023405, '落地镜', 0, 50023404, 3, ',50016348,2132,50023404,50023405,', 0),
(50023406, '双面镜', 1, 50023404, 3, ',50016348,2132,50023404,50023406,', 0),
(50023407, '柜镜/梳妆镜', 2, 50023404, 3, ',50016348,2132,50023404,50023407,', 0),
(50023409, '浴室镜', 4, 50023404, 3, ',50016348,2132,50023404,50023409,', 0),
(50023450, '马术头盔', 0, 50023448, 3, ',50010728,50023363,50023448,50023450,', 0),
(50023460, '马裤/大恰', 1, 50023448, 3, ',50010728,50023363,50023448,50023460,', 0),
(50023461, '骑士马靴', 2, 50023448, 3, ',50010728,50023363,50023448,50023461,', 0),
(50023462, '骑士服装', 3, 50023448, 3, ',50010728,50023363,50023448,50023462,', 0),
(50023463, '马术手套', 4, 50023448, 3, ',50010728,50023363,50023448,50023463,', 0),
(50023464, '马术护腿', 5, 50023448, 3, ',50010728,50023363,50023448,50023464,', 0),
(50023465, '马术风镜', 6, 50023448, 3, ',50010728,50023363,50023448,50023465,', 0),
(50023466, '马术包/骑士包', 7, 50023448, 3, ',50010728,50023363,50023448,50023466,', 0),
(50023467, '马刺/马刺带', 8, 50023448, 3, ',50010728,50023363,50023448,50023467,', 0),
(50023468, '马鞭', 9, 50023448, 3, ',50010728,50023363,50023448,50023468,', 0),
(50023469, '马鞭架', 10, 50023448, 3, ',50010728,50023363,50023448,50023469,', 0),
(50023470, '脱鞋器', 11, 50023448, 3, ',50010728,50023363,50023448,50023470,', 0),
(50023451, '马鞍', 0, 50023449, 3, ',50010728,50023363,50023449,50023451,', 0),
(50023452, '马鞍垫', 1, 50023449, 3, ',50010728,50023363,50023449,50023452,', 0),
(50023471, '马鞍架', 2, 50023449, 3, ',50010728,50023363,50023449,50023471,', 0),
(50023472, '马鞍包/袋', 3, 50023449, 3, ',50010728,50023363,50023449,50023472,', 0),
(50023473, '马鞍护理液/鞍油', 4, 50023449, 3, ',50010728,50023363,50023449,50023473,', 0),
(50023474, '马镫', 0, 50023453, 3, ',50010728,50023363,50023453,50023474,', 0),
(50023475, '马镫带/马镫革', 1, 50023453, 3, ',50010728,50023363,50023453,50023475,', 0),
(50023476, '马蹄铁', 2, 50023453, 3, ',50010728,50023363,50023453,50023476,', 0),
(50023477, '马蹄钉', 3, 50023453, 3, ',50010728,50023363,50023453,50023477,', 0),
(50023478, '马蹄测量角尺', 4, 50023453, 3, ',50010728,50023363,50023453,50023478,', 0),
(50023479, '量马尺', 5, 50023453, 3, ',50010728,50023363,50023453,50023479,', 0),
(50023480, '水勒缰(水勒/缰绳/口衔套装)', 6, 50023453, 3, ',50010728,50023363,50023453,50023480,', 0),
(50023481, '口衔铁/马嚼/马衔', 7, 50023453, 3, ',50010728,50023363,50023453,50023481,', 0),
(50023482, '牵马/调教龙头', 8, 50023453, 3, ',50010728,50023363,50023453,50023482,', 0),
(50023483, '马缰绳', 9, 50023453, 3, ',50010728,50023363,50023453,50023483,', 0),
(50023484, '肚带/肚带扣', 10, 50023453, 3, ',50010728,50023363,50023453,50023484,', 0),
(50023485, '蹬带', 11, 50023453, 3, ',50010728,50023363,50023453,50023485,', 0),
(50023486, '前胸带/低头革', 12, 50023453, 3, ',50010728,50023363,50023453,50023486,', 0),
(50023487, '马衣', 13, 50023453, 3, ',50010728,50023363,50023453,50023487,', 0),
(50023488, '马眼罩/耳罩/嘴套/护尾', 14, 50023453, 3, ',50010728,50023363,50023453,50023488,', 0),
(50023489, '马绑腿/马护腿/马护蹄', 15, 50023453, 3, ',50010728,50023363,50023453,50023489,', 0),
(50023490, '号码布', 16, 50023453, 3, ',50010728,50023363,50023453,50023490,', 0),
(50023491, '马球', 0, 50023454, 3, ',50010728,50023363,50023454,50023491,', 0),
(50023492, '马球帽', 1, 50023454, 3, ',50010728,50023363,50023454,50023492,', 0),
(50023493, '马球杆', 2, 50023454, 3, ',50010728,50023363,50023454,50023493,', 0),
(50023494, '马球靴', 3, 50023454, 3, ',50010728,50023363,50023454,50023494,', 0),
(50023495, '马球护膝', 4, 50023454, 3, ',50010728,50023363,50023454,50023495,', 0),
(50025605, '佛珠项链', 0, 50025604, 3, ',50020857,50021048,50025604,50025605,', 0),
(50025606, '佛珠挂链', 1, 50025604, 3, ',50020857,50021048,50025604,50025606,', 0),
(50025607, '佛珠手链', 2, 50025604, 3, ',50020857,50021048,50025604,50025607,', 0),
(50025615, '3D电视眼镜', 0, 50025785, 3, ',50022703,50022734,50025785,50025615,', 0),
(50009808, '电视机架', 4, 50025785, 3, ',50022703,50022734,50025785,50009808,', 0),
(50026077, '电视机遥控器', 6, 50025785, 3, ',50022703,50022734,50025785,50026077,', 0),
(50025819, '其他电视配件', 7, 50025785, 3, ',50022703,50022734,50025785,50025819,', 0),
(50025796, '扫把', 0, 50025792, 3, ',50016348,50003949,50025792,50025796,', 0),
(50025797, '扫把头', 1, 50025792, 3, ',50016348,50003949,50025792,50025797,', 0),
(50025823, '条状拖把头', 0, 50025822, 3, ',50016348,50003949,50025822,50025823,', 0),
(50025824, '胶棉拖把头', 1, 50025822, 3, ',50016348,50003949,50025822,50025824,', 0),
(50025825, '尘推头', 2, 50025822, 3, ',50016348,50003949,50025822,50025825,', 0),
(50025826, '拖把桶', 3, 50025822, 3, ',50016348,50003949,50025822,50025826,', 0),
(50025827, '其他配件', 4, 50025822, 3, ',50016348,50003949,50025822,50025827,', 0),
(50050294, '融资', 0, 50050293, 3, ',33,50004687,50050293,50050294,', 0),
(50050295, '个人理财', 1, 50050293, 3, ',33,50004687,50050293,50050295,', 0),
(50050296, '证券', 2, 50050293, 3, ',33,50004687,50050293,50050296,', 0),
(50050297, '股票', 3, 50050293, 3, ',33,50004687,50050293,50050297,', 0),
(50050298, '货币银行学', 4, 50050293, 3, ',33,50004687,50050293,50050298,', 0),
(50050299, '金融理论', 5, 50050293, 3, ',33,50004687,50050293,50050299,', 0),
(50050300, '保险', 6, 50050293, 3, ',33,50004687,50050293,50050300,', 0),
(50050301, '企业并购', 7, 50050293, 3, ',33,50004687,50050293,50050301,', 0),
(50050302, '国际金融', 8, 50050293, 3, ',33,50004687,50050293,50050302,', 0),
(50050303, '期货', 9, 50050293, 3, ',33,50004687,50050293,50050303,', 0),
(50050304, '信贷', 10, 50050293, 3, ',33,50004687,50050293,50050304,', 0),
(50050305, '基金', 11, 50050293, 3, ',33,50004687,50050293,50050305,', 0),
(50050323, '小学教材', 0, 50050322, 3, ',33,50000072,50050322,50050323,', 0),
(50050324, '大学教材', 1, 50050322, 3, ',33,50000072,50050322,50050324,', 0),
(50050325, '中学教材', 2, 50050322, 3, ',33,50000072,50050322,50050325,', 0),
(50050329, '微电子', 0, 50050328, 3, ',33,50004788,50050328,50050329,', 0),
(50050330, '真空电子技术', 1, 50050328, 3, ',33,50004788,50050328,50050330,', 0),
(50050331, '电子对抗', 2, 50050328, 3, ',33,50004788,50050328,50050331,', 0),
(50050332, '无线电导航', 3, 50050328, 3, ',33,50004788,50050328,50050332,', 0),
(50050333, '光电子技术', 4, 50050328, 3, ',33,50004788,50050328,50050333,', 0),
(50050334, '电子元件', 5, 50050328, 3, ',33,50004788,50050328,50050334,', 0),
(50050335, '雷达', 6, 50050328, 3, ',33,50004788,50050328,50050335,', 0),
(50050336, '电信测量', 7, 50050328, 3, ',33,50004788,50050328,50050336,', 0),
(50050337, '电视', 8, 50050328, 3, ',33,50004788,50050328,50050337,', 0),
(50050338, '半导体', 9, 50050328, 3, ',33,50004788,50050328,50050338,', 0),
(50050339, '广播', 10, 50050328, 3, ',33,50004788,50050328,50050339,', 0),
(50050340, '基本电子电路', 11, 50050328, 3, ',33,50004788,50050328,50050340,', 0),
(50050341, '无线电设备', 12, 50050328, 3, ',33,50004788,50050328,50050341,', 0),
(50050342, '通信', 13, 50050328, 3, ',33,50004788,50050328,50050342,', 0),
(50050343, '无线通信', 14, 50050328, 3, ',33,50004788,50050328,50050343,', 0),
(50009210, '照明电筒', 5, 50009206, 2, ',21,50009206,50009210,', 0),
(50013983, '剪刀/美发剪/园艺剪', 40, 50009206, 2, ',21,50009206,50013983,', 1),
(350706, '缝纫机/针织机', 41, 50009206, 2, ',21,50009206,350706,', 0),
(50006279, '家用梯', 64, 50009206, 2, ',21,50009206,50006279,', 0),
(50018432, '缝纫配件', 65, 50009206, 2, ',21,50009206,50018432,', 0),
(50018433, '绣花机', 66, 50009206, 2, ',21,50009206,50018433,', 0),
(50009340, '新娘手捧花', 1, 50009339, 2, ',50007216,50009339,50009340,', 0),
(50009342, '婚车鲜花', 2, 50009339, 2, ',50007216,50009339,50009342,', 0),
(50009341, '鲜花拱门', 3, 50009339, 2, ',50007216,50009339,50009341,', 0),
(50009343, '婚庆花篮', 4, 50009339, 2, ',50007216,50009339,50009343,', 0),
(50009344, '其它', 5, 50009339, 2, ',50007216,50009339,50009344,', 0),
(50011093, '胸花', 6, 50009339, 2, ',50007216,50009339,50011093,', 0),
(50015284, '玫瑰花瓣', 7, 50009339, 2, ',50007216,50009339,50015284,', 0),
(50009529, '餐具', 3, 50009521, 2, ',50014812,50009521,50009529,', 0),
(50009524, '水杯/水壶', 4, 50009521, 2, ',50014812,50009521,50009524,', 0),
(50009532, '喂药器', 6, 50009521, 2, ',50014812,50009521,50009532,', 0),
(50012841, '保温奶瓶', 22, 50009521, 2, ',50014812,50009521,50012841,', 0),
(50008710, '奶瓶保温桶/保温袋', 23, 50009521, 2, ',50014812,50009521,50008710,', 0),
(50008706, '奶瓶保温箱/包', 24, 50009521, 2, ',50014812,50009521,50008706,', 0),
(50009530, '吸管', 26, 50009521, 2, ',50014812,50009521,50009530,', 0),
(50009531, '食物研磨器', 28, 50009521, 2, ',50014812,50009521,50009531,', 0),
(50009526, '奶粉储存盒', 30, 50009521, 2, ',50014812,50009521,50009526,', 0),
(50014230, '奶瓶储存盒', 31, 50009521, 2, ',50014812,50009521,50014230,', 0),
(50014231, '奶嘴储存盒', 32, 50009521, 2, ',50014812,50009521,50014231,', 0),
(50009533, '其它喂哺用品', 37, 50009521, 2, ',50014812,50009521,50009533,', 0),
(50016455, '奶瓶刷/夹/盖等辅件', 38, 50009521, 2, ',50014812,50009521,50016455,', 1),
(50018624, '魔术杯软嘴', 40, 50009521, 2, ',50014812,50009521,50018624,', 0),
(50009557, '鱿鱼系列', 1, 50009556, 2, ',50002766,50009556,50009557,', 0),
(50009558, '鱼系列', 2, 50009556, 2, ',50002766,50009556,50009558,', 0),
(50009559, '虾系列', 3, 50009556, 2, ',50002766,50009556,50009559,', 0),
(50009560, '蟹系列', 4, 50009556, 2, ',50002766,50009556,50009560,', 0),
(50009561, '贝系列', 5, 50009556, 2, ',50002766,50009556,50009561,', 0),
(50009562, '海苔系列', 6, 50009556, 2, ',50002766,50009556,50009562,', 0),
(50013054, '海参即食', 7, 50009556, 2, ',50002766,50009556,50013054,', 0),
(50013057, '海带/裙带菜', 8, 50009556, 2, ',50002766,50009556,50013057,', 0),
(50009563, '其他系列', 9, 50009556, 2, ',50002766,50009556,50009563,', 0),
(50009579, '二件套', 1, 50009578, 2, ',50010404,50009578,50009579,', 0),
(50009580, '三件套', 2, 50009578, 2, ',50010404,50009578,50009580,', 0),
(50009581, '多件套', 3, 50009578, 2, ',50010404,50009578,50009581,', 0),
(50009878, '料酒', 0, 50009821, 2, ',50016422,50009821,50009878,', 0),
(50009856, '酱油', 0, 50009821, 2, ',50016422,50009821,50009856,', 0),
(50009879, '食糖', 1, 50009821, 2, ',50016422,50009821,50009879,', 0),
(50009828, '醋制品', 2, 50009821, 2, ',50016422,50009821,50009828,', 0),
(50025674, '调味料', 3, 50009821, 2, ',50016422,50009821,50025674,', 1),
(50025222, '调味酱', 4, 50009821, 2, ',50016422,50009821,50025222,', 1),
(50009830, '鸡精/味精', 4, 50009821, 2, ',50016422,50009821,50009830,', 0),
(50025675, '调味汁/调味油', 5, 50009821, 2, ',50016422,50009821,50025675,', 0),
(50010891, '豆腐乳', 5, 50009821, 2, ',50016422,50009821,50010891,', 0),
(50009824, '寿司料理', 6, 50009821, 2, ',50016422,50009821,50009824,', 0),
(50009835, '其它调味品', 7, 50009821, 2, ',50016422,50009821,50009835,', 0),
(50017138, '果酱', 10, 50009821, 2, ',50016422,50009821,50017138,', 0),
(50025697, '奶酪/黄油', 12, 50009821, 2, ',50016422,50009821,50025697,', 0),
(50009839, '面粉/食用粉', 3, 50009837, 2, ',50016422,50009837,50009839,', 0),
(50009841, '玉米', 5, 50009837, 2, ',50016422,50009837,50009841,', 0),
(50009843, '其它粮食', 13, 50009837, 2, ',50016422,50009837,50009843,', 0),
(50050578, '米类', 42, 50009837, 2, ',50016422,50009837,50050578,', 1),
(50050579, '杂粮组合', 43, 50009837, 2, ',50016422,50009837,50050579,', 0),
(50050580, '豆类', 44, 50009837, 2, ',50016422,50009837,50050580,', 1),
(50009858, '藕粉', 1, 50009857, 2, ',50026316,50009857,50009858,', 0),
(50009859, '冲饮麦片', 2, 50009857, 2, ',50026316,50009857,50009859,', 0),
(50009860, '芝麻糊', 3, 50009857, 2, ',50026316,50009857,50009860,', 0),
(50009861, '冲饮果汁', 4, 50009857, 2, ',50026316,50009857,50009861,', 0),
(50010422, '中老年/成人奶粉', 7, 50009857, 2, ',50026316,50009857,50010422,', 0),
(50008910, '蜂蜜果味茶', 7, 50009857, 2, ',50026316,50009857,50008910,', 0),
(50009862, '其它冲饮品', 10, 50009857, 2, ',50026316,50009857,50009862,', 0),
(50011942, '豆奶', 11, 50009857, 2, ',50026316,50009857,50011942,', 0),
(50011943, '豆浆', 12, 50009857, 2, ',50026316,50009857,50011943,', 0),
(50011946, '姜汤', 15, 50009857, 2, ',50026316,50009857,50011946,', 0),
(50011947, '双皮奶/姜汁撞奶', 16, 50009857, 2, ',50026316,50009857,50011947,', 0),
(50016423, '奶茶', 18, 50009857, 2, ',50026316,50009857,50016423,', 1),
(50016428, '酸梅粉', 19, 50009857, 2, ',50026316,50009857,50016428,', 0),
(50026317, '可可/巧克力饮品', 20, 50009857, 2, ',50026316,50009857,50026317,', 0),
(210211, '伞', 0, 50010099, 2, ',21,50010099,210211,', 0),
(50018434, '伞架/伞配件', 1, 50010099, 2, ',21,50010099,50018434,', 0),
(50018429, '雨披/雨衣', 2, 50010099, 2, ',21,50010099,50018429,', 0),
(50023021, '雨罩', 3, 50010099, 2, ',21,50010099,50023021,', 0),
(50023022, '雨棚', 4, 50010099, 2, ',21,50010099,50023022,', 0),
(50023023, '防雨布', 5, 50010099, 2, ',21,50010099,50023023,', 0),
(50023024, '其他', 6, 50010099, 2, ',21,50010099,50023024,', 0),
(50026194, '雨鞋', 7, 50010099, 2, ',21,50010099,50026194,', 0),
(50026402, '防潮垫/抽屉垫', 8, 50010099, 2, ',21,50010099,50026402,', 0),
(50002802, '锅具/煲/烧水壶', 3, 50010101, 2, ',50016349,50010101,50002802,', 1),
(50006775, '烹饪勺铲', 4, 50010101, 2, ',50016349,50010101,50006775,', 1),
(215205, '刀具', 5, 50010101, 2, ',50016349,50010101,215205,', 1),
(350514, '燃气灶', 8, 50010101, 2, ',50016349,50010101,350514,', 0),
(50003449, '砧板/菜板', 10, 50010101, 2, ',50016349,50010101,50003449,', 0),
(215201, '其它', 48, 50010101, 2, ',50016349,50010101,215201,', 0),
(50026551, '烹饪工具套装', 49, 50010101, 2, ',50016349,50010101,50026551,', 0),
(50000563, '毛巾/面巾', 1, 50010103, 2, ',50008163,50010103,50000563,', 0),
(50008607, '浴巾', 5, 50010103, 2, ',50008163,50010103,50008607,', 0),
(50006988, '浴裙/浴袍/浴衣', 9, 50010103, 2, ',50008163,50010103,50006988,', 0),
(50008608, '手巾/手帕', 10, 50010103, 2, ',50008163,50010103,50008608,', 0),
(50024601, '浴巾毛巾方巾套装/三件套', 11, 50010103, 2, ',50008163,50010103,50024601,', 0),
(50024602, '酒店毛巾浴巾', 12, 50010103, 2, ',50008163,50010103,50024602,', 0),
(50010111, '油画', 1, 50010104, 2, ',23,50010104,50010111,', 0),
(50010106, '雕塑', 4, 50010104, 2, ',23,50010104,50010106,', 0),
(50003585, '瓷器', 5, 50010104, 2, ',23,50010104,50003585,', 0),
(50003584, '陶器', 6, 50010104, 2, ',23,50010104,50003584,', 0),
(50010109, '照片艺术品', 7, 50010104, 2, ',23,50010104,50010109,', 0),
(50010110, '其他材料艺术品', 8, 50010104, 2, ',23,50010104,50010110,', 0),
(50012878, '素描', 9, 50010104, 2, ',23,50010104,50012878,', 0),
(50012905, '水粉水彩', 11, 50010104, 2, ',23,50010104,50012905,', 0),
(50009045, '鞋子配件', 1, 50010406, 2, ',50010404,50010406,50009045,', 1),
(50009046, '包配件', 2, 50010406, 2, ',50010404,50010406,50009046,', 1),
(50009036, '皮带扣', 5, 50010406, 2, ',50010404,50010406,50009036,', 0),
(50010465, '迷你风扇', 1, 50010464, 2, ',21,50010464,50010465,', 0),
(50010466, '扇子', 2, 50010464, 2, ',21,50010464,50010466,', 0),
(50010357, '扇子配件', 30, 50010464, 2, ',21,50010464,50010357,', 0),
(50026437, '冰垫', 31, 50010464, 2, ',21,50010464,50026437,', 0),
(50026360, '冰贴', 32, 50010464, 2, ',21,50010464,50026360,', 0),
(50010511, '饼干', 0, 50010550, 2, ',50002766,50010550,50010511,', 0),
(50010535, '膨化食品', 1, 50010550, 2, ',50002766,50010550,50010535,', 0),
(50010513, '传统糕点', 3, 50010550, 2, ',50002766,50010550,50010513,', 0),
(50008062, '月饼', 7, 50010550, 2, ',50002766,50010550,50008062,', 0),
(50012598, '西式糕点', 14, 50010550, 2, ',50002766,50010550,50012598,', 0),
(50012402, '其它小点心', 15, 50010550, 2, ',50002766,50010550,50012402,', 0),
(50050719, '新鲜蔬菜', 35, 50010566, 2, ',50050359,50010566,50050719,', 1),
(50050724, '净菜', 36, 50010566, 2, ',50050359,50010566,50050724,', 0),
(350201, '剃须刀', 7, 50010567, 2, ',50002768,50010567,350201,', 0),
(50004396, '毛孔清洁器', 12, 50010567, 2, ',50002768,50010567,50004396,', 0),
(350212, '鼻毛修剪器', 13, 50010567, 2, ',50002768,50010567,350212,', 0),
(50005000, '美容喷雾机', 23, 50010567, 2, ',50002768,50010567,50005000,', 0),
(50005002, '电子美容仪', 25, 50010567, 2, ',50002768,50010567,50005002,', 0),
(50010715, '儿童书', 0, 50010689, 2, ',33,50010689,50010715,', 0),
(50010713, '其它', 0, 50010689, 2, ',33,50010689,50010713,', 0),
(50010710, '医学', 0, 50010689, 2, ',33,50010689,50010710,', 0),
(50010711, '哲学宗教', 0, 50010689, 2, ',33,50010689,50010711,', 0),
(50010714, '在线学习卡', 0, 50010689, 2, ',33,50010689,50010714,', 0),
(50010703, '外语/语言文字', 0, 50010689, 2, ',33,50010689,50010703,', 0),
(50010705, '娱乐时尚', 0, 50010689, 2, ',33,50010689,50010705,', 0),
(50010691, '小说', 0, 50010689, 2, ',33,50010689,50010691,', 0),
(50010706, '工具书', 0, 50010689, 2, ',33,50010689,50010706,', 0),
(50010701, '文化', 0, 50010689, 2, ',33,50010689,50010701,', 0),
(50010693, '文学', 0, 50010689, 2, ',33,50010689,50010693,', 0),
(50010712, '旅游/地理', 0, 50010689, 2, ',33,50010689,50010712,', 0),
(50010694, '期刊杂志', 0, 50010689, 2, ',33,50010689,50010694,', 0),
(50010708, '法律/政治/历史', 0, 50010689, 2, ',33,50010689,50010708,', 0),
(50010697, '漫画/动漫/杂志', 0, 50010689, 2, ',33,50010689,50010697,', 0),
(50010699, '生活/保健', 0, 50010689, 2, ',33,50010689,50010699,', 0),
(50010709, '社会科学', 0, 50010689, 2, ',33,50010689,50010709,', 0),
(50010704, '管理/经济', 0, 50010689, 2, ',33,50010689,50010704,', 0),
(50010690, '考试教材', 0, 50010689, 2, ',33,50010689,50010690,', 0),
(50010702, '育儿书', 0, 50010689, 2, ',33,50010689,50010702,', 0),
(50010700, '艺术', 0, 50010689, 2, ',33,50010689,50010700,', 0),
(50010707, '计算机', 0, 50010689, 2, ',33,50010689,50010707,', 0),
(111217, '打字机', 12, 50010757, 2, ',50007218,50010757,111217,', 0),
(50008331, '刻字机', 13, 50010757, 2, ',50007218,50010757,50008331,', 0),
(50008869, '幻灯机', 18, 50010757, 2, ',50007218,50010757,50008869,', 0),
(50008350, '绘图仪', 20, 50010757, 2, ',50007218,50010757,50008350,', 0),
(111211, '其它', 121, 50010757, 2, ',50007218,50010757,111211,', 0),
(50018845, '销毁设备', 122, 50010757, 2, ',50007218,50010757,50018845,', 0),
(50018850, '切纸机', 125, 50010757, 2, ',50007218,50010757,50018850,', 0),
(50018853, '冷裱机', 126, 50010757, 2, ',50007218,50010757,50018853,', 0),
(50018858, '光标阅卷机', 128, 50010757, 2, ',50007218,50010757,50018858,', 0),
(162701, '婚纱', 0, 50011404, 2, ',16,50011404,162701,', 0),
(50005065, '旗袍', 1, 50011404, 2, ',16,50011404,50005065,', 0),
(162702, '礼服/晚装', 2, 50011404, 2, ',16,50011404,162702,', 0),
(50012322, '羽毛球', 2, 50011556, 2, ',50010728,50011556,50012322,', 0),
(50012323, '羽毛球拍', 3, 50011556, 2, ',50010728,50011556,50012323,', 0),
(50012327, '羽毛球拍线', 4, 50011556, 2, ',50010728,50011556,50012327,', 0),
(50012328, '手胶/吸汗带', 5, 50011556, 2, ',50010728,50011556,50012328,', 0),
(50012325, '羽毛球服', 6, 50011556, 2, ',50010728,50011556,50012325,', 0),
(50012324, '羽毛球包', 7, 50011556, 2, ',50010728,50011556,50012324,', 0),
(50012331, '羽毛球鞋', 9, 50011556, 2, ',50010728,50011556,50012331,', 0),
(50012333, '运动袜', 10, 50011556, 2, ',50010728,50011556,50012333,', 0),
(50017577, '运动帽', 11, 50011556, 2, ',50010728,50011556,50017577,', 0),
(50012332, '运动毛巾', 13, 50011556, 2, ',50010728,50011556,50012332,', 0),
(50012329, '球网', 14, 50011556, 2, ',50010728,50011556,50012329,', 0),
(50016857, '更多羽毛球装备', 16, 50011556, 2, ',50010728,50011556,50016857,', 1),
(50018887, 'AV切换器', 0, 50011826, 2, ',50008090,50011826,50018887,', 0),
(50018889, 'KVM切换器', 1, 50011826, 2, ',50008090,50011826,50018889,', 0),
(50018888, 'VGA切换器', 2, 50011826, 2, ',50008090,50011826,50018888,', 0),
(50018883, 'BNC头', 3, 50011826, 2, ',50008090,50011826,50018883,', 0),
(50018884, 'F头', 4, 50011826, 2, ',50008090,50011826,50018884,', 0),
(50018886, 'RCA头', 5, 50011826, 2, ',50008090,50011826,50018886,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50018885, 'RF头', 6, 50011826, 2, ',50008090,50011826,50018885,', 0),
(50006511, '插头', 7, 50011826, 2, ',50008090,50011826,50006511,', 0),
(50006510, '电视高压包', 8, 50011826, 2, ',50008090,50011826,50006510,', 0),
(50018880, '分压盒', 9, 50011826, 2, ',50008090,50011826,50018880,', 0),
(50002920, '分配器/分频器/分支器', 10, 50011826, 2, ',50008090,50011826,50002920,', 0),
(50018882, '隔离器/耦合器', 11, 50011826, 2, ',50008090,50011826,50018882,', 0),
(50011828, '机顶盒共享器', 12, 50011826, 2, ',50008090,50011826,50011828,', 0),
(50011827, '数字电视机顶盒', 13, 50011826, 2, ',50008090,50011826,50011827,', 0),
(50002925, '视频线/音频线/AV线', 14, 50011826, 2, ',50008090,50011826,50002925,', 0),
(50018890, '网络切换器', 15, 50011826, 2, ',50008090,50011826,50018890,', 0),
(50002926, '射频器/转换器', 16, 50011826, 2, ',50008090,50011826,50002926,', 0),
(50002924, '节电器/省电器', 17, 50011826, 2, ',50008090,50011826,50002924,', 0),
(50018881, '微波炉面板', 18, 50011826, 2, ',50008090,50011826,50018881,', 0),
(350116, '遥控器', 19, 50011826, 2, ',50008090,50011826,350116,', 0),
(50018894, '其它家电配件', 20, 50011826, 2, ',50008090,50011826,50018894,', 0),
(50018937, '3D立体眼镜', 21, 50011826, 2, ',50008090,50011826,50018937,', 0),
(121704, '线材', 5, 50011866, 2, ',50011972,50011866,121704,', 0),
(50016107, '遥控器', 8, 50011866, 2, ',50011972,50011866,50016107,', 0),
(50011867, '耳机/耳麦配件', 9, 50011866, 2, ',50011972,50011866,50011867,', 0),
(120611, '碟/电池/电源适配器', 10, 50011866, 2, ',50011972,50011866,120611,', 0),
(50008739, '音频/视频无线传输器材', 12, 50011866, 2, ',50011972,50011866,50008739,', 0),
(50016482, '麦克风/话筒配件', 13, 50011866, 2, ',50011972,50011866,50016482,', 1),
(121705, 'hifi音响配件', 14, 50011866, 2, ',50011972,50011866,121705,', 1),
(50006490, '电源插座/接线板', 14, 50011866, 2, ',50011972,50011866,50006490,', 0),
(50008652, '更多影音配件', 19, 50011866, 2, ',50011972,50011866,50008652,', 0),
(50019649, 'HDMI线', 50, 50011866, 2, ',50011972,50011866,50019649,', 0),
(50019650, 'VGA线', 51, 50011866, 2, ',50011972,50011866,50019650,', 0),
(50011880, '按摩器材配件', 12, 50011877, 2, ',50002768,50011877,50011880,', 0),
(50024631, '口腔护理配件', 26, 50011877, 2, ',50002768,50011877,50024631,', 0),
(50024632, '美容/美体辅助工具配件', 27, 50011877, 2, ',50002768,50011877,50024632,', 0),
(50024633, '家用护理辅助器材配件', 28, 50011877, 2, ',50002768,50011877,50024633,', 1),
(50024634, '经络保健器材配件', 29, 50011877, 2, ',50002768,50011877,50024634,', 1),
(50024645, '美体瘦身配件', 30, 50011877, 2, ',50002768,50011877,50024645,', 1),
(50024654, '清洁美容工具配件', 31, 50011877, 2, ',50002768,50011877,50024654,', 1),
(50024655, '美发工具配件', 32, 50011877, 2, ',50002768,50011877,50024655,', 1),
(50024656, '家用保健器材配件', 33, 50011877, 2, ',50002768,50011877,50024656,', 1),
(50011889, '镜盒/镜袋/镜套', 0, 50011888, 2, ',28,50011888,50011889,', 0),
(50011890, '镜布', 1, 50011888, 2, ',28,50011888,50011890,', 0),
(50011891, '隐形眼镜伴侣盒', 2, 50011888, 2, ',28,50011888,50011891,', 0),
(50011897, '隐形眼镜清洁器', 3, 50011888, 2, ',28,50011888,50011897,', 0),
(50011940, '眼镜护理剂', 4, 50011888, 2, ',28,50011888,50011940,', 0),
(50018896, '眼镜螺丝刀', 5, 50011888, 2, ',28,50011888,50018896,', 0),
(50011898, '老花镜', 0, 50011893, 2, ',28,50011893,50011898,', 0),
(50011899, '游泳镜', 1, 50011893, 2, ',28,50011893,50011899,', 0),
(50011900, '潜水镜', 2, 50011893, 2, ',28,50011893,50011900,', 0),
(50011901, '司机镜', 3, 50011893, 2, ',28,50011893,50011901,', 0),
(50011902, '滑雪镜', 4, 50011893, 2, ',28,50011893,50011902,', 0),
(50011903, '电脑护目镜', 5, 50011893, 2, ',28,50011893,50011903,', 0),
(50011915, '夜视镜', 6, 50011893, 2, ',28,50011893,50011915,', 0),
(50018834, '3D眼镜', 7, 50011893, 2, ',28,50011893,50018834,', 0),
(50025614, '篮球眼镜', 8, 50011893, 2, ',28,50011893,50025614,', 0),
(50011999, '单方精油', 0, 50011992, 2, ',1801,50011992,50011999,', 0),
(50012000, '复方精油', 1, 50011992, 2, ',1801,50011992,50012000,', 0),
(50012001, '基底精油', 2, 50011992, 2, ',1801,50011992,50012001,', 0),
(50012002, '纯露/花水', 3, 50011992, 2, ',1801,50011992,50012002,', 0),
(50012003, '无香基底产品', 4, 50011992, 2, ',1801,50011992,50012003,', 0),
(50012004, '手工皂/精油皂', 5, 50011992, 2, ',1801,50011992,50012004,', 0),
(50012005, '熏香工具/DIY用具', 6, 50011992, 2, ',1801,50011992,50012005,', 0),
(50012006, '其它精油芳疗产品', 7, 50011992, 2, ',1801,50011992,50012006,', 0),
(50012158, 'MD', 1, 50012067, 2, ',50011972,50012067,50012158,', 0),
(120612, '便携VCD', 2, 50012067, 2, ',50011972,50012067,120612,', 0),
(50008317, '移动/便携DVD', 3, 50012067, 2, ',50011972,50012067,50008317,', 0),
(120608, 'TAPE磁带随身听', 5, 50012067, 2, ',50011972,50012067,120608,', 0),
(50012159, 'CD随身听', 6, 50012067, 2, ',50011972,50012067,50012159,', 0),
(350122, '视频眼镜', 7, 50012067, 2, ',50011972,50012067,350122,', 0),
(50005137, '收录机/手提CD/面包机', 8, 50012067, 2, ',50011972,50012067,50005137,', 0),
(350121, '收音机', 9, 50012067, 2, ',50011972,50012067,350121,', 0),
(50003367, '复读机', 10, 50012067, 2, ',50011972,50012067,50003367,', 0),
(50012147, '其他随身视听', 11, 50012067, 2, ',50011972,50012067,50012147,', 0),
(50005180, '足浴器', 2, 50012083, 2, ',50002768,50012083,50005180,', 0),
(50014749, '保健项圈/手环', 19, 50012083, 2, ',50002768,50012083,50014749,', 0),
(50009106, '保健护具(护腰/膝/腿)', 21, 50012083, 2, ',50002768,50012083,50009106,', 0),
(50008389, '桑拿浴箱', 38, 50012083, 2, ',50002768,50012083,50008389,', 0),
(50008392, '止酣器', 39, 50012083, 2, ',50002768,50012083,50008392,', 0),
(50010409, '其它健康/保健/检测', 46, 50012083, 2, ',50002768,50012083,50010409,', 0),
(50011874, '豆浆/搅拌/研磨机配件', 0, 50012099, 2, ',50012082,50012099,50011874,', 0),
(50011875, '电煲/电锅类配件', 1, 50012099, 2, ',50012082,50012099,50011875,', 0),
(50011873, '净水/饮水机配件耗材', 2, 50012099, 2, ',50012082,50012099,50011873,', 0),
(50011876, '酸奶/咖啡机配件及辅料', 3, 50012099, 2, ',50012082,50012099,50011876,', 0),
(50015138, '电热水壶/保健养生壶配件', 4, 50012099, 2, ',50012082,50012099,50015138,', 0),
(50003369, '其它厨房家电配件', 5, 50012099, 2, ',50012082,50012099,50003369,', 0),
(150806, '电话配件', 4, 50012135, 2, ',50012100,50012135,150806,', 0),
(50011868, '清洁/挂烫机/电熨斗配件', 5, 50012135, 2, ',50012100,50012135,50011868,', 0),
(50011869, '吸尘器/扫地机配件', 6, 50012135, 2, ',50012100,50012135,50011869,', 0),
(50011870, '缝纫机配件', 7, 50012135, 2, ',50012100,50012135,50011870,', 0),
(50011871, '风扇/换气扇配件', 8, 50012135, 2, ',50012100,50012135,50011871,', 0),
(50011872, '净化/加湿抽湿机配件', 9, 50012135, 2, ',50012100,50012135,50011872,', 0),
(50004394, '其他生活家电配件', 10, 50012135, 2, ',50012100,50012135,50004394,', 0),
(50012955, '对讲机配件', 11, 50012135, 2, ',50012100,50012135,50012955,', 0),
(50008224, 'LCD液晶电视', 0, 50012136, 2, ',50022703,50012136,50008224,', 0),
(50019790, 'LED电视', 1, 50012136, 2, ',50022703,50012136,50019790,', 0),
(50020200, '3D电视', 2, 50012136, 2, ',50022703,50012136,50020200,', 0),
(50016745, '等离子电视', 3, 50012136, 2, ',50022703,50012136,50016745,', 0),
(50012137, '其他电视机', 6, 50012136, 2, ',50022703,50012136,50012137,', 0),
(121703, 'Hifi音箱', 1, 50012142, 2, ',50011972,50012142,121703,', 0),
(50012143, '低音炮', 2, 50012142, 2, ',50011972,50012142,50012143,', 0),
(121702, '功放', 3, 50012142, 2, ',50011972,50012142,121702,', 0),
(50012144, '耳放', 4, 50012142, 2, ',50011972,50012142,50012144,', 0),
(50012145, '话放', 5, 50012142, 2, ',50011972,50012142,50012145,', 0),
(50001818, '胆机', 6, 50012142, 2, ',50011972,50012142,50001818,', 0),
(50008740, '混响', 8, 50012142, 2, ',50011972,50012142,50008740,', 0),
(50005053, '解码器', 9, 50012142, 2, ',50011972,50012142,50005053,', 0),
(50012146, 'Hifi套装', 16, 50012142, 2, ',50011972,50012142,50012146,', 0),
(50005887, '世嘉Idog/Ifish/Iz', 0, 50012149, 2, ',50011972,50012149,50005887,', 0),
(50008316, '录像机', 1, 50012149, 2, ',50011972,50012149,50008316,', 0),
(50006534, '扩音器', 2, 50012149, 2, ',50011972,50012149,50006534,', 0),
(50008741, '其它影音产品', 3, 50012149, 2, ',50011972,50012149,50008741,', 0),
(50018091, '各类线材', 0, 50012160, 2, ',20,50012160,50018091,', 0),
(50018092, '专用布袋/软套/硅胶套', 1, 50012160, 2, ',20,50012160,50018092,', 0),
(50018093, '水晶盒/铁壳', 2, 50012160, 2, ',20,50012160,50018093,', 0),
(50018094, '专用耳机', 3, 50012160, 2, ',20,50012160,50018094,', 0),
(50018095, '其他配件', 4, 50012160, 2, ',20,50012160,50018095,', 0),
(50018050, '游戏枪', 0, 50012161, 2, ',20,50012161,50018050,', 0),
(50018051, '左手手柄', 1, 50012161, 2, ',20,50012161,50018051,', 0),
(50018052, '右手手柄', 2, 50012161, 2, ',20,50012161,50018052,', 0),
(50018054, '加速器', 3, 50012161, 2, ',20,50012161,50018054,', 0),
(50018055, 'FIT平衡板', 4, 50012161, 2, ',20,50012161,50018055,', 0),
(50018056, '运动套装', 5, 50012161, 2, ',20,50012161,50018056,', 0),
(50018057, '吉他', 6, 50012161, 2, ',20,50012161,50018057,', 0),
(50018058, '鼓', 7, 50012161, 2, ',20,50012161,50018058,', 0),
(50018059, '瑜伽垫/健身毯', 8, 50012161, 2, ',20,50012161,50018059,', 0),
(50018060, '飞行摇杆', 9, 50012161, 2, ',20,50012161,50018060,', 0),
(50018061, '摩托艇', 10, 50012161, 2, ',20,50012161,50018061,', 0),
(50018062, '格斗摇杆', 11, 50012161, 2, ',20,50012161,50018062,', 0),
(50018063, '曲棍球杆', 12, 50012161, 2, ',20,50012161,50018063,', 0),
(50018064, '高尔夫球杆', 13, 50012161, 2, ',20,50012161,50018064,', 0),
(50018065, '音乐套装', 14, 50012161, 2, ',20,50012161,50018065,', 0),
(50018066, '桌球杆', 15, 50012161, 2, ',20,50012161,50018066,', 0),
(50018067, '光剑', 16, 50012161, 2, ',20,50012161,50018067,', 0),
(50018068, '拳击手套', 17, 50012161, 2, ',20,50012161,50018068,', 0),
(50018069, '乒乓球拍', 18, 50012161, 2, ',20,50012161,50018069,', 0),
(50018070, '跳舞毯', 19, 50012161, 2, ',20,50012161,50018070,', 0),
(50018071, 'WII专用记忆卡', 20, 50012161, 2, ',20,50012161,50018071,', 0),
(50018072, 'WII其他配件', 21, 50012161, 2, ',20,50012161,50018072,', 0),
(50018073, '座充', 0, 50012162, 2, ',20,50012162,50018073,', 0),
(50018074, '支架', 1, 50012162, 2, ',20,50012162,50018074,', 0),
(50018075, '各类线材', 2, 50012162, 2, ',20,50012162,50018075,', 0),
(50018076, '吉他', 3, 50012162, 2, ',20,50012162,50018076,', 0),
(50018077, '风扇', 4, 50012162, 2, ',20,50012162,50018077,', 0),
(50018078, '主机包', 5, 50012162, 2, ',20,50012162,50018078,', 0),
(50018080, '手柄', 6, 50012162, 2, ',20,50012162,50018080,', 0),
(50018081, '电源', 7, 50012162, 2, ',20,50012162,50018081,', 0),
(50018079, '其他专用配件', 8, 50012162, 2, ',20,50012162,50018079,', 0),
(50018088, '电源', 0, 50012163, 2, ',20,50012163,50018088,', 0),
(50018089, '触笔', 1, 50012163, 2, ',20,50012163,50018089,', 0),
(50018090, '其他配件', 2, 50012163, 2, ',20,50012163,50018090,', 0),
(50010548, '普通外套', 1, 50012308, 2, ',50008165,50012308,50010548,', 0),
(50024769, '西服/小西装', 2, 50012308, 2, ',50008165,50012308,50024769,', 0),
(50010519, '夹克/皮衣', 3, 50012308, 2, ',50008165,50012308,50010519,', 0),
(50010520, '大衣', 6, 50012308, 2, ',50008165,50012308,50010520,', 0),
(50012310, '风衣', 8, 50012308, 2, ',50008165,50012308,50012310,', 0),
(50012309, '其它', 11, 50012308, 2, ',50008165,50012308,50012309,', 0),
(50011818, '产妇帽/头巾', 1, 50012314, 2, ',50022517,50012314,50011818,', 0),
(50011597, '孕妇鞋', 2, 50012314, 2, ',50022517,50012314,50011597,', 0),
(50014848, '孕妇袜/连裤袜/打底袜', 22, 50012314, 2, ',50022517,50012314,50014848,', 0),
(50012341, '运动鞋', 2, 50012340, 2, ',50008165,50012340,50012341,', 0),
(50012342, '皮鞋', 3, 50012340, 2, ',50008165,50012340,50012342,', 0),
(50012343, '帆布鞋', 4, 50012340, 2, ',50008165,50012340,50012343,', 0),
(50012344, '单鞋', 5, 50012340, 2, ',50008165,50012340,50012344,', 0),
(50012345, '防滑学步鞋', 6, 50012340, 2, ',50008165,50012340,50012345,', 0),
(50012346, '凉鞋', 7, 50012340, 2, ',50008165,50012340,50012346,', 0),
(50017902, '沙滩鞋', 8, 50012340, 2, ',50008165,50012340,50017902,', 0),
(50012347, '靴子/雪地靴', 9, 50012340, 2, ',50008165,50012340,50012347,', 0),
(50012348, '棉鞋', 10, 50012340, 2, ',50008165,50012340,50012348,', 0),
(50012349, '家居拖鞋/保暖拖鞋', 11, 50012340, 2, ',50008165,50012340,50012349,', 0),
(50012350, '凉拖鞋', 12, 50012340, 2, ',50008165,50012340,50012350,', 0),
(50012351, '传统布鞋/手工编织鞋', 13, 50012340, 2, ',50008165,50012340,50012351,', 0),
(50012352, '虎头鞋', 14, 50012340, 2, ',50008165,50012340,50012352,', 0),
(50012353, '雨靴', 15, 50012340, 2, ',50008165,50012340,50012353,', 0),
(50003620, '鞋带鞋垫及其它', 16, 50012340, 2, ',50008165,50012340,50003620,', 0),
(50017903, '舞蹈鞋', 17, 50012340, 2, ',50008165,50012340,50017903,', 0),
(50012357, '连衣裙', 4, 50012354, 2, ',50022517,50012354,50012357,', 0),
(50023591, '半身裙', 5, 50012354, 2, ',50022517,50012354,50023591,', 0),
(50012372, '吊带/背心', 6, 50012354, 2, ',50022517,50012354,50012372,', 0),
(50012360, 'T恤', 7, 50012354, 2, ',50022517,50012354,50012360,', 0),
(50012365, '衬衫/雪纺衫', 8, 50012354, 2, ',50022517,50012354,50012365,', 0),
(50012359, '针织衫', 9, 50012354, 2, ',50022517,50012354,50012359,', 0),
(50012358, '毛衣', 10, 50012354, 2, ',50022517,50012354,50012358,', 0),
(50012369, '卫衣/绒衫', 11, 50012354, 2, ',50022517,50012354,50012369,', 0),
(50012355, '外套/风衣', 12, 50012354, 2, ',50022517,50012354,50012355,', 0),
(50012371, '马甲', 13, 50012354, 2, ',50022517,50012354,50012371,', 0),
(50023594, '棉衣/羽绒服/大衣', 14, 50012354, 2, ',50022517,50012354,50023594,', 0),
(50012361, '套装', 15, 50012354, 2, ',50022517,50012354,50012361,', 0),
(50023595, '影楼服装', 16, 50012354, 2, ',50022517,50012354,50023595,', 0),
(50050346, '孕妇婚纱/礼服', 17, 50012354, 2, ',50022517,50012354,50050346,', 0),
(50002664, '其它', 18, 50012354, 2, ',50022517,50012354,50002664,', 0),
(50012378, '防辐射吊带', 5, 50012374, 2, ',50022517,50012374,50012378,', 0),
(50012379, '防辐射套装', 6, 50012374, 2, ',50022517,50012374,50012379,', 0),
(50012380, '防辐射肚兜/护胎宝', 7, 50012374, 2, ',50022517,50012374,50012380,', 0),
(50012381, '防辐射围裙', 8, 50012374, 2, ',50022517,50012374,50012381,', 0),
(50010398, '其它防辐射', 9, 50012374, 2, ',50022517,50012374,50010398,', 0),
(50012532, '防辐射布料', 10, 50012374, 2, ',50022517,50012374,50012532,', 0),
(50012377, '防辐射裙/马甲', 15, 50012374, 2, ',50022517,50012374,50012377,', 0),
(50023581, '防辐射内裤', 16, 50012374, 2, ',50022517,50012374,50023581,', 0),
(50023582, '防辐射卡', 17, 50012374, 2, ',50022517,50012374,50023582,', 0),
(50023583, '防辐射面罩/口罩', 18, 50012374, 2, ',50022517,50012374,50023583,', 0),
(50023584, '防辐射手机袋/卡袋', 19, 50012374, 2, ',50022517,50012374,50023584,', 0),
(50050687, '鲜活蛋类', 34, 50012382, 2, ',50050359,50012382,50050687,', 1),
(50050688, '加工蛋类及蛋制品', 35, 50012382, 2, ',50050359,50012382,50050688,', 1),
(50012405, '幼儿小书包', 1, 50012404, 2, ',25,50012404,50012405,', 0),
(50012406, '普通双肩包', 2, 50012404, 2, ',25,50012404,50012406,', 0),
(50012407, '减负书包', 3, 50012404, 2, ',25,50012404,50012407,', 0),
(50012408, '拉杆包/箱', 4, 50012404, 2, ',25,50012404,50012408,', 0),
(50015878, '儿童行李箱/储物箱', 5, 50012404, 2, ',25,50012404,50015878,', 0),
(50012410, '斜挎包/拎包/腰包', 6, 50012404, 2, ',25,50012404,50012410,', 0),
(50012411, '零钱包', 7, 50012404, 2, ',25,50012404,50012411,', 0),
(1644, '其它', 8, 50012404, 2, ',25,50012404,1644,', 0),
(50025422, '翡翠', 0, 50025248, 2, ',50023878,50025248,50025422,', 0),
(50025423, '黄金', 1, 50025248, 2, ',50023878,50025248,50025423,', 0),
(50025424, '玉石', 2, 50025248, 2, ',50023878,50025248,50025424,', 0),
(50025425, '钻石', 3, 50025248, 2, ',50023878,50025248,50025425,', 0),
(50025426, '手表', 4, 50025248, 2, ',50023878,50025248,50025426,', 0),
(50025427, '其他', 5, 50025248, 2, ',50023878,50025248,50025427,', 0),
(50025428, '女装', 0, 50025249, 2, ',50023878,50025249,50025428,', 0),
(50025429, '男装', 1, 50025249, 2, ',50023878,50025249,50025429,', 0),
(50025430, '男鞋', 2, 50025249, 2, ',50023878,50025249,50025430,', 0),
(50025431, '女鞋', 3, 50025249, 2, ',50023878,50025249,50025431,', 0),
(50025432, '饰品', 4, 50025249, 2, ',50023878,50025249,50025432,', 0),
(50025433, '箱包', 5, 50025249, 2, ',50023878,50025249,50025433,', 0),
(50025434, '其他', 6, 50025249, 2, ',50023878,50025249,50025434,', 0),
(50025435, '美容护肤', 0, 50025250, 2, ',50023878,50025250,50025435,', 0),
(50025436, '彩妆', 1, 50025250, 2, ',50023878,50025250,50025436,', 0),
(50025437, '美容工具', 2, 50025250, 2, ',50023878,50025250,50025437,', 0),
(50025438, '香水', 3, 50025250, 2, ',50023878,50025250,50025438,', 0),
(50025439, '美发护发', 4, 50025250, 2, ',50023878,50025250,50025439,', 0),
(50025440, '其他', 5, 50025250, 2, ',50023878,50025250,50025440,', 0),
(50025441, '书籍', 0, 50025251, 2, ',50023878,50025251,50025441,', 0),
(50025442, 'CD/DVD', 1, 50025251, 2, ',50023878,50025251,50025442,', 0),
(50025443, '期刊杂志', 2, 50025251, 2, ',50023878,50025251,50025443,', 0),
(50025444, '乐器', 3, 50025251, 2, ',50023878,50025251,50025444,', 0),
(50025445, '运动器材', 4, 50025251, 2, ',50023878,50025251,50025445,', 0),
(50025446, '文具', 5, 50025251, 2, ',50023878,50025251,50025446,', 0),
(50025447, '其他', 6, 50025251, 2, ',50023878,50025251,50025447,', 0),
(50025448, '书画', 0, 50025252, 2, ',50023878,50025252,50025448,', 0),
(50025449, '收藏品', 1, 50025252, 2, ',50023878,50025252,50025449,', 0),
(50025450, '古玩', 2, 50025252, 2, ',50023878,50025252,50025450,', 0),
(50025451, '其他', 3, 50025252, 2, ',50023878,50025252,50025451,', 0),
(50025452, '宠物', 0, 50025253, 2, ',50023878,50025253,50025452,', 0),
(50025453, '宠物用品', 1, 50025253, 2, ',50023878,50025253,50025453,', 0),
(50025454, '宠物食品', 2, 50025253, 2, ',50023878,50025253,50025454,', 0),
(50025455, '其他', 3, 50025253, 2, ',50023878,50025253,50025455,', 0),
(50025456, '电影票', 0, 50025254, 2, ',50023878,50025254,50025456,', 0),
(50025457, '演出赛事', 1, 50025254, 2, ',50023878,50025254,50025457,', 0),
(50025458, '折扣券/购物卡', 2, 50025254, 2, ',50023878,50025254,50025458,', 0),
(50025459, '餐饮美食', 3, 50025254, 2, ',50023878,50025254,50025459,', 0),
(50025460, '休闲娱乐', 4, 50025254, 2, ',50023878,50025254,50025460,', 0),
(50025461, '生活服务', 5, 50025254, 2, ',50023878,50025254,50025461,', 0),
(50025462, '其他', 6, 50025254, 2, ',50023878,50025254,50025462,', 0),
(50025463, '二手整车', 0, 50025255, 2, ',50023878,50025255,50025463,', 0),
(50025464, '汽车配件', 1, 50025255, 2, ',50023878,50025255,50025464,', 0),
(50025465, '摩托/电动车', 2, 50025255, 2, ',50023878,50025255,50025465,', 0),
(50025466, '摩托/电动配件', 3, 50025255, 2, ',50023878,50025255,50025466,', 0),
(50025467, '自行车', 4, 50025255, 2, ',50023878,50025255,50025467,', 0),
(50025468, '其他', 5, 50025255, 2, ',50023878,50025255,50025468,', 0),
(50025386, '手机', 0, 50025385, 2, ',50023878,50025385,50025386,', 0),
(50025387, '配件', 1, 50025385, 2, ',50023878,50025385,50025387,', 0),
(50025558, '圣诞树', 0, 50025557, 2, ',50020857,50025557,50025558,', 0),
(50025559, '圣诞树装饰品', 1, 50025557, 2, ',50020857,50025557,50025559,', 0),
(50025560, '圣诞帽', 2, 50025557, 2, ',50020857,50025557,50025560,', 0),
(50025561, '圣诞装饰灯', 3, 50025557, 2, ',50020857,50025557,50025561,', 0),
(50025562, '圣诞袜', 4, 50025557, 2, ',50020857,50025557,50025562,', 0),
(50025563, '其他圣诞用品', 5, 50025557, 2, ',50020857,50025557,50025563,', 0),
(50016817, '脱水蔬菜', 0, 50025680, 2, ',50050359,50025680,50016817,', 0),
(50013193, '酱菜', 1, 50025680, 2, ',50050359,50025680,50013193,', 0),
(50016818, '腌制/泡菜', 33, 50025680, 2, ',50050359,50025680,50016818,', 0),
(50016820, '干货/土特产', 0, 50025682, 2, ',50016422,50025682,50016820,', 1),
(50050573, '熏腊/香肠/火腿制品', 36, 50025682, 2, ',50016422,50025682,50050573,', 1),
(50008438, '其它', 0, 50025689, 2, ',50016422,50025689,50008438,', 0),
(50016852, '年糕', 0, 50025689, 2, ',50016422,50025689,50016852,', 0),
(50016845, '方便面/粉丝/米线', 0, 50025689, 2, ',50016422,50025689,50016845,', 0),
(50016855, '粽子', 0, 50025689, 2, ',50016422,50025689,50016855,', 0),
(50016849, '肉制品', 0, 50025689, 2, ',50016422,50025689,50016849,', 0),
(50016850, '面条/挂面（待煮面条）', 0, 50025689, 2, ',50016422,50025689,50016850,', 0),
(50016846, '速食粥', 2, 50025689, 2, ',50016422,50025689,50016846,', 0),
(50016847, '速食汤', 3, 50025689, 2, ',50016422,50025689,50016847,', 0),
(50016848, '方便米饭', 4, 50025689, 2, ',50016422,50025689,50016848,', 0),
(50016851, '意大利面', 7, 50025689, 2, ',50016422,50025689,50016851,', 0),
(50025694, '低温即食', 9, 50025689, 2, ',50016422,50025689,50025694,', 0),
(50016853, '汤圆', 9, 50025689, 2, ',50016422,50025689,50016853,', 0),
(50016854, '煎饼', 10, 50025689, 2, ',50016422,50025689,50016854,', 0),
(50017231, '冷面', 17, 50025689, 2, ',50016422,50025689,50017231,', 0),
(50025683, '水饺/馄饨', 18, 50025689, 2, ',50016422,50025689,50025683,', 0),
(50025684, '面食', 19, 50025689, 2, ',50016422,50025689,50025684,', 0),
(50025685, '肉类火锅料', 20, 50025689, 2, ',50016422,50025689,50025685,', 0),
(50025686, '素火锅料', 21, 50025689, 2, ',50016422,50025689,50025686,', 0),
(50025687, '海鲜', 22, 50025689, 2, ',50016422,50025689,50025687,', 0),
(50025711, 'PSV电池', 0, 50025710, 2, ',20,50025710,50025711,', 0),
(50025712, 'PSV充电器', 1, 50025710, 2, ',20,50025710,50025712,', 0),
(50025713, 'PSV保护套/外壳', 2, 50025710, 2, ',20,50025710,50025713,', 0),
(50025714, 'PSV专用耳机', 3, 50025710, 2, ',20,50025710,50025714,', 0),
(50025715, 'PSV屏幕贴膜', 4, 50025710, 2, ',20,50025710,50025715,', 0),
(50025716, 'PSV彩贴/贴纸', 5, 50025710, 2, ',20,50025710,50025716,', 0),
(50011173, '防蚊贴/防蚊手环', 0, 50025838, 2, ',21,50025838,50011173,', 0),
(50004421, '灭蚊灯/吸蚊机/灭蝇灯', 1, 50025838, 2, ',21,50025838,50004421,', 0),
(50004423, '超声波驱蚊器/电子驱蚊器', 3, 50025838, 2, ',21,50025838,50004423,', 0),
(50004424, '其它灭蚊用品', 4, 50025838, 2, ',21,50025838,50004424,', 0),
(50018223, '电蚊拍', 10, 50025838, 2, ',21,50025838,50018223,', 0),
(50023025, '粘蝇纸/苍蝇拍', 13, 50025838, 2, ',21,50025838,50023025,', 0),
(50023026, '灭鼠笼/捕鼠器', 14, 50025838, 2, ',21,50025838,50023026,', 0),
(50024046, '驱蚊草', 17, 50025838, 2, ',21,50025838,50024046,', 0),
(50026520, '防霉防蛀', 18, 50025838, 2, ',21,50025838,50026520,', 0),
(50026527, '纱窗/纱门', 19, 50025838, 2, ',21,50025838,50026527,', 0),
(216506, '香熏灯炉/器具', 0, 50025839, 2, ',21,50025839,216506,', 0),
(50026403, '香包/香囊', 1, 50025839, 2, ',21,50025839,50026403,', 0),
(50026343, '玄幻奇幻', 0, 50026342, 2, ',33,50026342,50026343,', 0),
(50026344, '仙侠奇侠', 1, 50026342, 2, ',33,50026342,50026344,', 0),
(50026345, '科幻悬疑', 2, 50026342, 2, ',33,50026342,50026345,', 0),
(50026346, '历史军事', 3, 50026342, 2, ',33,50026342,50026346,', 0),
(50026347, '游戏竞技', 4, 50026342, 2, ',33,50026342,50026347,', 0),
(50026348, '都市情感', 5, 50026342, 2, ',33,50026342,50026348,', 0),
(50026349, '古典言情', 6, 50026342, 2, ',33,50026342,50026349,', 0),
(50026350, '青春校园', 7, 50026342, 2, ',33,50026342,50026350,', 0),
(50026351, '幻想穿越', 8, 50026342, 2, ',33,50026342,50026351,', 0),
(50026352, '豪门纯爱', 9, 50026342, 2, ',33,50026342,50026352,', 0),
(50008611, '乌龙茶', 0, 50026397, 2, ',50026316,50026397,50008611,', 0),
(50010420, '养生茶', 0, 50026397, 2, ',50026316,50026397,50010420,', 0),
(50026408, '普洱茶', 0, 50026397, 2, ',50026316,50026397,50026408,', 1),
(50010421, '水果茶/果味茶', 0, 50026397, 2, ',50026316,50026397,50010421,', 0),
(50016231, '绿茶', 1, 50026397, 2, ',50026316,50026397,50016231,', 0),
(50016232, '红茶', 2, 50026397, 2, ',50026316,50026397,50016232,', 0),
(50016233, '黑茶', 3, 50026397, 2, ',50026316,50026397,50016233,', 0),
(50016234, '白茶', 4, 50026397, 2, ',50026316,50026397,50016234,', 0),
(50008612, '花草茶', 5, 50026397, 2, ',50026316,50026397,50008612,', 0),
(50016235, '黄茶', 5, 50026397, 2, ',50026316,50026397,50016235,', 0),
(50016236, '花茶/其它茶叶', 6, 50026397, 2, ',50026316,50026397,50016236,', 0),
(50009863, '功能饮料', 1, 50026398, 2, ',50026316,50026398,50009863,', 0),
(50009864, '碳酸饮料', 2, 50026398, 2, ',50026316,50026398,50009864,', 0),
(50016431, '果蔬汁', 4, 50026398, 2, ',50026316,50026398,50016431,', 1),
(50008917, '茶饮料', 5, 50026398, 2, ',50026316,50026398,50008917,', 0),
(50008912, '凉茶', 6, 50026398, 2, ',50026316,50026398,50008912,', 0),
(50008916, '矿泉水/纯净水', 9, 50026398, 2, ',50026316,50026398,50008916,', 0),
(50012391, '含乳饮料', 12, 50026398, 2, ',50026316,50026398,50012391,', 0),
(50008914, '酸梅汤', 12, 50026398, 2, ',50026316,50026398,50008914,', 0),
(50012392, '常温牛奶', 13, 50026398, 2, ',50026316,50026398,50012392,', 0),
(50016427, '酸奶/粉/益生菌', 15, 50026398, 2, ',50026316,50026398,50016427,', 0),
(50013192, '果味饮料', 16, 50026398, 2, ',50026316,50026398,50013192,', 0),
(50008919, '其它饮料', 18, 50026398, 2, ',50026316,50026398,50008919,', 0),
(50026438, '洁面', 0, 50026457, 2, ',50022517,50026457,50026438,', 0),
(50026439, '化妆水/爽肤水', 1, 50026457, 2, ',50022517,50026457,50026439,', 0),
(50026440, '面部精华', 123, 50026457, 2, ',50022517,50026457,50026440,', 0),
(50026441, '乳液/面霜', 125, 50026457, 2, ',50022517,50026457,50026441,', 0),
(50026442, '面膜/面膜粉', 126, 50026457, 2, ',50022517,50026457,50026442,', 0),
(50026443, '防晒/隔离', 127, 50026457, 2, ',50022517,50026457,50026443,', 0),
(50026444, '眼部护理', 128, 50026457, 2, ',50022517,50026457,50026444,', 0),
(50026445, '唇部护理', 129, 50026457, 2, ',50022517,50026457,50026445,', 0),
(50026446, '手部护理', 130, 50026457, 2, ',50022517,50026457,50026446,', 0),
(50026447, '身体护理', 131, 50026457, 2, ',50022517,50026457,50026447,', 0),
(50026448, '乳房护理', 132, 50026457, 2, ',50022517,50026457,50026448,', 0),
(50026449, '妊娠纹护理', 133, 50026457, 2, ',50022517,50026457,50026449,', 0),
(50026450, '淡疤护理', 133, 50026457, 2, ',50022517,50026457,50026450,', 0),
(50026451, '腿脚舒缓', 134, 50026457, 2, ',50022517,50026457,50026451,', 0),
(50026452, '瘦身紧致', 135, 50026457, 2, ',50022517,50026457,50026452,', 0),
(50026453, '孕产妇漱口水', 136, 50026457, 2, ',50022517,50026457,50026453,', 0),
(50026454, '孕产妇牙膏', 137, 50026457, 2, ',50022517,50026457,50026454,', 0),
(50026455, '其它', 138, 50026457, 2, ',50022517,50026457,50026455,', 0),
(50026456, '孕产妇叶酸', 0, 50026460, 2, ',50022517,50026460,50026456,', 0),
(50026461, '孕产妇DHA', 142, 50026460, 2, ',50022517,50026460,50026461,', 0),
(50026462, '孕产妇维生素', 143, 50026460, 2, ',50022517,50026460,50026462,', 0),
(50026463, '孕产妇钙铁锌', 144, 50026460, 2, ',50022517,50026460,50026463,', 0),
(50026464, '孕产妇牛初乳', 145, 50026460, 2, ',50022517,50026460,50026464,', 0),
(50026465, '孕产妇益生菌', 146, 50026460, 2, ',50022517,50026460,50026465,', 0),
(50026466, '孕产妇鱼肝油', 147, 50026460, 2, ',50022517,50026460,50026466,', 0),
(50026467, '孕产妇防便秘营养品', 148, 50026460, 2, ',50022517,50026460,50026467,', 0),
(50026468, '孕产妇多元营养', 149, 50026460, 2, ',50022517,50026460,50026468,', 0),
(50026469, '产后瘦身品', 150, 50026460, 2, ',50022517,50026460,50026469,', 0),
(50026470, '其它', 151, 50026460, 2, ',50022517,50026460,50026470,', 0),
(50026472, '月子餐', 0, 50026471, 2, ',50022517,50026471,50026472,', 0),
(50026473, '月子食用油', 144, 50026471, 2, ',50022517,50026471,50026473,', 0),
(50026474, '月子米酒', 145, 50026471, 2, ',50022517,50026471,50026474,', 0),
(50026475, '月乃汤', 146, 50026471, 2, ',50022517,50026471,50026475,', 0),
(50026476, '催奶发奶产品', 147, 50026471, 2, ',50022517,50026471,50026476,', 0),
(50026477, '其它', 148, 50026471, 2, ',50022517,50026471,50026477,', 0),
(50026536, '健康评估', 1, 50026535, 2, ',50025111,50026535,50026536,', 1),
(50026540, '预约就医', 3, 50026535, 2, ',50025111,50026535,50026540,', 1),
(50026544, '医疗美容/护理/治疗', 4, 50026535, 2, ',50025111,50026535,50026544,', 1),
(50026543, '其他', 5, 50026535, 2, ',50025111,50026535,50026543,', 0),
(50019102, '体检/医疗保健卡', 6, 50026535, 2, ',50025111,50026535,50019102,', 0),
(50026802, '维生素/矿物质', 0, 50026801, 2, ',50026800,50026801,50026802,', 1),
(50026803, '海洋生物类', 1, 50026801, 2, ',50026800,50026801,50026803,', 1),
(50026804, '菌/菇/微生物发酵', 2, 50026801, 2, ',50026800,50026801,50026804,', 1),
(50026805, '蛋白质/氨基酸', 3, 50026801, 2, ',50026800,50026801,50026805,', 1),
(50026806, '膳食纤维/碳水化合物', 4, 50026801, 2, ',50026800,50026801,50026806,', 1),
(50026807, '植物精华/提取物', 5, 50026801, 2, ',50026800,50026801,50026807,', 1),
(50026808, '动物精华/提取物', 6, 50026801, 2, ',50026800,50026801,50026808,', 1),
(50026809, '保健饮品', 7, 50026801, 2, ',50026800,50026801,50026809,', 0),
(50026810, '功能复合型膳食营养补充剂', 8, 50026801, 2, ',50026800,50026801,50026810,', 1),
(50050227, '脂肪酸/脂类', 9, 50026801, 2, ',50026800,50026801,50050227,', 1),
(50026812, '海洋生物类', 0, 50026811, 2, ',50026800,50026811,50026812,', 1),
(50026813, '菌/菇/微生物发酵', 1, 50026811, 2, ',50026800,50026811,50026813,', 1),
(50026814, '维生素/矿物质', 2, 50026811, 2, ',50026800,50026811,50026814,', 1),
(50026815, '蛋白质/氨基酸', 3, 50026811, 2, ',50026800,50026811,50026815,', 1),
(50026816, '膳食纤维/碳水化合物', 4, 50026811, 2, ',50026800,50026811,50026816,', 1),
(50026817, '植物精华/提取物', 5, 50026811, 2, ',50026800,50026811,50026817,', 1),
(50026818, '保健饮品', 6, 50026811, 2, ',50026800,50026811,50026818,', 0),
(50026819, '动物精华/提取物', 7, 50026811, 2, ',50026800,50026811,50026819,', 1),
(50026820, '功能复合型膳食营养补充剂', 8, 50026811, 2, ',50026800,50026811,50026820,', 1),
(50050231, '脂肪酸/脂类', 9, 50026811, 2, ',50026800,50026811,50050231,', 1),
(50050237, '其他', 10, 50026811, 2, ',50026800,50026811,50050237,', 0),
(50050144, '雪莲', 0, 50050143, 2, ',50020275,50050143,50050144,', 0),
(50050145, '芦荟', 1, 50050143, 2, ',50020275,50050143,50050145,', 0),
(50050146, '蚂蚁', 2, 50050143, 2, ',50020275,50050143,50050146,', 0),
(50050147, '松花粉', 3, 50050143, 2, ',50020275,50050143,50050147,', 0),
(50050148, '草珊瑚', 4, 50050143, 2, ',50020275,50050143,50050148,', 0),
(50050149, '其它新资源食品类', 5, 50050143, 2, ',50020275,50050143,50050149,', 0),
(50050150, '蛹虫草', 6, 50050143, 2, ',50020275,50050143,50050150,', 0),
(50050151, '银杏', 7, 50050143, 2, ',50020275,50050143,50050151,', 0),
(50050281, '发生心理学', 0, 50050280, 2, ',33,50050280,50050281,', 0),
(50050282, '大众心理学', 1, 50050280, 2, ',33,50050280,50050282,', 0),
(50050283, '心里健康', 2, 50050280, 2, ',33,50050280,50050283,', 0),
(50050284, '心理学研究方法', 3, 50050280, 2, ',33,50050280,50050284,', 0),
(50050285, '心里辅导', 4, 50050280, 2, ',33,50050280,50050285,', 0),
(50050286, '心理学理论', 5, 50050280, 2, ',33,50050280,50050286,', 0),
(50050287, '心理过程与心里状态', 6, 50050280, 2, ',33,50050280,50050287,', 0),
(50050288, '社会心理学', 7, 50050280, 2, ',33,50050280,50050288,', 0),
(50050289, '人格心理学', 8, 50050280, 2, ',33,50050280,50050289,', 0),
(50050290, '变态心理学', 9, 50050280, 2, ',33,50050280,50050290,', 0),
(50050291, '催眠术', 10, 50050280, 2, ',33,50050280,50050291,', 0),
(50050292, '心里分析术', 11, 50050280, 2, ',33,50050280,50050292,', 0),
(50016772, '海参', 0, 50050371, 2, ',50050359,50050371,50016772,', 0),
(50050693, '鱼类', 0, 50050371, 2, ',50050359,50050371,50050693,', 1),
(50050694, '墨鱼/乌贼', 1, 50050371, 2, ',50050359,50050371,50050694,', 1),
(50016771, '藻类', 1, 50050371, 2, ',50050359,50050371,50016771,', 1),
(50050695, '虾类', 2, 50050371, 2, ',50050359,50050371,50050695,', 1),
(50050698, '章鱼', 5, 50050371, 2, ',50050359,50050371,50050698,', 1),
(50050699, '鱿鱼', 6, 50050371, 2, ',50050359,50050371,50050699,', 1),
(50050701, '贝类', 8, 50050371, 2, ',50050359,50050371,50050701,', 1),
(50016801, '海蜇', 10, 50050371, 2, ',50050359,50050371,50016801,', 0),
(50016806, '甲鱼', 15, 50050371, 2, ',50050359,50050371,50016806,', 0),
(50025692, '其它', 17, 50050371, 2, ',50050359,50050371,50025692,', 0),
(50025690, '蟹类', 33, 50050371, 2, ',50050359,50050371,50025690,', 1),
(50050666, '其它', 0, 50050372, 2, ',50050359,50050372,50050666,', 0),
(50050667, '鸡肉制品', 1, 50050372, 2, ',50050359,50050372,50050667,', 1),
(50050668, '猪肉制品', 2, 50050372, 2, ',50050359,50050372,50050668,', 1),
(50050669, '羊肉制品', 3, 50050372, 2, ',50050359,50050372,50050669,', 1),
(50050670, '鸽肉制品', 4, 50050372, 2, ',50050359,50050372,50050670,', 0),
(50050671, '鸭肉制品', 5, 50050372, 2, ',50050359,50050372,50050671,', 0),
(50050672, '牛肉制品', 6, 50050372, 2, ',50050359,50050372,50050672,', 1),
(50050379, '大豆油', 0, 50050378, 2, ',50016422,50050378,50050379,', 0),
(50050380, '玉米油', 1, 50050378, 2, ',50016422,50050378,50050380,', 0),
(50050381, '调和油', 2, 50050378, 2, ',50016422,50050378,50050381,', 0),
(50050382, '红花油', 3, 50050378, 2, ',50016422,50050378,50050382,', 0),
(50050383, '香油', 4, 50050378, 2, ',50016422,50050378,50050383,', 0),
(50050385, '核桃油', 6, 50050378, 2, ',50016422,50050378,50050385,', 0),
(50013185, '蚝油', 7, 50050378, 2, ',50016422,50050378,50013185,', 0),
(50050388, '葡萄籽油', 9, 50050378, 2, ',50016422,50050378,50050388,', 0),
(50050390, '米糠油', 11, 50050378, 2, ',50016422,50050378,50050390,', 0),
(50017141, '鱼露', 11, 50050378, 2, ',50016422,50050378,50017141,', 0),
(50050391, '菜籽油', 12, 50050378, 2, ',50016422,50050378,50050391,', 0),
(50025676, '麻油', 12, 50050378, 2, ',50016422,50050378,50025676,', 0),
(50050393, '花生油', 14, 50050378, 2, ',50016422,50050378,50050393,', 0),
(50050394, '花椒油', 15, 50050378, 2, ',50016422,50050378,50050394,', 0),
(50050395, '椰子油', 16, 50050378, 2, ',50016422,50050378,50050395,', 0),
(50050396, '橄榄油', 17, 50050378, 2, ',50016422,50050378,50050396,', 0),
(50050397, '山茶油', 18, 50050378, 2, ',50016422,50050378,50050397,', 0),
(50009836, '其它', 35, 50050378, 2, ',50016422,50050378,50009836,', 0),
(50050519, '家居家电维修/清洗', 0, 50050464, 2, ',50025111,50050464,50050519,', 1),
(50050520, '家居装修施工/设计', 1, 50050464, 2, ',50025111,50050464,50050520,', 1),
(50050521, '测量/检测', 2, 50050464, 2, ',50025111,50050464,50050521,', 1),
(50050522, '其他家居服务', 3, 50050464, 2, ',50025111,50050464,50050522,', 0),
(50023807, '垂直搬运', 4, 50050464, 2, ',50025111,50050464,50023807,', 0),
(50023806, '家居物流/同城配送', 5, 50050464, 2, ',50025111,50050464,50023806,', 0),
(50050523, '单项家居安装施工', 6, 50050464, 2, ',50025111,50050464,50050523,', 1),
(50024446, '家居安装服务套餐', 7, 50050464, 2, ',50025111,50050464,50024446,', 1),
(50050473, '孕妇/亲子摄影', 0, 50050471, 2, ',50025111,50050471,50050473,', 0),
(50050474, '会议摄影', 1, 50050471, 2, ',50025111,50050471,50050474,', 0),
(50050475, '证件照', 2, 50050471, 2, ',50025111,50050471,50050475,', 0),
(50050476, '视频/照片后期制作', 3, 50050471, 2, ',50025111,50050471,50050476,', 0),
(50050477, '儿童摄影', 4, 50050471, 2, ',50025111,50050471,50050477,', 0),
(50050478, '宠物摄影', 5, 50050471, 2, ',50025111,50050471,50050478,', 0),
(50050479, '商品摄影', 6, 50050471, 2, ',50025111,50050471,50050479,', 0),
(50050480, '婚纱摄影', 7, 50050471, 2, ',50025111,50050471,50050480,', 0),
(50050481, '写真摄影', 8, 50050471, 2, ',50025111,50050471,50050481,', 0),
(50050482, '广告摄影', 9, 50050471, 2, ',50025111,50050471,50050482,', 0),
(50050483, '彩扩冲印', 10, 50050471, 2, ',50025111,50050471,50050483,', 0),
(50050484, '情侣摄影', 11, 50050471, 2, ',50025111,50050471,50050484,', 0),
(50050485, '全家福摄影', 12, 50050471, 2, ',50025111,50050471,50050485,', 0),
(50050486, '相框/相册制作', 13, 50050471, 2, ',50025111,50050471,50050486,', 0),
(50050572, '其他摄影服务', 15, 50050471, 2, ',50025111,50050471,50050572,', 0),
(50050491, '社区便利', 2, 50050489, 2, ',50025111,50050489,50050491,', 1),
(50050494, '派对服务/设备场地租赁', 4, 50050489, 2, ',50025111,50050489,50050494,', 1),
(50050495, '其他便民服务', 10, 50050489, 2, ',50025111,50050489,50050495,', 1),
(50050538, '殡葬服务', 11, 50050489, 2, ',50025111,50050489,50050538,', 1),
(50025113, '水电煤/生活缴费', 12, 50050489, 2, ',50025111,50050489,50025113,', 0),
(50025112, '信用卡还贷', 13, 50050489, 2, ',50025111,50050489,50025112,', 0),
(50025120, '宗教/起名/解梦', 14, 50050489, 2, ',50025111,50050489,50025120,', 1),
(50026187, '文字编辑服务', 15, 50050489, 2, ',50025111,50050489,50026187,', 1),
(50019101, '洗衣券/家政服务卡', 16, 50050489, 2, ',50025111,50050489,50019101,', 0),
(50025122, '搬家/搬运服务', 17, 50050489, 2, ',50025111,50050489,50025122,', 1),
(50014966, '宠物服务', 18, 50050489, 2, ',50025111,50050489,50014966,', 0),
(50019108, '生活服务优惠券', 20, 50050489, 2, ',50025111,50050489,50019108,', 0),
(50019107, '电视/宽带卡', 21, 50050489, 2, ',50025111,50050489,50019107,', 0),
(50008154, '代办/跑腿', 22, 50050489, 2, ',50025111,50050489,50008154,', 0),
(50014970, '理财咨询', 23, 50050489, 2, ',50025111,50050489,50014970,', 0),
(50025138, '加油卡/加油充值', 24, 50050489, 2, ',50025111,50050489,50025138,', 1),
(50050623, '胶片胶卷', 0, 50050622, 2, ',50008090,50050622,50050623,', 1),
(50050626, 'Lomo配件及周边', 1, 50050622, 2, ',50008090,50050622,50050626,', 1),
(50050632, '拍立得配件及周边', 2, 50050622, 2, ',50008090,50050622,50050632,', 1),
(50050639, '其他配件', 3, 50050622, 2, ',50008090,50050622,50050639,', 0),
(50025699, '烤鸭', 14, 50050643, 2, ',50050359,50050643,50025699,', 0),
(50025700, '卤肉类', 15, 50050643, 2, ',50050359,50050643,50025700,', 0),
(50008063, '豆腐干/香干', 16, 50050643, 2, ',50050359,50050643,50008063,', 0),
(50016841, '其它', 85, 50050643, 2, ',50050359,50050643,50016841,', 0),
(50050733, '凉菜\\凉拌', 86, 50050643, 2, ',50050359,50050643,50050733,', 0),
(50050734, '鸡熟食', 87, 50050643, 2, ',50050359,50050643,50050734,', 0),
(50050726, '新鲜水果', 0, 50050725, 2, ',50050359,50050725,50050726,', 1),
(50016819, '冻干水果', 34, 50050725, 2, ',50050359,50050725,50016819,', 0),
(50009898, '水果罐头', 63, 50050725, 2, ',50050359,50050725,50009898,', 0),
(50012417, '床围', 8, 50012412, 2, ',50014812,50012412,50012417,', 0),
(50015975, '床靠', 9, 50012412, 2, ',50014812,50012412,50015975,', 0),
(50015381, '床单/床褥', 10, 50012412, 2, ',50014812,50012412,50015381,', 0),
(50012418, '床垫', 11, 50012412, 2, ',50014812,50012412,50012418,', 0),
(50012421, '婴儿床品套件', 12, 50012412, 2, ',50014812,50012412,50012421,', 0),
(50012414, '抱被/抱毯', 13, 50012412, 2, ',50014812,50012412,50012414,', 0),
(50015974, '毛毯/盖毯', 14, 50012412, 2, ',50014812,50012412,50015974,', 0),
(50015977, '尿布袋/床头挂袋', 15, 50012412, 2, ',50014812,50012412,50015977,', 0),
(50015557, '被套', 19, 50012412, 2, ',50014812,50012412,50015557,', 0),
(50016160, '棉花被', 20, 50012412, 2, ',50014812,50012412,50016160,', 0),
(50015972, '蚕丝被', 21, 50012412, 2, ',50014812,50012412,50015972,', 0),
(50012416, '其它被子', 22, 50012412, 2, ',50014812,50012412,50012416,', 0),
(50012437, '婴儿剪刀/指甲钳', 1, 50012436, 2, ',50014812,50012436,50012437,', 0),
(50012440, '理发器', 6, 50012436, 2, ',50014812,50012436,50012440,', 0),
(50012442, '体温计', 8, 50012436, 2, ',50014812,50012436,50012442,', 0),
(50012444, '棉棒/棉签', 11, 50012436, 2, ',50014812,50012436,50012444,', 0),
(50012445, '吸鼻器', 12, 50012436, 2, ',50014812,50012436,50012445,', 0),
(50012758, '清洁镊子', 13, 50012436, 2, ',50014812,50012436,50012758,', 0),
(50006022, '身高尺', 17, 50012436, 2, ',50014812,50012436,50006022,', 0),
(50006024, '儿童坐便凳', 19, 50012436, 2, ',50014812,50012436,50006024,', 0),
(50008714, '婴儿电子秤', 32, 50012436, 2, ',50014812,50012436,50008714,', 0),
(50014844, '安全梳子/刷子', 34, 50012436, 2, ',50014812,50012436,50014844,', 0),
(50014845, '耳勺/发光耳勺', 35, 50012436, 2, ',50014812,50012436,50014845,', 0),
(50015053, '温湿度计/室温计', 37, 50012436, 2, ',50014812,50012436,50015053,', 0),
(50015951, '粉扑', 39, 50012436, 2, ',50014812,50012436,50015951,', 0),
(50006017, '其它', 40, 50012436, 2, ',50014812,50012436,50006017,', 0),
(50016469, '婴儿电吹风', 43, 50012436, 2, ',50014812,50012436,50016469,', 0),
(50016470, '儿童马桶盖', 44, 50012436, 2, ',50014812,50012436,50016470,', 0),
(50016471, '理发围布', 45, 50012436, 2, ',50014812,50012436,50016471,', 0),
(50012449, '牙胶/固齿器', 1, 50012448, 2, ',50014812,50012448,50012449,', 0),
(50008709, '食物咬咬袋', 2, 50012448, 2, ',50014812,50012448,50008709,', 0),
(50014700, '电动牙刷', 3, 50012448, 2, ',50014812,50012448,50014700,', 0),
(50012450, '乳牙刷', 5, 50012448, 2, ',50014812,50012448,50012450,', 0),
(50012451, '训练牙刷', 6, 50012448, 2, ',50014812,50012448,50012451,', 0),
(50012452, '护齿牙刷', 7, 50012448, 2, ',50014812,50012448,50012452,', 0),
(50012453, '牙膏', 8, 50012448, 2, ',50014812,50012448,50012453,', 0),
(50012454, '牙膏牙刷套装', 9, 50012448, 2, ',50014812,50012448,50012454,', 0),
(50005951, '其它', 10, 50012448, 2, ',50014812,50012448,50005951,', 0),
(50012456, '戏水/玩沙玩具', 1, 50012455, 2, ',25,50012455,50012456,', 0),
(50016435, '洗澡书', 2, 50012455, 2, ',25,50012455,50016435,', 0),
(50016046, '水上游艺设施', 3, 50012455, 2, ',25,50012455,50016046,', 0),
(50012457, '游泳池', 3, 50012455, 2, ',25,50012455,50012457,', 0),
(50012458, '婴儿/儿童游泳圈', 5, 50012455, 2, ',25,50012455,50012458,', 0),
(50012459, '救生衣', 6, 50012455, 2, ',25,50012455,50012459,', 0),
(50012461, '充气筒', 8, 50012455, 2, ',25,50012455,50012461,', 0),
(50012462, '护脐贴/护耳贴', 9, 50012455, 2, ',25,50012455,50012462,', 0),
(50012463, '溶质', 10, 50012455, 2, ',25,50012455,50012463,', 0),
(50012464, '儿童泳衣泳裤', 11, 50012455, 2, ',25,50012455,50012464,', 0),
(50024218, '儿童游泳帽', 12, 50012455, 2, ',25,50012455,50024218,', 0),
(50012465, '泳镜鼻夹耳塞', 13, 50012455, 2, ',25,50012455,50012465,', 0),
(50000935, '其它', 14, 50012455, 2, ',25,50012455,50000935,', 0),
(50008708, '奶瓶果蔬清洗液', 1, 50012466, 2, ',50014812,50012466,50008708,', 0),
(50012467, '洗衣液', 2, 50012466, 2, ',50014812,50012466,50012467,', 0),
(50012468, '衣物柔顺/柔软剂', 3, 50012466, 2, ',50014812,50012466,50012468,', 0),
(50012469, '洗衣粉', 4, 50012466, 2, ',50014812,50012466,50012469,', 0),
(50014726, '洗衣皂', 6, 50012466, 2, ',50014812,50012466,50014726,', 0),
(50005970, '其它', 7, 50012466, 2, ',50014812,50012466,50005970,', 0),
(50018994, '卷筒纸', 0, 50012473, 2, ',50025705,50012473,50018994,', 0),
(50010895, '湿巾', 0, 50012473, 2, ',50025705,50012473,50010895,', 0),
(50012478, '抽纸', 4, 50012473, 2, ',50025705,50012473,50012478,', 0),
(50012480, '手帕纸', 6, 50012473, 2, ',50025705,50012473,50012480,', 0),
(50016890, '厨房纸巾', 7, 50012473, 2, ',50025705,50012473,50016890,', 0),
(50018992, '卫生纸', 8, 50012473, 2, ',50025705,50012473,50018992,', 1),
(50020217, '家用防油贴纸', 9, 50012473, 2, ',50025705,50012473,50020217,', 0),
(50020218, '吸油纸/膜', 10, 50012473, 2, ',50025705,50012473,50020218,', 0),
(213202, '洗发水', 5, 50012482, 2, ',50025705,50012482,213202,', 0),
(50016883, '护发素', 6, 50012482, 2, ',50025705,50012482,50016883,', 0),
(50024999, '发膜/护发产品', 8, 50012482, 2, ',50025705,50012482,50024999,', 0),
(50016885, '摩丝/啫喱/头发造型', 9, 50012482, 2, ',50025705,50012482,50016885,', 0),
(50008599, '洗面奶', 10, 50012482, 2, ',50025705,50012482,50008599,', 0),
(50024975, '洁面皂/洁面产品', 11, 50012482, 2, ',50025705,50012482,50024975,', 0),
(50022676, '爽肤水', 13, 50012482, 2, ',50025705,50012482,50022676,', 0),
(50022680, '剃须啫喱/剃须膏/剃须泡', 14, 50012482, 2, ',50025705,50012482,50022680,', 0),
(50022679, '面膜/眼膜', 15, 50012482, 2, ',50025705,50012482,50022679,', 1),
(213203, '牙膏', 19, 50012482, 2, ',50025705,50012482,213203,', 0),
(50024984, '牙粉/牙素', 20, 50012482, 2, ',50025705,50012482,50024984,', 0),
(50024985, '漱口水', 21, 50012482, 2, ',50025705,50012482,50024985,', 0),
(50024986, '口喷/脱色剂/美白剂', 22, 50012482, 2, ',50025705,50012482,50024986,', 0),
(50022682, '润唇膏', 24, 50012482, 2, ',50025705,50012482,50022682,', 0),
(50013976, '牙刷/口腔清洁工具', 25, 50012482, 2, ',50025705,50012482,50013976,', 0),
(213205, '沐浴露', 26, 50012482, 2, ',50025705,50012482,213205,', 0),
(50006280, '牙线/牙线棒', 26, 50012482, 2, ',50025705,50012482,50006280,', 0),
(50024980, '香皂', 27, 50012482, 2, ',50025705,50012482,50024980,', 0),
(50024981, '搓泥浴宝', 28, 50012482, 2, ',50025705,50012482,50024981,', 0),
(50024982, '泡澡浴盐/浴液/花瓣', 29, 50012482, 2, ',50025705,50012482,50024982,', 0),
(50024983, '身体磨砂膏/去角质膏', 31, 50012482, 2, ',50025705,50012482,50024983,', 0),
(50022681, '防晒霜', 33, 50012482, 2, ',50025705,50012482,50022681,', 0),
(50012923, '洗手液', 34, 50012482, 2, ',50025705,50012482,50012923,', 0),
(50022677, '护手霜', 35, 50012482, 2, ',50025705,50012482,50022677,', 0),
(50022686, '身体乳液', 37, 50012482, 2, ',50025705,50012482,50022686,', 0),
(50022687, '竹醋液/足贴/竹酢', 38, 50012482, 2, ',50025705,50012482,50022687,', 0),
(50011174, '痱子粉/爽身粉/花露水', 62, 50012482, 2, ',50025705,50012482,50011174,', 0),
(50011176, '清凉油/防暑/醒神药油', 67, 50012482, 2, ',50025705,50012482,50011176,', 0),
(50003820, '私处洗液', 68, 50012482, 2, ',50025705,50012482,50003820,', 0),
(50022685, '足浴盐/浴足剂/足部磨砂膏', 69, 50012482, 2, ',50025705,50012482,50022685,', 0),
(50022678, '护足霜', 70, 50012482, 2, ',50025705,50012482,50022678,', 0),
(50022674, '其他洗护清洁用品', 77, 50012482, 2, ',50025705,50012482,50022674,', 0),
(50014015, '管道疏通剂', 2, 50012487, 2, ',50025705,50012487,50014015,', 0),
(50014010, '马桶清洁剂/洁厕剂', 3, 50012487, 2, ',50025705,50012487,50014010,', 0),
(50014012, '洁瓷剂', 4, 50012487, 2, ',50025705,50012487,50014012,', 0),
(50014009, '洗洁精', 5, 50012487, 2, ',50025705,50012487,50014009,', 0),
(50014008, '消毒液', 6, 50012487, 2, ',50025705,50012487,50014008,', 0),
(50014014, '玻璃清洁剂', 7, 50012487, 2, ',50025705,50012487,50014014,', 0),
(50014011, '多用途清洁剂', 8, 50012487, 2, ',50025705,50012487,50014011,', 0),
(50010040, '油污清洁剂', 9, 50012487, 2, ',50025705,50012487,50010040,', 0),
(50023695, '布艺用品清洁剂', 30, 50012487, 2, ',50025705,50012487,50023695,', 0),
(50003951, '其它清洁用品', 31, 50012487, 2, ',50025705,50012487,50003951,', 0),
(50006966, '怀炉/怀炉用品', 3, 50012512, 2, ',21,50012512,50006966,', 1),
(50013958, '暖脚宝/暖垫', 12, 50012512, 2, ',21,50012512,50013958,', 0),
(50013959, '保暖贴', 13, 50012512, 2, ',21,50012512,50013959,', 0),
(50013960, '热水袋/暖手宝', 14, 50012512, 2, ',21,50012512,50013960,', 0),
(50000568, '其它保暖用品', 15, 50012512, 2, ',21,50012512,50000568,', 0),
(50025840, '保暖帽子', 16, 50012512, 2, ',21,50012512,50025840,', 0),
(50025841, '保暖围巾', 17, 50012512, 2, ',21,50012512,50025841,', 0),
(50025842, '保暖披肩', 18, 50012512, 2, ',21,50012512,50025842,', 0),
(50025843, '保暖手套', 19, 50012512, 2, ',21,50012512,50025843,', 0),
(50025844, '暖手贴', 20, 50012512, 2, ',21,50012512,50025844,', 0),
(50025845, '桌上暖垫', 21, 50012512, 2, ',21,50012512,50025845,', 0),
(50025846, '保暖鞋', 22, 50012512, 2, ',21,50012512,50025846,', 0),
(50025848, '发热鞋垫', 24, 50012512, 2, ',21,50012512,50025848,', 0),
(50025849, '暖风机', 25, 50012512, 2, ',21,50012512,50025849,', 0),
(50025850, '油汀', 26, 50012512, 2, ',21,50012512,50025850,', 0),
(50025851, '电热毯', 27, 50012512, 2, ',21,50012512,50025851,', 0),
(50003458, '口罩', 0, 50012514, 2, ',21,50012514,50003458,', 0),
(50006999, '护腕垫', 2, 50012514, 2, ',21,50012514,50006999,', 0),
(50007006, '眼罩', 11, 50012514, 2, ',21,50012514,50007006,', 0),
(50006125, '隔音耳塞', 12, 50012514, 2, ',21,50012514,50006125,', 0),
(50012515, '防护服', 13, 50012514, 2, ',21,50012514,50012515,', 0),
(50012516, '防护鞋', 14, 50012514, 2, ',21,50012514,50012516,', 0),
(50012517, '护目镜', 15, 50012514, 2, ',21,50012514,50012517,', 0),
(50012518, '防护面具', 16, 50012514, 2, ',21,50012514,50012518,', 0),
(50012519, '防护耳罩', 17, 50012514, 2, ',21,50012514,50012519,', 0),
(50012520, '防护手套', 18, 50012514, 2, ',21,50012514,50012520,', 0),
(50012521, '安全帽', 19, 50012514, 2, ',21,50012514,50012521,', 0),
(50006277, '其它劳保用品', 20, 50012514, 2, ',21,50012514,50006277,', 0),
(50023012, '头部防护用品', 30, 50012514, 2, ',21,50012514,50023012,', 0),
(50023013, '肩部防护用品', 31, 50012514, 2, ',21,50012514,50023013,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50023014, '胸部防护用品', 32, 50012514, 2, ',21,50012514,50023014,', 0),
(50023015, '腰部防护用品', 33, 50012514, 2, ',21,50012514,50023015,', 0),
(50023016, '肘部防护用品', 34, 50012514, 2, ',21,50012514,50023016,', 0),
(50023017, '腕部防护用品', 35, 50012514, 2, ',21,50012514,50023017,', 0),
(50023018, '手部防护用品', 36, 50012514, 2, ',21,50012514,50023018,', 0),
(50023019, '腿部防护用品', 37, 50012514, 2, ',21,50012514,50023019,', 0),
(50023020, '膝部防护用品', 38, 50012514, 2, ',21,50012514,50023020,', 0),
(50025828, '其它', 39, 50012514, 2, ',21,50012514,50025828,', 0),
(50013961, '护膝/护腰/护肩/护颈', 40, 50012514, 2, ',21,50012514,50013961,', 0),
(50012622, '感光鼓芯', 0, 50012601, 2, ',50007218,50012601,50012622,', 0),
(50012623, '计数芯片', 1, 50012601, 2, ',50007218,50012601,50012623,', 0),
(50012624, '喷头/打印头', 2, 50012601, 2, ',50007218,50012601,50012624,', 0),
(50012625, '定影膜', 3, 50012601, 2, ',50007218,50012601,50012625,', 0),
(50012626, '搓纸轮', 4, 50012601, 2, ',50007218,50012601,50012626,', 0),
(50012627, '主板', 5, 50012601, 2, ',50007218,50012601,50012627,', 0),
(50012628, '定影下辊', 6, 50012601, 2, ',50007218,50012601,50012628,', 0),
(50012629, '分页器', 7, 50012601, 2, ',50007218,50012601,50012629,', 0),
(50012630, '激光器', 8, 50012601, 2, ',50007218,50012601,50012630,', 0),
(50012631, '定影上辊', 9, 50012601, 2, ',50007218,50012601,50012631,', 0),
(50012632, '接口板', 10, 50012601, 2, ',50007218,50012601,50012632,', 0),
(50012633, '电源板', 11, 50012601, 2, ',50007218,50012601,50012633,', 0),
(50012634, '电源', 12, 50012601, 2, ',50007218,50012601,50012634,', 0),
(50012635, '定影齿轮', 13, 50012601, 2, ',50007218,50012601,50012635,', 0),
(50012636, '下辊轴套', 14, 50012601, 2, ',50007218,50012601,50012636,', 0),
(50012637, '定影灯管', 15, 50012601, 2, ',50007218,50012601,50012637,', 0),
(50012638, '传感器', 16, 50012601, 2, ',50007218,50012601,50012638,', 0),
(50012639, '摆轮', 17, 50012601, 2, ',50007218,50012601,50012639,', 0),
(50012640, '上辊轴套', 18, 50012601, 2, ',50007218,50012601,50012640,', 0),
(50012641, '转印辊', 19, 50012601, 2, ',50007218,50012601,50012641,', 0),
(50012642, '上导电辊', 20, 50012601, 2, ',50007218,50012601,50012642,', 0),
(50012643, '出纸杆', 21, 50012601, 2, ',50007218,50012601,50012643,', 0),
(50012644, '其它', 22, 50012601, 2, ',50007218,50012601,50012644,', 0),
(50006267, '照片冲印设备', 23, 50012601, 2, ',50007218,50012601,50006267,', 0),
(50018855, '打印服务器', 127, 50012601, 2, ',50007218,50012601,50018855,', 0),
(50019241, '连续供墨系统', 133, 50012601, 2, ',50007218,50012601,50019241,', 0),
(50012646, '资料册', 0, 50012645, 2, ',50018004,50012645,50012646,', 0),
(50001879, '笔筒/座/插/架', 1, 50012645, 2, ',50018004,50012645,50001879,', 0),
(50012648, '文件夹/文件套/文件袋', 2, 50012645, 2, ',50018004,50012645,50012648,', 0),
(50012649, '文件座/文件架/文件框', 3, 50012645, 2, ',50018004,50012645,50012649,', 0),
(50004418, '便条夹/照片夹', 4, 50012645, 2, ',50018004,50012645,50004418,', 0),
(50005912, '便签盒/座', 4, 50012645, 2, ',50018004,50012645,50005912,', 0),
(50012650, '桌面文件柜', 4, 50012645, 2, ',50018004,50012645,50012650,', 0),
(50005914, '名片盒/本/夹', 6, 50012645, 2, ',50018004,50012645,50005914,', 0),
(50012655, '档案盒/袋', 6, 50012645, 2, ',50018004,50012645,50012655,', 0),
(50012660, '书报架/展示架', 7, 50012645, 2, ',50018004,50012645,50012660,', 0),
(50005114, '书立/阅读架', 7, 50012645, 2, ',50018004,50012645,50005114,', 0),
(50012665, '风琴包/事务包', 8, 50012645, 2, ',50018004,50012645,50012665,', 0),
(50012667, '挂快劳/快劳夹', 10, 50012645, 2, ',50018004,50012645,50012667,', 0),
(50012668, '卡套/证件套', 11, 50012645, 2, ',50018004,50012645,50012668,', 0),
(50012669, 'CD册', 12, 50012645, 2, ',50018004,50012645,50012669,', 0),
(50012670, '相册', 13, 50012645, 2, ',50018004,50012645,50012670,', 0),
(50012671, '其它', 14, 50012645, 2, ',50018004,50012645,50012671,', 0),
(50024651, '意见箱/抽奖箱/信件箱', 15, 50012645, 2, ',50018004,50012645,50024651,', 0),
(50012677, '笔记本/记事本', 1, 50012676, 2, ',50018004,50012676,50012677,', 0),
(50012679, '硬面抄（商品请放在笔记本/记事本）', 3, 50012676, 2, ',50018004,50012676,50012679,', 0),
(50012681, '日记本', 4, 50012676, 2, ',50018004,50012676,50012681,', 0),
(50005823, '书签', 5, 50012676, 2, ',50018004,50012676,50005823,', 0),
(50012783, '同学录/纪念册', 8, 50012676, 2, ',50018004,50012676,50012783,', 0),
(50012684, '便签本/便条纸/N次贴', 11, 50012676, 2, ',50018004,50012676,50012684,', 0),
(50012685, '贴纸/磁贴', 12, 50012676, 2, ',50018004,50012676,50012685,', 0),
(50012687, '信封/信纸', 14, 50012676, 2, ',50018004,50012676,50012687,', 0),
(50012689, '不干胶标签', 16, 50012676, 2, ',50018004,50012676,50012689,', 0),
(50012691, '通讯录/电话本', 18, 50012676, 2, ',50018004,50012676,50012691,', 0),
(50012692, '奖状/证书', 19, 50012676, 2, ',50018004,50012676,50012692,', 0),
(50013851, '活页替芯', 22, 50012676, 2, ',50018004,50012676,50013851,', 0),
(50014809, 'POP广告纸/爆炸贴', 23, 50012676, 2, ',50018004,50012676,50014809,', 0),
(50012695, '文稿纸/草稿纸', 27, 50012676, 2, ',50018004,50012676,50012695,', 0),
(50012702, '分页纸/索引纸', 34, 50012676, 2, ',50018004,50012676,50012702,', 0),
(50012705, '复写纸', 37, 50012676, 2, ',50018004,50012676,50012705,', 0),
(50012707, '包装纸', 39, 50012676, 2, ',50018004,50012676,50012707,', 0),
(50012708, '其它纸品', 40, 50012676, 2, ',50018004,50012676,50012708,', 0),
(50024635, '课业本/教学用本', 41, 50012676, 2, ',50018004,50012676,50024635,', 0),
(50024636, '折纸/手工纸', 42, 50012676, 2, ',50018004,50012676,50024636,', 0),
(50012227, '布尿裤', 4, 50012711, 2, ',50014812,50012711,50012227,', 0),
(50012530, '隔尿垫巾', 5, 50012711, 2, ',50014812,50012711,50012530,', 0),
(50015709, '隔尿床垫', 6, 50012711, 2, ',50014812,50012711,50015709,', 0),
(50012531, '纱布尿布', 7, 50012711, 2, ',50014812,50012711,50012531,', 0),
(50012712, '尿布带', 8, 50012711, 2, ',50014812,50012711,50012712,', 0),
(50012714, '其它', 9, 50012711, 2, ',50014812,50012711,50012714,', 0),
(50012717, '钢笔', 0, 50012716, 2, ',50018004,50012716,50012717,', 0),
(50012718, '圆珠笔', 1, 50012716, 2, ',50018004,50012716,50012718,', 0),
(50012719, '宝珠/走珠/签字笔', 3, 50012716, 2, ',50018004,50012716,50012719,', 0),
(50012720, '中性笔', 4, 50012716, 2, ',50018004,50012716,50012720,', 0),
(50012721, '马克笔', 7, 50012716, 2, ',50018004,50012716,50012721,', 0),
(50012722, '记号笔', 8, 50012716, 2, ',50018004,50012716,50012722,', 0),
(50012725, '荧光笔', 11, 50012716, 2, ',50018004,50012716,50012725,', 0),
(50012726, '油漆笔', 13, 50012716, 2, ',50018004,50012716,50012726,', 0),
(50012727, '针管笔', 14, 50012716, 2, ',50018004,50012716,50012727,', 0),
(50012750, '笔用墨水/补充液/墨囊', 22, 50012716, 2, ',50018004,50012716,50012750,', 0),
(50012751, '替芯/铅芯', 23, 50012716, 2, ',50018004,50012716,50012751,', 0),
(50012767, '其它功能笔', 24, 50012716, 2, ',50018004,50012716,50012767,', 0),
(50024639, '正姿笔', 26, 50012716, 2, ',50018004,50012716,50024639,', 0),
(50024640, '泡泡笔', 27, 50012716, 2, ',50018004,50012716,50024640,', 0),
(50024657, '铅笔', 28, 50012716, 2, ',50018004,50012716,50024657,', 0),
(50003114, '避孕套', 0, 50012829, 2, ',2813,50012829,50003114,', 0),
(50012831, '早孕试纸', 1, 50012829, 2, ',2813,50012829,50012831,', 0),
(50012832, '排卵试纸', 2, 50012829, 2, ',2813,50012829,50012832,', 0),
(50012830, '体温计/仪器', 3, 50012829, 2, ',2813,50012829,50012830,', 0),
(50006275, '其它', 4, 50012829, 2, ',2813,50012829,50006275,', 0),
(50012840, 'PS游戏软件', 1, 50012834, 2, ',20,50012834,50012840,', 0),
(50012835, 'PC游戏软件', 2, 50012834, 2, ',20,50012834,50012835,', 0),
(50012836, 'WII游戏软件', 3, 50012834, 2, ',20,50012834,50012836,', 0),
(50012837, 'PSP游戏软件', 4, 50012834, 2, ',20,50012834,50012837,', 0),
(50012838, 'XBOX游戏软件', 5, 50012834, 2, ',20,50012834,50012838,', 0),
(50012839, 'NDSL游戏软件', 6, 50012834, 2, ',20,50012834,50012839,', 0),
(50003437, '其它游戏软件', 7, 50012834, 2, ',20,50012834,50003437,', 0),
(50012852, '国内旅游度假/自由行', 4, 50012849, 2, ',50025707,50012849,50012852,', 0),
(50012854, '出境旅游度假/自由行', 10, 50012849, 2, ',50025707,50012849,50012854,', 0),
(50016071, '签证（通行证）', 11, 50012849, 2, ',50025707,50012849,50016071,', 0),
(50014468, '导游', 12, 50012849, 2, ',50025707,50012849,50014468,', 0),
(50012881, '国画', 0, 50012880, 2, ',23,50012880,50012881,', 0),
(50012882, '书法', 1, 50012880, 2, ',23,50012880,50012882,', 0),
(50012883, '年画', 2, 50012880, 2, ',23,50012880,50012883,', 0),
(50012884, '碑帖', 3, 50012880, 2, ',23,50012880,50012884,', 0),
(50012885, '版画', 4, 50012880, 2, ',23,50012880,50012885,', 0),
(50012886, '画框定制', 5, 50012880, 2, ',23,50012880,50012886,', 0),
(50012913, '酒店优惠券', 1, 50012910, 2, ',50025707,50012910,50012913,', 0),
(50012914, '旅行电话卡', 3, 50012910, 2, ',50025707,50012910,50012914,', 0),
(50025875, '本地游购与服务', 5, 50012910, 2, ',50025707,50012910,50025875,', 1),
(50014471, '餐饮（自助、BBQ）/娱乐', 6, 50012910, 2, ',50025707,50012910,50014471,', 0),
(50018112, '旅行社/网站优惠券', 11, 50012910, 2, ',50025707,50012910,50018112,', 0),
(50012762, '港澳送关服务', 13, 50012910, 2, ',50025707,50012910,50012762,', 0),
(50018322, '高尔夫', 14, 50012910, 2, ',50025707,50012910,50018322,', 0),
(50024215, '购物折扣卡券', 16, 50012910, 2, ',50025707,50012910,50024215,', 0),
(50025831, '旅游年票/一卡通/年卡', 18, 50012910, 2, ',50025707,50012910,50025831,', 0),
(50026091, '国外火车票', 19, 50012910, 2, ',50025707,50012910,50026091,', 0),
(50025874, '其他预订', 20, 50012910, 2, ',50025707,50012910,50025874,', 0),
(50018113, '其它', 21, 50012910, 2, ',50025707,50012910,50018113,', 0),
(50026528, '丽江9元卡', 22, 50012910, 2, ',50025707,50012910,50026528,', 0),
(50012938, '乒乓球', 0, 50012937, 2, ',50010728,50012937,50012938,', 0),
(50012940, '乒乓球成品拍', 1, 50012937, 2, ',50010728,50012937,50012940,', 0),
(50012939, '乒乓底板', 2, 50012937, 2, ',50010728,50012937,50012939,', 0),
(50012942, '乒乓套胶/海绵/单胶片', 4, 50012937, 2, ',50010728,50012937,50012942,', 0),
(50012947, '乒乓球台', 5, 50012937, 2, ',50010728,50012937,50012947,', 0),
(50017579, '乒乓球网架/网', 6, 50012937, 2, ',50010728,50012937,50017579,', 0),
(50012945, '乒乓球服', 7, 50012937, 2, ',50010728,50012937,50012945,', 0),
(50012946, '乒乓球鞋', 8, 50012937, 2, ',50010728,50012937,50012946,', 0),
(50019222, '乒乓球袜', 9, 50012937, 2, ',50010728,50012937,50019222,', 0),
(50012941, '乒乓球拍套/包', 10, 50012937, 2, ',50010728,50012937,50012941,', 0),
(50012943, '粘合剂/胶水', 12, 50012937, 2, ',50010728,50012937,50012943,', 0),
(50017580, '乒乓球保养/清洁装备', 16, 50012937, 2, ',50010728,50012937,50017580,', 0),
(50012948, '乒乓球发球机', 18, 50012937, 2, ',50010728,50012937,50012948,', 0),
(50019705, '乒乓球捡球器', 19, 50012937, 2, ',50010728,50012937,50019705,', 0),
(50019706, '乒乓球挡板', 20, 50012937, 2, ',50010728,50012937,50019706,', 0),
(50019708, '乒乓球盒', 21, 50012937, 2, ',50010728,50012937,50019708,', 0),
(50019709, '计分器/翻分牌', 22, 50012937, 2, ',50010728,50012937,50019709,', 0),
(50012949, '更多乒乓球配件', 23, 50012937, 2, ',50010728,50012937,50012949,', 0),
(50013008, '电饭煲', 0, 50012959, 2, ',50012082,50012959,50013008,', 0),
(50013009, '电压力锅', 1, 50012959, 2, ',50012082,50012959,50013009,', 0),
(50013010, '电蒸锅', 2, 50012959, 2, ',50012082,50012959,50013010,', 0),
(50013011, '电炖/煮粥锅/文火炉', 3, 50012959, 2, ',50012082,50012959,50013011,', 0),
(50012960, '电热/火锅', 4, 50012959, 2, ',50012082,50012959,50012960,', 0),
(50012982, '山核桃', 1, 50012981, 2, ',50002766,50012981,50012982,', 0),
(50012983, '长寿果/碧根果', 2, 50012981, 2, ',50002766,50012981,50012983,', 0),
(50012985, '核桃', 4, 50012981, 2, ',50002766,50012981,50012985,', 0),
(50012986, '开心果', 5, 50012981, 2, ',50002766,50012981,50012986,', 0),
(50012987, '夏威夷果', 6, 50012981, 2, ',50002766,50012981,50012987,', 0),
(50012988, '香榧', 7, 50012981, 2, ',50002766,50012981,50012988,', 0),
(50012989, '松子', 8, 50012981, 2, ',50002766,50012981,50012989,', 0),
(50012990, '鲍鱼果', 9, 50012981, 2, ',50002766,50012981,50012990,', 0),
(50012991, '瓜子', 10, 50012981, 2, ',50002766,50012981,50012991,', 0),
(50012992, '榛子', 11, 50012981, 2, ',50002766,50012981,50012992,', 0),
(50016429, '豆类制品', 12, 50012981, 2, ',50002766,50012981,50016429,', 0),
(50012993, '栗类制品', 13, 50012981, 2, ',50002766,50012981,50012993,', 0),
(50012994, '核桃仁', 14, 50012981, 2, ',50002766,50012981,50012994,', 0),
(50012995, '薄皮/纸皮核桃', 15, 50012981, 2, ',50002766,50012981,50012995,', 0),
(50012996, '花生', 16, 50012981, 2, ',50002766,50012981,50012996,', 0),
(50012997, '腰果', 17, 50012981, 2, ',50002766,50012981,50012997,', 0),
(50012998, '杏仁', 18, 50012981, 2, ',50002766,50012981,50012998,', 0),
(50012999, '白果/银杏果', 19, 50012981, 2, ',50002766,50012981,50012999,', 0),
(50013000, '小银杏', 20, 50012981, 2, ',50002766,50012981,50013000,', 0),
(50013001, '巴旦木', 21, 50012981, 2, ',50002766,50012981,50013001,', 0),
(50008059, '其它', 22, 50012981, 2, ',50002766,50012981,50008059,', 0),
(50008363, '香肠/热狗机', 0, 50013021, 2, ',50012082,50013021,50008363,', 0),
(50013043, '展示柜', 1, 50013021, 2, ',50012082,50013021,50013043,', 0),
(50013046, '商用咖啡机', 2, 50013021, 2, ',50012082,50013021,50013046,', 0),
(50013048, '商用消毒柜', 3, 50013021, 2, ',50012082,50013021,50013048,', 0),
(50013022, '商用面条/轧面机', 4, 50013021, 2, ',50012082,50013021,50013022,', 0),
(50013023, '商用冰淇淋/甜筒/雪糕机', 5, 50013021, 2, ',50012082,50013021,50013023,', 0),
(50008365, '磨粉机/药材粉碎机', 6, 50013021, 2, ',50012082,50013021,50008365,', 0),
(50013024, '冷饮/饮料机', 7, 50013021, 2, ',50012082,50013021,50013024,', 0),
(50013050, '商用豆浆机', 8, 50013021, 2, ',50012082,50013021,50013050,', 0),
(50013025, '商用爆米花机', 9, 50013021, 2, ',50012082,50013021,50013025,', 0),
(50013041, '棉花糖机', 10, 50013021, 2, ',50012082,50013021,50013041,', 0),
(50013027, '商用炸锅', 11, 50013021, 2, ',50012082,50013021,50013027,', 0),
(50013028, '商用打蛋搅拌机', 12, 50013021, 2, ',50012082,50013021,50013028,', 0),
(50013029, '商用烤饼机', 13, 50013021, 2, ',50012082,50013021,50013029,', 0),
(50013030, '扒炉/铁板烧/手抓饼炉', 14, 50013021, 2, ',50012082,50013021,50013030,', 0),
(50013040, '关东煮机', 15, 50013021, 2, ',50012082,50013021,50013040,', 0),
(50013044, '章鱼丸机/鱼丸炉', 16, 50013021, 2, ',50012082,50013021,50013044,', 0),
(50013047, '商用烘烤炉/烤箱', 17, 50013021, 2, ',50012082,50013021,50013047,', 0),
(50013031, '商用切片机/切肉机', 18, 50013021, 2, ',50012082,50013021,50013031,', 0),
(50013033, '刨冰/碎冰/冰沙机', 19, 50013021, 2, ',50012082,50013021,50013033,', 0),
(50013032, '商用制冰机', 20, 50013021, 2, ',50012082,50013021,50013032,', 0),
(50013034, '炒冰/冰粥机', 22, 50013021, 2, ',50012082,50013021,50013034,', 0),
(50013038, '封口/封杯机', 23, 50013021, 2, ',50012082,50013021,50013038,', 0),
(50013049, '商用电磁炉', 24, 50013021, 2, ',50012082,50013021,50013049,', 0),
(50013042, '蒸炉/蒸包炉', 25, 50013021, 2, ',50012082,50013021,50013042,', 0),
(50013045, '和面机', 26, 50013021, 2, ',50012082,50013021,50013045,', 0),
(50013036, '肠粉机', 27, 50013021, 2, ',50012082,50013021,50013036,', 0),
(50013051, '商用净水设备', 28, 50013021, 2, ',50012082,50013021,50013051,', 0),
(50013026, '其他商用厨电', 29, 50013021, 2, ',50012082,50013021,50013026,', 0),
(50013062, '芭蕉干', 2, 50013061, 2, ',50002766,50013061,50013062,', 0),
(50013063, '菠萝蜜', 3, 50013061, 2, ',50002766,50013061,50013063,', 0),
(50013152, '香蕉干/片', 4, 50013061, 2, ',50002766,50013061,50013152,', 0),
(50013064, '草莓干', 5, 50013061, 2, ',50002766,50013061,50013064,', 0),
(50013065, '车厘子', 6, 50013061, 2, ',50002766,50013061,50013065,', 0),
(50013066, '陈皮', 7, 50013061, 2, ',50002766,50013061,50013066,', 0),
(50013067, '薯类制品', 8, 50013061, 2, ',50002766,50013061,50013067,', 0),
(50013068, '菠萝/凤梨干', 9, 50013061, 2, ',50002766,50013061,50013068,', 0),
(50013069, '佛手果', 10, 50013061, 2, ',50002766,50013061,50013069,', 0),
(50013070, '哈密瓜', 11, 50013061, 2, ',50002766,50013061,50013070,', 0),
(50013071, '南瓜干', 12, 50013061, 2, ',50002766,50013061,50013071,', 0),
(50013072, '海棠果', 13, 50013061, 2, ',50002766,50013061,50013072,', 0),
(50013073, '黄皮', 14, 50013061, 2, ',50002766,50013061,50013073,', 0),
(50013074, '加应子/李子', 15, 50013061, 2, ',50002766,50013061,50013074,', 0),
(50013075, '金桔类制品', 16, 50013061, 2, ',50002766,50013061,50013075,', 0),
(50013076, '蓝莓', 17, 50013061, 2, ',50002766,50013061,50013076,', 0),
(50013077, '李子', 18, 50013061, 2, ',50002766,50013061,50013077,', 0),
(50013078, '榴莲干', 19, 50013061, 2, ',50002766,50013061,50013078,', 0),
(50013079, '罗汉果', 20, 50013061, 2, ',50002766,50013061,50013079,', 0),
(50013080, '芒果干', 21, 50013061, 2, ',50002766,50013061,50013080,', 0),
(50013081, '玫瑰花脯', 22, 50013061, 2, ',50002766,50013061,50013081,', 0),
(50013082, '梅类制品', 23, 50013061, 2, ',50002766,50013061,50013082,', 0),
(50013083, '木瓜', 24, 50013061, 2, ',50002766,50013061,50013083,', 0),
(50013084, '苹果干', 25, 50013061, 2, ',50002766,50013061,50013084,', 0),
(50013085, '葡萄干', 26, 50013061, 2, ',50002766,50013061,50013085,', 0),
(50013086, '桑椹干', 27, 50013061, 2, ',50002766,50013061,50013086,', 0),
(50013087, '山楂类制品', 28, 50013061, 2, ',50002766,50013061,50013087,', 0),
(50013088, '圣女果干', 29, 50013061, 2, ',50002766,50013061,50013088,', 0),
(50013089, '柿饼', 30, 50013061, 2, ',50002766,50013061,50013089,', 0),
(50013090, '蔬果干', 31, 50013061, 2, ',50002766,50013061,50013090,', 0),
(50013091, '酸角', 32, 50013061, 2, ',50002766,50013061,50013091,', 0),
(50013092, '笋类制品', 33, 50013061, 2, ',50002766,50013061,50013092,', 0),
(50013093, '桃干', 34, 50013061, 2, ',50002766,50013061,50013093,', 0),
(50013094, '无花果干', 35, 50013061, 2, ',50002766,50013061,50013094,', 0),
(50013095, '杏仁/杏干', 36, 50013061, 2, ',50002766,50013061,50013095,', 0),
(50013096, '椰子片', 37, 50013061, 2, ',50002766,50013061,50013096,', 0),
(50013097, '樱桃', 38, 50013061, 2, ',50002766,50013061,50013097,', 0),
(50013098, '芋头条', 39, 50013061, 2, ',50002766,50013061,50013098,', 0),
(50013099, '枣类制品', 40, 50013061, 2, ',50002766,50013061,50013099,', 0),
(50013100, '猕猴桃干', 41, 50013061, 2, ',50002766,50013061,50013100,', 0),
(50013101, '柚脯/柚干', 42, 50013061, 2, ',50002766,50013061,50013101,', 0),
(50013102, '槟榔', 43, 50013061, 2, ',50002766,50013061,50013102,', 0),
(50013103, '橄榄', 44, 50013061, 2, ',50002766,50013061,50013103,', 0),
(50008058, '其它', 45, 50013061, 2, ',50002766,50013061,50008058,', 0),
(50006076, '自行车', 5, 50013198, 2, ',25,50013198,50006076,', 0),
(50006077, '儿童电动车', 6, 50013198, 2, ',25,50013198,50006077,', 0),
(50008691, '溜冰鞋/旱冰鞋', 6, 50013198, 2, ',25,50013198,50008691,', 0),
(50006078, '三轮车', 7, 50013198, 2, ',25,50013198,50006078,', 0),
(50006079, '滑板车', 8, 50013198, 2, ',25,50013198,50006079,', 0),
(50006082, '扭扭车', 10, 50013198, 2, ',25,50013198,50006082,', 0),
(50011760, '童车配件', 16, 50013198, 2, ',25,50013198,50011760,', 0),
(50006083, '其它', 17, 50013198, 2, ',25,50013198,50006083,', 0),
(50023710, '滑板/活力板', 18, 50013198, 2, ',25,50013198,50023710,', 0),
(50023723, '头盔/安全护具', 19, 50013198, 2, ',25,50013198,50023723,', 0),
(50023759, '踏行车/滑行学步车', 20, 50013198, 2, ',25,50013198,50023759,', 0),
(50013203, '篮球', 0, 50013202, 2, ',50010728,50013202,50013203,', 0),
(50013204, '篮球服', 1, 50013202, 2, ',50010728,50013202,50013204,', 0),
(50017267, '篮球板', 5, 50013202, 2, ',50010728,50013202,50017267,', 0),
(50013214, '篮球架/篮球框', 6, 50013202, 2, ',50010728,50013202,50013214,', 0),
(50017268, '篮球网', 7, 50013202, 2, ',50010728,50013202,50017268,', 0),
(50017240, '裁判/教练用品', 16, 50013202, 2, ',50010728,50013202,50017240,', 1),
(50017246, '篮球球迷用品', 17, 50013202, 2, ',50010728,50013202,50017246,', 0),
(50017261, '篮球袜/鞋垫', 18, 50013202, 2, ',50010728,50013202,50017261,', 0),
(50017265, '篮球充气设备', 20, 50013202, 2, ',50010728,50013202,50017265,', 0),
(50017266, '篮球包/篮球袋', 21, 50013202, 2, ',50010728,50013202,50017266,', 0),
(50013210, '更多篮球用品', 22, 50013202, 2, ',50010728,50013202,50013210,', 0),
(50013310, '其它光源', 1, 50013217, 2, ',27,50013217,50013310,', 0),
(50024680, '白炽灯', 7, 50013217, 2, ',27,50013217,50024680,', 0),
(50024681, '卤钨灯', 8, 50013217, 2, ',27,50013217,50024681,', 0),
(50024682, '荧光灯', 9, 50013217, 2, ',27,50013217,50024682,', 1),
(50024683, 'LED光源', 10, 50013217, 2, ',27,50013217,50024683,', 1),
(261704, '车用便捷式GPS导航', 0, 50018720, 2, ',26,50018720,261704,', 0),
(50005818, 'DVD导航', 1, 50018720, 2, ',26,50018720,50005818,', 0),
(50010726, 'GPS支架', 3, 50018720, 2, ',26,50018720,50010726,', 0),
(50010727, 'GPS充电器', 4, 50018720, 2, ',26,50018720,50010727,', 0),
(50014544, 'GPS模块', 15, 50018720, 2, ',26,50018720,50014544,', 0),
(50005110, 'GPS其他配件', 16, 50018720, 2, ',26,50018720,50005110,', 0),
(50022746, '后视镜导航GPS', 18, 50018720, 2, ',26,50018720,50022746,', 0),
(50022747, 'GPS导航软件', 19, 50018720, 2, ',26,50018720,50022747,', 0),
(50022748, '其它GPS导航相关产品', 20, 50018720, 2, ',26,50018720,50022748,', 0),
(50014611, '车用水桶', 0, 50018772, 2, ',26,50018772,50014611,', 0),
(50018715, '车用清洗/除蜡/除胶剂', 0, 50018772, 2, ',26,50018772,50018715,', 0),
(50018773, '车用洗车机/设备', 1, 50018772, 2, ',26,50018772,50018773,', 0),
(50010625, '车掸/蜡拖', 2, 50018772, 2, ',26,50018772,50010625,', 0),
(50006855, '擦车巾', 6, 50018772, 2, ',26,50018772,50006855,', 0),
(50010626, '洗车水枪', 7, 50018772, 2, ',26,50018772,50010626,', 0),
(50011457, '洗车海绵/洗车泥', 10, 50018772, 2, ',26,50018772,50011457,', 0),
(50015860, '车刷', 12, 50018772, 2, ',26,50018772,50015860,', 0),
(50015877, '汽车清洗手套', 15, 50018772, 2, ',26,50018772,50015877,', 0),
(50016248, '清洁一次性用品', 16, 50018772, 2, ',26,50018772,50016248,', 0),
(50014597, '其它车用清洗工具/用品', 17, 50018772, 2, ',26,50018772,50014597,', 0),
(50022886, '洗车水管接头', 18, 50018772, 2, ',26,50018772,50022886,', 0),
(50018598, '菜粉/水果粉', 0, 50018801, 2, ',35,50018801,50018598,', 0),
(50006825, '米粉/米糊/汤粥', 7, 50018801, 2, ',35,50018801,50006825,', 0),
(50018597, '果泥/菜泥/肉泥', 78, 50018801, 2, ',35,50018801,50018597,', 0),
(50018802, '面条', 79, 50018801, 2, ',35,50018801,50018802,', 0),
(50018803, '肉松/鱼松', 80, 50018801, 2, ',35,50018801,50018803,', 0),
(50018804, '果汁/饮品', 81, 50018801, 2, ',35,50018801,50018804,', 0),
(50018806, '磨牙棒/饼干', 82, 50018801, 2, ',35,50018801,50018806,', 0),
(50018809, '牛初乳', 0, 50018808, 2, ',35,50018808,50018809,', 0),
(50018811, '益生菌', 1, 50018808, 2, ',35,50018808,50018811,', 0),
(50018812, 'DHA/核桃油', 2, 50018808, 2, ',35,50018808,50018812,', 0),
(50018836, '鱼肝油', 3, 50018808, 2, ',35,50018808,50018836,', 0),
(50018837, '清火/奶伴侣/营养伴侣', 4, 50018808, 2, ',35,50018808,50018837,', 0),
(50018840, '葡萄糖', 6, 50018808, 2, ',35,50018808,50018840,', 0),
(50005772, '蛋白粉', 9, 50018808, 2, ',35,50018808,50005772,', 0),
(50016097, '钙铁锌', 74, 50018808, 2, ',35,50018808,50016097,', 0),
(50016098, '维生素', 75, 50018808, 2, ',35,50018808,50016098,', 0),
(50018910, 'MSN聊天伴侣', 0, 50018909, 2, ',50008090,50018909,50018910,', 0),
(110219, 'USB HUB/转换器', 11, 50018909, 2, ',50008090,50018909,110219,', 0),
(50018912, 'USB Humping Dog', 12, 50018909, 2, ',50008090,50018909,50018912,', 0),
(50018913, 'USB按摩器', 13, 50018909, 2, ',50008090,50018909,50018913,', 0),
(50018914, 'USB摆设品/装饰品', 14, 50018909, 2, ',50008090,50018909,50018914,', 0),
(50018915, 'USB保暖坐垫/靠垫', 15, 50018909, 2, ',50008090,50018909,50018915,', 0),
(50018916, 'USB保温碟/保温垫', 16, 50018909, 2, ',50008090,50018909,50018916,', 0),
(50018917, 'USB灯', 17, 50018909, 2, ',50008090,50018909,50018917,', 0),
(50018918, 'USB电话机/网络电话机', 18, 50018909, 2, ',50008090,50018909,50018918,', 0),
(50018919, 'USB电脑锁/防盗器', 19, 50018909, 2, ',50008090,50018909,50018919,', 0),
(50018920, 'USB多功能数码宝', 20, 50018909, 2, ',50008090,50018909,50018920,', 0),
(50018921, 'USB翻页激光笔', 21, 50018909, 2, ',50008090,50018909,50018921,', 0),
(50018922, 'USB风扇', 22, 50018909, 2, ',50008090,50018909,50018922,', 0),
(50018923, 'USB加湿器', 23, 50018909, 2, ',50008090,50018909,50018923,', 0),
(50018924, 'USB迷你冰箱', 24, 50018909, 2, ',50008090,50018909,50018924,', 0),
(50018925, 'USB暖手宝/暖手袋', 25, 50018909, 2, ',50008090,50018909,50018925,', 0),
(50018926, 'USB暖手鼠标垫', 26, 50018909, 2, ',50008090,50018909,50018926,', 0),
(50018927, 'USB暖手套/暖脚鞋', 27, 50018909, 2, ',50008090,50018909,50018927,', 0),
(50018928, 'USB食品加热包/保温盒', 28, 50018909, 2, ',50008090,50018909,50018928,', 0),
(50018929, 'USB碎纸机', 29, 50018909, 2, ',50008090,50018909,50018929,', 0),
(50018930, 'USB吸尘器', 30, 50018909, 2, ',50008090,50018909,50018930,', 0),
(50018931, 'USB烟灰缸', 31, 50018909, 2, ',50008090,50018909,50018931,', 0),
(50018936, 'USB延长线', 32, 50018909, 2, ',50008090,50018909,50018936,', 0),
(50018932, 'USB氧吧/空气清新器', 33, 50018909, 2, ',50008090,50018909,50018932,', 0),
(50018934, 'USB驱蚊器', 34, 50018909, 2, ',50008090,50018909,50018934,', 0),
(50018935, '其它USB周边设备', 35, 50018909, 2, ',50008090,50018909,50018935,', 0),
(50018961, '干燥剂', 0, 50018960, 2, ',50025705,50018960,50018961,', 0),
(50018962, '冰箱除味剂', 1, 50018960, 2, ',50025705,50018960,50018962,', 0),
(50018963, '甲醛清除剂/甲醛测试', 2, 50018960, 2, ',50025705,50018960,50018963,', 1),
(50018964, '空气芳香剂', 3, 50018960, 2, ',50025705,50018960,50018964,', 0),
(50018972, '地板护理日化用品', 0, 50018971, 2, ',50025705,50018971,50018972,', 0),
(50018973, '家私护理日化品', 1, 50018971, 2, ',50025705,50018971,50018973,', 0),
(50018974, '鞋油', 2, 50018971, 2, ',50025705,50018971,50018974,', 0),
(50018981, '洗衣皂', 0, 50018975, 2, ',50025705,50018975,50018981,', 0),
(50018976, '洗衣粉', 1, 50018975, 2, ',50025705,50018975,50018976,', 0),
(50018977, '洗衣液', 2, 50018975, 2, ',50025705,50018975,50018977,', 0),
(50018978, '衣领净', 3, 50018975, 2, ',50025705,50018975,50018978,', 0),
(50018983, '衣物柔顺剂', 7, 50018975, 2, ',50025705,50018975,50018983,', 0),
(50018982, '干洗剂', 8, 50018975, 2, ',50025705,50018975,50018982,', 0),
(50019000, '漂白剂', 11, 50018975, 2, ',50025705,50018975,50019000,', 0),
(50019001, '彩漂', 12, 50018975, 2, ',50025705,50018975,50019001,', 0),
(50019117, '迷彩服/军迷服/作训服', 0, 50019007, 2, ',50013886,50019007,50019117,', 1),
(50019118, '军迷鞋靴', 1, 50019007, 2, ',50013886,50019007,50019118,', 1),
(50019119, '军迷配饰', 2, 50019007, 2, ',50013886,50019007,50019119,', 1),
(50019122, '军迷包具', 3, 50019007, 2, ',50013886,50019007,50019122,', 1),
(50019085, '演唱会', 0, 50019084, 2, ',50025110,50019084,50019085,', 0),
(50019087, '音乐会', 2, 50019084, 2, ',50025110,50019084,50019087,', 0),
(50019088, '话剧', 3, 50019084, 2, ',50025110,50019084,50019088,', 0),
(50019089, '音乐剧/歌剧', 4, 50019084, 2, ',50025110,50019084,50019089,', 0),
(50019090, '舞蹈', 5, 50019084, 2, ',50025110,50019084,50019090,', 0),
(50019091, '亲子儿童', 6, 50019084, 2, ',50025110,50019084,50019091,', 0),
(50019092, '戏曲曲艺', 7, 50019084, 2, ',50025110,50019084,50019092,', 0),
(50019093, '魔术/杂技/马戏', 8, 50019084, 2, ',50025110,50019084,50019093,', 0),
(50019094, '其他', 9, 50019084, 2, ',50025110,50019084,50019094,', 0),
(50050362, '展览会', 10, 50019084, 2, ',50025110,50019084,50050362,', 0),
(50019243, '国际邮轮', 0, 50019242, 2, ',50025707,50019242,50019243,', 0),
(50018298, '国内游船/邮轮', 10, 50019242, 2, ',50025707,50019242,50018298,', 0),
(50012697, '打印纸', 0, 50019250, 2, ',50007218,50019250,50012697,', 0),
(50021199, '牛皮纸', 0, 50019250, 2, ',50007218,50019250,50021199,', 0),
(50021200, '瓦楞原纸', 1, 50019250, 2, ',50007218,50019250,50021200,', 0),
(50021296, '纸类标签', 1, 50019250, 2, ',50007218,50019250,50021296,', 0),
(50021201, '板纸', 2, 50019250, 2, ',50007218,50019250,50021201,', 0),
(50021202, '卡纸', 3, 50019250, 2, ',50007218,50019250,50021202,', 0),
(50021203, '纸袋纸/杯纸', 4, 50019250, 2, ',50007218,50019250,50021203,', 0),
(50021204, '防油纸/防潮纸', 5, 50019250, 2, ',50007218,50019250,50021204,', 0),
(50021205, '玻璃纸', 6, 50019250, 2, ',50007218,50019250,50021205,', 0),
(50021206, '铝箔纸', 7, 50019250, 2, ',50007218,50019250,50021206,', 0),
(50021235, '羊皮纸', 8, 50019250, 2, ',50007218,50019250,50021235,', 0),
(50021236, '鸡皮纸', 9, 50019250, 2, ',50007218,50019250,50021236,', 0),
(50021237, '透明纸', 10, 50019250, 2, ',50007218,50019250,50021237,', 0),
(50021238, '商标纸/标签纸', 11, 50019250, 2, ',50007218,50019250,50021238,', 0),
(50021239, '淋膜纸', 12, 50019250, 2, ',50007218,50019250,50021239,', 0),
(50021240, '硅油纸', 13, 50019250, 2, ',50007218,50019250,50021240,', 0),
(50021241, '石头纸', 14, 50019250, 2, ',50007218,50019250,50021241,', 0),
(50021242, '包装用纸', 15, 50019250, 2, ',50007218,50019250,50021242,', 0),
(50012696, '相片纸', 28, 50019250, 2, ',50007218,50019250,50012696,', 0),
(50012698, '复印纸', 30, 50019250, 2, ',50007218,50019250,50012698,', 0),
(50012699, '电脑连打纸', 31, 50019250, 2, ',50007218,50019250,50012699,', 0),
(50012700, '彩喷纸', 32, 50019250, 2, ',50007218,50019250,50012700,', 0),
(50012703, '传真纸', 35, 50019250, 2, ',50007218,50019250,50012703,', 0),
(50012704, '收银纸', 36, 50019250, 2, ',50007218,50019250,50012704,', 0),
(50019252, '标签打印纸/条码纸', 37, 50019250, 2, ',50007218,50019250,50019252,', 0),
(50024368, '其他纸', 53, 50019250, 2, ',50007218,50019250,50024368,', 0),
(50019272, '登山鞋/徒步鞋/越野跑鞋', 1, 50019269, 2, ',50013886,50019269,50019272,', 0),
(50019270, '高海拔登山靴/攀冰鞋', 2, 50019269, 2, ',50013886,50019269,50019270,', 0),
(50019274, '沙滩鞋/凉鞋/拖鞋', 4, 50019269, 2, ',50013886,50019269,50019274,', 0),
(50019275, '溯溪鞋', 5, 50019269, 2, ',50013886,50019269,50019275,', 0),
(50019276, '攀岩鞋', 6, 50019269, 2, ',50013886,50019269,50019276,', 0),
(50019278, '滑雪鞋/雪地靴', 8, 50019269, 2, ',50013886,50019269,50019278,', 0),
(50019279, '户外休闲鞋', 9, 50019269, 2, ',50013886,50019269,50019279,', 0),
(50019280, '其他户外鞋', 10, 50019269, 2, ',50013886,50019269,50019280,', 0),
(50015374, '户外袜子', 11, 50019269, 2, ',50013886,50019269,50015374,', 0),
(50019690, '户外鞋垫', 12, 50019269, 2, ',50013886,50019269,50019690,', 0),
(50019281, '保养用品/鞋配件配饰', 13, 50019269, 2, ',50013886,50019269,50019281,', 0),
(50019310, '天馈系统', 0, 50019309, 2, ',50018264,50019309,50019310,', 0),
(50019312, '功率放大器', 1, 50019309, 2, ',50018264,50019309,50019312,', 0),
(50019313, '无线安全保密', 2, 50019309, 2, ',50018264,50019309,50019313,', 0),
(50019319, '程控交换机', 0, 50019318, 2, ',50018264,50019318,50019319,', 0),
(50019320, 'XDSL设备', 1, 50019318, 2, ',50018264,50019318,50019320,', 0),
(50019321, '网络摄像机', 2, 50019318, 2, ',50018264,50019318,50019321,', 0),
(50019322, '中继器', 3, 50019318, 2, ',50018264,50019318,50019322,', 0),
(50019323, '模块接口卡', 4, 50019318, 2, ',50018264,50019318,50019323,', 0),
(50019324, '集线器', 5, 50019318, 2, ',50018264,50019318,50019324,', 0),
(50019325, '测试仪', 6, 50019318, 2, ',50018264,50019318,50019325,', 0),
(50019326, '负载均衡', 7, 50019318, 2, ',50018264,50019318,50019326,', 0),
(50019327, '流量管理', 8, 50019318, 2, ',50018264,50019318,50019327,', 0),
(50019328, '收发器', 9, 50019318, 2, ',50018264,50019318,50019328,', 0),
(50019329, '转换器', 10, 50019318, 2, ',50018264,50019318,50019329,', 0),
(50019330, '串口通讯服务器', 11, 50019318, 2, ',50018264,50019318,50019330,', 0),
(50019331, '工业网络交换机', 12, 50019318, 2, ',50018264,50019318,50019331,', 0),
(50019332, '上网行为管理', 13, 50019318, 2, ',50018264,50019318,50019332,', 0),
(50019333, '功能服务器', 14, 50019318, 2, ',50018264,50019318,50019333,', 0),
(50019334, '计费系统', 15, 50019318, 2, ',50018264,50019318,50019334,', 0),
(50019336, '电力线通信设备', 17, 50019318, 2, ',50018264,50019318,50019336,', 0),
(50019337, '网络加速及优化', 18, 50019318, 2, ',50018264,50019318,50019337,', 0),
(50019338, '网页过滤', 19, 50019318, 2, ',50018264,50019318,50019338,', 0),
(50019339, '复用器', 20, 50019318, 2, ',50018264,50019318,50019339,', 0),
(50019368, '水晶头/网线', 21, 50019318, 2, ',50018264,50019318,50019368,', 0),
(50019340, '其他网络设备', 22, 50019318, 2, ',50018264,50019318,50019340,', 0),
(50019344, '防火墙', 0, 50019341, 2, ',50018264,50019341,50019344,', 0),
(50019345, 'UTM', 1, 50019341, 2, ',50018264,50019341,50019345,', 0),
(50019346, '入侵检测', 2, 50019341, 2, ',50018264,50019341,50019346,', 0),
(50019347, '防毒及邮件过滤', 3, 50019341, 2, ',50018264,50019341,50019347,', 0),
(50019348, '物理安全隔离', 4, 50019341, 2, ',50018264,50019341,50019348,', 0),
(50019349, '内网安全', 5, 50019341, 2, ',50018264,50019341,50019349,', 0),
(50019351, '应用监管', 7, 50019341, 2, ',50018264,50019341,50019351,', 0),
(50016220, '物理防火墙', 7, 50019341, 2, ',50018264,50019341,50016220,', 0),
(50019352, '网络漏洞扫描', 8, 50019341, 2, ',50018264,50019341,50019352,', 0),
(50019362, '综合布线', 0, 50019361, 2, ',50018264,50019361,50019362,', 0),
(50019363, '电缆和双绞线', 1, 50019361, 2, ',50018264,50019361,50019363,', 0),
(50019364, 'PDU电源分配器', 2, 50019361, 2, ',50018264,50019361,50019364,', 0),
(50019365, '精密空调', 3, 50019361, 2, ',50018264,50019361,50019365,', 0),
(50019495, '摄像设备', 0, 50019494, 2, ',50018264,50019494,50019495,', 0),
(50019496, '图像记录', 1, 50019494, 2, ',50018264,50019494,50019496,', 0),
(50016205, '网络摄像机', 1, 50019494, 2, ',50018264,50019494,50016205,', 0),
(50019497, '传输设备', 2, 50019494, 2, ',50018264,50019494,50019497,', 0),
(50019498, '显示控制', 3, 50019494, 2, ',50018264,50019494,50019498,', 0),
(50019499, '周边设备', 4, 50019494, 2, ',50018264,50019494,50019499,', 0),
(50019504, '慢跑鞋', 0, 50019503, 2, ',50010728,50019503,50019504,', 0),
(50019507, '更多慢跑装备', 3, 50019503, 2, ',50010728,50019503,50019507,', 0),
(50019511, '视频会议', 0, 50019510, 2, ',50018264,50019510,50019511,', 0),
(50019512, '多媒体视频', 1, 50019510, 2, ',50018264,50019510,50019512,', 0),
(50019513, '中央控制系统', 2, 50019510, 2, ',50018264,50019510,50019513,', 0),
(50019514, '电视墙与操作台', 3, 50019510, 2, ',50018264,50019510,50019514,', 0),
(50019515, '音频及会议系统', 4, 50019510, 2, ',50018264,50019510,50019515,', 0),
(50019578, '露营/旅游/登山帐篷', 0, 50019539, 2, ',50013886,50019539,50019578,', 0),
(50019579, '沙滩帐/钓鱼遮阳帐篷', 1, 50019539, 2, ',50013886,50019539,50019579,', 0),
(50019580, '车顶帐篷', 2, 50019539, 2, ',50013886,50019539,50019580,', 0),
(50019581, '更衣/沐浴帐篷', 3, 50019539, 2, ',50013886,50019539,50019581,', 0),
(50019582, '工程/民用/活动/救灾帐篷', 4, 50019539, 2, ',50013886,50019539,50019582,', 0),
(50019583, '遮阳篷/雨篷/车篷/广告篷/天幕', 5, 50019539, 2, ',50013886,50019539,50019583,', 0),
(50019584, '帐篷配件', 6, 50019539, 2, ',50013886,50019539,50019584,', 1),
(50020172, '儿童帐篷/游戏屋', 7, 50019539, 2, ',50013886,50019539,50020172,', 0),
(50019593, '普通望远镜', 0, 50019592, 2, ',50013886,50019592,50019593,', 0),
(50019594, '天文望远镜', 1, 50019592, 2, ',50013886,50019592,50019594,', 0),
(50019595, '数码望远镜', 2, 50019592, 2, ',50013886,50019592,50019595,', 0),
(50019596, '红外夜视仪', 3, 50019592, 2, ',50013886,50019592,50019596,', 0),
(50019597, '激光测距望远镜', 4, 50019592, 2, ',50013886,50019592,50019597,', 0),
(50019598, '垂钓望远镜', 5, 50019592, 2, ',50013886,50019592,50019598,', 0),
(50014778, '户外眼镜', 6, 50019592, 2, ',50013886,50019592,50014778,', 0),
(50017070, '望远镜配件', 7, 50019592, 2, ',50013886,50019592,50017070,', 0),
(50014775, '手电筒', 0, 50019601, 2, ',50013886,50019601,50014775,', 0),
(50014886, '营地灯/帐篷灯', 1, 50019601, 2, ',50013886,50019601,50014886,', 0),
(50014887, '头灯', 2, 50019601, 2, ',50013886,50019601,50014887,', 0),
(50018165, '信号灯/发光棒/救生灯', 4, 50019601, 2, ',50013886,50019601,50018165,', 0),
(50015273, '其他灯', 6, 50019601, 2, ',50013886,50019601,50015273,', 0),
(50014146, '潜水照明装备', 14, 50019601, 2, ',50013886,50019601,50014146,', 0),
(50017774, '钓鱼灯', 26, 50019601, 2, ',50013886,50019601,50017774,', 0),
(50019607, '灯具配件', 27, 50019601, 2, ',50013886,50019601,50019607,', 1),
(50019618, '阴臀倒模', 0, 50019617, 2, ',2813,50019617,50019618,', 0),
(50019619, '简单便携', 1, 50019617, 2, ',2813,50019617,50019619,', 1),
(50019623, '性玩偶', 2, 50019617, 2, ',2813,50019617,50019623,', 1),
(50019626, 'G点后庭', 3, 50019617, 2, ',2813,50019617,50019626,', 0),
(50019627, '仿真乳房', 4, 50019617, 2, ',2813,50019617,50019627,', 0),
(50019628, '穿戴增大', 5, 50019617, 2, ',2813,50019617,50019628,', 0),
(50019629, '其他男用', 6, 50019617, 2, ',2813,50019617,50019629,', 0),
(50019631, '震动棒', 0, 50019630, 2, ',2813,50019630,50019631,', 0),
(50019636, 'G点后庭', 1, 50019630, 2, ',2813,50019630,50019636,', 0),
(50019637, '阴蒂刺激', 2, 50019630, 2, ',2813,50019630,50019637,', 0),
(50019638, '丰乳挑逗', 3, 50019630, 2, ',2813,50019630,50019638,', 0),
(50019639, '女用穿戴', 4, 50019630, 2, ',2813,50019630,50019639,', 0),
(50019640, '其他女用', 5, 50019630, 2, ',2813,50019630,50019640,', 0),
(50019642, '润滑剂', 0, 50019641, 2, ',2813,50019641,50019642,', 0),
(50019643, '情趣跳蛋', 1, 50019641, 2, ',2813,50019641,50019643,', 0),
(50019644, '延时套环', 2, 50019641, 2, ',2813,50019641,50019644,', 1),
(50019645, '另类玩具', 3, 50019641, 2, ',2813,50019641,50019645,', 0),
(50019646, '调情香水', 4, 50019641, 2, ',2813,50019641,50019646,', 1),
(50019700, '激情用具', 6, 50019641, 2, ',2813,50019641,50019700,', 0),
(50019647, '其他用品', 7, 50019641, 2, ',2813,50019641,50019647,', 0),
(50019652, '情趣文胸', 0, 50019651, 2, ',2813,50019651,50019652,', 0),
(50019653, '情趣内裤', 1, 50019651, 2, ',2813,50019651,50019653,', 1),
(50019656, '情趣丝袜', 2, 50019651, 2, ',2813,50019651,50019656,', 0),
(50019657, '情趣睡衣', 3, 50019651, 2, ',2813,50019651,50019657,', 0),
(50019658, '情趣套装', 4, 50019651, 2, ',2813,50019651,50019658,', 0),
(50019659, '情趣配饰', 5, 50019651, 2, ',2813,50019651,50019659,', 1),
(50014758, '水壶/水瓶/水杯', 0, 50019712, 2, ',50013886,50019712,50014758,', 0),
(50019713, '饮用水袋/皮囊', 1, 50019712, 2, ',50013886,50019712,50019713,', 1),
(50019723, '酒壶', 2, 50019712, 2, ',50013886,50019712,50019723,', 0),
(50018722, '野外沐浴袋/太阳能沐浴袋', 4, 50019712, 2, ',50013886,50019712,50018722,', 0),
(50019717, '净水设备', 6, 50019712, 2, ',50013886,50019712,50019717,', 0),
(50017870, '户外烧水壶/茶壶/咖啡壶', 6, 50019712, 2, ',50013886,50019712,50017870,', 0),
(50014841, '水桶/水盆', 7, 50019712, 2, ',50013886,50019712,50014841,', 0),
(50019718, '配件区', 7, 50019712, 2, ',50013886,50019712,50019718,', 1),
(50018692, '电动自行车', 0, 50019782, 2, ',50010728,50019782,50018692,', 0),
(50019380, '电动车零/配件', 27, 50019782, 2, ',50010728,50019782,50019380,', 1),
(50019402, '电动车装备区', 28, 50019782, 2, ',50010728,50019782,50019402,', 1),
(50019427, '电动车维修工具', 29, 50019782, 2, ',50010728,50019782,50019427,', 1),
(50025783, '国内套餐', 1, 50019784, 2, ',50011949,50019784,50025783,', 1),
(50019817, '海外套餐', 2, 50019784, 2, ',50011949,50019784,50019817,', 0),
(50019813, '天线', 0, 50019812, 2, ',50018264,50019812,50019813,', 0),
(50019814, '电源/适配器', 1, 50019812, 2, ',50018264,50019812,50019814,', 0),
(50019815, '路由器其它配件', 2, 50019812, 2, ',50018264,50019812,50019815,', 0),
(50019837, '扣板模块', 0, 50019835, 2, ',27,50019835,50019837,', 0),
(50019838, '电器模块', 1, 50019835, 2, ',27,50019835,50019838,', 1),
(50019840, '配件模块', 2, 50019835, 2, ',27,50019835,50019840,', 1),
(50019940, '吸顶灯', 0, 50019935, 2, ',27,50019935,50019940,', 0),
(50020103, '吊灯', 1, 50019935, 2, ',27,50019935,50020103,', 0),
(50019938, '壁灯', 4, 50019935, 2, ',27,50019935,50019938,', 0),
(50019939, '落地灯', 6, 50019935, 2, ',27,50019935,50019939,', 0),
(50019936, '小夜灯', 7, 50019935, 2, ',27,50019935,50019936,', 0),
(50020105, '新奇特灯具', 14, 50019935, 2, ',27,50019935,50020105,', 0),
(50020106, '镜前灯', 15, 50019935, 2, ',27,50019935,50020106,', 0),
(50024675, '台灯', 18, 50019935, 2, ',27,50019935,50024675,', 1),
(50024677, '室外灯饰', 19, 50019935, 2, ',27,50019935,50024677,', 1),
(50024678, '筒灯', 20, 50019935, 2, ',27,50019935,50024678,', 0),
(50024679, '射灯', 21, 50019935, 2, ',27,50019935,50024679,', 0),
(50024696, '橱柜灯', 22, 50019935, 2, ',27,50019935,50024696,', 0),
(50024811, '支架灯', 23, 50019935, 2, ',27,50019935,50024811,', 0),
(50024812, '应急灯', 24, 50019935, 2, ',27,50019935,50024812,', 0),
(50024813, '其它灯具灯饰', 25, 50019935, 2, ',27,50019935,50024813,', 0),
(50020632, '布艺沙发', 1, 50020006, 2, ',50008164,50020006,50020632,', 0),
(50020633, '皮艺沙发', 2, 50020006, 2, ',50008164,50020006,50020633,', 0),
(50020634, '实木沙发', 3, 50020006, 2, ',50008164,50020006,50020634,', 0),
(50020636, '铁艺沙发', 5, 50020006, 2, ',50008164,50020006,50020636,', 0),
(50020635, '藤/竹沙发', 6, 50020006, 2, ',50008164,50020006,50020635,', 0),
(50015457, '沙发床', 8, 50020006, 2, ',50008164,50020006,50015457,', 0),
(50015458, '懒人沙发', 9, 50020006, 2, ',50008164,50020006,50015458,', 0),
(50015837, '儿童沙发', 16, 50020006, 2, ',50008164,50020006,50015837,', 0),
(50020638, '贵妃椅', 17, 50020006, 2, ',50008164,50020006,50020638,', 0),
(50020639, '充气沙发', 18, 50020006, 2, ',50008164,50020006,50020639,', 0),
(50020640, '沙发凳/脚踏', 19, 50020006, 2, ',50008164,50020006,50020640,', 0),
(50020641, '沙发配件及辅料', 20, 50020006, 2, ',50008164,50020006,50020641,', 1),
(50020008, '卫浴龙头', 0, 50020007, 2, ',27,50020007,50020008,', 1),
(50020009, '坐便器', 1, 50020007, 2, ',27,50020007,50020009,', 1),
(50020010, '坐便器盖板', 2, 50020007, 2, ',27,50020007,50020010,', 1),
(50003559, '蹲便器', 3, 50020007, 2, ',27,50020007,50003559,', 0),
(50003561, '净身妇洗器', 4, 50020007, 2, ',27,50020007,50003561,', 0),
(50020013, '小便器', 5, 50020007, 2, ',27,50020007,50020013,', 1),
(50020014, '洗面盆', 6, 50020007, 2, ',27,50020007,50020014,', 1),
(50020015, '冲水器', 7, 50020007, 2, ',27,50020007,50020015,', 1),
(50020016, '浴缸', 8, 50020007, 2, ',27,50020007,50020016,', 1),
(50020017, '淋浴房', 9, 50020007, 2, ',27,50020007,50020017,', 1),
(50020018, '卫浴家具', 10, 50020007, 2, ',27,50020007,50020018,', 1),
(50020021, '角阀', 13, 50020007, 2, ',27,50020007,50020021,', 0),
(50013330, '拖把池', 46, 50020007, 2, ',27,50020007,50013330,', 0),
(50013331, '地漏', 47, 50020007, 2, ',27,50020007,50013331,', 0),
(50013332, '卫浴配件', 48, 50020007, 2, ',27,50020007,50013332,', 1),
(50016746, '卫浴五金/挂件', 49, 50020007, 2, ',27,50020007,50016746,', 1),
(50013352, '商用卫浴', 50, 50020007, 2, ',27,50020007,50013352,', 1),
(50023011, '卫浴水箱', 51, 50020007, 2, ',27,50020007,50023011,', 0),
(50020181, '电子书手写笔/电磁笔', 0, 50020180, 2, ',50008090,50020180,50020181,', 0),
(50020182, '电子书灯', 1, 50020180, 2, ',50008090,50020180,50020182,', 0),
(50020183, '电子书保护套', 2, 50020180, 2, ',50008090,50020180,50020183,', 0),
(50020184, '电纸书充电器', 3, 50020180, 2, ',50008090,50020180,50020184,', 0),
(50020185, '电纸书屏幕贴膜', 4, 50020180, 2, ',50008090,50020180,50020185,', 0),
(50020186, '电纸书防护包', 5, 50020180, 2, ',50008090,50020180,50020186,', 0),
(50020187, '电纸书数据线', 6, 50020180, 2, ',50008090,50020180,50020187,', 0),
(50003320, '调音台(舞台)', 0, 50020192, 2, ',50011972,50020192,50003320,', 0),
(350123, '均衡(舞台)', 11, 50020192, 2, ',50011972,50020192,350123,', 0),
(50003408, '专业音频放大器(舞台)', 12, 50020192, 2, ',50011972,50020192,50003408,', 0),
(50003405, '效果器(舞台)', 13, 50020192, 2, ',50011972,50020192,50003405,', 0),
(50003406, '分频器(舞台)', 14, 50020192, 2, ',50011972,50020192,50003406,', 0),
(50008106, 'KTV(舞台)', 15, 50020192, 2, ',50011972,50020192,50008106,', 0),
(50020193, '打碟机', 16, 50020192, 2, ',50011972,50020192,50020193,', 0),
(50020205, '性爱椅', 0, 50020206, 2, ',2813,50020206,50020205,', 0),
(50050327, '性爱沙发', 1, 50020206, 2, ',2813,50020206,50050327,', 0),
(50007215, '传统滋补品其他', 0, 50020296, 2, ',50020275,50020296,50007215,', 0),
(50011728, '蚂蚁', 16, 50020296, 2, ',50020275,50020296,50011728,', 0),
(50009985, '不老草', 17, 50020296, 2, ',50020275,50020296,50009985,', 0),
(50009984, '当归', 18, 50020296, 2, ',50020275,50020296,50009984,', 0),
(50009982, '雪莲', 20, 50020296, 2, ',50020275,50020296,50009982,', 0),
(50009981, '制何首乌', 21, 50020296, 2, ',50020275,50020296,50009981,', 0),
(50008674, '五味子', 25, 50020296, 2, ',50020275,50020296,50008674,', 0),
(50008328, '天麻', 26, 50020296, 2, ',50020275,50020296,50008328,', 0),
(50012195, '五加皮', 38, 50020296, 2, ',50020275,50020296,50012195,', 0),
(50015227, '藏红花', 51, 50020296, 2, ',50020275,50020296,50015227,', 0),
(50015228, '益母草', 52, 50020296, 2, ',50020275,50020296,50015228,', 0),
(50020298, '熟地黄', 54, 50020296, 2, ',50020275,50020296,50020298,', 0),
(50020299, '生地黄', 55, 50020296, 2, ',50020275,50020296,50020299,', 0),
(50020300, '丹参', 56, 50020296, 2, ',50020275,50020296,50020300,', 0),
(50020302, '红景天', 58, 50020296, 2, ',50020275,50020296,50020302,', 0),
(50020303, '杜仲', 59, 50020296, 2, ',50020275,50020296,50020303,', 0),
(50020304, '罗布麻', 60, 50020296, 2, ',50020275,50020296,50020304,', 0),
(50050413, '党参', 61, 50020296, 2, ',50020275,50020296,50050413,', 0),
(50050414, '珍珠粉', 62, 50020296, 2, ',50020275,50020296,50050414,', 0),
(50050415, '威灵仙', 63, 50020296, 2, ',50020275,50020296,50050415,', 0),
(50050416, '黄芪', 64, 50020296, 2, ',50020275,50020296,50050416,', 0),
(50050417, '北沙参', 65, 50020296, 2, ',50020275,50020296,50050417,', 0),
(50050418, '牛膝', 66, 50020296, 2, ',50020275,50020296,50050418,', 0),
(50050419, '豆蔻', 67, 50020296, 2, ',50020275,50020296,50050419,', 0),
(50050420, '广金钱草', 68, 50020296, 2, ',50020275,50020296,50050420,', 0),
(50050421, '红花', 69, 50020296, 2, ',50020275,50020296,50050421,', 0),
(50050422, '太子参', 70, 50020296, 2, ',50020275,50020296,50050422,', 0),
(50050423, '山茱萸', 71, 50020296, 2, ',50020275,50020296,50050423,', 0),
(50050424, '麦冬', 72, 50020296, 2, ',50020275,50020296,50050424,', 0),
(50013573, '细木工板', 0, 50020333, 2, ',50020332,50020333,50013573,', 0),
(50013574, '胶合板', 1, 50020333, 2, ',50020332,50020333,50013574,', 0),
(50013575, '饰面板', 2, 50020333, 2, ',50020332,50020333,50013575,', 0),
(50013576, '三聚氰胺板', 3, 50020333, 2, ',50020332,50020333,50013576,', 0),
(50020339, '建筑模板', 4, 50020333, 2, ',50020332,50020333,50020339,', 0),
(50013577, '欧松板', 4, 50020333, 2, ',50020332,50020333,50013577,', 0),
(50020340, '铝塑板', 5, 50020333, 2, ',50020332,50020333,50020340,', 0),
(50013579, '中密度板', 6, 50020333, 2, ',50020332,50020333,50013579,', 0),
(50013580, '集成板', 7, 50020333, 2, ',50020332,50020333,50013580,', 0),
(50020342, '轻质砖', 0, 50020341, 2, ',50020332,50020341,50020342,', 0),
(50020343, '红砖', 1, 50020341, 2, ',50020332,50020341,50020343,', 0),
(50020344, '多孔砖', 2, 50020341, 2, ',50020332,50020341,50020344,', 0),
(50020345, '透水砖', 3, 50020341, 2, ',50020332,50020341,50020345,', 0),
(50020346, '砖雕', 4, 50020341, 2, ',50020332,50020341,50020346,', 0),
(50020349, '电视背景墙', 0, 50020348, 2, ',50020332,50020348,50020349,', 0),
(50020350, '屏风', 1, 50020348, 2, ',50020332,50020348,50020350,', 0),
(50020351, '玻璃隔断墙', 2, 50020348, 2, ',50020332,50020348,50020351,', 0),
(50020353, '粗沙', 0, 50020352, 2, ',50020332,50020352,50020353,', 0),
(50020354, '中沙', 1, 50020352, 2, ',50020332,50020352,50020354,', 0),
(50020355, '细沙', 2, 50020352, 2, ',50020332,50020352,50020355,', 0),
(50020357, '鹅卵石', 4, 50020352, 2, ',50020332,50020352,50020357,', 0),
(50020359, '白水泥', 0, 50020358, 2, ',50020332,50020358,50020359,', 0),
(50020360, '黑水泥', 1, 50020358, 2, ',50020332,50020358,50020360,', 0),
(50020363, '镀锌管/配件', 0, 50020362, 2, ',50020332,50020362,50020363,', 0),
(50020364, '铜管/配件', 1, 50020362, 2, ',50020332,50020362,50020364,', 0),
(50020365, '不锈钢管/配件', 2, 50020362, 2, ',50020332,50020362,50020365,', 0),
(50020366, 'PE管/配件', 3, 50020362, 2, ',50020332,50020362,50020366,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50020367, 'UPVC管/配件', 4, 50020362, 2, ',50020332,50020362,50020367,', 0),
(50020368, 'PPR管/配件', 5, 50020362, 2, ',50020332,50020362,50020368,', 0),
(50013435, '其他管材连接件', 84, 50020362, 2, ',50020332,50020362,50013435,', 1),
(50020370, '石膏线条', 0, 50020369, 2, ',50020332,50020369,50020370,', 0),
(50020371, '木线条', 1, 50020369, 2, ',50020332,50020369,50020371,', 0),
(50022706, '相框线条', 2, 50020369, 2, ',50020332,50020369,50022706,', 0),
(50020373, '木龙骨', 0, 50020372, 2, ',50020332,50020372,50020373,', 0),
(50020374, '防腐木', 1, 50020372, 2, ',50020332,50020372,50020374,', 0),
(50020375, '碳化木', 2, 50020372, 2, ',50020332,50020372,50020375,', 0),
(50020376, '原木木方', 3, 50020372, 2, ',50020332,50020372,50020376,', 0),
(50020393, '安全网', 0, 50020392, 2, ',50020332,50020392,50020393,', 0),
(50020394, '石棉瓦', 1, 50020392, 2, ',50020332,50020392,50020394,', 0),
(50020395, '井盖', 2, 50020392, 2, ',50020332,50020392,50020395,', 0),
(50020396, '其它', 3, 50020392, 2, ',50020332,50020392,50020396,', 0),
(50013519, '其他装饰材料', 13, 50020392, 2, ',50020332,50020392,50013519,', 0),
(50013509, '基础材料', 24, 50020392, 2, ',50020332,50020392,50013509,', 0),
(50012578, '其它材料', 26, 50020392, 2, ',50020332,50020392,50012578,', 0),
(50020398, '隔音板', 0, 50020397, 2, ',50020332,50020397,50020398,', 0),
(50020399, '隔音棉', 1, 50020397, 2, ',50020332,50020397,50020399,', 0),
(50020401, '管道隔热保温套', 0, 50020400, 2, ',50020332,50020400,50020401,', 0),
(50020402, '隔热保温片', 1, 50020400, 2, ',50020332,50020400,50020402,', 0),
(50020403, '墙体外保温体系', 2, 50020400, 2, ',50020332,50020400,50020403,', 0),
(50020405, '扁钢', 0, 50020404, 2, ',50020332,50020404,50020405,', 0),
(50020406, '螺纹钢', 1, 50020404, 2, ',50020332,50020404,50020406,', 0),
(50020407, '角钢', 2, 50020404, 2, ',50020332,50020404,50020407,', 0),
(50020408, '圆钢', 3, 50020404, 2, ',50020332,50020404,50020408,', 0),
(50020409, '槽钢', 4, 50020404, 2, ',50020332,50020404,50020409,', 0),
(50020411, '钢板', 6, 50020404, 2, ',50020332,50020404,50020411,', 0),
(50020415, '工业用铝型材', 2, 50020412, 2, ',50020332,50020412,50020415,', 0),
(50020416, '铝板', 3, 50020412, 2, ',50020332,50020412,50020416,', 0),
(50020418, '防水石膏板', 0, 50020417, 2, ',50020332,50020417,50020418,', 0),
(50020419, '防火石膏板', 1, 50020417, 2, ',50020332,50020417,50020419,', 0),
(50020420, '石膏板配件', 2, 50020417, 2, ',50020332,50020417,50020420,', 0),
(50022224, '普通石膏板', 3, 50020417, 2, ',50020332,50020417,50022224,', 0),
(50020437, '纱窗', 0, 50020421, 2, ',50020332,50020421,50020437,', 0),
(50020434, '平开窗', 1, 50020421, 2, ',50020332,50020421,50020434,', 0),
(50020433, '推拉窗', 2, 50020421, 2, ',50020332,50020421,50020433,', 0),
(50020435, '外悬窗', 3, 50020421, 2, ',50020332,50020421,50020435,', 0),
(50020436, '无框阳台窗', 4, 50020421, 2, ',50020332,50020421,50020436,', 0),
(50020438, '防盗窗', 5, 50020421, 2, ',50020332,50020421,50020438,', 0),
(50013221, '其它窗', 22, 50020421, 2, ',50020332,50020421,50013221,', 0),
(50020443, '门底密封条', 0, 50020442, 2, ',50020332,50020442,50020443,', 0),
(50020444, '窗密封条', 1, 50020442, 2, ',50020332,50020442,50020444,', 0),
(50023526, '花剑系列', 0, 50023370, 2, ',50010728,50023370,50023526,', 1),
(50023527, '重剑系列', 1, 50023370, 2, ',50010728,50023370,50023527,', 1),
(50023528, '佩剑系列', 2, 50023370, 2, ',50010728,50023370,50023528,', 1),
(50023529, '击剑护具', 3, 50023370, 2, ',50010728,50023370,50023529,', 0),
(50023530, '击剑剑包', 4, 50023370, 2, ',50010728,50023370,50023530,', 0),
(50023531, '击剑鞋/袜', 5, 50023370, 2, ',50010728,50023370,50023531,', 0),
(50023421, '高尔夫球服', 5, 50023415, 2, ',50011699,50023415,50023421,', 0),
(50023423, '棒球服', 6, 50023415, 2, ',50011699,50023415,50023423,', 0),
(50023424, '橄榄球服', 7, 50023415, 2, ',50011699,50023415,50023424,', 0),
(50023425, '其它球服', 8, 50023415, 2, ',50011699,50023415,50023425,', 0),
(50023580, '解锁/解环玩具', 0, 50023498, 2, ',25,50023498,50023580,', 0),
(50006804, '益智魔方', 1, 50023498, 2, ',25,50023498,50006804,', 0),
(50006948, '悠悠(溜溜)球', 2, 50023498, 2, ',25,50023498,50006948,', 0),
(253904, '迷宫类', 28, 50023498, 2, ',25,50023498,253904,', 0),
(50023599, '智力解题/通关玩具', 29, 50023498, 2, ',25,50023498,50023599,', 0),
(50008829, '彩泥/橡皮泥', 1, 50023502, 2, ',25,50023502,50008829,', 0),
(50023497, '手工制作/创意DIY', 7, 50023502, 2, ',25,50023502,50023497,', 1),
(50013181, '切切看', 8, 50023502, 2, ',25,50023502,50013181,', 0),
(50023640, '仿真果蔬/食物', 22, 50023502, 2, ',25,50023502,50023640,', 0),
(50016084, '仿真/动物玩偶', 24, 50023502, 2, ',25,50023502,50016084,', 0),
(50023800, '仿真照相机', 25, 50023502, 2, ',25,50023502,50023800,', 0),
(50023643, '过家家玩具', 26, 50023502, 2, ',25,50023502,50023643,', 0),
(50013179, '其它仿真玩具', 28, 50023502, 2, ',25,50023502,50013179,', 0),
(251707, '拼图/拼板', 0, 50023504, 2, ',25,50023504,251707,', 0),
(50023647, '建构/拼插积木', 1, 50023504, 2, ',25,50023504,50023647,', 1),
(50023673, '数字屋/形状认知/配对', 2, 50023504, 2, ',25,50023504,50023673,', 1),
(50023674, '螺母拆装/组合玩具', 3, 50023504, 2, ',25,50023504,50023674,', 0),
(50023701, '串珠/绕珠/插珠/蘑菇插钉', 4, 50023504, 2, ',25,50023504,50023701,', 1),
(50023505, '钓鱼/敲打/打地鼠/多米诺', 5, 50023504, 2, ',25,50023504,50023505,', 1),
(50023585, '儿童早教机构', 0, 50023507, 2, ',25,50023507,50023585,', 0),
(50023586, '儿童摄影机构', 1, 50023507, 2, ',25,50023507,50023586,', 0),
(50023587, '宝宝游泳馆', 2, 50023507, 2, ',25,50023507,50023587,', 0),
(50023588, '妈咪瘦身机构', 3, 50023507, 2, ',25,50023507,50023588,', 0),
(50023668, '游戏围栏', 0, 50023508, 2, ',25,50023508,50023668,', 0),
(50016044, '室内娱乐设备', 1, 50023508, 2, ',25,50023508,50016044,', 0),
(50023669, '感统训练器材/教学设备', 1, 50023508, 2, ',25,50023508,50023669,', 0),
(50016045, '游艺机', 2, 50023508, 2, ',25,50023508,50016045,', 0),
(50008688, '蹦床', 4, 50023508, 2, ',25,50023508,50008688,', 0),
(50008689, '小型滑梯/秋千', 5, 50023508, 2, ',25,50023508,50008689,', 0),
(50013822, '摇摆机/摇摇乐', 33, 50023508, 2, ',25,50023508,50013822,', 0),
(50023670, '跷跷板', 34, 50023508, 2, ',25,50023508,50023670,', 0),
(50023672, '隧道/钻洞', 35, 50023508, 2, ',25,50023508,50023672,', 0),
(50024611, '软体组合器材', 36, 50023508, 2, ',25,50023508,50024611,', 0),
(251201, '大型组合式游乐设备', 37, 50023508, 2, ',25,50023508,251201,', 0),
(251202, '其他游乐设施', 40, 50023508, 2, ',25,50023508,251202,', 0),
(50024613, '科学实验玩具', 0, 50023509, 2, ',25,50023509,50024613,', 0),
(50023661, '太阳能玩具', 4, 50023509, 2, ',25,50023509,50023661,', 0),
(50023659, '儿童放大镜', 5, 50023509, 2, ',25,50023509,50023659,', 0),
(50023798, '儿童望远镜', 8, 50023509, 2, ',25,50023509,50023798,', 0),
(50009920, '万花筒', 12, 50023509, 2, ',25,50023509,50009920,', 0),
(50023776, '儿童地球仪', 13, 50023509, 2, ',25,50023509,50023776,', 0),
(50023662, '其他科学探索类玩具', 14, 50023509, 2, ',25,50023509,50023662,', 0),
(50026668, '物理类', 15, 50023509, 2, ',25,50023509,50026668,', 0),
(50026669, '艺术类', 16, 50023509, 2, ',25,50023509,50026669,', 0),
(50026670, '生物/化学类', 17, 50023509, 2, ',25,50023509,50026670,', 1),
(50026671, '舞蹈类', 18, 50023509, 2, ',25,50023509,50026671,', 0),
(50026672, '体育类', 19, 50023509, 2, ',25,50023509,50026672,', 0),
(50026673, '计算机类', 20, 50023509, 2, ',25,50023509,50026673,', 0),
(50026674, '音乐类', 21, 50023509, 2, ',25,50023509,50026674,', 0),
(50026675, '美术绘画类', 22, 50023509, 2, ',25,50023509,50026675,', 0),
(50026676, '阅读类', 23, 50023509, 2, ',25,50023509,50026676,', 0),
(50006012, '家居服/哺乳装/喂奶衣', 0, 50023613, 2, ',50022517,50023613,50006012,', 0),
(50023614, '秋衣裤', 1, 50023613, 2, ',50022517,50023613,50023614,', 0),
(50023615, '其它', 2, 50023613, 2, ',50022517,50023613,50023615,', 0),
(50006010, '束腹带', 0, 50023660, 2, ',50022517,50023660,50006010,', 0),
(50014810, '产妇瘦身塑体衣', 23, 50023660, 2, ',50022517,50023660,50014810,', 0),
(50016731, '骨盆矫正带', 24, 50023660, 2, ',50022517,50023660,50016731,', 0),
(350213, '电吹风', 0, 50023686, 2, ',50002768,50023686,350213,', 0),
(50010401, '卷/直发器', 3, 50023686, 2, ',50002768,50023686,50010401,', 0),
(50005011, '理发器', 4, 50023686, 2, ',50002768,50023686,50005011,', 0),
(50024628, '焗油帽/机', 5, 50023686, 2, ',50002768,50023686,50024628,', 0),
(50024629, '其它美发工具', 6, 50023686, 2, ',50002768,50023686,50024629,', 0),
(50014743, '血压计', 0, 50023687, 2, ',50002768,50023687,50014743,', 0),
(50015979, '电子血糖仪', 10, 50023687, 2, ',50002768,50023687,50015979,', 0),
(50009107, '电子体温计', 11, 50023687, 2, ',50002768,50023687,50009107,', 0),
(350215, '电子计步器', 18, 50023687, 2, ',50002768,50023687,350215,', 0),
(50023374, '点穴棒', 0, 50023688, 2, ',50002768,50023688,50023374,', 0),
(50005183, '刮痧片/板', 22, 50023688, 2, ',50002768,50023688,50005183,', 0),
(50005466, '拔罐器', 25, 50023688, 2, ',50002768,50023688,50005466,', 0),
(50022662, '温灸器', 27, 50023688, 2, ',50002768,50023688,50022662,', 0),
(50023376, '家用护理床', 0, 50023690, 2, ',50002768,50023690,50023376,', 0),
(50018412, '足底理疗/气血循环机', 3, 50023690, 2, ',50002768,50023690,50018412,', 0),
(50018411, '家用电子理疗仪', 5, 50023690, 2, ',50002768,50023690,50018411,', 0),
(50009104, '家用氧吧', 40, 50023690, 2, ',50002768,50023690,50009104,', 0),
(50003469, '轮椅', 42, 50023690, 2, ',50002768,50023690,50003469,', 0),
(50003470, '手杖/拐杖/助行', 43, 50023690, 2, ',50002768,50023690,50003470,', 0),
(50010611, '坐便椅', 44, 50023690, 2, ',50002768,50023690,50010611,', 0),
(50010612, '接尿用品', 45, 50023690, 2, ',50002768,50023690,50010612,', 0),
(50023731, '五官用药', 0, 50023720, 2, ',50023717,50023720,50023731,', 1),
(50023765, '心脑血管', 1, 50023720, 2, ',50023717,50023720,50023765,', 0),
(50023732, '皮肤用药/外伤', 2, 50023720, 2, ',50023717,50023720,50023732,', 0),
(50023733, '肠胃用药', 3, 50023720, 2, ',50023717,50023720,50023733,', 0),
(50023734, '泌尿生殖', 4, 50023720, 2, ',50023717,50023720,50023734,', 0),
(50023735, '肝胆用药', 5, 50023720, 2, ',50023717,50023720,50023735,', 0),
(50023736, '风湿骨伤', 6, 50023720, 2, ',50023717,50023720,50023736,', 0),
(50023737, '妇科用药', 7, 50023720, 2, ',50023717,50023720,50023737,', 0),
(50023738, '孕婴用药', 8, 50023720, 2, ',50023717,50023720,50023738,', 1),
(50023739, '男科用药', 9, 50023720, 2, ',50023717,50023720,50023739,', 0),
(50023740, '感冒咳嗽', 10, 50023720, 2, ',50023717,50023720,50023740,', 0),
(50023741, '解热镇痛', 11, 50023720, 2, ',50023717,50023720,50023741,', 0),
(50023742, '维矿物质', 12, 50023720, 2, ',50023717,50023720,50023742,', 0),
(50023743, '补益安神', 13, 50023720, 2, ',50023717,50023720,50023743,', 0),
(50023764, '戒烟用药', 14, 50023720, 2, ',50023717,50023720,50023764,', 0),
(50023766, '眩晕晕车用药', 15, 50023720, 2, ',50023717,50023720,50023766,', 0),
(50023869, '避孕', 16, 50023720, 2, ',50023717,50023720,50023869,', 0),
(50023744, '血糖用品', 0, 50023721, 2, ',50023717,50023721,50023744,', 0),
(50023745, '血压仪器', 1, 50023721, 2, ',50023717,50023721,50023745,', 0),
(50023746, '温度计类', 2, 50023721, 2, ',50023717,50023721,50023746,', 0),
(50023747, '中医保健', 3, 50023721, 2, ',50023717,50023721,50023747,', 0),
(50023748, '保健理疗', 4, 50023721, 2, ',50023717,50023721,50023748,', 0),
(50023749, '轮椅拐杖', 5, 50023721, 2, ',50023717,50023721,50023749,', 0),
(50023750, '医用用具', 6, 50023721, 2, ',50023717,50023721,50023750,', 0),
(50023751, '隐形眼镜', 0, 50023722, 2, ',50023717,50023722,50023751,', 0),
(50023752, '护理液', 1, 50023722, 2, ',50023717,50023722,50023752,', 0),
(50023753, '彩色隐形眼镜', 2, 50023722, 2, ',50023717,50023722,50023753,', 0),
(50026903, '隐形眼镜伴侣', 3, 50023722, 2, ',50023717,50023722,50026903,', 0),
(50023918, '家庭装修硬装设计', 0, 50023809, 2, ',50023804,50023809,50023918,', 0),
(50023919, '家庭装修软装设计', 1, 50023809, 2, ',50023804,50023809,50023919,', 0),
(50023920, '家庭装修设计套餐', 2, 50023809, 2, ',50023804,50023809,50023920,', 0),
(50023916, '单项装饰施工', 0, 50023810, 2, ',50023804,50023810,50023916,', 0),
(50023917, '家庭施工套餐', 1, 50023810, 2, ',50023804,50023810,50023917,', 0),
(50023922, '全屋装修工程监理', 0, 50023921, 2, ',50023804,50023921,50023922,', 0),
(50023923, '分项装修工程监理', 1, 50023921, 2, ',50023804,50023921,50023923,', 0),
(50023951, '保养服务', 0, 50023950, 2, ',26,50023950,50023951,', 1),
(50023954, '改装服务', 1, 50023950, 2, ',26,50023950,50023954,', 1),
(50023956, '装潢服务', 2, 50023950, 2, ',26,50023950,50023956,', 1),
(50023957, '维修服务', 3, 50023950, 2, ',26,50023950,50023957,', 1),
(50023960, '电子产品服务', 4, 50023950, 2, ',26,50023950,50023960,', 1),
(50023961, '其它服务', 5, 50023950, 2, ',26,50023950,50023961,', 0),
(50023985, '美容服务', 6, 50023950, 2, ',26,50023950,50023985,', 1),
(50023989, '车况检查', 7, 50023950, 2, ',26,50023950,50023989,', 0),
(50023436, '幼儿叠叠乐/不倒翁/手抓球', 0, 50024048, 2, ',25,50024048,50023436,', 1),
(50023440, '布书/手偶/床铃/摇铃', 6, 50024048, 2, ',25,50024048,50023440,', 1),
(50023444, '幼儿爬行/学步/健身', 7, 50024048, 2, ',25,50024048,50023444,', 1),
(50023644, '发光玩具', 0, 50024050, 2, ',25,50024050,50023644,', 1),
(50015992, '创意/整蛊玩具', 6, 50024050, 2, ',25,50024050,50015992,', 0),
(252801, '塑料充气玩具（其他材质勿放）', 27, 50024050, 2, ',25,50024050,252801,', 0),
(50023635, '电子玩具', 54, 50024050, 2, ',25,50024050,50023635,', 1),
(50024061, '船模', 0, 50024060, 2, ',25,50024060,50024061,', 1),
(50024062, '固定翼', 1, 50024060, 2, ',25,50024060,50024062,', 0),
(50024063, '坦克', 2, 50024060, 2, ',25,50024060,50024063,', 0),
(50024064, '车模', 3, 50024060, 2, ',25,50024060,50024064,', 0),
(50024065, '直升机', 4, 50024060, 2, ',25,50024060,50024065,', 0),
(150704, '手机保护套/壳', 0, 50024094, 2, ',50008090,50024094,150704,', 0),
(50012584, '手机充电器', 0, 50024094, 2, ',50008090,50024094,50012584,', 0),
(50010614, '手机零部件', 0, 50024094, 2, ',50008090,50024094,50010614,', 0),
(50018621, '手机防尘塞', 4, 50024094, 2, ',50008090,50024094,50018621,', 0),
(1507, '手机饰品', 5, 50024094, 2, ',50008090,50024094,1507,', 1),
(50012579, '手机电池', 27, 50024094, 2, ',50008090,50024094,50012579,', 0),
(50012587, '手机屏幕贴膜', 29, 50024094, 2, ',50008090,50024094,50012587,', 0),
(50005266, '手机专用线控耳机', 43, 50024094, 2, ',50008090,50024094,50005266,', 0),
(50024110, '其它手机配件', 44, 50024094, 2, ',50008090,50024094,50024110,', 0),
(50050366, '手机数据线', 45, 50024094, 2, ',50008090,50024094,50050366,', 0),
(50012580, '笔记本电池', 0, 50024095, 2, ',50008090,50024095,50012580,', 0),
(50012582, '笔记本电脑包', 0, 50024095, 2, ',50008090,50024095,50012582,', 0),
(50005718, '笔记本散热器/降温卡', 1, 50024095, 2, ',50008090,50024095,50005718,', 0),
(50005192, '笔记本炫彩贴', 2, 50024095, 2, ',50008090,50024095,50005192,', 0),
(50005722, '笔记本多功能支架/桌', 7, 50024095, 2, ',50008090,50024095,50005722,', 0),
(50005723, '笔记本键盘保护膜', 7, 50024095, 2, ',50008090,50024095,50005723,', 0),
(50012588, '笔记本屏幕贴膜', 9, 50024095, 2, ',50008090,50024095,50012588,', 0),
(50012585, '笔记本电源', 13, 50024095, 2, ',50008090,50024095,50012585,', 0),
(50024111, '其它笔记本配件', 14, 50024095, 2, ',50008090,50024095,50024111,', 0),
(50010607, '笔记本个性小贴纸', 14, 50024095, 2, ',50008090,50024095,50010607,', 0),
(50024147, '笔记本零部件', 15, 50024095, 2, ',50008090,50024095,50024147,', 0),
(50023360, '笔记本膝上桌', 36, 50024095, 2, ',50008090,50024095,50023360,', 0),
(50003326, '键盘刷', 37, 50024095, 2, ',50008090,50024095,50003326,', 0),
(50012586, '数码相机充电器', 0, 50024096, 2, ',50008090,50024096,50012586,', 0),
(50012581, '数码相机电池', 36, 50024096, 2, ',50008090,50024096,50012581,', 0),
(50024112, '其它数码相机配件', 37, 50024096, 2, ',50008090,50024096,50024112,', 0),
(50012583, '数码相机包', 41, 50024096, 2, ',50008090,50024096,50012583,', 0),
(50050619, '数码相机适配器', 42, 50024096, 2, ',50008090,50024096,50050619,', 0),
(50050620, '数据连接线', 43, 50024096, 2, ',50008090,50024096,50050620,', 0),
(50050621, '屏幕保护膜', 44, 50024096, 2, ',50008090,50024096,50050621,', 0),
(50012846, '影棚设备', 9, 50024097, 2, ',50008090,50024097,50012846,', 1),
(50024115, '其他配件', 12, 50024097, 2, ',50008090,50024097,50024115,', 1),
(50010018, '清洁用品', 34, 50024097, 2, ',50008090,50024097,50010018,', 1),
(50050586, '脚架/云台', 180, 50024097, 2, ',50008090,50024097,50050586,', 1),
(50050591, '背包/箱具', 181, 50024097, 2, ',50008090,50024097,50050591,', 1),
(50050596, '闪光灯', 182, 50024097, 2, ',50008090,50024097,50050596,', 1),
(50050598, '镜头附件', 183, 50024097, 2, ',50008090,50024097,50050598,', 1),
(50050600, '机身附件', 184, 50024097, 2, ',50008090,50024097,50050600,', 1),
(50050608, '单反/单电专用电池电源', 185, 50024097, 2, ',50008090,50024097,50050608,', 1),
(50050612, '色彩管理', 186, 50024097, 2, ',50008090,50024097,50050612,', 1),
(50024116, '平板电脑保护套/壳', 0, 50024098, 2, ',50008090,50024098,50024116,', 0),
(50024117, '平板电脑外接键盘', 1, 50024098, 2, ',50008090,50024098,50024117,', 0),
(50024118, '平板电脑充电器', 2, 50024098, 2, ',50008090,50024098,50024118,', 0),
(50024119, '平板电脑支架', 3, 50024098, 2, ',50008090,50024098,50024119,', 0),
(50024120, '平板电脑底座', 4, 50024098, 2, ',50008090,50024098,50024120,', 0),
(50024121, '其它平板电脑配件', 5, 50024098, 2, ',50008090,50024098,50024121,', 0),
(50024124, '平板电脑包', 42, 50024098, 2, ',50008090,50024098,50024124,', 0),
(50050367, '平板电脑屏幕贴膜', 43, 50024098, 2, ',50008090,50024098,50050367,', 0),
(50050368, '平板电脑数据线', 44, 50024098, 2, ',50008090,50024098,50050368,', 0),
(50050369, '平板电脑零部件', 45, 50024098, 2, ',50008090,50024098,50050369,', 0),
(50018869, 'IC集成电路/电机', 0, 50024099, 2, ',50008090,50024099,50018869,', 1),
(50008179, '线材/线类', 3, 50024099, 2, ',50008090,50024099,50008179,', 1),
(50002918, '电子元件', 18, 50024099, 2, ',50008090,50024099,50002918,', 1),
(50018870, '电子器件', 19, 50024099, 2, ',50008090,50024099,50018870,', 1),
(50024138, '电脑元件/零配件', 20, 50024099, 2, ',50008090,50024099,50024138,', 1),
(50005264, '耳机绕线器', 4, 50024101, 2, ',50008090,50024101,50005264,', 0),
(50008661, '数码收纳整理包', 31, 50024101, 2, ',50008090,50024101,50008661,', 0),
(50023351, '线缆收纳器/集线器', 34, 50024101, 2, ',50008090,50024101,50023351,', 0),
(50025382, '电池收纳盒', 43, 50024101, 2, ',50008090,50024101,50025382,', 0),
(50024122, '数码维修服务', 0, 50024102, 2, ',50008090,50024102,50024122,', 0),
(50024123, '手机套餐服务', 1, 50024102, 2, ',50008090,50024102,50024123,', 0),
(50025268, '摄影摄像服务', 2, 50024102, 2, ',50008090,50024102,50025268,', 0),
(50012617, '电子辞典/学习机配件', 0, 50024104, 2, ',50008090,50024104,50012617,', 0),
(50022561, '点读机/点读笔配件', 144, 50024104, 2, ',50008090,50024104,50022561,', 0),
(50024944, '耳机/耳麦', 0, 50024109, 2, ',50008090,50024109,50024944,', 0),
(50010367, '音乐枕', 1, 50024109, 2, ',50008090,50024109,50010367,', 0),
(50010608, 'PSP游戏配件/周边', 2, 50024109, 2, ',50008090,50024109,50010608,', 0),
(50005267, '迷你小音箱/插卡音箱', 2, 50024109, 2, ',50008090,50024109,50005267,', 0),
(50003781, '手写笔', 10, 50024109, 2, ',50008090,50024109,50003781,', 0),
(50008683, '数码显微镜', 19, 50024109, 2, ',50008090,50024109,50008683,', 0),
(140912, '读卡器', 22, 50024109, 2, ',50008090,50024109,140912,', 0),
(1104, 'PDA/掌上电脑', 29, 50024109, 2, ',50008090,50024109,1104,', 0),
(50003327, '数据线', 33, 50024109, 2, ',50008090,50024109,50003327,', 0),
(50005729, '数码设备外接键盘', 36, 50024109, 2, ',50008090,50024109,50005729,', 0),
(50003774, '其它充电器', 40, 50024109, 2, ',50008090,50024109,50003774,', 0),
(50008681, '其它电池', 41, 50024109, 2, ',50008090,50024109,50008681,', 0),
(50006265, '闪存卡转接套', 81, 50024109, 2, ',50008090,50024109,50006265,', 0),
(50025361, '数码维修工具', 82, 50024109, 2, ',50008090,50024109,50025361,', 0),
(50025701, '触摸屏手套', 83, 50024109, 2, ',50008090,50024109,50025701,', 0),
(50050435, '移动支付终端机', 84, 50024109, 2, ',50008090,50024109,50050435,', 0),
(50013321, '油漆辅料', 1, 50013222, 2, ',27,50013222,50013321,', 1),
(50022304, '丙烯酸乳胶漆', 3, 50013222, 2, ',27,50013222,50022304,', 0),
(50022305, '溶剂型丙烯酸漆', 4, 50013222, 2, ',27,50013222,50022305,', 0),
(50022309, '氨基漆', 8, 50013222, 2, ',27,50013222,50022309,', 0),
(50024843, '民用油性漆', 28, 50013222, 2, ',27,50013222,50024843,', 1),
(50024844, '工业漆', 29, 50013222, 2, ',27,50013222,50024844,', 1),
(50024845, '水性漆', 30, 50013222, 2, ',27,50013222,50024845,', 0),
(50024846, '艺术漆', 31, 50013222, 2, ',27,50013222,50024846,', 0),
(50024847, '其它类油漆', 32, 50013222, 2, ',27,50013222,50024847,', 0),
(50013526, '呼吸防护', 0, 50013226, 2, ',50020332,50013226,50013526,', 1),
(50013527, '手部防护', 1, 50013226, 2, ',50020332,50013226,50013527,', 1),
(50013528, '降噪/隔音耳塞', 2, 50013226, 2, ',50020332,50013226,50013528,', 0),
(50013529, '足部防护鞋', 3, 50013226, 2, ',50020332,50013226,50013529,', 1),
(50013530, '眼部、面部防护', 4, 50013226, 2, ',50020332,50013226,50013530,', 1),
(50013531, '防护服', 5, 50013226, 2, ',50020332,50013226,50013531,', 1),
(50022321, '头部防护', 7, 50013226, 2, ',50020332,50013226,50022321,', 1),
(50022335, '坠落防护', 8, 50013226, 2, ',50020332,50013226,50022335,', 1),
(50022340, '消防防护产品', 9, 50013226, 2, ',50020332,50013226,50022340,', 1),
(50022348, '交通安全保护', 10, 50013226, 2, ',50020332,50013226,50022348,', 1),
(50013294, '游乐场设施', 0, 50013253, 2, ',50010728,50013253,50013294,', 0),
(50013291, '塑胶/运动地板', 1, 50013253, 2, ',50010728,50013253,50013291,', 0),
(50013314, '泳池设备', 3, 50013253, 2, ',50010728,50013253,50013314,', 0),
(50013292, '草地铺设及设备', 4, 50013253, 2, ',50010728,50013253,50013292,', 0),
(50013295, '场馆灯光设备', 8, 50013253, 2, ',50010728,50013253,50013295,', 0),
(50013309, '场馆音响设备', 9, 50013253, 2, ',50010728,50013253,50013309,', 0),
(50013296, '座椅', 10, 50013253, 2, ',50010728,50013253,50013296,', 0),
(50013298, '计时/显示设备', 12, 50013253, 2, ',50010728,50013253,50013298,', 0),
(50013299, '更多场馆设施', 13, 50013253, 2, ',50010728,50013253,50013299,', 0),
(50013323, '其它材质类墙纸', 0, 50013322, 2, ',27,50013322,50013323,', 0),
(50024688, 'PVC墙纸', 2, 50013322, 2, ',27,50013322,50024688,', 0),
(50024689, '纯纸墙纸', 3, 50013322, 2, ',27,50013322,50024689,', 0),
(50024690, '无纺布墙纸', 4, 50013322, 2, ',27,50013322,50024690,', 0),
(50024691, '沙粒墙纸（喷砂壁纸）', 5, 50013322, 2, ',27,50013322,50024691,', 0),
(50024692, '绒面墙纸', 6, 50013322, 2, ',27,50013322,50024692,', 0),
(50013475, '电热水器', 0, 50013474, 2, ',27,50013474,50013475,', 0),
(50013497, '燃气热水器', 1, 50013474, 2, ',27,50013474,50013497,', 0),
(50013498, '太阳能热水器', 2, 50013474, 2, ',27,50013474,50013498,', 0),
(50013499, '空气源热泵热水器', 3, 50013474, 2, ',27,50013474,50013499,', 0),
(50022268, '锅炉及其他热水设备', 4, 50013474, 2, ',27,50013474,50022268,', 0),
(50025836, '小厨宝', 5, 50013474, 2, ',27,50013474,50025836,', 0),
(50025837, '电热水龙头', 6, 50013474, 2, ',27,50013474,50025837,', 0),
(50013478, '账本/账册', 0, 50013477, 2, ',50018004,50013477,50013478,', 0),
(50013479, '凭证', 1, 50013477, 2, ',50018004,50013477,50013479,', 0),
(50013480, '报表', 2, 50013477, 2, ',50018004,50013477,50013480,', 0),
(50013483, '单据/收据', 5, 50013477, 2, ',50018004,50013477,50013483,', 0),
(50013491, '印台', 13, 50013477, 2, ',50018004,50013477,50013491,', 0),
(50013492, '印油/印泥', 14, 50013477, 2, ',50018004,50013477,50013492,', 0),
(50013494, '湿手器', 16, 50013477, 2, ',50018004,50013477,50013494,', 0),
(50013496, '其它财会用品', 18, 50013477, 2, ',50018004,50013477,50013496,', 0),
(50024653, '财务印章', 19, 50013477, 2, ',50018004,50013477,50024653,', 0),
(50013824, '足球', 0, 50013823, 2, ',50010728,50013823,50013824,', 0),
(50013825, '足球服', 1, 50013823, 2, ',50010728,50013823,50013825,', 0),
(50013827, '足球袜', 3, 50013823, 2, ',50010728,50013823,50013827,', 0),
(50017223, '足球鞋钉', 4, 50013823, 2, ',50010728,50013823,50017223,', 0),
(50013829, '守门员手套', 5, 50013823, 2, ',50010728,50013823,50013829,', 0),
(50013830, '足球战术板', 6, 50013823, 2, ',50010728,50013823,50013830,', 0),
(50017226, '足球球门', 6, 50013823, 2, ',50010728,50013823,50017226,', 0),
(50017227, '足球球网', 7, 50013823, 2, ',50010728,50013823,50017227,', 0),
(50017205, '裁判使用', 8, 50013823, 2, ',50010728,50013823,50017205,', 1),
(50017214, '训练背心(分组对抗)', 9, 50013823, 2, ',50010728,50013823,50017214,', 0),
(50017215, '球迷用品', 10, 50013823, 2, ',50010728,50013823,50017215,', 0),
(50017217, '训练辅助用具', 11, 50013823, 2, ',50010728,50013823,50017217,', 1),
(50001714, '婴儿床/儿童床', 0, 50013866, 2, ',50014812,50013866,50001714,', 0),
(50013867, '幼儿园专用床', 1, 50013866, 2, ',50014812,50013866,50013867,', 0),
(50005965, '摇篮', 2, 50013866, 2, ',50014812,50013866,50005965,', 0),
(50005966, '摇椅', 3, 50013866, 2, ',50014812,50013866,50005966,', 0),
(50005964, '餐椅', 4, 50013866, 2, ',50014812,50013866,50005964,', 0),
(50014493, '登山包/双肩背包', 0, 50013887, 2, ',50013886,50013887,50014493,', 0),
(50014494, '腰包/挂包/臂包', 1, 50013887, 2, ',50013886,50013887,50014494,', 0),
(50014495, '旅行包/旅行箱', 4, 50013887, 2, ',50013886,50013887,50014495,', 0),
(50014496, '户外摄影包', 5, 50013887, 2, ',50013886,50013887,50014496,', 0),
(50014500, '钱包/卡包/证件包', 10, 50013887, 2, ',50013886,50013887,50014500,', 0),
(50014502, '防水包/防水箱', 12, 50013887, 2, ',50013886,50013887,50014502,', 0),
(50014503, '挎包/拎包/休闲包', 13, 50013887, 2, ',50013886,50013887,50014503,', 0),
(50015943, '防雨罩/背包配件', 14, 50013887, 2, ',50013886,50013887,50015943,', 0),
(50020102, '旅行收纳包/杂物袋/鞋袋', 15, 50013887, 2, ',50013886,50013887,50020102,', 0),
(50016151, '配件包', 16, 50013887, 2, ',50013886,50013887,50016151,', 0),
(50013928, '冲锋衣裤', 32, 50013888, 2, ',50013886,50013888,50013928,', 1),
(50019517, '速干衣裤', 33, 50013888, 2, ',50013886,50013888,50019517,', 1),
(50013930, '抓绒/软壳衣裤', 34, 50013888, 2, ',50013886,50013888,50013930,', 1),
(50013937, '滑雪服', 35, 50013888, 2, ',50013886,50013888,50013937,', 1),
(50014680, '羽绒服', 36, 50013888, 2, ',50013886,50013888,50014680,', 1),
(50019527, '保暖棉服', 37, 50013888, 2, ',50013886,50013888,50019527,', 1),
(50014796, '功能内衣裤', 38, 50013888, 2, ',50013886,50013888,50014796,', 0),
(50013933, '运动户外风衣', 39, 50013888, 2, ',50013886,50013888,50013933,', 0),
(50014792, '户外休闲衣裤', 40, 50013888, 2, ',50013886,50013888,50014792,', 1),
(50014089, '钓鱼服', 41, 50013888, 2, ',50013886,50013888,50014089,', 0),
(50014137, '潜水服', 42, 50013888, 2, ',50013886,50013888,50014137,', 0),
(50019535, '马术服', 46, 50013888, 2, ',50013886,50013888,50019535,', 0),
(50016143, '一次性内裤', 49, 50013888, 2, ',50013886,50013888,50016143,', 0),
(50015396, '其他户外服装', 50, 50013888, 2, ',50013886,50013888,50015396,', 0),
(50014043, '登山攀岩攀冰', 1, 50013891, 2, ',50013886,50013891,50014043,', 1),
(50014025, '滑雪装备', 6, 50013891, 2, ',50013886,50013891,50014025,', 1),
(50014126, '水上船艇', 17, 50013891, 2, ',50013886,50013891,50014126,', 1),
(50014127, '潜水装备', 18, 50013891, 2, ',50013886,50013891,50014127,', 1),
(50014125, '冲浪/滑水/帆板', 26, 50013891, 2, ',50013886,50013891,50014125,', 1),
(50014200, '风筝/滑翔伞', 35, 50013891, 2, ',50013886,50013891,50014200,', 1),
(50013899, '野餐垫', 5, 50013892, 2, ',50013886,50013892,50013899,', 0),
(50018828, '户外桌椅套装', 10, 50013892, 2, ',50013886,50013892,50018828,', 0),
(50013893, '户外桌子', 11, 50013892, 2, ',50013886,50013892,50013893,', 0),
(50013894, '户外椅子凳子', 12, 50013892, 2, ',50013886,50013892,50013894,', 0),
(50013895, '吊床', 13, 50013892, 2, ',50013886,50013892,50013895,', 0),
(50013905, '秋千', 27, 50013892, 2, ',50013886,50013892,50013905,', 0),
(50013927, '户外床/折叠床', 29, 50013892, 2, ',50013886,50013892,50013927,', 0),
(50015229, '充气床', 30, 50013892, 2, ',50013886,50013892,50015229,', 0),
(50013906, '其他', 31, 50013892, 2, ',50013886,50013892,50013906,', 0),
(50014075, '钓竿', 3, 50014023, 2, ',50013886,50014023,50014075,', 0),
(50017238, '渔具套装', 4, 50014023, 2, ',50013886,50014023,50017238,', 0),
(50014077, '鱼线', 5, 50014023, 2, ',50013886,50014023,50014077,', 0),
(50014095, '鱼线轮', 6, 50014023, 2, ',50013886,50014023,50014095,', 0),
(50014080, '支架', 9, 50014023, 2, ',50013886,50014023,50014080,', 0),
(50014076, '鱼钩', 10, 50014023, 2, ',50013886,50014023,50014076,', 0),
(50014078, '浮漂', 11, 50014023, 2, ',50013886,50014023,50014078,', 0),
(50014079, '鱼饵', 14, 50014023, 2, ',50013886,50014023,50014079,', 0),
(50014081, '渔具包', 16, 50014023, 2, ',50013886,50014023,50014081,', 0),
(50014084, '钓鱼帽', 19, 50014023, 2, ',50013886,50014023,50014084,', 0),
(50014085, '抄网', 20, 50014023, 2, ',50013886,50014023,50014085,', 0),
(50014087, '鱼护', 21, 50014023, 2, ',50013886,50014023,50014087,', 0),
(50014088, '钓箱', 22, 50014023, 2, ',50013886,50014023,50014088,', 0),
(50017575, '钓鱼椅、凳', 23, 50014023, 2, ',50013886,50014023,50017575,', 0),
(50017576, '钓鱼伞', 24, 50014023, 2, ',50013886,50014023,50017576,', 0),
(50017755, '钓台', 25, 50014023, 2, ',50013886,50014023,50017755,', 0),
(50014092, '钓鱼鞋', 33, 50014023, 2, ',50013886,50014023,50014092,', 0),
(50014094, '鱼网/虾笼/其它渔具', 39, 50014023, 2, ',50013886,50014023,50014094,', 0),
(50017188, '探鱼器', 41, 50014023, 2, ',50013886,50014023,50017188,', 0),
(50014097, '垂钓小配件', 44, 50014023, 2, ',50013886,50014023,50014097,', 0),
(50014098, '垂钓音像书刊', 45, 50014023, 2, ',50013886,50014023,50014098,', 0),
(50014099, '其他垂钓用品', 46, 50014023, 2, ',50013886,50014023,50014099,', 0),
(50023430, '路亚钳', 47, 50014023, 2, ',50013886,50014023,50023430,', 0),
(50023431, '绑钩器', 48, 50014023, 2, ',50013886,50014023,50023431,', 0),
(50023432, '脱钩器', 49, 50014023, 2, ',50013886,50014023,50023432,', 0),
(50023433, '止血钳', 50, 50014023, 2, ',50013886,50014023,50023433,', 0),
(50023434, '控鱼钳', 51, 50014023, 2, ',50013886,50014023,50023434,', 0),
(50023435, '伸缩扣', 52, 50014023, 2, ',50013886,50014023,50023435,', 0),
(50014238, '耳环', 0, 50014227, 2, ',50013864,50014227,50014238,', 0),
(50014239, '耳钉', 1, 50014227, 2, ',50013864,50014227,50014239,', 0),
(50014240, '耳线', 2, 50014227, 2, ',50013864,50014227,50014240,', 0),
(50024815, '耳夹', 3, 50014227, 2, ',50013864,50014227,50024815,', 0),
(50000567, '保鲜盒', 0, 50014236, 2, ',50016349,50014236,50000567,', 0),
(50014237, '保鲜盖', 2, 50014236, 2, ',50016349,50014236,50014237,', 0),
(50024610, '保温袋', 4, 50014236, 2, ',50016349,50014236,50024610,', 0),
(50014260, '礼盒套装', 1, 50014248, 2, ',50014812,50014248,50014260,', 0),
(50014250, '洗发/护发', 2, 50014248, 2, ',50014812,50014248,50014250,', 0),
(50014259, '沐浴系列', 3, 50014248, 2, ',50014812,50014248,50014259,', 0),
(50014253, '润肤系列', 4, 50014248, 2, ',50014812,50014248,50014253,', 0),
(50014255, '爽身粉 /痱子粉', 5, 50014248, 2, ',50014812,50014248,50014255,', 0),
(50014257, '护臀系列', 6, 50014248, 2, ',50014812,50014248,50014257,', 0),
(50014249, '护唇/润唇', 7, 50014248, 2, ',50014812,50014248,50014249,', 0),
(50014258, '防晒系列', 8, 50014248, 2, ',50014812,50014248,50014258,', 0),
(50014256, '驱蚊膏/止痒水', 9, 50014248, 2, ',50014812,50014248,50014256,', 0),
(50014254, '婴儿皂类', 10, 50014248, 2, ',50014812,50014248,50014254,', 0),
(50014741, '洗手液', 17, 50014248, 2, ',50014812,50014248,50014741,', 0),
(50004439, '其它', 31, 50014248, 2, ',50014812,50014248,50004439,', 0),
(50014509, '汽车美容漆/膜/蜡工具', 5, 50014479, 2, ',26,50014479,50014509,', 1),
(50014511, '汽车维修/工具', 14, 50014479, 2, ',26,50014479,50014511,', 1),
(50014507, '汽车添加剂/养护品', 23, 50014479, 2, ',26,50014479,50014507,', 1),
(50012090, '汽车座垫', 0, 50014480, 2, ',26,50014480,50012090,', 0),
(50012089, '专车专用座套', 1, 50014480, 2, ',26,50014480,50012089,', 0),
(50016726, '通用座套', 2, 50014480, 2, ',26,50014480,50016726,', 0),
(50016722, '专车专用脚垫', 3, 50014480, 2, ',26,50014480,50016722,', 0),
(50012138, '通用脚垫', 4, 50014480, 2, ',26,50014480,50012138,', 0),
(50016579, '包真皮座套', 5, 50014480, 2, ',26,50014480,50016579,', 0),
(50012140, '专车专用后备箱垫', 6, 50014480, 2, ',26,50014480,50012140,', 0),
(50016723, '通用后备箱垫', 7, 50014480, 2, ',26,50014480,50016723,', 0),
(50012094, '方向盘套', 8, 50014480, 2, ',26,50014480,50012094,', 0),
(50012141, '汽车宠物垫', 8, 50014480, 2, ',26,50014480,50012141,', 0),
(50018690, '汽车用品小套饰', 9, 50014480, 2, ',26,50014480,50018690,', 0),
(50012139, '车用防滑垫', 10, 50014480, 2, ',26,50014480,50012139,', 0),
(50018697, '车用头枕/抱枕/腰靠', 11, 50014480, 2, ',26,50014480,50018697,', 0),
(50018810, '车用挂饰/摆件/纪念品', 12, 50014480, 2, ',26,50014480,50018810,', 0),
(50018689, '车用置物袋/置物箱', 13, 50014480, 2, ',26,50014480,50018689,', 0),
(50012102, '车用窗帘', 14, 50014480, 2, ',26,50014480,50012102,', 0),
(50018698, '汽车香水/净化/降温剂', 19, 50014480, 2, ',26,50014480,50018698,', 1),
(50014699, '地胶', 23, 50014480, 2, ',26,50014480,50014699,', 0),
(50016329, '脚踏板防滑垫', 23, 50014480, 2, ',26,50014480,50016329,', 0),
(50012118, 'CD包/夹/袋', 30, 50014480, 2, ',26,50014480,50012118,', 0),
(50014522, '驾车个人用品', 33, 50014480, 2, ',26,50014480,50014522,', 1),
(50015876, '遮阳挡/避光垫', 37, 50014480, 2, ',26,50014480,50015876,', 0),
(50015556, '汽车模型', 38, 50014480, 2, ',26,50014480,50015556,', 0),
(50010595, '汽车儿童安全座椅', 44, 50014480, 2, ',26,50014480,50010595,', 0),
(50012130, '其它汽车用品/内饰', 51, 50014480, 2, ',26,50014480,50012130,', 0),
(50022749, '汽车外饰品', 73, 50014481, 2, ',26,50014481,50022749,', 1),
(50022750, '汽车防护', 74, 50014481, 2, ',26,50014481,50022750,', 1),
(50022751, '加装/装潢', 75, 50014481, 2, ',26,50014481,50022751,', 1),
(50022743, '汽车电子防盗安防', 51, 50014482, 2, ',26,50014482,50022743,', 1),
(50022744, '汽车影音', 52, 50014482, 2, ',26,50014482,50022744,', 1),
(50022745, '车用电子/电器', 53, 50014482, 2, ',26,50014482,50022745,', 1),
(50003794, '摩托车整车', 0, 50014648, 2, ',26,50014648,50003794,', 0),
(50022885, '其他摩托车', 1, 50014648, 2, ',26,50014648,50022885,', 0),
(261406, '摩托车配件', 3, 50014648, 2, ',26,50014648,261406,', 0),
(50016451, '摩托车机油', 4, 50014648, 2, ',26,50014648,50016451,', 0),
(50017189, '摩托车防盗器', 5, 50014648, 2, ',26,50014648,50017189,', 0),
(50015539, '摩托车维修工具', 6, 50014648, 2, ',26,50014648,50015539,', 0),
(50012651, '骑士装备', 7, 50014648, 2, ',26,50014648,50012651,', 1),
(261407, '其他摩托车用品', 8, 50014648, 2, ',26,50014648,261407,', 0),
(50014771, '防潮垫', 0, 50014756, 2, ',50013886,50014756,50014771,', 0),
(50014772, '地布/地席', 1, 50014756, 2, ',50013886,50014756,50014772,', 0),
(50014773, '枕头', 2, 50014756, 2, ',50013886,50014756,50014773,', 0),
(50014774, '其他垫子', 3, 50014756, 2, ',50013886,50014756,50014774,', 0),
(50016111, '辅配件', 4, 50014756, 2, ',50013886,50014756,50016111,', 0),
(50013896, '烧烤炉/烤架', 0, 50014757, 2, ',50013886,50014757,50013896,', 0),
(50016332, '烧烤夹/针/烧烤配件', 1, 50014757, 2, ',50013886,50014757,50016332,', 0),
(50014836, '野餐炉具', 2, 50014757, 2, ',50013886,50014757,50014836,', 0),
(50014837, '套锅/户外炊具', 3, 50014757, 2, ',50013886,50014757,50014837,', 0),
(50014840, '野餐餐具', 4, 50014757, 2, ',50013886,50014757,50014840,', 0),
(50018178, '调味盒/调料瓶', 5, 50014757, 2, ',50013886,50014757,50018178,', 0),
(50013898, '野餐包/户外餐具套装', 6, 50014757, 2, ',50013886,50014757,50013898,', 0),
(50013901, '野餐篮/鸡蛋蓝/食品袋', 7, 50014757, 2, ',50013886,50014757,50013901,', 0),
(50013955, '冰包/冰桶/保鲜包', 8, 50014757, 2, ',50013886,50014757,50013955,', 0),
(50014838, '燃料', 9, 50014757, 2, ',50013886,50014757,50014838,', 0),
(50014893, '打火机/火柴/喷枪/点火装置', 10, 50014757, 2, ',50013886,50014757,50014893,', 0),
(50016342, '挡风板', 11, 50014757, 2, ',50013886,50014757,50016342,', 0),
(50018179, '户外鼓风机', 20, 50014757, 2, ',50013886,50014757,50018179,', 0),
(50014894, '其他', 21, 50014757, 2, ',50013886,50014757,50014894,', 0),
(50019694, '瑞士军刀', 0, 50014759, 2, ',50013886,50014759,50019694,', 0),
(50018248, '其他户外刀具', 1, 50014759, 2, ',50013886,50014759,50018248,', 0),
(50014822, '多功能组合工具', 2, 50014759, 2, ',50013886,50014759,50014822,', 0),
(50018249, '磨刀石/磨刀棒/护刀油', 3, 50014759, 2, ',50013886,50014759,50018249,', 0),
(50018175, '军刀卡/万能刀卡', 5, 50014759, 2, ',50013886,50014759,50018175,', 0),
(50019695, '刀鞘/刀套', 6, 50014759, 2, ',50013886,50014759,50019695,', 0),
(50014823, '工兵铲/工兵锹', 7, 50014759, 2, ',50013886,50014759,50014823,', 0),
(50018247, '工兵斧/营地斧', 8, 50014759, 2, ',50013886,50014759,50018247,', 0),
(50018157, '放大镜', 10, 50014759, 2, ',50013886,50014759,50018157,', 0),
(50018827, '挂扣', 11, 50014759, 2, ',50013886,50014759,50018827,', 0),
(50018221, '伞绳', 13, 50014759, 2, ',50013886,50014759,50018221,', 0),
(50015743, '野营旅行小配件', 15, 50014759, 2, ',50013886,50014759,50015743,', 0),
(50014824, '其他', 18, 50014759, 2, ',50013886,50014759,50014824,', 0),
(50014779, '指南针/温度计/气压计/高度计', 0, 50014763, 2, ',50013886,50014763,50014779,', 0),
(50014780, 'GPS/电子导航设备', 1, 50014763, 2, ',50013886,50014763,50014780,', 0),
(50014781, '户外功能手表', 2, 50014763, 2, ',50013886,50014763,50014781,', 0),
(50014782, '无线电/对讲机/通讯设备', 3, 50014763, 2, ',50013886,50014763,50014782,', 0),
(50015750, '其他表类', 4, 50014763, 2, ',50013886,50014763,50015750,', 0),
(50016081, '毛巾', 0, 50014764, 2, ',50013886,50014764,50016081,', 0),
(50016145, '口腔清洁护理', 1, 50014764, 2, ',50013886,50014764,50016145,', 0),
(50015985, '洗漱包/化妆包', 2, 50014764, 2, ',50013886,50014764,50015985,', 0),
(50019771, '香皂/洗发水/沐浴露/洗面乳', 3, 50014764, 2, ',50013886,50014764,50019771,', 0),
(50019772, '梳子/镜子/发卡/美发用品', 4, 50014764, 2, ',50013886,50014764,50019772,', 0),
(50019773, '剃须刀', 5, 50014764, 2, ',50013886,50014764,50019773,', 0),
(50016142, '洗手液', 6, 50014764, 2, ',50013886,50014764,50016142,', 0),
(50019774, '防虫/防蚊用品', 7, 50014764, 2, ',50013886,50014764,50019774,', 0),
(50016144, '马桶垫', 10, 50014764, 2, ',50013886,50014764,50016144,', 0),
(50016082, '其它', 12, 50014764, 2, ',50013886,50014764,50016082,', 0),
(50014783, '地图', 0, 50014767, 2, ',50013886,50014767,50014783,', 0),
(50015143, '旅行指南', 1, 50014767, 2, ',50013886,50014767,50015143,', 0),
(50015144, '影像资料', 2, 50014767, 2, ',50013886,50014767,50015144,', 0),
(50015145, '杂志', 3, 50014767, 2, ',50013886,50014767,50015145,', 0),
(50015146, '专题文献', 4, 50014767, 2, ',50013886,50014767,50015146,', 0),
(50015147, '其他', 5, 50014767, 2, ',50013886,50014767,50015147,', 0),
(50014933, '2D/3D绘图', 0, 50014854, 2, ',50025004,50014854,50014933,', 0),
(50014935, 'FLASH/动画制作', 1, 50014854, 2, ',50025004,50014854,50014935,', 0),
(50014936, '服饰设计', 2, 50014854, 2, ',50025004,50014854,50014936,', 0),
(50014937, '工业设计', 3, 50014854, 2, ',50025004,50014854,50014937,', 1),
(50014939, '装饰工程', 4, 50014854, 2, ',50025004,50014854,50014939,', 1),
(50014941, '卡通/动漫/插画', 5, 50014854, 2, ',50025004,50014854,50014941,', 0),
(50014942, '平面设计', 6, 50014854, 2, ',50025004,50014854,50014942,', 1),
(50016437, '设计素材\\源文件', 7, 50014854, 2, ',50025004,50014854,50016437,', 0),
(50025054, '诗词定制', 8, 50014854, 2, ',50025004,50014854,50025054,', 0),
(50025055, '其它设计服务', 9, 50014854, 2, ',50025004,50014854,50025055,', 0),
(50012879, '个性签名', 10, 50014854, 2, ',50025004,50014854,50012879,', 0),
(50014938, '奖杯/奖牌/奖状/证书', 2, 50014920, 2, ',50025004,50014920,50014938,', 0),
(50014944, '图案印制类', 5, 50014920, 2, ',50025004,50014920,50014944,', 0),
(50019103, '学习卡', 0, 50014927, 2, ',50025111,50014927,50019103,', 0),
(50026625, '线下面授课程', 19, 50014927, 2, ',50025111,50014927,50026625,', 1),
(50026608, '教程/教材/资料', 20, 50014927, 2, ',50025111,50014927,50026608,', 1),
(50026627, '教学服务', 23, 50014927, 2, ',50025111,50014927,50026627,', 1),
(50050439, '线上远程教学', 26, 50014927, 2, ',50025111,50014927,50050439,', 1),
(50014232, '写字板/画板/画布/绘画桌', 0, 50015127, 2, ',25,50015127,50014232,', 0),
(50015128, '描红本/临摹写字本', 1, 50015127, 2, ',25,50015127,50015128,', 0),
(50023684, '学画本/涂色本/平面填色', 2, 50015127, 2, ',25,50015127,50023684,', 0),
(50023679, '颜料/笔刷/调色盘', 7, 50015127, 2, ',25,50015127,50023679,', 1),
(50023680, '蜡笔/油画棒', 8, 50015127, 2, ',25,50015127,50023680,', 0),
(50023681, '水彩笔', 9, 50015127, 2, ',25,50015127,50023681,', 0),
(50023682, '马克笔/荧光笔', 10, 50015127, 2, ',25,50015127,50023682,', 0),
(50023683, '粉笔', 11, 50015127, 2, ',25,50015127,50023683,', 0),
(50023714, '儿童铅笔', 17, 50015127, 2, ',25,50015127,50023714,', 0),
(50015130, '笔袋/笔盒/文件袋', 20, 50015127, 2, ',25,50015127,50015130,', 0),
(50015132, '削笔器/削笔刀', 21, 50015127, 2, ',25,50015127,50015132,', 0),
(50023685, '卡通造型橡皮', 22, 50015127, 2, ',25,50015127,50023685,', 0),
(50015129, '文具礼盒/绘画套装', 25, 50015127, 2, ',25,50015127,50015129,', 0),
(50023715, '其他儿童文具', 26, 50015127, 2, ',25,50015127,50023715,', 0),
(50015135, '鹿茸片', 0, 50015134, 2, ',50020275,50015134,50015135,', 0),
(50015136, '鹿茸枝', 1, 50015134, 2, ',50020275,50015134,50015136,', 0),
(50015137, '鹿胎膏', 2, 50015134, 2, ',50020275,50015134,50015137,', 0),
(50008045, '其它鹿类滋补品', 6, 50015134, 2, ',50020275,50015134,50008045,', 0),
(50015195, '整枝灵芝', 0, 50015194, 2, ',50020275,50015194,50015195,', 0),
(50015196, '灵芝片', 1, 50015194, 2, ',50020275,50015194,50015196,', 0),
(50015197, '灵芝粉', 2, 50015194, 2, ',50020275,50015194,50015197,', 0),
(50015198, '破壁灵芝孢子粉', 3, 50015194, 2, ',50020275,50015194,50015198,', 0),
(50008047, '其它灵芝产品', 7, 50015194, 2, ',50020275,50015194,50008047,', 0),
(50015827, '儿童床', 0, 50015200, 2, ',50008164,50015200,50015827,', 0),
(50015825, '婴儿床', 0, 50015200, 2, ',50008164,50015200,50015825,', 0),
(50015202, '高低/子母床', 1, 50015200, 2, ',50008164,50015200,50015202,', 0),
(50019997, '实木床', 6, 50015200, 2, ',50008164,50015200,50019997,', 0),
(50019999, '布艺床', 8, 50015200, 2, ',50008164,50015200,50019999,', 0),
(50020000, '皮艺床', 9, 50015200, 2, ',50008164,50015200,50020000,', 0),
(50020001, '藤艺床', 10, 50015200, 2, ',50008164,50015200,50020001,', 0),
(50020002, '板式床', 11, 50015200, 2, ',50008164,50015200,50020002,', 0),
(50019998, '铁艺/钢木床', 13, 50015200, 2, ',50008164,50015200,50019998,', 0),
(50022704, '铜床', 15, 50015200, 2, ',50008164,50015200,50022704,', 0),
(50020626, '充气床', 16, 50015200, 2, ',50008164,50015200,50020626,', 0),
(50020627, '折叠床/午休床', 17, 50015200, 2, ',50008164,50015200,50020627,', 0),
(50022451, '罗汉床', 18, 50015200, 2, ',50008164,50015200,50022451,', 0),
(50022453, '拔步床/架子床', 19, 50015200, 2, ',50008164,50015200,50022453,', 0),
(50015651, '床架/床板', 21, 50015200, 2, ',50008164,50015200,50015651,', 0),
(50020629, '床配件', 22, 50015200, 2, ',50008164,50015200,50020629,', 1),
(50008048, '枸杞', 1, 50015207, 2, ',50020275,50015207,50008048,', 0),
(50015209, '枸杞制品', 2, 50015207, 2, ',50020275,50015207,50015209,', 0),
(50015214, '雪蛤油', 2, 50015211, 2, ',50020275,50015211,50015214,', 0),
(50015213, '雪蛤干', 3, 50015211, 2, ',50020275,50015211,50015213,', 0),
(50008908, '其它雪蛤制品', 5, 50015211, 2, ',50020275,50015211,50008908,', 0),
(50015272, '其他药食同源食品', 0, 50015218, 2, ',50020275,50015218,50015272,', 0),
(50009983, '黄芩', 19, 50015218, 2, ',50020275,50015218,50009983,', 0),
(50009979, '山药', 23, 50015218, 2, ',50020275,50015218,50009979,', 0),
(50009986, '川贝', 24, 50015218, 2, ',50020275,50015218,50009986,', 0),
(50008665, '风流果', 27, 50015218, 2, ',50020275,50015218,50008665,', 0),
(50012190, '茯苓', 33, 50015218, 2, ',50020275,50015218,50012190,', 0),
(50012196, '决明子', 39, 50015218, 2, ',50020275,50015218,50012196,', 0),
(50020305, '牛蒡', 40, 50015218, 2, ',50020275,50015218,50020305,', 0),
(50020306, '玫瑰茄', 41, 50015218, 2, ',50020275,50015218,50020306,', 0),
(50020307, '甘草', 42, 50015218, 2, ',50020275,50015218,50020307,', 0),
(50020308, '白果', 43, 50015218, 2, ',50020275,50015218,50020308,', 0),
(50020309, '白扁豆', 44, 50015218, 2, ',50020275,50015218,50020309,', 0),
(50020310, '佛手', 45, 50015218, 2, ',50020275,50015218,50020310,', 0),
(50020311, '沙棘', 46, 50015218, 2, ',50020275,50015218,50020311,', 0),
(50020312, '芡实', 47, 50015218, 2, ',50020275,50015218,50020312,', 0),
(50020313, '鸡内金', 48, 50015218, 2, ',50020275,50015218,50020313,', 0),
(50020314, '罗汉果', 49, 50015218, 2, ',50020275,50015218,50020314,', 0),
(50020315, '金银花', 50, 50015218, 2, ',50020275,50015218,50020315,', 0),
(50020316, '鱼腥草', 51, 50015218, 2, ',50020275,50015218,50020316,', 0),
(50020317, '砂仁', 52, 50015218, 2, ',50020275,50015218,50020317,', 0),
(50020318, '胖大海', 53, 50015218, 2, ',50020275,50015218,50020318,', 0),
(50020319, '桑叶', 54, 50015218, 2, ',50020275,50015218,50020319,', 0),
(50020320, '桔梗', 55, 50015218, 2, ',50020275,50015218,50020320,', 0),
(50020321, '紫苏', 56, 50015218, 2, ',50020275,50015218,50020321,', 0),
(50020322, '酸枣仁', 57, 50015218, 2, ',50020275,50015218,50020322,', 0),
(50020323, '天门冬', 58, 50015218, 2, ',50020275,50015218,50020323,', 0),
(50050425, '百合', 59, 50015218, 2, ',50020275,50015218,50050425,', 0),
(50050426, '栀子', 60, 50015218, 2, ',50020275,50015218,50050426,', 0),
(50050427, '桑椹', 61, 50015218, 2, ',50020275,50015218,50050427,', 0),
(50050428, '肉桂', 62, 50015218, 2, ',50020275,50015218,50050428,', 0),
(50050429, '荷叶', 63, 50015218, 2, ',50020275,50015218,50050429,', 0),
(50050430, '橘皮', 64, 50015218, 2, ',50020275,50015218,50050430,', 0),
(50050431, '杏仁', 65, 50015218, 2, ',50020275,50015218,50050431,', 0),
(50050432, '葛根', 66, 50015218, 2, ',50020275,50015218,50050432,', 0),
(50050433, '龙眼肉（桂圆）', 67, 50015218, 2, ',50020275,50015218,50050433,', 0),
(50050434, '黄精', 68, 50015218, 2, ',50020275,50015218,50050434,', 0),
(50015223, '阿胶原粉', 3, 50015219, 2, ',50020275,50015219,50015223,', 0),
(50015221, '阿胶膏/固元膏', 4, 50015219, 2, ',50020275,50015219,50015221,', 0),
(50015222, '阿胶浆', 5, 50015219, 2, ',50020275,50015219,50015222,', 0),
(50012191, '其它阿胶制品', 7, 50015219, 2, ',50020275,50015219,50012191,', 0),
(50015231, '伞具', 0, 50015230, 2, ',50008164,50015230,50015231,', 1),
(50015232, '椅子', 1, 50015230, 2, ',50008164,50015230,50015232,', 1),
(50015239, '桌', 2, 50015230, 2, ',50008164,50015230,50015239,', 1),
(50015242, '桌椅套件', 3, 50015230, 2, ',50008164,50015230,50015242,', 0),
(50015243, '户外床', 4, 50015230, 2, ',50008164,50015230,50015243,', 1),
(50015248, '木屋凉亭', 6, 50015230, 2, ',50008164,50015230,50015248,', 0),
(50015249, '垃圾筒', 7, 50015230, 2, ',50008164,50015230,50015249,', 0),
(50015322, '窝/屋/帐篷', 0, 50015285, 2, ',29,50015285,50015322,', 0),
(50015323, '笼子', 1, 50015285, 2, ',29,50015285,50015323,', 0),
(50015324, '床/垫/沙发', 2, 50015285, 2, ',29,50015285,50015324,', 0),
(50015325, '背包/箱包', 3, 50015285, 2, ',29,50015285,50015325,', 0),
(50023174, '宠物推车', 4, 50015285, 2, ',29,50015285,50023174,', 0),
(50015326, '航空箱', 5, 50015285, 2, ',29,50015285,50015326,', 0),
(50015327, '专业比赛牵引带', 6, 50015285, 2, ',29,50015285,50015327,', 0),
(50015328, '家用牵引带', 7, 50015285, 2, ',29,50015285,50015328,', 0),
(50015330, '项圈', 9, 50015285, 2, ',29,50015285,50015330,', 0),
(50015331, '嘴套', 10, 50015285, 2, ',29,50015285,50015331,', 0),
(50015332, '碗/勺/杯', 11, 50015285, 2, ',29,50015285,50015332,', 0),
(50023173, '自动喂食器', 12, 50015285, 2, ',29,50015285,50023173,', 0),
(50015334, '饮水器/水壶/水头', 13, 50015285, 2, ',29,50015285,50015334,', 0),
(50015333, '储粮桶', 14, 50015285, 2, ',29,50015285,50015333,', 0),
(50015335, '散热板', 16, 50015285, 2, ',29,50015285,50015335,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50015336, '电热板/电热毯', 17, 50015285, 2, ',29,50015285,50015336,', 0),
(50015338, '诱导剂', 19, 50015285, 2, ',29,50015285,50015338,', 0),
(50015341, '止吠器', 20, 50015285, 2, ',29,50015285,50015341,', 0),
(50023175, '训练器', 21, 50015285, 2, ',29,50015285,50023175,', 0),
(50015342, '语言翻译机', 22, 50015285, 2, ',29,50015285,50015342,', 0),
(50023176, '追踪器', 23, 50015285, 2, ',29,50015285,50023176,', 0),
(50016385, '更多日用品', 33, 50015285, 2, ',29,50015285,50016385,', 0),
(50015704, '兔', 0, 50015292, 2, ',29,50015292,50015704,', 0),
(50023331, '兔兔主粮', 1, 50015292, 2, ',29,50015292,50023331,', 0),
(50023332, '兔兔零食', 2, 50015292, 2, ',29,50015292,50023332,', 0),
(50023333, '兔兔干草', 3, 50015292, 2, ',29,50015292,50023333,', 0),
(50023334, '兔兔磨牙', 4, 50015292, 2, ',29,50015292,50023334,', 0),
(50015706, '兔兔用品', 6, 50015292, 2, ',29,50015292,50015706,', 0),
(50015707, '兔兔医疗/保健品', 7, 50015292, 2, ',29,50015292,50015707,', 0),
(50015710, '仓鼠', 0, 50015293, 2, ',29,50015293,50015710,', 0),
(50015711, '龙猫', 1, 50015293, 2, ',29,50015293,50015711,', 0),
(50015713, '飞鼠', 3, 50015293, 2, ',29,50015293,50015713,', 0),
(50015715, '豚鼠', 5, 50015293, 2, ',29,50015293,50015715,', 0),
(50015716, '香猪', 6, 50015293, 2, ',29,50015293,50015716,', 0),
(50023263, '宠物貂', 7, 50015293, 2, ',29,50015293,50023263,', 0),
(50023264, '宠物狐狸', 8, 50015293, 2, ',29,50015293,50023264,', 0),
(50015717, '饲料/零食', 9, 50015293, 2, ',29,50015293,50015717,', 0),
(50015718, '小宠用品', 10, 50015293, 2, ',29,50015293,50015718,', 0),
(50015719, '医疗/保健品', 11, 50015293, 2, ',29,50015293,50015719,', 0),
(50016048, '马', 0, 50015294, 2, ',29,50015294,50016048,', 0),
(50015725, '马饲料', 1, 50015294, 2, ',29,50015294,50015725,', 0),
(50015720, '马鞍', 2, 50015294, 2, ',29,50015294,50015720,', 0),
(50015721, '马口衔/马嚼子', 3, 50015294, 2, ',29,50015294,50015721,', 0),
(50015722, '马刺', 4, 50015294, 2, ',29,50015294,50015722,', 0),
(50015723, '马笼套', 5, 50015294, 2, ',29,50015294,50015723,', 0),
(50015724, '马蹄挫', 6, 50015294, 2, ',29,50015294,50015724,', 0),
(50015727, '托运服务', 0, 50015295, 2, ',29,50015295,50015727,', 0),
(50015729, '寄养服务', 2, 50015295, 2, ',29,50015295,50015729,', 0),
(50015728, '配种服务', 3, 50015295, 2, ',29,50015295,50015728,', 0),
(50015730, '洗浴美容服务', 5, 50015295, 2, ',29,50015295,50015730,', 0),
(50015731, '摄像/台历/写真制作', 6, 50015295, 2, ',29,50015295,50015731,', 0),
(50023353, '殡葬服务', 7, 50015295, 2, ',29,50015295,50023353,', 0),
(50023354, '训犬服务', 8, 50015295, 2, ',29,50015295,50023354,', 0),
(50023355, '牵犬服务', 9, 50015295, 2, ',29,50015295,50023355,', 0),
(50023356, '其他服务', 10, 50015295, 2, ',29,50015295,50023356,', 0),
(50015369, '帽子', 0, 50015368, 2, ',50013886,50015368,50015369,', 0),
(50015370, '手套', 1, 50015368, 2, ',50013886,50015368,50015370,', 0),
(50015371, '头巾/遮耳', 2, 50015368, 2, ',50013886,50015368,50015371,', 0),
(50015372, '围巾/围脖', 3, 50015368, 2, ',50013886,50015368,50015372,', 0),
(50018244, '腰带', 4, 50015368, 2, ',50013886,50015368,50018244,', 0),
(50015373, '雪套/套脚', 5, 50015368, 2, ',50013886,50015368,50015373,', 0),
(50015377, '雨衣/雨裤/雨披', 9, 50015368, 2, ',50013886,50015368,50015377,', 0),
(50018245, '贴章/魔术贴章', 10, 50015368, 2, ',50013886,50015368,50018245,', 0),
(50015376, '其他服饰配件', 11, 50015368, 2, ',50013886,50015368,50015376,', 0),
(50015461, '椅', 4, 50015455, 2, ',50008164,50015455,50015461,', 1),
(50015462, '凳', 5, 50015455, 2, ',50008164,50015455,50015462,', 1),
(50015638, '坐具配件', 7, 50015455, 2, ',50008164,50015455,50015638,', 1),
(50007017, '超市货架', 1, 50015518, 2, ',50020611,50015518,50007017,', 0),
(50001716, '精品展柜/陈列柜', 2, 50015518, 2, ',50020611,50015518,50001716,', 0),
(50007016, '仓储货架', 3, 50015518, 2, ',50020611,50015518,50007016,', 0),
(50020689, '促销架/促销车', 5, 50015518, 2, ',50020611,50015518,50020689,', 0),
(50020693, '面包架', 6, 50015518, 2, ',50020611,50015518,50020693,', 0),
(50020694, '水果架', 13, 50015518, 2, ',50020611,50015518,50020694,', 0),
(50020695, '蔬菜架', 14, 50015518, 2, ',50020611,50015518,50020695,', 0),
(50020699, '化妆品架/柜', 18, 50015518, 2, ',50020611,50015518,50020699,', 0),
(50020702, '安全套架', 21, 50015518, 2, ',50020611,50015518,50020702,', 0),
(50023191, '服装货架', 23, 50015518, 2, ',50020611,50015518,50023191,', 0),
(50023194, '饰品架/柜', 26, 50015518, 2, ',50020611,50015518,50023194,', 0),
(50023195, '内衣货架', 27, 50015518, 2, ',50020611,50015518,50023195,', 0),
(50023196, '眼镜货架', 28, 50015518, 2, ',50020611,50015518,50023196,', 0),
(50023198, '鞋货架', 29, 50015518, 2, ',50020611,50015518,50023198,', 0),
(50023197, '图书音像货架', 30, 50015518, 2, ',50020611,50015518,50023197,', 0),
(50020703, '货架附件', 31, 50015518, 2, ',50020611,50015518,50020703,', 0),
(50001423, '其它货架', 33, 50015518, 2, ',50020611,50015518,50001423,', 0),
(50023265, '五金工具货架', 36, 50015518, 2, ',50020611,50015518,50023265,', 0),
(50015543, '酒店桌椅', 0, 50015541, 2, ',50020611,50015541,50015543,', 0),
(50015542, '酒店沙发', 1, 50015541, 2, ',50020611,50015541,50015542,', 0),
(50015545, '酒店单间/标间/成套家具', 3, 50015541, 2, ',50020611,50015541,50015545,', 0),
(50015550, '酒店行李柜', 10, 50015541, 2, ',50020611,50015541,50015550,', 0),
(50015553, '棋牌桌', 12, 50015541, 2, ',50020611,50015541,50015553,', 0),
(50015554, '其它酒店家具', 13, 50015541, 2, ',50020611,50015541,50015554,', 0),
(50015560, '冷柜', 0, 50015558, 2, ',50022703,50015558,50015560,', 0),
(50015562, '迷你/便携/车载冷热箱', 1, 50015558, 2, ',50022703,50015558,50015562,', 0),
(50015672, '床/床垫', 0, 50015566, 2, ',50008164,50015566,50015672,', 0),
(50015673, '沙发/沙发床', 1, 50015566, 2, ',50008164,50015566,50015673,', 0),
(50015674, '椅/凳', 2, 50015566, 2, ',50008164,50015566,50015674,', 0),
(50015675, '柜子', 3, 50015566, 2, ',50008164,50015566,50015675,', 0),
(50015676, '架/箱', 4, 50015566, 2, ',50008164,50015566,50015676,', 0),
(50015677, '桌子', 5, 50015566, 2, ',50008164,50015566,50015677,', 0),
(50015678, '茶几', 6, 50015566, 2, ',50008164,50015566,50015678,', 0),
(50015679, '成套家具', 7, 50015566, 2, ',50008164,50015566,50015679,', 0),
(50015680, '其它二手/闲置', 8, 50015566, 2, ',50008164,50015566,50015680,', 0),
(50015570, '海绵', 0, 50015568, 2, ',50008164,50015568,50015570,', 0),
(50015571, '玻璃', 1, 50015568, 2, ',50008164,50015568,50015571,', 0),
(50015572, '家具纸', 2, 50015568, 2, ',50008164,50015568,50015572,', 0),
(50015573, '布艺', 3, 50015568, 2, ',50008164,50015568,50015573,', 0),
(50015574, '皮革', 4, 50015568, 2, ',50008164,50015568,50015574,', 0),
(50015575, '松紧带', 5, 50015568, 2, ',50008164,50015568,50015575,', 0),
(50015576, '亚克力', 6, 50015568, 2, ',50008164,50015568,50015576,', 0),
(50015671, '其它家具配件', 6, 50015568, 2, ',50008164,50015568,50015671,', 0),
(50015577, '弹簧', 7, 50015568, 2, ',50008164,50015568,50015577,', 0),
(50015774, '客厅家具套装', 0, 50015771, 2, ',50008164,50015771,50015774,', 1),
(50015775, '餐厅家具套装', 1, 50015771, 2, ',50008164,50015771,50015775,', 1),
(50015776, '卧室家具套装', 2, 50015771, 2, ',50008164,50015771,50015776,', 1),
(50015777, '书房家具套装', 3, 50015771, 2, ',50008164,50015771,50015777,', 1),
(50015778, '门厅家具套装', 4, 50015771, 2, ',50008164,50015771,50015778,', 1),
(50015779, '整体衣帽间', 5, 50015771, 2, ',50008164,50015771,50015779,', 0),
(50001733, '其它成套家具', 8, 50015771, 2, ',50008164,50015771,50001733,', 0),
(50022733, '儿童成套家具', 18, 50015771, 2, ',50008164,50015771,50022733,', 0),
(50001709, '茶几', 0, 50015816, 2, ',50008164,50015816,50001709,', 0),
(50015847, '角几/边几', 1, 50015816, 2, ',50008164,50015816,50015847,', 0),
(50015879, '套几', 2, 50015816, 2, ',50008164,50015816,50015879,', 0),
(50015880, '炕几', 3, 50015816, 2, ',50008164,50015816,50015880,', 0),
(50015955, '其它几类', 4, 50015816, 2, ',50008164,50015816,50015955,', 0),
(50015892, '条案', 0, 50015886, 2, ',50008164,50015886,50015892,', 0),
(50015888, '玄关台', 1, 50015886, 2, ',50008164,50015886,50015888,', 0),
(50001406, '吧台', 8, 50015886, 2, ',50008164,50015886,50001406,', 0),
(50015952, '其它案台', 9, 50015886, 2, ',50008164,50015886,50015952,', 0),
(50015916, '折屏', 0, 50015915, 2, ',50008164,50015915,50015916,', 0),
(50015917, '座屏', 1, 50015915, 2, ',50008164,50015915,50015917,', 0),
(50015918, '挂屏', 2, 50015915, 2, ',50008164,50015915,50015918,', 0),
(50015919, '插屏', 3, 50015915, 2, ',50008164,50015915,50015919,', 0),
(50022485, '花窗', 37, 50015915, 2, ',50008164,50015915,50022485,', 0),
(50015995, '魔术杂技用具', 0, 50015994, 2, ',25,50015994,50015995,', 1),
(50015996, '聚会用具/装饰', 1, 50015994, 2, ',25,50015994,50015996,', 1),
(2033, 'Cosplay服饰/配件', 15, 50015994, 2, ',25,50015994,2033,', 1),
(201808, '圣斗士星矢', 0, 50016058, 2, ',25,50016058,201808,', 0),
(50002490, '高达模型专区', 4, 50016058, 2, ',25,50016058,50002490,', 1),
(203509, '变形金刚专区', 5, 50016058, 2, ',25,50016058,203509,', 0),
(50016101, '机器人/变形系列', 6, 50016058, 2, ',25,50016058,50016101,', 1),
(50005935, 'BJD娃娃专区', 8, 50016058, 2, ',25,50016058,50005935,', 0),
(50005868, '太空堡垒', 10, 50016058, 2, ',25,50016058,50005868,', 1),
(50003027, '新世纪福音战士', 11, 50016058, 2, ',25,50016058,50003027,', 1),
(50008406, '手办(精品/GK/白模)', 28, 50016058, 2, ',25,50016058,50008406,', 0),
(50008056, '糖果', 0, 50016091, 2, ',50002766,50016091,50008056,', 0),
(50016092, '口香糖', 1, 50016091, 2, ',50002766,50016091,50016092,', 0),
(50016093, '果冻/布丁', 2, 50016091, 2, ',50002766,50016091,50016093,', 0),
(50016103, '低体重儿/早产儿奶粉', 0, 50016094, 2, ',35,50016094,50016103,', 0),
(50016104, '防腹泻/抗过敏奶粉', 1, 50016094, 2, ',35,50016094,50016104,', 0),
(50016105, '其它', 2, 50016094, 2, ',35,50016094,50016105,', 0),
(50018184, '羊奶粉', 3, 50016094, 2, ',35,50016094,50018184,', 0),
(50018595, '豆奶粉', 4, 50016094, 2, ',35,50016094,50018595,', 0),
(50016121, '旅行安全', 1, 50016119, 2, ',50013886,50016119,50016121,', 1),
(50016126, '其他旅行用品', 6, 50016119, 2, ',50013886,50016119,50016126,', 1),
(50016190, '光端机', 0, 50016189, 2, ',50018264,50016189,50016190,', 0),
(50016191, '光纤跳线', 1, 50016189, 2, ',50018264,50016189,50016191,', 0),
(50016192, '光纤终端盒', 2, 50016189, 2, ',50018264,50016189,50016192,', 0),
(50016193, '光纤耦合器', 3, 50016189, 2, ',50018264,50016189,50016193,', 0),
(50016194, '其它光纤设备', 4, 50016189, 2, ',50018264,50016189,50016194,', 0),
(50016197, 'RAID卡', 1, 50016195, 2, ',50018264,50016195,50016197,', 0),
(50016198, 'SCSI卡', 2, 50016195, 2, ',50018264,50016195,50016198,', 0),
(50016199, 'SCSI配件', 3, 50016195, 2, ',50018264,50016195,50016199,', 0),
(50016200, '磁带', 4, 50016195, 2, ',50018264,50016195,50016200,', 0),
(50016201, '磁带机', 5, 50016195, 2, ',50018264,50016195,50016201,', 0),
(50016202, '其他网络存储设备', 6, 50016195, 2, ',50018264,50016195,50016202,', 0),
(50019353, '磁带库', 7, 50016195, 2, ',50018264,50016195,50019353,', 0),
(50019354, '磁盘阵列', 8, 50016195, 2, ',50018264,50016195,50019354,', 0),
(50019355, 'NAS网络储存', 9, 50016195, 2, ',50018264,50016195,50019355,', 0),
(50019356, 'SAN网络储存', 10, 50016195, 2, ',50018264,50016195,50019356,', 0),
(50019357, 'IP网络存储', 11, 50016195, 2, ',50018264,50016195,50019357,', 0),
(50019358, '硬盘抽取盒', 12, 50016195, 2, ',50018264,50016195,50019358,', 0),
(50019359, 'KVM切换器', 13, 50016195, 2, ',50018264,50016195,50019359,', 0),
(50019360, '网络延长器', 14, 50016195, 2, ',50018264,50016195,50019360,', 0),
(50016204, '机柜', 0, 50016203, 2, ',50018264,50016203,50016204,', 0),
(50016206, '配线架', 2, 50016203, 2, ',50018264,50016203,50016206,', 0),
(50016207, '电脑切换器/分配器', 3, 50016203, 2, ',50018264,50016203,50016207,', 0),
(50016208, '网络测试仪', 4, 50016203, 2, ',50018264,50016203,50016208,', 0),
(50016209, '打线刀', 5, 50016203, 2, ',50018264,50016203,50016209,', 0),
(50016210, '压线钳', 6, 50016203, 2, ',50018264,50016203,50016210,', 0),
(50016446, '螺丝刀', 7, 50016203, 2, ',50018264,50016203,50016446,', 0),
(50016447, '工具套装', 8, 50016203, 2, ',50018264,50016203,50016447,', 0),
(50016448, '万用表', 9, 50016203, 2, ',50018264,50016203,50016448,', 0),
(50018265, '无盘工作站', 10, 50016203, 2, ',50018264,50016203,50018265,', 0),
(50016354, '贺卡/明信片', 0, 50016353, 2, ',50018004,50016353,50016354,', 0),
(50016355, '宣传单/海报/说明书', 1, 50016353, 2, ',50018004,50016353,50016355,', 0),
(50016356, '名片', 2, 50016353, 2, ',50018004,50016353,50016356,', 0),
(50016357, '台历/挂历/年历', 3, 50016353, 2, ',50018004,50016353,50016357,', 0),
(50016358, '定制包装袋/纸/箱', 4, 50016353, 2, ',50018004,50016353,50016358,', 0),
(50016359, '其它印刷制品', 5, 50016353, 2, ',50018004,50016353,50016359,', 0),
(50024637, '吊牌', 6, 50016353, 2, ',50018004,50016353,50024637,', 0),
(50024638, '定制菜谱/桌牌/台牌', 7, 50016353, 2, ',50018004,50016353,50024638,', 0),
(50010358, '刺绣', 0, 50016434, 2, ',21,50016434,50010358,', 0),
(50004407, '钥匙扣', 0, 50016434, 2, ',21,50016434,50004407,', 0),
(50009221, '音乐盒', 2, 50016434, 2, ',21,50016434,50009221,', 0),
(50008229, '招财猫', 4, 50016434, 2, ',21,50016434,50008229,', 0),
(50008821, '太阳能娃娃', 6, 50016434, 2, ',21,50016434,50008821,', 0),
(50009283, '时尚烟灰缸', 6, 50016434, 2, ',21,50016434,50009283,', 0),
(50008670, '生日报', 6, 50016434, 2, ',21,50016434,50008670,', 0),
(50009213, '笔筒', 6, 50016434, 2, ',21,50016434,50009213,', 0),
(50007090, '手机链', 16, 50016434, 2, ',21,50016434,50007090,', 0),
(50003453, '储蓄罐', 21, 50016434, 2, ',21,50016434,50003453,', 0),
(50010364, '海螺/贝壳/珊瑚', 21, 50016434, 2, ',21,50016434,50010364,', 0),
(50011266, '阳光罐/月光罐', 22, 50016434, 2, ',21,50016434,50011266,', 0),
(50010363, '许愿瓶/幸运星瓶', 38, 50016434, 2, ',21,50016434,50010363,', 0),
(50006862, '防丢器', 65, 50016434, 2, ',21,50016434,50006862,', 0),
(210204, '其它杂货', 77, 50016434, 2, ',21,50016434,210204,', 0),
(50003463, '相册/相簿', 106, 50016434, 2, ',21,50016434,50003463,', 0),
(50025866, '风铃及配件', 107, 50016434, 2, ',21,50016434,50025866,', 0),
(50025867, '创意贴纸', 108, 50016434, 2, ',21,50016434,50025867,', 0),
(50025868, '创意根雕', 109, 50016434, 2, ',21,50016434,50025868,', 0),
(50025869, '创意摆件', 110, 50016434, 2, ',21,50016434,50025869,', 0),
(50025870, '创意风筝', 111, 50016434, 2, ',21,50016434,50025870,', 0),
(50025871, '创意泥人', 112, 50016434, 2, ',21,50016434,50025871,', 0),
(50025872, '创意陶瓷', 113, 50016434, 2, ',21,50016434,50025872,', 0),
(50025873, '相框', 114, 50016434, 2, ',21,50016434,50025873,', 0),
(50026195, '创意玩偶', 115, 50016434, 2, ',21,50016434,50026195,', 0),
(50026743, '创意坐垫/抱枕/颈枕', 116, 50016434, 2, ',21,50016434,50026743,', 0),
(50026786, '创意零钱包/钥匙包', 117, 50016434, 2, ',21,50016434,50026786,', 0),
(50016473, '拉丁舞', 0, 50016472, 2, ',50010728,50016472,50016473,', 1),
(50016476, '摩登舞', 1, 50016472, 2, ',50010728,50016472,50016476,', 1),
(50016474, '芭蕾舞', 2, 50016472, 2, ',50010728,50016472,50016474,', 1),
(50016475, '肚皮舞', 3, 50016472, 2, ',50010728,50016472,50016475,', 1),
(50016477, '爵士舞', 5, 50016472, 2, ',50010728,50016472,50016477,', 1),
(50016479, '踢踏舞', 8, 50016472, 2, ',50010728,50016472,50016479,', 1),
(50016492, '草裙舞', 10, 50016472, 2, ',50010728,50016472,50016492,', 1),
(50016481, '街舞', 11, 50016472, 2, ',50010728,50016472,50016481,', 1),
(50016485, '新疆舞', 12, 50016472, 2, ',50010728,50016472,50016485,', 1),
(50016486, '藏族舞', 13, 50016472, 2, ',50010728,50016472,50016486,', 1),
(50016487, '傣族舞', 14, 50016472, 2, ',50010728,50016472,50016487,', 1),
(50016490, '朝鲜舞', 15, 50016472, 2, ',50010728,50016472,50016490,', 1),
(50016491, '秧歌舞', 16, 50016472, 2, ',50010728,50016472,50016491,', 1),
(50016494, '钢管舞', 18, 50016472, 2, ',50010728,50016472,50016494,', 1),
(50016495, '健美操', 19, 50016472, 2, ',50010728,50016472,50016495,', 1),
(50016591, '体操', 20, 50016472, 2, ',50010728,50016472,50016591,', 1),
(50016681, '现代舞', 21, 50016472, 2, ',50010728,50016472,50016681,', 1),
(50017731, '啦啦队', 22, 50016472, 2, ',50010728,50016472,50017731,', 1),
(50016493, '更多舞种', 23, 50016472, 2, ',50010728,50016472,50016493,', 1),
(50025658, '中国古典舞', 25, 50016472, 2, ',50010728,50016472,50025658,', 1),
(50016664, '瑜伽服', 0, 50016663, 2, ',50010728,50016663,50016664,', 0),
(50016665, '瑜伽垫', 1, 50016663, 2, ',50010728,50016663,50016665,', 0),
(50016666, '瑜伽包', 2, 50016663, 2, ',50010728,50016663,50016666,', 0),
(50016667, '瑜伽砖', 3, 50016663, 2, ',50010728,50016663,50016667,', 0),
(50016668, '瑜伽球', 4, 50016663, 2, ',50010728,50016663,50016668,', 0),
(50016669, '伸展带/瑜伽绳', 5, 50016663, 2, ',50010728,50016663,50016669,', 0),
(50016732, '瑜伽拉力带', 7, 50016663, 2, ',50010728,50016663,50016732,', 0),
(50016670, '瑜伽铺巾', 8, 50016663, 2, ',50010728,50016663,50016670,', 0),
(50016671, '瑜伽披肩', 9, 50016663, 2, ',50010728,50016663,50016671,', 0),
(50016672, '瑜伽发带', 10, 50016663, 2, ',50010728,50016663,50016672,', 0),
(50016673, '瑜伽袜子', 11, 50016663, 2, ',50010728,50016663,50016673,', 0),
(50018316, '洗鼻壶/洗鼻盐', 12, 50016663, 2, ',50010728,50016663,50018316,', 0),
(50016674, '瑜伽手套/发带/眼枕', 13, 50016663, 2, ',50010728,50016663,50016674,', 0),
(50016675, '瑜伽体位图靠垫', 14, 50016663, 2, ',50010728,50016663,50016675,', 0),
(50018317, '瑜伽垫捆绑带/毛扣', 15, 50016663, 2, ',50010728,50016663,50018317,', 0),
(50016677, '更多瑜伽用品', 17, 50016663, 2, ',50010728,50016663,50016677,', 0),
(50019555, '瑜伽圈/普拉提圈', 19, 50016663, 2, ',50010728,50016663,50019555,', 0),
(50019707, '瑜伽服用胸垫', 20, 50016663, 2, ',50010728,50016663,50019707,', 0),
(50020041, '健身球架', 21, 50016663, 2, ',50010728,50016663,50020041,', 0),
(50020042, '瑜伽舒展器/健康架', 22, 50016663, 2, ',50010728,50016663,50020042,', 0),
(50020043, '瑜伽工艺品', 23, 50016663, 2, ',50010728,50016663,50020043,', 0),
(50020044, '瑜伽背景音乐', 24, 50016663, 2, ',50010728,50016663,50020044,', 0),
(50020045, '瑜伽香薰精油', 25, 50016663, 2, ',50010728,50016663,50020045,', 0),
(50020050, '瑜伽鞋', 26, 50016663, 2, ',50010728,50016663,50020050,', 0),
(50020211, '瘦小腿套', 28, 50016663, 2, ',50010728,50016663,50020211,', 0),
(50020212, '瘦手臂套', 29, 50016663, 2, ',50010728,50016663,50020212,', 0),
(50016686, '哺乳文胸', 0, 50016687, 2, ',50022517,50016687,50016686,', 0),
(50016688, '内裤', 1, 50016687, 2, ',50022517,50016687,50016688,', 0),
(50010399, '(文胸-内裤)套装', 2, 50016687, 2, ',50022517,50016687,50010399,', 0),
(50023646, '生理裤/产检裤', 4, 50016687, 2, ',50022517,50016687,50023646,', 0),
(50016884, '背扣乳垫及其它', 5, 50016687, 2, ',50022517,50016687,50016884,', 0),
(50016690, '直排轮', 0, 50016689, 2, ',50010728,50016689,50016690,', 0),
(50016691, '滑板', 1, 50016689, 2, ',50010728,50016689,50016691,', 0),
(50016692, '活力板', 3, 50016689, 2, ',50010728,50016689,50016692,', 0),
(50016693, '滑板车', 4, 50016689, 2, ',50010728,50016689,50016693,', 0),
(50016694, '漂移版/分体滑板', 5, 50016689, 2, ',50010728,50016689,50016694,', 0),
(50016695, '暴走鞋', 6, 50016689, 2, ',50010728,50016689,50016695,', 0),
(50016696, '风火轮', 7, 50016689, 2, ',50010728,50016689,50016696,', 0),
(50016697, '便携魔轮', 8, 50016689, 2, ',50010728,50016689,50016697,', 0),
(50016698, '弹跳跷', 9, 50016689, 2, ',50010728,50016689,50016698,', 0),
(50016699, '摆摆乐', 10, 50016689, 2, ',50010728,50016689,50016699,', 0),
(50016700, '竞技独轮车', 11, 50016689, 2, ',50010728,50016689,50016700,', 0),
(50016701, '双排轮', 12, 50016689, 2, ',50010728,50016689,50016701,', 0),
(50016702, '极限飞盘', 13, 50016689, 2, ',50010728,50016689,50016702,', 0),
(50016704, '极限装备/配件区', 15, 50016689, 2, ',50010728,50016689,50016704,', 1),
(50016730, '更多极限运动', 16, 50016689, 2, ',50010728,50016689,50016730,', 0),
(50016736, '比基尼', 0, 50016729, 2, ',50010728,50016729,50016736,', 0),
(50016737, '分体泳衣', 1, 50016729, 2, ',50010728,50016729,50016737,', 0),
(50016738, '连体泳衣', 2, 50016729, 2, ',50010728,50016729,50016738,', 0),
(50016739, '男士泳衣', 3, 50016729, 2, ',50010728,50016729,50016739,', 0),
(50016740, '儿童泳衣/裤', 4, 50016729, 2, ',50010728,50016729,50016740,', 0),
(50016741, '情侣装泳衣', 5, 50016729, 2, ',50010728,50016729,50016741,', 0),
(50016742, '亲子家庭装', 6, 50016729, 2, ',50010728,50016729,50016742,', 0),
(50016743, '裹裙/披纱', 7, 50016729, 2, ',50010728,50016729,50016743,', 0),
(50016744, '泳镜', 8, 50016729, 2, ',50010728,50016729,50016744,', 0),
(50016747, '泳帽', 9, 50016729, 2, ',50010728,50016729,50016747,', 0),
(50016749, '游泳圈', 10, 50016729, 2, ',50010728,50016729,50016749,', 0),
(50016752, '游泳专用包', 11, 50016729, 2, ',50010728,50016729,50016752,', 0),
(50023341, '游泳池', 20, 50016729, 2, ',50010728,50016729,50023341,', 0),
(50023344, '戏水玩具', 23, 50016729, 2, ',50010728,50016729,50023344,', 0),
(50023369, '人字拖/沙滩鞋', 24, 50016729, 2, ',50010728,50016729,50023369,', 0),
(50016762, '救生衣', 25, 50016729, 2, ',50010728,50016729,50016762,', 0),
(50016748, '游泳装备', 26, 50016729, 2, ',50010728,50016729,50016748,', 1),
(50023561, '沙滩裤', 27, 50016729, 2, ',50010728,50016729,50023561,', 0),
(50009919, '其它', 0, 50016810, 2, ',50050359,50016810,50009919,', 0),
(50016811, '猪肉', 1, 50016810, 2, ',50050359,50016810,50016811,', 0),
(50016812, '羊肉', 2, 50016810, 2, ',50050359,50016810,50016812,', 0),
(50016813, '牛肉', 3, 50016810, 2, ',50050359,50016810,50016813,', 0),
(50016814, '鸡肉', 4, 50016810, 2, ',50050359,50016810,50016814,', 0),
(50016815, '鸭肉', 5, 50016810, 2, ',50050359,50016810,50016815,', 0),
(50050665, '乳鸽', 6, 50016810, 2, ',50050359,50016810,50050665,', 0),
(50012475, '卫生巾', 0, 50016889, 2, ',50025705,50016889,50012475,', 0),
(50012476, '护垫', 2, 50016889, 2, ',50025705,50016889,50012476,', 0),
(50012481, '成人用纸尿护理用品', 7, 50016889, 2, ',50025705,50016889,50012481,', 0),
(50017596, '网球', 0, 50017077, 2, ',50010728,50017077,50017596,', 0),
(50017078, '网球拍', 1, 50017077, 2, ',50010728,50017077,50017078,', 0),
(50017079, '网球线', 2, 50017077, 2, ',50010728,50017077,50017079,', 0),
(50017597, '网球包', 3, 50017077, 2, ',50010728,50017077,50017597,', 0),
(50017598, '网球服', 4, 50017077, 2, ',50010728,50017077,50017598,', 0),
(50017599, '网球鞋', 5, 50017077, 2, ',50010728,50017077,50017599,', 0),
(50017600, '网球帽', 6, 50017077, 2, ',50010728,50017077,50017600,', 0),
(50017601, '运动袜', 7, 50017077, 2, ',50010728,50017077,50017601,', 0),
(50017602, '避震器', 8, 50017077, 2, ',50010728,50017077,50017602,', 0),
(50017603, '手胶/吸汗带', 9, 50017077, 2, ',50010728,50017077,50017603,', 0),
(50017605, '网球训练用品', 11, 50017077, 2, ',50010728,50017077,50017605,', 1),
(50017614, '网球赛事纪念', 12, 50017077, 2, ',50010728,50017077,50017614,', 0),
(50017615, '更多网球配件', 13, 50017077, 2, ',50010728,50017077,50017615,', 0),
(50017086, '踏步机', 0, 50017085, 2, ',50010728,50017085,50017086,', 0),
(50017092, '仰卧板/健腹板', 1, 50017085, 2, ',50010728,50017085,50017092,', 0),
(50017093, '健腹轮/健腹器', 2, 50017085, 2, ',50010728,50017085,50017093,', 0),
(50017094, '拉力绳/拉力器', 3, 50017085, 2, ',50010728,50017085,50017094,', 0),
(50017095, '哑铃', 4, 50017085, 2, ',50010728,50017085,50017095,', 0),
(50017096, '杠铃', 5, 50017085, 2, ',50010728,50017085,50017096,', 0),
(50017097, '跳绳', 6, 50017085, 2, ',50010728,50017085,50017097,', 0),
(50017098, '跳跳球/蹦蹦球', 7, 50017085, 2, ',50010728,50017085,50017098,', 0),
(50017099, '臂力器', 8, 50017085, 2, ',50010728,50017085,50017099,', 0),
(50017100, '腕力器', 9, 50017085, 2, ',50010728,50017085,50017100,', 0),
(50017101, '握力器', 10, 50017085, 2, ',50010728,50017085,50017101,', 0),
(50017102, '健身球/保健球', 11, 50017085, 2, ',50010728,50017085,50017102,', 0),
(50017103, '呼啦圈', 12, 50017085, 2, ',50010728,50017085,50017103,', 0),
(50017104, '扭腰盘', 13, 50017085, 2, ',50010728,50017085,50017104,', 0),
(50017105, '美腰机/挺腰器', 14, 50017085, 2, ',50010728,50017085,50017105,', 0),
(50017106, '美腿机/腿部训练器', 15, 50017085, 2, ',50010728,50017085,50017106,', 0),
(50017107, '俯卧撑架', 16, 50017085, 2, ',50010728,50017085,50017107,', 0),
(50017108, '单双杠/引体向上', 17, 50017085, 2, ',50010728,50017085,50017108,', 0),
(50017109, '健身椅', 18, 50017085, 2, ',50010728,50017085,50017109,', 0),
(50017110, '健身器材套装', 19, 50017085, 2, ',50010728,50017085,50017110,', 0),
(50017111, '负重装备', 20, 50017085, 2, ',50010728,50017085,50017111,', 0),
(50017112, '足底按摩垫', 21, 50017085, 2, ',50010728,50017085,50017112,', 0),
(50017114, '计时器/计步器', 23, 50017085, 2, ',50010728,50017085,50017114,', 0),
(50017146, '中小型健身器材配件区', 25, 50017085, 2, ',50010728,50017085,50017146,', 0),
(50017115, '更多中小型健身器材', 26, 50017085, 2, ',50010728,50017085,50017115,', 0),
(50019227, '吊环', 27, 50017085, 2, ',50010728,50017085,50019227,', 0),
(50019248, '跳跳环/闪光跳', 28, 50017085, 2, ',50010728,50017085,50019248,', 0),
(50019297, '娃娃跳/弹跳器', 29, 50017085, 2, ',50010728,50017085,50019297,', 0),
(50019551, '颈椎牵引器', 30, 50017085, 2, ',50010728,50017085,50019551,', 0),
(50019552, '弹力棒/健身棒', 31, 50017085, 2, ',50010728,50017085,50019552,', 0),
(50019553, '健身锤/按摩捶', 32, 50017085, 2, ',50010728,50017085,50019553,', 0),
(50019554, '体重秤/健康秤', 33, 50017085, 2, ',50010728,50017085,50019554,', 0),
(50019559, '健身踏板/韵律踏板', 34, 50017085, 2, ',50010728,50017085,50019559,', 0),
(50017847, '北京', 1, 50017087, 2, ',50025707,50017087,50017847,', 1),
(50017089, '上海', 2, 50017087, 2, ',50025707,50017087,50017089,', 0),
(50017180, '香港', 3, 50017087, 2, ',50025707,50017087,50017180,', 0),
(50017168, '广东', 4, 50017087, 2, ',50025707,50017087,50017168,', 1),
(50017169, '广西', 5, 50017087, 2, ',50025707,50017087,50017169,', 1),
(50017160, '浙江', 6, 50017087, 2, ',50025707,50017087,50017160,', 1),
(50017159, '江苏', 7, 50017087, 2, ',50025707,50017087,50017159,', 1),
(50017090, '天津', 8, 50017087, 2, ',50025707,50017087,50017090,', 0),
(50017091, '重庆', 9, 50017087, 2, ',50025707,50017087,50017091,', 0),
(50017153, '河北', 10, 50017087, 2, ',50025707,50017087,50017153,', 1),
(50017161, '安徽', 19, 50017087, 2, ',50025707,50017087,50017161,', 1),
(50017162, '福建', 20, 50017087, 2, ',50025707,50017087,50017162,', 1),
(50017164, '山东', 22, 50017087, 2, ',50025707,50017087,50017164,', 1),
(50017166, '湖北', 24, 50017087, 2, ',50025707,50017087,50017166,', 1),
(50017167, '湖南', 25, 50017087, 2, ',50025707,50017087,50017167,', 1),
(50017170, '海南', 28, 50017087, 2, ',50025707,50017087,50017170,', 1),
(50017171, '四川', 29, 50017087, 2, ',50025707,50017087,50017171,', 1),
(50017173, '云南', 31, 50017087, 2, ',50025707,50017087,50017173,', 1),
(50017175, '陕西', 33, 50017087, 2, ',50025707,50017087,50017175,', 1),
(50022894, '河南', 44, 50017087, 2, ',50025707,50017087,50022894,', 1),
(50022902, '黑龙江', 45, 50017087, 2, ',50025707,50017087,50022902,', 1),
(50022906, '吉林', 46, 50017087, 2, ',50025707,50017087,50022906,', 1),
(50022918, '江西', 47, 50017087, 2, ',50025707,50017087,50022918,', 1),
(50022928, '山西', 48, 50017087, 2, ',50025707,50017087,50022928,', 1),
(50022934, '辽宁', 49, 50017087, 2, ',50025707,50017087,50022934,', 1),
(50022940, '贵州', 50, 50017087, 2, ',50025707,50017087,50022940,', 1),
(50022946, '西藏', 51, 50017087, 2, ',50025707,50017087,50022946,', 1),
(50022956, '甘肃', 52, 50017087, 2, ',50025707,50017087,50022956,', 1),
(50022961, '青海', 53, 50017087, 2, ',50025707,50017087,50022961,', 1),
(50022965, '宁夏', 54, 50017087, 2, ',50025707,50017087,50022965,', 1),
(50022971, '新疆', 55, 50017087, 2, ',50025707,50017087,50022971,', 1),
(50022978, '内蒙古', 56, 50017087, 2, ',50025707,50017087,50022978,', 1),
(50017181, '澳门', 57, 50017087, 2, ',50025707,50017087,50017181,', 0),
(50017182, '台湾', 58, 50017087, 2, ',50025707,50017087,50017182,', 0),
(50012912, '其它', 59, 50017087, 2, ',50025707,50017087,50012912,', 0),
(50026533, '东南亚', 60, 50017087, 2, ',50025707,50017087,50026533,', 0),
(50017118, '跑步机', 0, 50017117, 2, ',50010728,50017117,50017118,', 0),
(50017119, '健身车', 1, 50017117, 2, ',50010728,50017117,50017119,', 0),
(50020038, '动感单车', 2, 50017117, 2, ',50010728,50017117,50020038,', 0),
(50020040, '力量训练器械(综合型)', 4, 50017117, 2, ',50010728,50017117,50020040,', 0),
(50020039, '力量训练器械(局部型)', 5, 50017117, 2, ',50010728,50017117,50020039,', 0),
(50017121, '椭圆机', 6, 50017117, 2, ',50010728,50017117,50017121,', 0),
(50017122, '跳跳床/蹦蹦床', 7, 50017117, 2, ',50010728,50017117,50017122,', 0),
(50017123, '举重床/卧推器', 8, 50017117, 2, ',50010728,50017117,50017123,', 0),
(50017124, '划船机', 9, 50017117, 2, ',50010728,50017117,50017124,', 0),
(50017125, '太空漫步机/走步机', 10, 50017117, 2, ',50010728,50017117,50017125,', 0),
(50017126, '骑马机', 11, 50017117, 2, ',50010728,50017117,50017126,', 0),
(50017127, '冲浪机', 12, 50017117, 2, ',50010728,50017117,50017127,', 0),
(50017128, '倒立机', 13, 50017117, 2, ',50010728,50017117,50017128,', 0),
(50017129, '甩脂机', 14, 50017117, 2, ',50010728,50017117,50017129,', 0),
(50019560, '登山机', 15, 50017117, 2, ',50010728,50017117,50019560,', 0),
(50017130, '健身路径', 16, 50017117, 2, ',50010728,50017117,50017130,', 0),
(50017131, '器械减震垫', 17, 50017117, 2, ',50010728,50017117,50017131,', 0),
(50017147, '大型健身器械配件区', 18, 50017117, 2, ',50010728,50017117,50017147,', 0),
(50017132, '更多大型健身器械', 19, 50017117, 2, ',50010728,50017117,50017132,', 0),
(50017120, '力量训练器械(综合性)', 20, 50017117, 2, ',50010728,50017117,50017120,', 0),
(50017148, '缝纫DIY工具', 1, 50017143, 2, ',50008163,50017143,50017148,', 0),
(2101, '缝纫DIY配件/辅料/配饰', 30, 50017143, 2, ',50008163,50017143,2101,', 1),
(50017150, '缝纫DIY材料套装', 31, 50017143, 2, ',50008163,50017143,50017150,', 0),
(50024951, '布艺DIY成品', 33, 50017143, 2, ',50008163,50017143,50024951,', 1),
(50017270, '田径运动服', 0, 50017269, 2, ',50010728,50017269,50017270,', 0),
(50017271, '田径运动鞋', 1, 50017269, 2, ',50010728,50017269,50017271,', 0),
(50017272, '起跑器/起跑器架', 2, 50017269, 2, ',50010728,50017269,50017272,', 0),
(50017273, '跨栏架', 3, 50017269, 2, ',50010728,50017269,50017273,', 0),
(50017274, '接力棒', 4, 50017269, 2, ',50010728,50017269,50017274,', 0),
(50017275, '跳高架/跳高杆', 5, 50017269, 2, ',50010728,50017269,50017275,', 0),
(50017276, '山羊/跳马/跳箱', 6, 50017269, 2, ',50010728,50017269,50017276,', 0),
(50017277, '铁饼/铁饼架', 7, 50017269, 2, ',50010728,50017269,50017277,', 0),
(50017278, '铅球/铅球架', 8, 50017269, 2, ',50010728,50017269,50017278,', 0),
(50017279, '链球', 9, 50017269, 2, ',50010728,50017269,50017279,', 0),
(50017280, '海绵垫/体操垫', 10, 50017269, 2, ',50010728,50017269,50017280,', 0),
(50017281, '裁判用具', 11, 50017269, 2, ',50010728,50017269,50017281,', 1),
(50017287, '田径场地辅助用具', 12, 50017269, 2, ',50010728,50017269,50017287,', 1),
(50017362, '快板', 0, 50017301, 2, ',50017300,50017301,50017362,', 0),
(50017363, '拍板', 1, 50017301, 2, ',50017300,50017301,50017363,', 0),
(50017323, '镲', 1, 50017301, 2, ',50017300,50017301,50017323,', 1),
(50017364, '梆子', 2, 50017301, 2, ',50017300,50017301,50017364,', 0),
(50017324, '钹/铙', 2, 50017301, 2, ',50017300,50017301,50017324,', 1),
(50017365, '萨巴依', 3, 50017301, 2, ',50017300,50017301,50017365,', 0),
(50017327, '民族乐器其它', 5, 50017301, 2, ',50017300,50017301,50017327,', 0),
(50017366, '扬琴', 0, 50017302, 2, ',50017300,50017302,50017366,', 0),
(50017368, '琵琶', 2, 50017302, 2, ',50017300,50017302,50017368,', 0),
(50017369, '阮', 3, 50017302, 2, ',50017300,50017302,50017369,', 0),
(50017370, '月琴', 4, 50017302, 2, ',50017300,50017302,50017370,', 0),
(50017371, '柳琴', 5, 50017302, 2, ',50017300,50017302,50017371,', 0),
(50017372, '三弦', 6, 50017302, 2, ',50017300,50017302,50017372,', 0),
(50017373, '秦琴', 7, 50017302, 2, ',50017300,50017302,50017373,', 0),
(50017374, '箜篌', 8, 50017302, 2, ',50017300,50017302,50017374,', 0),
(50017375, '弹布尔', 9, 50017302, 2, ',50017300,50017302,50017375,', 0),
(50017376, '热瓦普', 10, 50017302, 2, ',50017300,50017302,50017376,', 0),
(50017377, '冬不拉', 11, 50017302, 2, ',50017300,50017302,50017377,', 0),
(50017382, '笙', 4, 50017303, 2, ',50017300,50017303,50017382,', 0),
(50017383, '篌', 5, 50017303, 2, ',50017300,50017303,50017383,', 0),
(50017384, '唢呐', 6, 50017303, 2, ',50017300,50017303,50017384,', 0),
(50017385, '管子', 7, 50017303, 2, ',50017300,50017303,50017385,', 0),
(50017386, '尺八', 8, 50017303, 2, ',50017300,50017303,50017386,', 0),
(50017387, '巴乌', 9, 50017303, 2, ',50017300,50017303,50017387,', 0),
(50017388, '芦笙', 10, 50017303, 2, ',50017300,50017303,50017388,', 0),
(50017389, '葫芦笙', 11, 50017303, 2, ',50017300,50017303,50017389,', 0),
(50017392, '京二胡', 1, 50017304, 2, ',50017300,50017304,50017392,', 0),
(50017394, '高胡', 3, 50017304, 2, ',50017300,50017304,50017394,', 0),
(50017395, '中胡', 4, 50017304, 2, ',50017300,50017304,50017395,', 0),
(50017396, '低音胡', 5, 50017304, 2, ',50017300,50017304,50017396,', 0),
(50017397, '板胡', 6, 50017304, 2, ',50017300,50017304,50017397,', 0),
(50017398, '四胡', 7, 50017304, 2, ',50017300,50017304,50017398,', 0),
(50017399, '坠琴', 8, 50017304, 2, ',50017300,50017304,50017399,', 0),
(50017400, '革胡', 9, 50017304, 2, ',50017300,50017304,50017400,', 0),
(50017401, '椰胡', 10, 50017304, 2, ',50017300,50017304,50017401,', 0),
(50017402, '马头琴', 11, 50017304, 2, ',50017300,50017304,50017402,', 0),
(50017403, '艾捷克', 12, 50017304, 2, ',50017300,50017304,50017403,', 0),
(50017404, '马骨胡', 13, 50017304, 2, ',50017300,50017304,50017404,', 0),
(50017405, '声乐类', 0, 50017305, 2, ',50017300,50017305,50017405,', 0),
(50017406, '吉他类', 1, 50017305, 2, ',50017300,50017305,50017406,', 0),
(50017407, '键盘类', 2, 50017305, 2, ',50017300,50017305,50017407,', 0),
(50017408, '提琴类', 3, 50017305, 2, ',50017300,50017305,50017408,', 0),
(50017409, '打击类', 4, 50017305, 2, ',50017300,50017305,50017409,', 0),
(50017410, '管乐类', 5, 50017305, 2, ',50017300,50017305,50017410,', 0),
(50017411, '弦乐类', 6, 50017305, 2, ',50017300,50017305,50017411,', 0),
(50017412, '民乐类', 7, 50017305, 2, ',50017300,50017305,50017412,', 0),
(50017413, '重奏合奏类', 8, 50017305, 2, ',50017300,50017305,50017413,', 0),
(50017414, '理论类', 9, 50017305, 2, ',50017300,50017305,50017414,', 0),
(50017415, '报刊类', 10, 50017305, 2, ',50017300,50017305,50017415,', 0),
(50017416, '其他', 11, 50017305, 2, ',50017300,50017305,50017416,', 0),
(50017435, '架子鼓/爵士鼓', 0, 50017309, 2, ',50017300,50017309,50017435,', 0),
(50017436, '小军鼓', 1, 50017309, 2, ',50017300,50017309,50017436,', 0),
(50017437, '静音鼓', 2, 50017309, 2, ',50017300,50017309,50017437,', 0),
(50017438, '电子鼓', 3, 50017309, 2, ',50017300,50017309,50017438,', 0),
(50017439, '邦戈鼓', 4, 50017309, 2, ',50017300,50017309,50017439,', 0),
(50017440, '非洲鼓', 5, 50017309, 2, ',50017300,50017309,50017440,', 0),
(50017441, '康佳鼓', 6, 50017309, 2, ',50017300,50017309,50017441,', 0),
(50017443, '其他西洋鼓', 8, 50017309, 2, ',50017300,50017309,50017443,', 0),
(50017444, '笛类', 0, 50017310, 2, ',50017300,50017310,50017444,', 0),
(50017445, '长笛', 0, 50017310, 2, ',50017300,50017310,50017445,', 0),
(50017448, '圆号', 1, 50017310, 2, ',50017300,50017310,50017448,', 0),
(50017446, '短笛', 1, 50017310, 2, ',50017300,50017310,50017446,', 0),
(50017449, '双簧管', 2, 50017310, 2, ',50017300,50017310,50017449,', 0),
(50017447, '竖笛', 2, 50017310, 2, ',50017300,50017310,50017447,', 0),
(50017450, '单簧管', 3, 50017310, 2, ',50017300,50017310,50017450,', 0),
(50017451, '小号', 4, 50017310, 2, ',50017300,50017310,50017451,', 0),
(50017452, '长号', 5, 50017310, 2, ',50017300,50017310,50017452,', 0),
(50017453, '大号', 6, 50017310, 2, ',50017300,50017310,50017453,', 0),
(50017454, '钹类', 7, 50017310, 2, ',50017300,50017310,50017454,', 0),
(50017455, '木琴/钟琴', 8, 50017310, 2, ',50017300,50017310,50017455,', 0),
(50017456, '竖琴', 9, 50017310, 2, ',50017300,50017310,50017456,', 0),
(50017478, '其它吉他', 10, 50017310, 2, ',50017300,50017310,50017478,', 0),
(50017457, '其它西洋乐器', 11, 50017310, 2, ',50017300,50017310,50017457,', 0),
(50017458, 'MIDI键盘', 0, 50017311, 2, ',50017300,50017311,50017458,', 0),
(50017465, '话筒', 0, 50017311, 2, ',50017300,50017311,50017465,', 0),
(50017466, '话筒夹/话筒架', 1, 50017311, 2, ',50017300,50017311,50017466,', 0),
(50017459, '软音源', 1, 50017311, 2, ',50017300,50017311,50017459,', 0),
(50017460, '乐器软件', 2, 50017311, 2, ',50017300,50017311,50017460,', 0),
(50017467, '声卡/音频接口', 2, 50017311, 2, ',50017300,50017311,50017467,', 0),
(50017461, 'MIDI键盘控制器', 3, 50017311, 2, ',50017300,50017311,50017461,', 0),
(50017468, '话筒放大器', 3, 50017311, 2, ',50017300,50017311,50017468,', 0),
(50017462, 'MIDI吹奏控制器', 4, 50017311, 2, ',50017300,50017311,50017462,', 0),
(50017469, '耳机放大器', 4, 50017311, 2, ',50017300,50017311,50017469,', 0),
(50017470, '调音台', 5, 50017311, 2, ',50017300,50017311,50017470,', 0),
(50017464, '其它MIDI配件', 6, 50017311, 2, ',50017300,50017311,50017464,', 0),
(50017479, '民谣吉他弦', 0, 50017313, 2, ',50017300,50017313,50017479,', 0),
(50017480, '古典吉他弦', 1, 50017313, 2, ',50017300,50017313,50017480,', 0),
(50017481, '电吉他弦', 2, 50017313, 2, ',50017300,50017313,50017481,', 0),
(50017482, '贝司弦', 3, 50017313, 2, ',50017300,50017313,50017482,', 0),
(50017483, '曼陀铃弦', 4, 50017313, 2, ',50017300,50017313,50017483,', 0),
(50017484, '班卓琴弦', 5, 50017313, 2, ',50017300,50017313,50017484,', 0),
(50017485, '吉他效果器配件', 6, 50017313, 2, ',50017300,50017313,50017485,', 0),
(50017486, '单块效果器', 7, 50017313, 2, ',50017300,50017313,50017486,', 0),
(50017487, '综合效果器', 8, 50017313, 2, ',50017300,50017313,50017487,', 0),
(50017488, '拨片/拨片套', 9, 50017313, 2, ',50017300,50017313,50017488,', 0),
(50017489, '滑棒/指套', 10, 50017313, 2, ',50017300,50017313,50017489,', 0),
(50017490, '连接线', 11, 50017313, 2, ',50017300,50017313,50017490,', 0),
(50017491, '拾音器', 12, 50017313, 2, ',50017300,50017313,50017491,', 0),
(50017492, '吉他背带', 13, 50017313, 2, ',50017300,50017313,50017492,', 0),
(50017493, '吉他背包/琴盒', 14, 50017313, 2, ',50017300,50017313,50017493,', 0),
(50017494, '脚凳/支架/吊架', 15, 50017313, 2, ',50017300,50017313,50017494,', 0),
(50017495, '弦枕/弦柱/背带钮', 16, 50017313, 2, ',50017300,50017313,50017495,', 0),
(50017496, '上弦器', 17, 50017313, 2, ',50017300,50017313,50017496,', 0),
(50017497, '清洁保护品', 18, 50017313, 2, ',50017300,50017313,50017497,', 0),
(50017498, '调音器/节拍器/变调夹', 19, 50017313, 2, ',50017300,50017313,50017498,', 0),
(50017499, '吉他电源', 20, 50017313, 2, ',50017300,50017313,50017499,', 0),
(50017500, '吉他合成器', 21, 50017313, 2, ',50017300,50017313,50017500,', 0),
(50017501, '其它吉他配件', 22, 50017313, 2, ',50017300,50017313,50017501,', 0),
(50017523, '监听音箱', 0, 50017318, 2, ',50017300,50017318,50017523,', 0),
(50017524, '监听耳机', 1, 50017318, 2, ',50017300,50017318,50017524,', 0),
(50017525, '键盘音箱', 2, 50017318, 2, ',50017300,50017318,50017525,', 0),
(50017526, '多功能音箱', 3, 50017318, 2, ',50017300,50017318,50017526,', 0),
(50017527, '音箱脚踏控制器', 4, 50017318, 2, ',50017300,50017318,50017527,', 0),
(50017528, '音箱支架', 5, 50017318, 2, ',50017300,50017318,50017528,', 0),
(50017529, '吉他音箱', 6, 50017318, 2, ',50017300,50017318,50017529,', 0),
(50017530, '贝司音箱', 7, 50017318, 2, ',50017300,50017318,50017530,', 0),
(50017531, '箱琴音箱', 8, 50017318, 2, ',50017300,50017318,50017531,', 0),
(50017532, '音箱其他', 9, 50017318, 2, ',50017300,50017318,50017532,', 0),
(50017533, '拨片/指甲/胶带', 0, 50017319, 2, ',50017300,50017319,50017533,', 0),
(50017534, '琴弦', 1, 50017319, 2, ',50017300,50017319,50017534,', 0),
(50017535, '踏板', 2, 50017319, 2, ',50017300,50017319,50017535,', 0),
(50017536, '鼓棒/鼓锤/鼓槌', 3, 50017319, 2, ',50017300,50017319,50017536,', 0),
(50017537, '鼓皮', 4, 50017319, 2, ',50017300,50017319,50017537,', 0),
(50017538, '鼓凳', 5, 50017319, 2, ',50017300,50017319,50017538,', 0),
(50017539, '琴凳/键盘凳', 6, 50017319, 2, ',50017300,50017319,50017539,', 0),
(50017540, '哑鼓垫', 7, 50017319, 2, ',50017300,50017319,50017540,', 0),
(50017541, '鼓刷', 8, 50017319, 2, ',50017300,50017319,50017541,', 0),
(50017542, '镲片', 9, 50017319, 2, ',50017300,50017319,50017542,', 0),
(50017543, '鼓架/镲架', 10, 50017319, 2, ',50017300,50017319,50017543,', 0),
(50017544, '其他支架', 11, 50017319, 2, ',50017300,50017319,50017544,', 0),
(50017545, '踏套/脚垫', 12, 50017319, 2, ',50017300,50017319,50017545,', 0),
(50017546, '键盘架', 13, 50017319, 2, ',50017300,50017319,50017546,', 0),
(50017547, '踏板控制器', 14, 50017319, 2, ',50017300,50017319,50017547,', 0),
(50017548, '电源/适配器', 15, 50017319, 2, ',50017300,50017319,50017548,', 0),
(50017549, '罩/袋/盒/包/套', 16, 50017319, 2, ',50017300,50017319,50017549,', 0),
(50017550, '背带', 17, 50017319, 2, ',50017300,50017319,50017550,', 0),
(50017551, '笛头', 18, 50017319, 2, ',50017300,50017319,50017551,', 0),
(50017552, '号嘴', 19, 50017319, 2, ',50017300,50017319,50017552,', 0),
(50017553, '哨片', 20, 50017319, 2, ',50017300,50017319,50017553,', 0),
(50017554, '乐器连接线', 21, 50017319, 2, ',50017300,50017319,50017554,', 0),
(50017555, '笛膜', 22, 50017319, 2, ',50017300,50017319,50017555,', 0),
(50017556, '松香等低值易耗品', 23, 50017319, 2, ',50017300,50017319,50017556,', 0),
(50017557, '擦拭布/抛光布', 24, 50017319, 2, ',50017300,50017319,50017557,', 0),
(50017558, '指挥棒', 25, 50017319, 2, ',50017300,50017319,50017558,', 0),
(50017559, '谱架/谱台', 26, 50017319, 2, ',50017300,50017319,50017559,', 0),
(50017560, '节拍器', 27, 50017319, 2, ',50017300,50017319,50017560,', 0),
(50017561, '音叉/音笛/调音器', 28, 50017319, 2, ',50017300,50017319,50017561,', 0),
(50017562, '手指练习器', 29, 50017319, 2, ',50017300,50017319,50017562,', 0),
(50017563, '其它乐器配件', 30, 50017319, 2, ',50017300,50017319,50017563,', 0),
(50017564, '乐器定制', 0, 50017320, 2, ',50017300,50017320,50017564,', 0),
(50017565, '乐器出租', 1, 50017320, 2, ',50017300,50017320,50017565,', 0),
(50017566, '乐器维修', 2, 50017320, 2, ',50017300,50017320,50017566,', 0),
(50017567, '儿童摇铃', 0, 50017321, 2, ',50017300,50017321,50017567,', 0),
(50017568, '儿童吉他', 1, 50017321, 2, ',50017300,50017321,50017568,', 0),
(50017569, '儿童口琴', 2, 50017321, 2, ',50017300,50017321,50017569,', 0),
(50017570, '儿童钢琴', 3, 50017321, 2, ',50017300,50017321,50017570,', 0),
(50017571, '儿童击打乐器', 4, 50017321, 2, ',50017300,50017321,50017571,', 0),
(50017572, '儿童架子鼓', 5, 50017321, 2, ',50017300,50017321,50017572,', 0),
(50017573, '儿童口风琴', 6, 50017321, 2, ',50017300,50017321,50017573,', 0),
(50017574, '其他儿童乐器', 7, 50017321, 2, ',50017300,50017321,50017574,', 0),
(50017328, '京锣', 0, 50017322, 2, ',50017300,50017322,50017328,', 0),
(50017329, '武锣', 1, 50017322, 2, ',50017300,50017322,50017329,', 0),
(50017330, '苏锣', 2, 50017322, 2, ',50017300,50017322,50017330,', 0),
(50017331, '手锣', 3, 50017322, 2, ',50017300,50017322,50017331,', 0),
(50017332, '云锣', 4, 50017322, 2, ',50017300,50017322,50017332,', 0),
(50017333, '舟山锣', 5, 50017322, 2, ',50017300,50017322,50017333,', 0),
(50017334, '虎音锣', 6, 50017322, 2, ',50017300,50017322,50017334,', 0),
(50017335, '开道锣', 7, 50017322, 2, ',50017300,50017322,50017335,', 0),
(50017336, '低音锣', 8, 50017322, 2, ',50017300,50017322,50017336,', 0),
(50017337, '其它锣', 9, 50017322, 2, ',50017300,50017322,50017337,', 0),
(50017351, '堂鼓', 0, 50017325, 2, ',50017300,50017325,50017351,', 0),
(50017352, '战鼓', 1, 50017325, 2, ',50017300,50017325,50017352,', 0),
(50017353, '腰鼓', 2, 50017325, 2, ',50017300,50017325,50017353,', 0),
(50017354, '秧歌鼓', 3, 50017325, 2, ',50017300,50017325,50017354,', 0),
(50017355, '排鼓', 4, 50017325, 2, ',50017300,50017325,50017355,', 0),
(50017356, '板鼓', 5, 50017325, 2, ',50017300,50017325,50017356,', 0),
(50017357, '花盆鼓', 6, 50017325, 2, ',50017300,50017325,50017357,', 0),
(50017358, '铜鼓', 7, 50017325, 2, ',50017300,50017325,50017358,', 0),
(50017359, '细腰鼓', 8, 50017325, 2, ',50017300,50017325,50017359,', 0),
(50017360, '象脚鼓', 9, 50017325, 2, ',50017300,50017325,50017360,', 0),
(50017361, '其它鼓', 10, 50017325, 2, ',50017300,50017325,50017361,', 0),
(50017511, '提琴盒/包', 0, 50017510, 2, ',50017300,50017510,50017511,', 0),
(50017512, '提琴弓', 1, 50017510, 2, ',50017300,50017510,50017512,', 0),
(50017513, '提琴弦', 2, 50017510, 2, ',50017300,50017510,50017513,', 0),
(50017514, '肩垫', 3, 50017510, 2, ',50017300,50017510,50017514,', 0),
(50017515, '琴托', 4, 50017510, 2, ',50017300,50017510,50017515,', 0),
(50017516, '琴码', 5, 50017510, 2, ',50017300,50017510,50017516,', 0),
(50017517, '微调', 6, 50017510, 2, ',50017300,50017510,50017517,', 0),
(50017518, '拉弦板', 7, 50017510, 2, ',50017300,50017510,50017518,', 0),
(50017519, '指板', 8, 50017510, 2, ',50017300,50017510,50017519,', 0),
(50017520, '弦钮', 9, 50017510, 2, ',50017300,50017510,50017520,', 0),
(50017522, '其它提琴配件', 11, 50017510, 2, ',50017300,50017510,50017522,', 0),
(50017617, '排球', 0, 50017616, 2, ',50010728,50017616,50017617,', 0),
(50017618, '排球服', 1, 50017616, 2, ',50010728,50017616,50017618,', 0),
(50017619, '排球鞋', 2, 50017616, 2, ',50010728,50017616,50017619,', 0),
(50017621, '排球球网/球柱', 4, 50017616, 2, ',50010728,50017616,50017621,', 0),
(50017622, '充气设备', 5, 50017616, 2, ',50010728,50017616,50017622,', 0),
(50017623, '排球战术板', 6, 50017616, 2, ',50010728,50017616,50017623,', 0),
(50017624, '更多排球配件', 7, 50017616, 2, ',50010728,50017616,50017624,', 0),
(50017626, '壁球', 0, 50017625, 2, ',50010728,50017625,50017626,', 0),
(50017627, '壁球拍', 1, 50017625, 2, ',50010728,50017625,50017627,', 0),
(50017628, '壁球拍线', 2, 50017625, 2, ',50010728,50017625,50017628,', 0),
(50017630, '壁球鞋', 4, 50017625, 2, ',50010728,50017625,50017630,', 0),
(50017631, '更多壁球配件', 5, 50017625, 2, ',50010728,50017625,50017631,', 0),
(50017723, '台球', 0, 50017722, 2, ',50010728,50017722,50017723,', 0),
(50017724, '台球杆', 1, 50017722, 2, ',50010728,50017722,50017724,', 0),
(50017746, '台尼/台球布', 2, 50017722, 2, ',50010728,50017722,50017746,', 0),
(50017725, '台球桌', 2, 50017722, 2, ',50010728,50017722,50017725,', 0),
(50017726, '杆盒/杆筒/杆袋', 3, 50017722, 2, ',50010728,50017722,50017726,', 0),
(50017727, '皮头/杆头', 4, 50017722, 2, ',50010728,50017722,50017727,', 0),
(50017748, '皮头胶水', 4, 50017722, 2, ',50010728,50017722,50017748,', 0),
(50017728, '巧克粉', 5, 50017722, 2, ',50010728,50017722,50017728,', 0),
(50017729, '台球三指手套', 6, 50017722, 2, ',50010728,50017722,50017729,', 0),
(50017730, '球杆加长器', 7, 50017722, 2, ',50010728,50017722,50017730,', 0),
(50017739, '台球三角架', 8, 50017722, 2, ',50010728,50017722,50017739,', 0),
(50017740, '台球架杆器', 9, 50017722, 2, ',50010728,50017722,50017740,', 0),
(50017741, '球杆保养工具', 10, 50017722, 2, ',50010728,50017722,50017741,', 0),
(50017742, '巧粉夹/巧粉袋', 11, 50017722, 2, ',50010728,50017722,50017742,', 0),
(50017818, '台球挂件', 12, 50017722, 2, ',50010728,50017722,50017818,', 0),
(50019710, '台球修杆器', 13, 50017722, 2, ',50010728,50017722,50019710,', 0),
(50019711, '球杆保养油', 14, 50017722, 2, ',50010728,50017722,50019711,', 0),
(50017743, '台球配件', 15, 50017722, 2, ',50010728,50017722,50017743,', 1),
(50017758, '保龄球', 0, 50017757, 2, ',50010728,50017757,50017758,', 0),
(50017761, '保龄球瓶', 1, 50017757, 2, ',50010728,50017757,50017761,', 0),
(50017762, '保龄球鞋', 2, 50017757, 2, ',50010728,50017757,50017762,', 0),
(50017763, '保龄球包', 3, 50017757, 2, ',50010728,50017757,50017763,', 0),
(50017764, '儿童益智保龄球', 4, 50017757, 2, ',50010728,50017757,50017764,', 0),
(50017821, '保龄球挂件', 5, 50017757, 2, ',50010728,50017757,50017821,', 0),
(50017765, '更多保龄球配件', 6, 50017757, 2, ',50010728,50017757,50017765,', 0),
(50017777, '高尔夫球', 0, 50017776, 2, ',50010728,50017776,50017777,', 0),
(50017779, '高尔夫球杆', 1, 50017776, 2, ',50010728,50017776,50017779,', 0),
(50017780, '高尔夫手套', 2, 50017776, 2, ',50010728,50017776,50017780,', 0),
(50017781, '高尔夫球钉', 3, 50017776, 2, ',50010728,50017776,50017781,', 0),
(50017782, '高尔夫服装', 4, 50017776, 2, ',50010728,50017776,50017782,', 0),
(50017783, '高尔夫球帽', 5, 50017776, 2, ',50010728,50017776,50017783,', 0),
(50017784, '高尔夫鞋', 6, 50017776, 2, ',50010728,50017776,50017784,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50017785, '高尔夫包', 7, 50017776, 2, ',50010728,50017776,50017785,', 0),
(50017786, '高尔夫伞', 8, 50017776, 2, ',50010728,50017776,50017786,', 0),
(50017787, '高尔夫杆套', 9, 50017776, 2, ',50010728,50017776,50017787,', 0),
(50017788, '推杆练习器', 10, 50017776, 2, ',50010728,50017776,50017788,', 0),
(50017789, '挥杆练习器', 11, 50017776, 2, ',50010728,50017776,50017789,', 0),
(50017790, '高尔夫练习网', 12, 50017776, 2, ',50010728,50017776,50017790,', 0),
(50017791, '更多练习配件区', 14, 50017776, 2, ',50010728,50017776,50017791,', 1),
(50017860, '棒球', 0, 50017859, 2, ',50010728,50017859,50017860,', 0),
(50017861, '棒球棒', 1, 50017859, 2, ',50010728,50017859,50017861,', 0),
(50017862, '棒球手套', 2, 50017859, 2, ',50010728,50017859,50017862,', 0),
(50017863, '棒球帽', 3, 50017859, 2, ',50010728,50017859,50017863,', 0),
(50017864, '棒球球服', 4, 50017859, 2, ',50010728,50017859,50017864,', 0),
(50017865, '棒球鞋', 5, 50017859, 2, ',50010728,50017859,50017865,', 0),
(50017867, '棒球球迷用品', 7, 50017859, 2, ',50010728,50017859,50017867,', 0),
(50017869, '更多棒球配件', 9, 50017859, 2, ',50010728,50017859,50017869,', 0),
(50017872, '麻将', 0, 50017871, 2, ',50010728,50017871,50017872,', 1),
(50017884, '牌九', 1, 50017871, 2, ',50010728,50017871,50017884,', 0),
(50017885, '色子/骰子', 2, 50017871, 2, ',50010728,50017871,50017885,', 0),
(50017886, '筛盅', 3, 50017871, 2, ',50010728,50017871,50017886,', 0),
(50017887, '扑克', 4, 50017871, 2, ',50010728,50017871,50017887,', 0),
(50017888, 'UNO牌', 5, 50017871, 2, ',50010728,50017871,50017888,', 0),
(50017889, '筹码/筹码架', 6, 50017871, 2, ',50010728,50017871,50017889,', 0),
(50017890, '洗牌机/发牌机/切牌片', 7, 50017871, 2, ',50010728,50017871,50017890,', 0),
(50017891, '围棋', 8, 50017871, 2, ',50010728,50017871,50017891,', 0),
(50017892, '中国象棋', 9, 50017871, 2, ',50010728,50017871,50017892,', 0),
(50017893, '国际象棋', 10, 50017871, 2, ',50010728,50017871,50017893,', 0),
(50017894, '跳棋', 11, 50017871, 2, ',50010728,50017871,50017894,', 0),
(50017895, '军棋/陆战棋', 12, 50017871, 2, ',50010728,50017871,50017895,', 0),
(50017896, '飞行棋', 13, 50017871, 2, ',50010728,50017871,50017896,', 0),
(50017897, '大富翁', 14, 50017871, 2, ',50010728,50017871,50017897,', 0),
(50018183, '三国杀', 15, 50017871, 2, ',50010728,50017871,50018183,', 0),
(50017898, '斗兽棋', 16, 50017871, 2, ',50010728,50017871,50017898,', 0),
(50017899, '转盘', 17, 50017871, 2, ',50010728,50017871,50017899,', 0),
(50018215, '卡卡颂', 18, 50017871, 2, ',50010728,50017871,50018215,', 0),
(50018216, '德国心脏病', 19, 50017871, 2, ',50010728,50017871,50018216,', 0),
(50018217, '富饶之城', 20, 50017871, 2, ',50010728,50017871,50018217,', 0),
(50019704, '魔方/3D魔方', 21, 50017871, 2, ',50010728,50017871,50019704,', 0),
(50017900, '更多棋牌', 22, 50017871, 2, ',50010728,50017871,50017900,', 0),
(50023574, '多米诺骨牌', 23, 50017871, 2, ',50010728,50017871,50023574,', 0),
(50024958, '万智牌', 24, 50017871, 2, ',50010728,50017871,50024958,', 0),
(50024959, '狼人', 25, 50017871, 2, ',50010728,50017871,50024959,', 0),
(50024960, '拉密/以色列麻将', 26, 50017871, 2, ',50010728,50017871,50024960,', 0),
(50024961, '官捉兵', 27, 50017871, 2, ',50010728,50017871,50024961,', 0),
(50024962, '矮人矿工', 28, 50017871, 2, ',50010728,50017871,50024962,', 0),
(50017914, '太极', 0, 50017913, 2, ',50010728,50017913,50017914,', 1),
(50017925, '跆拳道', 1, 50017913, 2, ',50010728,50017913,50017925,', 1),
(50017937, '拳击/散打/泰拳', 2, 50017913, 2, ',50010728,50017913,50017937,', 1),
(50017947, '空手道', 3, 50017913, 2, ',50010728,50017913,50017947,', 1),
(50017955, '摔跤', 4, 50017913, 2, ',50010728,50017913,50017955,', 1),
(50017963, '柔道', 5, 50017913, 2, ',50010728,50017913,50017963,', 1),
(50017970, '剑道', 6, 50017913, 2, ',50010728,50017913,50017970,', 1),
(50017976, '双截棍', 7, 50017913, 2, ',50010728,50017913,50017976,', 0),
(50017981, '九节鞭', 8, 50017913, 2, ',50010728,50017913,50017981,', 0),
(50017984, 'T型棍/T型拐', 10, 50017913, 2, ',50010728,50017913,50017984,', 0),
(50017985, '三节甩棍/伸缩棍', 11, 50017913, 2, ',50010728,50017913,50017985,', 0),
(50017986, '负重设备', 12, 50017913, 2, ',50010728,50017913,50017986,', 0),
(50017987, '更多武术装备', 13, 50017913, 2, ',50010728,50017913,50017987,', 0),
(50018006, '飞镖', 0, 50018005, 2, ',50010728,50018005,50018006,', 1),
(50018013, '桌上足球', 1, 50018005, 2, ',50010728,50018005,50018013,', 1),
(50018017, '沙狐球', 2, 50018005, 2, ',50010728,50018005,50018017,', 1),
(50018053, '桌上冰球', 3, 50018005, 2, ',50010728,50018005,50018053,', 0),
(50018022, '更多室内休闲用品', 4, 50018005, 2, ',50010728,50018005,50018022,', 0),
(50020279, '悠悠/溜溜球', 5, 50018005, 2, ',50010728,50018005,50020279,', 0),
(50018026, '毽子', 0, 50018025, 2, ',50010728,50018025,50018026,', 0),
(50018027, '空竹', 1, 50018025, 2, ',50010728,50018025,50018027,', 1),
(50018032, '拔河绳', 2, 50018025, 2, ',50010728,50018025,50018032,', 0),
(50018033, '风筝', 3, 50018025, 2, ',50010728,50018025,50018033,', 1),
(50018038, '沙包', 4, 50018025, 2, ',50010728,50018025,50018038,', 0),
(50018039, '陀螺', 5, 50018025, 2, ',50010728,50018025,50018039,', 0),
(50018040, '剑球/技巧球', 6, 50018025, 2, ',50010728,50018025,50018040,', 0),
(50018185, '藤球', 8, 50018025, 2, ',50010728,50018025,50018185,', 0),
(50018187, '板羽球(三毛球)', 9, 50018025, 2, ',50010728,50018025,50018187,', 0),
(50018188, '板羽球拍', 10, 50018025, 2, ',50010728,50018025,50018188,', 0),
(50018041, '更多民间运动用品', 11, 50018025, 2, ',50010728,50018025,50018041,', 0),
(50019557, '无极健身球', 12, 50018025, 2, ',50010728,50018025,50019557,', 0),
(50019558, '嗒嗒球/球拍', 13, 50018025, 2, ',50010728,50018025,50019558,', 0),
(50019983, '门球', 14, 50018025, 2, ',50010728,50018025,50019983,', 1),
(50019991, '滚铁环', 15, 50018025, 2, ',50010728,50018025,50019991,', 0),
(50026076, '可乐球', 16, 50018025, 2, ',50010728,50018025,50026076,', 0),
(50020220, 'Kinect体感器', 0, 50018082, 2, ',20,50018082,50020220,', 0),
(50018083, '手柄', 1, 50018082, 2, ',20,50018082,50018083,', 0),
(50018084, '电源', 2, 50018082, 2, ',20,50018082,50018084,', 0),
(50018085, '各类线材', 3, 50018082, 2, ',20,50018082,50018085,', 0),
(50018086, '硬盘盒', 4, 50018082, 2, ',20,50018082,50018086,', 0),
(50018087, '其他配件', 5, 50018082, 2, ',20,50018082,50018087,', 0),
(50018097, '橄榄球', 0, 50018096, 2, ',50010728,50018096,50018097,', 0),
(50018098, '橄榄球服', 1, 50018096, 2, ',50010728,50018096,50018098,', 0),
(50018099, '橄榄球鞋', 2, 50018096, 2, ',50010728,50018096,50018099,', 0),
(50018100, '橄榄球头盔', 3, 50018096, 2, ',50010728,50018096,50018100,', 0),
(50018102, '更多橄榄球配件', 5, 50018096, 2, ',50010728,50018096,50018102,', 0),
(50018159, '急救包/急救箱', 0, 50018158, 2, ',50013886,50018158,50018159,', 0),
(50018182, '急救护理用品', 1, 50018158, 2, ',50013886,50018158,50018182,', 0),
(50018167, '防灾包/防地震包', 2, 50018158, 2, ',50013886,50018158,50018167,', 0),
(50018160, '求生哨', 3, 50018158, 2, ',50013886,50018158,50018160,', 0),
(50018168, '信号镜', 4, 50018158, 2, ',50013886,50018158,50018168,', 0),
(50018162, '救生棒/荧光棒', 5, 50018158, 2, ',50013886,50018158,50018162,', 0),
(50018161, '急救毯/保温毯', 6, 50018158, 2, ',50013886,50018158,50018161,', 0),
(50018166, '防护面罩', 8, 50018158, 2, ',50013886,50018158,50018166,', 0),
(50014499, '生存包', 9, 50018158, 2, ',50013886,50018158,50014499,', 0),
(50018169, '防护口罩', 9, 50018158, 2, ',50013886,50018158,50018169,', 0),
(50018163, '运动护具', 10, 50018158, 2, ',50013886,50018158,50018163,', 0),
(50018170, '求生绳/逃生绳', 13, 50018158, 2, ',50013886,50018158,50018170,', 0),
(50018172, '求生锯/绳锯/线锯', 15, 50018158, 2, ',50013886,50018158,50018172,', 0),
(50018173, '取暖器/暖宝宝/暖手炉', 16, 50018158, 2, ',50013886,50018158,50018173,', 0),
(50018164, '其他防护救生装备', 18, 50018158, 2, ',50013886,50018158,50018164,', 0),
(50018190, '赛车服', 0, 50018189, 2, ',50010728,50018189,50018190,', 0),
(50018191, '赛车鞋', 1, 50018189, 2, ',50010728,50018189,50018191,', 0),
(50018192, '赛车帽', 2, 50018189, 2, ',50010728,50018189,50018192,', 0),
(50018193, '赛车球迷用品', 3, 50018189, 2, ',50010728,50018189,50018193,', 0),
(50018195, '冰刀鞋', 0, 50018194, 2, ',50010728,50018194,50018195,', 0),
(50018196, '滑冰服', 1, 50018194, 2, ',50010728,50018194,50018196,', 0),
(50018197, '冰球杆', 2, 50018194, 2, ',50010728,50018194,50018197,', 0),
(50018198, '冰球', 3, 50018194, 2, ',50010728,50018194,50018198,', 0),
(50018199, '冰上运动配件区', 4, 50018194, 2, ',50010728,50018194,50018199,', 1),
(50018214, '更多冰上运动', 5, 50018194, 2, ',50010728,50018194,50018214,', 0),
(50018238, '电源', 0, 50018224, 2, ',20,50018224,50018238,', 0),
(50018237, '手柄', 1, 50018224, 2, ',20,50018224,50018237,', 0),
(50018226, '记忆卡', 2, 50018224, 2, ',20,50018224,50018226,', 0),
(50018227, '震动包', 3, 50018224, 2, ',20,50018224,50018227,', 0),
(50018228, 'AV线', 4, 50018224, 2, ',20,50018224,50018228,', 0),
(50018229, '其他专用配件', 5, 50018224, 2, ',20,50018224,50018229,', 0),
(50018231, '手柄', 0, 50018225, 2, ',20,50018225,50018231,', 0),
(50018232, 'AV线', 1, 50018225, 2, ',20,50018225,50018232,', 0),
(50018233, '记忆卡', 2, 50018225, 2, ',20,50018225,50018233,', 0),
(50018234, 'SD卡', 3, 50018225, 2, ',20,50018225,50018234,', 0),
(50018235, '电源', 4, 50018225, 2, ',20,50018225,50018235,', 0),
(50018236, '其他配件', 5, 50018225, 2, ',20,50018225,50018236,', 0),
(50018239, '按键', 0, 50018230, 2, ',20,50018230,50018239,', 0),
(50018240, '外壳', 1, 50018230, 2, ',20,50018230,50018240,', 0),
(50018241, '屏幕', 2, 50018230, 2, ',20,50018230,50018241,', 0),
(50018242, '其他', 3, 50018230, 2, ',20,50018230,50018242,', 0),
(50012438, '毛巾/手帕', 0, 50018325, 2, ',50014812,50018325,50012438,', 0),
(50012759, '吸汗巾/垫背巾', 10, 50018325, 2, ',50014812,50018325,50012759,', 0),
(50017082, '小围嘴', 46, 50018325, 2, ',50014812,50018325,50017082,', 0),
(50018417, '袖套', 95, 50018325, 2, ',50014812,50018325,50018417,', 0),
(50018418, '三角巾', 96, 50018325, 2, ',50014812,50018325,50018418,', 0),
(50018419, '反穿衣', 97, 50018325, 2, ',50014812,50018325,50018419,', 0),
(50018420, '食饭兜', 98, 50018325, 2, ',50014812,50018325,50018420,', 0),
(50019165, 'Touch通讯模块套', 0, 50018326, 2, ',50008090,50018326,50019165,', 0),
(50018599, '苹果保护套/保护壳', 1, 50018326, 2, ',50008090,50018326,50018599,', 0),
(50018600, '苹果笔记本包', 2, 50018326, 2, ',50008090,50018326,50018600,', 0),
(50018601, '苹果笔记本电池', 3, 50018326, 2, ',50008090,50018326,50018601,', 0),
(50018602, '苹果车载充电器', 4, 50018326, 2, ',50008090,50018326,50018602,', 0),
(50018603, '苹果车载发射器', 5, 50018326, 2, ',50008090,50018326,50018603,', 0),
(50018604, '苹果充电器/电源', 6, 50018326, 2, ',50008090,50018326,50018604,', 0),
(50018605, '苹果底座/支架', 7, 50018326, 2, ',50008090,50018326,50018605,', 0),
(50018606, '苹果键盘保护膜', 8, 50018326, 2, ',50008090,50018326,50018606,', 0),
(50018607, '苹果屏幕贴膜', 9, 50018326, 2, ',50008090,50018326,50018607,', 0),
(50018608, '苹果视频线/转换线', 10, 50018326, 2, ',50008090,50018326,50018608,', 0),
(50018609, '苹果手写笔', 11, 50018326, 2, ',50008090,50018326,50018609,', 0),
(50018610, '苹果数据线', 12, 50018326, 2, ',50008090,50018326,50018610,', 0),
(50018612, '苹果线控耳机', 14, 50018326, 2, ',50008090,50018326,50018612,', 0),
(50018613, '苹果遥控器', 15, 50018326, 2, ',50008090,50018326,50018613,', 0),
(50018614, '苹果专用音箱', 16, 50018326, 2, ',50008090,50018326,50018614,', 0),
(50018679, '苹果基站', 17, 50018326, 2, ',50008090,50018326,50018679,', 0),
(50018615, '苹果臂带', 18, 50018326, 2, ',50008090,50018326,50018615,', 0),
(50018616, '苹果零部件', 21, 50018326, 2, ',50008090,50018326,50018616,', 1),
(50018623, '其它苹果配件', 23, 50018326, 2, ',50008090,50018326,50018623,', 0),
(50025807, '苹果笔记本机身贴膜', 24, 50018326, 2, ',50008090,50018326,50025807,', 0),
(50025835, 'iPhone防辐射听筒', 25, 50018326, 2, ',50008090,50018326,50025835,', 0),
(50050365, 'SIM卡相关', 26, 50018326, 2, ',50008090,50018326,50050365,', 1),
(50018415, '调奶器', 1, 50018391, 2, ',50014812,50018391,50018415,', 0),
(50008703, '暖奶器/加热器', 5, 50018391, 2, ',50014812,50018391,50008703,', 0),
(50008711, 'BB煲/电粥锅', 10, 50018391, 2, ',50014812,50018391,50008711,', 0),
(50008704, '奶瓶消毒器/消毒锅', 16, 50018391, 2, ',50014812,50018391,50008704,', 0),
(50008705, '电动奶粉搅拌器', 19, 50018391, 2, ',50014812,50018391,50008705,', 0),
(50012753, '湿巾加热器', 33, 50018391, 2, ',50014812,50018391,50012753,', 0),
(50012413, '睡袋', 0, 50018395, 2, ',50014812,50018395,50012413,', 0),
(50012420, '婴儿枕/儿童枕', 2, 50018395, 2, ',50014812,50018395,50012420,', 0),
(50012419, '凉席', 13, 50018395, 2, ',50014812,50018395,50012419,', 0),
(50018422, '婴童蚊帐', 14, 50018395, 2, ',50014812,50018395,50018422,', 0),
(50018686, '其它零配件', 15, 50018395, 2, ',50014812,50018395,50018686,', 0),
(50012446, '浴盆', 0, 50018396, 2, ',50014812,50018396,50012446,', 0),
(50018805, '浴网/浴兜', 1, 50018396, 2, ',50014812,50018396,50018805,', 0),
(50012441, '沐浴棉/浴擦', 2, 50018396, 2, ',50014812,50018396,50012441,', 0),
(50012460, '水温计', 8, 50018396, 2, ',50014812,50018396,50012460,', 0),
(50012599, '洗发帽', 18, 50018396, 2, ',50014812,50018396,50012599,', 0),
(50014846, '脸盆', 38, 50018396, 2, ',50014812,50018396,50014846,', 0),
(50012443, '浴巾/浴衣', 39, 50018396, 2, ',50014812,50018396,50012443,', 0),
(50016467, '洗发杯/水勺', 41, 50018396, 2, ',50014812,50018396,50016467,', 0),
(50018399, 'MINI按摩器', 0, 50018398, 2, ',50002768,50018398,50018399,', 0),
(50018400, '按摩棒/锤', 1, 50018398, 2, ',50002768,50018398,50018400,', 0),
(50018401, '头部按摩机', 2, 50018398, 2, ',50002768,50018398,50018401,', 0),
(50018402, '眼部按摩器', 3, 50018398, 2, ',50002768,50018398,50018402,', 0),
(50018403, '按摩披肩/肩背敲击按摩带', 4, 50018398, 2, ',50002768,50018398,50018403,', 0),
(50018404, '按摩枕/颈腰靠垫/坐垫', 5, 50018398, 2, ',50002768,50018398,50018404,', 0),
(50018405, '按摩椅垫', 6, 50018398, 2, ',50002768,50018398,50018405,', 0),
(50018406, '按摩椅/沙发', 7, 50018398, 2, ',50002768,50018398,50018406,', 0),
(50018407, '按摩床', 8, 50018398, 2, ',50002768,50018398,50018407,', 0),
(50018408, '按摩床垫', 9, 50018398, 2, ',50002768,50018398,50018408,', 0),
(50018409, '按摩足疗机', 10, 50018398, 2, ',50002768,50018398,50018409,', 0),
(50018410, '其它按摩器材', 11, 50018398, 2, ',50002768,50018398,50018410,', 0),
(50023375, '足部按摩走毯', 12, 50018398, 2, ',50002768,50018398,50023375,', 0),
(50010467, '便携购物车', 0, 50018683, 2, ',50016348,50018683,50010467,', 0),
(50023172, '收纳凳', 35, 50018683, 2, ',50016348,50018683,50023172,', 0),
(50023180, '收纳瓶', 37, 50018683, 2, ',50016348,50018683,50023180,', 0),
(50023181, '收纳盒/储物箱（屏蔽）', 38, 50018683, 2, ',50016348,50018683,50023181,', 0),
(50025902, '收纳袋', 47, 50018683, 2, ',50016348,50018683,50025902,', 1),
(50025903, '储物箱', 48, 50018683, 2, ',50016348,50018683,50025903,', 1),
(50025904, '收纳架', 49, 50018683, 2, ',50016348,50018683,50025904,', 1),
(50025905, '收纳篮', 50, 50018683, 2, ',50016348,50018683,50025905,', 1),
(50025906, '收纳罐', 51, 50018683, 2, ',50016348,50018683,50025906,', 1),
(50025908, '收纳包', 53, 50018683, 2, ',50016348,50018683,50025908,', 1),
(50025909, '收纳桶', 54, 50018683, 2, ',50016348,50018683,50025909,', 1),
(50025911, '收纳柜', 56, 50018683, 2, ',50016348,50018683,50025911,', 1),
(50025915, '收纳盒', 58, 50018683, 2, ',50016348,50018683,50025915,', 1),
(50025936, '收纳套', 61, 50018683, 2, ',50016348,50018683,50025936,', 1),
(50025955, '其他', 62, 50018683, 2, ',50016348,50018683,50025955,', 0),
(50014527, '中网', 0, 50018708, 2, ',26,50018708,50014527,', 0),
(50012862, '汽车包围', 0, 50018708, 2, ',26,50018708,50012862,', 0),
(50022759, '滤芯', 1, 50018708, 2, ',26,50018708,50022759,', 1),
(50012860, '尾翼', 7, 50018708, 2, ',26,50018708,50012860,', 0),
(50012903, '保险杠', 15, 50018708, 2, ',26,50018708,50012903,', 0),
(50014533, '车底防护板/发动机挡板', 16, 50018708, 2, ',26,50018708,50014533,', 0),
(50012935, '车顶架', 17, 50018708, 2, ',26,50018708,50012935,', 0),
(50012863, '挡泥板', 18, 50018708, 2, ',26,50018708,50012863,', 0),
(50016326, '轮毂', 18, 50018708, 2, ',26,50018708,50016326,', 0),
(50012131, '轮胎', 19, 50018708, 2, ',26,50018708,50012131,', 0),
(50022793, '雨挡', 22, 50018708, 2, ',26,50018708,50022793,', 0),
(50012888, '雨刮器', 23, 50018708, 2, ',26,50018708,50012888,', 0),
(50000626, '车用天线', 25, 50018708, 2, ',26,50018708,50000626,', 0),
(50012864, '隔音隔热棉', 26, 50018708, 2, ',26,50018708,50012864,', 0),
(50022795, '越野车轮眉', 28, 50018708, 2, ',26,50018708,50022795,', 0),
(50022798, '大灯清洗', 30, 50018708, 2, ',26,50018708,50022798,', 0),
(50012869, '越野车外侧脚踏板', 30, 50018708, 2, ',26,50018708,50012869,', 0),
(50012894, '车门拉手', 32, 50018708, 2, ',26,50018708,50012894,', 0),
(50015616, '叶子板/子板内衬', 34, 50018708, 2, ',26,50018708,50015616,', 0),
(50018710, '其它车身及外观配件', 114, 50018708, 2, ',26,50018708,50018710,', 0),
(50022760, '内饰系统', 116, 50018708, 2, ',26,50018708,50022760,', 1),
(50022764, '照明系统', 118, 50018708, 2, ',26,50018708,50022764,', 1),
(50014559, '仪表系统', 120, 50018708, 2, ',26,50018708,50014559,', 0),
(50018787, '电气系统', 121, 50018708, 2, ',26,50018708,50018787,', 1),
(50018783, '动力系统', 122, 50018708, 2, ',26,50018708,50018783,', 1),
(50022768, '进排气系统', 123, 50018708, 2, ',26,50018708,50022768,', 1),
(50022769, '变速箱系统', 124, 50018708, 2, ',26,50018708,50022769,', 1),
(50022772, '防盗系统', 125, 50018708, 2, ',26,50018708,50022772,', 1),
(50018788, '冷却系统', 126, 50018708, 2, ',26,50018708,50018788,', 1),
(50022774, '点火系统', 127, 50018708, 2, ',26,50018708,50022774,', 1),
(50022775, '供油系统', 128, 50018708, 2, ',26,50018708,50022775,', 1),
(50018785, '制动系统', 129, 50018708, 2, ',26,50018708,50018785,', 1),
(50018786, '悬挂系统', 130, 50018708, 2, ',26,50018708,50018786,', 1),
(50018784, '转向系统', 132, 50018708, 2, ',26,50018708,50018784,', 1),
(50022777, '车用附件', 133, 50018708, 2, ',26,50018708,50022777,', 1),
(50016293, '其它汽车内部配件', 134, 50018708, 2, ',26,50018708,50016293,', 0),
(50024129, '建筑/DIY小屋/其他拼装模型', 0, 50024128, 2, ',25,50024128,50024129,', 0),
(50024130, '家居/生活场景/食玩', 1, 50024128, 2, ',25,50024128,50024130,', 0),
(50024133, '车模', 2, 50024128, 2, ',25,50024128,50024133,', 0),
(50024135, '飞机模型', 3, 50024128, 2, ',25,50024128,50024135,', 0),
(50024151, '火车模型', 7, 50024128, 2, ',25,50024128,50024151,', 0),
(50024150, '船舶/舰艇', 8, 50024128, 2, ',25,50024128,50024150,', 0),
(50024136, '坦克/军事战车', 9, 50024128, 2, ',25,50024128,50024136,', 0),
(50016059, '可动人偶', 11, 50024128, 2, ',25,50024128,50016059,', 1),
(251612, '兵人专区', 12, 50024128, 2, ',25,50024128,251612,', 0),
(50005847, '麦克法兰专区', 12, 50024128, 2, ',25,50024128,50005847,', 1),
(50008159, '其他模型玩具', 19, 50024128, 2, ',25,50024128,50008159,', 0),
(50024166, '军舰/航母', 20, 50024128, 2, ',25,50024128,50024166,', 0),
(50024154, '避孕套', 0, 50024153, 2, ',50023717,50024153,50024154,', 0),
(50024155, '早孕试纸', 1, 50024153, 2, ',50023717,50024153,50024155,', 0),
(50024156, '排卵试纸', 2, 50024153, 2, ',50023717,50024153,50024156,', 0),
(50024157, '润滑剂', 3, 50024153, 2, ',50023717,50024153,50024157,', 0),
(50001958, '现代和田玉', 3, 50024158, 2, ',23,50024158,50001958,', 0),
(230103, '古玉/老玉', 4, 50024158, 2, ',23,50024158,230103,', 0),
(50024164, '其它玉石', 5, 50024158, 2, ',23,50024158,50024164,', 0),
(50024208, '酒店用品', 0, 50024207, 2, ',50025707,50024207,50024208,', 0),
(50024210, '旅游纪念品', 2, 50024207, 2, ',50025707,50024207,50024210,', 0),
(50024212, '旅游必备品', 4, 50024207, 2, ',50025707,50024207,50024212,', 0),
(50024211, '其他', 5, 50024207, 2, ',50025707,50024207,50024211,', 0),
(111404, '墨盒', 57, 50024248, 2, ',50007218,50024248,111404,', 0),
(111405, '硒鼓/粉盒', 59, 50024248, 2, ',50007218,50024248,111405,', 0),
(111403, '墨粉/碳粉', 62, 50024248, 2, ',50007218,50024248,111403,', 0),
(111407, '色带/碳带', 63, 50024248, 2, ',50007218,50024248,111407,', 0),
(50007222, '软盘', 0, 50024253, 2, ',50007218,50024253,50007222,', 0),
(50018946, '光盘袋/光盘盒', 3, 50024253, 2, ',50007218,50024253,50018946,', 0),
(111406, '刻录盘', 18, 50024253, 2, ',50007218,50024253,111406,', 0),
(50018846, '光盘拷贝机', 123, 50024253, 2, ',50007218,50024253,50018846,', 0),
(111204, '多功能一体机', 0, 50024258, 2, ',50007218,50024258,111204,', 0),
(50012603, '多功能一体机配件', 2, 50024258, 2, ',50007218,50024258,50012603,', 0),
(50018849, '一体化速印机', 124, 50024258, 2, ',50007218,50024258,50018849,', 0),
(50008332, '条码扫描枪', 0, 50024300, 2, ',50007218,50024300,50008332,', 0),
(50019018, 'IC卡/磁卡/射频卡', 6, 50024300, 2, ',50007218,50024300,50019018,', 0),
(50012616, '条码扫描枪配件', 16, 50024300, 2, ',50007218,50024300,50012616,', 0),
(50008335, '标签机/条码打印机', 17, 50024300, 2, ',50007218,50024300,50008335,', 0),
(50019232, '数据采集器', 131, 50024300, 2, ',50007218,50024300,50019232,', 0),
(50019282, '磁卡读卡器', 132, 50024300, 2, ',50007218,50024300,50019282,', 0),
(111220, '收款机', 0, 50024346, 2, ',50007218,50024346,111220,', 0),
(50012606, '收款机配件', 5, 50024346, 2, ',50007218,50024346,50012606,', 0),
(50012613, '点钞机配件', 13, 50024346, 2, ',50007218,50024346,50012613,', 0),
(111215, '点钞机', 26, 50024346, 2, ',50007218,50024346,111215,', 0),
(50010586, '验钞机/笔', 78, 50024346, 2, ',50007218,50024346,50010586,', 0),
(50021295, '不干胶标签', 0, 50024369, 2, ',50007218,50024369,50021295,', 0),
(50018943, '塑封膜', 0, 50024369, 2, ',50007218,50024369,50018943,', 0),
(50021054, '捆扎机/打包机', 0, 50024369, 2, ',50007218,50024369,50021054,', 0),
(50008334, '装订机', 0, 50024369, 2, ',50007218,50024369,50008334,', 0),
(50021056, '封口机', 1, 50024369, 2, ',50007218,50024369,50021056,', 0),
(50018944, '装订耗材', 1, 50024369, 2, ',50007218,50024369,50018944,', 0),
(50021297, '塑料、塑胶标签', 2, 50024369, 2, ',50007218,50024369,50021297,', 0),
(50021058, '真空机', 2, 50024369, 2, ',50007218,50024369,50021058,', 0),
(50021059, '打码机', 3, 50024369, 2, ',50007218,50024369,50021059,', 0),
(50021298, '铭牌', 3, 50024369, 2, ',50007218,50024369,50021298,', 0),
(50021299, '其他标签、标牌', 4, 50024369, 2, ',50007218,50024369,50021299,', 0),
(50021061, '灌装机', 4, 50024369, 2, ',50007218,50024369,50021061,', 0),
(50021062, '收缩机', 5, 50024369, 2, ',50007218,50024369,50021062,', 0),
(50021063, '包装袋', 6, 50024369, 2, ',50007218,50024369,50021063,', 0),
(50012610, '装订机配件', 10, 50024369, 2, ',50007218,50024369,50012610,', 0),
(50012611, '塑封机配件', 11, 50024369, 2, ',50007218,50024369,50012611,', 0),
(50008333, '塑封机', 15, 50024369, 2, ',50007218,50024369,50008333,', 0),
(50018859, '覆膜机', 129, 50024369, 2, ',50007218,50024369,50018859,', 0),
(50012618, '刻录盘个性化服务', 0, 50024389, 2, ',50007218,50024389,50012618,', 0),
(50014827, '商务礼品个性定制服务', 19, 50024389, 2, ',50007218,50024389,50014827,', 0),
(50012619, '硒鼓加粉服务', 20, 50024389, 2, ',50007218,50024389,50012619,', 0),
(50012620, '设备维修或租赁服务', 21, 50024389, 2, ',50007218,50024389,50012620,', 0),
(111214, '考勤门禁', 0, 50024394, 2, ',50007218,50024394,111214,', 0),
(50012608, '考勤机配件', 8, 50024394, 2, ',50007218,50024394,50012608,', 0),
(50012609, '标签机配件', 0, 50024400, 2, ',50007218,50024400,50012609,', 0),
(50012602, '复印机配件', 1, 50024400, 2, ',50007218,50024400,50012602,', 0),
(50012604, '扫描仪配件', 3, 50024400, 2, ',50007218,50024400,50012604,', 0),
(50012607, '打字机配件', 7, 50024400, 2, ',50007218,50024400,50012607,', 0),
(50012612, '刻字机配件', 12, 50024400, 2, ',50007218,50024400,50012612,', 0),
(50012614, '幻灯机配件', 14, 50024400, 2, ',50007218,50024400,50012614,', 0),
(50012621, '其它设备配件', 22, 50024400, 2, ',50007218,50024400,50012621,', 0),
(50024485, '炒饭/拌饭', 0, 50024468, 2, ',50024451,50024468,50024485,', 0),
(50024487, '铁板饭/盖浇饭', 1, 50024468, 2, ',50024451,50024468,50024487,', 0),
(50024489, '粥', 2, 50024468, 2, ',50024451,50024468,50024489,', 0),
(50024491, '米饭', 3, 50024468, 2, ',50024451,50024468,50024491,', 0),
(50024498, '汤面/炒面/拌面', 0, 50024470, 2, ',50024451,50024470,50024498,', 0),
(50024499, '米线/河粉', 1, 50024470, 2, ',50024451,50024470,50024499,', 0),
(50024500, '水饺/煎饺/馄饨', 2, 50024470, 2, ',50024451,50024470,50024500,', 0),
(50024501, '馒头/包子/汤包/煎包', 3, 50024470, 2, ',50024451,50024470,50024501,', 0),
(50024502, '葱油饼/麦饼/饼', 4, 50024470, 2, ',50024451,50024470,50024502,', 0),
(50024503, '其他面食', 5, 50024470, 2, ',50024451,50024470,50024503,', 0),
(50024728, '汉堡/三明治', 0, 50024723, 2, ',50024612,50024723,50024728,', 0),
(50024724, '匹萨', 1, 50024723, 2, ',50024612,50024723,50024724,', 0),
(50024725, '意面/通心粉', 2, 50024723, 2, ',50024612,50024723,50024725,', 0),
(50024726, '炒饭', 3, 50024723, 2, ',50024612,50024723,50024726,', 0),
(50024727, '牛排/猪排/羊排/鸡排', 4, 50024723, 2, ',50024612,50024723,50024727,', 0),
(50024730, '沙拉', 5, 50024723, 2, ',50024612,50024723,50024730,', 0),
(50024731, '薯条/小食', 6, 50024723, 2, ',50024612,50024723,50024731,', 0),
(50024732, '鸡翅/鸡块', 7, 50024723, 2, ',50024612,50024723,50024732,', 0),
(50024733, '其他西餐', 8, 50024723, 2, ',50024612,50024723,50024733,', 0),
(50024735, '寿司/紫菜包饭', 0, 50024734, 2, ',50024612,50024734,50024735,', 0),
(50024736, '石锅拌饭', 1, 50024734, 2, ',50024612,50024734,50024736,', 0),
(50024737, '刺身/生鱼片', 2, 50024734, 2, ',50024612,50024734,50024737,', 0),
(50024738, '其他日韩料理', 3, 50024734, 2, ',50024612,50024734,50024738,', 0),
(50024740, '奶茶', 0, 50024739, 2, ',50024612,50024739,50024740,', 0),
(50024741, '咖啡', 1, 50024739, 2, ',50024612,50024739,50024741,', 0),
(50024742, '奶昔', 2, 50024739, 2, ',50024612,50024739,50024742,', 0),
(50024743, '果汁', 3, 50024739, 2, ',50024612,50024739,50024743,', 0),
(50024744, '花茶', 4, 50024739, 2, ',50024612,50024739,50024744,', 0),
(50024745, '饮料', 5, 50024739, 2, ',50024612,50024739,50024745,', 0),
(50024746, '其他饮品', 6, 50024739, 2, ',50024612,50024739,50024746,', 0),
(50024748, '面包', 0, 50024747, 2, ',50024612,50024747,50024748,', 0),
(50024749, '蛋糕', 1, 50024747, 2, ',50024612,50024747,50024749,', 0),
(50024750, '饼干', 2, 50024747, 2, ',50024612,50024747,50024750,', 0),
(50024751, '西点/糕点', 3, 50024747, 2, ',50024612,50024747,50024751,', 0),
(50024752, '甜品/糖水', 4, 50024747, 2, ',50024612,50024747,50024752,', 0),
(50024753, '其他西点', 5, 50024747, 2, ',50024612,50024747,50024753,', 0),
(50024755, '鸭脖', 0, 50024754, 2, ',50024612,50024754,50024755,', 0),
(50024756, '卤味', 1, 50024754, 2, ',50024612,50024754,50024756,', 0),
(50024757, '特色小吃', 2, 50024754, 2, ',50024612,50024754,50024757,', 0),
(50024759, '新鲜水果', 0, 50024758, 2, ',50024612,50024758,50024759,', 0),
(50024760, '水果拼盘', 1, 50024758, 2, ',50024612,50024758,50024760,', 0),
(50024761, '水果篮', 2, 50024758, 2, ',50024612,50024758,50024761,', 0),
(50024763, '生鲜蔬菜', 0, 50024762, 2, ',50024612,50024762,50024763,', 0),
(50024764, '食材半成品', 1, 50024762, 2, ',50024612,50024762,50024764,', 0),
(50020776, '飘窗垫', 0, 50024797, 2, ',50008163,50024797,50020776,', 0),
(50024799, '椅垫', 1, 50024797, 2, ',50008163,50024797,50024799,', 0),
(50024801, '蒲团', 3, 50024797, 2, ',50008163,50024797,50024801,', 0),
(50024921, '美臀垫/保健坐垫', 4, 50024797, 2, ',50008163,50024797,50024921,', 0),
(50002794, '沙发垫', 34, 50024797, 2, ',50008163,50024797,50002794,', 0),
(50005505, '桌布/桌旗/桌椅套/椅垫', 0, 50024918, 2, ',50008163,50024918,50005505,', 0),
(50020796, '桌布/桌旗', 2, 50024918, 2, ',50008163,50024918,50020796,', 0),
(50020798, '餐巾/餐垫', 3, 50024918, 2, ',50008163,50024918,50020798,', 0),
(50002795, '桌椅脚套/桌脚垫', 35, 50024918, 2, ',50008163,50024918,50002795,', 0),
(50024943, '椅套', 36, 50024918, 2, ',50008163,50024918,50024943,', 0),
(50020753, '刺绣', 0, 50024922, 2, ',50008163,50024922,50020753,', 1),
(50003494, '十字绣套件/成品', 0, 50024922, 2, ',50008163,50024922,50003494,', 0),
(50020676, '定制窗帘', 0, 50024923, 2, ',50008163,50024923,50020676,', 0),
(50024945, '成品窗帘', 0, 50024923, 2, ',50008163,50024923,50024945,', 0),
(50012944, '纱窗\\防蚊帘', 75, 50024923, 2, ',50008163,50024923,50012944,', 0),
(50020732, '浴帘', 0, 50024924, 2, ',50008163,50024924,50020732,', 0),
(50020720, '百叶帘/折帘/罗马帘', 0, 50024924, 2, ',50008163,50024924,50020720,', 0),
(50020678, '卷帘', 1, 50024924, 2, ',50008163,50024924,50020678,', 0),
(50001866, '门帘', 2, 50024924, 2, ',50008163,50024924,50001866,', 0),
(50002790, '珠帘/挂帘', 3, 50024924, 2, ',50008163,50024924,50002790,', 0),
(50020730, '线帘', 7, 50024924, 2, ',50008163,50024924,50020730,', 0),
(50020121, '轨道/罗马杆', 0, 50024925, 2, ',50008163,50024925,50020121,', 0),
(50020736, '辅料配件', 0, 50024925, 2, ',50008163,50024925,50020736,', 1),
(50020751, '窗帘面料', 18, 50024925, 2, ',50008163,50024925,50020751,', 0),
(50021928, '仿真花/假花', 0, 50024938, 2, ',50020808,50024938,50021928,', 0),
(50021929, '仿真植物盆景', 1, 50024938, 2, ',50020808,50024938,50021929,', 0),
(50020901, '花器/花瓶', 1, 50024938, 2, ',50020808,50024938,50020901,', 1),
(50021930, 'DIY仿真材料', 2, 50024938, 2, ',50020808,50024938,50021930,', 0),
(50021931, '仿真水果', 3, 50024938, 2, ',50020808,50024938,50021931,', 0),
(50024939, '干花/花瓣/干花包/干树枝', 4, 50024938, 2, ',50020808,50024938,50024939,', 0),
(50020748, '工艺软包', 0, 50024947, 2, ',50008163,50024947,50020748,', 0),
(50024948, '背景墙软包', 19, 50024947, 2, ',50008163,50024947,50024948,', 0),
(50024949, '天花板软包', 20, 50024947, 2, ',50008163,50024947,50024949,', 0),
(50024950, '床头套', 21, 50024947, 2, ',50008163,50024947,50024950,', 0),
(280910, '个性印章', 0, 50025007, 2, ',50025004,50025007,280910,', 0),
(50014934, '居家装饰定制', 0, 50025007, 2, ',50025004,50025007,50014934,', 1),
(50025021, '扇子定制', 0, 50025007, 2, ',50025004,50025007,50025021,', 0),
(50025022, '照片墙定制', 1, 50025007, 2, ',50025004,50025007,50025022,', 0),
(50025023, '明信片定制', 2, 50025007, 2, ',50025004,50025007,50025023,', 0),
(50025024, 'lomo卡定制', 3, 50025007, 2, ',50025004,50025007,50025024,', 0),
(50025025, '钥匙扣定制', 4, 50025007, 2, ',50025004,50025007,50025025,', 0),
(50025026, '餐具定制', 5, 50025007, 2, ',50025004,50025007,50025026,', 1),
(50025031, '其它日用/装饰定制', 6, 50025007, 2, ',50025004,50025007,50025031,', 0),
(50019776, '抱枕定制', 12, 50025007, 2, ',50025004,50025007,50019776,', 0),
(50015084, '打火机', 13, 50025007, 2, ',50025004,50025007,50015084,', 0),
(50015088, '手绘真人漫画/画类定制', 16, 50025007, 2, ',50025004,50025007,50015088,', 0),
(50008748, '拼图定制', 18, 50025007, 2, ',50025004,50025007,50008748,', 0),
(254107, '个性徽章', 19, 50025007, 2, ',50025004,50025007,254107,', 0),
(50020225, '杯子定制', 20, 50025007, 2, ',50025004,50025007,50020225,', 1),
(280915, '相册/照片书/立体照片', 21, 50025007, 2, ',50025004,50025007,280915,', 0),
(50020230, '个性台历/年历', 22, 50025007, 2, ',50025004,50025007,50020230,', 1),
(50015302, '贺卡/卡贴', 24, 50025007, 2, ',50025004,50025007,50015302,', 0),
(50015304, '笔记本', 25, 50025007, 2, ',50025004,50025007,50015304,', 0),
(50015305, '贴纸/名字条', 26, 50025007, 2, ',50025004,50025007,50015305,', 0),
(50016346, '写真/海报印制', 27, 50025007, 2, ',50025004,50025007,50016346,', 0),
(50020235, '水晶定制', 30, 50025007, 2, ',50025004,50025007,50020235,', 1),
(50025032, '数码配件定制', 0, 50025008, 2, ',50025004,50025008,50025032,', 1),
(50020233, '办公周边定制', 1, 50025008, 2, ',50025004,50025008,50020233,', 1),
(50025039, '其它办公/数码定制', 2, 50025008, 2, ',50025004,50025008,50025039,', 0),
(50025040, '箱包定制', 0, 50025009, 2, ',50025004,50025009,50025040,', 1),
(50025041, '鞋类定制', 1, 50025009, 2, ',50025004,50025009,50025041,', 1),
(50025042, '帽子定制', 2, 50025009, 2, ',50025004,50025009,50025042,', 1),
(50025043, '服装定制', 3, 50025009, 2, ',50025004,50025009,50025043,', 1),
(50025051, '配饰定制', 4, 50025009, 2, ',50025004,50025009,50025051,', 1),
(50015317, '人名项链', 0, 50025010, 2, ',50025004,50025010,50015317,', 0),
(50025017, '脚饰定制', 0, 50025010, 2, ',50025004,50025010,50025017,', 0),
(50020242, '戒指手链定制', 1, 50025010, 2, ',50025004,50025010,50020242,', 0),
(50025018, '耳饰定制', 1, 50025010, 2, ',50025004,50025010,50025018,', 0),
(50025019, '其它饰品定制', 2, 50025010, 2, ',50025004,50025010,50025019,', 0),
(50025020, '其它新奇商品定制', 0, 50025011, 2, ',50025004,50025011,50025020,', 0),
(50014943, '人偶/公仔定制', 4, 50025011, 2, ',50025004,50025011,50014943,', 1),
(50015318, '竹简定制', 14, 50025011, 2, ',50025004,50025011,50015318,', 0),
(50015300, '趣味证书/奖状', 18, 50025011, 2, ',50025004,50025011,50015300,', 0),
(50020240, '圣旨', 32, 50025011, 2, ',50025004,50025011,50020240,', 0),
(50015299, '个性报纸定制', 33, 50025011, 2, ',50025004,50025011,50015299,', 0),
(50020241, '杂志定制', 34, 50025011, 2, ',50025004,50025011,50020241,', 0),
(50015303, '卡牌/扑克/邮票', 35, 50025011, 2, ',50025004,50025011,50015303,', 0),
(50020234, '个人定制原材料', 0, 50025012, 2, ',50025004,50025012,50020234,', 0),
(50014945, '其它商品定制', 6, 50025012, 2, ',50025004,50025012,50014945,', 0),
(50016347, '各类个性定制设备', 7, 50025012, 2, ',50025004,50025012,50016347,', 0),
(50005232, '其他', 0, 50025125, 2, ',50025111,50025125,50005232,', 0),
(50026248, '保姆', 8, 50025125, 2, ',50025111,50025125,50026248,', 1),
(50026257, '婴幼儿/产妇护理', 10, 50025125, 2, ',50025111,50025125,50026257,', 1),
(50026266, '家庭特殊看护', 12, 50025125, 2, ',50025111,50025125,50026266,', 1),
(50026420, '专业保洁/养护', 13, 50025125, 2, ',50025111,50025125,50026420,', 1),
(50026423, '钟点工/小时工', 14, 50025125, 2, ',50025111,50025125,50026423,', 0),
(50026698, '医院陪护', 15, 50025125, 2, ',50025111,50025125,50026698,', 0),
(50014967, '婚礼策划', 0, 50025132, 2, ',50025111,50025132,50014967,', 0),
(50005257, '婚礼司仪', 12, 50025132, 2, ',50025111,50025132,50005257,', 0),
(50010023, '新娘跟妆', 15, 50025132, 2, ',50025111,50025132,50010023,', 0),
(50026282, '婚礼跟拍', 16, 50025132, 2, ',50025111,50025132,50026282,', 1),
(50026295, '婚车租赁', 19, 50025132, 2, ',50025111,50025132,50026295,', 1),
(50022564, '婚纱/礼服租赁', 20, 50025132, 2, ',50025111,50025132,50022564,', 0),
(50026308, '布置装饰', 21, 50025132, 2, ',50025111,50025132,50026308,', 1),
(50026666, '婚礼表演', 22, 50025132, 2, ',50025111,50025132,50026666,', 1),
(50026667, '婚庆素材', 23, 50025132, 2, ',50025111,50025132,50026667,', 0),
(50025134, '租车服务', 0, 50025133, 2, ',50025111,50025133,50025134,', 0),
(50025135, '汽车美容/装饰服务', 1, 50025133, 2, ',50025111,50025133,50025135,', 0),
(50025136, '汽修服务', 2, 50025133, 2, ',50025111,50025133,50025136,', 0),
(50019112, '汽车服务卡', 2, 50025133, 2, ',50025111,50025133,50019112,', 0),
(50025137, '代驾服务', 3, 50025133, 2, ',50025111,50025133,50025137,', 0),
(50025256, '笔记本电脑', 0, 50025240, 2, ',50023878,50025240,50025256,', 0),
(50025257, '平板电脑', 1, 50025240, 2, ',50023878,50025240,50025257,', 0),
(50025258, '台式机', 2, 50025240, 2, ',50023878,50025240,50025258,', 0),
(50025259, '显示器', 3, 50025240, 2, ',50023878,50025240,50025259,', 0),
(50025260, '台式机配件', 4, 50025240, 2, ',50023878,50025240,50025260,', 0),
(50025261, '网络设备', 5, 50025240, 2, ',50023878,50025240,50025261,', 0),
(50025262, '笔记本配件', 6, 50025240, 2, ',50023878,50025240,50025262,', 0),
(50025388, '单反镜头', 0, 50025242, 2, ',50023878,50025242,50025388,', 0),
(50025389, '数码单反', 1, 50025242, 2, ',50023878,50025242,50025389,', 0),
(50025390, '普通数码相机', 2, 50025242, 2, ',50023878,50025242,50025390,', 0),
(50025391, '胶片相机', 3, 50025242, 2, ',50023878,50025242,50025391,', 0),
(50025392, '摄像机', 4, 50025242, 2, ',50023878,50025242,50025392,', 0),
(50025393, '其他', 5, 50025242, 2, ',50023878,50025242,50025393,', 0),
(50025394, 'MP3/MP4/录音笔', 0, 50025243, 2, ',50023878,50025243,50025394,', 0),
(50025395, '游戏机', 1, 50025243, 2, ',50023878,50025243,50025395,', 0),
(50025396, '游戏软件', 2, 50025243, 2, ',50023878,50025243,50025396,', 0),
(50025397, 'U盘', 3, 50025243, 2, ',50023878,50025243,50025397,', 0),
(50025398, '移动硬盘', 4, 50025243, 2, ',50023878,50025243,50025398,', 0),
(50025399, '闪存卡', 5, 50025243, 2, ',50023878,50025243,50025399,', 0),
(50025400, '其他', 6, 50025243, 2, ',50023878,50025243,50025400,', 0),
(50025401, '家具', 0, 50025244, 2, ',50023878,50025244,50025401,', 0),
(50025402, '日用日化', 1, 50025244, 2, ',50023878,50025244,50025402,', 0),
(50025403, '建材', 2, 50025244, 2, ',50023878,50025244,50025403,', 0),
(50025404, '家饰家纺', 3, 50025244, 2, ',50023878,50025244,50025404,', 0),
(50025405, '其他', 4, 50025244, 2, ',50023878,50025244,50025405,', 0),
(50025406, '电视机', 0, 50025245, 2, ',50023878,50025245,50025406,', 0),
(50025407, '洗衣机', 1, 50025245, 2, ',50023878,50025245,50025407,', 0),
(50025408, '空调', 2, 50025245, 2, ',50023878,50025245,50025408,', 0),
(50025409, '冰箱', 3, 50025245, 2, ',50023878,50025245,50025409,', 0),
(50025410, '其他大家电', 4, 50025245, 2, ',50023878,50025245,50025410,', 0),
(50025411, '厨房电器', 5, 50025245, 2, ',50023878,50025245,50025411,', 0),
(50025412, '影音/耳机/HIFI', 6, 50025245, 2, ',50023878,50025245,50025412,', 0),
(50025413, '生活小家电', 7, 50025245, 2, ',50023878,50025245,50025413,', 0),
(50025414, '食品', 0, 50025246, 2, ',50023878,50025246,50025414,', 0),
(50025415, '保健品', 1, 50025246, 2, ',50023878,50025246,50025415,', 0),
(50025416, '孕产妇用品/营养', 0, 50025247, 2, ',50023878,50025247,50025416,', 0),
(50025417, '婴儿装/童装', 1, 50025247, 2, ',50023878,50025247,50025417,', 0),
(50025418, '玩具/早教/益智', 2, 50025247, 2, ',50023878,50025247,50025418,', 0),
(50025419, '婴儿用品', 3, 50025247, 2, ',50023878,50025247,50025419,', 0),
(50025420, '奶粉/宝宝营养', 4, 50025247, 2, ',50023878,50025247,50025420,', 0),
(50025421, '其他', 5, 50025247, 2, ',50023878,50025247,50025421,', 0),
(50024510, '匹萨', 0, 50024476, 2, ',50024451,50024476,50024510,', 0),
(50024509, '意面/通心粉', 1, 50024476, 2, ',50024451,50024476,50024509,', 0),
(50024511, '炒饭', 2, 50024476, 2, ',50024451,50024476,50024511,', 0),
(50024513, '汉堡/三明治', 3, 50024476, 2, ',50024451,50024476,50024513,', 0),
(50024512, '牛排/猪排/羊排/鸡排', 4, 50024476, 2, ',50024451,50024476,50024512,', 0),
(50024514, '沙拉', 6, 50024476, 2, ',50024451,50024476,50024514,', 0),
(50024515, '薯条/小食', 7, 50024476, 2, ',50024451,50024476,50024515,', 0),
(50024516, '鸡翅/鸡块', 8, 50024476, 2, ',50024451,50024476,50024516,', 0),
(50024517, '其他西餐', 9, 50024476, 2, ',50024451,50024476,50024517,', 0),
(50024519, '寿司/紫菜包饭', 0, 50024477, 2, ',50024451,50024477,50024519,', 0),
(50024520, '石锅拌饭', 1, 50024477, 2, ',50024451,50024477,50024520,', 0),
(50024521, '刺身/生鱼片', 2, 50024477, 2, ',50024451,50024477,50024521,', 0),
(50024522, '其他日韩料理', 3, 50024477, 2, ',50024451,50024477,50024522,', 0),
(50024523, '奶茶', 0, 50024478, 2, ',50024451,50024478,50024523,', 0),
(50024524, '咖啡', 1, 50024478, 2, ',50024451,50024478,50024524,', 0),
(50024526, '奶昔', 3, 50024478, 2, ',50024451,50024478,50024526,', 0),
(50024527, '果汁', 4, 50024478, 2, ',50024451,50024478,50024527,', 0),
(50024528, '花茶', 5, 50024478, 2, ',50024451,50024478,50024528,', 0),
(50024529, '饮料', 6, 50024478, 2, ',50024451,50024478,50024529,', 0),
(50024530, '其他饮品', 7, 50024478, 2, ',50024451,50024478,50024530,', 0),
(50024531, '面包', 0, 50024479, 2, ',50024451,50024479,50024531,', 0),
(50024532, '蛋糕', 1, 50024479, 2, ',50024451,50024479,50024532,', 0),
(50024533, '饼干', 2, 50024479, 2, ',50024451,50024479,50024533,', 0),
(50024534, '西点/糕点', 3, 50024479, 2, ',50024451,50024479,50024534,', 0),
(50024535, '甜品/糖水', 4, 50024479, 2, ',50024451,50024479,50024535,', 0),
(50024536, '其他西点', 5, 50024479, 2, ',50024451,50024479,50024536,', 0),
(50024537, '鸭脖', 0, 50024480, 2, ',50024451,50024480,50024537,', 0),
(50024538, '卤味', 1, 50024480, 2, ',50024451,50024480,50024538,', 0),
(50024539, '特色小吃', 2, 50024480, 2, ',50024451,50024480,50024539,', 0),
(50024540, '新鲜水果', 0, 50024481, 2, ',50024451,50024481,50024540,', 0),
(50024541, '水果拼盘', 1, 50024481, 2, ',50024451,50024481,50024541,', 0),
(50024542, '水果篮', 2, 50024481, 2, ',50024451,50024481,50024542,', 0),
(350203, '电动牙刷', 0, 50024626, 2, ',50002768,50024626,350203,', 0),
(50011883, '牙刷头', 5, 50024626, 2, ',50002768,50024626,50011883,', 0),
(50008385, '牙齿美白仪', 15, 50024626, 2, ',50002768,50024626,50008385,', 0),
(50008376, '冲牙器', 16, 50024626, 2, ',50002768,50024626,50008376,', 0),
(50024627, '其它口腔治疗设备', 17, 50024626, 2, ',50002768,50024626,50024627,', 0),
(50012682, '素描/素写本', 0, 50024641, 2, ',50018004,50024641,50012682,', 0),
(50012683, '儿童填色本', 10, 50024641, 2, ',50018004,50024641,50012683,', 0),
(50012724, '水彩笔', 10, 50024641, 2, ',50018004,50024641,50012724,', 0),
(50005918, '镇纸', 11, 50024641, 2, ',50018004,50024641,50005918,', 0),
(50011917, '画板/画架', 12, 50024641, 2, ',50018004,50024641,50011917,', 0),
(50012688, '书法用纸', 15, 50024641, 2, ',50018004,50024641,50012688,', 0),
(50012730, '勾线笔', 15, 50024641, 2, ',50018004,50024641,50012730,', 0),
(50012731, '水粉/水彩/油画专用笔', 16, 50024641, 2, ',50018004,50024641,50012731,', 0),
(50012732, '蜡笔', 17, 50024641, 2, ',50018004,50024641,50012732,', 0),
(50012733, '油画棒', 18, 50024641, 2, ',50018004,50024641,50012733,', 0),
(50012735, '毛笔1', 20, 50024641, 2, ',50018004,50024641,50012735,', 1),
(50014225, '色卡', 23, 50024641, 2, ',50018004,50024641,50014225,', 0),
(50012701, '绘图/白图纸', 33, 50024641, 2, ',50018004,50024641,50012701,', 0),
(50012706, '描图/硫酸纸', 38, 50024641, 2, ',50018004,50024641,50012706,', 0),
(50013216, '其它', 66, 50024641, 2, ',50018004,50024641,50013216,', 0),
(50022398, '文房四宝', 137, 50024641, 2, ',50018004,50024641,50022398,', 0),
(50024658, '毛笔', 138, 50024641, 2, ',50018004,50024641,50024658,', 0),
(50024706, '炒饭/拌饭', 0, 50024705, 2, ',50024612,50024705,50024706,', 0),
(50024707, '铁板饭/盖浇饭', 1, 50024705, 2, ',50024612,50024705,50024707,', 0),
(50024708, '粥', 2, 50024705, 2, ',50024612,50024705,50024708,', 0),
(50024709, '米饭', 3, 50024705, 2, ',50024612,50024705,50024709,', 0),
(50024711, '汤面/炒面/拌面', 0, 50024710, 2, ',50024612,50024710,50024711,', 0),
(50024712, '米线/河粉', 1, 50024710, 2, ',50024612,50024710,50024712,', 0),
(50024713, '水饺/煎饺/馄饨', 2, 50024710, 2, ',50024612,50024710,50024713,', 0),
(50024714, '馒头/包子/汤包/煎包', 3, 50024710, 2, ',50024612,50024710,50024714,', 0),
(50024715, '葱油饼/麦饼/饼', 4, 50024710, 2, ',50024612,50024710,50024715,', 0),
(50024716, '其他面食', 5, 50024710, 2, ',50024612,50024710,50024716,', 0),
(50024718, '简餐', 0, 50024717, 2, ',50024612,50024717,50024718,', 0),
(50024719, '商务套餐', 1, 50024717, 2, ',50024612,50024717,50024719,', 0),
(50024720, '系列套餐', 2, 50024717, 2, ',50024612,50024717,50024720,', 0),
(50024721, '儿童套餐', 3, 50024717, 2, ',50024612,50024717,50024721,', 0),
(50024722, '家庭套餐', 4, 50024717, 2, ',50024612,50024717,50024722,', 0),
(50024853, '内墙乳胶漆', 0, 50024852, 2, ',27,50024852,50024853,', 1),
(50024854, '外墙乳胶漆', 1, 50024852, 2, ',27,50024852,50024854,', 1),
(50022310, '艺术涂料', 9, 50024852, 2, ',27,50024852,50022310,', 0),
(50006236, '竹炭包/炭盒', 0, 50003948, 2, ',21,50003948,50006236,', 0),
(50021903, '工艺壁画', 1, 50020839, 2, ',50020808,50020839,50021903,', 0),
(150708, '手机座', 3, 1507, 3, ',50008090,50024094,1507,150708,', 0),
(150706, '手机贴纸', 12, 1507, 3, ',50008090,50024094,1507,150706,', 0),
(150705, '其它手机饰品', 30, 1507, 3, ',50008090,50024094,1507,150705,', 0),
(50003509, '上衣', 1, 1636, 3, ',16,50008906,1636,50003509,', 0),
(50003510, '裤子', 2, 1636, 3, ',16,50008906,1636,50003510,', 0),
(50003511, '裙子', 3, 1636, 3, ',16,50008906,1636,50003511,', 0),
(203301, 'Cosplay女装', 1, 2033, 3, ',25,50015994,2033,203301,', 0),
(203302, 'Cosplay男装', 2, 2033, 3, ',25,50015994,2033,203302,', 0),
(203304, 'Cosplay配件饰品', 3, 2033, 3, ',25,50015994,2033,203304,', 0),
(50005026, '布贴', 1, 2101, 3, ',50008163,50017143,2101,50005026,', 0),
(50017234, '珠子/钻饰/花朵等配饰', 2, 2101, 3, ',50008163,50017143,2101,50017234,', 0),
(50005030, '拉链', 3, 2101, 3, ',50008163,50017143,2101,50005030,', 0),
(50017233, '纽扣', 4, 2101, 3, ',50008163,50017143,2101,50017233,', 0),
(50005027, '丝带/绸带/布带', 5, 2101, 3, ',50008163,50017143,2101,50005027,', 0),
(50005029, '花边', 7, 2101, 3, ',50008163,50017143,2101,50005029,', 0),
(50005031, '绳子', 9, 2101, 3, ',50008163,50017143,2101,50005031,', 0),
(50017236, '魔术贴/粘扣带', 10, 2101, 3, ',50008163,50017143,2101,50017236,', 0),
(50017235, '松紧带', 11, 2101, 3, ',50008163,50017143,2101,50017235,', 0),
(50005028, '网布', 20, 2101, 3, ',50008163,50017143,2101,50005028,', 0),
(50005035, '边角料', 21, 2101, 3, ',50008163,50017143,2101,50005035,', 0),
(50005034, '门帘布料', 60, 2101, 3, ',50008163,50017143,2101,50005034,', 0),
(210107, '其它', 61, 2101, 3, ',50008163,50017143,2101,210107,', 0),
(50006478, '音响脚架/机架', 1, 121705, 3, ',50011972,50011866,121705,50006478,', 0),
(50006479, '电容', 2, 121705, 3, ',50011972,50011866,121705,50006479,', 0),
(50006480, '电阻', 3, 121705, 3, ',50011972,50011866,121705,50006480,', 0),
(50006481, '端子/插头/插座', 5, 121705, 3, ',50011972,50011866,121705,50006481,', 0),
(50006484, '喇叭单元/分频器', 6, 121705, 3, ',50011972,50011866,121705,50006484,', 0),
(50006482, '遥控', 7, 121705, 3, ',50011972,50011866,121705,50006482,', 0),
(50006483, '电子管', 8, 121705, 3, ',50011972,50011866,121705,50006483,', 0),
(50006485, '电源滤波器', 9, 121705, 3, ',50011972,50011866,121705,50006485,', 0),
(50006486, '音调板', 10, 121705, 3, ',50011972,50011866,121705,50006486,', 0),
(50006487, '激光头', 11, 121705, 3, ',50011972,50011866,121705,50006487,', 0),
(50006488, '线控', 12, 121705, 3, ',50011972,50011866,121705,50006488,', 0),
(50006489, '功放板', 13, 121705, 3, ',50011972,50011866,121705,50006489,', 0),
(50006491, '变压器', 15, 121705, 3, ',50011972,50011866,121705,50006491,', 0),
(50006492, '机箱', 16, 121705, 3, ',50011972,50011866,121705,50006492,', 0),
(50006493, '环绕架', 17, 121705, 3, ',50011972,50011866,121705,50006493,', 0),
(50006494, '接线柱', 18, 121705, 3, ',50011972,50011866,121705,50006494,', 0),
(50008109, '舞台灯光', 19, 121705, 3, ',50011972,50011866,121705,50008109,', 0),
(50008110, '电源（舞台）', 20, 121705, 3, ',50011972,50011866,121705,50008110,', 0),
(50010568, '支架', 21, 121705, 3, ',50011972,50011866,121705,50010568,', 0),
(50006495, '其他HIFI/音响配件', 22, 121705, 3, ',50011972,50011866,121705,50006495,', 0),
(50004431, '全套厨房刀具', 2, 215205, 3, ',50016349,50010101,215205,50004431,', 0),
(50004432, '菜刀', 3, 215205, 3, ',50016349,50010101,215205,50004432,', 0),
(50006774, '水果削皮器', 4, 215205, 3, ',50016349,50010101,215205,50006774,', 0),
(50004433, '蔬果刨丝器/瓜果刀', 5, 215205, 3, ',50016349,50010101,215205,50004433,', 0),
(50006678, '厨房雕刻刀', 6, 215205, 3, ',50016349,50010101,215205,50006678,', 0),
(50006945, '鱼鳞刨', 9, 215205, 3, ',50016349,50010101,215205,50006945,', 0),
(50004434, '其它', 12, 215205, 3, ',50016349,50010101,215205,50004434,', 0),
(50022399, '斩骨刀', 13, 215205, 3, ',50016349,50010101,215205,50022399,', 0),
(50022401, '冷冻调理刀', 14, 215205, 3, ',50016349,50010101,215205,50022401,', 0),
(50022409, '面包刀', 17, 215205, 3, ',50016349,50010101,215205,50022409,', 0),
(50022411, '多功能刀', 18, 215205, 3, ',50016349,50010101,215205,50022411,', 0),
(50022414, '特殊用途刀', 19, 215205, 3, ',50016349,50010101,215205,50022414,', 0),
(50006932, 'SD/Q版', 1, 50002490, 3, ',25,50016058,50002490,50006932,', 0),
(50011974, 'FG初级版', 2, 50002490, 3, ',25,50016058,50002490,50011974,', 0),
(50006918, 'PG版', 3, 50002490, 3, ',25,50016058,50002490,50006918,', 0),
(50006919, 'MG版', 4, 50002490, 3, ',25,50016058,50002490,50006919,', 0),
(50006929, 'HGUC版', 5, 50002490, 3, ',25,50016058,50002490,50006929,', 0),
(50003618, 'TV/HG版', 6, 50002490, 3, ',25,50016058,50002490,50003618,', 0),
(50006931, 'EX版', 7, 50002490, 3, ',25,50016058,50002490,50006931,', 0),
(50006940, 'HY2M版', 9, 50002490, 3, ',25,50016058,50002490,50006940,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50026090, 'RG版', 10, 50002490, 3, ',25,50016058,50002490,50026090,', 0),
(50006933, 'FIX系列', 11, 50002490, 3, ',25,50016058,50002490,50006933,', 0),
(50006934, 'MIA系列', 12, 50002490, 3, ',25,50016058,50002490,50006934,', 0),
(50006935, 'EMIA系列', 13, 50002490, 3, ',25,50016058,50002490,50006935,', 0),
(50006936, 'HCMPRO系列', 14, 50002490, 3, ',25,50016058,50002490,50006936,', 0),
(50012951, 'UCHG系列', 15, 50002490, 3, ',25,50016058,50002490,50012951,', 0),
(50006939, '其它机体', 16, 50002490, 3, ',25,50016058,50002490,50006939,', 0),
(50003619, '高达周边', 17, 50002490, 3, ',25,50016058,50002490,50003619,', 0),
(50005886, '高达零件', 18, 50002490, 3, ',25,50016058,50002490,50005886,', 0),
(50002804, '炒锅', 0, 50002802, 3, ',50016349,50010101,50002802,50002804,', 0),
(50004390, '煎锅/平底锅', 1, 50002802, 3, ',50016349,50010101,50002802,50004390,', 0),
(50002808, '汤锅', 2, 50002802, 3, ',50016349,50010101,50002802,50002808,', 0),
(50002803, '压力锅/高压锅', 3, 50002802, 3, ',50016349,50010101,50002802,50002803,', 0),
(50002807, '蒸锅', 4, 50002802, 3, ',50016349,50010101,50002802,50002807,', 0),
(50011676, '炖锅/炖煲/汤煲', 5, 50002802, 3, ',50016349,50010101,50002802,50011676,', 0),
(50006899, '烧水壶', 6, 50002802, 3, ',50016349,50010101,50002802,50006899,', 0),
(50002805, '砂锅/石锅', 9, 50002802, 3, ',50016349,50010101,50002802,50002805,', 0),
(50005480, '奶锅', 14, 50002802, 3, ',50016349,50010101,50002802,50005480,', 0),
(50011678, '火锅', 38, 50002802, 3, ',50016349,50010101,50002802,50011678,', 0),
(50011677, '汽锅', 39, 50002802, 3, ',50016349,50010101,50002802,50011677,', 0),
(215204, '其它', 41, 50002802, 3, ',50016349,50010101,50002802,215204,', 0),
(50022375, '锅组套装', 42, 50002802, 3, ',50016349,50010101,50002802,50022375,', 0),
(50018824, 'PCB电路板/印刷线路板', 10, 50002918, 3, ',50008090,50024099,50002918,50018824,', 0),
(50018817, '保险元器件', 11, 50002918, 3, ',50008090,50024099,50002918,50018817,', 0),
(50018891, '变频器', 12, 50002918, 3, ',50008090,50024099,50002918,50018891,', 0),
(50018822, '变压器', 13, 50002918, 3, ',50008090,50024099,50002918,50018822,', 0),
(50015940, '传感器', 14, 50002918, 3, ',50008090,50024099,50002918,50015940,', 0),
(50018893, '磁性元器件', 15, 50002918, 3, ',50008090,50024099,50002918,50018893,', 0),
(50018816, '电感器', 16, 50002918, 3, ',50008090,50024099,50002918,50018816,', 0),
(50006526, '电容器', 17, 50002918, 3, ',50008090,50024099,50002918,50006526,', 0),
(50002927, '电声器件/扬声器', 18, 50002918, 3, ',50008090,50024099,50002918,50002927,', 0),
(50006527, '电位器', 19, 50002918, 3, ',50008090,50024099,50002918,50006527,', 0),
(50018892, '电子专用材料', 20, 50002918, 3, ',50008090,50024099,50002918,50018892,', 0),
(50006525, '电阻器', 21, 50002918, 3, ',50008090,50024099,50002918,50006525,', 0),
(50006524, '继电器', 22, 50002918, 3, ',50008090,50024099,50002918,50006524,', 0),
(50018821, '开关元件', 23, 50002918, 3, ',50008090,50024099,50002918,50018821,', 0),
(50018820, '连接器', 24, 50002918, 3, ',50008090,50024099,50002918,50018820,', 0),
(50018818, '频率元件', 25, 50002918, 3, ',50008090,50024099,50002918,50018818,', 0),
(50018826, '显示器件', 26, 50002918, 3, ',50008090,50024099,50002918,50018826,', 0),
(50023274, '线圈', 27, 50002918, 3, ',50008090,50024099,50002918,50023274,', 0),
(50023275, '整流器件', 28, 50002918, 3, ',50008090,50024099,50002918,50023275,', 0),
(50002928, '其它元器件', 30, 50002918, 3, ',50008090,50024099,50002918,50002928,', 0),
(50005872, '战斗机体', 0, 50003027, 3, ',25,50016058,50003027,50005872,', 0),
(50005873, '手办/人偶', 0, 50003027, 3, ',25,50016058,50003027,50005873,', 0),
(50005852, '体育', 0, 50005847, 3, ',25,50024128,50005847,50005852,', 0),
(50005848, '再生侠', 0, 50005847, 3, ',25,50024128,50005847,50005848,', 0),
(50005856, '军事', 0, 50005847, 3, ',25,50024128,50005847,50005856,', 0),
(50005850, '怪物', 0, 50005847, 3, ',25,50024128,50005847,50005850,', 0),
(50005851, '扭曲', 0, 50005847, 3, ',25,50024128,50005847,50005851,', 0),
(50005854, '游戏动画', 0, 50005847, 3, ',25,50024128,50005847,50005854,', 0),
(50005849, '电影电视', 0, 50005847, 3, ',25,50024128,50005847,50005849,', 0),
(50005853, '音乐', 0, 50005847, 3, ',25,50024128,50005847,50005853,', 0),
(50005855, '龙系列', 0, 50005847, 3, ',25,50024128,50005847,50005855,', 0),
(50005870, '周边', 0, 50005868, 3, ',25,50016058,50005868,50005870,', 0),
(50005869, '机体', 0, 50005868, 3, ',25,50016058,50005868,50005869,', 0),
(50010340, 'CD和DVD储物家具', 2, 50006282, 3, ',50008164,50006281,50006282,50010340,', 0),
(50010339, '搁架单元', 2, 50006282, 3, ',50008164,50006281,50006282,50010339,', 0),
(50010342, '文件柜', 2, 50006282, 3, ',50008164,50006281,50006282,50010342,', 0),
(50006299, '书柜', 3, 50006282, 3, ',50008164,50006281,50006282,50006299,', 0),
(50006316, '电视柜', 20, 50006282, 3, ',50008164,50006281,50006282,50006316,', 0),
(50011360, '抽屉柜', 22, 50006282, 3, ',50008164,50006281,50006282,50011360,', 0),
(50011361, '连壁搁板', 23, 50006282, 3, ',50008164,50006281,50006282,50011361,', 0),
(50011363, '重型储物系列', 25, 50006282, 3, ',50008164,50006281,50006282,50011363,', 0),
(50011364, '橱柜和餐具柜', 26, 50006282, 3, ',50008164,50006281,50006282,50011364,', 0),
(50006318, '写字台', 1, 50006283, 3, ',50008164,50006281,50006283,50006318,', 0),
(50006319, '会议桌', 2, 50006283, 3, ',50008164,50006281,50006283,50006319,', 0),
(50006320, '抽屉柜', 3, 50006283, 3, ',50008164,50006281,50006283,50006320,', 0),
(50006321, '可移动抽屉柜', 4, 50006283, 3, ',50008164,50006281,50006283,50006321,', 0),
(50006322, '储物组合', 5, 50006283, 3, ',50008164,50006281,50006283,50006322,', 0),
(50006323, '转椅', 6, 50006283, 3, ',50008164,50006281,50006283,50006323,', 0),
(50006324, '待客椅子', 7, 50006283, 3, ',50008164,50006281,50006283,50006324,', 0),
(50006325, '椅子', 8, 50006283, 3, ',50008164,50006281,50006283,50006325,', 0),
(50006326, '办公用品', 9, 50006283, 3, ',50008164,50006281,50006283,50006326,', 0),
(50006327, '杂志盒', 10, 50006283, 3, ',50008164,50006281,50006283,50006327,', 0),
(50006328, '布告板', 11, 50006283, 3, ',50008164,50006281,50006283,50006328,', 0),
(50006329, '废纸篓', 12, 50006283, 3, ',50008164,50006281,50006283,50006329,', 0),
(50006330, '桌面', 17, 50006283, 3, ',50008164,50006281,50006283,50006330,', 0),
(50006331, '支腿', 18, 50006283, 3, ',50008164,50006281,50006283,50006331,', 0),
(50006332, '电脑桌', 19, 50006283, 3, ',50008164,50006281,50006283,50006332,', 0),
(50006333, '工作站', 20, 50006283, 3, ',50008164,50006281,50006283,50006333,', 0),
(50006334, '转角式工作站', 21, 50006283, 3, ',50008164,50006281,50006283,50006334,', 0),
(50006335, '壁式储物产品', 1, 50006284, 3, ',50008164,50006281,50006284,50006335,', 0),
(50006336, '内置件', 2, 50006284, 3, ',50008164,50006281,50006284,50006336,', 0),
(50006337, '储物用品', 3, 50006284, 3, ',50008164,50006281,50006284,50006337,', 0),
(50006338, '厨房纺织品', 4, 50006284, 3, ',50008164,50006281,50006284,50006338,', 0),
(50006339, '茶巾', 5, 50006284, 3, ',50008164,50006281,50006284,50006339,', 0),
(50006340, '厨房灯具', 6, 50006284, 3, ',50008164,50006281,50006284,50006340,', 0),
(50006341, '橱柜照明', 7, 50006284, 3, ',50008164,50006281,50006284,50006341,', 0),
(50006342, '底柜', 8, 50006284, 3, ',50008164,50006281,50006284,50006342,', 0),
(50006343, '壁柜', 9, 50006284, 3, ',50008164,50006281,50006284,50006343,', 0),
(50006344, '高柜', 10, 50006284, 3, ',50008164,50006281,50006284,50006344,', 0),
(50006345, '嵌入式厨柜', 11, 50006284, 3, ',50008164,50006281,50006284,50006345,', 0),
(50006346, '特制厨柜和搁板', 12, 50006284, 3, ',50008164,50006281,50006284,50006346,', 0),
(50006347, '装饰件', 13, 50006284, 3, ',50008164,50006281,50006284,50006347,', 0),
(50006348, '支腿与底座', 14, 50006284, 3, ',50008164,50006281,50006284,50006348,', 0),
(50006349, '把手和拉手', 15, 50006284, 3, ',50008164,50006281,50006284,50006349,', 0),
(50006350, '台车和餐桌', 16, 50006284, 3, ',50008164,50006281,50006284,50006350,', 0),
(50006351, '上菜桌', 17, 50006284, 3, ',50008164,50006281,50006284,50006351,', 0),
(50006352, '实木操作台', 18, 50006284, 3, ',50008164,50006281,50006284,50006352,', 0),
(50006353, '层压操作台', 19, 50006284, 3, ',50008164,50006281,50006284,50006353,', 0),
(50006354, '洗涤槽', 20, 50006284, 3, ',50008164,50006281,50006284,50006354,', 0),
(50006355, '混合型水龙头', 21, 50006284, 3, ',50008164,50006281,50006284,50006355,', 0),
(50006356, '金属件和家具护理用品', 1, 50006285, 3, ',50008164,50006281,50006285,50006356,', 0),
(50006357, '脚轮', 2, 50006285, 3, ',50008164,50006281,50006285,50006357,', 0),
(50006371, '床品套件装', 1, 50006286, 3, ',50008164,50006281,50006286,50006371,', 0),
(50010348, '床罩/床单', 2, 50006286, 3, ',50008164,50006281,50006286,50010348,', 0),
(50006369, '被子', 3, 50006286, 3, ',50008164,50006281,50006286,50006369,', 0),
(50006370, '枕头/靠垫芯', 4, 50006286, 3, ',50008164,50006281,50006286,50006370,', 0),
(50006372, '靠垫套/枕套', 5, 50006286, 3, ',50008164,50006281,50006286,50006372,', 0),
(50006399, '靠垫(含芯)', 6, 50006286, 3, ',50008164,50006281,50006286,50006399,', 0),
(50010349, '座垫/椅垫', 7, 50006286, 3, ',50008164,50006281,50006286,50010349,', 0),
(50006373, '其它', 8, 50006286, 3, ',50008164,50006281,50006286,50006373,', 0),
(50006451, '布料/缝纫用品', 10, 50006286, 3, ',50008164,50006281,50006286,50006451,', 0),
(50006398, '脚凳和座垫', 11, 50006286, 3, ',50008164,50006281,50006286,50006398,', 0),
(50006375, '单人床架', 10, 50006287, 3, ',50008164,50006281,50006287,50006375,', 0),
(50006376, '双人床架', 11, 50006287, 3, ',50008164,50006281,50006287,50006376,', 0),
(50006377, '双层床和高架床', 12, 50006287, 3, ',50008164,50006281,50006287,50006377,', 0),
(50006378, '床边桌', 13, 50006287, 3, ',50008164,50006281,50006287,50006378,', 0),
(50006379, '床垫', 14, 50006287, 3, ',50008164,50006281,50006287,50006379,', 0),
(50006381, '凳子', 1, 50006288, 3, ',50008164,50006281,50006288,50006381,', 0),
(50006382, '吧台凳', 2, 50006288, 3, ',50008164,50006281,50006288,50006382,', 0),
(50006396, '扶手椅', 2, 50006288, 3, ',50008164,50006281,50006288,50006396,', 0),
(50006383, '咖啡桌', 3, 50006288, 3, ',50008164,50006281,50006288,50006383,', 0),
(50006384, '边桌', 4, 50006288, 3, ',50008164,50006281,50006288,50006384,', 0),
(50006385, '餐桌', 5, 50006288, 3, ',50008164,50006281,50006288,50006385,', 0),
(50006386, '台车和餐桌', 6, 50006288, 3, ',50008164,50006281,50006288,50006386,', 0),
(50006387, '桌面与桌腿', 7, 50006288, 3, ',50008164,50006281,50006288,50006387,', 0),
(50006388, '酒吧桌', 8, 50006288, 3, ',50008164,50006281,50006288,50006388,', 0),
(50006390, '壁式桌子', 9, 50006288, 3, ',50008164,50006281,50006288,50006390,', 0),
(50006392, '折叠式椅子和叠放式椅子', 11, 50006288, 3, ',50008164,50006281,50006288,50006392,', 0),
(50006389, '其他', 12, 50006288, 3, ',50008164,50006281,50006288,50006389,', 0),
(50006400, '壁柜', 1, 50006290, 3, ',50008164,50006281,50006290,50006400,', 0),
(50006401, '水池和水龙头', 2, 50006290, 3, ',50008164,50006281,50006290,50006401,', 0),
(50006402, '浴巾', 3, 50006290, 3, ',50008164,50006281,50006290,50006402,', 0),
(50006403, '浴帘和浴帘杆', 4, 50006290, 3, ',50008164,50006281,50006290,50006403,', 0),
(50006404, '浴室储物件', 5, 50006290, 3, ',50008164,50006281,50006290,50006404,', 0),
(50006405, '浴室防滑垫', 6, 50006290, 3, ',50008164,50006281,50006290,50006405,', 0),
(50006406, '浴室家具', 7, 50006290, 3, ',50008164,50006281,50006290,50006406,', 0),
(50006407, '浴室镜', 8, 50006290, 3, ',50008164,50006281,50006290,50006407,', 0),
(50006408, '浴室用品', 9, 50006290, 3, ',50008164,50006281,50006290,50006408,', 0),
(50006409, '浴室照明', 11, 50006290, 3, ',50008164,50006281,50006290,50006409,', 0),
(50006412, '刀', 1, 50006291, 3, ',50008164,50006281,50006291,50006412,', 0),
(50006413, '砧板', 2, 50006291, 3, ',50008164,50006281,50006291,50006413,', 0),
(50006415, '茶巾', 4, 50006291, 3, ',50008164,50006281,50006291,50006415,', 0),
(50006416, '搅拌碗和壶', 5, 50006291, 3, ',50008164,50006281,50006291,50006416,', 0),
(50006417, '厨房用品', 6, 50006291, 3, ',50008164,50006281,50006291,50006417,', 0),
(50006420, '炊具', 9, 50006291, 3, ',50008164,50006281,50006291,50006420,', 0),
(50006419, '餐具滤水架和厨房用品', 9, 50006291, 3, ',50008164,50006281,50006291,50006419,', 0),
(50006421, '锅架', 10, 50006291, 3, ',50008164,50006281,50006291,50006421,', 0),
(50006422, '烤箱器皿和烤盘', 11, 50006291, 3, ',50008164,50006281,50006291,50006422,', 0),
(50006423, '瓶子、罐子和食品保鲜盒', 12, 50006291, 3, ',50008164,50006281,50006291,50006423,', 0),
(50006424, '用于调味品', 13, 50006291, 3, ',50008164,50006281,50006291,50006424,', 0),
(50006425, '酒架', 14, 50006291, 3, ',50008164,50006281,50006291,50006425,', 0),
(50006428, '茶壶和咖啡壶', 3, 50006293, 3, ',50008164,50006281,50006293,50006428,', 0),
(50006429, '缸子和杯子', 4, 50006293, 3, ',50008164,50006281,50006293,50006429,', 0),
(50006430, '咖啡具和茶具', 5, 50006293, 3, ',50008164,50006281,50006293,50006430,', 0),
(50006431, '保温瓶', 6, 50006293, 3, ',50008164,50006281,50006293,50006431,', 0),
(50006432, '玻璃杯', 7, 50006293, 3, ',50008164,50006281,50006293,50006432,', 0),
(50006433, '瓶子和玻璃水瓶', 8, 50006293, 3, ',50008164,50006281,50006293,50006433,', 0),
(50006434, '宜家餐桌用品套装', 9, 50006293, 3, ',50008164,50006281,50006293,50006434,', 0),
(50006435, '餐用纺织品', 10, 50006293, 3, ',50008164,50006281,50006293,50006435,', 0),
(50006436, '椅子垫', 11, 50006293, 3, ',50008164,50006281,50006293,50006436,', 0),
(50006438, '盘子', 12, 50006293, 3, ',50008164,50006281,50006293,50006438,', 0),
(50006437, '餐巾', 12, 50006293, 3, ',50008164,50006281,50006293,50006437,', 0),
(50006439, '碗', 14, 50006293, 3, ',50008164,50006281,50006293,50006439,', 0),
(50006440, '菜碟', 15, 50006293, 3, ',50008164,50006281,50006293,50006440,', 0),
(50006441, '金属餐具', 16, 50006293, 3, ',50008164,50006281,50006293,50006441,', 0),
(50006442, '分菜金属餐具', 18, 50006293, 3, ',50008164,50006281,50006293,50006442,', 0),
(50006443, '餐巾纸', 19, 50006293, 3, ',50008164,50006281,50006293,50006443,', 0),
(50006444, '餐巾环和餐巾圈', 20, 50006293, 3, ',50008164,50006281,50006293,50006444,', 0),
(50006445, '桌垫和杯垫', 21, 50006293, 3, ',50008164,50006281,50006293,50006445,', 0),
(50006446, '托盘和面包篮', 22, 50006293, 3, ',50008164,50006281,50006293,50006446,', 0),
(50006447, '餐具系列', 23, 50006293, 3, ',50008164,50006281,50006293,50006447,', 0),
(50006448, '其它餐具', 24, 50006293, 3, ',50008164,50006281,50006293,50006448,', 0),
(50006450, '地毯', 2, 50006294, 3, ',50008164,50006281,50006294,50006450,', 0),
(50006452, '窗帘', 3, 50006294, 3, ',50008164,50006281,50006294,50006452,', 0),
(50006453, '百叶窗帘', 4, 50006294, 3, ',50008164,50006281,50006294,50006453,', 0),
(50010350, '卷帘', 5, 50006294, 3, ',50008164,50006281,50006294,50010350,', 0),
(50010351, '隔断帘', 6, 50006294, 3, ',50008164,50006281,50006294,50010351,', 0),
(50006454, '窗帘杆和窗帘用品', 7, 50006294, 3, ',50008164,50006281,50006294,50006454,', 0),
(50006477, '衣柜', 1, 50006295, 3, ',50008164,50006281,50006295,50006477,', 0),
(50010345, '鞋柜', 3, 50006295, 3, ',50008164,50006281,50006295,50010345,', 0),
(50011371, '鞋架和衣帽架', 13, 50006295, 3, ',50008164,50006281,50006295,50011371,', 0),
(50011372, '洗衣和衣服护理', 14, 50006295, 3, ',50008164,50006281,50006295,50011372,', 0),
(50011552, '衣服储物系列', 15, 50006295, 3, ',50008164,50006281,50006295,50011552,', 0),
(50011553, '衣服和鞋类储藏件', 16, 50006295, 3, ',50008164,50006281,50006295,50011553,', 0),
(50011554, '梳妆台', 17, 50006295, 3, ',50008164,50006281,50006295,50011554,', 0),
(50010353, '摆件装饰', 0, 50006296, 3, ',50008164,50006281,50006296,50010353,', 0),
(50010354, '画框架', 0, 50006296, 3, ',50008164,50006281,50006296,50010354,', 0),
(50010352, '蜡烛/蜡烛台', 0, 50006296, 3, ',50008164,50006281,50006296,50010352,', 0),
(50006456, '图片', 1, 50006296, 3, ',50008164,50006281,50006296,50006456,', 0),
(50006457, '画框', 2, 50006296, 3, ',50008164,50006281,50006296,50006457,', 0),
(50006458, '装框艺术品', 3, 50006296, 3, ',50008164,50006281,50006296,50006458,', 0),
(50006459, '时钟', 4, 50006296, 3, ',50008164,50006281,50006296,50006459,', 0),
(50006460, '闹钟', 5, 50006296, 3, ',50008164,50006281,50006296,50006460,', 0),
(50006462, '花瓶', 6, 50006296, 3, ',50008164,50006281,50006296,50006462,', 0),
(50006463, '礼品包装', 7, 50006296, 3, ',50008164,50006281,50006296,50006463,', 0),
(50006464, '花盆', 8, 50006296, 3, ',50008164,50006281,50006296,50006464,', 0),
(50006465, '花房用品', 9, 50006296, 3, ',50008164,50006281,50006296,50006465,', 0),
(50006466, '人造花', 10, 50006296, 3, ',50008164,50006281,50006296,50006466,', 0),
(50006467, '蜡烛', 11, 50006296, 3, ',50008164,50006281,50006296,50006467,', 0),
(50006468, '芳香蜡烛', 12, 50006296, 3, ',50008164,50006281,50006296,50006468,', 0),
(50006469, '块状蜡烛', 13, 50006296, 3, ',50008164,50006281,50006296,50006469,', 0),
(50006470, '蜡烛台', 14, 50006296, 3, ',50008164,50006281,50006296,50006470,', 0),
(50006471, '装饰用品', 15, 50006296, 3, ',50008164,50006281,50006296,50006471,', 0),
(50006473, '儿童装饰用品', 17, 50006296, 3, ',50008164,50006281,50006296,50006473,', 0),
(50006474, '镜子', 19, 50006296, 3, ',50008164,50006281,50006296,50006474,', 0),
(50006363, '鞋柜', 6, 50006297, 3, ',50008164,50006281,50006297,50006363,', 0),
(50006455, '门厅系列', 8, 50006297, 3, ',50008164,50006281,50006297,50006455,', 0),
(50006365, '鞋架', 8, 50006297, 3, ',50008164,50006281,50006297,50006365,', 0),
(50006687, '指甲钳', 1, 50006685, 3, ',50016348,50009146,50006685,50006687,', 0),
(50006684, '修甲剪刀', 3, 50006685, 3, ',50016348,50009146,50006685,50006684,', 0),
(50009205, '美甲/修甲套装', 5, 50006685, 3, ',50016348,50009146,50006685,50009205,', 0),
(50000570, '其它', 20, 50006685, 3, ',50016348,50009146,50006685,50000570,', 0),
(50009366, '带放大镜指甲钳', 25, 50006685, 3, ',50016348,50009146,50006685,50009366,', 0),
(50006763, '切蛋器', 1, 50006762, 3, ',50016349,50008281,50006762,50006763,', 0),
(50006761, '蛋清分离器', 3, 50006762, 3, ',50016349,50008281,50006762,50006761,', 0),
(50006944, '其它', 10, 50006762, 3, ',50016349,50008281,50006762,50006944,', 0),
(50006752, '其它容器', 50, 50006762, 3, ',50016349,50008281,50006762,50006752,', 0),
(50004401, '打蛋器', 58, 50006762, 3, ',50016349,50008281,50006762,50004401,', 0),
(50006776, '全套勺铲', 1, 50006775, 3, ',50016349,50010101,50006775,50006776,', 0),
(50006785, '木铲', 2, 50006775, 3, ',50016349,50010101,50006775,50006785,', 0),
(50006777, '汤勺', 3, 50006775, 3, ',50016349,50010101,50006775,50006777,', 0),
(50008600, '锅铲', 3, 50006775, 3, ',50016349,50010101,50006775,50008600,', 0),
(50006778, '漏勺', 4, 50006775, 3, ',50016349,50010101,50006775,50006778,', 0),
(50006784, '饭勺', 4, 50006775, 3, ',50016349,50010101,50006775,50006784,', 0),
(50006781, '其它', 22, 50006775, 3, ',50016349,50010101,50006775,50006781,', 0),
(50022519, '煎铲', 23, 50006775, 3, ',50016349,50010101,50006775,50022519,', 0),
(50006947, '怀炉', 1, 50006966, 3, ',21,50012512,50006966,50006947,', 0),
(50006967, '怀炉专用油', 2, 50006966, 3, ',21,50012512,50006966,50006967,', 0),
(50006968, '怀炉套', 3, 50006966, 3, ',21,50012512,50006966,50006968,', 0),
(50009121, '其它线类', 0, 50008179, 3, ',50008090,50024099,50008179,50009121,', 0),
(50008182, '延长线', 0, 50008179, 3, ',50008090,50024099,50008179,50008182,', 0),
(50008184, '显示器信号线', 0, 50008179, 3, ',50008090,50024099,50008179,50008184,', 0),
(50024139, '水晶头', 0, 50008179, 3, ',50008090,50024099,50008179,50024139,', 0),
(50008183, '转接线', 0, 50008179, 3, ',50008090,50024099,50008179,50008183,', 0),
(50008181, '连接线', 0, 50008179, 3, ',50008090,50024099,50008179,50008181,', 0),
(50010259, '转接头/转接线', 14, 50008179, 3, ',50008090,50024099,50008179,50010259,', 0),
(50016445, '1394线', 50, 50008179, 3, ',50008090,50024099,50008179,50016445,', 0),
(50003802, '网线', 66, 50008179, 3, ',50008090,50024099,50008179,50003802,', 0),
(50006475, '儿童储物产品', 1, 50008439, 3, ',50008164,50006281,50008439,50006475,', 0),
(50006366, '儿童床和床垫', 1, 50008439, 3, ',50008164,50006281,50008439,50006366,', 0),
(50006449, '儿童纺织品', 1, 50008439, 3, ',50008164,50006281,50008439,50006449,', 0),
(50006427, '儿童餐具', 1, 50008439, 3, ',50008164,50006281,50008439,50006427,', 0),
(50008441, '玩具', 4, 50008439, 3, ',50008164,50006281,50008439,50008441,', 0),
(50006418, '儿童家具', 7, 50008439, 3, ',50008164,50006281,50008439,50006418,', 0),
(50008443, '台灯', 1, 50008442, 3, ',50008164,50006281,50008442,50008443,', 0),
(50008444, '壁灯', 2, 50008442, 3, ',50008164,50006281,50008442,50008444,', 0),
(50008445, '吸顶灯', 3, 50008442, 3, ',50008164,50006281,50008442,50008445,', 0),
(50008446, '落地灯', 4, 50008442, 3, ',50008164,50006281,50008442,50008446,', 0),
(50008447, '灯罩/灯座/软线', 6, 50008442, 3, ',50008164,50006281,50008442,50008447,', 0),
(50008448, '照明配件', 7, 50008442, 3, ',50008164,50006281,50008442,50008448,', 0),
(50006414, '其他灯具', 8, 50008442, 3, ',50008164,50006281,50008442,50006414,', 0),
(50011445, '家具照明', 10, 50008442, 3, ',50008164,50006281,50008442,50011445,', 0),
(50011551, '电灯泡和附件', 11, 50008442, 3, ',50008164,50006281,50008442,50011551,', 0),
(50009048, '鞋垫', 1, 50009045, 3, ',50010404,50010406,50009045,50009048,', 0),
(50011036, '前掌垫', 2, 50009045, 3, ',50010404,50010406,50009045,50011036,', 0),
(50011037, '增高垫', 3, 50009045, 3, ',50010404,50010406,50009045,50011037,', 0),
(50011039, '后跟贴', 4, 50009045, 3, ',50010404,50010406,50009045,50011039,', 0),
(50011043, '鞋扣', 5, 50009045, 3, ',50010404,50010406,50009045,50011043,', 0),
(50011038, '防滑贴', 6, 50009045, 3, ',50010404,50010406,50009045,50011038,', 0),
(50011040, '鞋撑', 7, 50009045, 3, ',50010404,50010406,50009045,50011040,', 0),
(50009049, '鞋带', 8, 50009045, 3, ',50010404,50010406,50009045,50009049,', 0),
(50011041, '钥匙扣', 1, 50009046, 3, ',50010404,50010406,50009046,50011041,', 0),
(50011042, '包挂件', 2, 50009046, 3, ',50010404,50010406,50009046,50011042,', 0),
(50009050, '拎环', 3, 50009046, 3, ',50010404,50010406,50009046,50009050,', 0),
(50009051, '包带', 4, 50009046, 3, ',50010404,50010406,50009046,50009051,', 0),
(50009052, '其他', 5, 50009046, 3, ',50010404,50010406,50009046,50009052,', 0),
(50002816, '梳子/化妆梳/按摩梳', 1, 50009201, 3, ',50016348,50009146,50009201,50002816,', 0),
(50009203, '镜梳套装', 2, 50009201, 3, ',50016348,50009146,50009201,50009203,', 0),
(50009202, '随身化妆镜', 3, 50009201, 3, ',50016348,50009146,50009201,50009202,', 0),
(50009535, '手提秤/挂秤', 1, 50009534, 3, ',50016349,50008281,50009534,50009535,', 0),
(50009536, '台秤', 2, 50009534, 3, ',50016349,50008281,50009534,50009536,', 0),
(50003767, '其他厨房秤/计量秤', 8, 50009534, 3, ',50016349,50008281,50009534,50003767,', 0),
(50006251, '气吹', 0, 50010018, 3, ',50008090,50024097,50010018,50006251,', 0),
(50006250, '清洁套装', 0, 50010018, 3, ',50008090,50024097,50010018,50006250,', 0),
(50006249, '镜头笔', 0, 50010018, 3, ',50008090,50024097,50010018,50006249,', 0),
(50006252, '镜头纸/镜头布', 0, 50010018, 3, ',50008090,50024097,50010018,50006252,', 0),
(50003324, '清洁液', 2, 50010018, 3, ',50008090,50024097,50010018,50003324,', 0),
(50001817, '其他清洁用品', 7, 50010018, 3, ',50008090,50024097,50010018,50001817,', 0),
(50050604, '毛刷', 8, 50010018, 3, ',50008090,50024097,50010018,50050604,', 0),
(50050605, '高压气罐', 9, 50010018, 3, ',50008090,50024097,50010018,50050605,', 0),
(50050606, 'cmos清洁', 10, 50010018, 3, ',50008090,50024097,50010018,50050606,', 0),
(50050607, '擦屏布', 11, 50010018, 3, ',50008090,50024097,50010018,50050607,', 0),
(50006308, '篮筐', 10, 50010318, 3, ',50008164,50006281,50010318,50006308,', 0),
(50011365, '储物盒和储物篮', 12, 50010318, 3, ',50008164,50006281,50010318,50011365,', 0),
(50011366, '储藏件', 13, 50010318, 3, ',50008164,50006281,50010318,50011366,', 0),
(50011367, '衣服和鞋类储藏件', 14, 50010318, 3, ',50008164,50006281,50010318,50011367,', 0),
(50011368, '洗衣和衣服护理', 15, 50010318, 3, ',50008164,50006281,50010318,50011368,', 0),
(50011369, '厨房储藏件', 16, 50010318, 3, ',50008164,50006281,50010318,50011369,', 0),
(50011370, '浴室储藏件', 17, 50010318, 3, ',50008164,50006281,50010318,50011370,', 0),
(50006395, '布艺沙发', 1, 50010346, 3, ',50008164,50006281,50010346,50006395,', 0),
(50006397, '皮沙发', 2, 50010346, 3, ',50008164,50006281,50010346,50006397,', 0),
(50006062, '隔音耳塞', 31, 50010463, 3, ',50020485,50020487,50010463,50006062,', 0),
(50006054, '打气筒', 35, 50010463, 3, ',50020485,50020487,50010463,50006054,', 0),
(50008305, '静电防护刷', 44, 50010463, 3, ',50020485,50020487,50010463,50008305,', 0),
(50008306, 'IC起拔器', 45, 50010463, 3, ',50020485,50020487,50010463,50008306,', 0),
(50008939, '油漆刷/滚筒', 47, 50010463, 3, ',50020485,50020487,50010463,50008939,', 0),
(50008941, '绝缘布', 48, 50010463, 3, ',50020485,50020487,50010463,50008941,', 0),
(50009805, 'POP广告用品', 49, 50010463, 3, ',50020485,50020487,50010463,50009805,', 0),
(50013661, '热胶枪', 50, 50010463, 3, ',50020485,50020487,50010463,50013661,', 0),
(50013650, '钢丝刷', 51, 50010463, 3, ',50020485,50020487,50010463,50013650,', 0),
(50013649, '粉斗', 52, 50010463, 3, ',50020485,50020487,50010463,50013649,', 0),
(50013663, '其它工具', 53, 50010463, 3, ',50020485,50020487,50010463,50013663,', 0),
(50010616, '骑行服', 0, 50010615, 3, ',50010728,2612,50010615,50010616,', 0),
(50010617, '骑行鞋', 2, 50010615, 3, ',50010728,2612,50010615,50010617,', 0),
(50019302, '骑行袜', 3, 50010615, 3, ',50010728,2612,50010615,50019302,', 0),
(50010619, '骑行眼镜/风镜', 4, 50010615, 3, ',50010728,2612,50010615,50010619,', 0),
(50010621, '自行车包', 5, 50010615, 3, ',50010728,2612,50010615,50010621,', 0),
(50010618, '骑行头盔', 5, 50010615, 3, ',50010728,2612,50010615,50010618,', 0),
(50018775, '自行车手套', 8, 50010615, 3, ',50010728,2612,50010615,50018775,', 0),
(50018776, '自行车头巾', 9, 50010615, 3, ',50010728,2612,50010615,50018776,', 0),
(50018777, '袖/腿套/束管带', 10, 50010615, 3, ',50010728,2612,50010615,50018777,', 0),
(50020176, '防风/尘保暖面罩', 18, 50010615, 3, ',50010728,2612,50010615,50020176,', 0),
(50006359, '洗衣用品', 0, 50011359, 3, ',50008164,50006281,50011359,50006359,', 0),
(50006362, '衣物箱', 1, 50011359, 3, ',50008164,50006281,50011359,50006362,', 0),
(50006476, '抽屉柜', 2, 50011359, 3, ',50008164,50006281,50011359,50006476,', 0),
(50006311, '筐子和袋子', 3, 50011359, 3, ',50008164,50006281,50011359,50006311,', 0),
(50006360, '衣服护理用品', 4, 50011359, 3, ',50008164,50006281,50011359,50006360,', 0),
(50006364, '衣架和衣撑', 5, 50011359, 3, ',50008164,50006281,50011359,50006364,', 0),
(50006361, '大件衣帽架', 6, 50011359, 3, ',50008164,50006281,50011359,50006361,', 0),
(50010322, '遥控器袋', 7, 50011359, 3, ',50008164,50006281,50011359,50010322,', 0),
(50010321, '储物袋/挂袋', 8, 50011359, 3, ',50008164,50006281,50011359,50010321,', 0),
(50006309, '储物盒', 9, 50011359, 3, ',50008164,50006281,50011359,50006309,', 0),
(50006304, '衣服储藏件', 10, 50011359, 3, ',50008164,50006281,50011359,50006304,', 0),
(50010338, 'CD/DVD盒', 11, 50011359, 3, ',50008164,50006281,50011359,50010338,', 0),
(50006300, '橱柜', 12, 50011359, 3, ',50008164,50006281,50011359,50006300,', 0),
(50006302, '餐具柜', 13, 50011359, 3, ',50008164,50006281,50011359,50006302,', 0),
(50006317, '多媒体家具', 14, 50011359, 3, ',50008164,50006281,50011359,50006317,', 0),
(50006315, '书挡', 15, 50011359, 3, ',50008164,50006281,50011359,50006315,', 0),
(50006303, '挂钩', 16, 50011359, 3, ',50008164,50006281,50011359,50006303,', 0),
(50006313, '搁板/架子板', 17, 50011359, 3, ',50008164,50006281,50011359,50006313,', 0),
(50006301, '玻璃门柜', 18, 50011359, 3, ',50008164,50006281,50011359,50006301,', 0),
(50006310, '钥匙柜', 19, 50011359, 3, ',50008164,50006281,50011359,50006310,', 0),
(50006307, '报纸架', 20, 50011359, 3, ',50008164,50006281,50011359,50006307,', 0),
(50006306, '多媒体储物产品', 21, 50011359, 3, ',50008164,50006281,50011359,50006306,', 0),
(50006358, '储物装置', 22, 50011359, 3, ',50008164,50006281,50011359,50006358,', 0),
(50006305, '杂志盒', 24, 50011359, 3, ',50008164,50006281,50011359,50006305,', 0),
(50006314, '托架', 25, 50011359, 3, ',50008164,50006281,50011359,50006314,', 0),
(50011439, '布艺扶手椅', 0, 50011438, 3, ',50008164,50006281,50011438,50011439,', 0),
(50011440, '皮质扶手椅', 1, 50011438, 3, ',50008164,50006281,50011438,50011440,', 0),
(50011442, '藤编扶手椅', 3, 50011438, 3, ',50008164,50006281,50011438,50011442,', 0),
(50011447, '床', 0, 50011446, 3, ',50008164,50006281,50011446,50011447,', 0),
(50011448, '床垫', 1, 50011446, 3, ',50008164,50006281,50011446,50011448,', 0),
(50011449, '环绕床的产品', 2, 50011446, 3, ',50008164,50006281,50011446,50011449,', 0),
(50011478, '床上用品', 2, 50011477, 3, ',50008164,50006281,50011477,50011478,', 0),
(50011479, '被子和枕头', 3, 50011477, 3, ',50008164,50006281,50011477,50011479,', 0),
(50011480, '地毯', 4, 50011477, 3, ',50008164,50006281,50011477,50011480,', 0),
(50011481, '窗帘和百叶窗帘', 5, 50011477, 3, ',50008164,50006281,50011477,50011481,', 0),
(50011482, '布料和缝纫用品', 6, 50011477, 3, ',50008164,50006281,50011477,50011482,', 0),
(50011483, '靠垫和罩单', 7, 50011477, 3, ',50008164,50006281,50011477,50011483,', 0),
(50011484, '浴室纺织品', 8, 50011477, 3, ',50008164,50006281,50011477,50011484,', 0),
(50011485, '厨房和餐厅纺织品', 9, 50011477, 3, ',50008164,50006281,50011477,50011485,', 0),
(50011488, '制作', 0, 50011487, 3, ',50008164,50006281,50011487,50011488,', 0),
(50011489, '食品储藏', 1, 50011487, 3, ',50008164,50006281,50011487,50011489,', 0),
(50011490, '烹饪用品', 2, 50011487, 3, ',50008164,50006281,50011487,50011490,', 0),
(50011491, '桌面装饰', 3, 50011487, 3, ',50008164,50006281,50011487,50011491,', 0),
(50011492, '布菜', 4, 50011487, 3, ',50008164,50006281,50011487,50011492,', 0),
(50011493, '餐饮用品', 5, 50011487, 3, ',50008164,50006281,50011487,50011493,', 0),
(50011494, '咖啡和茶', 6, 50011487, 3, ',50008164,50006281,50011487,50011494,', 0),
(50011495, '洗碗和清洁', 7, 50011487, 3, ',50008164,50006281,50011487,50011495,', 0),
(50011496, '烹饪与餐饮产品基础套装', 8, 50011487, 3, ',50008164,50006281,50011487,50011496,', 0),
(50011498, '五金件', 0, 50011497, 3, ',50008164,50006281,50011497,50011498,', 0),
(50011499, '家具护理产品', 1, 50011497, 3, ',50008164,50006281,50011497,50011499,', 0),
(50011501, '嵌入式厨房', 0, 50011500, 3, ',50008164,50006281,50011500,50011501,', 0),
(50011502, '独立式厨房', 1, 50011500, 3, ',50008164,50006281,50011500,50011502,', 0),
(50011503, '厨房岛和推车', 2, 50011500, 3, ',50008164,50006281,50011500,50011503,', 0),
(50011504, '厨房操作台', 3, 50011500, 3, ',50008164,50006281,50011500,50011504,', 0),
(50011505, '洗涤槽和水龙头', 4, 50011500, 3, ',50008164,50006281,50011500,50011505,', 0),
(50011506, '厨房搁架单元', 5, 50011500, 3, ',50008164,50006281,50011500,50011506,', 0),
(50011507, '厨房配件', 6, 50011500, 3, ',50008164,50006281,50011500,50011507,', 0),
(50011509, '柜子和搁架', 0, 50011508, 3, ',50008164,50006281,50011508,50011509,', 0),
(50011510, '洗脸池和水龙头', 1, 50011508, 3, ',50008164,50006281,50011508,50011510,', 0),
(50011511, '浴室储藏件', 2, 50011508, 3, ',50008164,50006281,50011508,50011511,', 0),
(50011513, '婴儿产品', 2, 50011512, 3, ',50008164,50006281,50011512,50011513,', 0),
(50011514, '睡眠产品', 3, 50011512, 3, ',50008164,50006281,50011512,50011514,', 0),
(50011515, '用餐产品', 4, 50011512, 3, ',50008164,50006281,50011512,50011515,', 0),
(50011516, '储物', 5, 50011512, 3, ',50008164,50006281,50011512,50011516,', 0),
(50011517, '游戏产品', 6, 50011512, 3, ',50008164,50006281,50011512,50011517,', 0),
(50011518, '儿童装饰产品', 7, 50011512, 3, ',50008164,50006281,50011512,50011518,', 0),
(50011444, '儿童照明产品', 8, 50011512, 3, ',50008164,50006281,50011512,50011444,', 0),
(50011519, '儿童纺织品', 9, 50011512, 3, ',50008164,50006281,50011512,50011519,', 0),
(50011450, '儿童床', 10, 50011512, 3, ',50008164,50006281,50011512,50011450,', 0),
(50011520, '安全产品', 11, 50011512, 3, ',50008164,50006281,50011512,50011520,', 0),
(50011522, '饮料', 0, 50011521, 3, ',50008164,50006281,50011521,50011522,', 0),
(50011523, '面包和奶制品', 1, 50011521, 3, ',50008164,50006281,50011521,50011523,', 0),
(50011524, '饼干和西点', 2, 50011521, 3, ',50008164,50006281,50011521,50011524,', 0),
(50011525, '肉、鱼和海产品', 3, 50011521, 3, ',50008164,50006281,50011521,50011525,', 0),
(50011526, '沙司和调味品', 4, 50011521, 3, ',50008164,50006281,50011521,50011526,', 0),
(50011527, '糖果和零食', 5, 50011521, 3, ',50008164,50006281,50011521,50011527,', 0),
(50011528, '果酱', 6, 50011521, 3, ',50008164,50006281,50011521,50011528,', 0),
(50011530, '墙面装饰品', 0, 50011529, 3, ',50008164,50006281,50011529,50011530,', 0),
(50011531, '镜子', 1, 50011529, 3, ',50008164,50006281,50011529,50011531,', 0),
(50011532, '时钟', 2, 50011529, 3, ',50008164,50006281,50011529,50011532,', 0),
(50011533, '蜡烛和蜡烛台', 3, 50011529, 3, ',50008164,50006281,50011529,50011533,', 0),
(50011534, '花盆和植物', 4, 50011529, 3, ',50008164,50006281,50011529,50011534,', 0),
(50011535, '花瓶和花', 5, 50011529, 3, ',50008164,50006281,50011529,50011535,', 0),
(50011536, '篮筐', 6, 50011529, 3, ',50008164,50006281,50011529,50011536,', 0),
(50011537, '房间隔断和帘子', 7, 50011529, 3, ',50008164,50006281,50011529,50011537,', 0),
(50011538, '装饰物，碗和碟子', 8, 50011529, 3, ',50008164,50006281,50011529,50011538,', 0),
(50011539, '礼品包装纸', 9, 50011529, 3, ',50008164,50006281,50011529,50011539,', 0),
(50011541, '餐桌', 0, 50011540, 3, ',50008164,50006281,50011540,50011541,', 0),
(50011542, '咖啡桌和边桌', 1, 50011540, 3, ',50008164,50006281,50011540,50011542,', 0),
(50011543, '办公桌', 2, 50011540, 3, ',50008164,50006281,50011540,50011543,', 0),
(50011544, '电脑储物组合', 3, 50011540, 3, ',50008164,50006281,50011540,50011544,', 0),
(50011545, '桌面和桌腿', 4, 50011540, 3, ',50008164,50006281,50011540,50011545,', 0),
(50011547, '餐椅', 0, 50011546, 3, ',50008164,50006281,50011546,50011547,', 0),
(50011548, '工作椅', 1, 50011546, 3, ',50008164,50006281,50011546,50011548,', 0),
(50011549, '可折叠式椅子和可摞放式椅子', 2, 50011546, 3, ',50008164,50006281,50011546,50011549,', 0),
(50011550, '圆凳和长凳', 3, 50011546, 3, ',50008164,50006281,50011546,50011550,', 0),
(50008523, '其他水具', 0, 50011684, 3, ',50016349,50006885,50011684,50008523,', 0),
(50008527, '冷水壶', 1, 50011684, 3, ',50016349,50006885,50011684,50008527,', 0),
(50011175, '刨冰机/碎冰机', 0, 50012488, 3, ',50016349,50008281,50012488,50011175,', 0),
(50002811, '微波炉专用盒', 1, 50012488, 3, ',50016349,50008281,50012488,50002811,', 0),
(50002813, '其它微波炉配套', 2, 50012488, 3, ',50016349,50008281,50012488,50002813,', 0),
(50002812, '微波炉手套', 3, 50012488, 3, ',50016349,50008281,50012488,50002812,', 0),
(50006770, '冰格/制冰袋', 4, 50012488, 3, ',50016349,50008281,50012488,50006770,', 0),
(50000566, '调味瓶罐', 2, 50012489, 3, ',50016349,50008281,50012489,50000566,', 0),
(50006895, '油壶', 3, 50012489, 3, ',50016349,50008281,50012489,50006895,', 0),
(50012921, '米桶/米缸', 8, 50012489, 3, ',50016349,50008281,50012489,50012921,', 0),
(50012922, '密封罐', 9, 50012489, 3, ',50016349,50008281,50012489,50012922,', 0),
(50005037, '垃圾架', 0, 50012527, 3, ',50016348,50003949,50012527,50005037,', 0),
(50004416, '垃圾桶', 1, 50012527, 3, ',50016348,50003949,50012527,50004416,', 0),
(50012502, '手动鼓风机', 0, 50012549, 3, ',50016349,50002258,50012549,50012502,', 0),
(50012501, '锡纸/油纸', 1, 50012549, 3, ',50016349,50002258,50012549,50012501,', 0),
(50012499, '烧烤刷', 2, 50012549, 3, ',50016349,50002258,50012549,50012499,', 0),
(50012498, '固态酒精', 3, 50012549, 3, ',50016349,50002258,50012549,50012498,', 0),
(50012497, '烧烤炭', 4, 50012549, 3, ',50016349,50002258,50012549,50012497,', 0),
(50012496, '烧烤网', 5, 50012549, 3, ',50016349,50002258,50012549,50012496,', 0),
(50012495, '烧烤夹/叉/铲/针', 6, 50012549, 3, ',50016349,50002258,50012549,50012495,', 0),
(50012494, '烧烤盘', 7, 50012549, 3, ',50016349,50002258,50012549,50012494,', 0),
(50012493, '烧烤车', 8, 50012549, 3, ',50016349,50002258,50012549,50012493,', 0),
(50012491, '烧烤架/烧烤炉', 10, 50012549, 3, ',50016349,50002258,50012549,50012491,', 0),
(50000014, '其它烧烤用品', 11, 50012549, 3, ',50016349,50002258,50012549,50000014,', 0),
(50026553, '烧烤用具套装', 12, 50012549, 3, ',50016349,50002258,50012549,50026553,', 0),
(50012510, '点心包装盒/包装袋', 0, 50012550, 3, ',50016349,50002258,50012550,50012510,', 0),
(50012509, '裱花嘴/裱花枪/裱花袋', 1, 50012550, 3, ',50016349,50002258,50012550,50012509,', 0),
(50012508, '烘焙用纸', 2, 50012550, 3, ',50016349,50002258,50012550,50012508,', 0),
(50012507, '面粉筛', 3, 50012550, 3, ',50016349,50002258,50012550,50012507,', 0),
(50012506, '烘焙机/烤箱', 4, 50012550, 3, ',50016349,50002258,50012550,50012506,', 0),
(50012505, '擀面杖', 5, 50012550, 3, ',50016349,50002258,50012550,50012505,', 0),
(50012504, '量勺/量匙/量杯/量秤', 6, 50012550, 3, ',50016349,50002258,50012550,50012504,', 0),
(50004436, '其它烘焙器具', 7, 50012550, 3, ',50016349,50002258,50012550,50004436,', 0),
(50023730, '烘焙模具', 8, 50012550, 3, ',50016349,50002258,50012550,50023730,', 0),
(50026552, '烘焙器具套装', 9, 50012550, 3, ',50016349,50002258,50012550,50026552,', 0),
(50012652, '摩托车头盔', 0, 50012651, 3, ',26,50014648,50012651,50012652,', 0),
(50012654, '风镜', 1, 50012651, 3, ',26,50014648,50012651,50012654,', 0),
(50012656, '骑士护具', 2, 50012651, 3, ',26,50014648,50012651,50012656,', 0),
(50012657, '骑士手套', 3, 50012651, 3, ',26,50014648,50012651,50012657,', 0),
(50012658, '赛车服', 4, 50012651, 3, ',26,50014648,50012651,50012658,', 0),
(50012659, '赛车T恤', 5, 50012651, 3, ',26,50014648,50012651,50012659,', 0),
(50012661, '赛车裤', 6, 50012651, 3, ',26,50014648,50012651,50012661,', 0),
(50012662, '赛车鞋', 7, 50012651, 3, ',26,50014648,50012651,50012662,', 0),
(50012663, '骑士包', 8, 50012651, 3, ',26,50014648,50012651,50012663,', 0),
(50012664, '其它骑士装备', 9, 50012651, 3, ',26,50014648,50012651,50012664,', 0),
(50012748, '兼毫笔（商品请发毛笔）', 2, 50012735, 3, ',50018004,50024641,50012735,50012748,', 0),
(50021854, '家用剪', 0, 50020511, 3, ',50020485,50020487,50020511,50021854,', 0),
(50021855, '理发剪', 1, 50020511, 3, ',50020485,50020487,50020511,50021855,', 0),
(50021856, '裁缝剪', 2, 50020511, 3, ',50020485,50020487,50020511,50021856,', 0),
(50021858, '园艺剪', 4, 50020511, 3, ',50020485,50020487,50020511,50021858,', 0),
(50021859, '铁皮剪', 5, 50020511, 3, ',50020485,50020487,50020511,50021859,', 0),
(50021860, '其他剪', 6, 50020511, 3, ',50020485,50020487,50020511,50021860,', 0),
(50021857, '电工剪', 7, 50020511, 3, ',50020485,50020487,50020511,50021857,', 0),
(50021862, '家用刀', 0, 50020512, 3, ',50020485,50020487,50020512,50021862,', 0),
(50013645, '抹泥刀', 1, 50020512, 3, ',50020485,50020487,50020512,50013645,', 0),
(50021863, '美工刀', 1, 50020512, 3, ',50020485,50020487,50020512,50021863,', 0),
(50021864, '管子割刀', 2, 50020512, 3, ',50020485,50020487,50020512,50021864,', 0),
(50021865, '电工刀', 3, 50020512, 3, ',50020485,50020487,50020512,50021865,', 0),
(50021866, '滚花刀', 4, 50020512, 3, ',50020485,50020487,50020512,50021866,', 0),
(50021867, '砌刀', 5, 50020512, 3, ',50020485,50020487,50020512,50021867,', 0),
(50021868, '砂轮整形刀', 6, 50020512, 3, ',50020485,50020487,50020512,50021868,', 0),
(50021869, '重型刀', 7, 50020512, 3, ',50020485,50020487,50020512,50021869,', 0),
(50021870, '雕刻刀', 8, 50020512, 3, ',50020485,50020487,50020512,50021870,', 0),
(50021871, '刀片', 9, 50020512, 3, ',50020485,50020487,50020512,50021871,', 0),
(50021872, '其他刀', 10, 50020512, 3, ',50020485,50020487,50020512,50021872,', 0),
(50013646, '油灰刀', 11, 50020512, 3, ',50020485,50020487,50020512,50013646,', 0),
(50013647, '铲刀', 12, 50020512, 3, ',50020485,50020487,50020512,50013647,', 0),
(50013660, '玻璃刀', 13, 50020512, 3, ',50020485,50020487,50020512,50013660,', 0),
(50013657, '刮刀', 14, 50020512, 3, ',50020485,50020487,50020512,50013657,', 0),
(50021487, '划规', 0, 50020513, 3, ',50020485,50020487,50020513,50021487,', 0),
(50021488, '划针', 1, 50020513, 3, ',50020485,50020487,50020513,50021488,', 0),
(50021489, '划线盘', 2, 50020513, 3, ',50020485,50020487,50020513,50021489,', 0),
(50021490, '划线用V形铁', 3, 50020513, 3, ',50020485,50020487,50020513,50021490,', 0),
(50021491, '方箱', 4, 50020513, 3, ',50020485,50020487,50020513,50021491,', 0),
(50021492, '其他', 5, 50020513, 3, ',50020485,50020487,50020513,50021492,', 0),
(50013637, '墨斗', 6, 50020513, 3, ',50020485,50020487,50020513,50013637,', 0),
(50013638, '墨汁', 7, 50020513, 3, ',50020485,50020487,50020513,50013638,', 0),
(50021493, '钉冲', 0, 50020514, 3, ',50020485,50020487,50020514,50021493,', 0),
(50021494, '圆柱冲', 1, 50020514, 3, ',50020485,50020487,50020514,50021494,', 0),
(50021495, '中心冲', 2, 50020514, 3, ',50020485,50020487,50020514,50021495,', 0),
(50021496, '尖冲', 3, 50020514, 3, ',50020485,50020487,50020514,50021496,', 0),
(50021497, '圆锥冲', 4, 50020514, 3, ',50020485,50020487,50020514,50021497,', 0),
(50021498, '撬棒', 5, 50020514, 3, ',50020485,50020487,50020514,50021498,', 0),
(50021499, '起钉器', 6, 50020514, 3, ',50020485,50020487,50020514,50021499,', 0),
(50021500, '其他', 7, 50020514, 3, ',50020485,50020487,50020514,50021500,', 0),
(50021501, '鸡尾锯', 0, 50020515, 3, ',50020485,50020487,50020515,50021501,', 0),
(50021503, '夹背锯', 1, 50020515, 3, ',50020485,50020487,50020515,50021503,', 0),
(50021504, '木工带锯', 2, 50020515, 3, ',50020485,50020487,50020515,50021504,', 0),
(50021505, '手用钢锯条', 3, 50020515, 3, ',50020485,50020487,50020515,50021505,', 0),
(50013630, '锯片', 3, 50020515, 3, ',50020485,50020487,50020515,50013630,', 0),
(50021506, '机用锯条', 4, 50020515, 3, ',50020485,50020487,50020515,50021506,', 0),
(50021507, '其他', 5, 50020515, 3, ',50020485,50020487,50020515,50021507,', 0),
(50013632, '手工锯', 5, 50020515, 3, ',50020485,50020487,50020515,50013632,', 0),
(50013629, '钢锯', 6, 50020515, 3, ',50020485,50020487,50020515,50013629,', 0),
(50021508, '锯锉', 0, 50020516, 3, ',50020485,50020487,50020516,50021508,', 0),
(50021509, '刀锉', 1, 50020516, 3, ',50020485,50020487,50020516,50021509,', 0),
(50021510, '钳工锉', 2, 50020516, 3, ',50020485,50020487,50020516,50021510,', 0),
(50021511, '钟表锉', 3, 50020516, 3, ',50020485,50020487,50020516,50021511,', 0),
(50021512, '整形锉', 4, 50020516, 3, ',50020485,50020487,50020516,50021512,', 0),
(50013631, '金刚锉', 4, 50020516, 3, ',50020485,50020487,50020516,50013631,', 0),
(50021513, '异形锉', 5, 50020516, 3, ',50020485,50020487,50020516,50021513,', 0),
(50021514, '什锦锉', 6, 50020516, 3, ',50020485,50020487,50020516,50021514,', 0),
(50013633, '木刨', 6, 50020516, 3, ',50020485,50020487,50020516,50013633,', 0),
(50021515, '锉刨', 7, 50020516, 3, ',50020485,50020487,50020516,50021515,', 0),
(50021516, '刨片', 8, 50020516, 3, ',50020485,50020487,50020516,50021516,', 0),
(50021517, '其他', 9, 50020516, 3, ',50020485,50020487,50020516,50021517,', 0),
(50021520, '电焊条', 0, 50020517, 3, ',50020485,50020487,50020517,50021520,', 0),
(50021521, '电焊丝', 1, 50020517, 3, ',50020485,50020487,50020517,50021521,', 0),
(50021522, '焊剂', 2, 50020517, 3, ',50020485,50020487,50020517,50021522,', 0),
(50021523, '钎料', 3, 50020517, 3, ',50020485,50020487,50020517,50021523,', 0),
(50021524, '割炬', 4, 50020517, 3, ',50020485,50020487,50020517,50021524,', 0),
(50013389, '焊炬/枪', 5, 50020517, 3, ',50020485,50020487,50020517,50013389,', 0),
(50021526, '焊台', 7, 50020517, 3, ',50020485,50020487,50020517,50021526,', 0),
(50021527, '喷火枪', 8, 50020517, 3, ',50020485,50020487,50020517,50021527,', 0),
(50021531, '喷灯', 12, 50020517, 3, ',50020485,50020487,50020517,50021531,', 0),
(50021532, '喷漆枪', 13, 50020517, 3, ',50020485,50020487,50020517,50021532,', 0),
(50021533, '喷笔', 14, 50020517, 3, ',50020485,50020487,50020517,50021533,', 0),
(50021534, '多彩喷涂枪', 15, 50020517, 3, ',50020485,50020487,50020517,50021534,', 0),
(50021535, '其它焊接喷涂工具', 16, 50020517, 3, ',50020485,50020487,50020517,50021535,', 0),
(50006223, '烙铁/电焊头', 17, 50020517, 3, ',50020485,50020487,50020517,50006223,', 0),
(50006224, '焊锡松香等耗材', 18, 50020517, 3, ',50020485,50020487,50020517,50006224,', 0),
(50021536, '游标卡尺', 0, 50020518, 3, ',50020485,50020487,50020518,50021536,', 0),
(50021537, '电子数显卡尺', 1, 50020518, 3, ',50020485,50020487,50020518,50021537,', 0),
(50021538, '带表卡尺', 2, 50020518, 3, ',50020485,50020487,50020518,50021538,', 0),
(50021539, '标尺', 3, 50020518, 3, ',50020485,50020487,50020518,50021539,', 0),
(50021886, '千分尺', 4, 50020518, 3, ',50020485,50020487,50020518,50021886,', 0),
(50021540, '卷尺', 5, 50020518, 3, ',50020485,50020487,50020518,50021540,', 0),
(50021887, '角尺', 6, 50020518, 3, ',50020485,50020487,50020518,50021887,', 0),
(50021541, '塞尺', 7, 50020518, 3, ',50020485,50020487,50020518,50021541,', 0),
(50021542, '木折尺', 8, 50020518, 3, ',50020485,50020487,50020518,50021542,', 0),
(50021543, '量规', 9, 50020518, 3, ',50020485,50020487,50020518,50021543,', 0),
(50021544, '样板', 10, 50020518, 3, ',50020485,50020487,50020518,50021544,', 0),
(50021545, '量块', 11, 50020518, 3, ',50020485,50020487,50020518,50021545,', 0),
(50021546, '指示表', 12, 50020518, 3, ',50020485,50020487,50020518,50021546,', 0),
(50021547, '表坐', 13, 50020518, 3, ',50020485,50020487,50020518,50021547,', 0),
(50021548, '测距望远镜', 14, 50020518, 3, ',50020485,50020487,50020518,50021548,', 0),
(50021549, '秤', 15, 50020518, 3, ',50020485,50020487,50020518,50021549,', 0),
(50021550, '线垂', 16, 50020518, 3, ',50020485,50020487,50020518,50021550,', 0),
(50021551, '卡钳', 17, 50020518, 3, ',50020485,50020487,50020518,50021551,', 0),
(50021552, '机床工具', 18, 50020518, 3, ',50020485,50020487,50020518,50021552,', 0),
(50013668, '钢直尺', 19, 50020518, 3, ',50020485,50020487,50020518,50013668,', 0),
(50013669, '水平尺', 20, 50020518, 3, ',50020485,50020487,50020518,50013669,', 0),
(50013673, '量油尺', 22, 50020518, 3, ',50020485,50020487,50020518,50013673,', 0),
(50013675, '其它测量工具', 23, 50020518, 3, ',50020485,50020487,50020518,50013675,', 0),
(50021556, '家用工具组套', 0, 50020520, 3, ',50020485,50020487,50020520,50021556,', 0),
(50006188, '组合套装', 8, 50020520, 3, ',50020485,50020487,50020520,50006188,', 0),
(50021559, '工具柜', 0, 50020521, 3, ',50020485,50020487,50020521,50021559,', 0),
(50021560, '工具包', 1, 50020521, 3, ',50020485,50020487,50020521,50021560,', 0),
(50021561, '工具车', 2, 50020521, 3, ',50020485,50020487,50020521,50021561,', 0),
(50013468, '零件盒', 4, 50020521, 3, ',50020485,50020487,50020521,50013468,', 0),
(50013469, '五金工具箱', 5, 50020521, 3, ',50020485,50020487,50020521,50013469,', 0),
(50021891, '电子焊接工具', 0, 50020522, 3, ',50020485,50020487,50020522,50021891,', 0),
(50021892, '电工维修工具', 1, 50020522, 3, ',50020485,50020487,50020522,50021892,', 0),
(50021893, '电子钳', 2, 50020522, 3, ',50020485,50020487,50020522,50021893,', 0),
(50021894, '线缆工具', 3, 50020522, 3, ',50020485,50020487,50020522,50021894,', 0),
(50021895, '其他电子工具', 5, 50020522, 3, ',50020485,50020487,50020522,50021895,', 0),
(50002930, '测电笔', 6, 50020522, 3, ',50020485,50020487,50020522,50002930,', 0),
(50021562, '通用汽修组套', 0, 50020523, 3, ',50020485,50020487,50020523,50021562,', 0),
(50021563, '润滑设备及工具', 1, 50020523, 3, ',50020485,50020487,50020523,50021563,', 0),
(50021564, '轮胎维修工具', 2, 50020523, 3, ',50020485,50020487,50020523,50021564,', 0),
(50021565, '引擎维修工具', 3, 50020523, 3, ',50020485,50020487,50020523,50021565,', 0),
(50021566, '底盘维修工具', 4, 50020523, 3, ',50020485,50020487,50020523,50021566,', 0),
(50021567, '车身维修工具', 5, 50020523, 3, ',50020485,50020487,50020523,50021567,', 0),
(50021568, '电器维修工具', 6, 50020523, 3, ',50020485,50020487,50020523,50021568,', 0),
(50022416, '其他汽修汽保工具', 7, 50020523, 3, ',50020485,50020487,50020523,50022416,', 0),
(50021569, '叉', 0, 50020524, 3, ',50020485,50020487,50020524,50021569,', 0),
(50021570, '锹', 1, 50020524, 3, ',50020485,50020487,50020524,50021570,', 0),
(50021571, '耙子', 2, 50020524, 3, ',50020485,50020487,50020524,50021571,', 0),
(50021572, '镰刀', 3, 50020524, 3, ',50020485,50020487,50020524,50021572,', 0),
(50021573, '锨', 4, 50020524, 3, ',50020485,50020487,50020524,50021573,', 0),
(50021574, '钢镐', 5, 50020524, 3, ',50020485,50020487,50020524,50021574,', 0),
(50021575, '其他农用工具', 6, 50020524, 3, ',50020485,50020487,50020524,50021575,', 0),
(50008934, '铲子/锄头', 7, 50020524, 3, ',50020485,50020487,50020524,50008934,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50021576, '齿轮', 0, 50020569, 3, ',50020485,50020490,50020569,50021576,', 0),
(50021577, '链轮', 1, 50020569, 3, ',50020485,50020490,50020569,50021577,', 0),
(50021578, '带轮', 2, 50020569, 3, ',50020485,50020490,50020569,50021578,', 0),
(50021579, '蜗轮', 3, 50020569, 3, ',50020485,50020490,50020569,50021579,', 0),
(50021580, '传动带', 4, 50020569, 3, ',50020485,50020490,50020569,50021580,', 0),
(50021581, '传动链', 5, 50020569, 3, ',50020485,50020490,50020569,50021581,', 0),
(50021582, '联轴器', 6, 50020569, 3, ',50020485,50020490,50020569,50021582,', 0),
(50021583, '齿轮箱', 7, 50020569, 3, ',50020485,50020490,50020569,50021583,', 0),
(50021584, '深沟球轴承', 0, 50020570, 3, ',50020485,50020490,50020570,50021584,', 0),
(50021585, '调心球轴承', 1, 50020570, 3, ',50020485,50020490,50020570,50021585,', 0),
(50021586, '圆柱滚子轴承', 2, 50020570, 3, ',50020485,50020490,50020570,50021586,', 0),
(50021587, '调心滚子轴承', 3, 50020570, 3, ',50020485,50020490,50020570,50021587,', 0),
(50021588, '滚针轴承', 4, 50020570, 3, ',50020485,50020490,50020570,50021588,', 0),
(50021589, '角接触球轴承', 5, 50020570, 3, ',50020485,50020490,50020570,50021589,', 0),
(50021590, '圆锥滚子轴承', 6, 50020570, 3, ',50020485,50020490,50020570,50021590,', 0),
(50021591, '推力球轴承', 7, 50020570, 3, ',50020485,50020490,50020570,50021591,', 0),
(50021592, '推力滚子轴承', 8, 50020570, 3, ',50020485,50020490,50020570,50021592,', 0),
(50021593, '组合轴承', 9, 50020570, 3, ',50020485,50020490,50020570,50021593,', 0),
(50022498, '外球面球轴承', 10, 50020570, 3, ',50020485,50020490,50020570,50022498,', 0),
(50021594, '关节轴承', 11, 50020570, 3, ',50020485,50020490,50020570,50021594,', 0),
(50021595, '直线运动轴承', 12, 50020570, 3, ',50020485,50020490,50020570,50021595,', 0),
(50021596, '转盘轴承/回转轴承', 13, 50020570, 3, ',50020485,50020490,50020570,50021596,', 0),
(50022450, '床幔', 0, 50020629, 3, ',50008164,50015200,50020629,50022450,', 0),
(50015652, '床铰链', 1, 50020629, 3, ',50008164,50015200,50020629,50015652,', 0),
(50015653, '床插', 2, 50020629, 3, ',50008164,50015200,50020629,50015653,', 0),
(50015654, '其它床配件', 3, 50020629, 3, ',50008164,50015200,50020629,50015654,', 0),
(50013353, '整体厨柜', 0, 50020631, 3, ',27,50002409,50020631,50013353,', 0),
(50021789, '柜体', 0, 50020631, 3, ',27,50002409,50020631,50021789,', 0),
(50021790, '门板', 1, 50020631, 3, ',27,50002409,50020631,50021790,', 0),
(50021792, '台面', 3, 50020631, 3, ',27,50002409,50020631,50021792,', 0),
(50003714, '充气泵及修补工具', 0, 50020641, 3, ',50008164,50020006,50020641,50003714,', 0),
(50015655, '沙发脚', 0, 50020641, 3, ',50008164,50020006,50020641,50015655,', 0),
(50015656, '泡钉', 1, 50020641, 3, ',50008164,50020006,50020641,50015656,', 0),
(50022497, '保丽龙颗粒', 14, 50020641, 3, ',50008164,50020006,50020641,50022497,', 0),
(50020658, '冲击扳手', 0, 50020647, 3, ',50020485,50020646,50020647,50020658,', 0),
(50020659, '扭剪扳手', 1, 50020647, 3, ',50020485,50020646,50020647,50020659,', 0),
(50020660, '定扭矩扳手', 2, 50020647, 3, ',50020485,50020646,50020647,50020660,', 0),
(50020662, '角向扳手', 4, 50020647, 3, ',50020485,50020646,50020647,50020662,', 0),
(50020668, '其他电动扳手', 5, 50020647, 3, ',50020485,50020646,50020647,50020668,', 0),
(50020788, '电圆锯', 1, 50020649, 3, ',50020485,50020646,50020649,50020788,', 0),
(50020664, '电动曲线锯', 2, 50020649, 3, ',50020485,50020646,50020649,50020664,', 0),
(50020665, '电链锯', 3, 50020649, 3, ',50020485,50020646,50020649,50020665,', 0),
(50020666, '台锯', 4, 50020649, 3, ',50020485,50020646,50020649,50020666,', 0),
(50020667, '马刀锯/往复锯', 5, 50020649, 3, ',50020485,50020646,50020649,50020667,', 0),
(50020818, '其他类型电锯', 6, 50020649, 3, ',50020485,50020646,50020649,50020818,', 0),
(50020858, '电话亭', 0, 50020708, 3, ',50020611,50020671,50020708,50020858,', 0),
(50020859, '公共椅', 1, 50020708, 3, ',50020611,50020671,50020708,50020859,', 0),
(50020860, '安检门', 2, 50020708, 3, ',50020611,50020671,50020708,50020860,', 0),
(50020861, '灭火箱', 3, 50020708, 3, ',50020611,50020671,50020708,50020861,', 0),
(50020862, '健身娱乐设施', 4, 50020708, 3, ',50020611,50020671,50020708,50020862,', 0),
(50020863, '公共饮水器', 5, 50020708, 3, ',50020611,50020671,50020708,50020863,', 0),
(50020864, '邮筒', 6, 50020708, 3, ',50020611,50020671,50020708,50020864,', 0),
(50020865, '售报亭', 7, 50020708, 3, ',50020611,50020671,50020708,50020865,', 0),
(50020866, '其他', 8, 50020708, 3, ',50020611,50020671,50020708,50020866,', 0),
(50020867, '交通指示牌', 0, 50020709, 3, ',50020611,50020671,50020709,50020867,', 0),
(50020868, '路标', 1, 50020709, 3, ',50020611,50020671,50020709,50020868,', 0),
(50020869, '路障', 2, 50020709, 3, ',50020611,50020671,50020709,50020869,', 0),
(50020870, '自行车停放设施', 3, 50020709, 3, ',50020611,50020671,50020709,50020870,', 0),
(50020871, '无障碍设施', 4, 50020709, 3, ',50020611,50020671,50020709,50020871,', 0),
(50020872, '停车牌', 5, 50020709, 3, ',50020611,50020671,50020709,50020872,', 0),
(50020873, '其他', 6, 50020709, 3, ',50020611,50020671,50020709,50020873,', 0),
(50020874, '垃圾筒/烟灰皿', 0, 50020710, 3, ',50020611,50020671,50020710,50020874,', 0),
(50020875, '其他', 1, 50020710, 3, ',50020611,50020671,50020710,50020875,', 0),
(50020876, '信息张贴栏', 0, 50020711, 3, ',50020611,50020671,50020711,50020876,', 0),
(50020877, '布告栏', 1, 50020711, 3, ',50020611,50020671,50020711,50020877,', 0),
(50020878, '导向牌', 2, 50020711, 3, ',50020611,50020671,50020711,50020878,', 0),
(50020880, '广告帐蓬', 4, 50020711, 3, ',50020611,50020671,50020711,50020880,', 0),
(50020881, '户外旗杆', 5, 50020711, 3, ',50020611,50020671,50020711,50020881,', 0),
(50020882, '宣传栏', 6, 50020711, 3, ',50020611,50020671,50020711,50020882,', 0),
(50020885, '杂志报刊架', 9, 50020711, 3, ',50020611,50020671,50020711,50020885,', 0),
(50020886, '其他', 10, 50020711, 3, ',50020611,50020671,50020711,50020886,', 0),
(50007012, 'X展架/易拉宝', 11, 50020711, 3, ',50020611,50020671,50020711,50007012,', 0),
(50007015, '广告牌', 14, 50020711, 3, ',50020611,50020671,50020711,50007015,', 0),
(50007066, '灯箱', 16, 50020711, 3, ',50020611,50020671,50020711,50007066,', 0),
(50020887, '花坛', 0, 50020712, 3, ',50020611,50020671,50020712,50020887,', 0),
(50020888, '雕塑', 1, 50020712, 3, ',50020611,50020671,50020712,50020888,', 0),
(50020889, '喷泉', 2, 50020712, 3, ',50020611,50020671,50020712,50020889,', 0),
(50020890, '叠水瀑布', 3, 50020712, 3, ',50020611,50020671,50020712,50020890,', 0),
(50020891, '景观小品', 4, 50020712, 3, ',50020611,50020671,50020712,50020891,', 0),
(50020892, '其他', 5, 50020712, 3, ',50020611,50020671,50020712,50020892,', 0),
(50020764, '无纺布', 1, 50020736, 3, ',50008163,50024925,50020736,50020764,', 0),
(50020766, '花边/蕾丝', 2, 50020736, 3, ',50008163,50024925,50020736,50020766,', 0),
(50020768, '挂钩/挂球', 3, 50020736, 3, ',50008163,50024925,50020736,50020768,', 0),
(50020770, '布百叶配件', 4, 50020736, 3, ',50008163,50024925,50020736,50020770,', 0),
(50005507, '窗帘扣', 4, 50020736, 3, ',50008163,50024925,50020736,50005507,', 0),
(50020773, '铅线/铅坠', 5, 50020736, 3, ',50008163,50024925,50020736,50020773,', 0),
(50022701, '窗帘绑带', 6, 50020736, 3, ',50008163,50024925,50020736,50022701,', 0),
(50023091, '其他制帘配件', 7, 50020736, 3, ',50008163,50024925,50020736,50023091,', 0),
(50008862, '帘珠', 8, 50020736, 3, ',50008163,50024925,50020736,50008862,', 0),
(50008863, '帘杆', 9, 50020736, 3, ',50008163,50024925,50020736,50008863,', 0),
(50020803, '苏绣', 0, 50020753, 3, ',50008163,50024922,50020753,50020803,', 0),
(50020805, '其他绣品', 1, 50020753, 3, ',50008163,50024922,50020753,50020805,', 0),
(50021908, '湘绣', 2, 50020753, 3, ',50008163,50024922,50020753,50021908,', 0),
(50021909, '蜀绣', 3, 50020753, 3, ',50008163,50024922,50020753,50021909,', 0),
(50021910, '粤绣', 4, 50020753, 3, ',50008163,50024922,50020753,50021910,', 0),
(50021878, '花瓶', 0, 50020901, 3, ',50020808,50024938,50020901,50021878,', 0),
(50021879, '花桶', 1, 50020901, 3, ',50020808,50024938,50020901,50021879,', 0),
(50021880, '花盆', 2, 50020901, 3, ',50020808,50024938,50020901,50021880,', 0),
(50021881, '花篮', 3, 50020901, 3, ',50020808,50024938,50020901,50021881,', 0),
(50021882, '花栅栏', 4, 50020901, 3, ',50020808,50024938,50020901,50021882,', 0),
(50021883, '窗型花器', 5, 50020901, 3, ',50020808,50024938,50020901,50021883,', 0),
(50021884, '花壶瓶', 6, 50020901, 3, ',50020808,50024938,50020901,50021884,', 0),
(50021885, '其他花器', 7, 50020901, 3, ',50020808,50024938,50020901,50021885,', 0),
(50022256, '顶座', 0, 50020970, 3, ',27,50020966,50020970,50022256,', 0),
(50022257, '滑轮', 1, 50020970, 3, ',27,50020966,50020970,50022257,', 0),
(50022258, '定向转角', 2, 50020970, 3, ',27,50020966,50020970,50022258,', 0),
(50022259, '晾杆', 3, 50020970, 3, ',27,50020966,50020970,50022259,', 0),
(50022260, '手摇器', 4, 50020970, 3, ',27,50020966,50020970,50022260,', 0),
(50022261, '钢丝绳', 5, 50020970, 3, ',27,50020966,50020970,50022261,', 0),
(50022262, '定向滑轮组', 6, 50020970, 3, ',27,50020966,50020970,50022262,', 0),
(50006727, '其它摄像机', 0, 50021060, 3, ',50020579,50021057,50021060,50006727,', 0),
(50021064, '枪机', 0, 50021060, 3, ',50020579,50021057,50021060,50021064,', 0),
(50021065, '半球型摄像机', 1, 50021060, 3, ',50020579,50021057,50021060,50021065,', 0),
(50021066, '一体化摄像机', 2, 50021060, 3, ',50020579,50021057,50021060,50021066,', 0),
(50021067, '红外摄像机', 3, 50021060, 3, ',50020579,50021057,50021060,50021067,', 0),
(50021068, '球型摄像机', 4, 50021060, 3, ',50020579,50021057,50021060,50021068,', 0),
(50021069, '网络摄像机', 5, 50021060, 3, ',50020579,50021057,50021060,50021069,', 0),
(50021070, '仿真摄像机', 6, 50021060, 3, ',50020579,50021057,50021060,50021070,', 0),
(50021071, '防爆摄像机', 7, 50021060, 3, ',50020579,50021057,50021060,50021071,', 0),
(50021074, 'PC式硬盘录像机', 0, 50021073, 3, ',50020579,50021057,50021073,50021074,', 0),
(50021075, '嵌入式硬盘录像机', 1, 50021073, 3, ',50020579,50021057,50021073,50021075,', 0),
(50021078, '软件压缩卡', 0, 50021077, 3, ',50020579,50021057,50021077,50021078,', 0),
(50021079, '硬件压缩卡', 1, 50021077, 3, ',50020579,50021057,50021077,50021079,', 0),
(50021108, '红外探测器', 0, 50021106, 3, ',50020579,50021105,50021106,50021108,', 0),
(50021109, '震动探测器', 1, 50021106, 3, ',50020579,50021105,50021106,50021109,', 0),
(50021110, '门磁报警器', 2, 50021106, 3, ',50020579,50021105,50021106,50021110,', 0),
(50021111, '声磁报警器', 3, 50021106, 3, ',50020579,50021105,50021106,50021111,', 0),
(50021603, '钢珠/滚珠', 0, 50021167, 3, ',50020485,50020490,50021167,50021603,', 0),
(50021604, '滚子', 1, 50021167, 3, ',50020485,50020490,50021167,50021604,', 0),
(50021605, '保持架', 2, 50021167, 3, ',50020485,50020490,50021167,50021605,', 0),
(50021606, '紧定套', 3, 50021167, 3, ',50020485,50020490,50021167,50021606,', 0),
(50021607, '挡圈', 4, 50021167, 3, ',50020485,50020490,50021167,50021607,', 0),
(50021608, '退卸衬套', 5, 50021167, 3, ',50020485,50020490,50021167,50021608,', 0),
(50021609, '止推环', 6, 50021167, 3, ',50020485,50020490,50021167,50021609,', 0),
(50021610, '锁紧垫圈', 7, 50021167, 3, ',50020485,50020490,50021167,50021610,', 0),
(50021611, '锁紧螺母', 8, 50021167, 3, ',50020485,50020490,50021167,50021611,', 0),
(50021612, '套管', 9, 50021167, 3, ',50020485,50020490,50021167,50021612,', 0),
(50021613, '轴承座', 10, 50021167, 3, ',50020485,50020490,50021167,50021613,', 0),
(50021614, '轴承装卸工具', 11, 50021167, 3, ',50020485,50020490,50021167,50021614,', 0),
(50021615, '轴承润滑油脂', 12, 50021167, 3, ',50020485,50020490,50021167,50021615,', 0),
(50021624, '汽油发电机', 0, 50021207, 3, ',50020485,50020491,50021207,50021624,', 0),
(50021625, '太阳能发电机', 1, 50021207, 3, ',50020485,50020491,50021207,50021625,', 0),
(50021626, '风力发电机', 2, 50021207, 3, ',50020485,50020491,50021207,50021626,', 0),
(50021627, '柴油发电机', 3, 50021207, 3, ',50020485,50020491,50021207,50021627,', 0),
(50021628, '燃气发电机', 4, 50021207, 3, ',50020485,50020491,50021207,50021628,', 0),
(50021629, '水力发电机', 5, 50021207, 3, ',50020485,50020491,50021207,50021629,', 0),
(50021630, '燃煤发电机', 6, 50021207, 3, ',50020485,50020491,50021207,50021630,', 0),
(50021631, '发电机组零部件', 7, 50021207, 3, ',50020485,50020491,50021207,50021631,', 0),
(50021632, '其他发电机', 8, 50021207, 3, ',50020485,50020491,50021207,50021632,', 0),
(50021638, '汽油机', 0, 50021209, 3, ',50020485,50020491,50021209,50021638,', 0),
(50021639, '柴油机', 1, 50021209, 3, ',50020485,50020491,50021209,50021639,', 0),
(50021641, '其他内燃机', 3, 50021209, 3, ',50020485,50020491,50021209,50021641,', 0),
(50021633, '齿轮减速机', 0, 50021210, 3, ',50020485,50020491,50021210,50021633,', 0),
(50021634, '蜗轮蜗杆减速机', 1, 50021210, 3, ',50020485,50020491,50021210,50021634,', 0),
(50021635, '行星摆线针轮减速机', 2, 50021210, 3, ',50020485,50020491,50021210,50021635,', 0),
(50021636, '行星齿轮减速机', 3, 50021210, 3, ',50020485,50020491,50021210,50021636,', 0),
(50021637, '减速机配件', 5, 50021210, 3, ',50020485,50020491,50021210,50021637,', 0),
(50021642, '工业电炉', 0, 50021211, 3, ',50020485,50020491,50021211,50021642,', 0),
(50021643, '电热管', 1, 50021211, 3, ',50020485,50020491,50021211,50021643,', 0),
(50021647, '工业烤箱', 5, 50021211, 3, ',50020485,50020491,50021211,50021647,', 0),
(50021648, '电热圈/片/盘/板', 6, 50021211, 3, ',50020485,50020491,50021211,50021648,', 0),
(50021649, '电热膜', 8, 50021211, 3, ',50020485,50020491,50021211,50021649,', 0),
(50021650, '电热带', 9, 50021211, 3, ',50020485,50020491,50021211,50021650,', 0),
(50021652, '伴热设备', 11, 50021211, 3, ',50020485,50020491,50021211,50021652,', 0),
(50021653, '热电偶/阻', 12, 50021211, 3, ',50020485,50020491,50021211,50021653,', 0),
(50021654, '实验电炉', 13, 50021211, 3, ',50020485,50020491,50021211,50021654,', 0),
(50021657, '发热芯', 16, 50021211, 3, ',50020485,50020491,50021211,50021657,', 0),
(50021658, '电热丝', 17, 50021211, 3, ',50020485,50020491,50021211,50021658,', 0),
(50021659, '硅碳棒', 18, 50021211, 3, ',50020485,50020491,50021211,50021659,', 0),
(50021661, '其他电热设备', 20, 50021211, 3, ',50020485,50020491,50021211,50021661,', 0),
(50021662, '点焊机', 0, 50021212, 3, ',50020485,50020491,50021212,50021662,', 0),
(50021663, '等离子切割机', 1, 50021212, 3, ',50020485,50020491,50021212,50021663,', 0),
(50021664, '电阻焊机', 2, 50021212, 3, ',50020485,50020491,50021212,50021664,', 0),
(50021665, '塑焊机', 3, 50021212, 3, ',50020485,50020491,50021212,50021665,', 0),
(50021666, '激光切割机', 4, 50021212, 3, ',50020485,50020491,50021212,50021666,', 0),
(50021667, '等离子焊机', 5, 50021212, 3, ',50020485,50020491,50021212,50021667,', 0),
(50021668, '碰焊机', 6, 50021212, 3, ',50020485,50020491,50021212,50021668,', 0),
(50021669, '排焊机', 7, 50021212, 3, ',50020485,50020491,50021212,50021669,', 0),
(50021670, '电火花', 8, 50021212, 3, ',50020485,50020491,50021212,50021670,', 0),
(50021671, '线切割', 9, 50021212, 3, ',50020485,50020491,50021212,50021671,', 0),
(50021672, '储能机', 10, 50021212, 3, ',50020485,50020491,50021212,50021672,', 0),
(50021673, '焊锡机', 11, 50021212, 3, ',50020485,50020491,50021212,50021673,', 0),
(50021674, '激光焊机', 12, 50021212, 3, ',50020485,50020491,50021212,50021674,', 0),
(50021675, '滚焊机', 13, 50021212, 3, ',50020485,50020491,50021212,50021675,', 0),
(50021676, '回流焊接机', 14, 50021212, 3, ',50020485,50020491,50021212,50021676,', 0),
(50021677, '焊线机', 15, 50021212, 3, ',50020485,50020491,50021212,50021677,', 0),
(50021678, '压焊机', 16, 50021212, 3, ',50020485,50020491,50021212,50021678,', 0),
(50021679, '摩擦焊机', 17, 50021212, 3, ',50020485,50020491,50021212,50021679,', 0),
(50021680, '焊管机', 18, 50021212, 3, ',50020485,50020491,50021212,50021680,', 0),
(50021681, '其他电焊/切割设备', 19, 50021212, 3, ',50020485,50020491,50021212,50021681,', 0),
(50021719, '膨胀螺栓', 0, 50021221, 3, ',50020485,50020492,50021221,50021719,', 0),
(50021720, '膨胀螺丝', 1, 50021221, 3, ',50020485,50020492,50021221,50021720,', 0),
(50021721, '内置式膨胀螺栓', 2, 50021221, 3, ',50020485,50020492,50021221,50021721,', 0),
(50021722, '胀紧套', 3, 50021221, 3, ',50020485,50020492,50021221,50021722,', 0),
(50021723, '塑料膨胀管', 4, 50021221, 3, ',50020485,50020492,50021221,50021723,', 0),
(50021724, '塑料胀塞', 5, 50021221, 3, ',50020485,50020492,50021221,50021724,', 0),
(50021725, '其它膨胀类紧固件', 6, 50021221, 3, ',50020485,50020492,50021221,50021725,', 0),
(50021696, '半空心铆钉', 0, 50021227, 3, ',50020485,50020492,50021227,50021696,', 0),
(50021697, '空心铆钉', 1, 50021227, 3, ',50020485,50020492,50021227,50021697,', 0),
(50021698, '半圆头铆钉', 2, 50021227, 3, ',50020485,50020492,50021227,50021698,', 0),
(50021699, '鸡眼铆钉', 3, 50021227, 3, ',50020485,50020492,50021227,50021699,', 0),
(50021700, '台阶铆钉', 4, 50021227, 3, ',50020485,50020492,50021227,50021700,', 0),
(50021711, '平头铆钉', 5, 50021227, 3, ',50020485,50020492,50021227,50021711,', 0),
(50021712, '环槽铆钉', 6, 50021227, 3, ',50020485,50020492,50021227,50021712,', 0),
(50021713, '标牌铆钉', 7, 50021227, 3, ',50020485,50020492,50021227,50021713,', 0),
(50021714, '子母铆钉', 8, 50021227, 3, ',50020485,50020492,50021227,50021714,', 0),
(50021715, '抽芯铆钉', 9, 50021227, 3, ',50020485,50020492,50021227,50021715,', 0),
(50021716, '平锥头铆钉', 10, 50021227, 3, ',50020485,50020492,50021227,50021716,', 0),
(50021717, '其他铆钉', 11, 50021227, 3, ',50020485,50020492,50021227,50021717,', 0),
(50021726, '圆柱铣刀', 0, 50021229, 3, ',50020485,50020493,50021229,50021726,', 0),
(50021727, '立铣刀', 1, 50021229, 3, ',50020485,50020493,50021229,50021727,', 0),
(50021728, '面铣刀', 2, 50021229, 3, ',50020485,50020493,50021229,50021728,', 0),
(50021729, '三面刃铣刀', 3, 50021229, 3, ',50020485,50020493,50021229,50021729,', 0),
(50021730, '锯片铣刀', 4, 50021229, 3, ',50020485,50020493,50021229,50021730,', 0),
(50021731, '键槽铣刀', 5, 50021229, 3, ',50020485,50020493,50021229,50021731,', 0),
(50021736, '其他铣刀', 10, 50021229, 3, ',50020485,50020493,50021229,50021736,', 0),
(50021737, '手用铰刀', 0, 50021230, 3, ',50020485,50020493,50021230,50021737,', 0),
(50021738, '机用铰刀', 1, 50021230, 3, ',50020485,50020493,50021230,50021738,', 0),
(50021739, '其他铰刀', 2, 50021230, 3, ',50020485,50020493,50021230,50021739,', 0),
(50021742, '圆车刀', 2, 50021231, 3, ',50020485,50020493,50021231,50021742,', 0),
(50021743, '切断车刀', 3, 50021231, 3, ',50020485,50020493,50021231,50021743,', 0),
(50021745, '螺丝车刀', 5, 50021231, 3, ',50020485,50020493,50021231,50021745,', 0),
(50021746, '孔车刀', 6, 50021231, 3, ',50020485,50020493,50021231,50021746,', 0),
(50021747, '其他车刀', 7, 50021231, 3, ',50020485,50020493,50021231,50021747,', 0),
(50022124, '拉祜族木雕', 0, 50021970, 3, ',50020857,50021045,50021970,50022124,', 0),
(50022129, '东乡族毛毡', 0, 50021972, 3, ',50020857,50021045,50021972,50022129,', 0),
(50022146, '仫佬族紫檀木工艺', 0, 50021978, 3, ',50020857,50021045,50021978,50022146,', 0),
(50022147, '羌族挑花刺绣', 0, 50021979, 3, ',50020857,50021045,50021979,50022147,', 0),
(50022159, '侗族银饰', 0, 50021982, 3, ',50020857,50021045,50021982,50022159,', 0),
(50022192, '木雕壁挂', 0, 50021994, 3, ',50020857,50021045,50021994,50022192,', 0),
(50013532, '安全帽', 0, 50022321, 3, ',50020332,50013226,50022321,50013532,', 0),
(50022322, '其他头部防护用品', 1, 50022321, 3, ',50020332,50013226,50022321,50022322,', 0),
(50022336, '安全带', 0, 50022335, 3, ',50020332,50013226,50022335,50022336,', 0),
(50022337, '安全绳', 1, 50022335, 3, ',50020332,50013226,50022335,50022337,', 0),
(50022338, '缓降器', 2, 50022335, 3, ',50020332,50013226,50022335,50022338,', 0),
(50022339, '安全网', 3, 50022335, 3, ',50020332,50013226,50022335,50022339,', 0),
(50022341, '消防靴', 0, 50022340, 3, ',50020332,50013226,50022340,50022341,', 0),
(50022342, '消防服', 1, 50022340, 3, ',50020332,50013226,50022340,50022342,', 0),
(50022343, '消防头盔', 2, 50022340, 3, ',50020332,50013226,50022340,50022343,', 0),
(50022344, '消防水带', 3, 50022340, 3, ',50020332,50013226,50022340,50022344,', 0),
(50022345, '灭火器', 4, 50022340, 3, ',50020332,50013226,50022340,50022345,', 0),
(50022346, '消防斧', 5, 50022340, 3, ',50020332,50013226,50022340,50022346,', 0),
(50022347, '灭火毯', 6, 50022340, 3, ',50020332,50013226,50022340,50022347,', 0),
(50022349, '反光锥', 0, 50022348, 3, ',50020332,50013226,50022348,50022349,', 0),
(50022350, '安全标志', 1, 50022348, 3, ',50020332,50013226,50022348,50022350,', 0),
(50022351, '护栏/隔离栏', 2, 50022348, 3, ',50020332,50013226,50022348,50022351,', 0),
(50022352, '路障闪灯', 3, 50022348, 3, ',50020332,50013226,50022348,50022352,', 0),
(50022353, '反光带', 4, 50022348, 3, ',50020332,50013226,50022348,50022353,', 0),
(50022354, '减速带\\减速垄', 5, 50022348, 3, ',50020332,50013226,50022348,50022354,', 0),
(50022355, '反光镜', 6, 50022348, 3, ',50020332,50013226,50022348,50022355,', 0),
(50022356, '水马\\防撞桶', 7, 50022348, 3, ',50020332,50013226,50022348,50022356,', 0),
(50022688, '面膜', 0, 50022679, 3, ',50025705,50012482,50022679,50022688,', 0),
(50022689, '眼膜', 1, 50022679, 3, ',50025705,50012482,50022679,50022689,', 0),
(50022756, '防盗器配件', 0, 50022743, 3, ',26,50014482,50022743,50022756,', 0),
(50011857, '车载摄像头', 12, 50022743, 3, ',26,50014482,50022743,50011857,', 0),
(50003800, '倒车雷达', 20, 50022743, 3, ',26,50014482,50022743,50003800,', 0),
(50011907, '汽车防盗器', 21, 50022743, 3, ',26,50014482,50022743,50011907,', 0),
(50022762, '跟踪器', 22, 50022743, 3, ',26,50014482,50022743,50022762,', 0),
(50004235, '防瞌睡提醒器', 30, 50022743, 3, ',26,50014482,50022743,50004235,', 0),
(50023120, '行车记录仪', 31, 50022743, 3, ',26,50014482,50022743,50023120,', 0),
(50025066, '其他电子防盗配件', 32, 50022743, 3, ',26,50014482,50022743,50025066,', 0),
(50022757, '车载音乐配件', 0, 50022744, 3, ',26,50014482,50022744,50022757,', 0),
(261713, '汽车音箱/低音炮', 1, 50022744, 3, ',26,50014482,50022744,261713,', 0),
(50008297, '车载CD机', 6, 50022744, 3, ',26,50014482,50022744,50008297,', 0),
(261710, '车载MP3/MP4', 8, 50022744, 3, ',26,50014482,50022744,261710,', 0),
(50003795, '汽车喇叭/高音头', 9, 50022744, 3, ',26,50014482,50022744,50003795,', 0),
(50003796, '汽车功放', 10, 50022744, 3, ',26,50014482,50022744,50003796,', 0),
(50017907, '车载碟盒', 11, 50022744, 3, ',26,50014482,50022744,50017907,', 0),
(50008299, '车载电脑/准系统', 20, 50022744, 3, ',26,50014482,50022744,50008299,', 0),
(50022878, '车用显示器', 21, 50022744, 3, ',26,50014482,50022744,50022878,', 0),
(50022879, '车用头枕屏', 22, 50022744, 3, ',26,50014482,50022744,50022879,', 0),
(50022883, '其它汽车影音产品', 23, 50022744, 3, ',26,50014482,50022744,50022883,', 0),
(50008298, '车载数字电视盒', 0, 50022745, 3, ',26,50014482,50022745,50008298,', 0),
(261709, '电源转换器', 3, 50022745, 3, ',26,50014482,50022745,261709,', 0),
(50004234, '点烟器/电源分配/逆变器', 5, 50022745, 3, ',26,50014482,50022745,50004234,', 0),
(261703, '车载蓝牙/免提电话', 5, 50022745, 3, ',26,50014482,50022745,261703,', 0),
(50000119, '电台/对讲设备/中继台', 6, 50022745, 3, ',26,50014482,50022745,50000119,', 0),
(261705, '车载吸尘器', 11, 50022745, 3, ',26,50014482,50022745,261705,', 0),
(261701, '车载冷暖箱', 12, 50022745, 3, ',26,50014482,50022745,261701,', 0),
(50010892, '汽车空调', 13, 50022745, 3, ',26,50014482,50022745,50010892,', 0),
(50011156, '车用电扇', 13, 50022745, 3, ',26,50014482,50022745,50011156,', 0),
(261712, '车用氧吧/空气净化器', 14, 50022745, 3, ',26,50014482,50022745,261712,', 0),
(50004233, '车载剃须刀', 22, 50022745, 3, ',26,50014482,50022745,50004233,', 0),
(50011418, '车载手机充电器', 24, 50022745, 3, ',26,50014482,50022745,50011418,', 0),
(50011858, '车载加热/保温杯', 39, 50022745, 3, ',26,50014482,50022745,50011858,', 0),
(50015467, '车用电器配件', 43, 50022745, 3, ',26,50014482,50022745,50015467,', 0),
(261706, '车载充气泵', 45, 50022745, 3, ',26,50014482,50022745,261706,', 0),
(50014725, '其它车用电器', 47, 50022745, 3, ',26,50014482,50022745,50014725,', 0),
(261711, '其它汽车电子用品', 49, 50022745, 3, ',26,50014482,50022745,261711,', 0),
(50018716, '车载电子产品配件', 50, 50022745, 3, ',26,50014482,50022745,50018716,', 0),
(50022753, '汽车车标', 0, 50022749, 3, ',26,50014481,50022749,50022753,', 0),
(50010665, '汽车装饰贴', 4, 50022749, 3, ',26,50014481,50022749,50010665,', 0),
(50012898, '犀牛皮保护贴膜', 7, 50022749, 3, ',26,50014481,50022749,50012898,', 0),
(50012891, '车牌架/牌照托', 20, 50022749, 3, ',26,50014481,50022749,50012891,', 0),
(50010893, '车用双面胶', 24, 50022749, 3, ',26,50014481,50022749,50010893,', 0),
(50022881, '其它外饰品', 25, 50022749, 3, ',26,50014481,50022749,50022881,', 0),
(50022754, '车门防护板/防护条', 0, 50022750, 3, ',26,50014481,50022750,50022754,', 0),
(50022755, '其它汽车防护用品', 1, 50022750, 3, ',26,50014481,50022750,50022755,', 0),
(50012889, '汽车车衣', 1, 50022750, 3, ',26,50014481,50022750,50012889,', 0),
(50008922, '底盘装甲', 4, 50022750, 3, ',26,50014481,50022750,50008922,', 0),
(50016076, '玻璃防爆隔热膜', 8, 50022750, 3, ',26,50014481,50022750,50016076,', 0),
(50012900, '防撞胶条', 11, 50022750, 3, ',26,50014481,50022750,50012900,', 0),
(50012890, '晴雨挡', 14, 50022750, 3, ',26,50014481,50022750,50012890,', 0),
(50004232, '汽车防静电用品', 23, 50022750, 3, ',26,50014481,50022750,50004232,', 0),
(50011823, '防滑链', 31, 50022750, 3, ',26,50014481,50022750,50011823,', 0),
(50019477, '车用密封胶条', 72, 50022750, 3, ',26,50014481,50022750,50019477,', 0),
(50014686, '车身装饰条', 0, 50022751, 3, ',26,50014481,50022751,50014686,', 0),
(50018706, '汽车装饰灯', 2, 50022751, 3, ',26,50014481,50022751,50018706,', 0),
(50016345, '汽车灯罩框', 3, 50022751, 3, ',26,50014481,50022751,50016345,', 0),
(50012895, '装饰性轮眉', 10, 50022751, 3, ',26,50014481,50022751,50012895,', 0),
(50012902, '尾喉/消声器', 17, 50022751, 3, ',26,50014481,50022751,50012902,', 0),
(50012896, '门腕', 30, 50022751, 3, ',26,50014481,50022751,50012896,', 0),
(50012919, '其它加装/装潢', 32, 50022751, 3, ',26,50014481,50022751,50012919,', 0),
(50022882, '灯眉', 33, 50022751, 3, ',26,50014481,50022751,50022882,', 0),
(50016288, '空气滤芯', 0, 50022759, 3, ',26,50018708,50022759,50016288,', 0),
(50015525, '机油滤芯', 5, 50022759, 3, ',26,50018708,50022759,50015525,', 0),
(50016289, '汽油滤芯', 7, 50022759, 3, ',26,50018708,50022759,50016289,', 0),
(50010627, '空调滤芯', 20, 50022759, 3, ',26,50018708,50022759,50010627,', 0),
(50012868, '玻璃升降器', 0, 50022760, 3, ',26,50018708,50022760,50012868,', 0),
(50022800, '车窗及其配件', 1, 50022760, 3, ',26,50018708,50022760,50022800,', 0),
(50012867, '天窗及配件', 2, 50022760, 3, ',26,50018708,50022760,50012867,', 0),
(50015614, '安全气囊/气囊电脑', 3, 50022760, 3, ',26,50018708,50022760,50015614,', 0),
(50014561, '方向盘', 5, 50022760, 3, ',26,50018708,50022760,50014561,', 0),
(50014694, '排挡杆', 6, 50022760, 3, ',26,50018708,50022760,50014694,', 0),
(50022801, '原厂烟灰缸', 7, 50022760, 3, ',26,50018708,50022760,50022801,', 0),
(50012104, '扶手箱', 8, 50022760, 3, ',26,50018708,50022760,50012104,', 0),
(50012872, '座椅及附件', 9, 50022760, 3, ',26,50018708,50022760,50012872,', 0),
(50018707, '倒车镜/后视镜', 10, 50022760, 3, ',26,50018708,50022760,50018707,', 0),
(50022803, '车内灯', 0, 50022764, 3, ',26,50018708,50022764,50022803,', 0),
(50014577, '车外灯', 2, 50022764, 3, ',26,50018708,50022764,50014577,', 0),
(50011637, 'HID氙气灯', 140, 50022764, 3, ',26,50018708,50022764,50011637,', 0),
(50016256, '氙气灯安定器', 141, 50022764, 3, ',26,50018708,50022764,50016256,', 0),
(50022831, '进气总管', 0, 50022768, 3, ',26,50018708,50022768,50022831,', 0),
(50022833, '进气歧管', 1, 50022768, 3, ',26,50018708,50022768,50022833,', 0),
(50022835, '排气歧管', 2, 50022768, 3, ',26,50018708,50022768,50022835,', 0),
(50012858, '排气管', 4, 50022768, 3, ',26,50018708,50022768,50012858,', 0),
(50016295, '三元催化', 5, 50022768, 3, ',26,50018708,50022768,50016295,', 0),
(50012866, '增压器', 6, 50022768, 3, ',26,50018708,50022768,50012866,', 0),
(50022837, '波箱电脑', 0, 50022769, 3, ',26,50018708,50022769,50022837,', 0),
(50015624, '离合器片/压盘/离合器分泵', 1, 50022769, 3, ',26,50018708,50022769,50015624,', 0),
(50022839, '飞轮及轴承', 2, 50022769, 3, ',26,50018708,50022769,50022839,', 0),
(50022841, '齿轮及摩擦片', 3, 50022769, 3, ',26,50018708,50022769,50022841,', 0),
(50022842, '变速箱/波箱/分动箱总成', 4, 50022769, 3, ',26,50018708,50022769,50022842,', 0),
(50022844, '变速箱/波箱/分动箱油封', 5, 50022769, 3, ',26,50018708,50022769,50022844,', 0),
(50014562, '其他变速箱系统配件', 18, 50022769, 3, ',26,50018708,50022769,50014562,', 0),
(50011914, '汽车钥匙', 0, 50022772, 3, ',26,50018708,50022772,50011914,', 0),
(50018709, '中控锁', 1, 50022772, 3, ',26,50018708,50022772,50018709,', 0),
(50010871, '方向盘锁', 38, 50022772, 3, ',26,50018708,50022772,50010871,', 0),
(50022846, '其他汽车防盗系统', 39, 50022772, 3, ',26,50018708,50022772,50022846,', 0),
(50022853, '点火器', 0, 50022774, 3, ',26,50018708,50022774,50022853,', 0),
(50012859, '火花塞', 1, 50022774, 3, ',26,50018708,50022774,50012859,', 0),
(50014560, '点火线圈', 15, 50022774, 3, ',26,50018708,50022774,50014560,', 0),
(50015617, '分电器', 50, 50022774, 3, ',26,50018708,50022774,50015617,', 0),
(50022854, '其他点火系统配件', 51, 50022774, 3, ',26,50018708,50022774,50022854,', 0),
(50025160, '高压线', 52, 50022774, 3, ',26,50018708,50022774,50025160,', 0),
(50022856, '油箱', 1, 50022775, 3, ',26,50018708,50022775,50022856,', 0),
(50012865, '喷油嘴', 2, 50022775, 3, ',26,50018708,50022775,50012865,', 0),
(50015594, '油泵', 26, 50022775, 3, ',26,50018708,50022775,50015594,', 0),
(50015602, '其他燃油供给配件', 41, 50022775, 3, ',26,50018708,50022775,50015602,', 0),
(50010785, '备用油箱', 0, 50022777, 3, ',26,50018708,50022777,50010785,', 0),
(50018712, '油箱盖', 1, 50022777, 3, ',26,50018708,50022777,50018712,', 0),
(50010600, '警示牌', 16, 50022777, 3, ',26,50018708,50022777,50010600,', 0),
(50012904, '备胎罩', 18, 50022777, 3, ',26,50018708,50022777,50012904,', 0),
(50019006, '电瓶搭火线', 18, 50022777, 3, ',26,50018708,50022777,50019006,', 0),
(50011155, '车轮锁/车位锁', 19, 50022777, 3, ',26,50018708,50022777,50011155,', 0),
(50012134, '轮毂盖', 19, 50022777, 3, ',26,50018708,50022777,50012134,', 0),
(50017165, '河南其他', 0, 50022894, 3, ',50025707,50017087,50022894,50017165,', 0),
(50022897, '郑州', 1, 50022894, 3, ',50025707,50017087,50022894,50022897,', 0),
(50022898, '开封', 2, 50022894, 3, ',50025707,50017087,50022894,50022898,', 0),
(50023118, '洛阳', 3, 50022894, 3, ',50025707,50017087,50022894,50023118,', 0),
(50023119, '新乡', 4, 50022894, 3, ',50025707,50017087,50022894,50023119,', 0),
(50023128, '焦作', 5, 50022894, 3, ',50025707,50017087,50022894,50023128,', 0),
(50023129, '平顶山', 6, 50022894, 3, ',50025707,50017087,50022894,50023129,', 0),
(50023168, '三门峡', 7, 50022894, 3, ',50025707,50017087,50022894,50023168,', 0),
(50017158, '黑龙江其他', 0, 50022902, 3, ',50025707,50017087,50022902,50017158,', 0),
(50022904, '哈尔滨', 1, 50022902, 3, ',50025707,50017087,50022902,50022904,', 0),
(50023130, '伊春', 2, 50022902, 3, ',50025707,50017087,50022902,50023130,', 0),
(50023131, '牡丹江', 3, 50022902, 3, ',50025707,50017087,50022902,50023131,', 0),
(50017157, '吉林其他', 0, 50022906, 3, ',50025707,50017087,50022906,50017157,', 0),
(50022908, '长春', 1, 50022906, 3, ',50025707,50017087,50022906,50022908,', 0),
(50022910, '吉林', 2, 50022906, 3, ',50025707,50017087,50022906,50022910,', 0),
(50022912, '白城', 3, 50022906, 3, ',50025707,50017087,50022906,50022912,', 0),
(50022914, '白山', 4, 50022906, 3, ',50025707,50017087,50022906,50022914,', 0),
(50022916, '延边', 5, 50022906, 3, ',50025707,50017087,50022906,50022916,', 0),
(50017163, '江西其他', 0, 50022918, 3, ',50025707,50017087,50022918,50017163,', 0),
(50022920, '南昌', 1, 50022918, 3, ',50025707,50017087,50022918,50022920,', 0),
(50022922, '景德镇', 2, 50022918, 3, ',50025707,50017087,50022918,50022922,', 0),
(50022924, '九江', 3, 50022918, 3, ',50025707,50017087,50022918,50022924,', 0),
(50022926, '吉安', 4, 50022918, 3, ',50025707,50017087,50022918,50022926,', 0),
(50023159, '赣州', 5, 50022918, 3, ',50025707,50017087,50022918,50023159,', 0),
(50023160, '宜春', 6, 50022918, 3, ',50025707,50017087,50022918,50023160,', 0),
(50024445, '鹰潭市', 7, 50022918, 3, ',50025707,50017087,50022918,50024445,', 0),
(50017154, '山西其他', 0, 50022928, 3, ',50025707,50017087,50022928,50017154,', 0),
(50022930, '太原', 1, 50022928, 3, ',50025707,50017087,50022928,50022930,', 0),
(50022932, '大同', 2, 50022928, 3, ',50025707,50017087,50022928,50022932,', 0),
(50023137, '运城', 3, 50022928, 3, ',50025707,50017087,50022928,50023137,', 0),
(50023138, '晋中', 4, 50022928, 3, ',50025707,50017087,50022928,50023138,', 0),
(50023139, '晋城', 5, 50022928, 3, ',50025707,50017087,50022928,50023139,', 0),
(50017156, '辽宁其他', 0, 50022934, 3, ',50025707,50017087,50022934,50017156,', 0),
(50022936, '沈阳', 1, 50022934, 3, ',50025707,50017087,50022934,50022936,', 0),
(50022938, '大连', 2, 50022934, 3, ',50025707,50017087,50022934,50022938,', 0),
(50023123, '本溪', 3, 50022934, 3, ',50025707,50017087,50022934,50023123,', 0),
(50023124, '丹东', 4, 50022934, 3, ',50025707,50017087,50022934,50023124,', 0),
(50023125, '锦州', 5, 50022934, 3, ',50025707,50017087,50022934,50023125,', 0),
(50023126, '鞍山', 6, 50022934, 3, ',50025707,50017087,50022934,50023126,', 0),
(50023127, '抚顺', 7, 50022934, 3, ',50025707,50017087,50022934,50023127,', 0),
(50017172, '贵州其他', 0, 50022940, 3, ',50025707,50017087,50022940,50017172,', 0),
(50022942, '贵阳', 1, 50022940, 3, ',50025707,50017087,50022940,50022942,', 0),
(50022944, '遵义', 2, 50022940, 3, ',50025707,50017087,50022940,50022944,', 0),
(50023132, '安顺', 3, 50022940, 3, ',50025707,50017087,50022940,50023132,', 0),
(50023133, '毕节', 4, 50022940, 3, ',50025707,50017087,50022940,50023133,', 0),
(50023134, '铜仁', 5, 50022940, 3, ',50025707,50017087,50022940,50023134,', 0),
(50017174, '西藏其他', 0, 50022946, 3, ',50025707,50017087,50022946,50017174,', 0),
(50022948, '拉萨', 1, 50022946, 3, ',50025707,50017087,50022946,50022948,', 0),
(50022950, '日喀则', 2, 50022946, 3, ',50025707,50017087,50022946,50022950,', 0),
(50022952, '山南', 3, 50022946, 3, ',50025707,50017087,50022946,50022952,', 0),
(50022954, '林芝', 4, 50022946, 3, ',50025707,50017087,50022946,50022954,', 0),
(50017176, '甘肃其他', 0, 50022956, 3, ',50025707,50017087,50022956,50017176,', 0),
(50022958, '兰州', 1, 50022956, 3, ',50025707,50017087,50022956,50022958,', 0),
(50022959, '嘉峪关', 2, 50022956, 3, ',50025707,50017087,50022956,50022959,', 0),
(50017177, '青海其他', 0, 50022961, 3, ',50025707,50017087,50022961,50017177,', 0),
(50022964, '西宁', 1, 50022961, 3, ',50025707,50017087,50022961,50022964,', 0),
(50017178, '宁夏其他', 0, 50022965, 3, ',50025707,50017087,50022965,50017178,', 0),
(50022967, '银川', 1, 50022965, 3, ',50025707,50017087,50022965,50022967,', 0),
(50022970, '中卫', 2, 50022965, 3, ',50025707,50017087,50022965,50022970,', 0),
(50017179, '新疆其他', 0, 50022971, 3, ',50025707,50017087,50022971,50017179,', 0),
(50022974, '乌鲁木齐', 1, 50022971, 3, ',50025707,50017087,50022971,50022974,', 0),
(50022975, '吐鲁番', 2, 50022971, 3, ',50025707,50017087,50022971,50022975,', 0),
(50022976, '喀什', 3, 50022971, 3, ',50025707,50017087,50022971,50022976,', 0),
(50017155, '内蒙古其他', 0, 50022978, 3, ',50025707,50017087,50022978,50017155,', 0),
(50022980, '呼和浩特', 1, 50022978, 3, ',50025707,50017087,50022978,50022980,', 0),
(50022982, '包头', 2, 50022978, 3, ',50025707,50017087,50022978,50022982,', 0),
(50022985, '锡林郭勒', 3, 50022978, 3, ',50025707,50017087,50022978,50022985,', 0),
(50023439, '婴儿手抓球', 1, 50023436, 3, ',25,50024048,50023436,50023439,', 0),
(50006802, '叠叠乐', 16, 50023436, 3, ',25,50024048,50023436,50006802,', 0),
(50013160, '不倒翁', 56, 50023436, 3, ',25,50024048,50023436,50013160,', 0),
(50013157, '床铃/床挂', 10, 50023440, 3, ',25,50024048,50023440,50013157,', 0),
(50013158, '摇铃', 11, 50023440, 3, ',25,50024048,50023440,50013158,', 0),
(50023779, '拨浪鼓', 13, 50023440, 3, ',25,50024048,50023440,50023779,', 0),
(50008827, '宝宝布书', 14, 50023440, 3, ',25,50024048,50023440,50008827,', 0),
(50023650, '幼儿布质/软胶积木', 15, 50023440, 3, ',25,50024048,50023440,50023650,', 0),
(50013174, '幼儿手偶/安抚玩偶', 25, 50023440, 3, ',25,50024048,50023440,50013174,', 0),
(50023446, '游戏毯/音乐毯', 0, 50023444, 3, ',25,50024048,50023444,50023446,', 0),
(50013169, '爬行垫', 8, 50023444, 3, ',25,50024048,50023444,50013169,', 0),
(50013159, '婴儿健身器', 14, 50023444, 3, ',25,50024048,50023444,50013159,', 0),
(50023496, '手推学步玩具', 57, 50023444, 3, ',25,50024048,50023444,50023496,', 0),
(50013176, '拖拉学步玩具', 58, 50023444, 3, ',25,50024048,50023444,50013176,', 0),
(50024609, '幼儿学爬玩具', 59, 50023444, 3, ',25,50024048,50023444,50024609,', 0),
(50016225, '沙画/胶画/其他画', 63, 50023497, 3, ',25,50023502,50023497,50016225,', 0),
(50023512, '魔法玉米', 64, 50023497, 3, ',25,50023502,50023497,50023512,', 0),
(50024603, '手工食品制作', 65, 50023497, 3, ',25,50023502,50023497,50024603,', 0),
(50023513, '手工创意粘贴类', 66, 50023497, 3, ',25,50023502,50023497,50023513,', 0),
(50023514, '手工折纸/剪纸书', 67, 50023497, 3, ',25,50023502,50023497,50023514,', 0),
(50023517, '白模填色/模具彩绘', 70, 50023497, 3, ',25,50023502,50023497,50023517,', 0),
(50024131, '织布机/手工编织/刺绣类', 71, 50023497, 3, ',25,50023502,50023497,50024131,', 0),
(50024132, '手工制作工具/彩纸/配件', 72, 50023497, 3, ',25,50023502,50023497,50024132,', 0),
(50023518, '其他手工制作', 73, 50023497, 3, ',25,50023502,50023497,50023518,', 0),
(50013172, '钓鱼类玩具', 0, 50023505, 3, ',25,50023504,50023505,50013172,', 0),
(50023653, '打地鼠/敲击果虫', 1, 50023505, 3, ',25,50023504,50023505,50023653,', 0),
(50023678, '敲打台/其他敲打玩具', 21, 50023505, 3, ',25,50023504,50023505,50023678,', 0),
(50006805, '多米诺骨牌', 22, 50023505, 3, ',25,50023504,50023505,50006805,', 0),
(50023532, '电动花剑整剑', 0, 50023526, 3, ',50010728,50023370,50023526,50023532,', 0),
(50023533, '训练花剑整剑', 1, 50023526, 3, ',50010728,50023370,50023526,50023533,', 0),
(50023534, '电动花剑条', 2, 50023526, 3, ',50010728,50023370,50023526,50023534,', 0),
(50023535, '训练花剑条', 3, 50023526, 3, ',50010728,50023370,50023526,50023535,', 0),
(50023536, '花剑套装', 4, 50023526, 3, ',50010728,50023370,50023526,50023536,', 0),
(50023537, '花剑剑服', 5, 50023526, 3, ',50010728,50023370,50023526,50023537,', 0),
(50023538, '花剑面罩', 6, 50023526, 3, ',50010728,50023370,50023526,50023538,', 0),
(50023539, '花剑手套', 7, 50023526, 3, ',50010728,50023370,50023526,50023539,', 0),
(50023540, '花剑零配', 8, 50023526, 3, ',50010728,50023370,50023526,50023540,', 0),
(50023541, '电动重剑整剑', 0, 50023527, 3, ',50010728,50023370,50023527,50023541,', 0),
(50023542, '训练重剑整剑', 1, 50023527, 3, ',50010728,50023370,50023527,50023542,', 0),
(50023543, '电动重剑条', 2, 50023527, 3, ',50010728,50023370,50023527,50023543,', 0),
(50023544, '训练重剑条', 3, 50023527, 3, ',50010728,50023370,50023527,50023544,', 0),
(50023545, '重剑套装', 4, 50023527, 3, ',50010728,50023370,50023527,50023545,', 0),
(50023546, '重剑剑服', 5, 50023527, 3, ',50010728,50023370,50023527,50023546,', 0),
(50023547, '重剑面罩', 6, 50023527, 3, ',50010728,50023370,50023527,50023547,', 0),
(50023548, '重剑手套', 7, 50023527, 3, ',50010728,50023370,50023527,50023548,', 0),
(50023549, '重剑零配', 8, 50023527, 3, ',50010728,50023370,50023527,50023549,', 0),
(50023550, '电动佩剑整剑', 0, 50023528, 3, ',50010728,50023370,50023528,50023550,', 0),
(50023551, '训练佩剑整剑', 1, 50023528, 3, ',50010728,50023370,50023528,50023551,', 0),
(50023552, '电动佩剑条', 2, 50023528, 3, ',50010728,50023370,50023528,50023552,', 0),
(50023553, '训练佩剑条', 3, 50023528, 3, ',50010728,50023370,50023528,50023553,', 0),
(50023554, '佩剑套装', 4, 50023528, 3, ',50010728,50023370,50023528,50023554,', 0),
(50023555, '佩剑剑服', 5, 50023528, 3, ',50010728,50023370,50023528,50023555,', 0),
(50023556, '佩剑面罩', 6, 50023528, 3, ',50010728,50023370,50023528,50023556,', 0),
(50023557, '佩剑手套', 7, 50023528, 3, ',50010728,50023370,50023528,50023557,', 0),
(50023558, '佩剑零配', 8, 50023528, 3, ',50010728,50023370,50023528,50023558,', 0),
(50023618, '电动/遥控车', 0, 50023605, 3, ',25,50007116,50023605,50023618,', 0),
(50023619, '电动/遥控轨道', 1, 50023605, 3, ',25,50007116,50023605,50023619,', 0),
(50023620, '电动/遥控飞机', 2, 50023605, 3, ',25,50007116,50023605,50023620,', 0),
(50023621, '电动/遥控船类', 3, 50023605, 3, ',25,50007116,50023605,50023621,', 0),
(50023622, '电动/遥控动物/人物', 4, 50023605, 3, ',25,50007116,50023605,50023622,', 0),
(50008836, '电动/遥控机器人', 6, 50023605, 3, ',25,50007116,50023605,50008836,', 0),
(50023642, '电动玩具枪', 7, 50023605, 3, ',25,50007116,50023605,50023642,', 0),
(50023624, '其他电动/遥控玩具', 9, 50023605, 3, ',25,50007116,50023605,50023624,', 0),
(50023626, '敲琴', 0, 50023625, 3, ',25,50008876,50023625,50023626,', 0),
(50013182, '音乐电话', 25, 50023625, 3, ',25,50008876,50023625,50013182,', 0),
(50023627, '幼儿电动手拍鼓', 26, 50023625, 3, ',25,50008876,50023625,50023627,', 0),
(50023628, '沙锤/沙蛋/沙球', 27, 50023625, 3, ',25,50008876,50023625,50023628,', 0),
(50008841, '电子琴玩具/儿童电子琴', 28, 50023625, 3, ',25,50008876,50023625,50008841,', 0),
(50023629, '儿童钢琴/玩具钢琴', 29, 50023625, 3, ',25,50008876,50023625,50023629,', 0),
(50023801, '儿童架子鼓', 30, 50023625, 3, ',25,50008876,50023625,50023801,', 0),
(50023630, '玩具小提琴/手风琴', 31, 50023625, 3, ',25,50008876,50023625,50023630,', 0),
(50023631, '玩具吉他', 32, 50023625, 3, ',25,50008876,50023625,50023631,', 0),
(50023803, '儿童音乐话筒', 33, 50023625, 3, ',25,50008876,50023625,50023803,', 0),
(50023780, '铃类乐器', 34, 50023625, 3, ',25,50008876,50023625,50023780,', 0),
(50023632, '儿童打击乐器', 35, 50023625, 3, ',25,50008876,50023625,50023632,', 0),
(50023633, '儿童吹奏玩具/乐器', 36, 50023625, 3, ',25,50008876,50023625,50023633,', 0),
(50007120, '八音盒/音乐盒', 38, 50023625, 3, ',25,50008876,50023625,50007120,', 0),
(50023634, '儿童乐器套装', 39, 50023625, 3, ',25,50008876,50023625,50023634,', 0),
(50007118, '其他音乐玩具/儿童乐器', 40, 50023625, 3, ',25,50008876,50023625,50007118,', 0),
(50023636, '电子游戏机/俄罗斯方块机', 0, 50023635, 3, ',25,50024050,50023635,50023636,', 0),
(50023802, '儿童对讲机', 8, 50023635, 3, ',25,50024050,50023635,50023802,', 0),
(50015133, '儿童卡通电子表', 49, 50023635, 3, ',25,50024050,50023635,50015133,', 0),
(50023637, '电子机械虫', 50, 50023635, 3, ',25,50024050,50023635,50023637,', 0),
(50023638, '电子宠物机', 51, 50023635, 3, ',25,50024050,50023635,50023638,', 0),
(50023781, '儿童数码照相机', 52, 50023635, 3, ',25,50024050,50023635,50023781,', 0),
(50023639, '其他电子玩具', 55, 50023635, 3, ',25,50024050,50023635,50023639,', 0),
(250804, '其他发光玩具', 0, 50023644, 3, ',25,50024050,50023644,250804,', 0),
(50013980, '安睡灯/投影灯', 50, 50023644, 3, ',25,50024050,50023644,50013980,', 0),
(50013058, '木制堆搭积木', 0, 50023647, 3, ',25,50023504,50023647,50013058,', 0),
(50013055, '磁性积木', 3, 50023647, 3, ',25,50023504,50023647,50013055,', 0),
(50013821, '塑料/胶制拼插积木', 9, 50023647, 3, ',25,50023504,50023647,50013821,', 0),
(50017904, '电子/电路积木', 10, 50023647, 3, ',25,50023504,50023647,50017904,', 0),
(50023649, 'EVA/泡沫积木', 12, 50023647, 3, ',25,50023504,50023647,50023649,', 0),
(50023651, '模型/情景组装积木', 14, 50023647, 3, ',25,50023504,50023647,50023651,', 0),
(50008778, '动感电动积木', 15, 50023647, 3, ',25,50023504,50023647,50008778,', 0),
(50023652, '其他积木', 16, 50023647, 3, ',25,50023504,50023647,50023652,', 0),
(50023791, '形状配对扭扭蛋', 22, 50023673, 3, ',25,50023504,50023673,50023791,', 0),
(50023792, '螺丝形状配对玩具', 23, 50023673, 3, ',25,50023504,50023673,50023792,', 0),
(50013060, '数字屋/形状盒/多孔认知玩具', 24, 50023673, 3, ',25,50023504,50023673,50013060,', 0),
(50024217, '几何形状套柱', 25, 50023673, 3, ',25,50023504,50023673,50024217,', 0),
(50013173, '其他形状认知/配对玩具', 26, 50023673, 3, ',25,50023504,50023673,50013173,', 0),
(50023689, '颜料', 0, 50023679, 3, ',25,50015127,50023679,50023689,', 0),
(50023691, '画笔/画刷', 1, 50023679, 3, ',25,50015127,50023679,50023691,', 0),
(50023692, '调色盘', 2, 50023679, 3, ',25,50015127,50023679,50023692,', 0),
(50023694, '颜料绘画组合', 3, 50023679, 3, ',25,50015127,50023679,50023694,', 0),
(50023693, '其他颜料绘画相关', 4, 50023679, 3, ',25,50015127,50023679,50023693,', 0),
(50023702, '串珠', 0, 50023701, 3, ',25,50023504,50023701,50023702,', 0),
(50023703, '绕珠', 1, 50023701, 3, ',25,50023504,50023701,50023703,', 0),
(50023704, '百变插珠', 2, 50023701, 3, ',25,50023504,50023701,50023704,', 0),
(50023705, '蘑菇钉/十字绣插钉', 3, 50023701, 3, ',25,50023504,50023701,50023705,', 0),
(50023790, '穿线板/穿线玩具', 4, 50023701, 3, ',25,50023504,50023701,50023790,', 0),
(50014621, '汽车升降机', 2, 50014511, 3, ',26,50014479,50014511,50014621,', 0),
(50014622, '四轮定位仪', 3, 50014511, 3, ',26,50014479,50014511,50014622,', 0),
(50014623, '扒胎机', 4, 50014511, 3, ',26,50014479,50014511,50014623,', 0),
(50014579, '维修灯', 4, 50014511, 3, ',26,50014479,50014511,50014579,', 0),
(50014624, '轮胎平衡仪', 5, 50014511, 3, ',26,50014479,50014511,50014624,', 0),
(50014625, '氮气充气机', 6, 50014511, 3, ',26,50014479,50014511,50014625,', 0),
(50016440, '空气压缩机', 9, 50014511, 3, ',26,50014479,50014511,50016440,', 0),
(50014571, '千斤顶', 10, 50014511, 3, ',26,50014479,50014511,50014571,', 0),
(50014899, '其它汽车维修/工具', 13, 50014511, 3, ',26,50014479,50014511,50014899,', 0),
(50018717, '拖车绳/网/绑带', 14, 50014511, 3, ',26,50014479,50014511,50018717,', 0),
(50015864, '安全锤工具', 17, 50014511, 3, ',26,50014479,50014511,50015864,', 0),
(50018941, '滤清磁铁', 31, 50014511, 3, ',26,50014479,50014511,50018941,', 0),
(50010596, '司机护目镜', 0, 50014522, 3, ',26,50014480,50014522,50010596,', 0),
(50014570, '急救包', 0, 50014522, 3, ',26,50014480,50014522,50014570,', 0),
(50017632, '年检车贴', 5, 50014522, 3, ',26,50014480,50014522,50017632,', 0),
(50015875, '车用挂钩', 7, 50014522, 3, ',26,50014480,50014522,50015875,', 0),
(261707, '气压表/胎压表', 8, 50014522, 3, ',26,50014480,50014522,261707,', 0),
(50012106, '车用钥匙扣', 10, 50014522, 3, ',26,50014480,50014522,50012106,', 0),
(50012107, '车用钥匙包', 11, 50014522, 3, ',26,50014480,50014522,50012107,', 0),
(50012111, '方向盘助力器', 15, 50014522, 3, ',26,50014480,50014522,50012111,', 0),
(50010599, '车用灭火器', 15, 50014522, 3, ',26,50014480,50014522,50010599,', 0),
(50012112, '车用电子钟表', 15, 50014522, 3, ',26,50014480,50014522,50012112,', 0),
(50016251, '车用票据夹', 15, 50014522, 3, ',26,50014480,50014522,50016251,', 0),
(50016331, '越野平衡仪', 16, 50014522, 3, ',26,50014480,50014522,50016331,', 0),
(50012110, '车用指南针/指南球', 20, 50014522, 3, ',26,50014480,50014522,50012110,', 0),
(50005817, '酒精测试仪', 20, 50014522, 3, ',26,50014480,50014522,50005817,', 0),
(50015536, '多功能手电', 22, 50014522, 3, ',26,50014480,50014522,50015536,', 0),
(50016325, '车用纸巾盒/套', 22, 50014522, 3, ',26,50014480,50014522,50016325,', 0),
(50016324, '车用纸巾', 23, 50014522, 3, ',26,50014480,50014522,50016324,', 0),
(50012119, '车用眼镜夹', 25, 50014522, 3, ',26,50014480,50014522,50012119,', 0),
(50012120, '车用水杯架/手机座', 26, 50014522, 3, ',26,50014480,50014522,50012120,', 0),
(50012121, '车用笔记本架', 27, 50014522, 3, ',26,50014480,50014522,50012121,', 0),
(50012122, '车用衣服架', 28, 50014522, 3, ',26,50014480,50014522,50012122,', 0),
(50012123, '车用烟灰缸', 29, 50014522, 3, ',26,50014480,50014522,50012123,', 0),
(50012127, '驾驶证件套', 33, 50014522, 3, ',26,50014480,50014522,50012127,', 0),
(50014647, '其它驾车个人用品', 36, 50014522, 3, ',26,50014480,50014522,50014647,', 0),
(50014798, '羽绒衣', 0, 50014680, 3, ',50013886,50013888,50014680,50014798,', 0),
(50019541, '羽绒裤', 1, 50014680, 3, ',50013886,50013888,50014680,50019541,', 0),
(50019543, '羽绒衣裤套装', 4, 50014680, 3, ',50013886,50013888,50014680,50019543,', 0),
(50014802, '户外休闲衣', 0, 50014792, 3, ',50013886,50013888,50014792,50014802,', 0),
(50014803, '户外休闲裤', 1, 50014792, 3, ',50013886,50013888,50014792,50014803,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50015984, '户外休闲衣裤套装', 2, 50014792, 3, ',50013886,50013888,50014792,50015984,', 0),
(50015389, '山地车', 0, 50014817, 3, ',50010728,2612,50014817,50015389,', 0),
(50015390, '公路车', 1, 50014817, 3, ',50010728,2612,50014817,50015390,', 0),
(50015391, '旅行车', 2, 50014817, 3, ',50010728,2612,50014817,50015391,', 0),
(50015392, '普通车', 3, 50014817, 3, ',50010728,2612,50014817,50015392,', 0),
(50015393, '小轮攀爬车', 4, 50014817, 3, ',50010728,2612,50014817,50015393,', 0),
(50015394, '其它二手自行车', 6, 50014817, 3, ',50010728,2612,50014817,50015394,', 0),
(50008284, '地毯/地垫定制', 3, 50014934, 3, ',50025004,50025007,50014934,50008284,', 0),
(50008094, '相框/画框定制', 3, 50014934, 3, ',50025004,50025007,50014934,50008094,', 0),
(50015296, '其它居家装饰定制', 4, 50014934, 3, ',50025004,50025007,50014934,50015296,', 0),
(50020247, '杯垫/花片', 5, 50014934, 3, ',50025004,50025007,50014934,50020247,', 0),
(50025056, '铁艺定制', 6, 50014934, 3, ',50025004,50025007,50014934,50025056,', 0),
(50025057, '音乐盒定制', 7, 50014934, 3, ',50025004,50025007,50014934,50025057,', 0),
(50015298, '木版画/装饰画', 23, 50014934, 3, ',50025004,50025007,50014934,50015298,', 0),
(50014978, '家居产品设计', 0, 50014937, 3, ',50025004,50014854,50014937,50014978,', 0),
(50014979, '礼品/工艺品/饰品设计', 1, 50014937, 3, ',50025004,50014854,50014937,50014979,', 0),
(50014980, '数码/电脑产品设计', 2, 50014937, 3, ',50025004,50014854,50014937,50014980,', 0),
(50014984, '通信产品设计', 3, 50014937, 3, ',50025004,50014854,50014937,50014984,', 0),
(50014985, '照明灯具设计', 4, 50014937, 3, ',50025004,50014854,50014937,50014985,', 0),
(50014986, '仪器仪表设计', 5, 50014937, 3, ',50025004,50014854,50014937,50014986,', 0),
(50014987, '机械设计', 6, 50014937, 3, ',50025004,50014854,50014937,50014987,', 0),
(50014989, '汽车及配件设计', 7, 50014937, 3, ',50025004,50014854,50014937,50014989,', 0),
(50014990, '五金/工具设计', 8, 50014937, 3, ',50025004,50014854,50014937,50014990,', 0),
(50014991, '电工电器设计', 9, 50014937, 3, ',50025004,50014854,50014937,50014991,', 0),
(50014992, '玩具/玩偶设计', 10, 50014937, 3, ',50025004,50014854,50014937,50014992,', 0),
(50014993, '其他工业设计', 11, 50014937, 3, ',50025004,50014854,50014937,50014993,', 0),
(50014994, '装潢设计', 0, 50014939, 3, ',50025004,50014854,50014939,50014994,', 0),
(50014995, '家电布线设计', 1, 50014939, 3, ',50025004,50014854,50014939,50014995,', 0),
(50014996, '建筑及模型设计', 2, 50014939, 3, ',50025004,50014854,50014939,50014996,', 0),
(50014997, '宣传册设计', 0, 50014942, 3, ',50025004,50014854,50014942,50014997,', 0),
(50020188, '画册/杂志/书籍装帧设计', 1, 50014942, 3, ',50025004,50014854,50014942,50020188,', 0),
(50014998, '商标logo设计', 2, 50014942, 3, ',50025004,50014854,50014942,50014998,', 0),
(50014999, '店面招牌', 3, 50014942, 3, ',50025004,50014854,50014942,50014999,', 0),
(50015000, '企业形象VI设计', 4, 50014942, 3, ',50025004,50014854,50014942,50015000,', 0),
(50015001, '包装设计', 5, 50014942, 3, ',50025004,50014854,50014942,50015001,', 0),
(50015002, '名片设计', 6, 50014942, 3, ',50025004,50014854,50014942,50015002,', 0),
(50019989, '平面广告设计', 7, 50014942, 3, ',50025004,50014854,50014942,50019989,', 0),
(50015104, '软陶人偶', 0, 50014943, 3, ',50025004,50025011,50014943,50015104,', 0),
(50015105, '立体人面公仔', 1, 50014943, 3, ',50025004,50025011,50014943,50015105,', 0),
(50018431, '其他玩偶定制', 2, 50014943, 3, ',50025004,50025011,50014943,50018431,', 0),
(50015150, '地埋旋转喷头', 0, 50015149, 3, ',50007216,50007010,50015149,50015150,', 0),
(50015151, '地埋散射喷头', 1, 50015149, 3, ',50007216,50007010,50015149,50015151,', 0),
(50015152, '水枪', 2, 50015149, 3, ',50007216,50007010,50015149,50015152,', 0),
(50015153, '水车架', 3, 50015149, 3, ',50007216,50007010,50015149,50015153,', 0),
(50015154, '接头等配件', 4, 50015149, 3, ',50007216,50007010,50015149,50015154,', 0),
(50015155, '高压清洗机', 5, 50015149, 3, ',50007216,50007010,50015149,50015155,', 0),
(50015157, '10米清洗套装', 7, 50015149, 3, ',50007216,50007010,50015149,50015157,', 0),
(50015158, '15米清洗套装', 8, 50015149, 3, ',50007216,50007010,50015149,50015158,', 0),
(50015159, '20米清洗套装', 9, 50015149, 3, ',50007216,50007010,50015149,50015159,', 0),
(50015160, '30米清洗套装', 10, 50015149, 3, ',50007216,50007010,50015149,50015160,', 0),
(50015161, '清洗刷', 11, 50015149, 3, ',50007216,50007010,50015149,50015161,', 0),
(50015164, '雾化微喷/滴灌设备', 0, 50015163, 3, ',50007216,50007010,50015163,50015164,', 0),
(50015165, '常用简易接头', 1, 50015163, 3, ',50007216,50007010,50015163,50015165,', 0),
(50015166, '毛管/PE管', 2, 50015163, 3, ',50007216,50007010,50015163,50015166,', 0),
(50015168, '金属摇臂喷头', 0, 50015167, 3, ',50007216,50007010,50015167,50015168,', 0),
(50015169, '塑料摇臂喷头', 1, 50015167, 3, ',50007216,50007010,50015167,50015169,', 0),
(50015170, '喷泉/水景景观喷头', 2, 50015167, 3, ',50007216,50007010,50015167,50015170,', 0),
(50015181, '取水阀', 0, 50015171, 3, ',50007216,50007010,50015171,50015181,', 0),
(50015182, '千秋架', 1, 50015171, 3, ',50007216,50007010,50015171,50015182,', 0),
(50015183, '阀门箱', 2, 50015171, 3, ',50007216,50007010,50015171,50015183,', 0),
(50015184, '过滤器', 3, 50015171, 3, ',50007216,50007010,50015171,50015184,', 0),
(50015185, '控制器', 4, 50015171, 3, ',50007216,50007010,50015171,50015185,', 0),
(50015186, '感应器', 5, 50015171, 3, ',50007216,50007010,50015171,50015186,', 0),
(50015187, '电磁阀', 6, 50015171, 3, ',50007216,50007010,50015171,50015187,', 0),
(50015233, '遮阳伞', 0, 50015231, 3, ',50008164,50015230,50015231,50015233,', 0),
(50015234, '伞坐', 1, 50015231, 3, ',50008164,50015230,50015231,50015234,', 0),
(50015236, '公园椅', 1, 50015232, 3, ',50008164,50015230,50015232,50015236,', 0),
(50005526, '户外秋千', 3, 50015232, 3, ',50008164,50015230,50015232,50005526,', 0),
(50015240, '沙滩桌', 0, 50015239, 3, ',50008164,50015230,50015239,50015240,', 0),
(50015241, '公园桌', 1, 50015239, 3, ',50008164,50015230,50015239,50015241,', 0),
(50015244, '吊床', 0, 50015243, 3, ',50008164,50015230,50015243,50015244,', 0),
(50015245, '沙滩床', 1, 50015243, 3, ',50008164,50015230,50015243,50015245,', 0),
(50015246, '折叠床', 2, 50015243, 3, ',50008164,50015230,50015243,50015246,', 0),
(211508, '办公电脑桌', 2, 50015435, 3, ',50020611,211503,50015435,211508,', 0),
(50001391, '大班台/主管桌', 3, 50015435, 3, ',50020611,211503,50015435,50001391,', 0),
(50015437, '组合/屏风工作位', 3, 50015435, 3, ',50020611,211503,50015435,50015437,', 0),
(50001393, '会议桌', 5, 50015435, 3, ',50020611,211503,50015435,50001393,', 0),
(50015439, '阅览桌', 5, 50015435, 3, ',50020611,211503,50015435,50015439,', 0),
(50023073, '中班台（新增）', 6, 50015435, 3, ',50020611,211503,50015435,50023073,', 0),
(50023074, '前台/接待台（新增）', 7, 50015435, 3, ',50020611,211503,50015435,50023074,', 0),
(50023075, '培训台', 8, 50015435, 3, ',50020611,211503,50015435,50023075,', 0),
(50015504, '桌子配件', 9, 50015435, 3, ',50020611,211503,50015435,50015504,', 0),
(50023273, '演讲台', 10, 50015435, 3, ',50020611,211503,50015435,50023273,', 0),
(50015442, '沙发', 0, 50015441, 3, ',50020611,211503,50015441,50015442,', 0),
(50015443, '茶几', 1, 50015441, 3, ',50020611,211503,50015441,50015443,', 0),
(50015506, '沙发配件', 3, 50015441, 3, ',50020611,211503,50015441,50015506,', 0),
(50015446, '中班椅', 1, 50015444, 3, ',50020611,211503,50015444,50015446,', 0),
(50001392, '大班椅/老板椅', 2, 50015444, 3, ',50020611,211503,50015444,50001392,', 0),
(50015454, '会议椅/会客椅', 3, 50015444, 3, ',50020611,211503,50015444,50015454,', 0),
(50015459, '前台椅/吧椅', 4, 50015444, 3, ',50020611,211503,50015444,50015459,', 0),
(50015472, '休闲椅', 5, 50015444, 3, ',50020611,211503,50015444,50015472,', 0),
(50022995, '培训椅（新增）', 11, 50015444, 3, ',50020611,211503,50015444,50022995,', 0),
(50022997, '接待椅（新增）', 13, 50015444, 3, ',50020611,211503,50015444,50022997,', 0),
(50015479, '椅子配件', 19, 50015444, 3, ',50020611,211503,50015444,50015479,', 0),
(50015482, '餐椅', 0, 50015461, 3, ',50008164,50015455,50015461,50015482,', 0),
(50015483, '沙发椅', 1, 50015461, 3, ',50008164,50015455,50015461,50015483,', 0),
(50001400, '职员椅/电脑椅', 3, 50015461, 3, ',50008164,50015455,50015461,50001400,', 0),
(50015485, '按摩椅', 4, 50015461, 3, ',50008164,50015455,50015461,50015485,', 0),
(50015489, '摇椅', 7, 50015461, 3, ',50008164,50015455,50015461,50015489,', 0),
(50015835, '儿童椅', 8, 50015461, 3, ',50008164,50015455,50015461,50015835,', 0),
(50015490, '折叠椅/躺椅', 8, 50015461, 3, ',50008164,50015455,50015461,50015490,', 0),
(50015488, '围椅', 11, 50015461, 3, ',50008164,50015455,50015461,50015488,', 0),
(50015487, '交椅', 12, 50015461, 3, ',50008164,50015455,50015461,50015487,', 0),
(50022470, '圈椅', 23, 50015461, 3, ',50008164,50015455,50015461,50022470,', 0),
(50015946, '其它椅子', 24, 50015461, 3, ',50008164,50015455,50015461,50015946,', 0),
(50015491, '躺椅', 25, 50015461, 3, ',50008164,50015455,50015461,50015491,', 0),
(50015484, '转椅', 26, 50015461, 3, ',50008164,50015455,50015461,50015484,', 0),
(50003711, '充气凳', 0, 50015462, 3, ',50008164,50015455,50015462,50003711,', 0),
(50015494, '矮凳', 1, 50015462, 3, ',50008164,50015455,50015462,50015494,', 0),
(50015502, '贵妃榻', 1, 50015462, 3, ',50008164,50015455,50015462,50015502,', 0),
(50015495, '梳妆凳', 2, 50015462, 3, ',50008164,50015455,50015462,50015495,', 0),
(50015496, '换鞋凳', 3, 50015462, 3, ',50008164,50015455,50015462,50015496,', 0),
(50015498, '鼓墩/绣墩', 6, 50015462, 3, ',50008164,50015455,50015462,50015498,', 0),
(50015836, '儿童凳', 8, 50015462, 3, ',50008164,50015455,50015462,50015836,', 0),
(50001727, '折叠凳', 23, 50015462, 3, ',50008164,50015455,50015462,50001727,', 0),
(50018250, '床尾凳', 24, 50015462, 3, ',50008164,50015455,50015462,50018250,', 0),
(50015948, '其它凳子', 25, 50015462, 3, ',50008164,50015455,50015462,50015948,', 0),
(50015476, '办公屏风/隔断', 0, 50015474, 3, ',50020611,211503,50015474,50015476,', 0),
(50015475, '高隔断/隔墙', 0, 50015474, 3, ',50020611,211503,50015474,50015475,', 0),
(50015511, '餐桌椅系列', 0, 50015510, 3, ',50020611,211503,50015510,50015511,', 0),
(50015512, '排椅系列', 1, 50015510, 3, ',50020611,211503,50015510,50015512,', 0),
(50015514, '休闲椅系列', 2, 50015510, 3, ',50020611,211503,50015510,50015514,', 0),
(50015515, '等候椅系列', 3, 50015510, 3, ',50020611,211503,50015510,50015515,', 0),
(50015516, '剧院椅系列', 4, 50015510, 3, ',50020611,211503,50015510,50015516,', 0),
(50015643, '旋转件', 0, 50015638, 3, ',50008164,50015455,50015638,50015643,', 0),
(50015644, '连接杆', 1, 50015638, 3, ',50008164,50015455,50015638,50015644,', 0),
(50015646, '椅脚', 3, 50015638, 3, ',50008164,50015455,50015638,50015646,', 0),
(50015647, '其它椅子配件', 4, 50015638, 3, ',50008164,50015455,50015638,50015647,', 0),
(50015648, '线盒', 0, 50015639, 3, ',50008164,50008280,50015639,50015648,', 0),
(50015649, '塑胶封边条', 1, 50015639, 3, ',50008164,50008280,50015639,50015649,', 0),
(50015650, '其它桌子配件', 2, 50015639, 3, ',50008164,50008280,50015639,50015650,', 0),
(50015657, '铰链(合页)', 0, 50015642, 3, ',50008164,50001705,50015642,50015657,', 0),
(50015658, '抽屉滑轨', 1, 50015642, 3, ',50008164,50001705,50015642,50015658,', 0),
(50015659, '移门路轨', 2, 50015642, 3, ',50008164,50001705,50015642,50015659,', 0),
(50015660, '液压秆', 3, 50015642, 3, ',50008164,50001705,50015642,50015660,', 0),
(50015661, '拉手', 4, 50015642, 3, ',50008164,50001705,50015642,50015661,', 0),
(50015662, '柜脚', 5, 50015642, 3, ',50008164,50001705,50015642,50015662,', 0),
(50015663, '衣管托', 6, 50015642, 3, ',50008164,50001705,50015642,50015663,', 0),
(50015664, '衣柜挂衣秆', 7, 50015642, 3, ',50008164,50001705,50015642,50015664,', 0),
(50015665, '防尘胶条', 8, 50015642, 3, ',50008164,50001705,50015642,50015665,', 0),
(50015666, '塑料孔塞盖', 9, 50015642, 3, ',50008164,50001705,50015642,50015666,', 0),
(50015667, '螺丝', 10, 50015642, 3, ',50008164,50001705,50015642,50015667,', 0),
(50015668, '轴承', 11, 50015642, 3, ',50008164,50001705,50015642,50015668,', 0),
(50015669, '衣钩', 12, 50015642, 3, ',50008164,50001705,50015642,50015669,', 0),
(50015670, '其它柜子配件', 13, 50015642, 3, ',50008164,50001705,50015642,50015670,', 0),
(50015783, '茶几+电视柜', 1, 50015774, 3, ',50008164,50015771,50015774,50015783,', 0),
(50015784, '沙发+茶几+电视柜', 2, 50015774, 3, ',50008164,50015771,50015774,50015784,', 0),
(50015785, '沙发+茶几+电视柜+角几', 3, 50015774, 3, ',50008164,50015771,50015774,50015785,', 0),
(50015786, '沙发+角几', 4, 50015774, 3, ',50008164,50015771,50015774,50015786,', 0),
(50005519, '沙发+茶几', 9, 50015774, 3, ',50008164,50015771,50015774,50005519,', 0),
(50015788, '餐桌椅+餐边柜', 1, 50015775, 3, ',50008164,50015771,50015775,50015788,', 0),
(50015789, '餐桌椅+酒柜', 2, 50015775, 3, ',50008164,50015771,50015775,50015789,', 0),
(50015790, '餐桌椅+餐车', 3, 50015775, 3, ',50008164,50015771,50015775,50015790,', 0),
(50015791, '餐桌椅+餐边柜+酒柜', 4, 50015775, 3, ',50008164,50015771,50015775,50015791,', 0),
(50015792, '餐桌椅+酒柜+餐车', 5, 50015775, 3, ',50008164,50015771,50015775,50015792,', 0),
(50015793, '餐桌椅+餐边柜+餐车', 6, 50015775, 3, ',50008164,50015771,50015775,50015793,', 0),
(50015794, '餐桌椅+餐边柜+酒柜+餐车', 7, 50015775, 3, ',50008164,50015771,50015775,50015794,', 0),
(50015795, '餐边柜+酒架', 8, 50015775, 3, ',50008164,50015771,50015775,50015795,', 0),
(50015796, '餐桌椅+酒架', 9, 50015775, 3, ',50008164,50015771,50015775,50015796,', 0),
(50001734, '餐桌+餐椅', 11, 50015775, 3, ',50008164,50015771,50015775,50001734,', 0),
(50008287, '双人床+床头柜', 0, 50015776, 3, ',50008164,50015771,50015776,50008287,', 0),
(50015798, '单人床+床头柜', 1, 50015776, 3, ',50008164,50015771,50015776,50015798,', 0),
(50015799, '双层床+写字桌', 2, 50015776, 3, ',50008164,50015771,50015776,50015799,', 0),
(50015800, '双人床+床头柜+衣柜', 3, 50015776, 3, ',50008164,50015771,50015776,50015800,', 0),
(50015801, '单人床+床头柜+衣柜', 4, 50015776, 3, ',50008164,50015771,50015776,50015801,', 0),
(50015802, '双层床+写字桌+衣柜', 5, 50015776, 3, ',50008164,50015771,50015776,50015802,', 0),
(50015803, '双人床+床头柜+梳妆台', 6, 50015776, 3, ',50008164,50015771,50015776,50015803,', 0),
(50015804, '单人床+床头柜+梳妆台', 7, 50015776, 3, ',50008164,50015771,50015776,50015804,', 0),
(50015805, '双人床+床头柜+梳妆台+衣柜', 8, 50015776, 3, ',50008164,50015771,50015776,50015805,', 0),
(50005522, '梳妆台+梳妆凳', 8, 50015776, 3, ',50008164,50015771,50015776,50005522,', 0),
(50015806, '单人床+床头柜+梳妆台+衣柜', 9, 50015776, 3, ',50008164,50015771,50015776,50015806,', 0),
(50015809, '书桌椅+书柜', 1, 50015777, 3, ',50008164,50015771,50015777,50015809,', 0),
(50015810, '书桌椅+书柜+休闲沙发', 2, 50015777, 3, ',50008164,50015771,50015777,50015810,', 0),
(50001731, '书桌+写字椅', 10, 50015777, 3, ',50008164,50015771,50015777,50001731,', 0),
(50015811, '玄关台+门厅柜+衣帽架', 0, 50015778, 3, ',50008164,50015771,50015778,50015811,', 0),
(50015812, '门厅柜+鞋柜', 1, 50015778, 3, ',50008164,50015771,50015778,50015812,', 0),
(50015813, '隔断+ 鞋柜', 2, 50015778, 3, ',50008164,50015771,50015778,50015813,', 0),
(50001715, '单个书柜', 0, 50015885, 3, ',50008164,50001705,50015885,50001715,', 0),
(50015887, '连体书桌柜', 1, 50015885, 3, ',50008164,50001705,50015885,50015887,', 0),
(50015958, '咖啡粉', 1, 50015956, 3, ',50026316,210605,50015956,50015958,', 0),
(50002255, '咖啡豆', 1, 50015956, 3, ',50026316,210605,50015956,50002255,', 0),
(50002257, '奶精', 0, 50015962, 3, ',50026316,210605,50015962,50002257,', 0),
(50015963, '奶油球', 1, 50015962, 3, ',50026316,210605,50015962,50015963,', 0),
(50015964, '糖浆', 2, 50015962, 3, ',50026316,210605,50015962,50015964,', 0),
(50015965, '白砂糖包', 3, 50015962, 3, ',50026316,210605,50015962,50015965,', 0),
(50015966, '黄糖包', 4, 50015962, 3, ',50026316,210605,50015962,50015966,', 0),
(50015967, '肉桂粉', 5, 50015962, 3, ',50026316,210605,50015962,50015967,', 0),
(50016049, '布艺材料', 0, 50015993, 3, ',25,50008737,50015993,50016049,', 0),
(50016087, '十字绣', 1, 50015993, 3, ',25,50008737,50015993,50016087,', 0),
(50016050, '不织布', 2, 50015993, 3, ',25,50008737,50015993,50016050,', 0),
(50016051, '白模/染料/笔', 3, 50015993, 3, ',25,50008737,50015993,50016051,', 0),
(50016052, '软陶', 4, 50015993, 3, ',25,50008737,50015993,50016052,', 0),
(50016053, '木制', 5, 50015993, 3, ',25,50008737,50015993,50016053,', 0),
(50016054, '金属', 6, 50015993, 3, ',25,50008737,50015993,50016054,', 0),
(50016055, '纸质', 7, 50015993, 3, ',25,50008737,50015993,50016055,', 0),
(50016056, '贴片系列', 8, 50015993, 3, ',25,50008737,50015993,50016056,', 0),
(50016057, '模具', 9, 50015993, 3, ',25,50008737,50015993,50016057,', 0),
(50016011, '杂技用具', 14, 50015995, 3, ',25,50015994,50015995,50016011,', 0),
(50016013, '魔术套装', 15, 50015995, 3, ',25,50015994,50015995,50016013,', 0),
(50016014, '魔术道具', 16, 50015995, 3, ',25,50015994,50015995,50016014,', 0),
(50016015, '魔术教学', 17, 50015995, 3, ',25,50015994,50015995,50016015,', 0),
(50016016, '服饰', 0, 50015996, 3, ',25,50015994,50015996,50016016,', 0),
(50016018, '面具', 1, 50015996, 3, ',25,50015994,50015996,50016018,', 0),
(50016019, '头饰', 2, 50015996, 3, ',25,50015994,50015996,50016019,', 0),
(50016021, '翅膀/天使棒', 4, 50015996, 3, ',25,50015994,50015996,50016021,', 0),
(50019290, '荧光棒', 5, 50015996, 3, ',25,50015994,50015996,50019290,', 0),
(50024058, '其他聚会装饰', 6, 50015996, 3, ',25,50015994,50015996,50024058,', 0),
(50018705, '体育明星人偶', 2, 50016059, 3, ',25,50024128,50016059,50018705,', 0),
(50008792, '真人明星人偶', 3, 50016059, 3, ',25,50024128,50016059,50008792,', 0),
(50016066, '电影剧情人偶', 4, 50016059, 3, ',25,50024128,50016059,50016066,', 0),
(50016083, '京剧/民俗人偶', 5, 50016059, 3, ',25,50024128,50016059,50016083,', 0),
(50024152, '关节/其他人偶', 7, 50016059, 3, ',25,50024128,50016059,50024152,', 0),
(50007137, '五星物语', 10, 50016101, 3, ',25,50016058,50016101,50007137,', 0),
(50018842, '果宝特攻', 11, 50016101, 3, ',25,50016058,50016101,50018842,', 0),
(50008072, '机器人大战', 12, 50016101, 3, ',25,50016058,50016101,50008072,', 0),
(50016109, '其他机器人', 13, 50016101, 3, ',25,50016058,50016101,50016109,', 0),
(50019215, '铠甲勇士', 14, 50016101, 3, ',25,50016058,50016101,50019215,', 0),
(50019216, '机甲兽神', 15, 50016101, 3, ',25,50016058,50016101,50019216,', 0),
(50019218, '钢甲卡卡龙', 16, 50016101, 3, ',25,50016058,50016101,50019218,', 0),
(50016132, 'TSA密码锁', 0, 50016121, 3, ',50013886,50016119,50016121,50016132,', 0),
(50016133, '普通密码锁', 1, 50016121, 3, ',50013886,50016119,50016121,50016133,', 0),
(50016138, '其他安全防盗产品', 6, 50016121, 3, ',50013886,50016119,50016121,50016138,', 0),
(50016152, '晾衣绳', 0, 50016126, 3, ',50013886,50016119,50016126,50016152,', 0),
(50016153, '转换插头', 1, 50016126, 3, ',50013886,50016119,50016126,50016153,', 0),
(50016158, '其他', 2, 50016126, 3, ',50013886,50016119,50016126,50016158,', 0),
(50016367, '安全汽车背带', 0, 50016368, 3, ',50014812,50006020,50016368,50016367,', 0),
(50013697, '汽车座椅', 31, 50016368, 3, ',50014812,50006020,50016368,50013697,', 0),
(50011945, '袋装奶茶', 0, 50016423, 3, ',50026316,50009857,50016423,50011945,', 0),
(50008436, '珍珠奶茶粉', 6, 50016423, 3, ',50026316,50009857,50016423,50008436,', 0),
(50016424, '杯装奶茶', 7, 50016423, 3, ',50026316,50009857,50016423,50016424,', 0),
(50008911, '纯果蔬汁', 0, 50016431, 3, ',50026316,50026398,50016431,50008911,', 0),
(50016432, '浓缩果蔬汁', 1, 50016431, 3, ',50026316,50026398,50016431,50016432,', 0),
(50012818, '奶嘴链', 0, 50016455, 3, ',50014812,50009521,50016455,50012818,', 0),
(50012817, '奶瓶把/手柄', 7, 50016455, 3, ',50014812,50009521,50016455,50012817,', 0),
(50012789, '奶瓶刷/奶嘴刷', 8, 50016455, 3, ',50014812,50009521,50016455,50012789,', 0),
(50012780, '奶瓶夹', 9, 50016455, 3, ',50014812,50009521,50016455,50012780,', 0),
(50012755, '奶瓶干燥架', 13, 50016455, 3, ',50014812,50009521,50016455,50012755,', 0),
(50008707, '防胀气装置', 17, 50016455, 3, ',50014812,50009521,50016455,50008707,', 0),
(50012819, '奶瓶盖', 18, 50016455, 3, ',50014812,50009521,50016455,50012819,', 0),
(50012754, '奶瓶温度计', 20, 50016455, 3, ',50014812,50009521,50016455,50012754,', 0),
(50012842, '奶嘴打孔器', 26, 50016455, 3, ',50014812,50009521,50016455,50012842,', 0),
(50012807, '吸管刷', 27, 50016455, 3, ',50014812,50009521,50016455,50012807,', 0),
(50016584, '拉丁舞鞋', 0, 50016473, 3, ',50010728,50016472,50016473,50016584,', 0),
(50016585, '拉丁舞上装', 1, 50016473, 3, ',50010728,50016472,50016473,50016585,', 0),
(50016586, '拉丁舞下装', 2, 50016473, 3, ',50010728,50016472,50016473,50016586,', 0),
(50016587, '拉丁舞练习套装', 3, 50016473, 3, ',50010728,50016472,50016473,50016587,', 0),
(50016588, '拉丁舞演出服', 4, 50016473, 3, ',50010728,50016472,50016473,50016588,', 0),
(50016589, '拉丁舞配件', 5, 50016473, 3, ',50010728,50016472,50016473,50016589,', 0),
(50016617, '芭蕾舞鞋', 0, 50016474, 3, ',50010728,50016472,50016474,50016617,', 0),
(50016620, '芭蕾舞服', 1, 50016474, 3, ',50010728,50016472,50016474,50016620,', 0),
(50016622, '芭蕾舞演出服', 2, 50016474, 3, ',50010728,50016472,50016474,50016622,', 0),
(50016623, '芭蕾舞护腿袜/护具', 3, 50016474, 3, ',50010728,50016472,50016474,50016623,', 0),
(50016624, '芭蕾舞配件', 4, 50016474, 3, ',50010728,50016472,50016474,50016624,', 0),
(50016642, '肚皮舞鞋', 0, 50016475, 3, ',50010728,50016472,50016475,50016642,', 0),
(50016643, '肚皮舞上装', 1, 50016475, 3, ',50010728,50016472,50016475,50016643,', 0),
(50016644, '肚皮舞下装', 2, 50016475, 3, ',50010728,50016472,50016475,50016644,', 0),
(50016645, '肚皮舞套装(演出服)', 3, 50016475, 3, ',50010728,50016472,50016475,50016645,', 0),
(50016646, '肚皮舞腰链', 4, 50016475, 3, ',50010728,50016472,50016475,50016646,', 0),
(50016647, '肚皮舞配饰', 5, 50016475, 3, ',50010728,50016472,50016475,50016647,', 0),
(50016592, '摩登舞鞋', 0, 50016476, 3, ',50010728,50016472,50016476,50016592,', 0),
(50016593, '摩登舞上装', 1, 50016476, 3, ',50010728,50016472,50016476,50016593,', 0),
(50016594, '摩登舞下装', 2, 50016476, 3, ',50010728,50016472,50016476,50016594,', 0),
(50016595, '摩登舞套装(含演出服)', 3, 50016476, 3, ',50010728,50016472,50016476,50016595,', 0),
(50016596, '摩登舞配饰', 4, 50016476, 3, ',50010728,50016472,50016476,50016596,', 0),
(50016650, '爵士舞鞋', 0, 50016477, 3, ',50010728,50016472,50016477,50016650,', 0),
(50016651, '爵士舞服装', 1, 50016477, 3, ',50010728,50016472,50016477,50016651,', 0),
(50016652, '爵士舞道具/配件', 2, 50016477, 3, ',50010728,50016472,50016477,50016652,', 0),
(50016654, '踢踏舞鞋', 0, 50016479, 3, ',50010728,50016472,50016479,50016654,', 0),
(50016655, '踢踏舞服', 1, 50016479, 3, ',50010728,50016472,50016479,50016655,', 0),
(50016656, '踢踏舞配件', 2, 50016479, 3, ',50010728,50016472,50016479,50016656,', 0),
(50016637, '街舞鞋', 0, 50016481, 3, ',50010728,50016472,50016481,50016637,', 0),
(50016638, '街舞服装', 1, 50016481, 3, ',50010728,50016472,50016481,50016638,', 0),
(50016639, '街舞配件', 2, 50016481, 3, ',50010728,50016472,50016481,50016639,', 0),
(50016483, '底座', 0, 50016482, 3, ',50011972,50011866,50016482,50016483,', 0),
(50016484, '支架', 1, 50016482, 3, ',50011972,50011866,50016482,50016484,', 0),
(50016488, '咪罩', 2, 50016482, 3, ',50011972,50011866,50016482,50016488,', 0),
(50016489, '更多', 3, 50016482, 3, ',50011972,50011866,50016482,50016489,', 0),
(50016633, '新疆舞鞋', 0, 50016485, 3, ',50010728,50016472,50016485,50016633,', 0),
(50016634, '新疆舞服', 1, 50016485, 3, ',50010728,50016472,50016485,50016634,', 0),
(50016635, '新疆舞配饰', 2, 50016485, 3, ',50010728,50016472,50016485,50016635,', 0),
(50016629, '藏族舞鞋', 0, 50016486, 3, ',50010728,50016472,50016486,50016629,', 0),
(50016630, '藏族舞服', 1, 50016486, 3, ',50010728,50016472,50016486,50016630,', 0),
(50016631, '藏族舞配饰', 2, 50016486, 3, ',50010728,50016472,50016486,50016631,', 0),
(50016625, '傣族舞服', 0, 50016487, 3, ',50010728,50016472,50016487,50016625,', 0),
(50016627, '傣族舞配饰', 1, 50016487, 3, ',50010728,50016472,50016487,50016627,', 0),
(50016616, '朝鲜舞鞋', 0, 50016490, 3, ',50010728,50016472,50016490,50016616,', 0),
(50016618, '朝鲜舞服', 1, 50016490, 3, ',50010728,50016472,50016490,50016618,', 0),
(50016619, '朝鲜舞配饰', 2, 50016490, 3, ',50010728,50016472,50016490,50016619,', 0),
(50016612, '秧歌鞋', 0, 50016491, 3, ',50010728,50016472,50016491,50016612,', 0),
(50016613, '秧歌服', 1, 50016491, 3, ',50010728,50016472,50016491,50016613,', 0),
(50016614, '秧歌配饰', 2, 50016491, 3, ',50010728,50016472,50016491,50016614,', 0),
(50016571, '草裙', 0, 50016492, 3, ',50010728,50016472,50016492,50016571,', 0),
(50016572, '草裙舞套装', 1, 50016492, 3, ',50010728,50016472,50016492,50016572,', 0),
(50016574, '草裙舞配饰', 2, 50016492, 3, ',50010728,50016472,50016492,50016574,', 0),
(50016659, '更多舞鞋', 0, 50016493, 3, ',50010728,50016472,50016493,50016659,', 0),
(50016660, '更多舞蹈服装', 1, 50016493, 3, ',50010728,50016472,50016493,50016660,', 0),
(50016661, '更多舞蹈配饰', 2, 50016493, 3, ',50010728,50016472,50016493,50016661,', 0),
(50016607, '钢管舞鞋', 0, 50016494, 3, ',50010728,50016472,50016494,50016607,', 0),
(50016608, '钢管舞服', 1, 50016494, 3, ',50010728,50016472,50016494,50016608,', 0),
(50016609, '钢管舞钢管', 2, 50016494, 3, ',50010728,50016472,50016494,50016609,', 0),
(50016610, '更多钢管舞配件', 3, 50016494, 3, ',50010728,50016472,50016494,50016610,', 0),
(50016602, '健美操鞋', 0, 50016495, 3, ',50010728,50016472,50016495,50016602,', 0),
(50016603, '健美操上装', 1, 50016495, 3, ',50010728,50016472,50016495,50016603,', 0),
(50016604, '健美操下装', 2, 50016495, 3, ',50010728,50016472,50016495,50016604,', 0),
(50016605, '健美操套装', 3, 50016495, 3, ',50010728,50016472,50016495,50016605,', 0),
(50016606, '健美操道具', 4, 50016495, 3, ',50010728,50016472,50016495,50016606,', 0),
(50016598, '体操鞋', 0, 50016591, 3, ',50010728,50016472,50016591,50016598,', 0),
(50016599, '体操服', 1, 50016591, 3, ',50010728,50016472,50016591,50016599,', 0),
(50016600, '体操比赛服', 2, 50016591, 3, ',50010728,50016472,50016591,50016600,', 0),
(50016601, '体操道具', 3, 50016591, 3, ',50010728,50016472,50016591,50016601,', 0),
(50016682, '现代舞鞋', 0, 50016681, 3, ',50010728,50016472,50016681,50016682,', 0),
(50016683, '现代舞服装', 1, 50016681, 3, ',50010728,50016472,50016681,50016683,', 0),
(50016684, '现代舞配件', 2, 50016681, 3, ',50010728,50016472,50016681,50016684,', 0),
(50016705, '头盔', 0, 50016704, 3, ',50010728,50016689,50016704,50016705,', 0),
(50016707, '速滑服', 2, 50016704, 3, ',50010728,50016689,50016704,50016707,', 0),
(50016708, '轮滑包', 3, 50016704, 3, ',50010728,50016689,50016704,50016708,', 0),
(50016727, '滑板包', 4, 50016704, 3, ',50010728,50016689,50016704,50016727,', 0),
(50016710, '轮滑桩', 5, 50016704, 3, ',50010728,50016689,50016704,50016710,', 0),
(50016711, '滑板轮子', 6, 50016704, 3, ',50010728,50016689,50016704,50016711,', 0),
(50016712, '直排轮子', 7, 50016704, 3, ',50010728,50016689,50016704,50016712,', 0),
(50016713, '穿钉', 8, 50016704, 3, ',50010728,50016689,50016704,50016713,', 0),
(50016714, '轴承', 9, 50016704, 3, ',50010728,50016689,50016704,50016714,', 0),
(50016715, '滑板桥', 10, 50016704, 3, ',50010728,50016689,50016704,50016715,', 0),
(50016716, 'T型滑板工具', 11, 50016704, 3, ',50010728,50016689,50016704,50016716,', 0),
(50016717, '速滑刀架', 12, 50016704, 3, ',50010728,50016689,50016704,50016717,', 0),
(50016718, '轮滑鞋套', 13, 50016704, 3, ',50010728,50016689,50016704,50016718,', 0),
(50016725, '漂移板护边', 14, 50016704, 3, ',50010728,50016689,50016704,50016725,', 0),
(50016719, '润滑油', 15, 50016704, 3, ',50010728,50016689,50016704,50016719,', 0),
(50016720, '滑板/漂移板砂纸', 16, 50016704, 3, ',50010728,50016689,50016704,50016720,', 0),
(50016728, '更多配件', 18, 50016704, 3, ',50010728,50016689,50016704,50016728,', 0),
(50013333, '杯架/漱口杯', 0, 50016746, 3, ',27,50020007,50016746,50013333,', 0),
(50013334, '浴巾架/毛巾架', 1, 50016746, 3, ',27,50020007,50016746,50013334,', 0),
(50013335, '挂钩/挂衣钩', 2, 50016746, 3, ',27,50020007,50016746,50013335,', 0),
(50013336, '化妆品架', 3, 50016746, 3, ',27,50020007,50016746,50013336,', 0),
(50013337, '卷纸器/纸巾架', 4, 50016746, 3, ',27,50020007,50016746,50013337,', 0),
(50013338, '肥皂盒/皂碟', 5, 50016746, 3, ',27,50020007,50016746,50013338,', 0),
(50013339, '毛巾杆/毛巾挂', 6, 50016746, 3, ',27,50020007,50016746,50013339,', 0),
(50013340, '毛巾环', 7, 50016746, 3, ',27,50020007,50016746,50013340,', 0),
(50013341, '浴室扶手', 8, 50016746, 3, ',27,50020007,50016746,50013341,', 0),
(50013342, '美容镜', 9, 50016746, 3, ',27,50020007,50016746,50013342,', 0),
(50013798, '置物架', 10, 50016746, 3, ',27,50020007,50016746,50013798,', 0),
(50013800, '浴室角架', 11, 50016746, 3, ',27,50020007,50016746,50013800,', 0),
(50013799, '过滤器/净水器', 21, 50016746, 3, ',27,50020007,50016746,50013799,', 0),
(50013801, '皂液器', 22, 50016746, 3, ',27,50020007,50016746,50013801,', 0),
(50014922, '马桶刷/马桶杯', 25, 50016746, 3, ',27,50020007,50016746,50014922,', 0),
(50016750, '游泳浮标(跟屁虫)', 1, 50016748, 3, ',50010728,50016729,50016748,50016750,', 0),
(50016751, '手臂浮圈', 2, 50016748, 3, ',50010728,50016729,50016748,50016751,', 0),
(50016753, '耳塞', 4, 50016748, 3, ',50010728,50016729,50016748,50016753,', 0),
(50016754, '鼻夹', 5, 50016748, 3, ',50010728,50016729,50016748,50016754,', 0),
(50016755, '脚蹼', 6, 50016748, 3, ',50010728,50016729,50016748,50016755,', 0),
(50016756, '手蹼', 7, 50016748, 3, ',50010728,50016729,50016748,50016756,', 0),
(50016757, '打水板/浮板', 8, 50016748, 3, ',50010728,50016729,50016748,50016757,', 0),
(50016758, '水中拉力带', 9, 50016748, 3, ',50010728,50016729,50016748,50016758,', 0),
(50016759, '充气床', 10, 50016748, 3, ',50010728,50016729,50016748,50016759,', 0),
(50016760, '充气沙发', 11, 50016748, 3, ',50010728,50016729,50016748,50016760,', 0),
(50019556, '充气水球/戏水球', 12, 50016748, 3, ',50010728,50016729,50016748,50019556,', 0),
(50016761, '浴巾/吸水巾', 13, 50016748, 3, ',50010728,50016729,50016748,50016761,', 0),
(50023378, '防晒衣/沙滩衣', 14, 50016748, 3, ',50010728,50016729,50016748,50023378,', 0),
(50023379, '遮阳帽/沙滩帽', 15, 50016748, 3, ',50010728,50016729,50016748,50023379,', 0),
(50023377, '比基尼头花/胸花', 16, 50016748, 3, ',50010728,50016729,50016748,50023377,', 0),
(50016763, '泳衣胸垫', 18, 50016748, 3, ',50010728,50016729,50016748,50016763,', 0),
(50016764, '防雾剂/帖', 19, 50016748, 3, ',50010728,50016729,50016748,50016764,', 0),
(50016765, '专用呼吸管', 20, 50016748, 3, ',50010728,50016729,50016748,50016765,', 0),
(50016766, '充气设备', 21, 50016748, 3, ',50010728,50016729,50016748,50016766,', 0),
(50023342, '护脐贴/肚脐贴/护耳贴', 24, 50016748, 3, ',50010728,50016729,50016748,50023342,', 0),
(50023343, '水温计/温度计', 25, 50016748, 3, ',50010728,50016729,50016748,50023343,', 0),
(50023361, '冲浪板', 27, 50016748, 3, ',50010728,50016729,50016748,50023361,', 0),
(50023438, '水下MP3', 28, 50016748, 3, ',50010728,50016729,50016748,50023438,', 0),
(50016769, '更多游泳装备', 29, 50016748, 3, ',50010728,50016729,50016748,50016769,', 0),
(50016799, '其它', 8, 50016771, 3, ',50050359,50050371,50016771,50016799,', 0),
(50016804, '紫菜', 13, 50016771, 3, ',50050359,50050371,50016771,50016804,', 0),
(50050718, '海带', 14, 50016771, 3, ',50050359,50050371,50016771,50050718,', 0),
(50009899, '莲子', 0, 50016820, 3, ',50016422,50025682,50016820,50009899,', 0),
(50009778, '香菇类', 27, 50016820, 3, ',50016422,50025682,50016820,50009778,', 0),
(50012188, '桂圆干/龙眼', 31, 50016820, 3, ',50016422,50025682,50016820,50012188,', 0),
(50012189, '荔枝干', 32, 50016820, 3, ',50016422,50025682,50016820,50012189,', 0),
(50012194, '百合', 37, 50016820, 3, ',50016422,50025682,50016820,50012194,', 0),
(50012193, '银耳/白木耳', 41, 50016820, 3, ',50016422,50025682,50016820,50012193,', 0),
(50012548, '黑木耳', 42, 50016820, 3, ',50016422,50025682,50016820,50012548,', 0),
(50012395, '其它', 43, 50016820, 3, ',50016422,50025682,50016820,50012395,', 0),
(50050575, '猴头菇', 44, 50016820, 3, ',50016422,50025682,50016820,50050575,', 0),
(50050576, '松茸', 45, 50016820, 3, ',50016422,50025682,50016820,50050576,', 0),
(50050577, '竹荪', 46, 50016820, 3, ',50016422,50025682,50016820,50050577,', 0),
(50016858, '鞋垫', 0, 50016857, 3, ',50010728,50011556,50016857,50016858,', 0),
(50016859, '发力练习器', 1, 50016857, 3, ',50010728,50011556,50016857,50016859,', 0),
(50016860, '防滑粉', 2, 50016857, 3, ',50010728,50011556,50016857,50016860,', 0),
(50016861, '穿线机及配件', 3, 50016857, 3, ',50010728,50011556,50016857,50016861,', 0),
(50016862, '羽毛球挂件', 4, 50016857, 3, ',50010728,50011556,50016857,50016862,', 0),
(50016863, '羽拍护线管', 5, 50016857, 3, ',50010728,50011556,50016857,50016863,', 0),
(50016864, '羽拍袋', 6, 50016857, 3, ',50010728,50011556,50016857,50016864,', 0),
(50016865, '球鞋袋', 7, 50016857, 3, ',50010728,50011556,50016857,50016865,', 0),
(50017578, '羽毛球网架/网柱', 8, 50016857, 3, ',50010728,50011556,50016857,50017578,', 0),
(50016866, '其他', 9, 50016857, 3, ',50010728,50011556,50016857,50016866,', 0),
(50017194, '石家庄', 0, 50017153, 3, ',50025707,50017087,50017153,50017194,', 0),
(50017195, '唐山', 1, 50017153, 3, ',50025707,50017087,50017153,50017195,', 0),
(50017196, '秦皇岛', 2, 50017153, 3, ',50025707,50017087,50017153,50017196,', 0),
(50017197, '邯郸', 3, 50017153, 3, ',50025707,50017087,50017153,50017197,', 0),
(50017198, '邢台', 4, 50017153, 3, ',50025707,50017087,50017153,50017198,', 0),
(50017199, '保定', 5, 50017153, 3, ',50025707,50017087,50017153,50017199,', 0),
(50017200, '张家口', 6, 50017153, 3, ',50025707,50017087,50017153,50017200,', 0),
(50017201, '承德', 7, 50017153, 3, ',50025707,50017087,50017153,50017201,', 0),
(50017202, '沧州', 8, 50017153, 3, ',50025707,50017087,50017153,50017202,', 0),
(50017203, '廊坊', 9, 50017153, 3, ',50025707,50017087,50017153,50017203,', 0),
(50017204, '衡水', 10, 50017153, 3, ',50025707,50017087,50017153,50017204,', 0),
(50017846, '其它', 11, 50017153, 3, ',50025707,50017087,50017153,50017846,', 0),
(50017831, '南京', 0, 50017159, 3, ',50025707,50017087,50017159,50017831,', 0),
(50017832, '苏州', 1, 50017159, 3, ',50025707,50017087,50017159,50017832,', 0),
(50017833, '扬州', 2, 50017159, 3, ',50025707,50017087,50017159,50017833,', 0),
(50017834, '常州', 3, 50017159, 3, ',50025707,50017087,50017159,50017834,', 0),
(50017835, '无锡', 4, 50017159, 3, ',50025707,50017087,50017159,50017835,', 0),
(50017836, '泰州', 5, 50017159, 3, ',50025707,50017087,50017159,50017836,', 0),
(50017837, '镇江', 6, 50017159, 3, ',50025707,50017087,50017159,50017837,', 0),
(50017838, '徐州', 7, 50017159, 3, ',50025707,50017087,50017159,50017838,', 0),
(50017839, '连云港', 8, 50017159, 3, ',50025707,50017087,50017159,50017839,', 0),
(50017841, '南通', 9, 50017159, 3, ',50025707,50017087,50017159,50017841,', 0),
(50017840, '其它', 10, 50017159, 3, ',50025707,50017087,50017159,50017840,', 0),
(50025149, '淮安', 11, 50017159, 3, ',50025707,50017087,50017159,50025149,', 0),
(50017766, '杭州', 0, 50017160, 3, ',50025707,50017087,50017160,50017766,', 0),
(50017767, '绍兴', 1, 50017160, 3, ',50025707,50017087,50017160,50017767,', 0),
(50017807, '临安', 2, 50017160, 3, ',50025707,50017087,50017160,50017807,', 0),
(50017808, '富阳', 3, 50017160, 3, ',50025707,50017087,50017160,50017808,', 0),
(50017809, '桐庐', 4, 50017160, 3, ',50025707,50017087,50017160,50017809,', 0),
(50017811, '淳安（千岛湖）', 6, 50017160, 3, ',50025707,50017087,50017160,50017811,', 0),
(50017812, '建德', 7, 50017160, 3, ',50025707,50017087,50017160,50017812,', 0),
(50017813, '安吉', 8, 50017160, 3, ',50025707,50017087,50017160,50017813,', 0),
(50017810, '嘉兴', 9, 50017160, 3, ',50025707,50017087,50017160,50017810,', 0),
(50017822, '金华', 10, 50017160, 3, ',50025707,50017087,50017160,50017822,', 0),
(50017823, '湖州', 11, 50017160, 3, ',50025707,50017087,50017160,50017823,', 0),
(50017824, '宁波', 12, 50017160, 3, ',50025707,50017087,50017160,50017824,', 0),
(50017825, '舟山', 13, 50017160, 3, ',50025707,50017087,50017160,50017825,', 0),
(50017826, '台州', 14, 50017160, 3, ',50025707,50017087,50017160,50017826,', 0),
(50017827, '温州', 15, 50017160, 3, ',50025707,50017087,50017160,50017827,', 0),
(50017828, '丽水', 16, 50017160, 3, ',50025707,50017087,50017160,50017828,', 0),
(50017829, '衢州', 17, 50017160, 3, ',50025707,50017087,50017160,50017829,', 0),
(50017830, '其它', 18, 50017160, 3, ',50025707,50017087,50017160,50017830,', 0),
(50017979, '合肥', 0, 50017161, 3, ',50025707,50017087,50017161,50017979,', 0),
(50017980, '黄山', 1, 50017161, 3, ',50025707,50017087,50017161,50017980,', 0),
(50018156, '芜湖', 3, 50017161, 3, ',50025707,50017087,50017161,50018156,', 0),
(50024226, '六安市', 5, 50017161, 3, ',50025707,50017087,50017161,50024226,', 0),
(50024227, '宣城', 6, 50017161, 3, ',50025707,50017087,50017161,50024227,', 0),
(50024228, '滁州', 7, 50017161, 3, ',50025707,50017087,50017161,50024228,', 0),
(50024426, '安庆市', 8, 50017161, 3, ',50025707,50017087,50017161,50024426,', 0),
(50017982, '其它', 9, 50017161, 3, ',50025707,50017087,50017161,50017982,', 0),
(50025148, '马鞍山', 10, 50017161, 3, ',50025707,50017087,50017161,50025148,', 0),
(50025672, '池州', 11, 50017161, 3, ',50025707,50017087,50017161,50025672,', 0),
(50017991, '厦门', 0, 50017162, 3, ',50025707,50017087,50017162,50017991,', 0),
(50017993, '福州', 1, 50017162, 3, ',50025707,50017087,50017162,50017993,', 0),
(50017994, '武夷山', 2, 50017162, 3, ',50025707,50017087,50017162,50017994,', 0),
(50017992, '其它', 3, 50017162, 3, ',50025707,50017087,50017162,50017992,', 0),
(50023064, '泉州', 4, 50017162, 3, ',50025707,50017087,50017162,50023064,', 0),
(50026618, '宁德', 5, 50017162, 3, ',50025707,50017087,50017162,50026618,', 0),
(50026621, '漳州', 6, 50017162, 3, ',50025707,50017087,50017162,50026621,', 0),
(50026623, '三明', 7, 50017162, 3, ',50025707,50017087,50017162,50026623,', 0),
(50026624, '龙岩', 8, 50017162, 3, ',50025707,50017087,50017162,50026624,', 0),
(50017996, '青岛', 0, 50017164, 3, ',50025707,50017087,50017164,50017996,', 0),
(50017997, '济南', 1, 50017164, 3, ',50025707,50017087,50017164,50017997,', 0),
(50017998, '烟台', 2, 50017164, 3, ',50025707,50017087,50017164,50017998,', 0),
(50017999, '其它', 3, 50017164, 3, ',50025707,50017087,50017164,50017999,', 0),
(50022895, '济宁', 4, 50017164, 3, ',50025707,50017087,50017164,50022895,', 0),
(50026021, '临沂', 5, 50017164, 3, ',50025707,50017087,50017164,50026021,', 0),
(50026645, '泰安', 6, 50017164, 3, ',50025707,50017087,50017164,50026645,', 0),
(50018000, '武汉', 0, 50017166, 3, ',50025707,50017087,50017166,50018000,', 0),
(50018002, '咸宁', 39, 50017166, 3, ',50025707,50017087,50017166,50018002,', 0),
(50018001, '其它', 40, 50017166, 3, ',50025707,50017087,50017166,50018001,', 0),
(50017989, '长沙', 0, 50017167, 3, ',50025707,50017087,50017167,50017989,', 0),
(50017990, '其它', 1, 50017167, 3, ',50025707,50017087,50017167,50017990,', 0),
(50024224, '张家界', 2, 50017167, 3, ',50025707,50017087,50017167,50024224,', 0),
(50017768, '广州', 0, 50017168, 3, ',50025707,50017087,50017168,50017768,', 0),
(50017769, '深圳', 1, 50017168, 3, ',50025707,50017087,50017168,50017769,', 0),
(50017770, '珠海', 2, 50017168, 3, ',50025707,50017087,50017168,50017770,', 0),
(50017772, '佛山', 3, 50017168, 3, ',50025707,50017087,50017168,50017772,', 0),
(50017773, '清远', 4, 50017168, 3, ',50025707,50017087,50017168,50017773,', 0),
(50017775, '江门', 5, 50017168, 3, ',50025707,50017087,50017168,50017775,', 0),
(50017804, '韶关', 6, 50017168, 3, ',50025707,50017087,50017168,50017804,', 0),
(50017806, '茂名', 8, 50017168, 3, ',50025707,50017087,50017168,50017806,', 0),
(50023893, '惠州', 9, 50017168, 3, ',50025707,50017087,50017168,50023893,', 0),
(50023894, '中山', 10, 50017168, 3, ',50025707,50017087,50017168,50023894,', 0),
(50017805, '其它', 11, 50017168, 3, ',50025707,50017087,50017168,50017805,', 0),
(50024185, '阳江市', 12, 50017168, 3, ',50025707,50017087,50017168,50024185,', 0),
(50024206, '云浮市', 13, 50017168, 3, ',50025707,50017087,50017168,50024206,', 0),
(50024225, '河源', 14, 50017168, 3, ',50025707,50017087,50017168,50024225,', 0),
(50026341, '东莞', 15, 50017168, 3, ',50025707,50017087,50017168,50026341,', 0),
(50050194, '肇庆', 16, 50017168, 3, ',50025707,50017087,50017168,50050194,', 0),
(50050195, '梅州', 17, 50017168, 3, ',50025707,50017087,50017168,50050195,', 0),
(50017857, '南宁', 0, 50017169, 3, ',50025707,50017087,50017169,50017857,', 0),
(50017845, '桂林', 0, 50017169, 3, ',50025707,50017087,50017169,50017845,', 0),
(50026086, '防城港', 1, 50017169, 3, ',50025707,50017087,50017169,50026086,', 0),
(50017858, '其它', 2, 50017169, 3, ',50025707,50017087,50017169,50017858,', 0),
(50050196, '北海', 3, 50017169, 3, ',50025707,50017087,50017169,50050196,', 0),
(50050197, '贵港', 4, 50017169, 3, ',50025707,50017087,50017169,50050197,', 0),
(50050198, '百色', 5, 50017169, 3, ',50025707,50017087,50017169,50050198,', 0),
(50017842, '三亚', 0, 50017170, 3, ',50025707,50017087,50017170,50017842,', 0),
(50017843, '海口', 1, 50017170, 3, ',50025707,50017087,50017170,50017843,', 0),
(50017844, '其它', 2, 50017170, 3, ',50025707,50017087,50017170,50017844,', 0),
(50017923, '成都', 0, 50017171, 3, ',50025707,50017087,50017171,50017923,', 0),
(50017933, '其它', 1, 50017171, 3, ',50025707,50017087,50017171,50017933,', 0),
(50050436, '阿坝藏族羌族自治州', 2, 50017171, 3, ',50025707,50017087,50017171,50050436,', 0),
(50050437, '绵阳', 3, 50017171, 3, ',50025707,50017087,50017171,50050437,', 0),
(50017962, '昆明', 0, 50017173, 3, ',50025707,50017087,50017173,50017962,', 0),
(50017964, '丽江', 1, 50017173, 3, ',50025707,50017087,50017173,50017964,', 0),
(50023784, '大理', 2, 50017173, 3, ',50025707,50017087,50017173,50023784,', 0),
(50023785, '西双版纳', 4, 50017173, 3, ',50025707,50017087,50017173,50023785,', 0),
(50023786, '楚雄', 5, 50017173, 3, ',50025707,50017087,50017173,50023786,', 0),
(50023787, '红河', 6, 50017173, 3, ',50025707,50017087,50017173,50023787,', 0),
(50024127, '玉溪', 7, 50017173, 3, ',50025707,50017087,50017173,50024127,', 0),
(50017972, '其它', 8, 50017173, 3, ',50025707,50017087,50017173,50017972,', 0),
(50017977, '西安', 0, 50017175, 3, ',50025707,50017087,50017175,50017977,', 0),
(50017978, '其它', 1, 50017175, 3, ',50025707,50017087,50017175,50017978,', 0),
(50017206, '裁判服', 0, 50017205, 3, ',50010728,50013823,50017205,50017206,', 0),
(50017207, '裁判徽章', 1, 50017205, 3, ',50010728,50013823,50017205,50017207,', 0),
(50017208, '裁判专用哨', 2, 50017205, 3, ',50010728,50013823,50017205,50017208,', 0),
(50017209, '挑边器', 3, 50017205, 3, ',50010728,50013823,50017205,50017209,', 0),
(50017210, '记分牌/换人牌', 4, 50017205, 3, ',50010728,50013823,50017205,50017210,', 0),
(50017211, '裁判巡边旗', 5, 50017205, 3, ',50010728,50013823,50017205,50017211,', 0),
(50017212, '红黄牌', 6, 50017205, 3, ',50010728,50013823,50017205,50017212,', 0),
(50017213, '计时工具', 7, 50017205, 3, ',50010728,50013823,50017205,50017213,', 0),
(50017299, '更多', 8, 50017205, 3, ',50010728,50013823,50017205,50017299,', 0),
(50017219, '装备袋', 1, 50017217, 3, ',50010728,50013823,50017217,50017219,', 0),
(50017220, '鞋子收纳袋', 2, 50017217, 3, ',50010728,50013823,50017217,50017220,', 0),
(50017221, '充气装备', 3, 50017217, 3, ',50010728,50013823,50017217,50017221,', 0),
(50017225, '袖标', 5, 50017217, 3, ',50010728,50013823,50017217,50017225,', 0),
(50017228, '跳栏/跳格梯', 8, 50017217, 3, ',50010728,50013823,50017217,50017228,', 0),
(50017229, '障碍物/标志物', 9, 50017217, 3, ',50010728,50013823,50017217,50017229,', 0),
(50017230, '更多', 10, 50017217, 3, ',50010728,50013823,50017217,50017230,', 0),
(50017241, '裁判服', 0, 50017240, 3, ',50010728,50013202,50017240,50017241,', 0),
(50017242, '裁判专用哨', 1, 50017240, 3, ',50010728,50013202,50017240,50017242,', 0),
(50017243, '篮球战术板', 2, 50017240, 3, ',50010728,50013202,50017240,50017243,', 0),
(50017244, '计时工具', 3, 50017240, 3, ',50010728,50013202,50017240,50017244,', 0),
(50017245, '记分牌/换人牌', 4, 50017240, 3, ',50010728,50013202,50017240,50017245,', 0),
(50017282, '裁判台', 0, 50017281, 3, ',50010728,50017269,50017281,50017282,', 0),
(50017283, '裁判椅', 1, 50017281, 3, ',50010728,50017269,50017281,50017283,', 0),
(50017284, '计时工具', 2, 50017281, 3, ',50010728,50017269,50017281,50017284,', 0),
(50017285, '裁判专用哨', 3, 50017281, 3, ',50010728,50017269,50017281,50017285,', 0),
(50017286, '更多', 4, 50017281, 3, ',50010728,50017269,50017281,50017286,', 0),
(50017288, '划线车', 0, 50017287, 3, ',50010728,50017269,50017287,50017288,', 0),
(50017289, '场地测量尺', 1, 50017287, 3, ',50010728,50017269,50017287,50017289,', 0),
(50017290, '安全警戒线', 2, 50017287, 3, ',50010728,50017269,50017287,50017290,', 0),
(50017291, '助跳板', 3, 50017287, 3, ',50010728,50017269,50017287,50017291,', 0),
(50017292, '铁饼链球插牌', 4, 50017287, 3, ',50010728,50017269,50017287,50017292,', 0),
(50017293, '铅球抵趾板', 5, 50017287, 3, ',50010728,50017269,50017287,50017293,', 0),
(50017294, '平砂板', 6, 50017287, 3, ',50010728,50017269,50017287,50017294,', 0),
(50017295, '撑杆跳插斗', 7, 50017287, 3, ',50010728,50017269,50017287,50017295,', 0),
(50017296, '道次墩', 8, 50017287, 3, ',50010728,50017269,50017287,50017296,', 0),
(50017297, '场地吸水器', 9, 50017287, 3, ',50010728,50017269,50017287,50017297,', 0),
(50017298, '更多', 10, 50017287, 3, ',50010728,50017269,50017287,50017298,', 0),
(50017338, '镲锅', 0, 50017323, 3, ',50017300,50017301,50017323,50017338,', 0),
(50017339, '水镲', 1, 50017323, 3, ',50017300,50017301,50017323,50017339,', 0),
(50017340, '军镲', 2, 50017323, 3, ',50017300,50017301,50017323,50017340,', 0),
(50017341, '腰鼓镲', 3, 50017323, 3, ',50017300,50017301,50017323,50017341,', 0),
(50017342, '秧歌镲', 4, 50017323, 3, ',50017300,50017301,50017323,50017342,', 0),
(50017343, '其它镲', 5, 50017323, 3, ',50017300,50017301,50017323,50017343,', 0),
(50017344, '大钹', 0, 50017324, 3, ',50017300,50017301,50017324,50017344,', 0),
(50017345, '广钹', 1, 50017324, 3, ',50017300,50017301,50017324,50017345,', 0),
(50017346, '川钹', 2, 50017324, 3, ',50017300,50017301,50017324,50017346,', 0),
(50017347, '大顶钹', 3, 50017324, 3, ',50017300,50017301,50017324,50017347,', 0),
(50017348, '大铙', 4, 50017324, 3, ',50017300,50017301,50017324,50017348,', 0),
(50017349, '碰钟', 5, 50017324, 3, ',50017300,50017301,50017324,50017349,', 0),
(50017350, '铜书板', 6, 50017324, 3, ',50017300,50017301,50017324,50017350,', 0),
(50017606, '固腕支架', 0, 50017605, 3, ',50010728,50017077,50017605,50017606,', 0),
(50017607, '网球框', 1, 50017605, 3, ',50010728,50017077,50017605,50017607,', 0),
(50017608, '六角球/反应球', 2, 50017605, 3, ',50010728,50017077,50017605,50017608,', 0),
(50017609, '网球练习器', 3, 50017605, 3, ',50010728,50017077,50017605,50017609,', 0),
(50017610, '高弹力橡筋', 4, 50017605, 3, ',50010728,50017077,50017605,50017610,', 0),
(50017611, '网球网', 5, 50017605, 3, ',50010728,50017077,50017605,50017611,', 0),
(50017612, '运动毛巾', 6, 50017605, 3, ',50010728,50017077,50017605,50017612,', 0),
(50017613, '更多', 7, 50017605, 3, ',50010728,50017077,50017605,50017613,', 0),
(50017732, '啦啦队服', 0, 50017731, 3, ',50010728,50016472,50017731,50017732,', 0),
(50017733, '啦啦队彩球', 1, 50017731, 3, ',50010728,50016472,50017731,50017733,', 0),
(50017734, '啦啦队彩绘', 2, 50017731, 3, ',50010728,50016472,50017731,50017734,', 0),
(50017735, '啦啦队头饰', 3, 50017731, 3, ',50010728,50016472,50017731,50017735,', 0),
(50017752, '更多啦啦队配饰', 5, 50017731, 3, ',50010728,50016472,50017731,50017752,', 0),
(50017744, '母球定位器', 0, 50017743, 3, ',50010728,50017722,50017743,50017744,', 0),
(50017745, '台球刷', 1, 50017743, 3, ',50010728,50017722,50017743,50017745,', 0),
(50017747, '皮头压制器', 3, 50017743, 3, ',50010728,50017722,50017743,50017747,', 0),
(50017749, '皮头削', 5, 50017743, 3, ',50010728,50017722,50017743,50017749,', 0),
(50017750, '更多', 6, 50017743, 3, ',50010728,50017722,50017743,50017750,', 0),
(50017792, '打击垫', 0, 50017791, 3, ',50010728,50017776,50017791,50017792,', 0),
(50017793, '动作矫正器', 1, 50017791, 3, ',50010728,50017776,50017791,50017793,', 0),
(50017794, '发球机', 2, 50017791, 3, ',50010728,50017776,50017791,50017794,', 0),
(50017795, '果岭洞杯', 3, 50017791, 3, ',50010728,50017776,50017791,50017795,', 0),
(50017796, '果岭叉', 4, 50017791, 3, ',50010728,50017776,50017791,50017796,', 0),
(50017797, '果岭草', 5, 50017791, 3, ',50010728,50017776,50017791,50017797,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50017798, '果岭旗标', 6, 50017791, 3, ',50010728,50017776,50017791,50017798,', 0),
(50017799, '高尔夫鞋钉', 7, 50017791, 3, ',50010728,50017776,50017791,50017799,', 0),
(50017820, '高尔夫球迷用品', 8, 50017791, 3, ',50010728,50017776,50017791,50017820,', 0),
(50017800, '更多', 9, 50017791, 3, ',50010728,50017776,50017791,50017800,', 0),
(50006857, '寿司帘', 0, 50012792, 3, ',50016349,50008281,50012792,50006857,', 0),
(50011617, '寿司套件/料理套件', 1, 50012792, 3, ',50016349,50008281,50012792,50011617,', 0),
(50012797, '第一套人民币', 0, 50012796, 3, ',23,2310,50012796,50012797,', 0),
(50012798, '第二套人民币', 1, 50012796, 3, ',23,2310,50012796,50012798,', 0),
(50012799, '第三套人民币', 2, 50012796, 3, ',23,2310,50012796,50012799,', 0),
(50012800, '纪念币', 3, 50012796, 3, ',23,2310,50012796,50012800,', 0),
(50012803, '外汇兑换券', 6, 50012796, 3, ',23,2310,50012796,50012803,', 0),
(50012804, '国库券', 7, 50012796, 3, ',23,2310,50012796,50012804,', 0),
(50006254, '影室灯', 0, 50012846, 3, ',50008090,50024097,50012846,50006254,', 0),
(50006253, '摄影台/静物台', 1, 50012846, 3, ',50008090,50024097,50012846,50006253,', 0),
(50012847, '摄影棚', 2, 50012846, 3, ',50008090,50024097,50012846,50012847,', 0),
(50006257, '反光器具', 3, 50012846, 3, ',50008090,50024097,50012846,50006257,', 0),
(50006255, '背景布类', 3, 50012846, 3, ',50008090,50024097,50012846,50006255,', 0),
(50006256, '辅助道具类', 4, 50012846, 3, ',50008090,50024097,50012846,50006256,', 0),
(50050610, '外拍灯', 5, 50012846, 3, ',50008090,50024097,50012846,50050610,', 0),
(50050611, '灯附件', 6, 50012846, 3, ',50008090,50024097,50012846,50050611,', 0),
(50006260, '柔光器具', 70, 50012846, 3, ',50008090,50024097,50012846,50006260,', 0),
(50013622, '填缝/调和辅料', 0, 50013321, 3, ',27,50013222,50013321,50013622,', 0),
(50013624, '磨砂工具', 2, 50013321, 3, ',27,50013222,50013321,50013624,', 0),
(50013625, '胶粘/补缝辅料', 3, 50013321, 3, ',27,50013222,50013321,50013625,', 0),
(50013626, '五金工具', 4, 50013321, 3, ',27,50013222,50013321,50013626,', 0),
(50022311, '批嵌材料', 5, 50013321, 3, ',27,50013222,50013321,50022311,', 0),
(50022312, '涂料添加剂', 6, 50013321, 3, ',27,50013222,50013321,50022312,', 0),
(50022313, '色浆', 7, 50013321, 3, ',27,50013222,50013321,50022313,', 0),
(50022314, '色精', 8, 50013321, 3, ',27,50013222,50013321,50022314,', 0),
(50022315, '虫胶漆片', 9, 50013321, 3, ',27,50013222,50013321,50022315,', 0),
(50022316, '清油', 10, 50013321, 3, ',27,50013222,50013321,50022316,', 0),
(50022317, '红丹粉/铅红', 11, 50013321, 3, ',27,50013222,50013321,50022317,', 0),
(50022318, '界面剂', 12, 50013321, 3, ',27,50013222,50013321,50022318,', 0),
(50013344, '蹲便器配件', 13, 50013332, 3, ',27,50020007,50013332,50013344,', 0),
(50013350, '进水软管', 19, 50013332, 3, ',27,50020007,50013332,50013350,', 0),
(50013818, '卫浴五金套件', 23, 50013332, 3, ',27,50020007,50013332,50013818,', 0),
(50014921, '其它卫浴配件', 24, 50013332, 3, ',27,50020007,50013332,50014921,', 0),
(50013611, '感应龙头', 0, 50013352, 3, ',27,50020007,50013352,50013611,', 0),
(50013613, '烘手器', 2, 50013352, 3, ',27,50020007,50013352,50013613,', 0),
(50013614, '手纸箱', 3, 50013352, 3, ',27,50020007,50013352,50013614,', 0),
(50021718, '干发器', 5, 50013352, 3, ',27,50020007,50013352,50021718,', 0),
(50013652, '滚筒刷', 0, 50013359, 3, ',50020485,50020487,50013359,50013652,', 0),
(50013653, '羊毛刷', 1, 50013359, 3, ',50020485,50020487,50013359,50013653,', 0),
(50013654, '排笔', 2, 50013359, 3, ',50020485,50020487,50013359,50013654,', 0),
(50013655, '毛笔', 3, 50013359, 3, ',50020485,50020487,50013359,50013655,', 0),
(50013656, '油画笔', 4, 50013359, 3, ',50020485,50020487,50013359,50013656,', 0),
(50013658, '泥板', 6, 50013359, 3, ',50020485,50020487,50013359,50013658,', 0),
(50013659, '其它漆工工具', 7, 50013359, 3, ',50020485,50020487,50013359,50013659,', 0),
(50013623, '其他涂刷工具', 8, 50013359, 3, ',50020485,50020487,50013359,50013623,', 0),
(50013436, '接头', 0, 50013435, 3, ',50020332,50020362,50013435,50013436,', 0),
(50013437, '螺母', 1, 50013435, 3, ',50020332,50020362,50013435,50013437,', 0),
(50013438, '弯头', 2, 50013435, 3, ',50020332,50020362,50013435,50013438,', 0),
(50013439, '三通', 3, 50013435, 3, ',50020332,50020362,50013435,50013439,', 0),
(50013440, '四通', 4, 50013435, 3, ',50020332,50020362,50013435,50013440,', 0),
(50013441, '管堵', 5, 50013435, 3, ',50020332,50020362,50013435,50013441,', 0),
(50013442, '管帽', 6, 50013435, 3, ',50020332,50020362,50013435,50013442,', 0),
(50013449, '尼龙绳', 0, 50013448, 3, ',50020485,50020486,50013448,50013449,', 0),
(50013450, '涤纶绳', 1, 50013448, 3, ',50020485,50020486,50013448,50013450,', 0),
(50013451, '丙烯绳', 2, 50013448, 3, ',50020485,50020486,50013448,50013451,', 0),
(50013452, '宠物链', 3, 50013448, 3, ',50020485,50020486,50013448,50013452,', 0),
(50013453, '铁环链', 4, 50013448, 3, ',50020485,50020486,50013448,50013453,', 0),
(50013454, '花蓝螺丝', 5, 50013448, 3, ',50020485,50020486,50013448,50013454,', 0),
(50013455, '套环', 6, 50013448, 3, ',50020485,50020486,50013448,50013455,', 0),
(50013456, 'S钩', 7, 50013448, 3, ',50020485,50020486,50013448,50013456,', 0),
(50013805, '其它', 8, 50013448, 3, ',50020485,50020486,50013448,50013805,', 0),
(50013594, '甲醛清除剂', 0, 50013471, 3, ',27,2159,50013471,50013594,', 0),
(50013595, '笨氨清除剂', 1, 50013471, 3, ',27,2159,50013471,50013595,', 0),
(50013596, '其它', 2, 50013471, 3, ',27,2159,50013471,50013596,', 0),
(50022269, '甲醛检测剂/自测盒', 3, 50013471, 3, ',27,2159,50013471,50022269,', 0),
(50013597, '活性炭/竹炭包', 0, 50013472, 3, ',27,2159,50013472,50013597,', 0),
(50013598, '除味剂', 1, 50013472, 3, ',27,2159,50013472,50013598,', 0),
(50013599, '炭雕', 2, 50013472, 3, ',27,2159,50013472,50013599,', 0),
(50013605, '净化液/净化器', 4, 50013472, 3, ',27,2159,50013472,50013605,', 0),
(50013600, '其它', 5, 50013472, 3, ',27,2159,50013472,50013600,', 0),
(50013601, '清洗液', 0, 50013473, 3, ',27,2159,50013473,50013601,', 0),
(50013602, '护理蜡', 1, 50013473, 3, ',27,2159,50013473,50013602,', 0),
(50013603, '保养精油', 2, 50013473, 3, ',27,2159,50013473,50013603,', 0),
(50013604, '其它', 3, 50013473, 3, ',27,2159,50013473,50013604,', 0),
(50013552, '十字卡', 0, 50013520, 3, ',27,50008696,50013520,50013552,', 0),
(50013553, '勾缝剂', 1, 50013520, 3, ',27,50008696,50013520,50013553,', 0),
(50013554, '瓷砖胶', 2, 50013520, 3, ',27,50008696,50013520,50013554,', 0),
(50013555, '云石胶', 3, 50013520, 3, ',27,50008696,50013520,50013555,', 0),
(50013556, '密封条', 0, 50013521, 3, ',27,50008696,50013521,50013556,', 0),
(50013557, '泡沫胶', 1, 50013521, 3, ',27,50008696,50013521,50013557,', 0),
(50013558, '踢脚线', 0, 50013522, 3, ',27,50008696,50013522,50013558,', 0),
(50013559, '压边条', 1, 50013522, 3, ',27,50008696,50013522,50013559,', 0),
(50013560, '地板垫', 2, 50013522, 3, ',27,50008696,50013522,50013560,', 0),
(50013561, '钢丝吊码', 0, 50013523, 3, ',27,50008696,50013523,50013561,', 0),
(50013562, '玻璃夹', 1, 50013523, 3, ',27,50008696,50013523,50013562,', 0),
(50013563, '玻璃拉杆', 2, 50013523, 3, ',27,50008696,50013523,50013563,', 0),
(50013564, '玻璃铰链', 3, 50013523, 3, ',27,50008696,50013523,50013564,', 0),
(50013565, '玻璃钉', 4, 50013523, 3, ',27,50008696,50013523,50013565,', 0),
(50013566, '玻璃抓', 5, 50013523, 3, ',27,50008696,50013523,50013566,', 0),
(50013567, '楼梯玻璃连接', 6, 50013523, 3, ',27,50008696,50013523,50013567,', 0),
(50013568, '玻璃胶', 7, 50013523, 3, ',27,50008696,50013523,50013568,', 0),
(50013569, '玻璃压条', 8, 50013523, 3, ',27,50008696,50013523,50013569,', 0),
(50013570, '玻璃钻头', 9, 50013523, 3, ',27,50008696,50013523,50013570,', 0),
(50013571, '基膜', 0, 50013524, 3, ',27,50008696,50013524,50013571,', 0),
(50013572, '壁纸铲刀', 1, 50013524, 3, ',27,50008696,50013524,50013572,', 0),
(50013533, '电焊口罩', 0, 50013526, 3, ',50020332,50013226,50013526,50013533,', 0),
(50013534, '防尘口罩', 1, 50013526, 3, ',50020332,50013226,50013526,50013534,', 0),
(50013535, '防毒口罩', 2, 50013526, 3, ',50020332,50013226,50013526,50013535,', 0),
(50022326, '医用口罩', 3, 50013526, 3, ',50020332,50013226,50013526,50022326,', 0),
(50022327, '呼吸器', 4, 50013526, 3, ',50020332,50013226,50013526,50022327,', 0),
(50022328, '电动送风面罩', 5, 50013526, 3, ',50020332,50013226,50013526,50022328,', 0),
(50013536, '无尘手套', 0, 50013527, 3, ',50020332,50013226,50013527,50013536,', 0),
(50013537, '棉纱手套', 1, 50013527, 3, ',50020332,50013226,50013527,50013537,', 0),
(50013538, '点塑手套', 2, 50013527, 3, ',50020332,50013226,50013527,50013538,', 0),
(50013539, '园艺手套', 3, 50013527, 3, ',50020332,50013226,50013527,50013539,', 0),
(50013540, '橡胶防水手套', 4, 50013527, 3, ',50020332,50013226,50013527,50013540,', 0),
(50013541, '隔热手套', 5, 50013527, 3, ',50020332,50013226,50013527,50013541,', 0),
(50013542, '防割手套', 6, 50013527, 3, ',50020332,50013226,50013527,50013542,', 0),
(50022329, '绝缘手套', 7, 50013527, 3, ',50020332,50013226,50013527,50022329,', 0),
(50013543, '工矿鞋', 0, 50013529, 3, ',50020332,50013226,50013529,50013543,', 0),
(50013544, '防砸皮鞋', 1, 50013529, 3, ',50020332,50013226,50013529,50013544,', 0),
(50022330, '绝缘靴', 2, 50013529, 3, ',50020332,50013226,50013529,50022330,', 0),
(50022331, '耐酸碱胶靴', 3, 50013529, 3, ',50020332,50013226,50013529,50022331,', 0),
(50013545, '焊工墨镜', 0, 50013530, 3, ',50020332,50013226,50013530,50013545,', 0),
(50013546, '防紫外线镜', 1, 50013530, 3, ',50020332,50013226,50013530,50013546,', 0),
(50013547, '防风镜', 2, 50013530, 3, ',50020332,50013226,50013530,50013547,', 0),
(50013548, '防护镜', 3, 50013530, 3, ',50020332,50013226,50013530,50013548,', 0),
(50022324, '防护面罩', 4, 50013530, 3, ',50020332,50013226,50013530,50022324,', 0),
(50022325, '紧急冲淋装置及洗眼器', 5, 50013530, 3, ',50020332,50013226,50013530,50022325,', 0),
(50013549, '防静电服', 0, 50013531, 3, ',50020332,50013226,50013531,50013549,', 0),
(50013550, '防尘服', 1, 50013531, 3, ',50020332,50013226,50013531,50013550,', 0),
(50013551, '反光安全服', 2, 50013531, 3, ',50020332,50013226,50013531,50013551,', 0),
(50022332, '防化服', 3, 50013531, 3, ',50020332,50013226,50013531,50022332,', 0),
(50022333, '防酸碱工作服', 4, 50013531, 3, ',50020332,50013226,50013531,50022333,', 0),
(50022334, '阻燃服', 5, 50013531, 3, ',50020332,50013226,50013531,50022334,', 0),
(50013858, '鲁比克360魔方', 2, 50013859, 3, ',25,50023498,50013859,50013858,', 0),
(50013860, '魔方周边', 3, 50013859, 3, ',25,50023498,50013859,50013860,', 0),
(50013862, '魔板', 4, 50013859, 3, ',25,50023498,50013859,50013862,', 0),
(50014785, '冲锋衣', 0, 50013928, 3, ',50013886,50013888,50013928,50014785,', 0),
(50014786, '冲锋裤', 1, 50013928, 3, ',50013886,50013888,50013928,50014786,', 0),
(50015978, '冲锋衣裤套装', 2, 50013928, 3, ',50013886,50013888,50013928,50015978,', 0),
(50014787, '抓绒/软壳衣', 0, 50013930, 3, ',50013886,50013888,50013930,50014787,', 0),
(50014788, '抓绒/软壳裤', 1, 50013930, 3, ',50013886,50013888,50013930,50014788,', 0),
(50015980, '抓绒/软壳衣裤套装', 2, 50013930, 3, ',50013886,50013888,50013930,50015980,', 0),
(50014800, '滑雪衣', 0, 50013937, 3, ',50013886,50013888,50013937,50014800,', 0),
(50014801, '滑雪裤', 1, 50013937, 3, ',50013886,50013888,50013937,50014801,', 0),
(50015983, '滑雪衣裤套装', 2, 50013937, 3, ',50013886,50013888,50013937,50015983,', 0),
(50013984, '美发刀剪', 1, 50013983, 3, ',21,50009206,50013983,50013984,', 0),
(50013985, '裁缝刀剪', 2, 50013983, 3, ',21,50009206,50013983,50013985,', 0),
(50013986, '家用剪刀', 3, 50013983, 3, ',21,50009206,50013983,50013986,', 0),
(50013987, '厨房剪刀', 4, 50013983, 3, ',21,50009206,50013983,50013987,', 0),
(50013988, '园艺刀剪', 5, 50013983, 3, ',21,50009206,50013983,50013988,', 0),
(50014102, '滑雪板', 0, 50014025, 3, ',50013886,50013891,50014025,50014102,', 0),
(50014103, '雪杖', 1, 50014025, 3, ',50013886,50013891,50014025,50014103,', 0),
(50014104, '固定器', 2, 50014025, 3, ',50013886,50013891,50014025,50014104,', 0),
(50014105, '滑雪护具、头盔', 3, 50014025, 3, ',50013886,50013891,50014025,50014105,', 0),
(50014106, '滑雪眼镜', 4, 50014025, 3, ',50013886,50013891,50014025,50014106,', 0),
(50014112, '其他滑雪装备', 8, 50014025, 3, ',50013886,50013891,50014025,50014112,', 0),
(50014050, '绳索', 0, 50014043, 3, ',50013886,50013891,50014043,50014050,', 0),
(50014051, '安全带', 1, 50014043, 3, ',50013886,50013891,50014043,50014051,', 0),
(50014057, '锁具', 2, 50014043, 3, ',50013886,50013891,50014043,50014057,', 0),
(50014058, '保护器', 3, 50014043, 3, ',50013886,50013891,50014043,50014058,', 0),
(50014059, '扁带', 4, 50014043, 3, ',50013886,50013891,50014043,50014059,', 0),
(50014060, '快挂(专业攀岩用)', 5, 50014043, 3, ',50013886,50013891,50014043,50014060,', 0),
(50015945, '滑轮', 6, 50014043, 3, ',50013886,50013891,50014043,50015945,', 0),
(50014061, '岩石塞', 7, 50014043, 3, ',50013886,50013891,50014043,50014061,', 0),
(50014062, '岩钉', 8, 50014043, 3, ',50013886,50013891,50014043,50014062,', 0),
(50014063, '膨胀钉', 9, 50014043, 3, ',50013886,50013891,50014043,50014063,', 0),
(50014064, '挂片', 10, 50014043, 3, ',50013886,50013891,50014043,50014064,', 0),
(50014065, '镁粉袋', 11, 50014043, 3, ',50013886,50013891,50014043,50014065,', 0),
(50014066, '抱石垫', 12, 50014043, 3, ',50013886,50013891,50014043,50014066,', 0),
(50014067, '头盔', 13, 50014043, 3, ',50013886,50013891,50014043,50014067,', 0),
(50014069, '冰镐', 15, 50014043, 3, ',50013886,50013891,50014043,50014069,', 0),
(50014070, '冰爪', 16, 50014043, 3, ',50013886,50013891,50014043,50014070,', 0),
(50014071, '冰锥', 17, 50014043, 3, ',50013886,50013891,50014043,50014071,', 0),
(50014073, '上升器', 19, 50014043, 3, ',50013886,50013891,50014043,50014073,', 0),
(50014074, '下降器', 20, 50014043, 3, ',50013886,50013891,50014043,50014074,', 0),
(50018251, '攀岩绳包', 21, 50014043, 3, ',50013886,50013891,50014043,50018251,', 0),
(50014100, '其他装备', 22, 50014043, 3, ',50013886,50013891,50014043,50014100,', 0),
(50014159, '冲浪板', 1, 50014125, 3, ',50013886,50013891,50014125,50014159,', 0),
(50014162, '舵', 4, 50014125, 3, ',50013886,50013891,50014125,50014162,', 0),
(50014163, '脚绳', 5, 50014125, 3, ',50013886,50013891,50014125,50014163,', 0),
(50014164, '蜡块', 6, 50014125, 3, ',50013886,50013891,50014125,50014164,', 0),
(50014165, '防寒衣/防磨衣', 7, 50014125, 3, ',50013886,50013891,50014125,50014165,', 0),
(50014166, '防滑垫', 8, 50014125, 3, ',50013886,50013891,50014125,50014166,', 0),
(50014167, '冲浪板背袋', 9, 50014125, 3, ',50013886,50013891,50014125,50014167,', 0),
(50014168, '鼻头', 10, 50014125, 3, ',50013886,50013891,50014125,50014168,', 0),
(50014179, '滑水板', 11, 50014125, 3, ',50013886,50013891,50014125,50014179,', 0),
(50014190, '滑水板套', 12, 50014125, 3, ',50013886,50013891,50014125,50014190,', 0),
(50014191, '滑水绳', 13, 50014125, 3, ',50013886,50013891,50014125,50014191,', 0),
(50014192, '滑水鞋', 14, 50014125, 3, ',50013886,50013891,50014125,50014192,', 0),
(50014193, '救生衣', 15, 50014125, 3, ',50013886,50013891,50014125,50014193,', 0),
(50014194, '滑水手套', 16, 50014125, 3, ',50013886,50013891,50014125,50014194,', 0),
(50014197, '帆板', 19, 50014125, 3, ',50013886,50013891,50014125,50014197,', 0),
(50014215, '其他装备', 20, 50014125, 3, ',50013886,50013891,50014125,50014215,', 0),
(50014129, '皮划艇充气艇', 0, 50014126, 3, ',50013886,50013891,50014126,50014129,', 0),
(50014130, '独木舟', 1, 50014126, 3, ',50013886,50013891,50014126,50014130,', 0),
(50014131, '帆船', 2, 50014126, 3, ',50013886,50013891,50014126,50014131,', 0),
(50014132, '龙舟', 3, 50014126, 3, ',50013886,50013891,50014126,50014132,', 0),
(50014208, '摩托艇', 5, 50014126, 3, ',50013886,50013891,50014126,50014208,', 0),
(50014214, '船桨/划艇配件', 7, 50014126, 3, ',50013886,50013891,50014126,50014214,', 0),
(50014133, '其他', 8, 50014126, 3, ',50013886,50013891,50014126,50014133,', 0),
(50014134, '面镜', 0, 50014127, 3, ',50013886,50013891,50014127,50014134,', 0),
(50014135, '呼吸管/呼吸器', 1, 50014127, 3, ',50013886,50013891,50014127,50014135,', 0),
(50014136, '脚蹼', 2, 50014127, 3, ',50013886,50013891,50014127,50014136,', 0),
(50014141, '手蹼', 3, 50014127, 3, ',50013886,50013891,50014127,50014141,', 0),
(50014138, '潜水帽', 5, 50014127, 3, ',50013886,50013891,50014127,50014138,', 0),
(50014139, '潜水靴', 6, 50014127, 3, ',50013886,50013891,50014127,50014139,', 0),
(50014140, '潜水袜', 7, 50014127, 3, ',50013886,50013891,50014127,50014140,', 0),
(50014142, '呼吸调节器', 10, 50014127, 3, ',50013886,50013891,50014127,50014142,', 0),
(50014143, '浮力调整器(BC)', 11, 50014127, 3, ',50013886,50013891,50014127,50014143,', 0),
(50014144, '气瓶', 12, 50014127, 3, ',50013886,50013891,50014127,50014144,', 0),
(50014145, '配重和配重带', 13, 50014127, 3, ',50013886,50013891,50014127,50014145,', 0),
(50014148, '手写板', 16, 50014127, 3, ',50013886,50013891,50014127,50014148,', 0),
(50014149, '潜水减压表', 17, 50014127, 3, ',50013886,50013891,50014127,50014149,', 0),
(50014150, '潜水浮标', 18, 50014127, 3, ',50013886,50013891,50014127,50014150,', 0),
(50014151, '潜水电脑', 19, 50014127, 3, ',50013886,50013891,50014127,50014151,', 0),
(50014153, '潜水仪表', 20, 50014127, 3, ',50013886,50013891,50014127,50014153,', 0),
(50014152, '水下推进器', 21, 50014127, 3, ',50013886,50013891,50014127,50014152,', 0),
(50014154, '探棒', 23, 50014127, 3, ',50013886,50013891,50014127,50014154,', 0),
(50014155, '潜水箱包', 24, 50014127, 3, ',50013886,50013891,50014127,50014155,', 0),
(50014158, '其他装备', 27, 50014127, 3, ',50013886,50013891,50014127,50014158,', 0),
(50014209, '滑翔伞', 7, 50014200, 3, ',50013886,50013891,50014200,50014209,', 0),
(50014210, '其他', 9, 50014200, 3, ',50013886,50013891,50014200,50014210,', 0),
(260605, '玻璃水', 13, 50014507, 3, ',26,50014479,50014507,260605,', 0),
(50008924, '防冻液', 14, 50014507, 3, ',26,50014479,50014507,50008924,', 0),
(260607, '机油添加剂', 16, 50014507, 3, ',26,50014479,50014507,260607,', 0),
(50010894, '汽油添加剂', 18, 50014507, 3, ',26,50014479,50014507,50010894,', 0),
(260212, '汽油发动机品牌润滑油', 21, 50014507, 3, ',26,50014479,50014507,260212,', 0),
(50016286, '专车专用润滑油', 22, 50014507, 3, ',26,50014479,50014507,50016286,', 0),
(50016238, '柴油机油', 25, 50014507, 3, ',26,50014479,50014507,50016238,', 0),
(50016283, '齿轮油', 26, 50014507, 3, ',26,50014479,50014507,50016283,', 0),
(50016284, '变速箱油/波箱油/分动箱油', 28, 50014507, 3, ',26,50014479,50014507,50016284,', 0),
(50017081, '刹车/助力油', 30, 50014507, 3, ',26,50014479,50014507,50017081,', 0),
(50014603, '其它汽车保养/添加剂', 33, 50014507, 3, ',26,50014479,50014507,50014603,', 0),
(50012857, '节油器', 90, 50014507, 3, ',26,50014479,50014507,50012857,', 0),
(50022986, '齿轮油/柴油添加剂', 91, 50014507, 3, ',26,50014479,50014507,50022986,', 0),
(50023093, '清洗剂/养护剂', 92, 50014507, 3, ',26,50014479,50014507,50023093,', 0),
(50018713, '车釉/车漆镀膜', 0, 50014509, 3, ',26,50014479,50014509,50018713,', 0),
(50002702, '补漆笔', 1, 50014509, 3, ',26,50014479,50014509,50002702,', 0),
(50018714, '车蜡', 1, 50014509, 3, ',26,50014479,50014509,50018714,', 0),
(50014614, '抛光机', 5, 50014509, 3, ',26,50014479,50014509,50014614,', 0),
(50014615, '封釉机', 6, 50014509, 3, ',26,50014479,50014509,50014615,', 0),
(50014616, '电烤枪', 7, 50014509, 3, ',26,50014479,50014509,50014616,', 0),
(50018940, '车用砂纸', 8, 50014509, 3, ',26,50014479,50014509,50018940,', 0),
(50014617, '刮板', 9, 50014509, 3, ',26,50014479,50014509,50014617,', 0),
(50014618, '其它车用美容清洗工具', 20, 50014509, 3, ',26,50014479,50014509,50014618,', 0),
(260602, '其它美容保养用品', 62, 50014509, 3, ',26,50014479,50014509,260602,', 0),
(50022887, '抛光盘', 63, 50014509, 3, ',26,50014479,50014509,50022887,', 0),
(50022888, '打蜡海绵', 64, 50014509, 3, ',26,50014479,50014509,50022888,', 0),
(50017088, '北京', 0, 50017847, 3, ',50025707,50017087,50017847,50017088,', 0),
(50017848, '密云', 1, 50017847, 3, ',50025707,50017087,50017847,50017848,', 0),
(50017849, '怀柔', 2, 50017847, 3, ',50025707,50017087,50017847,50017849,', 0),
(50017850, '通州', 3, 50017847, 3, ',50025707,50017087,50017847,50017850,', 0),
(50017851, '延庆', 4, 50017847, 3, ',50025707,50017087,50017847,50017851,', 0),
(50017853, '房山', 5, 50017847, 3, ',50025707,50017087,50017847,50017853,', 0),
(50017854, '顺义', 6, 50017847, 3, ',50025707,50017087,50017847,50017854,', 0),
(50017855, '昌平', 7, 50017847, 3, ',50025707,50017087,50017847,50017855,', 0),
(50017856, '其它', 8, 50017847, 3, ',50025707,50017087,50017847,50017856,', 0),
(50017873, '家用麻将', 0, 50017872, 3, ',50010728,50017871,50017872,50017873,', 0),
(50017874, '旅行简装麻将', 1, 50017872, 3, ',50010728,50017871,50017872,50017874,', 0),
(50017875, '纸麻将', 2, 50017872, 3, ',50010728,50017871,50017872,50017875,', 0),
(50017877, '麻将桌', 3, 50017872, 3, ',50010728,50017871,50017872,50017877,', 0),
(50017878, '自动麻将机', 4, 50017872, 3, ',50010728,50017871,50017872,50017878,', 0),
(50017879, '麻将垫', 5, 50017872, 3, ',50010728,50017871,50017872,50017879,', 0),
(50017880, '麻将尺', 6, 50017872, 3, ',50010728,50017871,50017872,50017880,', 0),
(50017881, '清洁用品', 7, 50017872, 3, ',50010728,50017871,50017872,50017881,', 0),
(50017882, '麻将教材', 8, 50017872, 3, ',50010728,50017871,50017872,50017882,', 0),
(50017883, '更多', 9, 50017872, 3, ',50010728,50017871,50017872,50017883,', 0),
(50017915, '太极服', 0, 50017914, 3, ',50010728,50017913,50017914,50017915,', 0),
(50017916, '太极鞋', 1, 50017914, 3, ',50010728,50017913,50017914,50017916,', 0),
(50017917, '太极剑', 2, 50017914, 3, ',50010728,50017913,50017914,50017917,', 0),
(50017918, '太极扇', 3, 50017914, 3, ',50010728,50017913,50017914,50017918,', 0),
(50017919, '太极柔力球', 4, 50017914, 3, ',50010728,50017913,50017914,50017919,', 0),
(50017920, '太极佛尘', 5, 50017914, 3, ',50010728,50017913,50017914,50017920,', 0),
(50017921, '太极棍', 6, 50017914, 3, ',50010728,50017913,50017914,50017921,', 0),
(50017924, '更多太极配件', 8, 50017914, 3, ',50010728,50017913,50017914,50017924,', 0),
(50017926, '跆拳道服', 0, 50017925, 3, ',50010728,50017913,50017925,50017926,', 0),
(50017927, '跆拳道鞋', 1, 50017925, 3, ',50010728,50017913,50017925,50017927,', 0),
(50017928, '跆拳道道带', 2, 50017925, 3, ',50010728,50017913,50017925,50017928,', 0),
(50017929, '跆拳道包', 3, 50017925, 3, ',50010728,50017913,50017925,50017929,', 0),
(50017930, '跆拳道脚靶', 4, 50017925, 3, ',50010728,50017913,50017925,50017930,', 0),
(50017932, '跆拳道表演板', 6, 50017925, 3, ',50010728,50017913,50017925,50017932,', 0),
(50017934, '跆拳道场馆垫', 7, 50017925, 3, ',50010728,50017913,50017925,50017934,', 0),
(50017936, '更多跆拳道配件', 9, 50017925, 3, ',50010728,50017913,50017925,50017936,', 0),
(50017938, '拳击手套', 0, 50017937, 3, ',50010728,50017913,50017937,50017938,', 0),
(50017939, '拳击头盔', 1, 50017937, 3, ',50010728,50017913,50017937,50017939,', 0),
(50017940, '拳击服', 2, 50017937, 3, ',50010728,50017913,50017937,50017940,', 0),
(50017941, '拳击鞋', 3, 50017937, 3, ',50010728,50017913,50017937,50017941,', 0),
(50017942, '拳击护具', 4, 50017937, 3, ',50010728,50017913,50017937,50017942,', 0),
(50017943, '拳击沙袋', 5, 50017937, 3, ',50010728,50017913,50017937,50017943,', 0),
(50017944, '速度球/发泄球', 6, 50017937, 3, ',50010728,50017913,50017937,50017944,', 0),
(50017945, '拳击擂台', 7, 50017937, 3, ',50010728,50017913,50017937,50017945,', 0),
(50017946, '更多拳击配件', 8, 50017937, 3, ',50010728,50017913,50017937,50017946,', 0),
(50019537, '沙袋架', 9, 50017937, 3, ',50010728,50017913,50017937,50019537,', 0),
(50017948, '空手道服', 0, 50017947, 3, ',50010728,50017913,50017947,50017948,', 0),
(50017949, '空手道手套', 1, 50017947, 3, ',50010728,50017913,50017947,50017949,', 0),
(50017950, '空手道道带', 2, 50017947, 3, ',50010728,50017913,50017947,50017950,', 0),
(50017951, '空手道练习靶', 3, 50017947, 3, ',50010728,50017913,50017947,50017951,', 0),
(50017952, '空手道护具', 4, 50017947, 3, ',50010728,50017913,50017947,50017952,', 0),
(50017953, '空手道教材', 5, 50017947, 3, ',50010728,50017913,50017947,50017953,', 0),
(50017954, '更多空手道配件', 6, 50017947, 3, ',50010728,50017913,50017947,50017954,', 0),
(50017956, '摔跤服', 0, 50017955, 3, ',50010728,50017913,50017955,50017956,', 0),
(50017957, '摔跤鞋', 1, 50017955, 3, ',50010728,50017913,50017955,50017957,', 0),
(50017958, '摔跤垫', 2, 50017955, 3, ',50010728,50017913,50017955,50017958,', 0),
(50017959, '摔跤布袋', 3, 50017955, 3, ',50010728,50017913,50017955,50017959,', 0),
(50017960, '摔跤教材', 4, 50017955, 3, ',50010728,50017913,50017955,50017960,', 0),
(50017961, '更多摔跤配件', 5, 50017955, 3, ',50010728,50017913,50017955,50017961,', 0),
(50017965, '柔道服', 0, 50017963, 3, ',50010728,50017913,50017963,50017965,', 0),
(50017966, '柔道腰带', 1, 50017963, 3, ',50010728,50017913,50017963,50017966,', 0),
(50017967, '柔道垫', 2, 50017963, 3, ',50010728,50017913,50017963,50017967,', 0),
(50017968, '柔道教材', 3, 50017963, 3, ',50010728,50017913,50017963,50017968,', 0),
(50017969, '更多柔道配件', 4, 50017963, 3, ',50010728,50017913,50017963,50017969,', 0),
(50017971, '竹剑/木刀', 0, 50017970, 3, ',50010728,50017913,50017970,50017971,', 0),
(50017973, '剑道服', 1, 50017970, 3, ',50010728,50017913,50017970,50017973,', 0),
(50017974, '剑道教材', 2, 50017970, 3, ',50010728,50017913,50017970,50017974,', 0),
(50017975, '更多剑道配件', 3, 50017970, 3, ',50010728,50017913,50017970,50017975,', 0),
(50018007, '飞镖盘/飞镖靶', 0, 50018006, 3, ',50010728,50018005,50018006,50018007,', 0),
(50018008, '飞镖', 1, 50018006, 3, ',50010728,50018005,50018006,50018008,', 0),
(50018009, '镖翼/尾翼', 2, 50018006, 3, ',50010728,50018005,50018006,50018009,', 0),
(50018010, '飞镖杆', 3, 50018006, 3, ',50010728,50018005,50018006,50018010,', 0),
(50018011, '飞镖套装', 4, 50018006, 3, ',50010728,50018005,50018006,50018011,', 0),
(50018012, '更多飞镖配件', 5, 50018006, 3, ',50010728,50018005,50018006,50018012,', 0),
(50018014, '桌上足球台', 0, 50018013, 3, ',50010728,50018005,50018013,50018014,', 0),
(50018015, '桌上足球用球', 1, 50018013, 3, ',50010728,50018005,50018013,50018015,', 0),
(50018016, '更多桌上足球配件', 2, 50018013, 3, ',50010728,50018005,50018013,50018016,', 0),
(50018018, '沙狐球台', 0, 50018017, 3, ',50010728,50018005,50018017,50018018,', 0),
(50018019, '沙狐球', 1, 50018017, 3, ',50010728,50018005,50018017,50018019,', 0),
(50018020, '沙狐球沙', 2, 50018017, 3, ',50010728,50018005,50018017,50018020,', 0),
(50018021, '更多沙狐球配件', 3, 50018017, 3, ',50010728,50018005,50018017,50018021,', 0),
(50018028, '空竹', 0, 50018027, 3, ',50010728,50018025,50018027,50018028,', 0),
(50018029, '空竹抖杆', 1, 50018027, 3, ',50010728,50018025,50018027,50018029,', 0),
(50018031, '更多空竹配件', 3, 50018027, 3, ',50010728,50018025,50018027,50018031,', 0),
(50018034, '风筝', 0, 50018033, 3, ',50010728,50018025,50018033,50018034,', 0),
(50018035, '风筝线', 1, 50018033, 3, ',50010728,50018025,50018033,50018035,', 0),
(50018036, '绕线板', 2, 50018033, 3, ',50010728,50018025,50018033,50018036,', 0),
(50018037, '更多风筝配件', 3, 50018033, 3, ',50010728,50018025,50018033,50018037,', 0),
(50018200, '速滑眼镜', 0, 50018199, 3, ',50010728,50018194,50018199,50018200,', 0),
(50018201, '冰刀刀套', 1, 50018199, 3, ',50010728,50018194,50018199,50018201,', 0),
(50018202, '冰鞋套', 2, 50018199, 3, ',50010728,50018194,50018199,50018202,', 0),
(50018203, '冰球杆头', 3, 50018199, 3, ',50010728,50018194,50018199,50018203,', 0),
(50018204, '单刀片', 4, 50018199, 3, ',50010728,50018194,50018199,50018204,', 0),
(50018205, '冰鞋包', 5, 50018199, 3, ',50010728,50018194,50018199,50018205,', 0),
(50018206, '冰球球门', 6, 50018199, 3, ',50010728,50018194,50018199,50018206,', 0),
(50018207, '花式滑冰网袜', 7, 50018199, 3, ',50010728,50018194,50018199,50018207,', 0),
(50018208, '磨刀机', 8, 50018199, 3, ',50010728,50018194,50018199,50018208,', 0),
(50018209, '磨刀架', 9, 50018199, 3, ',50010728,50018194,50018199,50018209,', 0),
(50018210, '磨刀石', 10, 50018199, 3, ',50010728,50018194,50018199,50018210,', 0),
(50018211, '更多', 11, 50018199, 3, ',50010728,50018194,50018199,50018211,', 0),
(50018617, '苹果液晶屏', 0, 50018616, 3, ',50008090,50018326,50018616,50018617,', 0),
(50018618, '苹果内置电池', 1, 50018616, 3, ',50008090,50018326,50018616,50018618,', 0),
(50018619, '苹果扬声器', 2, 50018616, 3, ',50008090,50018326,50018616,50018619,', 0),
(50018743, '车篮/车筐', 0, 50018695, 3, ',50010728,2612,50018695,50018743,', 0),
(50018748, '脚撑/停车架', 5, 50018695, 3, ',50010728,2612,50018695,50018748,', 0),
(50018749, '泥除/挡泥板', 6, 50018695, 3, ',50010728,2612,50018695,50018749,', 0),
(50018751, '自行车内胎', 8, 50018695, 3, ',50010728,2612,50018695,50018751,', 0),
(50018752, '自行车外胎', 9, 50018695, 3, ',50010728,2612,50018695,50018752,', 0),
(50018753, '车圈/刀圈', 10, 50018695, 3, ',50010728,2612,50018695,50018753,', 0),
(50018754, '车条/幅条', 11, 50018695, 3, ',50010728,2612,50018695,50018754,', 0),
(50018756, '变速器/保护器', 13, 50018695, 3, ',50010728,2612,50018695,50018756,', 0),
(50018757, '脚踏/轴承/滚珠', 14, 50018695, 3, ',50010728,2612,50018695,50018757,', 0),
(50018758, '自行车车头碗', 15, 50018695, 3, ',50010728,2612,50018695,50018758,', 0),
(50018759, '自行车车把', 16, 50018695, 3, ',50010728,2612,50018695,50018759,', 0),
(50018760, '自行车把立', 17, 50018695, 3, ',50010728,2612,50018695,50018760,', 0),
(50018761, '自行车把套', 18, 50018695, 3, ',50010728,2612,50018695,50018761,', 0),
(50018762, '自行车车架', 19, 50018695, 3, ',50010728,2612,50018695,50018762,', 0),
(50018763, '座管/座杆', 20, 50018695, 3, ',50010728,2612,50018695,50018763,', 0),
(50018764, '坐垫/鞍座', 21, 50018695, 3, ',50010728,2612,50018695,50018764,', 0),
(50018765, '自行车刹车装置', 22, 50018695, 3, ',50010728,2612,50018695,50018765,', 0),
(50018767, '牙盘/曲柄/中轴', 24, 50018695, 3, ',50010728,2612,50018695,50018767,', 0),
(50018769, '自行车花鼓', 26, 50018695, 3, ',50010728,2612,50018695,50018769,', 0),
(50018771, '更多零件/配件', 28, 50018695, 3, ',50010728,2612,50018695,50018771,', 0),
(50018949, '前叉/避震装置', 29, 50018695, 3, ',50010728,2612,50018695,50018949,', 0),
(50018950, '自行车轮组', 30, 50018695, 3, ',50010728,2612,50018695,50018950,', 0),
(50019371, '自行车链条/链条扣', 32, 50018695, 3, ',50010728,2612,50018695,50019371,', 0),
(50019470, '自行车飞轮', 33, 50018695, 3, ',50010728,2612,50018695,50019470,', 0),
(50018723, '速降自行车', 0, 50018696, 3, ',50010728,2612,50018696,50018723,', 0),
(50018724, '斜躺自行车', 1, 50018696, 3, ',50010728,2612,50018696,50018724,', 0),
(261105, '电动车', 1, 50018696, 3, ',50010728,2612,50018696,261105,', 0),
(50018725, '越野公路车', 2, 50018696, 3, ',50010728,2612,50018696,50018725,', 0),
(50018726, '场地自行车', 3, 50018696, 3, ',50010728,2612,50018696,50018726,', 0),
(50018727, '广告自行车', 4, 50018696, 3, ',50010728,2612,50018696,50018727,', 0),
(50018728, '更多', 5, 50018696, 3, ',50010728,2612,50018696,50018728,', 0),
(50019369, '宠物自行车', 6, 50018696, 3, ',50010728,2612,50018696,50019369,', 0),
(50018699, '车用香水', 0, 50018698, 3, ',26,50014480,50018698,50018699,', 0),
(50018702, '车用香薰/香膏', 3, 50018698, 3, ',26,50014480,50018698,50018702,', 0),
(50018703, '车用空气净化/清新剂', 4, 50018698, 3, ',26,50014480,50018698,50018703,', 0),
(50010593, '车用炭类吸附品', 6, 50018698, 3, ',26,50014480,50018698,50010593,', 0),
(50016310, '香水补充液/替芯', 9, 50018698, 3, ',26,50014480,50018698,50016310,', 0),
(50016291, '其他香水净化用品', 10, 50018698, 3, ',26,50014480,50018698,50016291,', 0),
(50010896, '空气降温剂', 49, 50018698, 3, ',26,50014480,50018698,50010896,', 0),
(50018730, '多功能组合工具', 0, 50018729, 3, ',50010728,2612,50018729,50018730,', 0),
(50018731, '螺丝刀', 1, 50018729, 3, ',50010728,2612,50018729,50018731,', 0),
(50018732, '扳手', 2, 50018729, 3, ',50010728,2612,50018729,50018732,', 0),
(50018733, '线剪钳', 3, 50018729, 3, ',50010728,2612,50018729,50018733,', 0),
(50018734, '撬胎棒', 4, 50018729, 3, ',50010728,2612,50018729,50018734,', 0),
(50018735, '挫胎片', 5, 50018729, 3, ',50010728,2612,50018729,50018735,', 0),
(50018736, '补胎片', 6, 50018729, 3, ',50010728,2612,50018729,50018736,', 0),
(50018737, '补胎胶水', 7, 50018729, 3, ',50010728,2612,50018729,50018737,', 0),
(50018738, '截链器', 8, 50018729, 3, ',50010728,2612,50018729,50018738,', 0),
(50018739, '洗链器', 9, 50018729, 3, ',50010728,2612,50018729,50018739,', 0),
(50018740, '修车架', 10, 50018729, 3, ',50010728,2612,50018729,50018740,', 0),
(50018741, '润滑油', 11, 50018729, 3, ',50010728,2612,50018729,50018741,', 0),
(50018742, '更多修车工具', 12, 50018729, 3, ',50010728,2612,50018729,50018742,', 0),
(50018770, '气门芯', 27, 50018729, 3, ',50010728,2612,50018729,50018770,', 0),
(50015598, '发动机总成', 9, 50018783, 3, ',26,50018708,50018783,50015598,', 0),
(50022810, '发动机电脑', 27, 50018783, 3, ',26,50018708,50018783,50022810,', 0),
(50022812, '缸盖/缸体', 28, 50018783, 3, ',26,50018708,50018783,50022812,', 0),
(50015596, '气缸及部件', 29, 50018783, 3, ',26,50018708,50018783,50015596,', 0),
(50016294, '活塞连杆总成/连杆瓦', 32, 50018783, 3, ',26,50018708,50018783,50016294,', 0),
(50022816, '活塞/活塞环', 33, 50018783, 3, ',26,50018708,50018783,50022816,', 0),
(50022817, '曲轴/曲轴瓦/曲轴油封', 34, 50018783, 3, ',26,50018708,50018783,50022817,', 0),
(50015597, '皮带', 35, 50018783, 3, ',26,50018708,50018783,50015597,', 0),
(50015604, '涨紧轮', 36, 50018783, 3, ',26,50018708,50018783,50015604,', 0),
(50022820, '气门顶杆', 84, 50018783, 3, ',26,50018708,50018783,50022820,', 0),
(50022821, '气门油封', 85, 50018783, 3, ',26,50018708,50018783,50022821,', 0),
(50022823, '气门其他部件', 86, 50018783, 3, ',26,50018708,50018783,50022823,', 0),
(50022826, '机油泵/滤网', 87, 50018783, 3, ',26,50018708,50018783,50022826,', 0),
(50015618, '启动马达', 88, 50018783, 3, ',26,50018708,50018783,50015618,', 0),
(50018789, '其它发动系统配件', 89, 50018783, 3, ',26,50018708,50018783,50018789,', 0),
(50015610, '方向机总成', 0, 50018784, 3, ',26,50018708,50018784,50015610,', 0),
(50015609, '方向助力泵', 36, 50018784, 3, ',26,50018708,50018784,50015609,', 0),
(50015607, '方向拉杆总成', 37, 50018784, 3, ',26,50018708,50018784,50015607,', 0),
(50015608, '方向拉杆球头', 39, 50018784, 3, ',26,50018708,50018784,50015608,', 0),
(50018790, '其它转向系统配件', 40, 50018784, 3, ',26,50018708,50018784,50018790,', 0),
(50015622, '制动器总成', 0, 50018785, 3, ',26,50018708,50018785,50015622,', 0),
(50014566, '刹车片', 1, 50018785, 3, ',26,50018708,50018785,50014566,', 0),
(50022858, '刹车油管', 60, 50018785, 3, ',26,50018708,50018785,50022858,', 0),
(50015629, '刹车盘/刹车鼓', 61, 50018785, 3, ',26,50018708,50018785,50015629,', 0),
(50022860, '刹车分泵', 75, 50018785, 3, ',26,50018708,50018785,50022860,', 0),
(50022862, '刹车卡钳', 76, 50018785, 3, ',26,50018708,50018785,50022862,', 0),
(50022864, '刹车总泵/ABS总泵', 77, 50018785, 3, ',26,50018708,50018785,50022864,', 0),
(50016297, '真空助力器', 79, 50018785, 3, ',26,50018708,50018785,50016297,', 0),
(50018791, '其它制动系统配件', 82, 50018785, 3, ',26,50018708,50018785,50018791,', 0),
(50022866, '车架/大梁/车壳', 0, 50018786, 3, ',26,50018708,50018786,50022866,', 0),
(50016307, '前桥/后桥', 1, 50018786, 3, ',26,50018708,50018786,50016307,', 0),
(50016298, '传动轴', 3, 50018786, 3, ',26,50018708,50018786,50016298,', 0),
(50015626, '半轴', 4, 50018786, 3, ',26,50018708,50018786,50015626,', 0),
(50015611, '轴承', 6, 50018786, 3, ',26,50018708,50018786,50015611,', 0),
(50016308, '桥壳', 7, 50018786, 3, ',26,50018708,50018786,50016308,', 0),
(50015623, '差速器', 9, 50018786, 3, ',26,50018708,50018786,50015623,', 0),
(50014564, '减震', 11, 50018786, 3, ',26,50018708,50018786,50014564,', 0),
(50016305, '钢板弹簧', 13, 50018786, 3, ',26,50018708,50018786,50016305,', 0),
(50022870, '上下摆臂', 79, 50018786, 3, ',26,50018708,50018786,50022870,', 0),
(50022872, '止推杆', 80, 50018786, 3, ',26,50018708,50018786,50022872,', 0),
(50022874, '摆臂球头', 82, 50018786, 3, ',26,50018708,50018786,50022874,', 0),
(50018792, '其它悬挂系统配件', 84, 50018786, 3, ',26,50018708,50018786,50018792,', 0),
(50014563, '蓄电池', 17, 50018787, 3, ',26,50018708,50018787,50014563,', 0),
(50015620, '发电机', 21, 50018787, 3, ',26,50018708,50018787,50015620,', 0),
(50015853, '整流器', 22, 50018787, 3, ',26,50018708,50018787,50015853,', 0),
(50011859, '传感器', 47, 50018787, 3, ',26,50018708,50018787,50011859,', 0),
(50022807, '车用芯片', 59, 50018787, 3, ',26,50018708,50018787,50022807,', 0),
(50015627, '保险片', 60, 50018787, 3, ',26,50018708,50018787,50015627,', 0),
(50018793, '其它电路系统配件', 61, 50018787, 3, ',26,50018708,50018787,50018793,', 0),
(50022848, '节温器', 0, 50018788, 3, ',26,50018708,50018788,50022848,', 0),
(50015599, '水泵', 1, 50018788, 3, ',26,50018708,50018788,50015599,', 0),
(50015600, '风扇', 13, 50018788, 3, ',26,50018708,50018788,50015600,', 0),
(50015601, '散热器', 14, 50018788, 3, ',26,50018708,50018788,50015601,', 0),
(50022850, '水管', 16, 50018788, 3, ',26,50018708,50018788,50022850,', 0),
(50015471, '压缩机', 17, 50018788, 3, ',26,50018708,50018788,50015471,', 0),
(50014834, '水箱', 17, 50018788, 3, ',26,50018708,50018788,50014834,', 0),
(50015582, '水箱保护网', 31, 50018788, 3, ',26,50018708,50018788,50015582,', 0),
(50015615, '冷凝器', 49, 50018788, 3, ',26,50018708,50018788,50015615,', 0),
(50018794, '其它冷却系统配件', 50, 50018788, 3, ',26,50018708,50018788,50018794,', 0),
(50006521, 'IC集成电路', 0, 50018869, 3, ',50008090,50024099,50018869,50006521,', 0),
(50015939, '单片机/开发板/学习板', 2, 50018869, 3, ',50008090,50024099,50018869,50015939,', 0),
(50023281, '电源模块', 4, 50018869, 3, ',50008090,50024099,50018869,50023281,', 0),
(50002922, '放大器', 5, 50018869, 3, ',50008090,50024099,50018869,50002922,', 0),
(50018871, '存储器', 6, 50018869, 3, ',50008090,50024099,50018869,50018871,', 0),
(50018872, '仿真器', 7, 50018869, 3, ',50008090,50024099,50018869,50018872,', 0),
(50018873, '编码器', 8, 50018869, 3, ',50008090,50024099,50018869,50018873,', 0),
(50006522, '电机/马达', 15, 50018869, 3, ',50008090,50024099,50018869,50006522,', 0),
(50006523, '芯片', 16, 50018869, 3, ',50008090,50024099,50018869,50006523,', 0),
(50018814, '二极管/LED', 0, 50018870, 3, ',50008090,50024099,50018870,50018814,', 0),
(50018815, '三极管', 25, 50018870, 3, ',50008090,50024099,50018870,50018815,', 0),
(50018823, 'MOS场效应管', 33, 50018870, 3, ',50008090,50024099,50018870,50018823,', 0),
(50018874, '可控硅/晶闸管', 36, 50018870, 3, ',50008090,50024099,50018870,50018874,', 0),
(50018825, '光电/激光器件', 37, 50018870, 3, ',50008090,50024099,50018870,50018825,', 0),
(50021168, '玻璃油墨', 0, 50018945, 3, ',50007218,111409,50018945,50021168,', 0),
(50021169, '陶瓷油墨', 1, 50018945, 3, ',50007218,111409,50018945,50021169,', 0),
(50021170, '塑料油墨', 2, 50018945, 3, ',50007218,111409,50018945,50021170,', 0),
(50021173, '橡胶油墨', 3, 50018945, 3, ',50007218,111409,50018945,50021173,', 0),
(50021171, '印铁油墨', 4, 50018945, 3, ',50007218,111409,50018945,50021171,', 0),
(50021172, '印纸油墨', 5, 50018945, 3, ',50007218,111409,50018945,50021172,', 0),
(50021174, '印布油墨', 7, 50018945, 3, ',50007218,111409,50018945,50021174,', 0),
(50021175, 'UV油墨', 8, 50018945, 3, ',50007218,111409,50018945,50021175,', 0),
(50021176, '防伪油墨', 9, 50018945, 3, ',50007218,111409,50018945,50021176,', 0),
(50021177, '其他油墨', 10, 50018945, 3, ',50007218,111409,50018945,50021177,', 0),
(50018967, '活性炭', 0, 50018963, 3, ',50025705,50018960,50018963,50018967,', 0),
(50018968, '甲醛清除剂', 1, 50018963, 3, ',50025705,50018960,50018963,50018968,', 0),
(50018969, '甲醛检测用品', 2, 50018963, 3, ',50025705,50018960,50018963,50018969,', 0),
(50018970, '其他甲醛清除剂/甲醛检测', 3, 50018963, 3, ',50025705,50018960,50018963,50018970,', 0),
(50026629, '出国游学服务', 1, 50026627, 3, ',50025111,50014927,50026627,50026629,', 0),
(50026630, '留学服务', 2, 50026627, 3, ',50025111,50014927,50026627,50026630,', 0),
(50014976, '签证服务', 18, 50026627, 3, ',50025111,50014927,50026627,50014976,', 0),
(50050187, '夏令营/冬令营', 19, 50026627, 3, ',50025111,50014927,50026627,50050187,', 0),
(50050571, '教育机构线下活动', 20, 50026627, 3, ',50025111,50014927,50026627,50050571,', 0),
(50050542, '魔术', 0, 50026666, 3, ',50025111,50025132,50026666,50050542,', 0),
(50050543, '演唱', 1, 50026666, 3, ',50025111,50025132,50026666,50050543,', 0),
(50050544, '小丑', 2, 50026666, 3, ',50025111,50025132,50026666,50050544,', 0),
(50050545, '沙画', 3, 50026666, 3, ',50025111,50025132,50026666,50050545,', 0),
(50008757, '显微镜', 9, 50026670, 3, ',25,50023509,50026670,50008757,', 0),
(50026912, '硒', 0, 50026802, 3, ',50026800,50026801,50026802,50026912,', 0),
(50026913, '维生素K', 1, 50026802, 3, ',50026800,50026801,50026802,50026913,', 0),
(50026914, '维生素AD/鱼肝油', 2, 50026802, 3, ',50026800,50026801,50026802,50026914,', 0),
(50026915, '钙镁', 3, 50026802, 3, ',50026800,50026801,50026802,50026915,', 0),
(50026916, '铁', 4, 50026802, 3, ',50026800,50026801,50026802,50026916,', 0),
(50026917, 'B族维生素', 5, 50026802, 3, ',50026800,50026801,50026802,50026917,', 0),
(50026918, '钙', 6, 50026802, 3, ',50026800,50026801,50026802,50026918,', 0),
(50026919, '维生素E/小麦胚芽油', 7, 50026802, 3, ',50026800,50026801,50026802,50026919,', 0),
(50026920, '维生素E+C', 8, 50026802, 3, ',50026800,50026801,50026802,50026920,', 0),
(50026921, '左旋肉碱', 9, 50026802, 3, ',50026800,50026801,50026802,50026921,', 0),
(50026922, '钙铁锌', 10, 50026802, 3, ',50026800,50026801,50026802,50026922,', 0),
(50026923, '维生素D', 11, 50026802, 3, ',50026800,50026801,50026802,50026923,', 0),
(50026924, '维生素C', 12, 50026802, 3, ',50026800,50026801,50026802,50026924,', 0),
(50026925, '维生素A/胡萝卜素', 13, 50026802, 3, ',50026800,50026801,50026802,50026925,', 0),
(50026926, '复合维生素/矿物质', 14, 50026802, 3, ',50026800,50026801,50026802,50026926,', 0),
(50026927, '叶酸', 15, 50026802, 3, ',50026800,50026801,50026802,50026927,', 0),
(50026928, '锌', 16, 50026802, 3, ',50026800,50026801,50026802,50026928,', 0),
(50026863, '珍珠粉', 0, 50026803, 3, ',50026800,50026801,50026803,50026863,', 0),
(50026864, '虾青素', 1, 50026803, 3, ',50026800,50026801,50026803,50026864,', 0),
(50026865, '牡蛎/贝类提取物', 2, 50026803, 3, ',50026800,50026801,50026803,50026865,', 0),
(50026866, '海狗/海豹油', 3, 50026803, 3, ',50026800,50026801,50026803,50026866,', 0),
(50026867, '沙丁鱼提取物', 4, 50026803, 3, ',50026800,50026801,50026803,50026867,', 0),
(50026868, '螺旋藻/藻类提取物', 5, 50026803, 3, ',50026800,50026801,50026803,50026868,', 0),
(50026869, '鲨鱼软骨素', 6, 50026803, 3, ',50026800,50026801,50026803,50026869,', 0),
(50026870, '其它海洋提取物', 7, 50026803, 3, ',50026800,50026801,50026803,50026870,', 0),
(50026871, '角鲨烯', 8, 50026803, 3, ',50026800,50026801,50026803,50026871,', 0),
(50026872, '鱼油/深海鱼油', 9, 50026803, 3, ',50026800,50026801,50026803,50026872,', 0),
(50026873, '氨基葡萄糖', 10, 50026803, 3, ',50026800,50026801,50026803,50026873,', 0),
(50026874, '甲壳素', 11, 50026803, 3, ',50026800,50026801,50026803,50026874,', 0),
(50026887, '辅酶Q10', 0, 50026804, 3, ',50026800,50026801,50026804,50026887,', 0),
(50026888, '猴头菇提取物', 1, 50026804, 3, ',50026800,50026801,50026804,50026888,', 0),
(50026889, '冬虫夏草提取物', 2, 50026804, 3, ',50026800,50026801,50026804,50026889,', 0),
(50026890, '其它菌/菇/微生物发酵', 3, 50026804, 3, ',50026800,50026801,50026804,50026890,', 0),
(50026891, '红曲', 4, 50026804, 3, ',50026800,50026801,50026804,50026891,', 0),
(50026892, '益生菌', 5, 50026804, 3, ',50026800,50026801,50026804,50026892,', 0),
(50026893, '酵素', 6, 50026804, 3, ',50026800,50026801,50026804,50026893,', 0),
(50026894, '灵芝/灵芝孢子粉', 7, 50026804, 3, ',50026800,50026801,50026804,50026894,', 0),
(50026821, '氨基酸', 0, 50026805, 3, ',50026800,50026801,50026805,50026821,', 0),
(50026822, '骨胶原蛋白', 1, 50026805, 3, ',50026800,50026801,50026805,50026822,', 0),
(50026823, '乳清蛋白', 2, 50026805, 3, ',50026800,50026801,50026805,50026823,', 0),
(50026824, '大豆分离蛋白', 3, 50026805, 3, ',50026800,50026801,50026805,50026824,', 0),
(50026825, '精氨酸', 4, 50026805, 3, ',50026800,50026801,50026805,50026825,', 0),
(50026826, '胶原蛋白', 5, 50026805, 3, ',50026800,50026801,50026805,50026826,', 0),
(50026827, '其它蛋白', 6, 50026805, 3, ',50026800,50026801,50026805,50026827,', 0),
(50026828, '鱼蛋白', 7, 50026805, 3, ',50026800,50026801,50026805,50026828,', 0),
(50026829, '混合蛋白', 8, 50026805, 3, ',50026800,50026801,50026805,50026829,', 0),
(50026830, '支链氨基酸', 9, 50026805, 3, ',50026800,50026801,50026805,50026830,', 0),
(50026831, '肽类', 10, 50026805, 3, ',50026800,50026801,50026805,50026831,', 0),
(50026904, '膳食纤维/果蔬纤维', 0, 50026806, 3, ',50026800,50026801,50026806,50026904,', 0),
(50026905, '生物多糖', 1, 50026806, 3, ',50026800,50026801,50026806,50026905,', 0),
(50026906, '低聚糖/寡糖', 2, 50026806, 3, ',50026800,50026801,50026806,50026906,', 0),
(50026907, '其它碳水化合物', 3, 50026806, 3, ',50026800,50026801,50026806,50026907,', 0),
(50026946, '其它植物提取物', 0, 50026807, 3, ',50026800,50026801,50026807,50026946,', 0),
(50026947, '大豆异黄酮', 1, 50026807, 3, ',50026800,50026801,50026807,50026947,', 0),
(50026948, '紫锥菊提取物', 2, 50026807, 3, ',50026800,50026801,50026807,50026948,', 0),
(50026949, '锯棕榈', 3, 50026807, 3, ',50026800,50026801,50026807,50026949,', 0),
(50026950, '葛根', 4, 50026807, 3, ',50026800,50026801,50026807,50026950,', 0),
(50026951, '南瓜/南瓜籽', 5, 50026807, 3, ',50026800,50026801,50026807,50026951,', 0),
(50026952, 'pycnogenol.', 6, 50026807, 3, ',50026800,50026801,50026807,50026952,', 0),
(50026953, '番茄红素', 7, 50026807, 3, ',50026800,50026801,50026807,50026953,', 0),
(50026954, '叶黄素', 8, 50026807, 3, ',50026800,50026801,50026807,50026954,', 0),
(50026955, '木瓜提取物', 9, 50026807, 3, ',50026800,50026801,50026807,50026955,', 0),
(50026956, '纳豆提取物', 10, 50026807, 3, ',50026800,50026801,50026807,50026956,', 0),
(50026957, '芦荟', 11, 50026807, 3, ',50026800,50026801,50026807,50026957,', 0),
(50026958, '紫花苜蓿', 12, 50026807, 3, ',50026800,50026801,50026807,50026958,', 0),
(50026959, '蛇麻草', 13, 50026807, 3, ',50026800,50026801,50026807,50026959,', 0),
(50026960, '参类提取物', 14, 50026807, 3, ',50026800,50026801,50026807,50026960,', 0),
(50026961, '茶多酚/茶族', 15, 50026807, 3, ',50026800,50026801,50026807,50026961,', 0),
(50026962, '沙棘', 16, 50026807, 3, ',50026800,50026801,50026807,50026962,', 0),
(50026963, '蒲公英', 17, 50026807, 3, ',50026800,50026801,50026807,50026963,', 0),
(50026964, '银杏/人参银杏', 18, 50026807, 3, ',50026800,50026801,50026807,50026964,', 0),
(50026965, '卵磷脂', 19, 50026807, 3, ',50026800,50026801,50026807,50026965,', 0),
(50026966, '葡萄籽/原花青素', 20, 50026807, 3, ',50026800,50026801,50026807,50026966,', 0),
(50026967, '越橘/蓝莓提取物', 21, 50026807, 3, ',50026800,50026801,50026807,50026967,', 0),
(50026968, '月见草油', 22, 50026807, 3, ',50026800,50026801,50026807,50026968,', 0),
(50026969, '玫瑰精油', 23, 50026807, 3, ',50026800,50026801,50026807,50026969,', 0),
(50026970, '苹果酸', 24, 50026807, 3, ',50026800,50026801,50026807,50026970,', 0),
(50026971, '大蒜提取物', 25, 50026807, 3, ',50026800,50026801,50026807,50026971,', 0),
(50026972, '苦瓜提取物', 26, 50026807, 3, ',50026800,50026801,50026807,50026972,', 0),
(50026973, '石斛', 27, 50026807, 3, ',50026800,50026801,50026807,50026973,', 0),
(50026974, '蔓越莓', 28, 50026807, 3, ',50026800,50026801,50026807,50026974,', 0),
(50026975, '蓟类', 29, 50026807, 3, ',50026800,50026801,50026807,50026975,', 0),
(50026976, '圣约翰草提取物', 30, 50026807, 3, ',50026800,50026801,50026807,50026976,', 0),
(50026843, '蜂胶', 0, 50026808, 3, ',50026800,50026801,50026808,50026843,', 0),
(50026844, '牛初乳', 1, 50026808, 3, ',50026800,50026801,50026808,50026844,', 0),
(50026845, '羊胎盘提取物', 2, 50026808, 3, ',50026800,50026801,50026808,50026845,', 0),
(50026846, '其它动物提取物', 3, 50026808, 3, ',50026800,50026801,50026808,50026846,', 0),
(50026847, '袋鼠精', 4, 50026808, 3, ',50026800,50026801,50026808,50026847,', 0),
(50026848, '鹿产品提取物', 5, 50026808, 3, ',50026800,50026801,50026808,50026848,', 0),
(50026849, '林蛙油提取物', 6, 50026808, 3, ',50026800,50026801,50026808,50026849,', 0),
(50026857, '褪黑素/松果体素', 0, 50026810, 3, ',50026800,50026801,50026810,50026857,', 0),
(50026858, '其它功能复合型', 1, 50026810, 3, ',50026800,50026801,50026810,50026858,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50026859, '谷氨酰胺', 2, 50026810, 3, ',50026800,50026801,50026810,50026859,', 0),
(50026875, '珍珠粉', 0, 50026812, 3, ',50026800,50026811,50026812,50026875,', 0),
(50026876, '虾青素', 1, 50026812, 3, ',50026800,50026811,50026812,50026876,', 0),
(50026877, '牡蛎/贝类提取物', 2, 50026812, 3, ',50026800,50026811,50026812,50026877,', 0),
(50026878, '海狗/海豹油', 3, 50026812, 3, ',50026800,50026811,50026812,50026878,', 0),
(50026879, '沙丁鱼提取物', 4, 50026812, 3, ',50026800,50026811,50026812,50026879,', 0),
(50026880, '螺旋藻/藻类提取物', 5, 50026812, 3, ',50026800,50026811,50026812,50026880,', 0),
(50026881, '鲨鱼软骨素', 6, 50026812, 3, ',50026800,50026811,50026812,50026881,', 0),
(50026882, '其它海洋提取物', 7, 50026812, 3, ',50026800,50026811,50026812,50026882,', 0),
(50026883, '角鲨烯', 8, 50026812, 3, ',50026800,50026811,50026812,50026883,', 0),
(50026884, '鱼油/深海鱼油', 9, 50026812, 3, ',50026800,50026811,50026812,50026884,', 0),
(50026885, '氨基葡萄糖', 10, 50026812, 3, ',50026800,50026811,50026812,50026885,', 0),
(50026886, '甲壳素', 11, 50026812, 3, ',50026800,50026811,50026812,50026886,', 0),
(50026895, '辅酶Q10', 0, 50026813, 3, ',50026800,50026811,50026813,50026895,', 0),
(50026896, '猴头菇提取物', 1, 50026813, 3, ',50026800,50026811,50026813,50026896,', 0),
(50026897, '冬虫夏草提取物', 2, 50026813, 3, ',50026800,50026811,50026813,50026897,', 0),
(50026898, '其它菌/菇/微生物发酵', 3, 50026813, 3, ',50026800,50026811,50026813,50026898,', 0),
(50026899, '红曲', 4, 50026813, 3, ',50026800,50026811,50026813,50026899,', 0),
(50026900, '益生菌', 5, 50026813, 3, ',50026800,50026811,50026813,50026900,', 0),
(50026901, '酵素', 6, 50026813, 3, ',50026800,50026811,50026813,50026901,', 0),
(50026902, '灵芝/灵芝孢子粉', 7, 50026813, 3, ',50026800,50026811,50026813,50026902,', 0),
(50026929, '硒', 0, 50026814, 3, ',50026800,50026811,50026814,50026929,', 0),
(50026930, '维生素K', 1, 50026814, 3, ',50026800,50026811,50026814,50026930,', 0),
(50026931, '维生素AD/鱼肝油', 2, 50026814, 3, ',50026800,50026811,50026814,50026931,', 0),
(50026932, '钙镁', 3, 50026814, 3, ',50026800,50026811,50026814,50026932,', 0),
(50026933, '铁', 4, 50026814, 3, ',50026800,50026811,50026814,50026933,', 0),
(50026934, 'B族维生素', 5, 50026814, 3, ',50026800,50026811,50026814,50026934,', 0),
(50026935, '钙', 6, 50026814, 3, ',50026800,50026811,50026814,50026935,', 0),
(50026936, '维生素E/小麦胚芽油', 7, 50026814, 3, ',50026800,50026811,50026814,50026936,', 0),
(50026937, '维生素E+C', 8, 50026814, 3, ',50026800,50026811,50026814,50026937,', 0),
(50026938, '左旋肉碱', 9, 50026814, 3, ',50026800,50026811,50026814,50026938,', 0),
(50026939, '钙铁锌', 10, 50026814, 3, ',50026800,50026811,50026814,50026939,', 0),
(50026940, '维生素D', 11, 50026814, 3, ',50026800,50026811,50026814,50026940,', 0),
(50026941, '维生素C', 12, 50026814, 3, ',50026800,50026811,50026814,50026941,', 0),
(50026942, '维生素A/胡萝卜素', 13, 50026814, 3, ',50026800,50026811,50026814,50026942,', 0),
(50026943, '复合维生素/矿物质', 14, 50026814, 3, ',50026800,50026811,50026814,50026943,', 0),
(50026944, '叶酸', 15, 50026814, 3, ',50026800,50026811,50026814,50026944,', 0),
(50026945, '锌', 16, 50026814, 3, ',50026800,50026811,50026814,50026945,', 0),
(50026832, '氨基酸', 0, 50026815, 3, ',50026800,50026811,50026815,50026832,', 0),
(50026833, '骨胶原蛋白', 1, 50026815, 3, ',50026800,50026811,50026815,50026833,', 0),
(50026834, '乳清蛋白', 2, 50026815, 3, ',50026800,50026811,50026815,50026834,', 0),
(50026835, '大豆分离蛋白', 3, 50026815, 3, ',50026800,50026811,50026815,50026835,', 0),
(50026836, '精氨酸', 4, 50026815, 3, ',50026800,50026811,50026815,50026836,', 0),
(50026837, '胶原蛋白', 5, 50026815, 3, ',50026800,50026811,50026815,50026837,', 0),
(50026838, '其它蛋白', 6, 50026815, 3, ',50026800,50026811,50026815,50026838,', 0),
(50026839, '鱼蛋白', 7, 50026815, 3, ',50026800,50026811,50026815,50026839,', 0),
(50026840, '混合蛋白', 8, 50026815, 3, ',50026800,50026811,50026815,50026840,', 0),
(50026841, '支链氨基酸', 9, 50026815, 3, ',50026800,50026811,50026815,50026841,', 0),
(50026842, '肽类', 10, 50026815, 3, ',50026800,50026811,50026815,50026842,', 0),
(50026908, '膳食纤维/果蔬纤维', 0, 50026816, 3, ',50026800,50026811,50026816,50026908,', 0),
(50026909, '生物多糖', 1, 50026816, 3, ',50026800,50026811,50026816,50026909,', 0),
(50026910, '低聚糖/寡糖', 2, 50026816, 3, ',50026800,50026811,50026816,50026910,', 0),
(50026911, '其它碳水化合物', 3, 50026816, 3, ',50026800,50026811,50026816,50026911,', 0),
(50026977, '其它植物提取物', 0, 50026817, 3, ',50026800,50026811,50026817,50026977,', 0),
(50026978, '大豆异黄酮', 1, 50026817, 3, ',50026800,50026811,50026817,50026978,', 0),
(50026979, '紫锥菊提取物', 2, 50026817, 3, ',50026800,50026811,50026817,50026979,', 0),
(50026980, '锯棕榈', 3, 50026817, 3, ',50026800,50026811,50026817,50026980,', 0),
(50026981, '葛根', 4, 50026817, 3, ',50026800,50026811,50026817,50026981,', 0),
(50026982, '南瓜/南瓜籽', 5, 50026817, 3, ',50026800,50026811,50026817,50026982,', 0),
(50026983, 'pycnogenol.', 6, 50026817, 3, ',50026800,50026811,50026817,50026983,', 0),
(50026984, '番茄红素', 7, 50026817, 3, ',50026800,50026811,50026817,50026984,', 0),
(50026985, '叶黄素', 8, 50026817, 3, ',50026800,50026811,50026817,50026985,', 0),
(50026986, '木瓜提取物', 9, 50026817, 3, ',50026800,50026811,50026817,50026986,', 0),
(50026987, '纳豆提取物', 10, 50026817, 3, ',50026800,50026811,50026817,50026987,', 0),
(50026988, '芦荟', 11, 50026817, 3, ',50026800,50026811,50026817,50026988,', 0),
(50026989, '紫花苜蓿', 12, 50026817, 3, ',50026800,50026811,50026817,50026989,', 0),
(50026990, '蛇麻草', 13, 50026817, 3, ',50026800,50026811,50026817,50026990,', 0),
(50026991, '参类提取物', 14, 50026817, 3, ',50026800,50026811,50026817,50026991,', 0),
(50026992, '茶多酚/茶族', 15, 50026817, 3, ',50026800,50026811,50026817,50026992,', 0),
(50026993, '沙棘', 16, 50026817, 3, ',50026800,50026811,50026817,50026993,', 0),
(50026994, '蒲公英', 17, 50026817, 3, ',50026800,50026811,50026817,50026994,', 0),
(50026995, '银杏/人参银杏', 18, 50026817, 3, ',50026800,50026811,50026817,50026995,', 0),
(50026996, '卵磷脂', 19, 50026817, 3, ',50026800,50026811,50026817,50026996,', 0),
(50026997, '葡萄籽/原花青素', 20, 50026817, 3, ',50026800,50026811,50026817,50026997,', 0),
(50026998, '越橘/蓝莓提取物', 21, 50026817, 3, ',50026800,50026811,50026817,50026998,', 0),
(50026999, '月见草油', 22, 50026817, 3, ',50026800,50026811,50026817,50026999,', 0),
(50027000, '玫瑰精油', 23, 50026817, 3, ',50026800,50026811,50026817,50027000,', 0),
(50027001, '苹果酸', 24, 50026817, 3, ',50026800,50026811,50026817,50027001,', 0),
(50027002, '大蒜提取物', 25, 50026817, 3, ',50026800,50026811,50026817,50027002,', 0),
(50027003, '石斛', 26, 50026817, 3, ',50026800,50026811,50026817,50027003,', 0),
(50027004, '苦瓜提取物', 26, 50026817, 3, ',50026800,50026811,50026817,50027004,', 0),
(50027005, '蔓越莓', 27, 50026817, 3, ',50026800,50026811,50026817,50027005,', 0),
(50027007, '蓟类', 28, 50026817, 3, ',50026800,50026811,50026817,50027007,', 0),
(50027010, '圣约翰草提取物', 29, 50026817, 3, ',50026800,50026811,50026817,50027010,', 0),
(50026850, '蜂胶', 0, 50026819, 3, ',50026800,50026811,50026819,50026850,', 0),
(50026851, '牛初乳', 1, 50026819, 3, ',50026800,50026811,50026819,50026851,', 0),
(50026852, '羊胎盘提取物', 2, 50026819, 3, ',50026800,50026811,50026819,50026852,', 0),
(50026853, '其它动物提取物', 3, 50026819, 3, ',50026800,50026811,50026819,50026853,', 0),
(50026854, '袋鼠精', 4, 50026819, 3, ',50026800,50026811,50026819,50026854,', 0),
(50026855, '鹿产品提取物', 5, 50026819, 3, ',50026800,50026811,50026819,50026855,', 0),
(50026856, '林蛙油提取物', 6, 50026819, 3, ',50026800,50026811,50026819,50026856,', 0),
(50026860, '褪黑素/松果体素', 0, 50026820, 3, ',50026800,50026811,50026820,50026860,', 0),
(50026861, '其它功能复合型', 1, 50026820, 3, ',50026800,50026811,50026820,50026861,', 0),
(50026862, '谷氨酰胺', 2, 50026820, 3, ',50026800,50026811,50026820,50026862,', 0),
(50050228, 'DHA/EPA/DPA', 0, 50050227, 3, ',50026800,50026801,50050227,50050228,', 0),
(50050229, '亚麻酸', 1, 50050227, 3, ',50026800,50026801,50050227,50050229,', 0),
(50050230, '其他脂类', 2, 50050227, 3, ',50026800,50026801,50050227,50050230,', 0),
(50050232, 'DHA/EPA/DPA', 0, 50050231, 3, ',50026800,50026811,50050231,50050232,', 0),
(50050233, '亚麻酸', 1, 50050231, 3, ',50026800,50026811,50050231,50050233,', 0),
(50050234, '其他脂类', 2, 50050231, 3, ',50026800,50026811,50050231,50050234,', 0),
(50019616, 'SIM 剪卡钳', 0, 50050365, 3, ',50008090,50018326,50050365,50019616,', 0),
(50018620, '苹果卡槽', 3, 50050365, 3, ',50008090,50018326,50050365,50018620,', 0),
(50018622, '苹果取卡针', 5, 50050365, 3, ',50008090,50018326,50050365,50018622,', 0),
(50023335, '苹果卡贴', 19, 50050365, 3, ',50008090,50018326,50050365,50023335,', 0),
(50050440, '在线学历教育培训', 0, 50050439, 3, ',50025111,50014927,50050439,50050440,', 0),
(50050441, '在线语言培训', 1, 50050439, 3, ',50025111,50014927,50050439,50050441,', 0),
(50050442, '在线经济贸易培训', 2, 50050439, 3, ',50025111,50014927,50050439,50050442,', 0),
(50050443, '其他在线培训', 3, 50050439, 3, ',50025111,50014927,50050439,50050443,', 0),
(50050444, '在线家教', 4, 50050439, 3, ',50025111,50014927,50050439,50050444,', 0),
(50050445, '在线建筑地产类培训', 5, 50050439, 3, ',50025111,50014927,50050439,50050445,', 0),
(50050446, '在线管理培训', 6, 50050439, 3, ',50025111,50014927,50050439,50050446,', 0),
(50050447, '在线财务会计培训', 7, 50050439, 3, ',50025111,50014927,50050439,50050447,', 0),
(50050448, '在线婴幼儿教育', 8, 50050439, 3, ',50025111,50014927,50050439,50050448,', 0),
(50050449, '在线中小学教育', 9, 50050439, 3, ',50025111,50014927,50050439,50050449,', 0),
(50050450, '在线银行/证券培训', 10, 50050439, 3, ',50025111,50014927,50050439,50050450,', 0),
(50050451, '在线淘宝大学培训课程', 11, 50050439, 3, ',50025111,50014927,50050439,50050451,', 0),
(50050452, '在线专业技能培训', 12, 50050439, 3, ',50025111,50014927,50050439,50050452,', 0),
(50050453, '在线电脑IT培训', 13, 50050439, 3, ',50025111,50014927,50050439,50050453,', 0),
(50050454, '在线考研培训', 14, 50050439, 3, ',50025111,50014927,50050439,50050454,', 0),
(50050455, '在线文艺体育培训', 15, 50050439, 3, ',50025111,50014927,50050439,50050455,', 0),
(50050456, '在线少儿培训', 16, 50050439, 3, ',50025111,50014927,50050439,50050456,', 0),
(50050457, '在线公务员考试培训', 17, 50050439, 3, ',50025111,50014927,50050439,50050457,', 0),
(50050458, '在线职业资格认证培训', 18, 50050439, 3, ',50025111,50014927,50050439,50050458,', 0),
(50050514, '修伞/修表/修鞋', 4, 50050491, 3, ',50025111,50050489,50050491,50050514,', 0),
(50026197, '生活配送', 7, 50050491, 3, ',50025111,50050489,50050491,50026197,', 0),
(50014751, '报刊杂志订阅', 8, 50050491, 3, ',50025111,50050489,50050491,50014751,', 0),
(50026202, '服饰尺寸修改', 9, 50050491, 3, ',50025111,50050489,50050491,50026202,', 0),
(50026203, '其他社区服务', 10, 50050491, 3, ',50025111,50050489,50050491,50026203,', 0),
(50050564, '洗衣', 11, 50050491, 3, ',50025111,50050489,50050491,50050564,', 0),
(50050496, '派对服务', 0, 50050494, 3, ',50025111,50050489,50050494,50050496,', 0),
(50050497, '设备场地租赁', 1, 50050494, 3, ',50025111,50050489,50050494,50050497,', 0),
(50050499, '工商注册', 0, 50050495, 3, ',50025111,50050489,50050495,50050499,', 0),
(50050500, '翻译', 1, 50050495, 3, ',50025111,50050489,50050495,50050500,', 0),
(50050501, '商务服务', 2, 50050495, 3, ',50025111,50050489,50050495,50050501,', 0),
(50050502, '礼品定制', 3, 50050495, 3, ',50025111,50050489,50050495,50050502,', 0),
(50014977, '其他服务', 6, 50050495, 3, ',50025111,50050489,50050495,50014977,', 0),
(50014968, '寄售服务', 7, 50050495, 3, ',50025111,50050489,50050495,50014968,', 0),
(50026185, '物业服务', 13, 50050495, 3, ',50025111,50050489,50050495,50026185,', 0),
(50022565, '设计服务', 14, 50050495, 3, ',50025111,50050489,50050495,50022565,', 0),
(50019110, '交通卡服务', 16, 50050495, 3, ',50025111,50050489,50050495,50019110,', 0),
(50005234, '家电维修/清洗/安装', 1, 50050519, 3, ',50025111,50050464,50050519,50005234,', 0),
(50019785, '电器延保/增值服务', 2, 50050519, 3, ',50025111,50050464,50050519,50019785,', 0),
(50050238, '家居维修', 3, 50050519, 3, ',50025111,50050464,50050519,50050238,', 0),
(50005237, '房屋维修', 4, 50050519, 3, ',50025111,50050464,50050519,50005237,', 0),
(50050241, '其他', 5, 50050519, 3, ',50025111,50050464,50050519,50050241,', 0),
(50050243, '装修施工', 0, 50050520, 3, ',50025111,50050464,50050520,50050243,', 0),
(50050244, '装修工程监理', 1, 50050520, 3, ',50025111,50050464,50050520,50050244,', 0),
(50050240, '装修设计', 2, 50050520, 3, ',50025111,50050464,50050520,50050240,', 0),
(50023805, '上门测量', 2, 50050521, 3, ',50025111,50050464,50050521,50023805,', 0),
(50023932, '室内空气污染治理', 3, 50050521, 3, ',50025111,50050464,50050521,50023932,', 0),
(50023931, '室内空气检测', 4, 50050521, 3, ',50025111,50050464,50050521,50023931,', 0),
(50023828, '橱柜安装服务', 0, 50050523, 3, ',50025111,50050464,50050523,50023828,', 0),
(50023821, '柜体安装服务', 1, 50050523, 3, ',50025111,50050464,50050523,50023821,', 0),
(50023820, '床安装服务', 2, 50050523, 3, ',50025111,50050464,50050523,50023820,', 0),
(50023822, '桌台几类安装服务', 3, 50050523, 3, ',50025111,50050464,50050523,50023822,', 0),
(50023825, '椅子安装服务', 4, 50050523, 3, ',50025111,50050464,50050523,50023825,', 0),
(50023824, '沙发安装服务', 5, 50050523, 3, ',50025111,50050464,50050523,50023824,', 0),
(50023857, '淋浴房安装', 6, 50050523, 3, ',50025111,50050464,50050523,50023857,', 0),
(50023858, '卫浴配件安装', 7, 50050523, 3, ',50025111,50050464,50050523,50023858,', 0),
(50023847, '三角阀安装', 8, 50050523, 3, ',50025111,50050464,50050523,50023847,', 0),
(50023840, '小便斗安装', 9, 50050523, 3, ',50025111,50050464,50050523,50023840,', 0),
(50023844, '面盆安装', 10, 50050523, 3, ',50025111,50050464,50050523,50023844,', 0),
(50023853, '淋浴龙头安装', 11, 50050523, 3, ',50025111,50050464,50050523,50023853,', 0),
(50023841, '蹲便器安装', 12, 50050523, 3, ',50025111,50050464,50050523,50023841,', 0),
(50023845, '龙头安装', 13, 50050523, 3, ',50025111,50050464,50050523,50023845,', 0),
(50023855, '淋浴拉门安装', 14, 50050523, 3, ',50025111,50050464,50050523,50023855,', 0),
(50023834, '浴室镜柜安装', 15, 50050523, 3, ',50025111,50050464,50050523,50023834,', 0),
(50023832, '浴室镜安装', 16, 50050523, 3, ',50025111,50050464,50050523,50023832,', 0),
(50023831, '浴室柜安装', 17, 50050523, 3, ',50025111,50050464,50050523,50023831,', 0),
(50023837, '浴缸安装', 18, 50050523, 3, ',50025111,50050464,50050523,50023837,', 0),
(50023836, '坐便器安装', 19, 50050523, 3, ',50025111,50050464,50050523,50023836,', 0),
(50023829, '成品楼梯安装', 20, 50050523, 3, ',50025111,50050464,50050523,50023829,', 0),
(50023819, '地板安装', 21, 50050523, 3, ',50025111,50050464,50050523,50023819,', 0),
(50023818, '灯具安装', 22, 50050523, 3, ',50025111,50050464,50050523,50023818,', 0),
(50023817, '墙纸铺贴', 23, 50050523, 3, ',50025111,50050464,50050523,50023817,', 0),
(50023861, '成品门/移门安装', 24, 50050523, 3, ',50025111,50050464,50050523,50023861,', 0),
(50023816, '窗帘轨道安装服务', 25, 50050523, 3, ',50025111,50050464,50050523,50023816,', 0),
(50023860, '地暖施工安装', 26, 50050523, 3, ',50025111,50050464,50050523,50023860,', 0),
(50023815, '厨房设施安装服务', 27, 50050523, 3, ',50025111,50050464,50050523,50023815,', 0),
(50023863, '安防报警设备安装', 28, 50050523, 3, ',50025111,50050464,50050523,50023863,', 0),
(50023814, '空调安装服务', 29, 50050523, 3, ',50025111,50050464,50050523,50023814,', 0),
(50023862, '集成吊顶安装', 30, 50050523, 3, ',50025111,50050464,50050523,50023862,', 0),
(50023813, '热水器安装服务', 31, 50050523, 3, ',50025111,50050464,50050523,50023813,', 0),
(50050524, '其他单项家居安装', 32, 50050523, 3, ',50025111,50050464,50050523,50050524,', 0),
(50050525, '视听设备安装服务', 33, 50050523, 3, ',50025111,50050464,50050523,50050525,', 0),
(50050539, '殡葬用品/设备', 0, 50050538, 3, ',50025111,50050489,50050538,50050539,', 0),
(50050540, '殡葬服务', 1, 50050538, 3, ',50025111,50050489,50050538,50050540,', 0),
(50012384, '腊/腌肉', 2, 50050573, 3, ',50016422,50025682,50050573,50012384,', 0),
(50025695, '培根', 10, 50050573, 3, ',50016422,50025682,50050573,50025695,', 0),
(50025696, '包装即食肠类', 11, 50050573, 3, ',50016422,50025682,50050573,50025696,', 0),
(50016816, '火腿', 34, 50050573, 3, ',50016422,50025682,50050573,50016816,', 0),
(50012383, '待加工香肠', 35, 50050573, 3, ',50016422,50025682,50050573,50012383,', 0),
(50050574, '香肠/腊肠', 36, 50050573, 3, ',50016422,50025682,50050573,50050574,', 0),
(50009838, '大米', 2, 50050578, 3, ',50016422,50009837,50050578,50009838,', 0),
(50009842, '小米', 6, 50050578, 3, ',50016422,50009837,50050578,50009842,', 0),
(50009844, '薏米', 7, 50050578, 3, ',50016422,50009837,50050578,50009844,', 0),
(50009943, '泰国香米', 8, 50050578, 3, ',50016422,50009837,50050578,50009943,', 0),
(50009944, '黑米', 9, 50050578, 3, ',50016422,50009837,50050578,50009944,', 0),
(50009945, '糯米', 10, 50050578, 3, ',50016422,50009837,50050578,50009945,', 0),
(50012197, '薏米仁', 40, 50050578, 3, ',50016422,50009837,50050578,50012197,', 0),
(50019864, '糙米', 41, 50050578, 3, ',50016422,50009837,50050578,50019864,', 0),
(50050581, '黄豆', 0, 50050580, 3, ',50016422,50009837,50050580,50050581,', 0),
(50050583, '红豆', 2, 50050580, 3, ',50016422,50009837,50050580,50050583,', 0),
(50050584, '黑豆', 3, 50050580, 3, ',50016422,50009837,50050580,50050584,', 0),
(50009840, '其它', 4, 50050580, 3, ',50016422,50009837,50050580,50009840,', 0),
(50050585, '绿豆', 4, 50050580, 3, ',50016422,50009837,50050580,50050585,', 0),
(50003479, '脚架', 0, 50050586, 3, ',50008090,50024097,50050586,50003479,', 0),
(50050587, '云台', 1, 50050586, 3, ',50008090,50024097,50050586,50050587,', 0),
(50009183, '快装板', 97, 50050586, 3, ',50008090,50024097,50050586,50009183,', 0),
(50050588, '脚架包', 98, 50050586, 3, ',50008090,50024097,50050586,50050588,', 0),
(50050589, '摄影梯', 99, 50050586, 3, ',50008090,50024097,50050586,50050589,', 0),
(50050590, '脚架配件', 100, 50050586, 3, ',50008090,50024097,50050586,50050590,', 0),
(50050592, '摄影包', 0, 50050591, 3, ',50008090,50024097,50050591,50050592,', 0),
(50003600, '防潮箱', 0, 50050591, 3, ',50008090,50024097,50050591,50003600,', 0),
(50050593, '保护箱', 1, 50050591, 3, ',50008090,50024097,50050591,50050593,', 0),
(50050594, '防寒设备', 2, 50050591, 3, ',50008090,50024097,50050591,50050594,', 0),
(50050595, '包/箱配件', 3, 50050591, 3, ',50008090,50024097,50050591,50050595,', 0),
(140916, '相机闪光灯', 0, 50050596, 3, ',50008090,50024097,50050596,140916,', 0),
(50050597, '闪光灯配件', 1, 50050596, 3, ',50008090,50024097,50050596,50050597,', 0),
(50003477, '滤镜', 0, 50050598, 3, ',50008090,50024097,50050598,50003477,', 0),
(50003484, '遮光罩', 6, 50050598, 3, ',50008090,50024097,50050598,50003484,', 0),
(141201, '增距镜', 8, 50050598, 3, ',50008090,50024097,50050598,141201,', 0),
(140909, '转接环', 9, 50050598, 3, ',50008090,50024097,50050598,140909,', 0),
(50008648, '镜头盖', 10, 50050598, 3, ',50008090,50024097,50050598,50008648,', 0),
(50011767, '单反机身盖', 103, 50050598, 3, ',50008090,50024097,50050598,50011767,', 0),
(50023761, '镜头袋/镜头筒', 103, 50050598, 3, ',50008090,50024097,50050598,50023761,', 0),
(50050599, '脚架接环', 104, 50050598, 3, ',50008090,50024097,50050598,50050599,', 0),
(50012589, '液晶屏保护膜', 0, 50050600, 3, ',50008090,50024097,50050600,50012589,', 0),
(50050601, '取景器', 1, 50050600, 3, ',50008090,50024097,50050600,50050601,', 0),
(50003481, '单反手柄', 7, 50050600, 3, ',50008090,50024097,50050600,50003481,', 0),
(50003483, '背带/腕带', 12, 50050600, 3, ',50008090,50024097,50050600,50003483,', 0),
(50006259, '眼罩', 70, 50050600, 3, ',50008090,50024097,50050600,50006259,', 0),
(50006261, '相机专用遥控器', 71, 50050600, 3, ',50008090,50024097,50050600,50006261,', 0),
(50006262, '对焦屏', 76, 50050600, 3, ',50008090,50024097,50050600,50006262,', 0),
(50006264, '快门线', 77, 50050600, 3, ',50008090,50024097,50050600,50006264,', 0),
(50050602, '热靴水平仪', 78, 50050600, 3, ',50008090,50024097,50050600,50050602,', 0),
(50050603, '无线传输设备', 79, 50050600, 3, ',50008090,50024097,50050600,50050603,', 0),
(50024113, '单反/单电电池', 0, 50050608, 3, ',50008090,50024097,50050608,50024113,', 0),
(50024114, '单反/单电充电器', 11, 50050608, 3, ',50008090,50024097,50050608,50024114,', 0),
(50050609, '单反/单电适配器', 12, 50050608, 3, ',50008090,50024097,50050608,50050609,', 0),
(50050613, '校色仪', 0, 50050612, 3, ',50008090,50024097,50050612,50050613,', 0),
(50050614, '色卡', 1, 50050612, 3, ',50008090,50024097,50050612,50050614,', 0),
(50050615, '灰板', 2, 50050612, 3, ',50008090,50024097,50050612,50050615,', 0),
(50050616, '白平衡镜', 3, 50050612, 3, ',50008090,50024097,50050612,50050616,', 0),
(50050624, '胶卷', 0, 50050623, 3, ',50008090,50050622,50050623,50050624,', 0),
(50050625, '快显胶片', 1, 50050623, 3, ',50008090,50050622,50050623,50050625,', 0),
(50050627, '镜头', 0, 50050626, 3, ',50008090,50050622,50050626,50050627,', 0),
(50050628, 'Lomo闪光灯', 1, 50050626, 3, ',50008090,50050622,50050626,50050628,', 0),
(50050629, 'Lomo相机包', 2, 50050626, 3, ',50008090,50050622,50050626,50050629,', 0),
(50050630, 'Lomo潜水盒', 3, 50050626, 3, ',50008090,50050622,50050626,50050630,', 0),
(50050631, '其他周边配件', 4, 50050626, 3, ',50008090,50050622,50050626,50050631,', 0),
(50050633, '一次成像相机专用包', 0, 50050632, 3, ',50008090,50050622,50050632,50050633,', 0),
(50050634, '相片角贴', 1, 50050632, 3, ',50008090,50050622,50050632,50050634,', 0),
(50050635, '一次成像相册', 2, 50050632, 3, ',50008090,50050622,50050632,50050635,', 0),
(50050636, '照片夹子', 3, 50050632, 3, ',50008090,50050622,50050632,50050636,', 0),
(50050637, '自拍镜头', 4, 50050632, 3, ',50008090,50050622,50050632,50050637,', 0),
(50050638, '涂鸦笔', 5, 50050632, 3, ',50008090,50050622,50050632,50050638,', 0),
(50050679, '鸡肉丸/肉串', 0, 50050667, 3, ',50050359,50050372,50050667,50050679,', 0),
(50050680, '其它', 1, 50050667, 3, ',50050359,50050372,50050667,50050680,', 0),
(50050684, '贡丸/肉串', 0, 50050668, 3, ',50050359,50050372,50050668,50050684,', 0),
(50050685, '猪排', 1, 50050668, 3, ',50050359,50050372,50050668,50050685,', 0),
(50050686, '其它', 2, 50050668, 3, ',50050359,50050372,50050668,50050686,', 0),
(50050681, '其它', 0, 50050669, 3, ',50050359,50050372,50050669,50050681,', 0),
(50050682, '羊肉卷', 1, 50050669, 3, ',50050359,50050372,50050669,50050682,', 0),
(50050683, '羊肉串', 2, 50050669, 3, ',50050359,50050372,50050669,50050683,', 0),
(50050676, '牛丸/肉串', 0, 50050672, 3, ',50050359,50050372,50050672,50050676,', 0),
(50050677, '其它', 1, 50050672, 3, ',50050359,50050372,50050672,50050677,', 0),
(50050678, '牛排', 2, 50050672, 3, ',50050359,50050372,50050672,50050678,', 0),
(50012385, '鸡蛋', 0, 50050687, 3, ',50050359,50012382,50050687,50012385,', 0),
(50012386, '鸭蛋', 3, 50050687, 3, ',50050359,50012382,50050687,50012386,', 0),
(50012387, '其它', 4, 50050687, 3, ',50050359,50012382,50050687,50012387,', 0),
(50050689, '鸽蛋', 5, 50050687, 3, ',50050359,50012382,50050687,50050689,', 0),
(50016809, '其它', 31, 50050688, 3, ',50050359,50012382,50050688,50016809,', 0),
(50050690, '咸鸭蛋', 32, 50050688, 3, ',50050359,50012382,50050688,50050690,', 0),
(50050691, '喜蛋', 33, 50050688, 3, ',50050359,50012382,50050688,50050691,', 0),
(50050692, '松花/皮蛋', 34, 50050688, 3, ',50050359,50012382,50050688,50050692,', 0),
(50016807, '三文鱼', 0, 50050693, 3, ',50050359,50050371,50050693,50016807,', 0),
(50050702, '鳕鱼', 1, 50050693, 3, ',50050359,50050371,50050693,50050702,', 0),
(50016793, '鱼类制品', 2, 50050693, 3, ',50050359,50050371,50050693,50016793,', 0),
(50016796, '花胶/鱼胶', 5, 50050693, 3, ',50050359,50050371,50050693,50016796,', 0),
(50025691, '淡水鱼类', 16, 50050693, 3, ',50050359,50050371,50050693,50025691,', 0),
(50050705, '海鲜鱼类', 19, 50050693, 3, ',50050359,50050371,50050693,50050705,', 0),
(50016798, '墨鱼干', 7, 50050694, 3, ',50050359,50050371,50050694,50016798,', 0),
(50050714, '冷冻墨鱼', 8, 50050694, 3, ',50050359,50050371,50050694,50050714,', 0),
(50050715, '墨鱼丸/花枝丸', 9, 50050694, 3, ',50050359,50050371,50050694,50050715,', 0),
(50016794, '虾类制品', 3, 50050695, 3, ',50050359,50050371,50050695,50016794,', 0),
(50016805, '虾皮/虾米/海米', 14, 50050695, 3, ',50050359,50050371,50050695,50016805,', 0),
(50050706, '活虾', 15, 50050695, 3, ',50050359,50050371,50050695,50050706,', 0),
(50050707, '虾仁', 16, 50050695, 3, ',50050359,50050371,50050695,50050707,', 0),
(50050716, '章鱼干', 0, 50050698, 3, ',50050359,50050371,50050698,50050716,', 0),
(50050717, '冷冻章鱼', 1, 50050698, 3, ',50050359,50050371,50050698,50050717,', 0),
(50016797, '鱿鱼干', 6, 50050699, 3, ',50050359,50050371,50050699,50016797,', 0),
(50050713, '冷冻鱿鱼', 7, 50050699, 3, ',50050359,50050371,50050699,50050713,', 0),
(50016795, '贝类制品', 4, 50050701, 3, ',50050359,50050371,50050701,50016795,', 0),
(50016802, '干贝/瑶柱', 11, 50050701, 3, ',50050359,50050371,50050701,50016802,', 0),
(50016803, '鲍鱼', 12, 50050701, 3, ',50050359,50050371,50050701,50016803,', 0),
(50050712, '北极贝', 13, 50050701, 3, ',50050359,50050371,50050701,50050712,', 0),
(50025698, '泥螺', 13, 50050701, 3, ',50050359,50050371,50050701,50025698,', 0),
(50016808, '其它', 17, 50050701, 3, ',50050359,50050371,50050701,50016808,', 0),
(50050720, '番薯', 0, 50050719, 3, ',50050359,50010566,50050719,50050720,', 0),
(50050721, '山药', 1, 50050719, 3, ',50050359,50010566,50050719,50050721,', 0),
(50050723, '土豆', 3, 50050719, 3, ',50050359,50010566,50050719,50050723,', 0),
(50009845, '其它', 31, 50050719, 3, ',50050359,50010566,50050719,50009845,', 0),
(50008064, '其它', 28, 50050726, 3, ',50050359,50050725,50050726,50008064,', 0),
(50050727, '芒果', 29, 50050726, 3, ',50050359,50050725,50050726,50050727,', 0),
(50050728, '梨', 30, 50050726, 3, ',50050359,50050725,50050726,50050728,', 0),
(50050729, '哈密瓜', 31, 50050726, 3, ',50050359,50050725,50050726,50050729,', 0),
(50050730, '车厘子', 32, 50050726, 3, ',50050359,50050725,50050726,50050730,', 0),
(50050731, '山竹', 33, 50050726, 3, ',50050359,50050725,50050726,50050731,', 0),
(50050732, '苹果', 34, 50050726, 3, ',50050359,50050725,50050726,50050732,', 0),
(50018996, '公用大卷筒纸', 1, 50018992, 3, ',50025705,50012473,50018992,50018996,', 0),
(50018997, '平板卫生纸', 2, 50018992, 3, ',50025705,50012473,50018992,50018997,', 0),
(50018998, '皱纹卫生纸', 3, 50018992, 3, ',50025705,50012473,50018992,50018998,', 0),
(50019002, '抽取式卫生纸', 4, 50018992, 3, ',50025705,50012473,50018992,50019002,', 0),
(50012479, '面巾纸', 5, 50018992, 3, ',50025705,50012473,50018992,50012479,', 0),
(50019125, '风衣', 3, 50019117, 3, ',50013886,50019007,50019117,50019125,', 0),
(50019128, '夹克', 4, 50019117, 3, ',50013886,50019007,50019117,50019128,', 0),
(50019126, '衬衫', 5, 50019117, 3, ',50013886,50019007,50019117,50019126,', 0),
(50019127, 'T恤', 6, 50019117, 3, ',50013886,50019007,50019117,50019127,', 0),
(50019130, '休闲背心', 9, 50019117, 3, ',50013886,50019007,50019117,50019130,', 0),
(50019131, '战术背心', 10, 50019117, 3, ',50013886,50019007,50019117,50019131,', 0),
(50019133, '毛衣', 11, 50019117, 3, ',50013886,50019007,50019117,50019133,', 0),
(50019135, '羽绒衣', 13, 50019117, 3, ',50013886,50019007,50019117,50019135,', 0),
(50019136, '迷彩裤/军迷裤/工装裤', 14, 50019117, 3, ',50013886,50019007,50019117,50019136,', 0),
(50023088, '卫衣', 18, 50019117, 3, ',50013886,50019007,50019117,50023088,', 0),
(50023089, '裙子/迷彩裙', 19, 50019117, 3, ',50013886,50019007,50019117,50023089,', 0),
(50023090, '吉利服/伪装服', 20, 50019117, 3, ',50013886,50019007,50019117,50023090,', 0),
(50023122, '军大衣/棉大衣', 21, 50019117, 3, ',50013886,50019007,50019117,50023122,', 0),
(50023161, '作训外套/套装/野战套装', 22, 50019117, 3, ',50013886,50019007,50019117,50023161,', 0),
(50019140, '战术靴/飞行靴/沙漠靴', 0, 50019118, 3, ',50013886,50019007,50019118,50019140,', 0),
(50019144, '鞋靴配件', 4, 50019118, 3, ',50013886,50019007,50019118,50019144,', 0),
(50019342, '解放鞋/回力鞋/帆布鞋', 5, 50019118, 3, ',50013886,50019007,50019118,50019342,', 0),
(50019145, '军迷帽/奔尼帽/平顶帽/解放帽', 0, 50019119, 3, ',50013886,50019007,50019119,50019145,', 0),
(50019162, '旗帜', 0, 50019119, 3, ',50013886,50019007,50019119,50019162,', 0),
(50019163, '勋章/臂章/肩章/纪念章', 1, 50019119, 3, ',50013886,50019007,50019119,50019163,', 0),
(50019146, '头盔/面罩/面具', 1, 50019119, 3, ',50013886,50019007,50019119,50019146,', 0),
(50019164, '身份牌/金属牌', 2, 50019119, 3, ',50013886,50019007,50019119,50019164,', 0),
(50019147, '风镜/眼镜', 2, 50019119, 3, ',50013886,50019007,50019119,50019147,', 0),
(50019150, '战术手套/军迷手套', 5, 50019119, 3, ',50013886,50019007,50019119,50019150,', 0),
(50019151, '战术腰带/皮带/腰封', 6, 50019119, 3, ',50013886,50019007,50019119,50019151,', 0),
(50023092, '军迷手表', 9, 50019119, 3, ',50013886,50019007,50019119,50023092,', 0),
(50023136, '战术护具/护膝/护腕', 10, 50019119, 3, ',50013886,50019007,50019119,50023136,', 0),
(50019154, '战术双肩背包', 0, 50019122, 3, ',50013886,50019007,50019122,50019154,', 0),
(50019155, '解放包/单肩包', 1, 50019122, 3, ',50013886,50019007,50019122,50019155,', 0),
(50019157, '腰包/臂包/拎包', 3, 50019122, 3, ',50013886,50019007,50019122,50019157,', 0),
(50019223, '腿包', 4, 50019122, 3, ',50013886,50019007,50019122,50019223,', 0),
(50019160, '其他包', 7, 50019122, 3, ',50013886,50019007,50019122,50019160,', 0),
(50019161, '包具配件', 8, 50019122, 3, ',50013886,50019007,50019122,50019161,', 0),
(50023086, '鞍袋', 9, 50019122, 3, ',50013886,50019007,50019122,50023086,', 0),
(50023087, '空降包', 10, 50019122, 3, ',50013886,50019007,50019122,50023087,', 0),
(50019235, '除尘掸', 0, 50019233, 3, ',50016348,50003949,50019233,50019235,', 0),
(50019236, '掸头', 1, 50019233, 3, ',50016348,50003949,50019233,50019236,', 0),
(50018779, '自行车水壶', 0, 50019291, 3, ',50010728,2612,50019291,50018779,', 0),
(50018780, '水壶架', 1, 50019291, 3, ',50010728,2612,50019291,50018780,', 0),
(50018744, '自行车灯', 2, 50019291, 3, ',50010728,2612,50019291,50018744,', 0),
(50019299, '灯架/灯夹', 3, 50019291, 3, ',50010728,2612,50019291,50019299,', 0),
(50018745, '车铃/喇叭', 4, 50019291, 3, ',50010728,2612,50019291,50018745,', 0),
(50018746, '自行车锁', 5, 50019291, 3, ',50010728,2612,50019291,50018746,', 0),
(50018747, '货架/尾架', 5, 50019291, 3, ',50010728,2612,50019291,50018747,', 0),
(50018781, '打气筒', 10, 50019291, 3, ',50010728,2612,50019291,50018781,', 0),
(50018750, '儿童座椅', 11, 50019291, 3, ',50010728,2612,50019291,50018750,', 0),
(50018778, '自行车码表及配件', 14, 50019291, 3, ',50010728,2612,50019291,50018778,', 0),
(50018782, '防水地图袋', 15, 50019291, 3, ',50010728,2612,50019291,50018782,', 0),
(50019298, '自行车手机架', 37, 50019291, 3, ',50010728,2612,50019291,50019298,', 0),
(50019300, '单车护链贴', 38, 50019291, 3, ',50010728,2612,50019291,50019300,', 0),
(50019301, '捆扎带/车把带', 39, 50019291, 3, ',50010728,2612,50019291,50019301,', 0),
(50019303, '自行车撑伞架', 41, 50019291, 3, ',50010728,2612,50019291,50019303,', 0),
(50019304, '便携音响/音箱', 42, 50019291, 3, ',50010728,2612,50019291,50019304,', 0),
(50019305, '自行车贴纸/反光贴', 43, 50019291, 3, ',50010728,2612,50019291,50019305,', 0),
(50019381, '电动车电池', 0, 50019380, 3, ',50010728,50019782,50019380,50019381,', 0),
(50019382, '电机', 1, 50019380, 3, ',50010728,50019782,50019380,50019382,', 0),
(50019383, '电动车前叉/减震装置', 2, 50019380, 3, ',50010728,50019782,50019380,50019383,', 0),
(50019384, '电动车刹车装置', 3, 50019380, 3, ',50010728,50019782,50019380,50019384,', 0),
(50019385, '电动车坐垫', 4, 50019380, 3, ',50010728,50019782,50019380,50019385,', 0),
(50019386, '电动车车篮/车筐', 5, 50019380, 3, ',50010728,50019782,50019380,50019386,', 0),
(50019387, '电动车后备箱', 6, 50019380, 3, ',50010728,50019782,50019380,50019387,', 0),
(50019388, '电动车脚踏', 7, 50019380, 3, ',50010728,50019782,50019380,50019388,', 0),
(50019389, '电动车外胎', 8, 50019380, 3, ',50010728,50019782,50019380,50019389,', 0),
(50019390, '电动车内胎', 9, 50019380, 3, ',50010728,50019782,50019380,50019390,', 0),
(50019391, '电动车灯', 10, 50019380, 3, ',50010728,50019782,50019380,50019391,', 0),
(50019392, '电动车反光镜', 11, 50019380, 3, ',50010728,50019782,50019380,50019392,', 0),
(50019393, '电动车轴承', 12, 50019380, 3, ',50010728,50019782,50019380,50019393,', 0),
(50019394, '电动车飞轮', 13, 50019380, 3, ',50010728,50019782,50019380,50019394,', 0),
(50019395, '电动车辐条', 14, 50019380, 3, ',50010728,50019782,50019380,50019395,', 0),
(50019396, '电动车线类', 15, 50019380, 3, ',50010728,50019782,50019380,50019396,', 0),
(50019397, '电动车开关', 16, 50019380, 3, ',50010728,50019782,50019380,50019397,', 0),
(50019398, '电动车碳刷/刷架', 17, 50019380, 3, ',50010728,50019782,50019380,50019398,', 0),
(50019399, '保险丝/保险丝座', 18, 50019380, 3, ',50010728,50019782,50019380,50019399,', 0),
(50019400, '电动车充电插座', 19, 50019380, 3, ',50010728,50019782,50019380,50019400,', 0),
(50019401, '更多电动车零/配件', 20, 50019380, 3, ',50010728,50019782,50019380,50019401,', 0),
(50019403, '电动车充电器', 0, 50019402, 3, ',50010728,50019782,50019402,50019403,', 0),
(50022559, '快速充电站', 1, 50019402, 3, ',50010728,50019782,50019402,50022559,', 0),
(50019404, '电动车锁', 2, 50019402, 3, ',50010728,50019782,50019402,50019404,', 0),
(50019405, '电动车报警器', 3, 50019402, 3, ',50010728,50019782,50019402,50019405,', 0),
(50019406, '电动车铃/喇叭', 4, 50019402, 3, ',50010728,50019782,50019402,50019406,', 0),
(50019407, '电动车音响/音箱', 5, 50019402, 3, ',50010728,50019782,50019402,50019407,', 0),
(50019408, '电压转换器', 6, 50019402, 3, ',50010728,50019782,50019402,50019408,', 0),
(50019409, '电池修复器', 7, 50019402, 3, ',50010728,50019782,50019402,50019409,', 0),
(50019410, '电池修复液', 8, 50019402, 3, ',50010728,50019782,50019402,50019410,', 0),
(50019411, '电动车撑伞架', 9, 50019402, 3, ',50010728,50019782,50019402,50019411,', 0),
(50019412, '瘪胎助推器', 10, 50019402, 3, ',50010728,50019782,50019402,50019412,', 0),
(50019413, '电动车防尘罩', 11, 50019402, 3, ',50010728,50019782,50019402,50019413,', 0),
(50019414, '电动车打气筒', 12, 50019402, 3, ',50010728,50019782,50019402,50019414,', 0),
(50019415, '电动车定时器', 13, 50019402, 3, ',50010728,50019782,50019402,50019415,', 0),
(50019416, '电动个性车牌', 14, 50019402, 3, ',50010728,50019782,50019402,50019416,', 0),
(50019417, '电动车贴', 15, 50019402, 3, ',50010728,50019782,50019402,50019417,', 0),
(50019418, '电动车头盔', 16, 50019402, 3, ',50010728,50019782,50019402,50019418,', 0),
(50019419, '电动车雨披', 17, 50019402, 3, ',50010728,50019782,50019402,50019419,', 0),
(50019420, '电动车手套/护手', 18, 50019402, 3, ',50010728,50019782,50019402,50019420,', 0),
(50019421, '电动车护膝', 19, 50019402, 3, ',50010728,50019782,50019402,50019421,', 0),
(50019422, '电动车电池盒', 20, 50019402, 3, ',50010728,50019782,50019402,50019422,', 0),
(50019423, '更多电动车装备', 21, 50019402, 3, ',50010728,50019782,50019402,50019423,', 0),
(50019428, '撬胎棒', 0, 50019427, 3, ',50010728,50019782,50019427,50019428,', 0),
(50019430, '扳手', 1, 50019427, 3, ',50010728,50019782,50019427,50019430,', 0),
(50019431, '橡胶锤', 2, 50019427, 3, ',50010728,50019782,50019427,50019431,', 0),
(50019433, '热熔枪', 3, 50019427, 3, ',50010728,50019782,50019427,50019433,', 0),
(50019434, '电烙铁', 4, 50019427, 3, ',50010728,50019782,50019427,50019434,', 0),
(50019435, '焊锡丝', 5, 50019427, 3, ',50010728,50019782,50019427,50019435,', 0),
(50019436, '气门芯', 6, 50019427, 3, ',50010728,50019782,50019427,50019436,', 0),
(50019437, '热缩管', 7, 50019427, 3, ',50010728,50019782,50019427,50019437,', 0),
(50019438, '扎带', 8, 50019427, 3, ',50010728,50019782,50019427,50019438,', 0),
(50019439, '胶棒', 9, 50019427, 3, ',50010728,50019782,50019427,50019439,', 0),
(50019440, '冷补胶', 10, 50019427, 3, ',50010728,50019782,50019427,50019440,', 0),
(50019441, 'AB胶', 11, 50019427, 3, ',50010728,50019782,50019427,50019441,', 0),
(50019442, '绝缘胶布', 12, 50019427, 3, ',50010728,50019782,50019427,50019442,', 0),
(50019444, '万用表', 13, 50019427, 3, ',50010728,50019782,50019427,50019444,', 0),
(50019445, '整车检测仪', 14, 50019427, 3, ',50010728,50019782,50019427,50019445,', 0),
(50019446, '电池检测仪', 15, 50019427, 3, ',50010728,50019782,50019427,50019446,', 0),
(50019447, '除绣剂', 16, 50019427, 3, ',50010728,50019782,50019427,50019447,', 0),
(50019448, '电池夹', 17, 50019427, 3, ',50010728,50019782,50019427,50019448,', 0),
(50019449, '控制器接头/插接件', 18, 50019427, 3, ',50010728,50019782,50019427,50019449,', 0),
(50019450, '更多电动车维修工具', 19, 50019427, 3, ',50010728,50019782,50019427,50019450,', 0),
(50014677, '速干衬衣', 1, 50019517, 3, ',50013886,50013888,50019517,50014677,', 0),
(50013932, '速干T恤', 2, 50019517, 3, ',50013886,50013888,50019517,50013932,', 0),
(50019520, '速干背心', 3, 50019517, 3, ',50013886,50013888,50019517,50019520,', 0),
(50014791, '速干裤', 5, 50019517, 3, ',50013886,50013888,50019517,50014791,', 0),
(50019526, '速干衣裤套装', 6, 50019517, 3, ',50013886,50013888,50019517,50019526,', 0),
(50014799, '保暖棉衣', 1, 50019527, 3, ',50013886,50013888,50019527,50014799,', 0),
(50019549, '保暖棉衣裤套装', 3, 50019527, 3, ',50013886,50013888,50019527,50019549,', 0),
(50019547, '保暖棉裤', 3, 50019527, 3, ',50013886,50013888,50019527,50019547,', 0),
(50019585, '地钉', 0, 50019584, 3, ',50013886,50019539,50019584,50019585,', 0),
(50019586, '帐篷绳', 1, 50019584, 3, ',50013886,50019539,50019584,50019586,', 0),
(50019587, '修补包/修补贴', 2, 50019584, 3, ',50013886,50019539,50019584,50019587,', 0),
(50019588, '篷布/网纱', 3, 50019584, 3, ',50013886,50019539,50019584,50019588,', 0),
(50019589, '帐杆/支撑杆/单杆修补管', 4, 50019584, 3, ',50013886,50019539,50019584,50019589,', 0),
(50019590, '挂钩', 5, 50019584, 3, ',50013886,50019539,50019584,50019590,', 0),
(50019591, '其他配件', 6, 50019584, 3, ',50013886,50019539,50019584,50019591,', 0),
(50019608, '电池/燃料', 0, 50019607, 3, ',50013886,50019601,50019607,50019608,', 0),
(50019609, '充电器', 1, 50019607, 3, ',50013886,50019601,50019607,50019609,', 0),
(50019610, '光杯', 2, 50019607, 3, ',50013886,50019601,50019607,50019610,', 0),
(50019611, '开关帽', 3, 50019607, 3, ',50013886,50019601,50019607,50019611,', 0),
(50019613, '其他', 5, 50019607, 3, ',50013886,50019601,50019607,50019613,', 0),
(50017778, '手电头带', 8, 50019607, 3, ',50013886,50019601,50019607,50017778,', 0),
(50020128, '电筒套/灯套', 9, 50019607, 3, ',50013886,50019601,50019607,50020128,', 0),
(50019620, '自慰软胶', 0, 50019619, 3, ',2813,50019617,50019619,50019620,', 0),
(50019621, '自慰杯', 1, 50019619, 3, ',2813,50019617,50019619,50019621,', 0),
(50019622, '自慰蛋', 2, 50019619, 3, ',2813,50019617,50019619,50019622,', 0),
(50019624, '充气娃娃', 0, 50019623, 3, ',2813,50019617,50019623,50019624,', 0),
(50019625, '实体娃娃', 1, 50019623, 3, ',2813,50019617,50019623,50019625,', 0),
(50019692, '延时套', 0, 50019644, 3, ',2813,50019641,50019644,50019692,', 0),
(50019693, '延时环', 1, 50019644, 3, ',2813,50019641,50019644,50019693,', 0),
(50019698, '女用调情香水', 0, 50019646, 3, ',2813,50019641,50019646,50019698,', 0),
(50019699, '男用调情香水', 1, 50019646, 3, ',2813,50019641,50019646,50019699,', 0),
(50019654, '男式情趣内裤', 0, 50019653, 3, ',2813,50019651,50019653,50019654,', 0),
(50019655, '女式情趣内裤', 1, 50019653, 3, ',2813,50019651,50019653,50019655,', 0),
(50019660, '吊袜带', 0, 50019659, 3, ',2813,50019651,50019659,50019660,', 0),
(50019661, '手套', 1, 50019659, 3, ',2813,50019651,50019659,50019661,', 0),
(50019662, '手圈', 2, 50019659, 3, ',2813,50019651,50019659,50019662,', 0),
(50019663, '足环', 3, 50019659, 3, ',2813,50019651,50019659,50019663,', 0),
(50019664, '眼罩', 4, 50019659, 3, ',2813,50019651,50019659,50019664,', 0),
(50019665, '其他配饰', 5, 50019659, 3, ',2813,50019651,50019659,50019665,', 0),
(50019724, '塑料水袋', 0, 50019713, 3, ',50013886,50019712,50019713,50019724,', 0),
(50019725, '皮水袋/皮囊', 1, 50019713, 3, ',50013886,50019712,50019713,50019725,', 0),
(50019719, '壶套/杯套/保温套', 0, 50019718, 3, ',50013886,50019712,50019718,50019719,', 0),
(50019720, '水袋配件', 1, 50019718, 3, ',50013886,50019712,50019718,50019720,', 0),
(50019721, '瓶盖/杯盖', 2, 50019718, 3, ',50013886,50019712,50019718,50019721,', 0),
(50019722, '水具清洁用品', 3, 50019718, 3, ',50013886,50019712,50019718,50019722,', 0),
(50019842, '照明模块', 0, 50019838, 3, ',27,50019835,50019838,50019842,', 0),
(50019845, '射灯模块', 1, 50019838, 3, ',27,50019835,50019838,50019845,', 0),
(50019846, '换气模块', 2, 50019838, 3, ',27,50019835,50019838,50019846,', 0),
(50019848, '灯暖模块', 3, 50019838, 3, ',27,50019835,50019838,50019848,', 0),
(50019851, '暖风模块', 4, 50019838, 3, ',27,50019835,50019838,50019851,', 0),
(50019853, '多功能组合电器', 5, 50019838, 3, ',27,50019835,50019838,50019853,', 0),
(50019854, '龙骨', 0, 50019840, 3, ',27,50019835,50019840,50019854,', 0),
(50019857, '收边条', 1, 50019840, 3, ',27,50019835,50019840,50019857,', 0),
(50019858, '丝杆', 2, 50019840, 3, ',27,50019835,50019840,50019858,', 0),
(50019861, '其它', 3, 50019840, 3, ',27,50019835,50019840,50019861,', 0),
(50019984, '门球杆', 0, 50019983, 3, ',50010728,50018025,50019983,50019984,', 0),
(50019985, '门球', 1, 50019983, 3, ',50010728,50018025,50019983,50019985,', 0),
(50019986, '门球球门', 2, 50019983, 3, ',50010728,50018025,50019983,50019986,', 0),
(50019987, '专用计时/记分器', 3, 50019983, 3, ',50010728,50018025,50019983,50019987,', 0),
(50019988, '门球包', 4, 50019983, 3, ',50010728,50018025,50019983,50019988,', 0),
(50020025, '面盆龙头', 0, 50020008, 3, ',27,50020007,50020008,50020025,', 0),
(50020027, '浴缸淋浴龙头', 2, 50020008, 3, ',27,50020007,50020008,50020027,', 0),
(50020028, '洗衣机龙头', 3, 50020008, 3, ',27,50020007,50020008,50020028,', 0),
(50020029, '拖把池龙头', 4, 50020008, 3, ',27,50020007,50020008,50020029,', 0),
(50020030, '净身盆龙头', 5, 50020008, 3, ',27,50020007,50020008,50020030,', 0),
(50013347, '花洒配件', 16, 50020008, 3, ',27,50020007,50020008,50013347,', 0),
(50013326, '淋浴花洒龙头', 30, 50020008, 3, ',27,50020007,50020008,50013326,', 0),
(50020032, '一体智能坐便器', 1, 50020009, 3, ',27,50020007,50020009,50020032,', 0),
(50003558, '普通坐便器', 2, 50020009, 3, ',27,50020007,50020009,50003558,', 0),
(50013343, '座便器配件', 12, 50020009, 3, ',27,50020007,50020009,50013343,', 0),
(50020033, '普通坐便盖板', 0, 50020010, 3, ',27,50020007,50020010,50020033,', 0),
(50020034, '智能坐便盖板', 1, 50020010, 3, ',27,50020007,50020010,50020034,', 0),
(50020036, '一体感应式小便斗', 1, 50020013, 3, ',27,50020007,50020013,50020036,', 0),
(50020037, '无水小便斗', 2, 50020013, 3, ',27,50020007,50020013,50020037,', 0),
(50003560, '普通小便斗', 5, 50020013, 3, ',27,50020007,50020013,50003560,', 0),
(50013345, '小便器配件', 14, 50020013, 3, ',27,50020007,50020013,50013345,', 0),
(50020058, '台上盆', 0, 50020014, 3, ',27,50020007,50020014,50020058,', 0),
(50020059, '台下盆', 1, 50020014, 3, ',27,50020007,50020014,50020059,', 0),
(50020060, '立柱盆', 2, 50020014, 3, ',27,50020007,50020014,50020060,', 0),
(50020061, '挂墙式洗脸盆', 3, 50020014, 3, ',27,50020007,50020014,50020061,', 0),
(50020062, '半嵌入式洗脸盆', 4, 50020014, 3, ',27,50020007,50020014,50020062,', 0),
(50020063, '盆、台一体成型式台盆', 5, 50020014, 3, ',27,50020007,50020014,50020063,', 0),
(50020064, '台上艺术碗盆', 6, 50020014, 3, ',27,50020007,50020014,50020064,', 0),
(50013349, '脸盆配用件', 18, 50020014, 3, ',27,50020007,50020014,50013349,', 0),
(50020065, '普通冲水阀', 0, 50020015, 3, ',27,50020007,50020015,50020065,', 0),
(50020066, '感应冲水器', 1, 50020015, 3, ',27,50020007,50020015,50020066,', 0),
(50020125, '按摩浴缸', 1, 50020016, 3, ',27,50020007,50020016,50020125,', 0),
(50013348, '浴缸配件', 17, 50020016, 3, ',27,50020007,50020016,50013348,', 0),
(50002411, '普通浴缸', 28, 50020016, 3, ',27,50020007,50020016,50002411,', 0),
(50020068, '定制淋浴拉门', 1, 50020017, 3, ',27,50020007,50020017,50020068,', 0),
(50013346, '淋浴房配件', 15, 50020017, 3, ',27,50020007,50020017,50013346,', 0),
(215903, '整体淋浴房', 31, 50020017, 3, ',27,50020007,50020017,215903,', 0),
(50020069, '浴室柜', 0, 50020018, 3, ',27,50020007,50020018,50020069,', 0),
(50020070, '浴室镜柜', 1, 50020018, 3, ',27,50020007,50020018,50020070,', 0),
(50020071, '浴室边柜', 2, 50020018, 3, ',27,50020007,50020018,50020071,', 0),
(50020072, '浴室柜组合', 3, 50020018, 3, ',27,50020007,50020018,50020072,', 0),
(50007071, '马克杯', 0, 50020225, 3, ',50025004,50025007,50020225,50007071,', 0),
(50020226, '保温杯', 1, 50020225, 3, ',50025004,50025007,50020225,50020226,', 0),
(50020227, '咖啡杯', 2, 50020225, 3, ',50025004,50025007,50020225,50020227,', 0),
(50020228, '酒杯', 3, 50020225, 3, ',50025004,50025007,50020225,50020228,', 0),
(50020229, '其它', 4, 50020225, 3, ',50025004,50025007,50020225,50020229,', 0),
(50015297, '运动水壶', 31, 50020225, 3, ',50025004,50025007,50020225,50015297,', 0),
(280903, '台历', 0, 50020230, 3, ',50025004,50025007,50020230,280903,', 0),
(50020231, '挂历', 1, 50020230, 3, ',50025004,50025007,50020230,50020231,', 0),
(50015115, '鼠标垫', 0, 50020233, 3, ',50025004,50025008,50020233,50015115,', 0),
(50018428, '胸牌定做', 1, 50020233, 3, ',50025004,50025008,50020233,50018428,', 0),
(50020238, '笔', 2, 50020233, 3, ',50025004,50025008,50020233,50020238,', 0),
(50008755, '奖杯/奖牌/奖章/证书定制', 10, 50020233, 3, ',50025004,50025008,50020233,50008755,', 0),
(50015301, '背胶证件照', 35, 50020233, 3, ',50025004,50025008,50020233,50015301,', 0),
(280908, '水晶影像定制', 0, 50020235, 3, ',50025004,50025007,50020235,280908,', 0),
(50020239, '水晶挂件定制', 1, 50020235, 3, ',50025004,50025007,50020235,50020239,', 0),
(50018797, '水晶内雕定做', 2, 50020235, 3, ',50025004,50025007,50020235,50018797,', 0),
(50021305, '机械门锁', 0, 50020495, 3, ',50020485,50020486,50020495,50021305,', 0),
(50021306, '电子门锁', 1, 50020495, 3, ',50020485,50020486,50020495,50021306,', 0),
(50021307, '自行车锁', 2, 50020495, 3, ',50020485,50020486,50020495,50021307,', 0),
(50021308, '家具锁', 3, 50020495, 3, ',50020485,50020486,50020495,50021308,', 0),
(50021309, '挂锁', 4, 50020495, 3, ',50020485,50020486,50020495,50021309,', 0),
(50021310, '车锁', 5, 50020495, 3, ',50020485,50020486,50020495,50021310,', 0),
(50021311, '特殊用锁', 6, 50020495, 3, ',50020485,50020486,50020495,50021311,', 0),
(50021312, '普通型合页', 0, 50020496, 3, ',50020485,50020486,50020496,50021312,', 0),
(50021315, '轴承合页', 3, 50020496, 3, ',50020485,50020486,50020496,50021315,', 0),
(50021316, '双袖型合页', 4, 50020496, 3, ',50020485,50020486,50020496,50021316,', 0),
(50021318, '脱卸合页', 6, 50020496, 3, ',50020485,50020486,50020496,50021318,', 0),
(50021319, '弹簧合页', 7, 50020496, 3, ',50020485,50020486,50020496,50021319,', 0),
(50021320, '暗合页', 8, 50020496, 3, ',50020485,50020486,50020496,50021320,', 0),
(50021321, '子母合页', 9, 50020496, 3, ',50020485,50020486,50020496,50021321,', 0),
(50021755, '大拉手', 0, 50020497, 3, ',50020485,50020486,50020497,50021755,', 0),
(50021756, '小拉手', 1, 50020497, 3, ',50020485,50020486,50020497,50021756,', 0),
(50021327, '暗插销', 0, 50020498, 3, ',50020485,50020486,50020498,50021327,', 0),
(50021328, '明插销', 1, 50020498, 3, ',50020485,50020486,50020498,50021328,', 0),
(50021360, '压条', 0, 50020499, 3, ',50020485,50020486,50020499,50021360,', 0),
(50021362, '门弹弓', 2, 50020499, 3, ',50020485,50020486,50020499,50021362,', 0),
(50021363, '安全链/扣', 3, 50020499, 3, ',50020485,50020486,50020499,50021363,', 0),
(50021364, '门鼻', 4, 50020499, 3, ',50020485,50020486,50020499,50021364,', 0),
(50013420, '门吸', 6, 50020499, 3, ',50020485,50020486,50020499,50013420,', 0),
(50013424, '地弹簧', 7, 50020499, 3, ',50020485,50020486,50020499,50013424,', 0),
(50013429, '门牌', 8, 50020499, 3, ',50020485,50020486,50020499,50013429,', 0),
(50013681, '门镜/猫眼', 9, 50020499, 3, ',50020485,50020486,50020499,50013681,', 0),
(50013421, '吊滑', 10, 50020499, 3, ',50020485,50020486,50020499,50013421,', 0),
(50013425, '闭门器', 11, 50020499, 3, ',50020485,50020486,50020499,50013425,', 0),
(50013427, '门挡', 12, 50020499, 3, ',50020485,50020486,50020499,50013427,', 0);
INSERT INTO `{dbprefix}shop_industry_catalog` (`id`, `cat_name`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`) VALUES
(50013428, '碰珠', 13, 50020499, 3, ',50020485,50020486,50020499,50013428,', 0),
(50022570, '门夹', 14, 50020499, 3, ',50020485,50020486,50020499,50022570,', 0),
(50013426, '浴室玻璃夹', 15, 50020499, 3, ',50020485,50020486,50020499,50013426,', 0),
(50021365, '其他门用配件', 16, 50020499, 3, ',50020485,50020486,50020499,50021365,', 0),
(50021366, '执手', 0, 50020500, 3, ',50020485,50020486,50020500,50021366,', 0),
(50021367, '门/窗钩', 1, 50020500, 3, ',50020485,50020486,50020500,50021367,', 0),
(50021368, '羊眼', 2, 50020500, 3, ',50020485,50020486,50020500,50021368,', 0),
(50021369, '撑杆', 3, 50020500, 3, ',50020485,50020486,50020500,50021369,', 0),
(50021370, '窗锁', 4, 50020500, 3, ',50020485,50020486,50020500,50021370,', 0),
(50021371, '密封条', 5, 50020500, 3, ',50020485,50020486,50020500,50021371,', 0),
(50021372, '滑轮', 6, 50020500, 3, ',50020485,50020486,50020500,50021372,', 0),
(50021373, '其他窗用配件', 7, 50020500, 3, ',50020485,50020486,50020500,50021373,', 0),
(50022231, '导轨', 1, 50020501, 3, ',50020485,50020486,50020501,50022231,', 0),
(50015645, '椅扶手', 2, 50020501, 3, ',50020485,50020486,50020501,50015645,', 0),
(50013422, '铰链', 2, 50020501, 3, ',50020485,50020486,50020501,50013422,', 0),
(50013459, '层板拖', 3, 50020501, 3, ',50020485,50020486,50020501,50013459,', 0),
(50013461, '踢脚板', 5, 50020501, 3, ',50020485,50020486,50020501,50013461,', 0),
(50021331, '转椅扶手', 5, 50020501, 3, ',50020485,50020486,50020501,50021331,', 0),
(50013462, '橱柜脚', 6, 50020501, 3, ',50020485,50020486,50020501,50013462,', 0),
(50013463, '门板封边', 7, 50020501, 3, ',50020485,50020486,50020501,50013463,', 0),
(50021335, '衣杆', 9, 50020501, 3, ',50020485,50020486,50020501,50021335,', 0),
(50021336, '家具底座', 10, 50020501, 3, ',50020485,50020486,50020501,50021336,', 0),
(50021337, '家具转盘', 11, 50020501, 3, ',50020485,50020486,50020501,50021337,', 0),
(50021339, '木塞/木榫', 13, 50020501, 3, ',50020485,50020486,50020501,50021339,', 0),
(50021340, '防尘胶条', 14, 50020501, 3, ',50020485,50020486,50020501,50021340,', 0),
(50021341, '塑胶封边条', 15, 50020501, 3, ',50020485,50020486,50020501,50021341,', 0),
(50021342, '防撞胶粒', 16, 50020501, 3, ',50020485,50020486,50020501,50021342,', 0),
(50021343, '防撞器', 17, 50020501, 3, ',50020485,50020486,50020501,50021343,', 0),
(50021345, '搁板销', 19, 50020501, 3, ',50020485,50020486,50020501,50021345,', 0),
(50021346, '角码', 20, 50020501, 3, ',50020485,50020486,50020501,50021346,', 0),
(50021347, '暗箱扣', 21, 50020501, 3, ',50020485,50020486,50020501,50021347,', 0),
(50021348, '气动杆', 22, 50020501, 3, ',50020485,50020486,50020501,50021348,', 0),
(50013411, '柜脚/腿', 25, 50020501, 3, ',50020485,50020486,50020501,50013411,', 0),
(50021351, '脚轮/万向轮', 26, 50020501, 3, ',50020485,50020486,50020501,50021351,', 0),
(50013412, '柜内裤架', 29, 50020501, 3, ',50020485,50020486,50020501,50013412,', 0),
(50013413, '线孔盖', 30, 50020501, 3, ',50020485,50020486,50020501,50013413,', 0),
(50013414, '挂衣钩', 31, 50020501, 3, ',50020485,50020486,50020501,50013414,', 0),
(50013415, '家具脚垫', 32, 50020501, 3, ',50020485,50020486,50020501,50013415,', 0),
(50013416, '家具连接件', 33, 50020501, 3, ',50020485,50020486,50020501,50013416,', 0),
(50021352, '其他家具五金', 34, 50020501, 3, ',50020485,50020486,50020501,50021352,', 0),
(50021334, '转椅五星脚', 35, 50020501, 3, ',50020485,50020486,50020501,50021334,', 0),
(50021374, '钢丝绳', 0, 50020502, 3, ',50020485,50020486,50020502,50021374,', 0),
(50021375, '钢板网', 1, 50020502, 3, ',50020485,50020486,50020502,50021375,', 0),
(50021376, '铝板网', 2, 50020502, 3, ',50020485,50020486,50020502,50021376,', 0),
(50021377, '玻璃托/夹', 3, 50020502, 3, ',50020485,50020486,50020502,50021377,', 0),
(50021379, '货品支架', 5, 50020502, 3, ',50020485,50020486,50020502,50021379,', 0),
(50021380, '风管', 6, 50020502, 3, ',50020485,50020486,50020502,50021380,', 0),
(50006107, '锁具配件', 8, 50020502, 3, ',50020485,50020486,50020502,50006107,', 0),
(50021385, '铝合金梯子/移动爬梯', 11, 50020502, 3, ',50020485,50020486,50020502,50021385,', 0),
(50013470, '其它五金', 13, 50020502, 3, ',50020485,50020486,50020502,50013470,', 0),
(50006949, '不锈钢垃圾桶', 39, 50020502, 3, ',50020485,50020486,50020502,50006949,', 0),
(50013465, '缎带/扎带', 40, 50020502, 3, ',50020485,50020486,50020502,50013465,', 0),
(50013466, '胶带', 41, 50020502, 3, ',50020485,50020486,50020502,50013466,', 0),
(50021387, '尖嘴钳', 0, 50020503, 3, ',50020485,50020487,50020503,50021387,', 0),
(50021388, '扁嘴钳', 1, 50020503, 3, ',50020485,50020487,50020503,50021388,', 0),
(50021389, '圆嘴钳', 2, 50020503, 3, ',50020485,50020487,50020503,50021389,', 0),
(50021390, '斜嘴钳', 3, 50020503, 3, ',50020485,50020487,50020503,50021390,', 0),
(50021391, '弯嘴钳', 4, 50020503, 3, ',50020485,50020487,50020503,50021391,', 0),
(50021392, '顶切钳', 5, 50020503, 3, ',50020485,50020487,50020503,50021392,', 0),
(50021393, '钢丝钳', 6, 50020503, 3, ',50020485,50020487,50020503,50021393,', 0),
(50021394, '鲤鱼钳', 7, 50020503, 3, ',50020485,50020487,50020503,50021394,', 0),
(50021395, '胡桃钳', 8, 50020503, 3, ',50020485,50020487,50020503,50021395,', 0),
(50021396, '鹰嘴断线钳', 9, 50020503, 3, ',50020485,50020487,50020503,50021396,', 0),
(50021397, '剥线钳', 10, 50020503, 3, ',50020485,50020487,50020503,50021397,', 0),
(50021398, '紧线钳', 11, 50020503, 3, ',50020485,50020487,50020503,50021398,', 0),
(50021399, '压线钳', 12, 50020503, 3, ',50020485,50020487,50020503,50021399,', 0),
(50021400, '线缆钳', 13, 50020503, 3, ',50020485,50020487,50020503,50021400,', 0),
(50021401, '铅印钳', 14, 50020503, 3, ',50020485,50020487,50020503,50021401,', 0),
(50021402, '挡圈/卡簧钳', 15, 50020503, 3, ',50020485,50020487,50020503,50021402,', 0),
(50021403, '大力钳', 16, 50020503, 3, ',50020485,50020487,50020503,50021403,', 0),
(50021405, '羊角起钉钳', 18, 50020503, 3, ',50020485,50020487,50020503,50021405,', 0),
(50021406, '水泵钳', 19, 50020503, 3, ',50020485,50020487,50020503,50021406,', 0),
(50021407, '管子钳', 20, 50020503, 3, ',50020485,50020487,50020503,50021407,', 0),
(50021408, '台虎钳', 21, 50020503, 3, ',50020485,50020487,50020503,50021408,', 0),
(50021409, '桌虎钳', 22, 50020503, 3, ',50020485,50020487,50020503,50021409,', 0),
(50021410, '手虎钳', 23, 50020503, 3, ',50020485,50020487,50020503,50021410,', 0),
(50021411, '水口钳', 24, 50020503, 3, ',50020485,50020487,50020503,50021411,', 0),
(50021412, 'G/F字夹', 25, 50020503, 3, ',50020485,50020487,50020503,50021412,', 0),
(50013680, '其它夹持类工具', 26, 50020503, 3, ',50020485,50020487,50020503,50013680,', 0),
(50021424, '活扳手', 0, 50020504, 3, ',50020485,50020487,50020504,50021424,', 0),
(50021425, '侧面孔勾扳手', 1, 50020504, 3, ',50020485,50020487,50020504,50021425,', 0),
(50021426, '内四方扳手', 2, 50020504, 3, ',50020485,50020487,50020504,50021426,', 0),
(50021427, '内六角扳手', 3, 50020504, 3, ',50020485,50020487,50020504,50021427,', 0),
(50021428, '单头呆扳手', 4, 50020504, 3, ',50020485,50020487,50020504,50021428,', 0),
(50021429, '两用扳手', 5, 50020504, 3, ',50020485,50020487,50020504,50021429,', 0),
(50021430, '双头呆扳手', 6, 50020504, 3, ',50020485,50020487,50020504,50021430,', 0),
(50021431, '梅花扳手', 7, 50020504, 3, ',50020485,50020487,50020504,50021431,', 0),
(50021432, '手动套筒扳手', 8, 50020504, 3, ',50020485,50020487,50020504,50021432,', 0),
(50021433, '十字柄套筒扳手', 9, 50020504, 3, ',50020485,50020487,50020504,50021433,', 0),
(50021434, '管活两用扳手', 10, 50020504, 3, ',50020485,50020487,50020504,50021434,', 0),
(50021435, '快速管子扳手', 11, 50020504, 3, ',50020485,50020487,50020504,50021435,', 0),
(50021436, '棘轮扳手', 12, 50020504, 3, ',50020485,50020487,50020504,50021436,', 0),
(50021437, '扭力扳手', 13, 50020504, 3, ',50020485,50020487,50020504,50021437,', 0),
(50021438, '增力扳手', 14, 50020504, 3, ',50020485,50020487,50020504,50021438,', 0),
(50021439, '其他扳手', 15, 50020504, 3, ',50020485,50020487,50020504,50021439,', 0),
(50021440, '6角套筒', 0, 50020505, 3, ',50020485,50020487,50020505,50021440,', 0),
(50021441, '6角长套筒', 1, 50020505, 3, ',50020485,50020487,50020505,50021441,', 0),
(50021442, '12角套筒', 2, 50020505, 3, ',50020485,50020487,50020505,50021442,', 0),
(50021443, '12角长套筒', 3, 50020505, 3, ',50020485,50020487,50020505,50021443,', 0),
(50021444, '花型套筒', 4, 50020505, 3, ',50020485,50020487,50020505,50021444,', 0),
(50021445, '旋具套筒', 5, 50020505, 3, ',50020485,50020487,50020505,50021445,', 0),
(50021446, '气动套筒', 6, 50020505, 3, ',50020485,50020487,50020505,50021446,', 0),
(50021447, '接杆', 7, 50020505, 3, ',50020485,50020487,50020505,50021447,', 0),
(50021448, '滑杆', 8, 50020505, 3, ',50020485,50020487,50020505,50021448,', 0),
(50021449, '接头', 9, 50020505, 3, ',50020485,50020487,50020505,50021449,', 0),
(50021450, '扳杆', 10, 50020505, 3, ',50020485,50020487,50020505,50021450,', 0),
(50021451, '风动密封圈', 11, 50020505, 3, ',50020485,50020487,50020505,50021451,', 0),
(50021453, '其他', 13, 50020505, 3, ',50020485,50020487,50020505,50021453,', 0),
(50021460, '绝缘螺丝批', 0, 50020507, 3, ',50020485,50020487,50020507,50021460,', 0),
(50021461, '棘轮螺丝批', 1, 50020507, 3, ',50020485,50020487,50020507,50021461,', 0),
(50021462, '冲击螺丝批', 2, 50020507, 3, ',50020485,50020487,50020507,50021462,', 0),
(50021463, '旋具头组套', 3, 50020507, 3, ',50020485,50020487,50020507,50021463,', 0),
(50021466, '螺丝批组套', 5, 50020507, 3, ',50020485,50020487,50020507,50021466,', 0),
(50021465, '其他', 6, 50020507, 3, ',50020485,50020487,50020507,50021465,', 0),
(50024614, '安全锤', 0, 50020508, 3, ',50020485,50020487,50020508,50024614,', 0),
(50021467, '钣金锤', 1, 50020508, 3, ',50020485,50020487,50020508,50021467,', 0),
(50021468, '木工锤', 2, 50020508, 3, ',50020485,50020487,50020508,50021468,', 0),
(50021469, '钳工锤', 3, 50020508, 3, ',50020485,50020487,50020508,50021469,', 0),
(50021471, '羊角锤', 5, 50020508, 3, ',50020485,50020487,50020508,50021471,', 0),
(50021472, '圆头锤', 6, 50020508, 3, ',50020485,50020487,50020508,50021472,', 0),
(50021473, '斩口锤', 7, 50020508, 3, ',50020485,50020487,50020508,50021473,', 0),
(50021474, '电工锤', 8, 50020508, 3, ',50020485,50020487,50020508,50021474,', 0),
(50021475, '石工锤', 9, 50020508, 3, ',50020485,50020487,50020508,50021475,', 0),
(50021476, '安装锤/胶锤', 10, 50020508, 3, ',50020485,50020487,50020508,50021476,', 0),
(50021477, '锤头', 11, 50020508, 3, ',50020485,50020487,50020508,50021477,', 0),
(50021478, '其他锤', 12, 50020508, 3, ',50020485,50020487,50020508,50021478,', 0),
(50021482, '采伐斧', 0, 50020509, 3, ',50020485,50020487,50020509,50021482,', 0),
(50021483, '木工斧', 1, 50020509, 3, ',50020485,50020487,50020509,50021483,', 0),
(50021484, '石工斧', 2, 50020509, 3, ',50020485,50020487,50020509,50021484,', 0),
(50021485, '消防斧', 3, 50020509, 3, ',50020485,50020487,50020509,50021485,', 0),
(50021486, '其他斧类', 4, 50020509, 3, ',50020485,50020487,50020509,50021486,', 0),
(50021479, '木凿', 0, 50020510, 3, ',50020485,50020487,50020510,50021479,', 0),
(50021480, '石工凿', 1, 50020510, 3, ',50020485,50020487,50020510,50021480,', 0),
(50021481, '其他凿', 2, 50020510, 3, ',50020485,50020487,50020510,50021481,', 0),
(50023754, '眼', 0, 50023731, 3, ',50023717,50023720,50023731,50023754,', 0),
(50023755, '耳', 1, 50023731, 3, ',50023717,50023720,50023731,50023755,', 0),
(50023756, '口', 2, 50023731, 3, ',50023717,50023720,50023731,50023756,', 0),
(50023757, '鼻', 3, 50023731, 3, ',50023717,50023720,50023731,50023757,', 0),
(50023758, '咽喉', 4, 50023731, 3, ',50023717,50023720,50023731,50023758,', 0),
(50023767, '小儿用药', 0, 50023738, 3, ',50023717,50023720,50023738,50023767,', 0),
(50023768, '儿童成长', 1, 50023738, 3, ',50023717,50023720,50023738,50023768,', 0),
(50023769, '孕产专区', 2, 50023738, 3, ',50023717,50023720,50023738,50023769,', 0),
(50023965, '刹车保养', 1, 50023951, 3, ',26,50023950,50023951,50023965,', 0),
(50023967, '更换机油/机油格', 2, 50023951, 3, ',26,50023950,50023951,50023967,', 0),
(50023969, '更换空气滤芯', 3, 50023951, 3, ',26,50023950,50023951,50023969,', 0),
(50023972, '更换空调滤芯', 4, 50023951, 3, ',26,50023950,50023951,50023972,', 0),
(50023973, '更换汽油格', 5, 50023951, 3, ',26,50023950,50023951,50023973,', 0),
(50023976, '更换变速箱油/波箱油/分动箱油', 6, 50023951, 3, ',26,50023950,50023951,50023976,', 0),
(50023978, '更换齿轮油', 7, 50023951, 3, ',26,50023950,50023951,50023978,', 0),
(50023979, '更换防冻液', 8, 50023951, 3, ',26,50023950,50023951,50023979,', 0),
(50023990, '四轮轴承保养', 11, 50023951, 3, ',26,50023950,50023951,50023990,', 0),
(50023991, '四轮定位', 12, 50023951, 3, ',26,50023950,50023951,50023991,', 0),
(50023992, '轮胎调换', 13, 50023951, 3, ',26,50023950,50023951,50023992,', 0),
(50023993, '轮胎动平衡', 14, 50023951, 3, ',26,50023950,50023951,50023993,', 0),
(50023994, '补胎', 15, 50023951, 3, ',26,50023950,50023951,50023994,', 0),
(50023995, '更换火花塞', 16, 50023951, 3, ',26,50023950,50023951,50023995,', 0),
(50023996, '更换水箱水', 17, 50023951, 3, ',26,50023950,50023951,50023996,', 0),
(50023997, '清洗喷油嘴', 18, 50023951, 3, ',26,50023950,50023951,50023997,', 0),
(50023998, '清洗节气门', 19, 50023951, 3, ',26,50023950,50023951,50023998,', 0),
(50023999, '其他保养服务', 20, 50023951, 3, ',26,50023950,50023951,50023999,', 0),
(50024006, '汽车钥匙改装', 0, 50023954, 3, ',26,50023950,50023954,50024006,', 0),
(50024007, '车灯改装', 1, 50023954, 3, ',26,50023950,50023954,50024007,', 0),
(50024008, '中网/前脸改装', 2, 50023954, 3, ',26,50023950,50023954,50024008,', 0),
(50024009, '包围改装', 3, 50023954, 3, ',26,50023950,50023954,50024009,', 0),
(50024010, '尾翼改装', 4, 50023954, 3, ',26,50023950,50023954,50024010,', 0),
(50024011, '避震改装', 5, 50023954, 3, ',26,50023950,50023954,50024011,', 0),
(50024012, '保险杠改装', 6, 50023954, 3, ',26,50023950,50023954,50024012,', 0),
(50024013, '车顶架改装', 7, 50023954, 3, ',26,50023950,50023954,50024013,', 0),
(50024014, '轮毂/轮胎改装', 8, 50023954, 3, ',26,50023950,50023954,50024014,', 0),
(50024015, '进/排气改装', 9, 50023954, 3, ',26,50023950,50023954,50024015,', 0),
(50024016, '叶子板改装', 10, 50023954, 3, ',26,50023950,50023954,50024016,', 0),
(50024017, '其他改装服务', 11, 50023954, 3, ',26,50023950,50023954,50024017,', 0),
(50024018, '汽车隔音', 0, 50023956, 3, ',26,50023950,50023956,50024018,', 0),
(50024019, '车标/贴装潢', 1, 50023956, 3, ',26,50023950,50023956,50024019,', 0),
(50024020, '太阳膜贴膜', 2, 50023956, 3, ',26,50023950,50023956,50024020,', 0),
(50024021, '外饰加装', 3, 50023956, 3, ',26,50023950,50023956,50024021,', 0),
(50024022, '汽车防护加装', 4, 50023956, 3, ',26,50023950,50023956,50024022,', 0),
(50024036, '其它装潢服务', 5, 50023956, 3, ',26,50023950,50023956,50024036,', 0),
(50024023, '钣金/油漆', 0, 50023957, 3, ',26,50023950,50023957,50024023,', 0),
(50024024, '保险杠修复', 1, 50023957, 3, ',26,50023950,50023957,50024024,', 0),
(50024025, '玻璃修复', 2, 50023957, 3, ',26,50023950,50023957,50024025,', 0),
(50024026, '轮毂维修', 3, 50023957, 3, ',26,50023950,50023957,50024026,', 0),
(50024027, '其他汽车维修服务', 4, 50023957, 3, ',26,50023950,50023957,50024027,', 0),
(50024028, 'DVD导航安装维修', 0, 50023960, 3, ',26,50023950,50023960,50024028,', 0),
(50024029, '定速巡航安装维修', 1, 50023960, 3, ',26,50023950,50023960,50024029,', 0),
(50024030, '倒车后视/雷达安装维修', 2, 50023960, 3, ',26,50023950,50023960,50024030,', 0),
(50024031, '汽车音响安装维修', 3, 50023960, 3, ',26,50023950,50023960,50024031,', 0),
(50024032, '中控锁安装维修', 4, 50023960, 3, ',26,50023950,50023960,50024032,', 0),
(50024033, '自动关窗器安装维修', 5, 50023960, 3, ',26,50023950,50023960,50024033,', 0),
(50024034, '一键启动安装维修', 6, 50023960, 3, ',26,50023950,50023960,50024034,', 0),
(50024035, '其它电子产品安装维修', 7, 50023960, 3, ',26,50023950,50023960,50024035,', 0),
(50024000, '漆面贴膜', 0, 50023985, 3, ',26,50023950,50023985,50024000,', 0),
(50024001, '洗车服务', 1, 50023985, 3, ',26,50023950,50023985,50024001,', 0),
(50024002, '封釉镀膜服务', 2, 50023985, 3, ',26,50023950,50023985,50024002,', 0),
(50024003, '抛光服务', 3, 50023985, 3, ',26,50023950,50023985,50024003,', 0),
(50024004, '打蜡服务', 4, 50023985, 3, ',26,50023950,50023985,50024004,', 0),
(50024005, '其它汽车美容服务', 5, 50023985, 3, ',26,50023950,50023985,50024005,', 0),
(50024066, '汽油动力船', 0, 50024061, 3, ',25,50024060,50024061,50024066,', 0),
(50024067, '甲醇动力船', 1, 50024061, 3, ',25,50024060,50024061,50024067,', 0),
(50024068, '有刷电动船模', 2, 50024061, 3, ',25,50024060,50024061,50024068,', 0),
(50024069, '无刷电动船', 3, 50024061, 3, ',25,50024060,50024061,50024069,', 0),
(50024070, '游艇', 4, 50024061, 3, ',25,50024060,50024061,50024070,', 0),
(50024072, '其他动力船模', 6, 50024061, 3, ',25,50024060,50024061,50024072,', 0),
(140915, '数码伴侣', 5, 50024115, 3, ',50008090,50024097,50024115,140915,', 0),
(50006827, '广角镜', 9, 50024115, 3, ',50008090,50024097,50024115,50006827,', 0),
(140908, '其他周边配件', 10, 50024115, 3, ',50008090,50024097,50024115,140908,', 0),
(50003482, '测光表', 13, 50024115, 3, ',50008090,50024097,50024115,50003482,', 0),
(50009079, '专业摄影背心', 15, 50024115, 3, ',50008090,50024097,50024115,50009079,', 0),
(50008682, '数码望远镜', 18, 50024115, 3, ',50008090,50024097,50024115,50008682,', 0),
(50006263, '说明书/使用指南', 77, 50024115, 3, ',50008090,50024097,50024115,50006263,', 0),
(50009798, '显示器/打印机色彩校正仪', 80, 50024115, 3, ',50008090,50024097,50024115,50009798,', 0),
(50050617, '夜视仪', 83, 50024115, 3, ',50008090,50024097,50024115,50050617,', 0),
(50050618, '测距仪', 84, 50024115, 3, ',50008090,50024097,50024115,50050618,', 0),
(50024140, '板卡配件', 1, 50024138, 3, ',50008090,50024099,50024138,50024140,', 0),
(50024141, '机箱配件', 2, 50024138, 3, ',50008090,50024099,50024138,50024141,', 0),
(50024142, '液晶/CRT配件', 3, 50024138, 3, ',50008090,50024099,50024138,50024142,', 0),
(50024143, '外设配件', 4, 50024138, 3, ',50008090,50024099,50024138,50024143,', 0),
(50024144, 'SCSI设备', 5, 50024138, 3, ',50008090,50024099,50024138,50024144,', 0),
(50024145, 'SCSI卡', 6, 50024138, 3, ',50008090,50024099,50024138,50024145,', 0),
(50024146, '其它电脑元件/零配件', 7, 50024138, 3, ',50008090,50024099,50024138,50024146,', 0),
(50024577, '床安装服务套餐', 0, 50024446, 3, ',50025111,50050464,50024446,50024577,', 0),
(50024578, '柜体安装服务套餐', 1, 50024446, 3, ',50025111,50050464,50024446,50024578,', 0),
(50024579, '桌台几类安装服务套餐', 2, 50024446, 3, ',50025111,50050464,50024446,50024579,', 0),
(50024580, '沙发安装服务套餐', 3, 50024446, 3, ',50025111,50050464,50024446,50024580,', 0),
(50024581, '椅子安装服务套餐', 4, 50024446, 3, ',50025111,50050464,50024446,50024581,', 0),
(50024582, '橱柜安装服务套餐', 5, 50024446, 3, ',50025111,50050464,50024446,50024582,', 0),
(50024583, '其他家具安装服务套餐', 6, 50024446, 3, ',50025111,50050464,50024446,50024583,', 0),
(50024584, '浴室柜安装服务套餐', 7, 50024446, 3, ',50025111,50050464,50024446,50024584,', 0),
(50024585, '坐便器安装服务套餐', 8, 50024446, 3, ',50025111,50050464,50024446,50024585,', 0),
(50024586, '浴缸安装服务套餐', 9, 50024446, 3, ',50025111,50050464,50024446,50024586,', 0),
(50024587, '面盆安装服务套餐', 10, 50024446, 3, ',50025111,50050464,50024446,50024587,', 0),
(50024588, '龙头安装服务套餐', 11, 50024446, 3, ',50025111,50050464,50024446,50024588,', 0),
(50024589, '淋浴房安装服务套餐', 12, 50024446, 3, ',50025111,50050464,50024446,50024589,', 0),
(50024591, '空调安装服务套餐', 14, 50024446, 3, ',50025111,50050464,50024446,50024591,', 0),
(50024592, '热水器安装服务套餐', 15, 50024446, 3, ',50025111,50050464,50024446,50024592,', 0),
(50024594, '窗帘轨道安装服务套餐', 17, 50024446, 3, ',50025111,50050464,50024446,50024594,', 0),
(50024595, '墙纸铺贴服务套餐', 18, 50024446, 3, ',50025111,50050464,50024446,50024595,', 0),
(50024596, '地板安装服务套餐', 19, 50024446, 3, ',50025111,50050464,50024446,50024596,', 0),
(50024597, '地暖安装服务套餐', 20, 50024446, 3, ',50025111,50050464,50024446,50024597,', 0),
(50024598, '成品门/移门安装服务套餐', 21, 50024446, 3, ',50025111,50050464,50024446,50024598,', 0),
(50024599, '集成吊顶安装服务套餐', 22, 50024446, 3, ',50025111,50050464,50024446,50024599,', 0),
(50050526, '卫浴配件安装服务套餐', 24, 50024446, 3, ',50025111,50050464,50024446,50050526,', 0),
(50050527, '厨房设施安装服务套餐', 25, 50024446, 3, ',50025111,50050464,50024446,50050527,', 0),
(50050528, '其他家居安装服务套餐', 26, 50024446, 3, ',50025111,50050464,50024446,50050528,', 0),
(50050529, '三角阀安装服务套餐', 27, 50024446, 3, ',50025111,50050464,50024446,50050529,', 0),
(50050530, '成品楼梯安装服务套餐', 28, 50024446, 3, ',50025111,50050464,50024446,50050530,', 0),
(50050531, '浴室镜安装服务套餐', 29, 50024446, 3, ',50025111,50050464,50024446,50050531,', 0),
(50050532, '浴室镜柜安装服务套餐', 30, 50024446, 3, ',50025111,50050464,50024446,50050532,', 0),
(50050533, '蹲便器安装服务套餐', 31, 50024446, 3, ',50025111,50050464,50024446,50050533,', 0),
(50050534, '视听设备安装服务套餐', 32, 50024446, 3, ',50025111,50050464,50024446,50050534,', 0),
(50050535, '淋浴拉门安装服务套餐', 33, 50024446, 3, ',50025111,50050464,50024446,50050535,', 0),
(50050536, '小便斗安装服务套餐', 34, 50024446, 3, ',50025111,50050464,50024446,50050536,', 0),
(50050537, '淋浴龙头安装服务套餐', 35, 50024446, 3, ',50025111,50050464,50024446,50050537,', 0),
(50024600, '安防报警安装服务套餐', 36, 50024446, 3, ',50025111,50050464,50024446,50024600,', 0),
(50050567, '灯具安装服务套餐', 37, 50024446, 3, ',50025111,50050464,50024446,50050567,', 0),
(50011884, '轮椅/拐仗/助便配件', 0, 50024633, 3, ',50002768,50011877,50024633,50011884,', 0),
(50022661, '温灸器配件', 0, 50024634, 3, ',50002768,50011877,50024634,50022661,', 0),
(50023391, '蜡疗机/手蜡机配件', 0, 50024645, 3, ',50002768,50011877,50024645,50023391,', 0),
(50011941, '背背佳/矫姿带配件', 9, 50024645, 3, ',50002768,50011877,50024645,50011941,', 0),
(50011885, '其它美体瘦身配件', 11, 50024645, 3, ',50002768,50011877,50024645,50011885,', 0),
(50011881, '其它清洁美容配件', 0, 50024654, 3, ',50002768,50011877,50024654,50011881,', 0),
(50011878, '剃须刀配件', 1, 50024654, 3, ',50002768,50011877,50024654,50011878,', 0),
(50011882, '电吹风配件', 0, 50024655, 3, ',50002768,50011877,50024655,50011882,', 0),
(50011887, '卷/直发器配件', 3, 50024655, 3, ',50002768,50011877,50024655,50011887,', 0),
(150803, '其它美发工具配件', 4, 50024655, 3, ',50002768,50011877,50024655,150803,', 0),
(50024630, '理发器配件', 4, 50024655, 3, ',50002768,50011877,50024655,50024630,', 0),
(50012826, '其它家用保健器材配件', 0, 50024656, 3, ',50002768,50011877,50024656,50012826,', 0),
(50011879, '桑拿浴箱配件', 10, 50024656, 3, ',50002768,50011877,50024656,50011879,', 0),
(50011938, '足浴器配件', 20, 50024656, 3, ',50002768,50011877,50024656,50011938,', 0),
(50024676, '阅读台灯(护眼灯/写字灯)', 0, 50024675, 3, ',27,50019935,50024675,50024676,', 0),
(50020104, '装饰台灯', 3, 50024675, 3, ',27,50019935,50024675,50020104,', 0),
(50019937, '端景台灯饰', 0, 50024677, 3, ',27,50019935,50024677,50019937,', 0),
(50020107, '景观庭院灯饰', 16, 50024677, 3, ',27,50019935,50024677,50020107,', 0),
(50024810, '其它室外灯具灯饰', 17, 50024677, 3, ',27,50019935,50024677,50024810,', 0),
(50024686, '紧凑型节能荧光灯', 0, 50024682, 3, ',27,50013217,50024682,50024686,', 0),
(50024687, '直管荧光灯', 1, 50024682, 3, ',27,50013217,50024682,50024687,', 0),
(50022652, 'LED单灯', 0, 50024683, 3, ',27,50013217,50024683,50022652,', 0),
(50024684, 'LED灯带', 0, 50024683, 3, ',27,50013217,50024683,50024684,', 0),
(50024685, 'LED灯管', 1, 50024683, 3, ',27,50013217,50024683,50024685,', 0),
(350505, '热水瓶', 0, 50024782, 3, ',50016349,50006885,50024782,350505,', 0),
(50006859, '锅盖架', 0, 50024796, 3, ',50016349,50008281,50024796,50006859,', 0),
(50006858, '厨房置物架/角架', 1, 50024796, 3, ',50016349,50008281,50024796,50006858,', 0),
(50024807, '厨房墙壁置物架/厨房墙壁挂架', 2, 50024796, 3, ',50016349,50008281,50024796,50024807,', 0),
(50022407, '刀架', 33, 50024796, 3, ',50016349,50008281,50024796,50022407,', 0),
(50024849, '聚酯漆（家用木材漆）', 0, 50024843, 3, ',27,50013222,50024843,50024849,', 0),
(50022308, '硝基漆', 7, 50024843, 3, ',27,50013222,50024843,50022308,', 0),
(50024850, '树脂漆（金属漆）', 0, 50024844, 3, ',27,50013222,50024844,50024850,', 0),
(50024917, '酚醛漆', 1, 50024844, 3, ',27,50013222,50024844,50024917,', 0),
(50022303, '醇酸漆', 2, 50024844, 3, ',27,50013222,50024844,50022303,', 0),
(50022306, '环氧漆(地坪漆)', 5, 50024844, 3, ',27,50013222,50024844,50022306,', 0),
(50022307, '聚氨酯漆', 6, 50024844, 3, ',27,50013222,50024844,50022307,', 0),
(50024856, '内墙白色哑光乳胶漆', 0, 50024853, 3, ',27,50024852,50024853,50024856,', 0),
(50024857, '调色专用基漆', 1, 50024853, 3, ',27,50024852,50024853,50024857,', 0),
(50024858, '防水涂料', 0, 50024854, 3, ',27,50024852,50024854,50024858,', 0),
(50024859, '防腐涂料', 1, 50024854, 3, ',27,50024852,50024854,50024859,', 0),
(50024860, '防火涂料', 2, 50024854, 3, ',27,50024852,50024854,50024860,', 0),
(50024861, '特种涂料', 3, 50024854, 3, ',27,50024852,50024854,50024861,', 0),
(50022665, '抽纸袋', 0, 50024951, 3, ',50008163,50017143,50024951,50022665,', 0),
(50022666, '相机包', 1, 50024951, 3, ',50008163,50017143,50024951,50022666,', 0),
(50022667, '移动硬盘袋', 2, 50024951, 3, ',50008163,50017143,50024951,50022667,', 0),
(50022668, '收纳盒', 3, 50024951, 3, ',50008163,50017143,50024951,50022668,', 0),
(50022669, '杯垫', 4, 50024951, 3, ',50008163,50017143,50024951,50022669,', 0),
(50022670, '便当袋', 5, 50024951, 3, ',50008163,50017143,50024951,50022670,', 0),
(50022671, '笔筒', 6, 50024951, 3, ',50008163,50017143,50024951,50022671,', 0),
(50022672, '餐具整理袋', 7, 50024951, 3, ',50008163,50017143,50024951,50022672,', 0),
(50022673, '拼布彩色时钟', 8, 50024951, 3, ',50008163,50017143,50024951,50022673,', 0),
(50022700, '其他小布艺', 9, 50024951, 3, ',50008163,50017143,50024951,50022700,', 0),
(50017237, '其它DIY成品', 32, 50024951, 3, ',50008163,50017143,50024951,50017237,', 0),
(50022567, '其他布艺饰品', 33, 50024951, 3, ',50008163,50017143,50024951,50022567,', 0),
(50025027, '碗筷套装定制', 0, 50025026, 3, ',50025004,50025007,50025026,50025027,', 0),
(50025028, '杯盖定制', 1, 50025026, 3, ',50025004,50025007,50025026,50025028,', 0),
(50025029, '勺子定制', 2, 50025026, 3, ',50025004,50025007,50025026,50025029,', 0),
(50025030, '其它餐具定制', 3, 50025026, 3, ',50025004,50025007,50025026,50025030,', 0),
(50025033, 'iphone壳/保护套定制', 0, 50025032, 3, ',50025004,50025008,50025032,50025033,', 0),
(50025034, 'ipad壳/保护套定制', 1, 50025032, 3, ',50025004,50025008,50025032,50025034,', 0),
(50025035, 'ipod壳/保护套定制', 2, 50025032, 3, ',50025004,50025008,50025032,50025035,', 0),
(50025036, '其它手机壳/保护套定制', 3, 50025032, 3, ',50025004,50025008,50025032,50025036,', 0),
(50025037, '其它电脑外壳/保护套定制', 4, 50025032, 3, ',50025004,50025008,50025032,50025037,', 0),
(50025038, '其它播放器外壳/保护套定制', 5, 50025032, 3, ',50025004,50025008,50025032,50025038,', 0),
(50025044, '手绘包', 0, 50025040, 3, ',50025004,50025009,50025040,50025044,', 0),
(50025045, '其它包类', 1, 50025040, 3, ',50025004,50025009,50025040,50025045,', 0),
(50025046, '卡套/卡包/钱包', 2, 50025040, 3, ',50025004,50025009,50025040,50025046,', 0),
(50015086, '手绘包/包包定制', 9, 50025040, 3, ',50025004,50025009,50025040,50015086,', 0),
(50019777, '包包定制', 43, 50025040, 3, ',50025004,50025009,50025040,50019777,', 0),
(50025047, '针织鞋', 0, 50025041, 3, ',50025004,50025009,50025041,50025047,', 0),
(50025048, '其它鞋类', 1, 50025041, 3, ',50025004,50025009,50025041,50025048,', 0),
(50015085, '手绘鞋', 8, 50025041, 3, ',50025004,50025009,50025041,50015085,', 0),
(50025049, '鸭舌帽', 0, 50025042, 3, ',50025004,50025009,50025042,50025049,', 0),
(50025050, '针织帽', 1, 50025042, 3, ',50025004,50025009,50025042,50025050,', 0),
(50018628, '手绘帽', 11, 50025042, 3, ',50025004,50025009,50025042,50018628,', 0),
(50018430, '其它帽子定做', 13, 50025042, 3, ',50025004,50025009,50025042,50018430,', 0),
(50015276, '礼服定制', 0, 50025043, 3, ',50025004,50025009,50025043,50015276,', 0),
(50015277, '旗袍定制', 1, 50025043, 3, ',50025004,50025009,50025043,50015277,', 0),
(50015278, '婚纱礼服', 2, 50025043, 3, ',50025004,50025009,50025043,50015278,', 0),
(50015279, '动漫服装/cosplay制服', 3, 50025043, 3, ',50025004,50025009,50025043,50015279,', 0),
(50015280, '舞台演出/舞蹈服装定制', 4, 50025043, 3, ',50025004,50025009,50025043,50015280,', 0),
(50015282, '针织类定制', 6, 50025043, 3, ',50025004,50025009,50025043,50015282,', 0),
(50015283, '民族服装定制', 7, 50025043, 3, ',50025004,50025009,50025043,50015283,', 0),
(50015087, '手绘T恤', 10, 50025043, 3, ',50025004,50025009,50025043,50015087,', 0),
(50015112, 'T恤印制', 12, 50025043, 3, ',50025004,50025009,50025043,50015112,', 0),
(50020237, 'POLO衫', 14, 50025043, 3, ',50025004,50025009,50025043,50020237,', 0),
(50015281, '工作服/校服/商务服定制', 15, 50025043, 3, ',50025004,50025009,50025043,50015281,', 0),
(50020245, '汉服定制', 16, 50025043, 3, ',50025004,50025009,50025043,50020245,', 0),
(50020246, '卫衣定制', 17, 50025043, 3, ',50025004,50025009,50025043,50020246,', 0),
(50025052, '皮带扣', 0, 50025051, 3, ',50025004,50025009,50025051,50025052,', 0),
(50025053, '其它配饰定制', 1, 50025051, 3, ',50025004,50025009,50025051,50025053,', 0),
(50003690, '取名', 0, 50025120, 3, ',50025111,50050489,50025120,50003690,', 0),
(50025121, '运势/易学', 4, 50025120, 3, ',50025111,50050489,50025120,50025121,', 0),
(50026209, '解梦', 5, 50025120, 3, ',50025111,50050489,50025120,50026209,', 0),
(50026311, '其他服务', 6, 50025120, 3, ',50025111,50050489,50025120,50026311,', 0),
(50026271, '小件/个人搬家', 0, 50025122, 3, ',50025111,50050489,50025122,50026271,', 0),
(50005236, '居家搬家', 0, 50025122, 3, ',50025111,50050489,50025122,50005236,', 0),
(50025123, '企业搬家', 1, 50025122, 3, ',50025111,50050489,50025122,50025123,', 0),
(50026272, '起重安装', 2, 50025122, 3, ',50025111,50050489,50025122,50026272,', 0),
(50026273, '钢琴搬运', 3, 50025122, 3, ',50025111,50050489,50025122,50026273,', 0),
(50026274, '空调家具拆装', 4, 50025122, 3, ',50025111,50050489,50025122,50026274,', 0),
(50026275, '长途长运搬家', 5, 50025122, 3, ',50025111,50050489,50025122,50026275,', 0),
(50019111, '加油卡', 49, 50025138, 3, ',50025111,50050489,50025138,50019111,', 0),
(50009833, '沙拉/千岛/蛋黄酱', 0, 50025222, 3, ',50016422,50009821,50025222,50009833,', 0),
(50009823, '酱类调料', 5, 50025222, 3, ',50016422,50009821,50025222,50009823,', 0),
(50009834, '鱼籽酱', 5, 50025222, 3, ',50016422,50009821,50025222,50009834,', 0),
(50017140, '虾酱', 9, 50025222, 3, ',50016422,50009821,50025222,50017140,', 0),
(50050640, '豆瓣酱', 10, 50025222, 3, ',50016422,50009821,50025222,50050640,', 0),
(50050641, '番茄酱', 11, 50025222, 3, ',50016422,50009821,50025222,50050641,', 0),
(50050642, '辣椒酱', 12, 50025222, 3, ',50016422,50009821,50025222,50050642,', 0),
(50025659, '古典舞服', 0, 50025658, 3, ',50010728,50016472,50025658,50025659,', 0),
(50025660, '古典舞配饰', 1, 50025658, 3, ',50010728,50016472,50025658,50025660,', 0),
(50025661, '古典舞鞋', 2, 50025658, 3, ',50010728,50016472,50025658,50025661,', 0),
(50009822, '火锅调料', 0, 50025674, 3, ',50016422,50009821,50025674,50009822,', 0),
(50009825, '其它调料', 4, 50025674, 3, ',50016422,50009821,50025674,50009825,', 0),
(50009829, '咖喱', 4, 50025674, 3, ',50016422,50009821,50025674,50009829,', 0),
(50009826, '烧烤调料', 4, 50025674, 3, ',50016422,50009821,50025674,50009826,', 0),
(50009880, '花椒/八角/桂皮', 4, 50025674, 3, ',50016422,50009821,50025674,50009880,', 0),
(50009827, '辣椒类调料', 4, 50025674, 3, ',50016422,50009821,50025674,50009827,', 0),
(50016792, '大闸蟹', 1, 50025690, 3, ',50050359,50050371,50025690,50016792,', 0),
(50016800, '蟹类制品', 9, 50025690, 3, ',50050359,50050371,50025690,50016800,', 0),
(50050708, '青蟹', 10, 50025690, 3, ',50050359,50050371,50025690,50050708,', 0),
(50050709, '蟹棒', 11, 50025690, 3, ',50050359,50050371,50025690,50050709,', 0),
(50050710, '帝王蟹', 12, 50025690, 3, ',50050359,50050371,50025690,50050710,', 0),
(50050711, '其它', 13, 50025690, 3, ',50050359,50050371,50025690,50050711,', 0),
(50019816, '酒店套餐', 0, 50025783, 3, ',50011949,50019784,50025783,50019816,', 0),
(50025784, '客栈套餐', 1, 50025783, 3, ',50011949,50019784,50025783,50025784,', 0),
(50025876, '餐饮(BBQ)', 0, 50025875, 3, ',50025707,50012910,50025875,50025876,', 0),
(50025878, '酒店SPA', 2, 50025875, 3, ',50025707,50012910,50025875,50025878,', 0),
(50025879, '酒店足浴', 3, 50025875, 3, ',50025707,50012910,50025875,50025879,', 0),
(50025880, '旅行拍照/婚纱摄影', 4, 50025875, 3, ',50025707,50012910,50025875,50025880,', 0),
(50025886, '潜水/岸潜/船潜', 5, 50025875, 3, ',50025707,50012910,50025875,50025886,', 0),
(50025887, '客栈鲜花布置/特色服务', 6, 50025875, 3, ',50025707,50012910,50025875,50025887,', 0),
(50025888, '机场取送及托运服务', 7, 50025875, 3, ',50025707,50012910,50025875,50025888,', 0),
(50002713, '压缩袋', 0, 50025902, 3, ',50016348,50018683,50025902,50002713,', 0),
(50012075, '购物袋/环保袋', 2, 50025902, 3, ',50016348,50018683,50025902,50012075,', 0),
(50012076, '饭盒袋', 4, 50025902, 3, ',50016348,50018683,50025902,50012076,', 0),
(50023171, '收纳挂袋', 34, 50025902, 3, ',50016348,50018683,50025902,50023171,', 0),
(50025912, '保温包', 35, 50025902, 3, ',50016348,50018683,50025902,50025912,', 0),
(50025937, '其他收纳袋', 37, 50025902, 3, ',50016348,50018683,50025902,50025937,', 0),
(50050345, '便当包', 38, 50025902, 3, ',50016348,50018683,50025902,50050345,', 0),
(50002817, '医药箱', 0, 50025903, 3, ',50016348,50018683,50025903,50002817,', 0),
(50002711, '收纳箱', 40, 50025903, 3, ',50016348,50018683,50025903,50002711,', 0),
(50001735, 'CD架', 0, 50025904, 3, ',50016348,50018683,50025904,50001735,', 0),
(50023167, '首饰架', 30, 50025904, 3, ',50016348,50018683,50025904,50023167,', 0),
(50025924, '纸巾架', 60, 50025904, 3, ',50016348,50018683,50025904,50025924,', 0),
(50025925, '红酒架', 61, 50025904, 3, ',50016348,50018683,50025904,50025925,', 0),
(50025926, '其他收纳架', 62, 50025904, 3, ',50016348,50018683,50025904,50025926,', 0),
(50005055, '脏衣篮', 0, 50025905, 3, ',50016348,50018683,50025905,50005055,', 0),
(50011177, '购物篮/提菜器', 1, 50025905, 3, ',50016348,50018683,50025905,50011177,', 0),
(50025938, '其他收纳篮', 2, 50025905, 3, ',50016348,50018683,50025905,50025938,', 0),
(50003447, '牙签筒', 0, 50025906, 3, ',50016348,50018683,50025906,50003447,', 0),
(50025939, '其他收纳罐', 1, 50025906, 3, ',50016348,50018683,50025906,50025939,', 0),
(50025956, '笔筒', 2, 50025906, 3, ',50016348,50018683,50025906,50025956,', 0),
(50025917, 'CD包', 0, 50025908, 3, ',50016348,50018683,50025908,50025917,', 0),
(50023169, '化妆包', 32, 50025908, 3, ',50016348,50018683,50025908,50023169,', 0),
(50025928, '卡包/证件包', 63, 50025908, 3, ',50016348,50018683,50025908,50025928,', 0),
(50025944, '卫生巾收纳包', 64, 50025908, 3, ',50016348,50018683,50025908,50025944,', 0),
(50025945, '其他收纳包', 65, 50025908, 3, ',50016348,50018683,50025908,50025945,', 0),
(50023183, '脏衣桶', 0, 50025909, 3, ',50016348,50018683,50025909,50023183,', 0),
(50025954, '其他收纳桶', 1, 50025909, 3, ',50016348,50018683,50025909,50025954,', 0),
(50023177, '鞋柜', 0, 50025911, 3, ',50016348,50018683,50025911,50023177,', 0),
(50025940, '收纳柜', 1, 50025911, 3, ',50016348,50018683,50025911,50025940,', 0),
(50025941, '衣物收纳柜/简易衣橱', 2, 50025911, 3, ',50016348,50018683,50025911,50025941,', 0),
(50025914, '药盒', 0, 50025915, 3, ',50016348,50018683,50025915,50025914,', 0),
(50025916, 'CD盒', 59, 50025915, 3, ',50016348,50018683,50025915,50025916,', 0),
(50025918, '纸巾盒', 60, 50025915, 3, ',50016348,50018683,50025915,50025918,', 0),
(50025919, '首饰盒', 61, 50025915, 3, ',50016348,50018683,50025915,50025919,', 0),
(50025920, '牙签盒', 62, 50025915, 3, ',50016348,50018683,50025915,50025920,', 0),
(50025921, '文具收纳盒', 63, 50025915, 3, ',50016348,50018683,50025915,50025921,', 0),
(50025922, '桌面收纳盒', 64, 50025915, 3, ',50016348,50018683,50025915,50025922,', 0),
(50025923, '其他收纳盒', 65, 50025915, 3, ',50016348,50018683,50025915,50025923,', 0),
(50025942, '食物收纳盒', 66, 50025915, 3, ',50016348,50018683,50025915,50025942,', 0),
(50025943, '内衣收纳盒', 67, 50025915, 3, ',50016348,50018683,50025915,50025943,', 0),
(50023166, '卡套', 0, 50025936, 3, ',50016348,50018683,50025936,50023166,', 0),
(50001691, '纸巾套', 12, 50025936, 3, ',50016348,50018683,50025936,50001691,', 0),
(50026267, '病人看护', 0, 50026266, 3, ',50025111,50025125,50026266,50026267,', 0),
(50026268, '老人看护', 1, 50026266, 3, ',50025111,50025125,50026266,50026268,', 0),
(50026699, '儿童全托/接送', 4, 50026266, 3, ',50025111,50025125,50026266,50026699,', 0),
(50026290, '全程跟拍', 0, 50026282, 3, ',50025111,50025132,50026282,50026290,', 0),
(50026291, '仪式拍摄', 1, 50026282, 3, ',50025111,50025132,50026282,50026291,', 0),
(50050504, '领证跟拍', 2, 50026282, 3, ',50025111,50025132,50026282,50050504,', 0),
(50026296, '加长车', 0, 50026295, 3, ',50025111,50025132,50026295,50026296,', 0),
(50026297, '豪华车', 1, 50026295, 3, ',50025111,50025132,50026295,50026297,', 0),
(50026298, '轿子', 2, 50026295, 3, ',50025111,50025132,50026295,50026298,', 0),
(50026299, '飞机', 3, 50026295, 3, ',50025111,50025132,50026295,50026299,', 0),
(50026300, '普通车', 4, 50026295, 3, ',50025111,50025132,50026295,50026300,', 0),
(50026301, '游艇', 5, 50026295, 3, ',50025111,50025132,50026295,50026301,', 0),
(50026302, '敞篷车', 6, 50026295, 3, ',50025111,50025132,50026295,50026302,', 0),
(50026303, '热气球', 7, 50026295, 3, ',50025111,50025132,50026295,50026303,', 0),
(50026304, '马车', 8, 50026295, 3, ',50025111,50025132,50026295,50026304,', 0),
(50026315, '其他车型', 9, 50026295, 3, ',50025111,50025132,50026295,50026315,', 0),
(50026309, '场地布置', 0, 50026308, 3, ',50025111,50025132,50026308,50026309,', 0),
(50026310, '婚车装饰', 1, 50026308, 3, ',50025111,50025132,50026308,50026310,', 0),
(50003862, '七子饼茶', 0, 50026408, 3, ',50026316,50026397,50026408,50003862,', 0),
(50016317, '沱茶', 1, 50026408, 3, ',50026316,50026397,50026408,50016317,', 0),
(50016318, '砖茶', 2, 50026408, 3, ',50026316,50026397,50026408,50016318,', 0),
(50016319, '迷你小沱茶', 3, 50026408, 3, ',50026316,50026397,50026408,50016319,', 0),
(50016320, '瓜茶', 4, 50026408, 3, ',50026316,50026397,50026408,50016320,', 0),
(50016321, '散茶', 5, 50026408, 3, ',50026316,50026397,50026408,50016321,', 0),
(50016322, '工艺/礼品茶', 6, 50026408, 3, ',50026316,50026397,50026408,50016322,', 0),
(50025124, '企业保洁', 0, 50026420, 3, ',50025111,50025125,50026420,50025124,', 0),
(50026700, '专业皮革养护', 3, 50026420, 3, ',50025111,50025125,50026420,50026700,', 0),
(50023924, '家具维修保养', 4, 50026420, 3, ',50025111,50025125,50026420,50023924,', 0),
(50023928, '家庭保洁服务', 5, 50026420, 3, ',50025111,50025125,50026420,50023928,', 0),
(50026537, '健康测评', 0, 50026536, 3, ',50025111,50026535,50026536,50026537,', 0),
(50026538, '其他', 1, 50026536, 3, ',50025111,50026535,50026536,50026538,', 0),
(50026539, '化验解读', 2, 50026536, 3, ',50025111,50026535,50026536,50026539,', 0),
(50026541, '网上挂号', 0, 50026540, 3, ',50025111,50026535,50026540,50026541,', 0),
(50026542, '预约医院', 1, 50026540, 3, ',50025111,50026535,50026540,50026542,', 0),
(50026545, '其他', 0, 50026544, 3, ',50025111,50026535,50026544,50026545,', 0),
(50026546, '整形美容', 1, 50026544, 3, ',50025111,50026535,50026544,50026546,', 0),
(50026547, '口腔护理/治疗', 2, 50026544, 3, ',50025111,50026535,50026544,50026547,', 0),
(50026548, '中医养生', 3, 50026544, 3, ',50025111,50026535,50026544,50026548,', 0),
(50026604, '眼部护理', 4, 50026544, 3, ',50025111,50026535,50026544,50026604,', 0),
(50026632, '职业资格认证教程/教材/资料', 0, 50026608, 3, ',50025111,50014927,50026608,50026632,', 0),
(50026633, '外语教程/教材/资料', 1, 50026608, 3, ',50025111,50014927,50026608,50026633,', 0),
(50026634, '建筑地产教程/教材/资料', 2, 50026608, 3, ',50025111,50014927,50026608,50026634,', 0),
(50026635, '财会教程/教材/资料', 3, 50026608, 3, ',50025111,50014927,50026608,50026635,', 0),
(50026636, '电脑IT教程/教材/资料', 4, 50026608, 3, ',50025111,50014927,50026608,50026636,', 0),
(50026637, '中小学教程/教材/资料', 5, 50026608, 3, ',50025111,50014927,50026608,50026637,', 0),
(50026638, '公务员教程/教材/资料', 6, 50026608, 3, ',50025111,50014927,50026608,50026638,', 0),
(50026639, '学历考试教程/教材/资料', 7, 50026608, 3, ',50025111,50014927,50026608,50026639,', 0),
(50026640, '考研教程/教材/资料', 8, 50026608, 3, ',50025111,50014927,50026608,50026640,', 0),
(50026641, '婴幼儿教程/教材/资料', 9, 50026608, 3, ',50025111,50014927,50026608,50026641,', 0),
(50026642, '银行教程/教材/资料', 10, 50026608, 3, ',50025111,50014927,50026608,50026642,', 0),
(50026643, '管理教程/教材/资料', 11, 50026608, 3, ',50025111,50014927,50026608,50026643,', 0),
(50026644, '其他教程/教材/资料', 12, 50026608, 3, ',50025111,50014927,50026608,50026644,', 0),
(50050462, '职业技能教程/教材/资料', 13, 50026608, 3, ',50025111,50014927,50026608,50050462,', 0),
(50050463, '经济贸易教程/教材/资料', 14, 50026608, 3, ',50025111,50014927,50026608,50050463,', 0),
(50015043, '专业技能培训', 0, 50026625, 3, ',50025111,50014927,50026625,50015043,', 0),
(50026361, '婴幼儿教育', 1, 50026625, 3, ',50025111,50014927,50026625,50026361,', 0),
(50026363, '少儿培训', 2, 50026625, 3, ',50025111,50014927,50026625,50026363,', 0),
(50008155, '中小学教育', 3, 50026625, 3, ',50025111,50014927,50026625,50008155,', 0),
(50018878, '学历教育培训', 4, 50026625, 3, ',50025111,50014927,50026625,50018878,', 0),
(50015039, '拓展培训', 6, 50026625, 3, ',50025111,50014927,50026625,50015039,', 0),
(50015041, '语言培训', 7, 50026625, 3, ',50025111,50014927,50026625,50015041,', 0),
(50015029, '管理培训', 8, 50026625, 3, ',50025111,50014927,50026625,50015029,', 0),
(50018877, '电脑IT培训', 9, 50026625, 3, ',50025111,50014927,50026625,50018877,', 0),
(50015047, '职业资格认证培训', 10, 50026625, 3, ',50025111,50014927,50026625,50015047,', 0),
(50026314, '驾驶培训', 11, 50026625, 3, ',50025111,50014927,50026625,50026314,', 0),
(50017232, '淘宝大学培训课程', 12, 50026625, 3, ',50025111,50014927,50026625,50017232,', 0),
(50026365, '财务/会计培训', 12, 50026625, 3, ',50025111,50014927,50026625,50026365,', 0),
(50026366, '建筑地产类培训', 13, 50026625, 3, ',50025111,50014927,50026625,50026366,', 0),
(50018875, '考研培训', 13, 50026625, 3, ',50025111,50014927,50026625,50018875,', 0),
(50018876, '公务员培训', 14, 50026625, 3, ',50025111,50014927,50026625,50018876,', 0),
(50018879, '文艺体育培训', 17, 50026625, 3, ',50025111,50014927,50026625,50018879,', 0),
(50025143, '其他培训', 18, 50026625, 3, ',50025111,50014927,50026625,50025143,', 0),
(50050459, '银行/证券培训', 19, 50026625, 3, ',50025111,50014927,50026625,50050459,', 0),
(50050460, '经济贸易培训', 20, 50026625, 3, ',50025111,50014927,50026625,50050460,', 0),
(50050461, '线下家教', 21, 50026625, 3, ',50025111,50014927,50026625,50050461,', 0),
(50026191, '短信', 0, 50026187, 3, ',50025111,50050489,50026187,50026191,', 0),
(50026192, '藏头诗', 1, 50026187, 3, ',50025111,50050489,50026187,50026192,', 0),
(50026193, '彩信', 2, 50026187, 3, ',50025111,50050489,50026187,50026193,', 0),
(50026395, '普通保姆', 8, 50026248, 3, ',50025111,50025125,50026248,50026395,', 0),
(50026422, '涉外保姆', 9, 50026248, 3, ',50025111,50025125,50026248,50026422,', 0),
(50026258, '月嫂', 0, 50026257, 3, ',50025111,50025125,50026257,50026258,', 0),
(50026259, '育婴师', 1, 50026257, 3, ',50025111,50025125,50026257,50026259,', 0),
(50026260, '催乳师', 2, 50026257, 3, ',50025111,50025125,50026257,50026260,', 0),
(50026261, '专业营养师', 3, 50026257, 3, ',50025111,50025125,50026257,50026261,', 0),
(50026433, '婴童馆服务', 3, 50026257, 3, ',50025111,50025125,50026257,50026433,', 0);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_link`
--

DROP TABLE IF EXISTS `{dbprefix}shop_link`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_link` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `cid` tinyint(1) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `hplink` varchar(500) default NULL,
  `pic_path` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=6 ;

--
-- 转存表中的数据 `{dbprefix}shop_link`
--

INSERT INTO `{dbprefix}shop_link` (`id`, `cid`, `title`, `hplink`, `pic_path`, `seqorder`) VALUES
(2, 1, '天夏网络', 'http://www.tianxianet.com/', '', 0),
(3, 1, '天夏网络淘宝店', 'http://tianxianet.taobao.com/', '', 0),
(4, 1, '天夏购物', 'http://taoshop168.com/', '', 0),
(5, 1, '天夏返利', 'http://5yfan.com', '', 0);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_menu`
--

DROP TABLE IF EXISTS `{dbprefix}shop_menu`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_menu` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `cat_name` varchar(255) default NULL,
  `parent_id` smallint(5) unsigned NOT NULL default '0',
  `hplink` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `is_trash` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=94 ;

--
-- 转存表中的数据 `{dbprefix}shop_menu`
--

INSERT INTO `{dbprefix}shop_menu` (`id`, `cat_name`, `parent_id`, `hplink`, `seqorder`, `is_trash`) VALUES
(1, '网站设置', 0, '#', 0, 0),
(3, '文章管理', 0, '#', 1, 0),
(9, '网站配置', 1, 'site_config', 0, 0),
(13, '友情链接', 1, 'link', 8, 0),
(14, '广告管理', 1, 'ads', 3, 0),
(84, '文章采集', 3, 'rule', 0, 0),
(16, '管理员设置', 79, 'admin', 3, 0),
(22, '分类管理', 3, 'news_catalog', 5, 0),
(23, '文章管理', 3, 'news', 5, 0),
(85, '板块管理', 0, '#', 1, 0),
(32, '数据库备份', 79, 'mysql_manage', 2, 0),
(35, '文件管理', 79, 'file_manage', 1, 0),
(41, '服务器环境检测', 79, 'help/echo_phpinfo', 5, 0),
(91, '授权管理', 1, 'author_code', 1, 0),
(55, '添加文章', 3, 'news/add_record_view', 5, 0),
(60, '顶部导航', 85, 'top_nav', 0, 0),
(71, '首页商品', 85, 'index_block', 2, 0),
(93, '首页文章', 85, 'news_index', 3, 0),
(90, '焦点图', 1, 'flash', 2, 0),
(92, '顽兔采集', 3, 'rule_wt', 0, 0),
(79, '其他杂项', 0, '#', 3, 0),
(77, '静态生成', 3, 'make_html', 0, 0),
(78, '行业类目', 1, 'industry_catalog', 9, 0);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_news`
--

DROP TABLE IF EXISTS `{dbprefix}shop_news`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_news` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `title` varchar(500) default NULL,
  `is_trash` tinyint(1) unsigned NOT NULL default '0',
  `is_push` tinyint(1) unsigned NOT NULL default '0',
  `catalog_id` varchar(100) default NULL,
  `keyword` varchar(500) default NULL,
  `description` text NOT NULL,
  `author` varchar(50) default NULL,
  `source` varchar(50) default NULL,
  `summary` text,
  `content` longtext,
  `pic_path` varchar(255) default NULL,
  `is_create` tinyint(1) unsigned NOT NULL default '0',
  `hits` int(10) unsigned NOT NULL default '0',
  `tpl` tinyint(1) unsigned NOT NULL default '0',
  `seqorder` int(10) unsigned NOT NULL default '0',
  `create_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `is_push` (`is_push`),
  KEY `is_trash` (`is_trash`),
  KEY `catalog_id` (`catalog_id`),
  KEY `title` (`title`(333)),
  KEY `is_create` (`is_create`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `{dbprefix}shop_news`
--


-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_news_catalog`
--

DROP TABLE IF EXISTS `{dbprefix}shop_news_catalog`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_news_catalog` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `cid` bigint(20) NOT NULL default '0',
  `q` varchar(30) default NULL,
  `cat_name` varchar(255) default NULL,
  `pic_path` varchar(255) default NULL,
  `seqorder` int(10) unsigned NOT NULL default '0',
  `parent_id` int(10) unsigned NOT NULL default '0',
  `deep_id` tinyint(2) unsigned NOT NULL default '0',
  `queue` varchar(255) NOT NULL default '0',
  `is_has_chd` tinyint(1) unsigned NOT NULL default '0',
  `tpl` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `is_has_chd` (`is_has_chd`),
  KEY `parent_id` (`parent_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=32 ;

--
-- 转存表中的数据 `{dbprefix}shop_news_catalog`
--

INSERT INTO `{dbprefix}shop_news_catalog` (`id`, `cid`, `q`, `cat_name`, `pic_path`, `seqorder`, `parent_id`, `deep_id`, `queue`, `is_has_chd`, `tpl`) VALUES
(1, 0, '服饰', '服饰', NULL, 0, 0, 0, ',1,', 1, 2),
(31, 1625, '', '美女帅哥', NULL, 0, 0, 0, ',31,', 0, 2),
(30, 0, '明星', '明星', NULL, 0, 0, 0, ',30,', 0, 2),
(6, 0, '卫衣', '卫衣', NULL, 0, 1, 1, ',1,6,', 0, 2),
(7, 0, '风衣', '风衣', NULL, 0, 1, 1, ',1,7,', 0, 2),
(8, 162103, '', '毛衣', NULL, 0, 1, 1, ',1,8,', 0, 2),
(9, 0, '外套', '外套', NULL, 0, 1, 1, ',1,9,', 0, 2),
(10, 0, '西装', '西装', NULL, 0, 1, 1, ',1,10,', 0, 2),
(11, 50010850, '', '连衣裙', NULL, 0, 1, 1, ',1,11,', 0, 2),
(12, 0, '短裙', '短裙', NULL, 0, 1, 1, ',1,12,', 0, 2),
(13, 0, '长裙', '长裙', NULL, 0, 1, 1, ',1,13,', 0, 2),
(14, 0, '情侣装', '情侣装', NULL, 0, 1, 1, ',1,14,', 0, 2),
(15, 0, '冬装', '冬装', NULL, 0, 1, 1, ',1,15,', 0, 2),
(16, 0, '秋装', '秋装', NULL, 0, 1, 1, ',1,16,', 0, 2),
(29, 0, '潮流', '潮流趋势', NULL, 0, 0, 0, ',29,', 0, 1),
(27, 0, '裤子', '裤子', NULL, 0, 1, 1, ',1,27,', 0, 2),
(28, 0, '哈伦裤', '哈伦裤', NULL, 0, 1, 1, ',1,28,', 0, 2),
(26, 162104, '', '时尚资讯', NULL, 0, 0, 0, ',26,', 0, 1);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_news_goods`
--

DROP TABLE IF EXISTS `{dbprefix}shop_news_goods`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_news_goods` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `title` varchar(255) default NULL,
  `num_iid` bigint(20) unsigned NOT NULL default '0',
  `nid` bigint(20) unsigned NOT NULL default '0',
  `pic_url` varchar(255) default NULL,
  `click_url` varchar(500) default NULL,
  `price` decimal(10,2) unsigned NOT NULL default '0.00',
  PRIMARY KEY  (`id`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `{dbprefix}shop_news_goods`
--


-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_news_image`
--

DROP TABLE IF EXISTS `{dbprefix}shop_news_image`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_news_image` (
  `id` bigint(20) unsigned NOT NULL auto_increment,
  `nid` bigint(20) unsigned NOT NULL default '0',
  `title` text,
  `pic_path` varchar(300) default NULL,
  PRIMARY KEY  (`id`),
  KEY `nid` (`nid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;

--
-- 转存表中的数据 `{dbprefix}shop_news_image`
--


-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_rule`
--

DROP TABLE IF EXISTS `{dbprefix}shop_rule`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_rule` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `f_url` varchar(255) default NULL,
  `p_url` varchar(255) default NULL,
  `page_total` int(10) unsigned NOT NULL default '0',
  `page_step` int(10) unsigned NOT NULL default '0',
  `c_total` int(10) unsigned NOT NULL default '0',
  `list_block_s` varchar(500) default NULL,
  `list_block_e` varchar(500) default NULL,
  `list_link_s` varchar(500) default NULL,
  `list_link_e` varchar(500) default NULL,
  `detail_s` varchar(500) default NULL,
  `detail_e` varchar(500) default NULL,
  `charset` varchar(20) default NULL,
  `mod_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=9 ;

--
-- 转存表中的数据 `{dbprefix}shop_rule`
--

INSERT INTO `{dbprefix}shop_rule` (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `list_link_s`, `list_link_e`, `detail_s`, `detail_e`, `charset`, `mod_date`) VALUES
(8, '潮流趋势-淘宝', 'http://fashion.taobao.com/list/2081/1.php', 'http://fashion.taobao.com/list/2081/{page}.php', 3, 1, 42, '<div class="list-box">', '<div id="art-list" style="display:none;"></div>', '<h2>', '</h2>', '<div class="info-main-text" id="art-content">', '</div>', 'gbk', 1351269690),
(7, '时尚资讯-淘宝', 'http://fashion.taobao.com/list/2046/1.php', 'http://fashion.taobao.com/list/2046/{page}.php', 3, 1, 43, '<div class="list-box">', '<div id="art-list" style="display:none;"></div>', '<h2>', '</h2>', '<div class="info-main-text" id="art-content">', '</div>', 'gbk', 1351269735);

-- --------------------------------------------------------

--
-- 表的结构 `{dbprefix}shop_rule_wt`
--

DROP TABLE IF EXISTS `{dbprefix}shop_rule_wt`;
CREATE TABLE IF NOT EXISTS `{dbprefix}shop_rule_wt` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `f_url` varchar(255) default NULL,
  `p_url` varchar(255) default NULL,
  `page_total` int(10) unsigned NOT NULL default '0',
  `page_step` int(10) unsigned NOT NULL default '0',
  `c_total` int(10) unsigned NOT NULL default '0',
  `list_block_s` varchar(500) default NULL,
  `list_block_e` varchar(500) default NULL,
  `charset` varchar(20) default NULL,
  `mod_date` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=15 ;

--
-- 转存表中的数据 `{dbprefix}shop_rule_wt`
--

INSERT INTO `{dbprefix}shop_rule_wt` (`id`, `title`, `f_url`, `p_url`, `page_total`, `page_step`, `c_total`, `list_block_s`, `list_block_e`, `charset`, `mod_date`) VALUES
(10, '服饰-情侣装', 'http://wantu.taobao.com/fushi/new/tag-109?spm=alz0j.1000827.0.98.3j1WtQ', 'http://wantu.taobao.com/fushi/new/tag-109?spm=alz0j.1000827.0.557&since=15242486&bySort=&cateId=109&p={page}', 3, 1, 0, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 0),
(9, '服饰-外套', 'http://wantu.taobao.com/fushi/new/tag-4402?spm=alz0j.1000827.0.80.uvmRTj', 'http://wantu.taobao.com/fushi/new/tag-4402?spm=alz0j.1000827.0.588.sRwPYl&since=15249889&bySort=&cateId=4402&p={page}', 3, 1, 0, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 0),
(8, '美女帅哥', 'http://wantu.taobao.com/meinv/new/tag-178?spm=alz0j.1000827.0.86', 'http://wantu.taobao.com/meinv/new/tag-178?spm=alz0j.1000827.0.514.zdnnDh&since=15248744&bySort=&cateId=178&p={page}', 6, 1, 14, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 1351310024),
(7, '明星', 'http://wantu.taobao.com/mingxing/new?spm=alz0j.1000827.0.74.BlI2by', 'http://wantu.taobao.com/mingxing/new?spm=alz0j.1000827.0.517&since=15250652&bySort=&cateId=13&p={page}', 5, 1, 21, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 1351309896),
(14, '服饰-连衣裙', 'http://wantu.taobao.com/fushi/new/tag-1003?spm=alz0j.1000827.0.87', 'http://wantu.taobao.com/fushi/new/tag-1003?spm=alz0j.1000827.0.560.1diWyv&since=15247494&bySort=&cateId=1003&p={page}', 3, 1, 23, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 1351346652),
(11, '服饰-短裙', 'http://wantu.taobao.com/fushi/new/tag-1007?spm=alz0j.1000827.0.88.pMInxF', 'http://wantu.taobao.com/fushi/new/tag-1007?spm=alz0j.1000827.0.562.cLQTEJ&since=15247388&bySort=&cateId=1007&p={page}', 3, 1, 56, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 1351308054),
(12, '服饰-冬装', 'http://wantu.taobao.com/fushi/new/tag-6601?spm=alz0j.1000827.0.95.zHoofz', 'http://wantu.taobao.com/fushi/new/tag-6601?spm=alz0j.1000827.0.580.hT8ouT&since=15247727&bySort=&cateId=6601&p={page}', 3, 1, 0, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 0),
(13, '服饰-秋装', 'http://wantu.taobao.com/fushi/new/tag-4801?spm=alz0j.1000827.0.78.hkKe03', 'http://wantu.taobao.com/fushi/new/tag-4801?spm=alz0j.1000827.0.579.c1qjGp&since=15247627&bySort=&cateId=4801&p={page}', 3, 1, 0, '<script id="pix-waterfall-data" type="application/json">', '</script>', 'gbk', 0);
