/**
 * jQuery Masonry v2.0.111015
 * A dynamic layout plugin for jQuery
 * The flip-side of CSS Floats
 * http://masonry.desandro.com
 *
 * Licensed under the MIT license.
 * Copyright 2011 David DeSandro
 */
(function(a, b, c) {
    var d = b.event,
    e;
    d.special.smartresize = {
        setup: function() {
            b(this).bind("resize", d.special.smartresize.handler)
        },
        teardown: function() {
            b(this).unbind("resize", d.special.smartresize.handler)
        },
        handler: function(a, b) {
            var c = this,
            d = arguments;
            a.type = "smartresize",
            e && clearTimeout(e),
            e = setTimeout(function() {
                jQuery.event.handle.apply(c, d)
            },
            b === "execAsap" ? 0 : 100)
        }
    },
    b.fn.smartresize = function(a) {
        return a ? this.bind("smartresize", a) : this.trigger("smartresize", ["execAsap"])
    },
    b.Mason = function(a, c) {
        this.element = b(c),
        this._create(a),
        this._init()
    };
    var f = ["position", "height"];
    b.Mason.settings = {
        isResizable: !0,
        isAnimated: !1,
        animationOptions: {
            queue: !1,
            duration: 500
        },
        gutterWidth: 0,
        isRTL: !1,
        isFitWidth: !1
    },
    b.Mason.prototype = {
        _filterFindBricks: function(a) {
            var b = this.options.itemSelector;
            return b ? a.filter(b).add(a.find(b)) : a
        },
        _getBricks: function(a) {
            var b = this._filterFindBricks(a).css({
                position: "absolute"
            }).addClass("masonry-brick");
            return b
        },
        _create: function(c) {
            this.options = b.extend(!0, {},
            b.Mason.settings, c),
            this.styleQueue = [],
            this.reloadItems();
            var d = this.element[0].style;
            this.originalStyle = {};
            for (var e = 0,
            g = f.length; e < g; e++) {
                var h = f[e];
                this.originalStyle[h] = d[h] || ""
            }
            this.element.css({
                position: "relative"
            }),
            this.horizontalDirection = this.options.isRTL ? "right": "left",
            this.offset = {};
            var i = b(document.createElement("div"));
            this.element.prepend(i),
            this.offset.y = Math.round(i.position().top),
            this.options.isRTL ? (i.css({
                "float": "right",
                display: "inline-block"
            }), this.offset.x = Math.round(this.element.outerWidth() - i.position().left)) : this.offset.x = Math.round(i.position().left),
            i.remove();
            var j = this;
            setTimeout(function() {
                j.element.addClass("masonry")
            },
            0),
            this.options.isResizable && b(a).bind("smartresize.masonry",
            function() {
                j.resize()
            })
        },
        _init: function(a) {
            this._getColumns(),
            this._reLayout(a)
        },
        option: function(a, c) {
            b.isPlainObject(a) && (this.options = b.extend(!0, this.options, a))
        },
        layout: function(a, c) {
            var d, e, f, g, h, i;
            for (var j = 0,
            k = a.length; j < k; j++) {
                d = b(a[j]),
                e = Math.ceil(d.outerWidth(!0) / this.columnWidth),
                e = Math.min(e, this.cols);
                if (e === 1) this._placeBrick(d, this.colYs);
                else {
                    f = this.cols + 1 - e,
                    g = [];
                    for (i = 0; i < f; i++) h = this.colYs.slice(i, i + e),
                    g[i] = Math.max.apply(Math, h);
                    this._placeBrick(d, g)
                }
            }
            var l = {};
            l.height = Math.max.apply(Math, this.colYs) - this.offset.y;
            if (this.options.isFitWidth) {
                var m = 0,
                j = this.cols;
                while (--j) {
                    if (this.colYs[j] !== this.offset.y) break;
                    m++
                }
                l.width = (this.cols - m) * this.columnWidth - this.options.gutterWidth
            }
            this.styleQueue.push({
                $el: this.element,
                style: l
            });
            var n = this.isLaidOut ? this.options.isAnimated ? "animate": "css": "css",
            o = this.options.animationOptions,
            p;
            for (j = 0, k = this.styleQueue.length; j < k; j++) p = this.styleQueue[j],
            p.$el[n](p.style, o);
            this.styleQueue = [],
            c && c.call(a),
            this.isLaidOut = !0
        },
        _getColumns: function() {
            var a = this.options.isFitWidth ? this.element.parent() : this.element,
            b = a.width();
            this.columnWidth = this.options.columnWidth || this.$bricks.outerWidth(!0) || b,
            this.columnWidth += this.options.gutterWidth,
            this.cols = Math.floor((b + this.options.gutterWidth) / this.columnWidth),
            this.cols = Math.max(this.cols, 1)
        },
        _placeBrick: function(a, b) {
            var c = Math.min.apply(Math, b),
            d = 0;
            for (var e = 0,
            f = b.length; e < f; e++) if (b[e] === c) {
                d = e;
                break
            }
            var g = {
                top: c
            };
            g[this.horizontalDirection] = this.columnWidth * d + this.offset.x,
            this.styleQueue.push({
                $el: a,
                style: g
            });
            var h = c + a.outerHeight(!0),
            i = this.cols + 1 - f;
            for (e = 0; e < i; e++) this.colYs[d + e] = h
        },
        resize: function() {
            var a = this.cols;
            this._getColumns(),
            this.cols !== a && this._reLayout()
        },
        _reLayout: function(a) {
            var b = this.cols;
            this.colYs = [];
            while (b--) this.colYs.push(this.offset.y);
            this.layout(this.$bricks, a)
        },
        reloadItems: function() {
            this.$bricks = this._getBricks(this.element.children())
        },
        reload: function(a) {
            this.reloadItems(),
            this._init(a)
        },
        appended: function(a, b, c) {
            if (b) {
                this._filterFindBricks(a).css({
                    top: this.element.height()
                });
                var d = this;
                setTimeout(function() {
                    d._appended(a, c)
                },
                1)
            } else this._appended(a, c)
        },
        _appended: function(a, b) {
            var c = this._getBricks(a);
            this.$bricks = this.$bricks.add(c),
            this.layout(c, b)
        },
        remove: function(a) {
            this.$bricks = this.$bricks.not(a),
            a.remove()
        },
        destroy: function() {
            this.$bricks.removeClass("masonry-brick").each(function() {
                this.style.position = "",
                this.style.top = "",
                this.style.left = ""
            });
            var c = this.element[0].style;
            for (var d = 0,
            e = f.length; d < e; d++) {
                var g = f[d];
                c[g] = this.originalStyle[g]
            }
            this.element.unbind(".masonry").removeClass("masonry").removeData("masonry"),
            b(a).unbind(".masonry")
        }
    },
    b.fn.imagesLoaded = function(a) {
        function h() {--e <= 0 && this.src !== f && (setTimeout(g), d.unbind("load error", h))
        }
        function g() {
            a.call(b, d)
        }
        var b = this,
        d = b.find("img").add(b.filter("img")),
        e = d.length,
        f = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==";
        e || g(),
        d.bind("load error", h).each(function() {
            if (this.complete || this.complete === c) {
                var a = this.src;
                this.src = f,
                this.src = a
            }
        });
        return b
    };
    var g = function(a) {
        this.console && console.error(a)
    };
    b.fn.masonry = function(a) {
        if (typeof a == "string") {
            var c = Array.prototype.slice.call(arguments, 1);
            this.each(function() {
                var d = b.data(this, "masonry");
                if (!d) g("cannot call methods on masonry prior to initialization; attempted to call method '" + a + "'");
                else {
                    if (!b.isFunction(d[a]) || a.charAt(0) === "_") {
                        g("no such method '" + a + "' for masonry instance");
                        return
                    }
                    d[a].apply(d, c)
                }
            })
        } else this.each(function() {
            var c = b.data(this, "masonry");
            c ? (c.option(a || {}), c._init()) : b.data(this, "masonry", new b.Mason(a, this))
        });
        return this
    }
})(window, jQuery);
/*
 * InfiniteScroll
*/
(function(n, i, k) {
    i.infinitescroll = function y(B, D, C) {
        this.element = i(C);
        this._create(B, D)
    };
    i.infinitescroll.defaults = {
        loading: {
            finished: k,
            finishedMsg: "<em>Congratulations, you've reached the end of the internet.</em>",
            img: "http://www.infinite-scroll.com/loading.gif",
            msg: null,
            msgText: "<em>Loading the next set of posts...</em>",
            selector: null,
            speed: "fast",
            start: k
        },
        state: {
            isDuringAjax: false,
            isInvalidPage: false,
            isDestroyed: false,
            isDone: false,
            isPaused: false,
            currPage: 1
        },
        callback: k,
        debug: false,
        behavior: k,
        binder: i(n),
        nextSelector: "div.navigation a:first",
        navSelector: "div.navigation",
        contentSelector: null,
        extraScrollPx: 150,
        itemSelector: "div.post",
        animate: false,
        pathParse: k,
        dataType: "html",
        appendCallback: true,
        bufferPx: 40,
        errorCallback: function() {},
        infid: 0,
        pixelsFromNavToBottom: k,
        path: k
    };
    i.infinitescroll.prototype = {
        _binding: function g(D) {
            var B = this,
            C = B.options;
            if ( !! C.behavior && this["_binding_" + C.behavior] !== k) {
                this["_binding_" + C.behavior].call(this);
                return
            }
            if (D !== "bind" && D !== "unbind") {
                this._debug("Binding value  " + D + " not valid");
                return false
            }
            if (D == "unbind") { (this.options.binder).unbind("smartscroll.infscr." + B.options.infid)
            } else { (this.options.binder)[D]("smartscroll.infscr." + B.options.infid,
                function() {
                    B.scroll()
                })
            }
            this._debug("Binding", D)
        },
        _create: function s(B, F) {
            if (!this._validate(B)) {
                return false
            }
            var C = this.options = i.extend(true, {},
            i.infinitescroll.defaults, B),
            E = /(.*?\/\/).*?(\/.*)/,
            D = i(C.nextSelector).attr("href");
            C.contentSelector = C.contentSelector || this.element;
            C.loading.selector = C.loading.selector || C.contentSelector;
            if (!D) {
                this._debug("Navigation selector not found");
                return
            }
            C.path = this._determinepath(D);
            C.loading.msg = i('<div id="infscr-loading"><img alt="Loading..." src="' + C.loading.img + '" /> <div>' + C.loading.msgText + "</div></div>"); (new Image()).src = C.loading.img;
            C.pixelsFromNavToBottom = i(document).height() - i(C.navSelector).offset().top;
            C.loading.start = C.loading.start ||
            function() {
                i(C.navSelector).hide();
                C.loading.msg.appendTo(C.loading.selector).show(C.loading.speed,
                function() {
                    beginAjax(C)
                })
            };
            C.loading.finished = C.loading.finished ||
            function() {
                C.loading.msg.fadeOut("normal")
            };
            C.callback = function(G, H) {
                if ( !! C.behavior && G["_callback_" + C.behavior] !== k) {
                    G["_callback_" + C.behavior].call(i(C.contentSelector)[0], H)
                }
                if (F) {
                    F.call(i(C.contentSelector)[0], H)
                }
            };
            this._setup()
        },
        _debug: function p() {
            if (this.options.debug) {
                return n.console && console.log.call(console, arguments)
            }
        },
        _determinepath: function z(C) {
            var B = this.options;
            if ( !! B.behavior && this["_determinepath_" + B.behavior] !== k) {
                this["_determinepath_" + B.behavior].call(this, C);
                return
            }
            if ( !! B.pathParse) {
                this._debug("pathParse manual");
                return B.pathParse
            } else {
                if (C.match(/^(.*?)\b2\b(.*?$)/)) {
                    C = C.match(/^(.*?)\b2\b(.*?$)/).slice(1)
                } else {
                    if (C.match(/^(.*?)2(.*?$)/)) {
                        if (C.match(/^(.*?page=)2(\/.*|$)/)) {
                            C = C.match(/^(.*?page=)2(\/.*|$)/).slice(1);
                            return C
                        }
                        C = C.match(/^(.*?)2(.*?$)/).slice(1)
                    } else {
                        if (C.match(/^(.*?page=)1(\/.*|$)/)) {
                            C = C.match(/^(.*?page=)1(\/.*|$)/).slice(1);
                            return C
                        } else {
                            this._debug("Sorry, we couldn't parse your Next (Previous Posts) URL. Verify your the css selector points to the correct A tag. If you still get this error: yell, scream, and kindly ask for help at infinite-scroll.com.");
                            B.state.isInvalidPage = true
                        }
                    }
                }
            }
            this._debug("determinePath", C);
            return C
        },
        _error: function u(C) {
            var B = this.options;
            if ( !! B.behavior && this["_error_" + B.behavior] !== k) {
                this["_error_" + B.behavior].call(this, C);
                return
            }
            if (C !== "destroy" && C !== "end") {
                C = "unknown"
            }
            this._debug("Error", C);
            if (C == "end") {
                this._showdonemsg()
            }
            B.state.isDone = true;
            B.state.currPage = 1;
            B.state.isPaused = false;
            this._binding("unbind")
        },
        _loadcallback: function c(F, G) {
            var E = this.options,
            I = this.options.callback,
            B = (E.state.isDone) ? "done": (!E.appendCallback) ? "no-append": "append",
            H;
            if ( !! E.behavior && this["_loadcallback_" + E.behavior] !== k) {
                this["_loadcallback_" + E.behavior].call(this, F, G);
                return
            }
            switch (B) {
            case "done":
                this._showdonemsg();
                return false;
                break;
            case "no-append":
                if (E.dataType == "html") {
                    G = "<div>" + G + "</div>";
                    G = i(G).find(E.itemSelector)
                }
                break;
            case "append":
                var D = F.children();
                if (D.length == 0) {
                    return this._error("end")
                }
                H = document.createDocumentFragment();
                while (F[0].firstChild) {
                    H.appendChild(F[0].firstChild)
                }
                this._debug("contentSelector", i(E.contentSelector)[0]);
                i(E.contentSelector)[0].appendChild(H);
                G = D.get();
                break
            }
            E.loading.finished.call(i(E.contentSelector)[0], E);
            if (E.animate) {
                var C = i(n).scrollTop() + i("#infscr-loading").height() + E.extraScrollPx + "px";
                i("html,body").animate({
                    scrollTop: C
                },
                800,
                function() {
                    E.state.isDuringAjax = false
                })
            }
            if (!E.animate) {
                E.state.isDuringAjax = false
            }
            I(this, G)
        },
        _nearbottom: function t() {
            var C = this.options,
            B = 0 + i(document).height() - (C.binder.scrollTop()) - i(n).height();
            if ( !! C.behavior && this["_nearbottom_" + C.behavior] !== k) {
                this["_nearbottom_" + C.behavior].call(this);
                return
            }
            this._debug("math:", B, C.pixelsFromNavToBottom);
            return (B - C.bufferPx < C.pixelsFromNavToBottom)
        },
        _pausing: function l(C) {
            var B = this.options;
            if ( !! B.behavior && this["_pausing_" + B.behavior] !== k) {
                this["_pausing_" + B.behavior].call(this, C);
                return
            }
            if (C !== "pause" && C !== "resume" && C !== null) {
                this._debug("Invalid argument. Toggling pause value instead")
            }
            C = (C && (C == "pause" || C == "resume")) ? C: "toggle";
            switch (C) {
            case "pause":
                B.state.isPaused = true;
                break;
            case "resume":
                B.state.isPaused = false;
                break;
            case "toggle":
                B.state.isPaused = !B.state.isPaused;
                break
            }
            this._debug("Paused", B.state.isPaused);
            return false
        },
        _setup: function q() {
            var B = this.options;
            if ( !! B.behavior && this["_setup_" + B.behavior] !== k) {
                this["_setup_" + B.behavior].call(this);
                return
            }
            this._binding("bind");
            return false
        },
        _showdonemsg: function a() {
            var B = this.options;
            if ( !! B.behavior && this["_showdonemsg_" + B.behavior] !== k) {
                this["_showdonemsg_" + B.behavior].call(this);
                return
            }
            B.loading.msg.find("img").hide().parent().find("div").html(B.loading.finishedMsg).animate({
                opacity: 1
            },
            2000,
            function() {
                i(this).parent().fadeOut("normal")
            });
            B.errorCallback.call(i(B.contentSelector)[0], "done")
        },
        _validate: function v(C) {
            for (var B in C) {
                if (B.indexOf && B.indexOf("Selector") > -1 && i(C[B]).length === 0) {
                    this._debug("Your " + B + " found no elements.");
                    return false
                }
                return true
            }
        },
        bind: function o() {
            this._binding("bind")
        },
        destroy: function A() {
            this.options.state.isDestroyed = true;
            return this._error("destroy")

        },
        pause: function e() {
            this._pausing("pause")
        },
        resume: function h() {
            this._pausing("resume")
        },
        retrieve: function b(H) {
            var I = this,
            C = I.options,
            K = C.path,
            E, J, L, B, D, H = H || null,
            G = ( !! H) ? H: C.state.currPage;
            beginAjax = function F(M) {
                M.state.currPage++;
                I._debug("heading into ajax", K);
                E = i(M.contentSelector).is("table") ? i("<tbody/>") : i("<div/>");
                L = K.join(M.state.currPage);
                B = (M.dataType == "html" || M.dataType == "json") ? M.dataType: "html+callback";
                if (M.appendCallback && M.dataType == "html") {
                    B += "+callback"
                }
                switch (B) {
                case "html+callback":
                    I._debug("Using HTML via .load() method");
                    E.load(L + " " + M.itemSelector, null,
                    function N(O) {
                        I._loadcallback(E, O)
                    });
                    break;
                case "html":
                case "json":
                    I._debug("Using " + (B.toUpperCase()) + " via $.ajax() method");
                    i.ajax({
                        url: L,
                        dataType: M.dataType,
                        complete: function N(O, P) {
                            D = (typeof(O.isResolved) !== "undefined") ? (O.isResolved()) : (P === "success" || P === "notmodified"); (D) ? I._loadcallback(E, O.responseText) : I._error("end")
                        }
                    });
                    break
                }
            };
            if ( !! C.behavior && this["retrieve_" + C.behavior] !== k) {
                this["retrieve_" + C.behavior].call(this, H);
                return
            }
            if (C.state.isDestroyed) {
                this._debug("Instance is destroyed");
                return false
            }
            C.state.isDuringAjax = true;
            C.loading.start.call(i(C.contentSelector)[0], C)
        },
        scroll: function f() {
            var B = this.options,
            C = B.state;
            if ( !! B.behavior && this["scroll_" + B.behavior] !== k) {
                this["scroll_" + B.behavior].call(this);
                return
            }
            if (C.isDuringAjax || C.isInvalidPage || C.isDone || C.isDestroyed || C.isPaused) {
                return
            }
            if (!this._nearbottom()) {
                return
            }
            this.retrieve()
        },
        toggle: function x() {
            this._pausing()
        },
        unbind: function m() {
            this._binding("unbind")
        },
        update: function j(B) {
            if (i.isPlainObject(B)) {
                this.options = i.extend(true, this.options, B)
            }
        }
    };
    i.fn.infinitescroll = function d(D, E) {
        var C = typeof D;
        switch (C) {
        case "string":
            var B = Array.prototype.slice.call(arguments, 1);
            this.each(function() {
                var F = i.data(this, "infinitescroll");
                if (!F) {
                    return false
                }
                if (!i.isFunction(F[D]) || D.charAt(0) === "_") {
                    return false
                }
                F[D].apply(F, B)
            });
            break;
        case "object":
            this.each(function() {
                var F = i.data(this, "infinitescroll");
                if (F) {
                    F.update(D)
                } else {
                    i.data(this, "infinitescroll", new i.infinitescroll(D, E, this))
                }
            });
            break
        }
        return this
    };
    var w = i.event,
    r;
    w.special.smartscroll = {
        setup: function() {
            i(this).bind("scroll", w.special.smartscroll.handler)
        },
        teardown: function() {
            i(this).unbind("scroll", w.special.smartscroll.handler)
        },
        handler: function(E, B) {
            var D = this,
            C = arguments;
            E.type = "smartscroll";
            if (r) {
                clearTimeout(r)
            }
            r = setTimeout(function() {
                i.event.handle.apply(D, C)
            },
            B === "execAsap" ? 0 : 100)
        }
    };
    i.fn.smartscroll = function(B) {
        return B ? this.bind("smartscroll", B) : this.trigger("smartscroll", ["execAsap"])
    }
})(window, jQuery);