<?php

class View {
    /**
     * ģ
     * @var tVar
     * @access protected
     */       
    protected $tVar        =  array();

    /**
     * ģֵ
     * @access public
     * @param mixed $name
     * @param mixed $value
     */
    public function assign($name,$value=''){
        if(is_array($name)) {
            $this->tVar   =  array_merge($this->tVar,$name);
        }else {
            $this->tVar[$name] = $value;
        }
    }

    /**
     * ȡģֵ
     * @access public
     * @param string $name
     * @return mixed
     */
    public function get($name=''){
        if('' === $name) {
            return $this->tVar;
        }
        return isset($this->tVar[$name])?$this->tVar[$name]:false;
    }

    /**
     * ģҳ Է
     * @access public
     * @param string $templateFile ģļ
     * @param string $charset ģַ
     * @param string $contentType 
     * @param string $content ģ
     * @param string $prefix ģ建ǰ׺
     * @return mixed
     */
    public function display($templateFile='',$charset='',$contentType='',$content='',$prefix='') {
		
        G('viewStartTime');
        // ͼʼǩ
        tag('view_begin',$templateFile);
        // ȡģ
        $content = $this->fetch($templateFile,$content,$prefix);
        // ģ
        $this->render($content,$charset,$contentType);
        // ͼǩ
        tag('view_end');
    }

    /**
     * ı԰Html
     * @access private
     * @param string $content 
     * @param string $charset ģַ
     * @param string $contentType 
     * @return mixed
     */
    private function render($content,$charset='',$contentType=''){
        if(empty($charset))  $charset = C('DEFAULT_CHARSET');
        if(empty($contentType)) $contentType = C('TMPL_CONTENT_TYPE');
        // ҳַ
        header('Content-Type:'.$contentType.'; charset='.$charset);
        header('Cache-control: '.C('HTTP_CACHE_CONTROL'));  // ҳ滺
        header('X-Powered-By:ThinkPHP');
        // ģļ
        echo $content;
    }

    /**
     * ͻȡģ 
     * @access public
     * @param string $templateFile ģļ
     * @param string $content ģ
     * @param string $prefix ģ建ǰ׺
     * @return string
     */
    public function fetch($templateFile='',$content='',$prefix='') {
        if(empty($content)) {
            // ģļǩ
            tag('view_template',$templateFile);
            // ģļֱӷ
            if(!is_file($templateFile)) return NULL;
        }
        // ҳ滺
        ob_start();
        ob_implicit_flush(0);
        if('php' == strtolower(C('TMPL_ENGINE_TYPE'))) { // ʹPHPԭģ
            // ģбֽΪ
            extract($this->tVar, EXTR_OVERWRITE);
            // ֱPHPģ
            empty($content)?include $templateFile:eval('?>'.$content);
        }else{
            // ͼǩ
            $params = array('var'=>$this->tVar,'file'=>$templateFile,'content'=>$content,'prefix'=>$prefix);
            tag('view_parse',$params);
        }
        // ȡջ
        $content = ob_get_clean();
        // ݹ˱ǩ
        tag('view_filter',$content);
        // ģļ
        return $content;
    }
}