<?php

/**
 * FerOS PHP template engine
 * @author feros<admin@feros.com.cn>
 * @copyright ©2014 feros.com.cn
 * @link http://www.feros.com.cn
 * @version 2.0
 */

namespace feros;

/**
 * 模板解析
 * @author sanliang
 */
class compile {

    private $__source, $__template_file, $__ldel, $__rdel, $__view, $_template_preg = array(), $_template_replace = array();

    public function __construct(\feros\view $view, &$content, $template) {
        if (empty($content))
            return $content;
        $this->__view = $view;
        $this->__source = $content;
        $this->__template_file = $template;
        $this->__ldel = preg_quote($this->__view->config->left_delimiter);
        $this->__rdel = preg_quote($this->__view->config->right_delimiter);
        $this->compile_code($content);
        $content = "<?php\n/**\n* " . view::NAME . "\n* @author feros<admin@feros.com.cn>\n* @copyright ©" . date('Y') . " feros.com.cn\n* @link http://www.feros.com.cn\n* @version " . view::VERSION . "\n*/\n?>" . $content;
    }

    private function xml_substitution($capture) {
        return "<?php echo '<?xml " . stripslashes($capture[1]) . " ?>'; ?>";
    }

    /**
     * 解析标签
     * @param array $content
     * @return string
     */
    public function parse_tag($content) {

        $content = stripslashes($content[0]);
        $content = preg_replace_callback('/\\$(\w+\.\w+)*/', array($this, 'parse_var'), $content);

        return $content;
    }

    /**
     * 解析变量
     * @param array $var
     * @return string
     */
    public function parse_var($var) {
        if (empty($var[0]))
            return;
        $vars = explode('.', $var[0]);
        $var = array_shift($vars);
        $name = $var;
        foreach ($vars as $key => $val)
            $name .= '["' . $val . '"]';
        return $name;
    }

    private function compile_code(&$content) {

        if (count($this->__view->config->black_list) && preg_match('/' . $this->__ldel . '\$?(' . implode('|', $this->__view->config->black_list) . ')' . $this->__rdel . '/s', $content))
            throw new \Exception($this->__view->language->template_black_list);

        $content = preg_replace_callback('/(' . $this->__ldel . ')([^\d\s' . $this->__ldel . $this->__rdel . '].+?)(' . $this->__rdel . ')/is', array($this, 'parse_tag'), $content);

        $this->_template_preg[] = "/<\?xml(.*?)\?>/s";
        $this->_template_replace[] = "##XML\\1XML##";
        if (!$this->__view->config->php_off) {
            $this->_template_preg[] = '/<\?(=|php|)(.+?)\?>/is';
            $this->_template_replace[] = '&lt;?\\1\\2?&gt;';
        } else {
            $this->_template_preg[] = '/(<\?(?!php|=|$))/i';
            $this->_template_replace[] = '<?php echo \'\\1\'; ?>';
        }
        if ($this->__view->config->style_path_url) {
            $this->_template_preg = array_merge($this->_template_preg, array('/<img(.*?)src=(?:")(http|https)\:\/\/([^"]+?)(?:")/i', '/<img(.*?)src=(?:")([^"]+?)#(?:")/i', '/<img(.*?)src="(.*?)"/', '/<img(.*?)src=(?:\@)([^"]+?)(?:\@)/i'));
            $this->_template_replace = array_merge($this->_template_replace, array('<img$1src=@$2://$3@', '<img$1src=@$2@', '<img$1src="' . $this->__view->config->style_path_url . '$2"', '<img$1src="$2"'));
            $this->_template_preg = array_merge($this->_template_preg, array('/<script(.*?)src=(?:")(http|https)\:\/\/([^"]+?)(?:")/i', '/<script(.*?)src=(?:")([^"]+?)#(?:")/i', '/<script(.*?)src="(.*?)"/', '/<script(.*?)src=(?:\@)([^"]+?)(?:\@)/i'));
            $this->_template_replace = array_merge($this->_template_replace, array('<script$1src=@$2://$3@', '<script$1src=@$2@', '<script$1src="' . $this->__view->config->style_path_url . '$2"', '<script$1src="$2"'));
            $this->_template_preg = array_merge($this->_template_preg, array('/<link(.*?)href=(?:")(http|https)\:\/\/([^"]+?)(?:")/i', '/<link(.*?)href=(?:")([^"]+?)#(?:")/i', '/<link(.*?)href="(.*?)"/', '/<link(.*?)href=(?:\@)([^"]+?)(?:\@)/i'));
            $this->_template_replace = array_merge($this->_template_replace, array('<link$1href=@$2://$3@', '<link$1href=@$2@', '<link$1href="' . $this->__view->config->style_path_url . '$2"', '<link$1href="$2"'));
            //$this->_template_preg = array_merge($this->_template_preg, array('/<a(.*?)href=(?:")(http\:\/\/|https\:\/\/|javascript:)([^"]+?)(?:")/i', '/<a(.*?)href="(.*?)"/', '/<a(.*?)href=(?:\@)([^"]+?)(?:\@)/i'));
            //$this->_template_replace = array_merge($this->_template_replace, array('<a$1href=@$2$3@', '<a$1href="' . $this->__view->config->style_path_url . '$2"', '<a$1href="$2"'));
            $this->_template_preg = array_merge($this->_template_preg, array('/<input(.*?)src=(?:")(http|https)\:\/\/([^"]+?)(?:")/i', '/<input(.*?)src=(?:")([^"]+?)#(?:")/i', '/<input(.*?)src="(.*?)"/', '/<input(.*?)src=(?:\@)([^"]+?)(?:\@)/i'));
            $this->_template_replace = array_merge($this->_template_replace, array('<input$1src=@$2://$3@', '<input$1src=@$2@', '<input$1src="' . $this->__view->config->style_path_url . '$2"', '<input$1src="$2"'));
        }
        $this->_template_preg[] = '/' . $this->__ldel . '(else if|elseif) (.*?)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . 'for (.*?)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . 'while (.*?)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . '(loop|foreach) (.*?)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . 'if (.*?)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . 'else' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . "(eval|_)( |[\r\n])(.*?)" . $this->__rdel . '/is';
        $this->_template_preg[] = '/' . $this->__ldel . '_e (.*?)' . $this->__rdel . '/is';
        $this->_template_preg[] = '/' . $this->__ldel . '_p (.*?)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . '\/(if|for|loop|foreach|eval|while)' . $this->__rdel . '/i';
        $this->_template_preg[] = '/' . $this->__ldel . '((( *(\+\+|--) *)*?(([_a-zA-Z][\w]*\(.*?\))|\$((\w+)((\[|\()(\'|")?\$*\w*(\'|")?(\)|\]))*((->)?\$?(\w*)(\((\'|")?(.*?)(\'|")?\)|))){0,})( *\.?[^ \.]*? *)*?){1,})' . $this->__rdel . '/i';
        $this->_template_preg[] = "/(	| ){0,}(\r\n){1,}\";/";
        $this->_template_preg[] = '/' . $this->__ldel . '(\#|\*)(.*?)(\#|\*)' . $this->__rdel . '/';
        $this->_template_preg[] = '/' . $this->__ldel . 'template (\'?\"?([\w|-|\/]{1,}\'?\"?)|(\$([_a-zA-Z][\w]+)))' . $this->__rdel . '/';
        $this->_template_preg[] = '/' . $this->__ldel . 'runtime' . $this->__rdel . '/';

        $this->_template_replace[] = '<?php }else if (\\2){ ?>';
        $this->_template_replace[] = '<?php for (\\1) { ?>';
        $this->_template_replace[] = '<?php while (\\1) { ?>';
        $this->_template_replace[] = '<?php foreach (\\2) {?>';
        $this->_template_replace[] = '<?php if (\\1){ ?>';
        $this->_template_replace[] = '<?php }else{ ?>';
        $this->_template_replace[] = '<?php \\3; ?>';
        $this->_template_replace[] = '<?php echo \\1; ?>';
        $this->_template_replace[] = '<?php print_r(\\1); ?>';
        $this->_template_replace[] = '<?php } ?>';
        $this->_template_replace[] = '<?php echo \\1;?>';
        $this->_template_replace[] = '';
        $this->_template_replace[] = '';
        $this->_template_replace[] = '<?php echo $this->fetch(\\1);?>';
        $this->_template_replace[] = '<?php echo $this->get_runtime();?>';
        $content = preg_replace($this->_template_preg, $this->_template_replace, $content);
        $content = preg_replace_callback("/##XML(.*?)XML##/s", array($this, 'xml_substitution'), $content);
        
        return $content;
    }

}
