<?php

defined("IS_SYS") or die("Accessed died!");

/**
* 商品分类模型文件
* @autor: fuwei<fuweiqs163@163.com>
* @version: 1.0
*/

class CategoryModel extends BaseModel{
	
	function __construct(){
		$this->table = 'category';
		parent::__construct();
	}
	
	/*
	* 返回分类的层级 该分类的父分类信息
	* @param $id int 分类ID
	*/
	function crumb($cateId){
		$cateInfo = $this->getCategory(array('id'=>$cateId));
		$data = array();
		foreach($cateInfo as $v){
			if( (int)$v['parentid'] !== 0){
				$control['parent_cate'] = $this->crumb($v['parentid']);
				$data [] = array_merge($v,$control);
			}else{
				$data[] = $v;
			}
		}
		unset($cateInfo,$v,$control);
		return $data;
	}
	
	/*
	* 获取该分类的信息
	* @access public
	* @param $where array/string 条件
	* @param $field string 需要获取哪些字段信息
	*/
	function getCategory($where,$field = "*"){
		return $this->select(array('where'=>$where,'field'=>$field));
	}
	
	/*
	* 获取该ID的所有子ID
	*/
	function getCateSons($id){
		$cate = $this->getCategory(array('parentid'=>$id));
		$str = '';
		if($cate){
			foreach($cate as $v) $str .= empty($str) ? $v['id'] : ','.$v['id'];
			$where = 'parentid in ('.$str.')';
			$sonlist = $this->getCategory($where);
			if($sonlist)
				foreach($sonlist as $val) $str .= empty($str) ? $val['id'] : ','.$val['id'];
		}
		$str .= empty($str) ? $id : ','.$id;
		unset($id,$v,$cate,$val,$sonlist);
		return $str;
	}
}