<?php

defined("IS_SYS") or die('ACCESSED died!');

/**
* 产品模型类
* @autor: fuwei<fuweiqs163@163.com>
* @version: 1.0
*/

class ProductModel extends BaseModel{
	
	private $productTypeTable;
	
	private $productImageTable;
	
	function __construct(){
		$this->table = 'product';
		parent::__construct();
		$this->productTypeTable = 'product_type';
		$this->productImageTable = 'product_image';
	}
	
	/*
	* 统计产品数量用于首页分类显示
	*/
	function countData($where=""){
		$sql = "SELECT a.*,b.product_type,b.product_stock,b.our_price FROM `{$this->table($this->table)}` a JOIN `{$this->table($this->productTypeTable)}` b WHERE {$where}";
		return $this->count($sql);
	}
	
	function selectAll($where = "",$limit = ""){
		$sql = "SELECT a.*,b.product_type,b.product_stock,b.our_price as price FROM `{$this->table($this->table)}` a JOIN `{$this->table($this->productTypeTable)}` b WHERE {$where} ORDER BY a.sort ASC, a.id DESC LIMIT ".$limit;
		return $this->select($sql);
	}
	
	/*
	* 获取一条商品详细信息
	* @access public
	* @param $id int 商品ID
	*/
	function getProductInfo($id){
		//if(DEBUG) cache('product_'.$id,null);
		if(!cache('product_'.$id)){
			$where = array(
				'id' => $id,
				'is_sale' => 0,
				'product_status' => 0
			);
			$info = $this->find(array('where'=>$where));
			if($info){
				$info['photos'] = $this->select(array('where'=>array('product_id'=>$id)),$this->productImageTable);
				$info['type'] = $this->getProductType($id);
			}
			cache('product_'.$id,$info);
		}
		return cache('product_'.$id);
	}
	
	/*
	* 获取该商品的所有货品
	* @access public
	* @param $id int 商品ID
	*/
	function getProductType($id){
		$typeInfo = $this->select(array('where'=>array('product_id' => $id)),$this->productTypeTable);
		$str = "";
		foreach($typeInfo as $v) $str .= empty($str) ? $v['product_type'] : ','.$v['product_type'];
		$str = explode(',',$str);
		$str = array_unique($str);
		sort($str);
		unset($typeInfo,$v);
		return $str;
	}
	
	/*
	* 获取指定条件的类型信息
	* @access public
	* @param $where string/array 条件
	*/
	function getTypeInfo($where){
		return $this->find(array('where'=>$where),$this->productTypeTable);
	}
	
	/*
	* 获取指定ID商品的商品名称的指定信息
	*/
	function getProductItem($where,$field = "*"){
		return $this->select(array('where'=>$where,'field'=>$field));
	}
}