<?php

defined('IS_SYS') or die('Accessed died');
/*
* 系统基类文件
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/
class Base{
	
	private static $_instance;
	
	static function createApp(){
		set_magic_quotes_runtime(0);
		dataIn($_GET);
		dataIn($_POST);
		dataIn($_REQUEST);
		dataIn($_COOKIE);
		baseUrl::app()->run();
	}
	
	static function registerAutoload(){
		foreach(self::_map() as $v){
			if(file_exists($v)) require $v;
		}
		self::autoLoadHelper();
		self::autoLoadLibrary();
		self::autoloadOther();
	}
	
	static function autoConfig(){
		return self::getConfig('autoload');
	}
	
	static function autoLoadHelper(){
		$config = self::autoConfig();
		if(!empty($config['helper']) && is_array($config['helper'])){
			foreach($config['helper'] as $v) BaseCommoned::getInstance()->helper($v);
			unset($config,$v);
		}
	}
	
	static function autoLoadLibrary(){
		$config = self::autoConfig();
		if(!empty($config['library']) && is_array($config['library'])){
			foreach($config['library'] as $v){
				$arr = array($v,'','',true);
				BaseCommoned::getInstance()->library($arr);
			}
			unset($config,$v);
		}
	}
	
	static function autoloadOther(){
		$config = self::autoConfig();
		unset($config['helper'],$config['library']);
		if(isset($config['controller']) && is_array($config['controller']))
			foreach($config['controller'] as $v) loadClass(ucfirst($v).'Controller','controller','',true);
		unset($config['controller'],$v);
		if(isset($config['service']) && is_array($config['service']))
			foreach($config['service'] as $v) loadClass(ucfirst($v).'Service','service','',true);
		unset($config['service'],$v);
		if(isset($config['model']) && is_array($config['model']))
			foreach($config['model'] as $v) loadClass(ucfirst($v).'Model','model','',true);
		unset($config['model'],$v);
	}
	
	static function app(){
		if( !(self::$_instance instanceof self) )
			self::$_instance = new self;
		return self::$_instance;
	}
	
	private static function _map(){
		return array(
			BASE_PATH.'/base/baseException.php',
			BASE_PATH.'/base/baseController.php',
			BASE_PATH.'/base/baseModel.php',
			BASE_PATH.'/base/baseUrl.php',
			BASE_PATH.'/base/baseCommoned.php',
			BASE_PATH.'/common/common.php',
			BASE_PATH.'/common/function.php',
		);
	}
	
	/*
	* 获取配置文件
	* @param $name string 需要加载的配置文件文件名
	* @param $option string 配置文件配置项
	*/
	static function getConfig($name,$dir = ''){
		try{
			if(empty($name)) throw new BaseException('请指定一个您需要加载的配置文件');
			$data = loadClass($name,'config',$dir,true);
			if($data) return $data;
			throw new BaseException($name.'.php 文件加载失败!');
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 加载一个驱动文件
	*/
	function getDriver($name,$dir = ""){
		try{
			$status = loadClass(ucfirst($name),'driver',$dir,false);
			if(!$status) throw new BaseException($name.'.php 文件加载失败');
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	function __call($method,$args){
		try{
			$array = array('getLibrary','getHelper','getService','getModel','getController','library','model','helper','service','controller');
			if(in_array($method,$array))
				return BaseCommoned::getInstance()->$method($args);
			else
				throw new BaseException($method.'不存在');
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	function __destruct(){}
}