<?php

defined('IS_SYS') or die('Accessed died');
/*
* 系统关联处理文件
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/

class BaseCommoned{
	
	private static $_instance;
	
	private function __clone(){}
	
	static function getInstance(){
		if( !(self::$_instance instanceof self) )
			self::$_instance = new self;
		return self::$_instance;
	}
	
	/*
	* 实例化加载一个中间服务层
	* @param $name array
	* @return object;
	* example:
	* D::app()->getService('User',$param=array(),'filepath');
	* 三个参数分别是 需要实例化的服务层的名称，传递给构造函数的参数，该服务层在service里面的目录
	* 服务层书写必须和实例化的名称相同 建议首字母大写
	*/
	static function getService($name){
		return self::service($name);
	}
	
	/* getService别名 用法同上 */
	static function service($name){
		try{
			if(!isset($name[0])) throw new BaseException('请指定一个您需要加载的服务类');
			$dir = (isset($name[2])&&!empty($name[2])) ? $name[2] : '';
			$fileName = ucfirst($name[0]).'Service';
			$param = (isset($name[1])&&!empty($name[1])) ? $name[1] : '';
			$status = loadClass($fileName,'service',$dir,true);
			if(!$status) throw new BaseException($fileName.'.php 文件不存在!');
			return new $fileName($param);
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 获取一个模型
	* @param $name array
	* @return object
	* example:
	* D::app()->getModel('User','Users');
	* 该方法两个参数分别是： 需要加载的模型 第二个是模型文件所在的目录
	*/
	static function getModel($name){
		return self::model($name);
	}
	
	static function model($name){
		try{
			if(!isset($name[0])) throw new BaseException('请指定一个您需要加载的模型!');
			$dir = isset($name[1]) && !empty($name[1]) ? $name[1] : '';
			$fileName = ucfirst($name[0]).'Model';
			$status = loadClass($fileName,'model',$dir,true);
			if(!$status) throw new BaseException($fileName.'.php 文件不存在!');
			return new $fileName;
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 获取一个控制器
	* @param $name string 需要获取的控制器的名称不含Controller
	* @return object
	*/
	static function getController($name){
		return self::controller($name);
	}
	
	static function controller($name){
		try{
			if(!isset($name)) throw new BaseException('请指定一个需要加载的Controller');
			$init = isset($name[1])&&!empty($name[1]) ? false : true;
			$fileName = ucfirst($name[0]).'Controller';
			$status = loadClass($fileName,'controller','',true);
			if(!$status) throw new BaseException($fileName.'.php 文件不存在');
			return $init ?  new $fileName : true;
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 加载一个类库,如果用户自定义类库有则加载用户自定义
	* @param $name array
	* @return object
	* example:
	* D::app()->getLibrary("Image",$config=array());
	* 本函数的两个参数：类文件名以及类名，需要加载到构造函数的配置信息
	*/
	static function getLibrary($name){
		return self::library($name);
	}
	
	static function library($name){
		try{
			if(!isset($name[0])) throw new BaseException('请指定一个您需要加载的类');
			$fileName = ucfirst($name[0]);
			$dir = isset($name[2]) && !empty($name[2]) ? $name[2] : '';
			$param = isset($name[1]) && !empty($name[1]) ? $name[1] : '';
			$status = loadClass($fileName,'library',$dir,true);
			!$status && $status = loadClass($fileName,'library',$dir,false);
			if(!$status) throw new BaseException($fileName.'.php 文件不存在');
			$init = isset($name[3]) && !empty($name[3]) ? true : false;
			return $init ? true : new $fileName($param);
		}catch(BaseException $e){
			$e->showError();
		}
	}
	/*
	* 加载一个函数文件
	* @param $name string
	* @return void;
	* example:
	* D::app()->getHelper("url");
	* D::app()->getHelper("url","test");//加载多个函数
	* 之后便可以使用Url.php中的函数了
	*/
	static function getHelper($name){
		self::helper($name);
	}
	
	static function helper($name){
		try{
			if(!isset($name)) throw new BaseException('请指定一个您需要加载的函数文件');
			if(is_string($name)){
				$fileName = strtolower($name);
				$status = loadClass($fileName,'helper','',true);
				!$status && $status = loadClass($fileName,'helper','',false);
				if(!$status) throw new BaseException($fileName.'.php 文件不存在');
			}
			if(is_array($name)){
				foreach($name as $v) self::helper($v);
				unset($name,$v);
			}
		}catch(BaseException $e){
			$e->showError();
		}
	}
	function __destruct(){}
}