<?php

defined('IS_SYS') or die('Accessed died');
/*
* 系统基类文件
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/
class BaseController{
	
	public $load;
	
	function __construct(){
		$this->load = D::app();
		$this->load->getDriver('Template','tpl');
	}
	
	protected function display($file,$cache = false,$cacheid = "",$expire = 3600){
		$file = empty($file) ? $_GET['_controller'] .'/'.$_GET['_action']: $file;
		Template::run()->display($file,$cache,$cacheid,$expire);
	}
	
	protected function assign($name,$value){
		return Template::run()->assign($name,$value);
	}
	
	protected function tplCache($file,$cacheid=''){
		return Template::run()->checkCache($file,$cacheid);
	}
	/**
	* 是否是POST请求
	* @access protected
	* @return bool
	*/
	protected function isPost(){
		return $_SERVER['REQUEST_METHOD'] == 'POST';
	}
	
	/**
	 * 是否AJAX请求
	 * @access protected
	 * @return bool
	 */
	protected function isAjax() {
		if(isset($_SERVER['HTTP_X_REQUESTED_WITH']) ) {
			if('xmlhttprequest' == strtolower($_SERVER['HTTP_X_REQUESTED_WITH'])) return true;
		}
		return false;
	}
	
	/**
	 * 判断是否SSL协议
	 * @return boolean
	 */
	protected function is_ssl() {
		if(isset($_SERVER['HTTPS']) && ('1' == $_SERVER['HTTPS'] || 'on' == strtolower($_SERVER['HTTPS'])))
			return true;
		elseif(isset($_SERVER['SERVER_PORT']) && ('443' == $_SERVER['SERVER_PORT'] )) 
			return true;
		return false;
	}

	function __set($name,$value) {
		$this->assign($name,$value);
	}
	
	/*
	* 用魔术方法如果打开一个不存在的URL时
	* 如果存在_empty方法调用_empty方法 否则显示404
	*/
	function __call($method,$arg=array()) {
		if(method_exists($_GET['_controller'].'Controller','_empty'))
			$this->_empty($method,$arg=array());
		else
			show404();
	}
	
	/**
	 * Ajax方式返回数据到客户端
	 * @access protected
	 * @param mixed $data 要返回的数据
	 * @param String $type AJAX返回数据格式
	 * @return void
	 */
	protected function ajaxReturn($data,$type='json') {
		switch (strtoupper($type)){
			case 'JSON' :
				// 返回JSON数据格式到客户端 包含状态信息
				header('Content-Type:application/json; charset=utf-8');
				exit(json_encode($data));
			case 'XML'  :
				// 返回xml格式数据
				header('Content-Type:text/xml; charset=utf-8');
				exit(xmlEncode($data));          
			default     :
				// 返回可执行的js脚本
				header('Content-Type:text/html; charset=utf-8');
				exit($data);
		}
	}
	
	/*
	* script 弹出框
	* @param $msg string 需要弹出的提示信息
	* @param $url string 需要跳转的网址
	*/
	protected function alert($msg,$url = ''){
		if(empty($url))
			echo "<script> alert('{$msg}');history.go(-1);</script>";
		else
			echo "<script> alert('{$msg}');window.location.href = '{$url}';</script>";
		exit;
	}
}