<?php
	/*
	* 系统异常处理类
	* @autor: fuwei
	*/
	class BaseException extends Exception{
		
		public $message;
		
		public $log;
		
		public function __construct($message="",$log = false){
			$this->message = empty($message) ? $this->getMessage() : $message;
			$this->log = $log;
		}
		
		/*
		* 打印友好错误信息
		*/
		public function showError(){
			$error = "";
			$error .= "<div style='width: 800px; height: auto; font-size: 14px; overflow: hidden; border: 1px solid #333; margin: 20px auto;'>";
			$error .= "<div style='width: 790px; height: 25px; line-height: 25px; border-bottom: 1px solid #333; padding-left: 10px;'><strong>The Error Page</strong></div>";
			$error .= "<div style='width: 790px; height: 25px; color: blue; line-height: 25px; padding-left: 10px;'>The Error Message: ".$this->message."</div>";
			$error .= "<div style='width: 790px; height: 25px; color: blue; line-height: 25px; padding-left: 10px;'>The Error Files: ".basename($this->getFile())."</div>";
			$error .= "<div style='width: 790px; height: 25px; color: blue; line-height: 25px; padding-left: 10px;'>The Error Lines: ".$this->getLine()."</div>";
			$error .= "<div style='width: 790px; height: 25px; color: blue; line-height: 25px; padding-left: 10px;'>The Error Code: ".$this->getCode()."</div></div>";
			if(DEBUG){
				if($this->log || LOG ) $this->writelog();
				echo $error;exit;
			}else{
				if( LOG ) $this->writelog();
				show404();
			}
		}
		
		/*
		* 将错误写入日志
		*/
		public function writeLog(){
			$logInfo = " The Error Message: ".$this->message."\n File: ".$this->getFile()."\n Line: ".$this->getLine()."\n Code: ".$this->getCode()."\n time: ".date('Y-m-d H:i:s',TIME)."\n\r";
			$logPath = APP_PATH.'log/'.date('Ymd',TIME).'.log';
			@file_put_contents($logPath,$logInfo,FILE_APPEND);
		}
		
		public function __destruct(){
			unset($this->message,$this->log);
		}
	}