<?php

defined('IS_SYS') or die('Accessed died');
/*
* 系统基类文件
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/

class BaseModel{
	
	private static $_instance;
	
	private $config;
	
	public $table = "";
	
	public $link;
	
	/*
	* 表前缀
	*/
	private $pre;
	
	private function __clone(){}
	
	static function getInstance($db = ""){
		if( !(self::$_instance instanceof self) )
			self::$_instance = new self($db);
		return self::$_instance;
	}
	
	function __construct($db = ""){
		$config = D::app()->getConfig("database");
		$this->config = empty($db) ? $config['default'] : $config[$db];
		D::app()->getDriver($this->config['driver'],'db');
		$this->link = self::run($this->config);
		$this->pre = $this->config['prefix'];
	}
	
	function run($config){
		switch(strtolower($config['driver'])){
			case 'mysql': return Mysql::getInstance($config); break;
			case 'sqlite': return Sqlite::getInstance($config); break;
			default: return false; break; 
		}
	}
	
	/*
	* 查询多条数据
	* @access protected
	* @param $data string/array
	* @param $table string
	* @return void;
	*/
	function select($data = array(),$table = ""){
		if(is_array($data)){
			$sql = $this->_execSql($data,$table);
		}else{
			$sql = $data;
			if(!empty($table))
				str_replace("{table}",$this->pre.$table,$sql);
			else
				str_replace("{table}",$this->pre.$this->table,$sql);
		}
		return $this->link->getSelect($sql);
	}
	
	/*
	* 查询语句解析
	* @access private
	* @param $data array 需要解析的数据
	* @param $table string 数据表名
	* @return string
	*/
	private function _execSql($data = array(),$table){
		if(!empty($data)){
			$sql = "SELECT ";
			$sql .= (isset($data['field']) && trim($data['field']) !== "") ? trim($data['field']) : "*";
			$sql .= " FROM `";
			$sql .= empty($table) ? $this->pre.$this->table."`" : $this->pre.$table."`";
			if(isset($data['where'])){
				if(is_string($data['where']))
					$sql .= (trim($data['where']) == "") ? "" : " WHERE ".trim($data['where']);
				else
					$sql .= " WHERE ".$this->_execWhere($data['where']);
			}
			if(isset($data['group']) && trim($data['group']) !== "")
				$sql .= " GROUP BY ".trim($data['group']);
			if(isset($data['order']) && trim($data['order']) !== "")
				$sql .= " ORDER BY ".trim($data['order']);
			if(isset($data['having']) && trim($data['having']) !== "")
				$sql .= " HAVING ".trim($data['having']);
			if(isset($data['limit']) && trim($data['limit']) !== "")
				$sql .= " LIMIT ".trim($data['limit']);
		}else{
			$sql = "SELECT * FROM `";
			$sql .= empty($table)? $this->pre.$this->table."`" : $this->pre.$table."`";
		}
		return $sql;
	}
	
	/*
	* 查询一条数据
	* @access protected
	* @param $data array/string
	* @param $table string
	* @return void;
	*/
	function find($data = array(),$table = ""){
		if(is_array($data)){
			if(isset($data['limit'])) unset($data['limit']);
			$data['limit'] = 1;
			$sql = $this->_execSql($data,$table);
		}else{
			$sql = $data;
			if(!empty($table))
				str_replace("{table}",$this->pre.$table,$sql);
			else
				str_replace("{table}",$this->pre.$this->table,$sql);
		}
		return $this->link->getFind($sql);
	}
	
	/*
	* 查询指定数据在数据表中是否存在
	* @access public
	* @param $where string/array 需要查询的条件
	*/
	function search($where,$table = ''){
		$where = $this->_execWhere($where);
		$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
		$sql = "SELECT 1 FROM `{$table}` WHERE {$where} limit 1";
		return $this->link->getFind($sql);
	}
	
	/*
	* 执行一条原生的SQL语句
	* @param $sql string 需要执行的SQL语句
	* @param $table string 需要操作的表
	* @return bool;
	*/
	function query($sql,$table = ""){
		if(empty($sql)) return false;
		if(!empty($table))
			str_replace("{table}",$this->pre.$table,$sql);
		else
			str_replace("{table}",$this->pre.$this->table,$sql);
		if($this->link->getQuery($sql))
			return true;
		else
			return false;
	}
	/*
	* 插入一条数据
	* @access protected
	* @param $data array 需要插入的数据的数组
	* @param $table string 定义的数据表
	* @return void;
	*/
	function insert($data = array(),$table = ""){
		if(!is_array($data) || empty($data) ) return false;
		$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
		$sql = "INSERT INTO `{$table}` ".$this->_exceData($data,'add');
		return $this->link->getInsert($sql);
	}
	
	/*
	* 插入多条数据
	* @access public
	* @param $data array 需要插入的数据 必须是一个结构一致的二维数组
	* @param $table string 定义的数据表
	* @for example:
	* $data = array(
	*	array('name'=>'fuwei','age'=>25),
	*   array('name'=>'zhangsan','age'=>26)
	*);
	*/
	function insertBatch($data = array(),$table = ""){
		if(is_array($data)){
			$insert = "";
			foreach($data as $val){
				$d=array();
				$d['key']="";
				$d['value']="";
				foreach($val as $key=>$value){
					$d['key'].="`$key`,";
					$d['value'].="'$value',";
				}
				$d['key']=substr($d['key'], 0,-1);//去除后面的逗号
				$d['value']=substr($d['value'], 0,-1);//去除后面的逗号
				$insert .= empty($insert) ? " (".$d['key'].") VALUES (".$d['value'].") " : ",(".$d['value'].")";
			}
			unset($data,$val,$key,$value,$d);
			$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
			$sql = "INSERT INTO `{$table}` ".$insert;
			return $this->link->getInsert($sql);
		}
	}
	
	/*
	* 替换插入
	*/
	function replace($data = array(),$table = ''){
		if(!is_array($data) || empty($data) ) return false;
		$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
		$sql = "REPLACE INTO `{$table}` ".$this->_exceData($data,'add');
		return $this->link->getInsert($sql);
	}
	
	/*
	* 更新一条数据
	* @access protected
	* @param $data array 需要修改的数据
	* @param $where array/string 条件
	* @return void
	*/
	function update($data,$where,$table = ""){
		try{
			$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
			if(is_array($data))
				$data = $this->_exceData($data,'save');
			else
				throw new BaseException("the update data must is a array");
			$where = $this->_execWhere($where);
			$sql = "UPDATE `{$table}` SET {$data} WHERE {$where}";
			return $this->link->getUpdate($sql);
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 批量更新数据
	* @access public
	* @param $values array 需要更新的数据
	* @param $index string 关联条件
	* @param $table string 需要更新的表
	* @param $where array/string  附加的其他条件
	* $data = array( array('id'=>1,'age'=>25),array('id'=>2,'age'=>28));
	* $this->updateBatch($data,'id','mytable',array('gid'=>1));
	*/
	function updateBatch($values, $index, $table, $where = NULL){
		$ids = array();
		$where = ($where != '' AND count($where) >=1) ? $this->_execWhere($where) .' AND ' : '' ;
		foreach ($values as $key => $val){
			$ids[] = $val[$index];
			foreach (array_keys($val) as $field) if ($field != $index) $final[$field][] =  'WHEN `'.$index.'` = '.$val[$index].' THEN '.$val[$field];
		}
		$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
		$sql = "UPDATE `".$table."` SET ";
		$cases = '';
		foreach ($final as $k => $v){
			$cases .= '`'.$k.'` = CASE '."\n";
			foreach ($v as $row) $cases .= $row."\n";
			$cases .= 'ELSE `'.$k.'` END, ';
		}
		$sql .= substr($cases, 0, -2);
		$sql .= ' WHERE '.$where.$index.' IN ('.implode(',', $ids).')';
		return $this->link->getUpdate($sql);
	}
	/*
	* 删除数据
	* @access protected
	* @param $where array/string
	* @param $table string
	* @return void
	*/
	function delete($where,$table = ""){
		$where = $this->_execWhere($where);
		$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
		$sql = "DELETE FROM `{$table}` WHERE {$where}";
		return $this->link->getDelete($sql);
	}
	
	/*
	* 数据表加一
	* @access protected
	* @param $where array/string
	* @param $field array key为表名 value为需要加的值 比如给score加10  那么就是$field['scroe'] = 10;
	* @return void;
	*/
	function setInc($field,$where,$table = ""){
		if(!is_array($field)) return false;
		$str = '';
		foreach($field as $key => $value)
			$str .= empty($str) ? "`{$key}` = `{$key}`+{$value}" : ", `{$key}` = `{$key}`+{$value}";
		$where = $this->_execWhere($where);
		$table = empty($table) ? $this->pre.$this->table : $this->pre.$table;
		$sql = "UPDATE `{$table}` SET {$str} WHERE {$where}";
		return $this->link->getUpdate($sql);
	}
	
	/*
	* 统计数据的条数
	* @access protected
	*/
	function count($data = array(),$table = ""){
		if(is_array($data)){
			$sql = $this->_execSql($data,$table);
		}else{
			$sql = $data;
			if(!empty($table))
				str_replace("{table}",$this->pre.$table,$sql);
			else
				str_replace("{table}",$this->pre.$this->table,$sql);
		}
		return $this->link->getCount($sql);
	}
	/*
	* where 条件解析
	* @param $where array/string
	* @return string
	*/
	private function _execWhere($where){
		try{
			if(is_array($where)){
				$updateWhere  = "";
				foreach($where as $key=>$value) $updateWhere .= empty($updateWhere) ? "`{$key}` = '{$value}'" : "AND `{$key}` = '{$value}'";
			}elseif(is_string($where)){
				$updateWhere = $where;
			}else{
				throw new BaseException("the sql where must a string or array");
			}
			unset($key,$value,$where);
			return $updateWhere;
		}catch(BaseException $e){
			$e->showError();
		}
	}
	/*
	* 数据解析
	* @access private
	* @param $paramData array 需要解析的数组 将数组解析成数据SQL的形式
	* @param $type string 是更新时候解析数据还是增加时候解析数据
	* @return string 返回解析后的字符串
	*/
	private function _exceData($paramData, $type ){		
		switch($type){
			case 'add':
				$data=array();
				$data['key']="";
				$data['value']="";
				foreach($paramData as $key=>$value){
					$data['key'].="`$key`,";
					$data['value'].="'$value',";
				}
				$data['key']=substr($data['key'], 0,-1);//去除后面的逗号
				$data['value']=substr($data['value'], 0,-1);//去除后面的逗号
				unset($paramData);	//清空$this->options['data']数据
				return " (".$data['key'].") VALUES (".$data['value'].") ";
				break;
			case 'save':
				$data="";
				foreach($paramData as $key=>$value) $data.="`$key` = '$value',";
				$data=substr($data, 0,-1);	//去除后面的逗号
				unset($paramData);
				return $data;
				break;
			default:
				unset($paramData);	
				return false;
		}	
	}
	
	/**
	* 数据表前缀
	**/
	function table($table){
		return $this->pre.$table;
	}
	
	function __destruct(){
		unset($this->pre,$this->config,$this->link,$this->table);
	}
}
