<?php

defined('IS_SYS') or die('Accessed died');
/*
* 系统基类文件
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/

class BaseUrl{
	
	private static $controller;
	
	private static $action;
	
	private static $_instance;
	
	private static $config;
	
	function __construct(){
		self::$config = D::app()->getConfig('config');
	}
	
	static function app(){
		if( !(self::$_instance instanceof self) )
			self::$_instance = new self();
		return self::$_instance;
	}
	
	
	static function run(){
		try{
			self::_url();
			$_GET['_controller'] = self::$controller;
			$_GET['_action'] = self::$action;
			$className = self::$controller.'Controller';
			loadClass($className,'controller','',true);
			if(!class_exists($className)) throw new BaseException($className . '类未定义');
			$methodName = self::$action;
			$obj = new $className;
			$obj->$methodName();
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	private static function _url(){
		$config = self::$config;
		$script_name = $_SERVER["SCRIPT_NAME"];
		$url = $_SERVER['REQUEST_URI'];
		//去除script_name
		if($url && @strpos($url , $script_name,0) !== false){
			$url = substr($url , strlen($script_name));
		}else{
			$script_name = str_replace(basename($_SERVER['SCRIPT_NAME']),'',$_SERVER['SCRIPT_NAME']);
			if( $url && @strpos($url, $script_name, 0) !== false ) $url = substr($url, strlen($script_name));
		}
		if( $url[0] == '/' ) $url = substr($url,1);
		//如果后面有?去掉
		if( $url && false !== ($pos = @strrpos($url , '?')) ) $url = substr($url , 0 , $pos);
		//去除后缀
		if( $url && false !==($pos = @strrpos($url , '.')) ) $url = substr($url, 0, $pos);
		$param = explode('/',$url);
		$param_count = count( $param );
		for($i = 0; $i<$param_count; $i= $i+2){
			$_GET[$i] = $param[$i];
			if( isset($param[$i+1])){
				if( !is_numeric( $param[$i] ) ) $_GET[$param[$i]] = $param[$i+1];
				$_GET[$i+1] = $param[$i+1];
			}
		}
		self::$controller=isset($_GET[0])&&!empty($_GET[0])?ucfirst($_GET[0]): 'Index';
		self::$action = isset($_GET[1]) && !empty($_GET[1]) ? $_GET[1] : 'index';
	}
	
	static function _base_url(){
		self::$controller = isset($_GET['c']) && !empty($_GET['c']) ? $_GET['c'] : 'Index';
		self::$action = isset($_GET['a']) && !empty($_GET['a']) ? $_GET['a'] : 'index';
	}
	
	function __destruct(){}
}