<?php

defined('IS_SYS') or die('Accessed died');

/**
* 系统函数库
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/

/**
* 浏览器友好的变量输出
* @param mixed $var 变量
* @param boolean $echo 是否输出 默认为True 如果为false 则返回输出字符串
* @param string $label 标签 默认为空
* @param boolean $strict 是否严谨 默认为true
* @return void|string
*/
function dump($var, $echo=true, $label=null, $strict=true) {
	$label = ($label === null) ? '' : rtrim($label) . ' ';
	if (!$strict) {
		if (ini_get('html_errors')) {
			$output = print_r($var, true);
			$output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
		} else {
			$output = $label . print_r($var, true);
		}
	} else {
		ob_start();
		var_dump($var);
		$output = ob_get_clean();
		if (!extension_loaded('xdebug')) {
			$output = preg_replace('/\]\=\>\n(\s+)/m', '] => ', $output);
			$output = '<pre>' . $label . htmlspecialchars($output, ENT_QUOTES) . '</pre>';
		}
	}
	if ($echo) {
		echo($output);
		return null;
	}else
		return $output;
}

/*
* 对数据进行过滤
* @param $data string/array 需要进行的过滤的数据
* @param $force boolean 是否忽略get_magic_quotes_gpc
*/
function dataIn($data,$force = false){
	if(is_string($data)){
		$data=trim(htmlspecialchars($data));//防止被挂马，跨站攻击
		if(($force==true)||(!get_magic_quotes_gpc())) 
		   $data = addslashes($data);//防止sql注入
		return  $data;
	} else if(is_array($data)) {
		foreach($data as $key=>$value) $data[$key]=dataIn($value,$force);
		return $data;
	} else {
		return $data;
	}	
}

/*
* 对数据进行还原
* @param $data string/array 待还原数据
*/
function dataOut($data){
	if(is_string($data)){
		return $data = stripslashes($data);
	} else if(is_array($data)){
		foreach($data as $key=>$value) $data[$key]=dataOut($value);
		return $data;
	} else {
		return $data;
	}	
}

/*
* 404
*/
function show404($url = ""){
	if(empty($url))
		exit("404 Not Found");
	else
		redirect($url);
}

/**
 * URL重定向
 * @param string $url 重定向的URL地址
 * @param integer $time 重定向的等待时间（秒）
 * @param string $msg 重定向前的提示信息
 * @return void
 */
function redirect($url, $time=0, $msg='') {
	if (empty($msg)) $msg    = "系统将在{$time}秒之后自动跳转到{$url}！";
	if (!headers_sent()) {
		// redirect
		if (0 === $time) {
			header('Location: ' . $url);
		} else {
			header("refresh:{$time};url={$url}");
			echo($msg);
		}
		exit();
	} else {
		$str    = "<meta http-equiv='Refresh' content='{$time};URL={$url}'>";
		if ($time != 0) $str .= $msg;
		exit($str);
	}
}

/*
* 系统缓存函数
*/
function cache($key,$value = "",$driver = "memcaches"){
	static $cache;
	$config = D::app()->getConfig('cache');
	if($driver == "memcaches" && !class_exists("Memcache")) $driver = "FileCache";
	switch(strtolower($driver)){
		case 'sqlite':
			D::app()->getDriver('SqliteCache','cache');
			$cache = SqliteCache::getInstance($config['SqliteCache']);
			break;
		case 'memcaches':
			D::app()->getDriver('Memcaches','cache');
			$cache = Memcaches::getInstance($config['Memcache']);
			break;
		/*
		case 'memcached':
			D::app()->getDriver('Memcached','cache');
			$cache = Memcached::getInstance($config['Memcached']);
			break;
		*/
		default:
			D::app()->getDriver('FileCache','cache');
			$cache = FileCache::getInstance($config['FileCache']);
			break;
	}
	if(is_null($value)) return $cache->del($key);
	if(!empty($value)){
		$cache->set($key,$value);
		return $cache->get($key);
	}else{
		return $cache->get($key);
	}	
}

/*
* url重装
* @param $param 需要组装的URL地址
* @param $data 参数
* @return string
*/
function url($param = "",$data = array()){
	$config = D::app()->getConfig('config');
	$url = "";
	$baseUrl = baseUrl();
	$page = empty($config['page']) ? "" : trim($config['page'],'/').'/';
	$url .= rtrim($baseUrl,'/').'/'.$page;
	$url .= empty($param) ? "index/index" : trim($param,'/');
	if(empty($data)){
		$url .= $config['urlFix'];
	}else{
		try{
			if(is_array($data)){
				$urlParam = "";
				foreach($data as $key => $value) $urlParam .= "/{$key}/{$value}";
				unset($data,$key,$value);
				$url .= $urlParam.$config['urlFix'];
			}else{
				throw new BaseException("the url data must a array data");
			}
		}catch(BaseException $e){
			$e->showError();
		}
	}
	return $url;
}

/*
* 基于网站根域名来访问
* @param $param string 传递的基于根目录的文件路径
*/
function baseUrl($param = ""){
	if(!is_string($param)) return false;
	$config = D::app()->getConfig('config');
	$baseUrl = empty($config['baseUrl']) ? $_SERVER['SCRIPT_NAME'] : $config['baseUrl'];
	$baseUrl = rtrim($baseUrl,'/').'/'.ltrim($param,'/');
	return $baseUrl;
}

/*
* 全局使用基础模型文件
* @param $db string 需要操作的数据库驱动 默认为default
*/
function getBaseModel($db = "default"){
	return BaseModel::getInstance($db);
}

/*
* 加载文件
* @param $fileName string  需要加载的文件的名称不含PHP后缀
* @param $type string 加载的类型 helper,controller,model,service,library
* @param $dir string 文件所在的目录
* @param $system bool 是否是框架系统目录 true 用户APP目录 false系统目录
*/
function loadClass($fileName,$type='controller',$dir = '',$system = false){
	$sysPath = $system ? APP_PATH : BASE_PATH.'/';
	$dir = empty($dir) ? '' : $dir.'/';
	switch(strtolower($type)){
		case 'controller': $path = $sysPath.'controller/'.$dir.$fileName.'.php'; break;
		case 'model': $path = $sysPath.'model/'.$dir.$fileName.'.php'; break;
		case 'service': $path = $sysPath.'service/'.$dir.$fileName.'.php'; break;
		case 'helper': $path = $sysPath.'helper/'.$dir.$fileName.'.php'; break;
		case 'library': $path = $sysPath.'library/'.$dir.$fileName.'.php'; break;
		case 'config': $path = $sysPath.'config/'.$dir.$fileName.'.php'; break;
		case 'driver': $path = $sysPath.'driver/'.$dir.$fileName.'.php'; break;
	}
	if(file_exists($path)){
		if($type == 'config')
			return require $path;
		else
			require_once $path;
		return true;
	}
	return false;
}

/*
* 会话SESSION管理
*/
function session($key = '',$value = ''){
	$config = D::app()->getConfig('session');
	$session = D::app()->library('session',$config);
	if(empty($key)){
		$session->destroy();
		return true;
	}
	if(is_null($value)) return $session->delete($key);
	if(!empty($value)){
		$session->set($key,$value);
		return true;
	}else{
		return $session->get($key);
	}	
}