<?php

defined('IS_SYS') or die('Accessed died');

/**
* 功能函数库
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/

/**
 * XML编码
 * @param mixed $data 数据
 * @param string $root 根节点名
 * @param string $item 数字索引的子节点名
 * @param string $attr 根节点属性
 * @param string $id   数字索引子节点key转换的属性名
 * @param string $encoding 数据编码 
 * @return string
 */
function xmlEncode($data, $root='xml', $item='item', $attr='', $id='id', $encoding='utf-8') {
	if(is_array($attr)){
		$_attr = array();
		foreach ($attr as $key => $value) $_attr[] = "{$key}=\"{$value}\"";
		$attr = implode(' ', $_attr);
	}
	$attr   = trim($attr);
	$attr   = empty($attr) ? '' : " {$attr}";
	$xml    = "<?xml version=\"1.0\" encoding=\"{$encoding}\"?>";
	$xml   .= "<{$root}{$attr}>";
	$xml   .= dataToXml($data, $item, $id);
	$xml   .= "</{$root}>";
	return $xml;
}

/**
 * 数据XML编码
 * @param mixed  $data 数据
 * @param string $item 数字索引时的节点名称
 * @param string $id   数字索引key转换为的属性名
 * @return string
 */
function dataToXml($data, $item='item', $id='id') {
	$xml = $attr = '';
	foreach ($data as $key => $val) {
		if(is_numeric($key)){
			$id && $attr = " {$id}=\"{$key}\"";
			$key  = $item;
		}
		$xml    .=  "<{$key}{$attr}>";
		$xml    .=  (is_array($val) || is_object($val)) ? dataToXml($val, $item, $id) : $val;
		$xml    .=  "</{$key}>";
	}
	return $xml;
}

/**
 * 获取客户端IP地址
 * @param integer $type 返回类型 0 返回IP地址 1 返回IPV4地址数字
 * @return mixed
 */
function getUserIp($type = 0) {
	$type       =  $type ? 1 : 0;
	static $ip  =   NULL;
	if ($ip !== NULL) return $ip[$type];
	if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
		$arr    =   explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
		$pos    =   array_search('unknown',$arr);
		if(false !== $pos) unset($arr[$pos]);
		$ip     =   trim($arr[0]);
	}elseif (isset($_SERVER['HTTP_CLIENT_IP'])) {
		$ip     =   $_SERVER['HTTP_CLIENT_IP'];
	}elseif (isset($_SERVER['REMOTE_ADDR'])) {
		$ip     =   $_SERVER['REMOTE_ADDR'];
	}
	// IP地址合法验证
	$long = sprintf("%u",ip2long($ip));
	$ip   = $long ? array($ip, $long) : array('0.0.0.0', 0);
	return $ip[$type];
}

/*
* 将数组转换为字符串
* @param $Array array 需要转换的数组
* @return string
*/
function Array2String($Array){
    $Return='';
    $NullValue="^^^";
    foreach ($Array as $Key => $Value) {
        if(is_array($Value))
            $ReturnValue='^^array^'.Array2String($Value);
        else
            $ReturnValue=(strlen($Value)>0)?$Value:$NullValue;
        $Return.=urlencode(base64_encode($Key)) . '|' . urlencode(base64_encode($ReturnValue)).'||';
    }
    return urlencode(substr($Return,0,-2));
}

// convert a string generated with Array2String() back to the original (multidimensional) array
// usage: array String2Array ( string String)

/*
* 将字符串转换为数组
* @param $String string 需要转换的字符串
* @return array
*/
function String2Array($String){
    $Return=array();
    $String=urldecode($String);
    $TempArray=explode('||',$String);
    $NullValue=urlencode(base64_encode("^^^"));
    foreach ($TempArray as $TempValue) {
        list($Key,$Value)=explode('|',$TempValue);
        $DecodedKey=base64_decode(urldecode($Key));
        if($Value!=$NullValue) {
            $ReturnValue=base64_decode(urldecode($Value));
            if(substr($ReturnValue,0,8)=='^^array^')
                $ReturnValue=String2Array(substr($ReturnValue,8));
            $Return[$DecodedKey]=$ReturnValue;
        }
        else
        $Return[$DecodedKey]=NULL;
    }
    return $Return;
}

/*
* 生成唯一的订单号
*/
function BuildOrderSn(){
	return date('Ymd').substr(implode(NULL, array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
}

/*
* 无限极分类解析
*/
function formatTree($array, $pid = 0){
	$arr = array();
	$tem = array();
	foreach ($array as $v) {
		if ($v['pid'] == $pid) {
			$tem = formatTree($array, $v['id']);
			//判断是否存在子数组
			$tem && $v['son'] = $tem;
			$arr[] = $v;
		} 
	}
	return $arr;
}

/*
* 去除二维数组中重复的值
*/
function uniqueArray($array2D,$stkeep=false,$ndformat=true)  {  
    // 判断是否保留一级数组键 (一级数组键可以为非数字)  
    if($stkeep) $stArr = array_keys($array2D);  
    // 判断是否保留二级数组键 (所有二级数组键必须相同)  
    if($ndformat) $ndArr = array_keys(end($array2D));  
    //降维,也可以用implode,将一维数组转换为用逗号连接的字符串  
    foreach ($array2D as $v){  
        $v = join(",",$v);   
        $temp[] = $v;  
    }  
    //去掉重复的字符串,也就是重复的一维数组  
    $temp = array_unique($temp);   
    //再将拆开的数组重新组装  
    foreach ($temp as $k => $v){  
        if($stkeep) $k = $stArr[$k];  
        if($ndformat)  
        {  
            $tempArr = explode(",",$v);   
            foreach($tempArr as $ndkey => $ndval) $output[$k][$ndArr[$ndkey]] = $ndval;  
        }  
        else $output[$k] = explode(",",$v);   
    }  
    return $output;  
}

/*
* 1.uri - base64创建数据
* @param $file string 文件路径含文件名
* @param $mime 文件类型
* $mime: 'image/gif', 'image/jpeg', 'image/png',
         'application/x-shockwave-flash', 'image/psd', 'image/bmp',
         'image/tiff', 'image/tiff', 'application/octet-stream',
         'image/jp2', 'application/octet-stream', 'application/octet-stream',
         'application/x-shockwave-flash', 'image/iff', 'image/vnd.wap.wbmp', 'image/xbm'
*/

function dataUri($file) {
	$contents=file_get_contents($file);
	$base64=base64_encode($contents);
	$mime = getMime($file);
	return "data:$mime;base64,$base64";
}

function getMime($file){
	$mime = getimagesize( $file );
	return $mime['mime'];
}

/*
* 4.下载远程图片
* @param $uri string 远程图片的地址
* @param $filepath string 保存图片的路径
*/
function getImage($uri,$filepath){
	$image = file_get_contents($uri);
	file_put_contents($filepath, $image); //Where to save the image
}

/*
* Curl函数操作
*/
function setCurl($url,$data=array(),$method = "POST",$header = ""){
	if(empty($url)) return false;
	$data = http_build_query($data);
	$method = strtoupper($method);
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
	curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
	if(!empty($header)) curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
	curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (compatible; MSIE 5.01; Windows NT 5.0)');
	curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
	curl_setopt($ch, CURLOPT_AUTOREFERER, 1);
	if(!empty($data)) curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	$tmpInfo = curl_exec($ch);
	curl_close($ch);
	return $tmpInfo;
}

//中文字符串截取
function msubstr($str, $start=0, $length, $charset="utf-8", $suffix=true){
	switch($charset){
		case 'utf-8':$char_len=3;break;
		case 'UTF8':$char_len=3;break;
		default:$char_len=2;
	}
	//小于指定长度，直接返回
    if(strlen($str)<=($length*$char_len)) return $str;
	if(function_exists("mb_substr")){   
	 	$slice= mb_substr($str, $start, $length, $charset);
	} else if(function_exists('iconv_substr')){
        $slice=iconv_substr($str,$start,$length,$charset);
    } else { 
	   $re['utf-8']   = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
		$re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
		$re['gbk']    = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
		$re['big5']   = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
		preg_match_all($re[$charset], $str, $match);
		$slice = join("",array_slice($match[0], $start, $length));
	}
    if($suffix) return $slice."…";
    return $slice;
}

/*
* 计算中文字符串长度 一个中文为一个单位
* @param $str string 需要计算的字符串
* @return int 长度
*/
function cnStrLen($str){
	$encode = mb_detect_encoding($str, array("ASCII","UTF-8","GB2312","GBK","BIG5"));
	//将编码全部转换为UTF8计算
	$str = @iconv($encode,"UTF-8",$str);
	// 将字符串分解为单元
	preg_match_all("/./us", $str, $match);
	// 返回单元个数
	return (int) count($match[0]);
}

/*
* 获取一个唯一值
*/
function unquie(){
	return time().substr(implode(NULL, array_map('ord', str_split(substr(uniqid(), 7, 13), 1))), 0, 8);
}

function get($name){
	return isset($_GET[$name]) ? $_GET[$name] : false;
}

function post($name){
	return isset($_POST[$name]) ? $_POST[$name] : false;
}

/*
* 加载JS文件
*/
function loadJs($file,$dir = '/static/'){
	if(!is_array($file)) return false;
	foreach($file as $v){
		$js = baseUrl( trim($dir,'/').'/'.$v.'.js' );
		echo "<script src = '{$js}' ></script>";
	}
	unset($v);
}

/*
* 动态加载CSS文件
*/
function loadCss($file,$dir = '/static/'){
	if(!is_array($file)) return false;
	foreach($file as $v){
		$css = baseUrl( trim($dir,'/').'/'.$v.'.css' );
		echo "<link rel='stylesheet' type='text/css' href='{$css}' />";
	}
	unset($v);
}