<?php

defined("IS_SYS") or die("Accessed died");

class Memcached {
	
	private $mmc = NULL;
    
	private $group = ''; 
    
	private $ver = 0;
    
	private static $_instance;
	
	private function __construct( $memConfig = array() ) {
		$this->mmc = new Memcached();
		if( empty($memConfig) ) {
			$memConfig['memServer'] = array(array('127.0.0.1', 11211));
			$memConfig['memGroup'] = '';
		}
		//$this->mmc->addServer('localhost', 11211);
		
		foreach($memConfig['memServer'] as $config) {
			call_user_func_array(array($this->mmc, 'addServer'), $config);
		}
		
		$this->group = $memConfig['memGroup'];
		$this->ver = intval( $this->mmc->get($this->group.'_ver') );
    }
	
	public function __clone(){}
	
	public static function getInstance($config = array()){
		if( !(self::$_instance instanceof self) ){
			self::$_instance = new self($config);
		}
		return self::$_instance;
	}
	
	//读取缓存
    public function get($key) {
		return $this->mmc->get($this->group.'_'.$this->ver.'_'.$key);
    }
	
	//设置缓存
    public function set($key, $value, $expire = 1800) {
		return $this->mmc->set($this->group.'_'.$this->ver.'_'.$key, $value, $expire);
    }
	
	//自增1
	public function inc($key, $value = 1) {
		 return $this->mmc->increment($this->group.'_'.$this->ver.'_'.$key, $value);
    }
	
	//自减1
	public function des($key, $value = 1) {
		 return $this->mmc->decrement($this->group.'_'.$this->ver.'_'.$key, $value);
    }
	
	//删除
	public function del($key) {
		return $this->mmc->delete($this->group.'_'.$this->ver.'_'.$key);
	}
	
	//全部清空
    public function clear() {
        return  $this->mmc->set($this->group.'_ver', $this->ver+1); 
    }	
}