<?php

defined("IS_SYS") or die("Accessed died");

/*
* sqlite 数据库缓存类
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
* CREATE TABLE "cache_data" ("cacheid" INTEGER PRIMARY KEY AUTOINCREMENT, "cachekey" VARCHAR, "cachevalue" TEXT, "expiretime" SMALLINT)
*/

class SqliteCache{
	
	private static $_instance;
	
	private $config = array();
	
	private $connect;
	
	private function __construct($config){
		$this->config = array(
			'host' => APP_PATH.'cache/sqlite_cache/sqlitecache.dat',
			'cacheTime' => 3600,
		);
		$this->config = array_merge($this->config, (array)$config);
		/*
		* 加载SQLITE数据库驱动文件
		*/
		D::app()->getDriver("Sqlite","db");
		$this->connect = Sqlite::getInstance($this->config);
	}
	
	public function __clone(){}
	
	public static function getInstance($config = array()){
		if( !(self::$_instance instanceof self) ){
			self::$_instance = new self($config);
		}
		return self::$_instance;
	}
	
	public function set($key,$value){
		$key = md5($key);
		$value = serialize($value);
		$status = $this->find($key);
		if(false === $status){
			$sql = "INSERT INTO `cache_data`(cachekey,cachevalue,expiretime) VALUES('$key','$value',".TIME.")";
			return $this->connect->getInsert($sql);
		}else{
			$sql = "UPDATE `cache_data` SET `cachevalue`='$value',`expiretime`=".TIME." WHERE `cachekey`='$key'";
			return $this->connect->getUpdate($sql);
		}
	}
	
	public function find($key){
		$sql = "SELECT cachevalue,expiretime FROM `cache_data` WHERE `cachekey`='$key' LIMIT 1";
		$search = $this->connect->getFind($sql);
		return $search;
	}
	
	public function get($key){
		$key = md5($key);
		$status = $this->find($key);
		if(false === $status){
			return false;
		}else{
			$cachetime = $this->config['cacheTime'];
			if($cachetime < (time()-$status['expiretime'])){
				$this->delete($key);
				return false;
			}else{
				return unserialize($status['cachevalue']);
			}
		}
	}
	
	public function del($key){
		$key = md5($key);
		return $this->delete($key);
	}
	
	private function delete($key){
		$status = $this->find($key);
		if(false === $status){
			return true;
		}else{
			$sql = "DELETE FROM `cache_data` WHERE `cachekey`='$key'";
			return $this->connect->getDelete($sql);
		}
	}
	
	public function search($key){
		$key = md5($key);
		return $this->Find($key);
	}
	
	public function __destruct(){}
}