<?php

defined("IS_SYS") or die("Accessed died");

/*
* Sqlite数据库驱动文件
* @autor: fuwei <fuweiqs163@163.com>
* @files: Sqlite.php
*/

class Sqlite{
	
	private static $_instance;
	
	private $connect;
	
	private $queryId;
	
	private function __construct($config){
		try{
			if(!file_exists($config['host'])) throw new BaseException("找不到SQLITE数据库：".$config['host']);
			$this->connect = @new PDO( 'sqlite:'.$config['host'] );//连接数据库
		}catch(PDOException $e){
			$e->getMessage();
		}
	}
	
	public function __clone(){}
	
	public static function getInstance($config){
		if( !(self::$_instance instanceof self) ){
			self::$_instance = new self($config);
		}
		return self::$_instance;
	}
	
	/*
	* 查询数据库返回一个queryID
	* @access private
	* @param $sql string
	* @return void;
	*/
	private function query($sql){
		try{
			$this->queryId = $this->connect->query($sql);
			if($this->queryId){
				return $this->queryId;
			}else{
				throw new BaseException("SQL查询错误:".$this->connect->lastErrorMsg);
			}
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 获取上一次插入的ID
	* @access private
	* @return void
	*/
	private function lastInsertId(){
		return (int) $this->connect->lastInsertId();
	}
	
	//开始一个事务
	public function begintrans(){
		return $this->connect->beginTransaction();
	}
	
	//递交一个事务
	public function commit(){
		return $this->connect->commit();
	}
	
	//回滚一个事务
	public function rollback(){
		return $this->connect->rollBack();
	}
	
	/*
	* 查询数据库
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getSelect($sql){
		return $this->query($sql)->fetchAll();
	}
	
	/*
	* 查询一条数据
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getFind($sql){
		return $this->query($sql)->fetch();
	}
	
	/*
	* 统计数据
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getCount($sql){
		return count($this->getSelect($sql));
	}
	
	/*
	* 更新数据
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getUpdate($sql){
		return $this->query($sql);
	}
	
	/*
	* 删除数据
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getDelete($sql){
		return $this->getUpdate($sql);
	}
	
	/*
	* 执行一条原生的SQL
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getQuery($sql){
		return $this->query($sql);
	}
	
	/*
	* 插入数据
	* @access public
	* @param $sql string
	* @return void
	*/
	public function getInsert($sql){
		if($this->query($sql))
			return $this->lastInsertId();
		else
			return false;
	}
	
	/*
	* 关闭连接
	*/
	private function close(){
		if($this->connect) $this->connect = null;
	}
	
	/*
	* 析构函数
	*/
	public function __destruct(){
		$this->close();
	}
}