<?php

defined('IS_SYS') or die('Accessed died');
/*
* 模板驱动文件
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
* @package system
*/
class Template{
	
	public $leftTag = "<!--{"; //左标记
	
	public $rightTag = "}-->"; //右侧标记
	
	public $tAssgin = array();
	
	public $cache = false;
	
	public $expire = 3600;
	
	public static $_instance;
	
	private $cacheId;
	
	public function __clone(){}
	
	public static function run(){
		if( !(self::$_instance instanceof self) )
			self::$_instance = new self();
		return self::$_instance;
	}
	
	/*
	* 标签替换
	* @access private
	* @param $template string 需要替换的内容
	*/
	private function replace($template){
		/**
		* loop 循环替换
		**/
		$template = preg_replace('/'.$this->leftTag.'loop\s+(\S+)\s+(\S+)'.$this->rightTag.'/', '<?php if(is_array(\\1)) foreach(\\1 as \\2) { ?>', $template);
		$template = preg_replace('/'.$this->leftTag.'loop\s+(\S+)\s+(\S+)\s+(\S+)'.$this->rightTag.'/', '<?php if(is_array(\\1)) foreach (\\1 as \\2 => \\3) { ?>', $template);
		$template = preg_replace('/'.$this->leftTag.'\/loop'.$this->rightTag.'/', '<?php } ?>', $template);
		/**
		* if  elseif else 替换
		**/
		$template = preg_replace('/'.$this->leftTag.'if\s+(.+?)'.$this->rightTag.'/', '<?php if (\\1) { ?>', $template);
		$template = preg_replace('/'.$this->leftTag.'elseif\s+(.+?)'.$this->rightTag.'/', '<?php }elseif(\\1){ ?>', $template);
		$template = preg_replace('/'.$this->leftTag.'else'.$this->rightTag.'/', '<?php }else{ ?>', $template);
		$template = preg_replace('/'.$this->leftTag.'\/if'.$this->rightTag.'/', '<?php } ?>', $template);
		/**
		* for  循环替换
		**/
		$template = preg_replace('/'.$this->leftTag.'for\s+(.+?)'.$this->rightTag.'/', '<?php for(\\1) { ?>', $template);
		$template = preg_replace('/'.$this->leftTag.'\/for'.$this->rightTag.'/', '<?php } ?>', $template);
		/**
		* 包含模板 {include header}
		**/
		$template = preg_replace('/'.$this->leftTag.'include\s(.+?)'.$this->rightTag.'/', '<?php \$this->_include(\'$1\'); ?>', $template);
		/**
		* 原生PHP支持 {:}
		**/
		$template = preg_replace('/'.$this->leftTag.':/', '<?php ', $template);
		$search = array($this->leftTag,$this->rightTag);
		$replace = array("<?php echo ","; ?>");
		$template = str_replace($search,$replace,$template);
		return $template;
	}
	
	/*
	* 文件加载
	*/
	public function _include($file){
		try{
			if(@stripos($file,"|") == false){
				$this->display($file);
			}else{
				$file = explode("|",$file);
				if(@stripos($file[1],'=')){
					$arr = explode("=",$file[1]);
					$this->assign($arr[0],$arr[1]);
				}else{
					throw new BaseException('INCLUDE文件时引用ASSIGN错误!');
				}
				$this->display($file[0]);
			}
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* 写入变量
	*/
	public function assign($name,$value = null){
		if(!$name)
			return false;
		if(is_array($name) === true){
			$this->assign($name);
			foreach ($name as $key => $val) $this->assign($key , $val);
		}else{
			if(is_object($value) === false && is_resource($value) === false)
				$this->tAssgin[$name] = $value;
			else
				unset($value);
		}
	}
	
	//display
	public function display($file,$cache = false,$cacheid = "",$expire = 3600){
		try {
			$this->cache = $cache;
			$this->expire = $expire;
			$this->cacheId = $cacheid;
			$this->compile($file);
		} catch (BaseException $e) {
			$e->showError();
		}
		
	}
	
	public function compile($file){
		extract($this->tAssgin,EXTR_OVERWRITE);
		$config = D::app()->getConfig('config');
		if(!empty($config['themes']))
			$template = APP_PATH.'view/'.$config['themes'].'/'.$file.$config['subfix'];
		else
			$template = APP_PATH.'view/'.$file.$config['subfix'];
		$compile = APP_PATH.'cache/view_c/'.md5($file);
		try{
			if(!is_file($template)) throw new BaseException("模板文件".$file."不存在");
			/* 检查是否开启缓存以及缓存文件是否存在 */
			$cache = APP_PATH.'cache/view_cache/'.md5($file.$this->cacheId);
			if($this->cache && is_file($cache)){
				$filetime = filemtime($cache);
				if($this->expire !== 0 &&((TIME - $filetime) < $this->expire)){
					if(is_file($compile)) unlink($compile);
					include $cache;
				}elseif($this->expire == 0){
					if(is_file($compile)) unlink($compile);
					include $cache;
				}else{
					unlink($cache);
					$this->compile($file);
				}
			}else{
				$template = file_get_contents($template);
				$template = $this->replace($template);
				$template = "<?php defined('IS_SYS') or die('Accessed died'); ?>\n\r".$template;
				file_put_contents($compile,$template);
				if($this->cache){
					ob_start();
					include($compile);
					$obContents = ob_get_contents();
					file_put_contents($cache,$obContents);
					ob_end_clean();
					$this->compile($file);
				}else{
					include($compile);
				}				
			}
		}catch(BaseException $e){
			$e->showError();
		}
	}
	
	/*
	* $file为模板文件
	*/
	function checkCache($file,$cacheid = ''){
		$cache = APP_PATH.'cache/view_cache/'.md5($file.$cacheid);
		if(is_file($cache)) return true;
		return false;
	}
}