<?php

defined("IS_SYS") or die('Accessed died!');

/**
* 处理文件以及文件夹相关函数
* @autor : fuwei <fuweiqs163@163.com>
* @verson: v1.0
*/

/*
* 列出指定目录的所有文件
* @param $dir string 需要列出的目录
*/

function listFiles($dir){
	if(is_dir($dir)){
		if($handle = opendir($dir)){
			$array = array();
			while(($file = readdir($handle)) !== false){
				if($file != "." && $file != ".." && $file != "Thumbs.db"){
					//echo ‘<a target=”_blank” href=”‘.$dir.$file.’”>’.$file.’</a><br>’.”n”;
					$array[] = array(
						'filepath' => $dir.$file,
						'filename' => $file,
					);
				}
			}
			closedir($handle);
			return $array;
		}
	}
	return false;
}

/*
* 删除一个目录以及目录里面的文件
* @param $dir string 需要删除的目录路径
* @param $virtual string 是否是虚拟目录
* @return boolean  
*/
function destroyDir($dir, $virtual = false){
	$ds = DIRECTORY_SEPARATOR;
	$dir = $virtual ? realpath($dir) : $dir;
	$dir = substr($dir, -1) == $ds ? substr($dir, 0, -1) : $dir;
	if (is_dir($dir) && $handle = opendir($dir)){
		while ($file = readdir($handle)){
			if ($file == '.' || $file == '..'){
				continue;
			}elseif (is_dir($dir.$ds.$file)){
				destroyDir($dir.$ds.$file);
			}else{
				unlink($dir.$ds.$file);
			}
		}
		closedir($handle);
		rmdir($dir);
		return true;
	}else{
		return false;
	}
}

/*
* 压缩ZIP文件
* @param $files array 需要压缩的文件
* @destination string 指定压缩的文件名
* @return boolean
*/
function createZip($files = array(),$destination = "",$overwrite = false) {
	if(class_exists('ZipArchive')) die('系统不支持ZipArchive');
	if(file_exists($destination) && !$overwrite) { return false; }
	$valid_files = array();
	if(is_array($files)) {
		foreach($files as $file) {
			if(file_exists($file)) {
				$valid_files[] = $file;
			}
		}
	}
	if(count($valid_files)) {
		$zip = new ZipArchive();
		if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
			return false;
		}
		foreach($valid_files as $file) {
			$zip->addFile($file,$file);
		}
		$zip->close();
		return file_exists($destination);
	}else{
		return false;
	}
}
/*
* 	案例
*	$files=array(‘file1.jpg’, ‘file2.jpg’, ‘file3.gif’);
*	create_zip($files, ‘myzipfile.zip’, true);
*/

/*
* php解压缩ZIP文件
* @param $file string 压缩文件的路径
* @param $destination 解压缩文件到目标目录
*/

function unZip($file, $destination) {
	if(class_exists('ZipArchive')) die('系统不支持ZipArchive');
	// create object
	$zip = new ZipArchive() ;
	// open archive
	if ($zip->open($file) !== TRUE) {
		die ('Could not open archive');
	}
	// extract contents to destination directory
	$zip->extractTo($destination);
	// close archive
	$zip->close();
	return true;
}
