<?php

defined("IS_SYS") or die("Accessed died!");

/**
* 网站购物车
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
**/

class Cart{
	
	private $cartInfo;//用于存储购物车信息
	
	private $cookie;
	
	function __construct(){
		$this->cookie = D::app()->library('cookie');
		if($this->cookie->get('cartInfo'))
			$this->cartInfo = String2Array($this->cookie->get('cartInfo'));
		else
			$this->cartInfo = array(
				'totalNums' => 0, //总共的数量0
				'totalPrice' => 0, //总价为0
				'items' => array(),
			);
	}
	
	/*
	* 向购物车中添加商品
	*/
	function insert($items = array()){
		if(!is_array($items)) return false;
		$status = false;
		//同一个商品ID同一个属性 则视为同一个商品并且数量增加
		if(!$status){
			foreach($this->cartInfo['items'] as $key => $val){
				if((int)$val['id'] == (int)$items['id'] && $val['type'] == trim($items['type'])){
					$this->cartInfo['items'][$key] = array(
						'id' => $items['id'],
						'type' => $items['type'],
						'nums' => (int) $val['nums'] + (int) $items['nums'],
						'price' => $val['price'],
					);
					$this->cartInfo['totalNums'] = $this->cartInfo['totalNums'] + (int)$items['nums'];
					$this->cartInfo['totalPrice'] = $this->cartInfo['totalPrice'] + ($val['price'] * (int)$items['nums']);
					$status = true;
					break;
				}else{
					$status = false;
				}
			}
		}
		if(!$status){
			$this->cartInfo['items'][] = array(
						'id' => $items['id'],
						'type' => $items['type'],
						'nums' => $items['nums'],
						'price' => $items['price'],
					);
			$this->cartInfo['totalNums'] = $this->cartInfo['totalNums'] + (int)$items['nums'];
			$this->cartInfo['totalPrice'] = $this->cartInfo['totalPrice'] + ($items['price'] * (int)$items['nums']);
			$status = true;
		}
		if($status){
			$this->cookie->set('cartInfo',Array2String($this->cartInfo));
			return true;
		}else{
			return false;
		}
	}
	
	function update($items = array()){
		if(!is_array($items) or !isset($items['id']) or !isset($item['type']) ) return false;
		if(count($this->cartInfo['items']) < 1 and $this->cartInfo['totalNums'] == 0) return false;
		$status = false;
		foreach($this->cartInfo['items'] as $key => $val){
			if($val['id'] == $items['id'] and $val['type'] == $items['type']){
				$this->cartInfo['items'][$key] = array(
					'id' => $val['id'],
					'type' => $val['type'],
					'nums' => $items['nums'],
					'price' => $val['price']
				);
				$this->cartInfo['totalNums'] = $this->cartInfo['totalNums'] - (int) $val['nums'] + (int) $items['nums'];
				$this->cartInfo['totalPrice'] = $this->cartInfo['totalPrice'] - ($val['price'] * (int)$val['nums']) + ($val['price'] * (int)$items['nums']);
				$status = true;
			}
		}
		if($status){
			$this->cookie->set('cartInfo',Array2String($this->cartInfo));
			return true;
		}else{
			return false;
		}
	}
	
	/*
	* 删除购物车中的商品
	*/
	function delete($items = array()){
		if(!is_array($items)) return false;
		$status = false;
		foreach($this->cartInfo['items'] as $key=>$val){
			if($val['id'] == $items['id'] and $val['type'] == $items['type']){
				$this->cartInfo['totalNums'] = $this->cartInfo['totalNums'] - $val['nums'];
				$this->cartInfo['totalPrice'] = $this->cartInfo['totalPrice'] - ($val['price'] * (int)$val['nums']);
				unset($this->cartInfo['items'][$key]);
				$status = true;
			}
		}
		if($status){
			$this->cookie->set('cartInfo',Array2String($this->cartInfo));
			return true;
		}else{
			return false;
		}
	}
	
	/**
	* 清空购物车
	*/
	function clear(){
		$this->cartInfo['totalNums'] = 0;
		$this->cartInfo['totalPrice'] = 0;
		$this->cartInfo['items'] = array();
		$this->cookie->set('cartInfo',Array2String($this->cartInfo));
		return true;
	}
	
	/**
	* 获取购物车信息
	*/
	function getCartInfo(){
		return $this->cartInfo;
	}
	
	function __destruct(){}
}