<?php

defined("IS_SYS") or die('Accessed died!');

/**
* COOKIE处理
* @autor: fuwei<fuweiqs163@163.com>
* @version: 1.0
**/

class Cookie{
	
	private $config = array(
		'domain' => null,
		'path' => '/',
		'expire' => 3600,
		'encrype' => false,
	);
	
	/*
	* 检测一个cookie
	*/
	function is($key){
		return isset($_COOKIE[$key]) ? true : false;
	}
	
	/*
	* 写入cookie
	*/
	function set($key,$value,$expire = null,$path = null,$domain = null){
		$expire = is_null($expire) ? TIME+($this->config['expire']) : TIME+$expire;
		$path = is_null($path) ? $this->config['path'] : $path;
		$domain = is_null($domain) ? $this->config['domain'] : $domain;
		if($this->config['encrype']) $value = base64_encode(serialize($value));
		setcookie($key,$value,$expire,$path,$domain);
		$_COOKIE[$key] = $value;
		return true;
	}
	
	/*
	* 获取一个cookie
	*/
	function get($key){
		if($this->is($key))
			return $this->config['encrype'] ? unserialize(base64_decode($_COOKIE[$key])) : $_COOKIE[$key];
		else
			return false;
	}
	
	/*
	* 删除一个cookie
	*/
	function delete($key , $domain = null){
		$this->set($key,'','-3600','/',$domain);
		unset($_COOKIE[$key]);
		return true;
	}
	
	/*
	* 清空cookie
	*/
	function clear(){
		unset($_COOKIE);
		return true;
	}
}