<?php

defined("IS_SYS") or die("Accessed died");

/*
* 以SMTP方式发送邮件类
* @autor : fuwei <fuweiqs163@163.com>
* @package: Email.php
* @version: v1.0
*/
class Email{
	
	/*
	* 邮件配置
	*/
	private $config;
	
	function __construct($config = array()){
		$this->config = D::app()->getConfig('email');
		$this->config = array_merge($this->config,(array)$config);
	}
	
	/*
	* 发送邮件
	* @access public
	* @param $to string/array 接收的邮件地址 多个请使用数组形式
	* @param $subject string 邮件主题
	* @param $body string 邮件内容
	* @param $attach 附件
	* @return bool
	*/
	function send($to,$subject,$body,$attach=NULL){
		//加载PHPEMAIL
		@error_reporting(E_ERROR | E_WARNING | E_PARSE);//屏蔽出错信息
         require_once(dirname(__FILE__).'/phpmailer/class.phpmailer.php');
	    $mail             = new PHPMailer();
		$mail->IsSMTP(); //// 使用SMTP方式发送
		$mail->Host       = $this->config['host']; //smtp服务器地址
		$mail->Port       = $this->config['port'];    //smtp服务器端口
		$mail->Username   = $this->config['user']; //smtp服务器帐号，
		$mail->Password   = $this->config['pass'];  // smtp服务器帐号密码
		$mail->SMTPAuth   = $this->config['auth'];//启用SMTP验证功能，一般需要开启
		$mail->CharSet = $this->config['charset'];//发送的邮件内容编码	
		$mail->SetFrom($this->config['from'], $this->config['fromName']);	// 发件人的邮箱和姓名
		$mail->AddReplyTo($this->config['reply'],$this->config['fromName']);// 回复时的邮箱和姓名，一般跟发件人一样
		//是否启用SSL安全连接	
		if($this->config['ssl']) $mail->SMTPSecure = "ssl"; //gmail需要启用sll安全连接
		//开启调试信息
		if($this->config['debug']) $mail->SMTPDebug  = 1; 
		$mail->Subject    = $subject;//邮件标题
		$mail->MsgHTML($body);//邮件内容，支持html代码
		//发送邮件
		if(is_array($to))
			//同时发送给多个人
			foreach($to as $key=>$value)$mail->AddAddress($value,"");  // 收件人邮箱和姓名
		else//只发送给一个人
			$mail->AddAddress($to,"");  // 收件人邮箱和姓名
		//发送多个附件
		if(is_array($attach)){
			foreach($attach as $value){
				if(file_exists($value)) $mail->AddAttachment($value); // attachment//附件必须存在，才会发送
			}
		}
		//发送一个附件
		if(!empty($attach)&&is_string($attach)){//附件必须存在，才会发送
			if(file_exists($mail_attach)) $mail->AddAttachment($attach); //发送附件
		}
		if(!$mail->Send()){
			if($this->config['debug']) $this->error($mail->ErrorInfo);
		  	return false;		  
		}else{
		    return true;
		}
	}
	
	function error($errorMsg){
		$e = new BaseException($errorMsg);
		$e->showError();
	}
	
	function __destruct(){}
}