<?php

defined("IS_SYS") or die("Accessed died!");

class Page {

    // 分页栏每页显示的页数
    public $rollPage = 6;
	
    // 页数跳转时要带的参数
    public $parameter  ;
	
    // 默认列表每页显示行数
    public $listRows = 20;
	
    // 起始行数
    public $firstRow	;
	
    // 分页总页面数
    protected $totalPages  ;
	
    // 总行数
    protected $totalRows  ;
	
    // 当前页数
    protected $nowPage    ;
	
    // 分页的栏的总页数
    protected $coolPages   ;
	
    // 分页显示定制
    protected $config  = array(
    	'redirect'=>false,
    	'header'=>'条记录',
    	'prev'=>'<',
    	'next'=>'>',
    	'first'=>'1',
    	'last'=>'>>',
    	//'theme'=>' <div class="part1">%upPage% %first%  %prePage%  %linkPage%  %nextPage% %downPage%</div> <div class="part2">共  %totalPage% 页');
		'theme'=>' <div class="part1">%upPage% %first%  %prePage%  %linkPage%  %nextPage% %downPage%</div>',
		'input' => false,
		);
    // 默认分页变量名
    protected $varPage;
	
	protected $url;
    /**
     +----------------------------------------------------------
     * 架构函数
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     * @param array $totalRows  总的记录数
     * @param array $listRows  每页显示记录数
     * @param array $parameter  分页跳转的参数
     +----------------------------------------------------------
     */
    public function __construct( $config =array()) {
        $this->totalRows = $config['totalRows'];
       // $this->parameter =  $config['parameter'];
        $this->varPage = !empty($config['varPage']) ? $config['varPage'] : 'p';
		$this->listRows = !empty($config['listRows']) ? intval($config['listRows']) : $this->listRows;
		$this->rollPage = !empty($config['rollPage']) ? intval($config['rollPage']) : $this->rollPage;
        $this->totalPages = ceil($this->totalRows/$this->listRows);     //总页数
        $this->coolPages  = ceil($this->totalPages/$this->rollPage);
        $this->nowPage = isset($_GET[$this->varPage]) ? intval($_GET[$this->varPage]) : 1;
        //$this->nowPage = $this->nowPage > 0 ? $this->nowPage : 1;
        if(!empty($this->totalPages) && $this->nowPage>$this->totalPages)
            $this->nowPage = $this->totalPages;
        $this->firstRow = $this->listRows*($this->nowPage-1);
		$this->url = $config['url'];
    }

    public function setConfig($name,$value) {
        if(isset($this->config[$name]))
            $this->config[$name]    =   $value;
    }

    /**
     +----------------------------------------------------------
     * 分页显示输出
     +----------------------------------------------------------
     * @access public
     +----------------------------------------------------------
     */
    public function show() {
    	
    	if(0 == $this->totalRows) return '';
    	
    	//处理参数
        $p = $this->varPage;
		$url = $this->url;
        /* 分页逻辑  */       
        $isfirst = false;
		$islast = false;
		$linkPage = '';
		$prePage = '';
		$nextPage = '';
        //当总数小于显示的页码数
        if ($this->totalPages <= $this->rollPage) {
        	$start = 1;
        	$end   = $this->totalPages;
        }
        else{
        	//
        	if  ($this->nowPage <= $this->rollPage - 1) {
        		$start = 1;
        		$end   = $this->rollPage;
        		
        		$islast = true;
        	}  
        	else if ($this->nowPage > $this->totalPages - $this->rollPage + 1) {
        		$start = $this->totalPages - ($this->rollPage - 1);
        		$end   = $this->totalPages;
        		
        		$isfirst = true;
        	}
        	else{
        		//浮动数
        		$size = floor($this->rollPage / 2);
        		
        		$start = $this->nowPage - $size;
        		$end   = $this->nowPage + $size;
        		
        		$isfirst = true;
        		$islast = true;
        	}
        }
        
        //上下翻页字符串
        $upRow   = $this->nowPage - 1;
        $downRow = $this->nowPage + 1;
        
        
        /* 拼装HTML */
        
        //< 1...     ...last >
        if ($isfirst)
        	$theFirst = "<a class='firstPage' href='".str_replace('{page}',1,$url)."' >".$this->config['first']."</a>";
        else
			$theFirst = '';
        if ($islast)
        	$theEnd = "<a class='lastPage' href='".str_replace('{page}',$this->totalPages,$url)."'>".$this->config['last']."</a>";
        else
			$theEnd = '';
        if ($upRow > 0)
        	$upPage = "<a class='upPage' href='".str_replace('{page}',$upRow,$url)."'>".$this->config['prev']."</a>";
        else
			$upPage = '';
        if ($downRow <= $this->totalPages)
        	$downPage = "<a class='downPage' href='".str_replace('{page}',$downRow,$url)."'>".$this->config['next']."</a>";
        else
			$downPage = '';
       if($start==3)
        	$linkPage .= "<a href='".str_replace('{page}',2,$url)."'>2</a>";
        if($start>=4)
        	$linkPage .= "<a href='".str_replace('{page}',2,$url)."'>2</a> <span class='noEndClass'>...</span>";
        //1 2 3 4 5
        for($i=$start;$i<=$end;$i++){
        	if($i!=$this->nowPage)
        		$linkPage .= " <a href='".str_replace('{page}',$i,$url)."'> ".$i." </a>";
        	else
        		$linkPage .= " <span class='current'>".$i."</span>";
        	if($i==$end){
        		if($i<$this->totalRows)
        			$linkPage .= " <span class='noEndClass'>...</span>";
        	}
        }
                
        $pageStr = str_replace(
            array('%header%','%nowPage%','%totalRow%','%totalPage%','%upPage%','%first%','%prePage%','%linkPage%','%nextPage%','%downPage%','%end%'),
            array($this->config['header'],$this->nowPage,$this->totalRows,$this->totalPages,$upPage,$theFirst,$prePage,$linkPage,$nextPage,$downPage,$theEnd),$this->config['theme']);

        //显示模式  普通false 带跳转ture
        if (!empty($this->config['redirect'])){
        	$html = $pageStr;
        }else{
        	//传递参数
        	if($this->totalPages > 1 && $this->config['input'] ){
        		$redirect = " </div><form method='get' action=''><div class='form'>转到第 <input name=".$p." type='text' class='page_text' size='3' maxlength='3' value='" . $this->nowPage ."'/> 页 <input type='submit' class='page_btn' value='确定' />";
        		if ($params){
        			foreach($params as $k => $v){
        				$string .= "<input type='hidden' name='" . $k . "' value='" . $v . "'/>";
        			}
        			$redirect = $redirect . $string . '</div></form>';
        		}else{
        			$redirect = $redirect . '</div></form>';
        		}
        	}else{
				$redirect = '';
			}
        	//生成Html字符串
        	$html = $pageStr . $redirect;       
        }  
        return $html;
    }

}