<?php

defined("IS_SYS") or die("Accessed died!");

/*
* 重写的session类
* @autor: fuwei <fuweiqs163@163.com>
* @version: v1.0
*/

class Session{
	
	//保存路径
	public $savePath;
	
	//生命周期
	public $lifeTime;
	
	//会话ID
	private $sessionId;
	
	//是否保存到数据库
	private $keepInDb;
	
	//保存到哪个数据库
	private $db;
	
	//数据库的数据表
	private $table;
	
	//实例化模型
	private $model;
	
	function __construct($config = array()){
	
		$this->savePath = isset($config['savePath'])&&!empty($config['savePath']) ? $config['savePath'] : $this->getSavePath();
		
		$this->lifeTime = isset($config['lifeTime'])&&!empty($config['lifeTime']) ? (int) $config['lifeTime'] : 7200;
		
		$this->keepInDb = isset($config['keepInDb'])&&($config['keepInDb'] == true) ? true : false;
		
		$this->gc();
		
		if($this->keepInDb){
		
			$this->db = isset($config['db'])&&!empty($config['db']) ? $config['db'] : 'default';
			
			$this->table = isset($config['table'])&&!empty($config['table']) ? $config['table'] : die('必须选择一个存储的数据表!');
			
			$this->model = &getBaseModel($this->db);
		}
	}
	
	/*
	* 将会话写入cookie
	*/
	function setCookie($sessionid){
		setcookie('PHPSESSID', $sessionid, TIME + 3600, "/");
		$_COOKIE['PHPSESSID'] = $sessionid;
	}
	
	/*
	* 检测COOKIE
	*/
	function isCookie(){
		return isset($_COOKIE['PHPSESSID']) && !empty($_COOKIE['PHPSESSID']) ? true : false;
	}
	
	/*
	* 破坏一个cookie
	*/
	function delCookie(){
		setcookie('PHPSESSID', '', TIME - 3600, "/");
		return true;
	}
	
	/*
	* 获取SESSION会话目录
	*/
	function getSavePath(){
		return session_save_path();
	}
	
	/*
	* 写入一个会话
	*/
	function set($key,$value){	
		$cookie = $this->isCookie();
		$sessionId = $this->sessionId();
		if(false == $cookie) $this->setCookie($sessionId);
		$data = $this->returnAll();
		if($data)
			$data = array_merge($data,array($key => $value));
		else
			$data = array($key => $value);
		$content = serialize($data);
		if($this->keepInDb){
			$insert['session_id'] = $_COOKIE['PHPSESSID'];
			$insert['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
			$insert['last_time'] = TIME;
			$insert['session_value'] = $content;
			$insert['ip_address'] = getUserIp();
			$this->model->replace($insert,$this->table);
			unset($insert,$data);
			return true;
		}else{
			$sessionFile = $this->getSavePath().'/'.'uj_'.$_COOKIE['PHPSESSID'];
			file_put_contents($sessionFile,$content);
		}
		return true;
	}
	
	/*
	* 检测一个会话是否存在
	*/
	function is($key){
		if(!isset($_COOKIE['PHPSESSID'])) return false;
		$data = $this->returnAll();
		return isset($data[$key]) ? $data: false;
	}
	
	/*
	* 返回所有的会话
	*/
	function returnAll(){
		if(!$this->isCookie()) return false;
		if($this->keepInDb){
			$sessionContent = $this->model->find(array('where'=>array('session_id'=>$_COOKIE['PHPSESSID'])),$this->table);
			return unserialize($sessionContent['session_value']);
		}else{
			$sessionPath = $this->getSavePath().'/'.'uj_'.$_COOKIE['PHPSESSID'];
			if(is_file($sessionPath)){
				$sessionContent = file_get_contents($sessionPath);
				$data = unserialize($sessionContent);
				return $data;
			}
		}
		return array();
	}
	
	/*
	* 获取一个会话
	*/
	function get($key){
		$sessionContent = $this->returnAll();
		if($sessionContent)
			return isset($sessionContent[$key]) ? $sessionContent[$key] : false;
		else
			return false;
	}
	
	/*
	* 获取一个会话ID
	*/
	function sessionId(){
		$this->sessionId = md5(uniqid('uj_'));
		return $this->sessionId;
	}
	
	/*
	* 删除一个会话
	*/
	function delete($key){
		if($data = $this->is($key)){
			//$data = $this->returnAll();
			unset($data[$key]);
			$content = serialize($data);
			if($this->keepInDb){
				$where['session_id'] = $_COOKIE['PHPSESSID'];
				$update['session_value'] = $content;
				$this->model->update($update,$where,$this->table);
			}else{
				$sessionFile = $this->getSavePath().'/'.'uj_'.$_COOKIE['PHPSESSID'];
				file_put_contents($sessionFile,$content);
			}
			return true;
		}
		return false;
	}
	
	/*
	* 垃圾回收
	*/
	function gc(){
		if($this->keepInDb){
			$lifeTime = $this->lifeTime;
			$lifeTime = TIME - (int)$lifeTime;
			$where = "last_time < $lifeTime";
			$this->model->delete($where,$this->table);
		}else{
			$dir = $this->getSavePath().'/';
			if (is_dir($dir) && $handle = opendir($dir)){
				while ($file = readdir($handle)){
					if($file != "." && $file != ".." && $file != "Thumbs.db"){
						if((int)strpos($file,'uj_') == 0 && (TIME - filemtime($dir.$file)) >= $this->lifeTime) unlink($dir.$file);
					}
				}
				closedir($handle);
			}
		}
		return true;
	}
	
	/*
	* 注销所有的会话
	*/
	function destroy(){
		if($this->isCookie()) unlink($this->getSavePath().'/'.'uj_'.$_COOKIE['PHPSESSID']);
		if($this->keepInDb){
			$where['session_id'] = $_COOKIE['PHPSESSID'];
			$this->model->delete($where,$this->table);
		}
		$this->delCookie();
		return true;
	}
	
	function __destruct(){
		unset($this->savePath,$this->lifeTime,$this->sessionId,$this->keepInDb,$this->db,$this->table,$this->model);
	}
}