<?php
/*
  作 用 : jsphp全局控制器
  时 间 : 2009-8-13
  作 者：jscto
  个人主页：www.jscto.net
  QQ交流群：287546175
 */
class Controller extends Base{
	
	//模型
	private $model;
	
	//视图
	private $view;
	
	
	public function __construct(){
		$this->view = new View();
	}
	
	/*
     * 解析访问路径
     *
     * @access protected
     * @return array
     */
	protected function getPath(){
		$path = @$_SERVER['PATH_INFO'];
		$path = explode('/',$path);
		return $path;
	}
	
	/*
     * 获得控制器
     *
     * @access protected
	   @param  array
     * @return string
     */
	 protected function getController($path){
		 $c = empty($path[1]) ? 'Index' : $path[1];
		 return $c;
	 }
	 
	/*
     * 获得操作
     *
     * @access protected
	 * @param  array
     * @return string
     */
	 protected function getAction($path){
		 $a = empty($path[2]) ? 'index' : $path[2];
		 return $a;
	 }
	 
	/*
     * 加载控制器
     *
     * @access protected
     * @return void
     */
	 protected function loadController(){
		 $path = $this->getPath();
		 $c = $this->getController($path);
		 $a = $this->getAction($path);
		 $cpath = APP_PATH.'/Libs/Controllers/'.$c.'Action.class.php';
		 if(!file_exists($cpath)){
			 $this->_404('控制器'.$c.'不存在');
		 }
		 else{
			 require_once($cpath);
			 $c = $c.'Action';
			 $c = new $c;
			 $c->$a();
		 }
	 }
	 
	/*
     * 加载模型
     *
     * @access protected
     * @return object
     */
	 public function loadModel(){
	 	$path = $this->getPath();
		$m = $this->getController($path);
		$mpath = APP_PATH.'/Libs/Models/'.$m.'Model.class.php';
		if(!file_exists($mpath)){
			 $this->_404('模型'.$m.'不存在');
		 }
		 else{
			 require_once($mpath);
			 $m = $m.'Model';
			 $this->model = new $m;
		 }
		 return $this->model;
	 }
	 
	 /*
     * 加载视图
     *
     * @access protected
     * @return object
     */
	 public function view(){
		return $this->view;
	 }
	 
	/*
     * 控制器入口
     *
     * @access public
     * @return void
     */
	public function run(){
		$this->loadController();
		$this->loadModel();
	}
	
	/*
     * 生成静态html页面
     *
     * @access protected
     * @return void
     */
	 public function makeHtml($file,$str){
	 	$fp = fopen($file,'w');
		fwrite($fp,$str);
		fclose($fp);
	 }
}
?>