/*
 * Decompiled with CFR 0.152.
 */
package jmaster.jumploader.controller;

import java.awt.Image;
import java.io.File;
import java.util.MissingResourceException;
import jmaster.jumploader.app.ShutdownCleaner;
import jmaster.jumploader.model.api.IModel;
import jmaster.jumploader.model.api.file.IFileBrowser;
import jmaster.jumploader.model.api.upload.IUploadFile;
import jmaster.jumploader.model.api.upload.IUploader;
import jmaster.jumploader.view.api.file.list.IFileListView;
import jmaster.jumploader.view.api.file.list.IFileListViewListener;
import jmaster.jumploader.view.api.file.tree.IFileTreeView;
import jmaster.jumploader.view.api.file.tree.IFileTreeViewListener;
import jmaster.jumploader.view.api.image.IImageView;
import jmaster.jumploader.view.api.image.IImageViewListener;
import jmaster.jumploader.view.api.main.IMainView;
import jmaster.jumploader.view.api.upload.IUploadView;
import jmaster.jumploader.view.api.upload.IUploadViewListener;
import jmaster.jumploader.view.impl.image.ImageView;
import jmaster.util.log.A;
import jmaster.util.log.B;
import jmaster.util.property.C;
import jmaster.util.property.D;

public class Controller
implements IUploadViewListener,
IFileTreeViewListener,
IFileListViewListener,
IImageViewListener {
    private static final String \u00ff = "Controller.properties";
    protected A \u00fd = B.getInstance().getLog(this.getClass());
    protected IMainView \u00fb;
    protected IModel \u00fc;
    private String[] \u00fe;

    public Controller(IModel iModel, IMainView iMainView) {
        Object object;
        this.\u00fc = iModel;
        this.\u00fb = iMainView;
        try {
            object = jmaster.util.property.B.C().G(\u00ff);
            C c2 = C.A();
            c2.A((Object)this, (D)object, null);
            this.\u00fe = ((D)object).H("addFiles");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        iMainView.getUploadView().addListener(this);
        if (iMainView.getFileTreeView() != null) {
            iMainView.getFileTreeView().addListener(this);
        }
        if (iMainView.getFileListView() != null) {
            iMainView.getFileListView().addListener(this);
        }
        if (iMainView.getImageView() != null) {
            iMainView.getImageView().addListener(this);
        }
        object = this.\u00fc.getUploader();
        if (this.\u00fe != null) {
            for (int k = 0; k < this.\u00fe.length; ++k) {
                try {
                    object.addFile(this.\u00fe[k]);
                    continue;
                }
                catch (jmaster.jumploader.model.api.A.C c3) {
                    this.\u00fd.E(c3, c3);
                }
            }
        }
    }

    public void uploadViewAddFilesAction(IUploadView iUploadView, String[] stringArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewAddFilesAction", new Class[]{IUploadView.class, String[].class}, new Object[]{iUploadView, stringArray});
            return;
        }
        try {
            this.T().addFiles(stringArray);
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.\u00fd.E("Failed to add files " + stringArray, c2);
            this.\u00fb.showWarning(c2.getMessage());
        }
    }

    public void uploadViewRemoveFilesAction(IUploadView iUploadView, IUploadFile[] iUploadFileArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewRemoveFilesAction", new Class[]{IUploadView.class, IUploadFile[].class}, new Object[]{iUploadView, iUploadFileArray});
            return;
        }
        try {
            for (int k = 0; k < iUploadFileArray.length; ++k) {
                if (!iUploadFileArray[k].isRemovable()) continue;
                this.T().removeFile(iUploadFileArray[k]);
            }
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewStartAction(IUploadView iUploadView) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewStartAction", new Class[]{IUploadView.class}, new Object[]{iUploadView});
            return;
        }
        try {
            this.T().startUpload();
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewStopAction(IUploadView iUploadView) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewStopAction", new Class[]{IUploadView.class}, new Object[]{iUploadView});
            return;
        }
        try {
            this.T().stopUpload();
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewStopFilesAction(IUploadView iUploadView, IUploadFile[] iUploadFileArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewStopFilesAction", new Class[]{IUploadView.class, IUploadFile[].class}, new Object[]{iUploadView, iUploadFileArray});
            return;
        }
        try {
            for (int k = 0; k < iUploadFileArray.length; ++k) {
                if (!iUploadFileArray[k].isStoppable()) continue;
                this.T().stopFileUpload(iUploadFileArray[k]);
            }
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewRetryFilesAction(IUploadView iUploadView, IUploadFile[] iUploadFileArray) {
        if (jmaster.util.B.C.A()) {
            jmaster.util.B.C.C(this, "uploadViewRetryFilesAction", new Class[]{IUploadView.class, IUploadFile[].class}, new Object[]{iUploadView, iUploadFileArray});
            return;
        }
        try {
            for (int k = 0; k < iUploadFileArray.length; ++k) {
                if (!iUploadFileArray[k].isRetryable()) continue;
                this.T().retryFileUpload(iUploadFileArray[k]);
            }
        }
        catch (jmaster.jumploader.model.api.A.C c2) {
            this.C(c2);
        }
    }

    public void uploadViewOpenDialogFilesSelected(IUploadView iUploadView, String[] stringArray) {
    }

    public void fileTreeViewPathChanged(IFileTreeView iFileTreeView) {
        jmaster.util.B.C.C(this, "setPath", new Class[]{File.class}, new Object[]{iFileTreeView.getPath()});
    }

    public void fileTreeViewFileDblClicked(IFileTreeView iFileTreeView, File file) {
        if (this.\u00fc.getViewConfig().isFileTreeQueueFileOnDblClick()) {
            jmaster.util.B.C.C(this, "addFile", new Class[]{File.class}, new Object[]{file});
        }
    }

    public void fileListViewPathChanged(IFileListView iFileListView, File file) {
        jmaster.util.B.C.C(this, "setPath", new Class[]{File.class}, new Object[]{file});
    }

    public void fileListViewFileDblClicked(IFileListView iFileListView, File file) {
        if (this.\u00fc.getViewConfig().isFileListQueueFileOnDblClick()) {
            jmaster.util.B.C.C(this, "addFile", new Class[]{File.class}, new Object[]{file});
        }
    }

    public void imageViewCloseAction(IImageView iImageView) {
        iImageView.setImage(null, null, null);
        this.\u00fb.setCurrentView(this.\u00fb.getProgramView());
    }

    public void imageViewSaveAction(IImageView iImageView) {
        this.\u00fb.showGlassView(true);
        jmaster.util.B.C.C(this, "imageViewSaveActionDo", new Class[]{IImageView.class}, new Object[]{iImageView});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageViewSaveActionDo(IImageView iImageView) {
        try {
            this.A(iImageView);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.\u00fb.showGlassView(false);
            this.imageViewCloseAction(iImageView);
        }
    }

    protected void C(Exception exception) {
        this.\u00fd.E("Controller exception", exception);
        this.\u00fb.showError(exception.getMessage());
    }

    private IUploader T() {
        return this.\u00fc.getUploader();
    }

    public void setPath(File file) {
        IFileBrowser iFileBrowser;
        if (file != null && !file.equals((iFileBrowser = this.\u00fc.getFileBrowser()).getPath())) {
            iFileBrowser.setPath(file);
        }
    }

    public void addFile(File file) {
        if (file != null) {
            try {
                this.\u00fc.getUploader().addFile(file.getAbsolutePath());
            }
            catch (jmaster.jumploader.model.api.A.C c2) {
                this.\u00fd.E("Failed to add file: " + file, c2);
            }
        }
    }

    private void A(IImageView iImageView) {
        try {
            jmaster.jumploader.model.api.B.A a2 = this.\u00fc.getImageProcessor();
            File file = File.createTempFile("jumploader_", ".jpg");
            ShutdownCleaner.getInstance().addFile(file);
            if (this.\u00fd.B()) {
                this.\u00fd.D("Saving image to temp file: " + file.getAbsolutePath());
            }
            int n = this.\u00fc.getImageConfig().getJpegQuality();
            a2.A((Image)iImageView.getImage(), file, n);
            jmaster.jumploader.model.impl.upload.C c2 = (jmaster.jumploader.model.impl.upload.C)iImageView.getUploadFile();
            c2.G(true);
            c2.F(true);
            this.\u00fc.getUploader().updateFile(c2, file, true);
            if (this.\u00fc.getUploaderConfig().isSaveImageTransformations()) {
                jmaster.jumploader.model.impl.image.B b2 = jmaster.jumploader.model.impl.image.B.A(c2);
                b2.A(((ImageView)iImageView).getTransformList());
            }
        }
        catch (Exception exception) {
            this.\u00fd.E(exception, exception);
            this.\u00fb.showError(exception.getMessage());
        }
    }

    public void destroy() {
        this.\u00fb = null;
        this.\u00fc = null;
    }

    public void start() {
    }
}

