/*
 * Decompiled with CFR 0.152.
 */
package jmaster.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jmaster.util.B.C;
import jmaster.util.property.D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingUtil {
    public static final String METHOD_FIRE_TABLE_DATA_CHANGED = "fireTableDataChanged";
    public static final String METHOD_FIRE_TABLE_ROWS_INSERTED = "fireTableRowsInserted";
    public static final String METHOD_FIRE_TABLE_ROWS_DELETED = "fireTableRowsDeleted";
    public static final String METHOD_FIRE_TABLE_ROWS_UPDATED = "fireTableRowsUpdated";

    public static void centerParent(Component component) {
        Container container = component.getParent();
        Point point = container.getLocationOnScreen();
        Dimension dimension = container.getSize();
        Dimension dimension2 = component.getSize();
        int n = dimension.width > dimension2.width ? (dimension.width - dimension2.width) / 2 + point.x : point.x;
        int n2 = dimension.height > dimension2.height ? (dimension.height - dimension2.height) / 2 + point.y : point.y;
        component.setLocation(n, n2);
    }

    public static Frame getParentFrame(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return SwingUtil.getParentFrame(container);
    }

    public static JFrame getParentJFrame(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof JFrame) {
            return (JFrame)container;
        }
        return SwingUtil.getParentJFrame(container);
    }

    public static JApplet getParentJApplet(Component component) {
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof JApplet) {
            return (JApplet)container;
        }
        return SwingUtil.getParentJApplet(container);
    }

    public static void reloadTreeNode(final DefaultTreeModel defaultTreeModel, final TreeNode treeNode) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        defaultTreeModel.reload(treeNode);
                    }
                });
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        } else {
            defaultTreeModel.reload(treeNode);
        }
    }

    public void setNativeLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (!C.A()) {
            C.E(this, "setNativeLookAndFeel");
            return;
        }
        String string = UIManager.getSystemLookAndFeelClassName();
        UIManager.setLookAndFeel(string);
    }

    public static void fireTableRowsInserted(AbstractTableModel abstractTableModel, int n, int n2) {
        if (!C.A()) {
            C.B(abstractTableModel, METHOD_FIRE_TABLE_ROWS_INSERTED, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
        } else {
            abstractTableModel.fireTableRowsInserted(n, n2);
        }
    }

    public static void fireTableRowsDeleted(AbstractTableModel abstractTableModel, int n, int n2) {
        if (!C.A()) {
            C.B(abstractTableModel, METHOD_FIRE_TABLE_ROWS_DELETED, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
        } else {
            abstractTableModel.fireTableRowsDeleted(n, n2);
        }
    }

    public static void fireTableRowsUpdated(AbstractTableModel abstractTableModel, int n, int n2) {
        if (!C.A()) {
            C.B(abstractTableModel, METHOD_FIRE_TABLE_ROWS_UPDATED, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
        } else {
            abstractTableModel.fireTableRowsUpdated(n, n2);
        }
    }

    public static void fireTableDataChanged(AbstractTableModel abstractTableModel) {
        if (!C.A()) {
            C.E(abstractTableModel, METHOD_FIRE_TABLE_DATA_CHANGED);
        } else {
            abstractTableModel.fireTableDataChanged();
        }
    }

    public static void setUiDefault(Object object, Object object2) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        uIDefaults.put(object, object2);
    }

    public static void setUiDefaultString(String string, Object object) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        Object object2 = uIDefaults.get(string);
        if (object2 != null) {
            if (object2 instanceof Color) {
                object = new Color(D.R("" + object));
            }
            if (object2 instanceof Font) {
                Object object3;
                StringTokenizer stringTokenizer = new StringTokenizer("" + object, ",");
                Font font = (Font)object2;
                String string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : font.getFontName();
                int n = font.getStyle();
                if (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    n = 0;
                    if (string3.indexOf(98) != -1) {
                        n |= 1;
                    }
                    if (string3.indexOf(105) != -1) {
                        n |= 2;
                    }
                }
                int n2 = font.getSize();
                if (stringTokenizer.hasMoreTokens()) {
                    object3 = stringTokenizer.nextToken();
                    n2 = Integer.parseInt((String)object3);
                }
                object = object3 = new Font(string2, n, n2);
            }
        }
        SwingUtil.setUiDefault(string, object);
    }

    public static Object getUiDefault(Object object) {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return uIDefaults.get(object);
    }

    public static Container getTopContainer(Component component) {
        return component.getParent() == null ? (component instanceof Container ? (Container)component : null) : SwingUtil.getTopContainer(component.getParent());
    }

    public static List getDescendantsOfType(Class clazz, Container container, boolean bl) {
        ArrayList arrayList = new ArrayList();
        for (Component component : container.getComponents()) {
            if (clazz.isAssignableFrom(component.getClass())) {
                arrayList.add(clazz.cast(component));
            }
            if (!bl && clazz.isAssignableFrom(component.getClass())) continue;
            arrayList.addAll(SwingUtil.getDescendantsOfType(clazz, (Container)component, bl));
        }
        return arrayList;
    }

    public static <T extends JComponent> T getDescendantOfType(Class<T> clazz, Container container, String string, Object object) throws IllegalArgumentException {
        return SwingUtil.getDescendantOfType(clazz, container, string, object, true);
    }

    public static <T extends JComponent> T getDescendantOfType(Class<T> clazz, Container container, String string, Object object, boolean bl) throws IllegalArgumentException {
        List list = SwingUtil.getDescendantsOfType(clazz, container, bl);
        return SwingUtil.A(clazz, list, string, object);
    }

    private static <T extends JComponent> T A(Class<T> clazz, List<T> list, String string, Object object) throws IllegalArgumentException {
        T t = null;
        Method method = null;
        try {
            method = clazz.getMethod("get" + string, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = clazz.getMethod("is" + string, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IllegalArgumentException("Property " + string + " not found in class " + clazz.getName());
            }
        }
        try {
            for (JComponent jComponent : list) {
                Object object2 = method.invoke((Object)jComponent, new Object[0]);
                if (!SwingUtil.equals(object, object2)) continue;
                return (T)jComponent;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("Error accessing property " + string + " in class " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Property " + string + " cannot be accessed in class " + clazz.getName());
        }
        catch (SecurityException securityException) {
            throw new IllegalArgumentException("Property " + string + " cannot be accessed in class " + clazz.getName());
        }
        return t;
    }

    public static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static void showImageFrame(Image image, String string) {
        JLabel jLabel = new JLabel();
        jLabel.setIcon(new ImageIcon(image));
        JFrame jFrame = new JFrame();
        jFrame.setTitle(string);
        jFrame.getContentPane().add(new JScrollPane(jLabel));
        jFrame.setSize(image.getWidth(null) + 20, image.getHeight(null) + 60);
        jFrame.setVisible(true);
    }
}

