<?php
$mtime = explode(' ', microtime());
$start_time = $mtime[0] + $mtime[1];

define('ROOT_PATH', str_replace('\\', '/', dirname(__FILE__)).'/');
define('APP_PATH', ROOT_PATH.'source/');
define('MOD_PATH', ROOT_PATH.'module/');

require(APP_PATH.'init.php');
require(APP_PATH.'module/option.php');
require(APP_PATH.'module/link.php');
require(APP_PATH.'module/adver.php');
require(APP_PATH.'module/label.php');
require(APP_PATH.'module/category.php');
require(APP_PATH.'module/website.php');
require(APP_PATH.'module/stats.php');

/** load setting  */
$options = get_options();
$options = array_change_key_case($options, CASE_LOWER);
if (substr($options['site_root'], -1) != '/') {
	$options['site_root'] .= '/';
}

/** gzip */
if ($options['is_enabled_gzip'] == 'yes' && function_exists('ob_gzhandler') && strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') !== FALSE) {
	@ob_start('ob_gzhandler');
} else {
	$options['is_enabled_gzip'] = 'no';
	ob_start();
}

require(MOD_PATH.'common.php');

/** module */
$module = $_GET['mod'] ? $_GET['mod'] : $_POST['mod'];
if (!isset($module)) $module = 'index';

$modarr = array('index', 'directory', 'category', 'update', 'archives', 'search', 'siteinfo', 'top', 'feedback', 'rssfeed', 'sitemap', 'addurl', 'ajaxget', 'getdata');
if (in_array($module, $modarr)) {
	$modpath = MOD_PATH.$module.'.php';
	if (is_file($modpath)) {
		require($modpath);
	} else {
		exit('“'.$module.'.php” 模块文件不存在！文件路径：“'.MOD_PATH.'”。');
	}
}
?>