<?php
if (!defined('IN_HANFOX')) exit('Access Denied');

$pagename = '网站提交入口';
$pageurl = '?mod=addurl';
$tempfile = 'addurl.html';

$smarty->caching = false;

if (!$smarty->isCached($tempfile)) {
	$smarty->assign('site_title', $pagename.' - '.$options['site_title']);
	$smarty->assign('site_keywords', '网站提交，网址提交，，网站提交入口，网站登录入口');
	$smarty->assign('site_description', '欢迎您提交各类优秀网站到'.$options['web_name'].'！');
	$smarty->assign('site_path', get_sitepath().' &raquo; '.$pagename);
	$smarty->assign('site_rss', get_rssfeed());
	$smarty->assign('pagename', $pagename);
	$smarty->assign('category_option', get_category_option(0, 0, 0));
	$smarty->assign('submit_limit', $options['submit_limit']);
	
	if ($_POST['act'] == 'submit') {
		$cate_id = intval($_POST['cate_id']);
		$web_name = trim($_POST['web_name']);
		$web_url = trim($_POST['web_url']);
		$web_tags = trim($_POST['web_tags']);
		$web_intro = trim($_POST['web_intro']);
		$web_owner = trim($_POST['web_owner']);
		$web_email = trim($_POST['web_email']);
		$check_code = strtolower(trim($_POST['check_code']));
		$post_time = time();
		
		if ($cate_id <= 0) {
			msgbox('请选择网站所属分类！');
		} else {
			$cate = get_one_category($cate_id);
			if ($cate['cate_childcount'] > 0) {
				msgbox('指定的分类下有子分类，请选择子分类进行操作！');
			}
		}
		
		if (empty($web_name)) {
			msgbox('请输入网站名称！');
		}
		
		if (empty($web_url)) {
			msgbox('请输入网站域名！');
		} else {
			if (!is_valid_domain($web_url)) {
				msgbox('请输入正确的网站域名！');
			}
		}
				
		if (empty($web_tags)) {
			msgbox('请输入TAG标签！');
		} else {
			$web_tags = str_replace('，', ',', $web_tags);
			$web_tags = str_replace(',,', ',', $web_tags);
			if (substr($web_tags, -1) == ',') {
				$web_tags = substr($web_tags, 0, strlen($web_tags) - 1);
			}
		}
		
		if (empty($web_intro)) {
			msgbox('请输入网站简介！');
		} else {
			if (strlen($web_intro) > 255) {
				msgbox('简介长度不能超过255个字节！');
			}
		}
		
		if (empty($web_owner)) {
			msgbox('请输入站长姓名！');
		}
		
		if (empty($web_email)) {
			msgbox('请输入电子邮箱！');
		} else {
			if (!is_valid_email($web_email)) {
				msgbox('请输入正确的电子邮件地址！');
			}
		}
		
		if (empty($check_code) || $check_code != $_SESSION['code']) {
			unset($_SESSION['code']);
			msgbox('您输入的验证码不正确，请重新输入！');	
		}
		
		//验证网站是否存在
		$query_1 = $DB->query("SELECT app_id FROM ".$DB->table('apply')." WHERE web_url='$web_url'");
    	if ($DB->num_rows($query_1) > 0) {
        	msgbox('您所提交的站点已在审核过程中，请勿重复提交！');
		}		
		
		$query_2 = $DB->query("SELECT web_id FROM ".$DB->table('website')." WHERE web_url='$web_url'");
    	if ($DB->num_rows($query_2) > 0) {
        	msgbox('您所提交的站点已被收录，请勿重复提交！');
		}
		
		//网站提交
		$sitedata = array(
			'cate_id' => $cate_id,
			'web_name' => $web_name,
			'web_url' => $web_url,
			'web_tags' => $web_tags,
			'web_intro' => $web_intro,
			'web_owner' => $web_owner,
			'web_email' => $web_email,
			'post_time' => $post_time,
		);
		$DB->insert($DB->table('apply'), $sitedata);
		unset($_SESSION['code']);
		
		//发送邮件
		if (!empty($options['smtp_host']) && !empty($options['smtp_port']) && !empty($options['smtp_auth']) && !empty($options['smtp_user'])  && !empty($options['smtp_pass'])) {
			require(APP_PATH.'include/sendmail.php');
			
			$smarty->assign('web_name', $options['web_name']);
			$smarty->assign('web_url', $options['web_url']);
			$smarty->assign('web_owner', $web_owner);
			$mailbody = $smarty->fetch('sendmail.html');
			sendmail($web_email, '欢迎提交网站至'.$options['web_name'].'！', $mailbody);
		}
		
		msgbox('<strong>网站提交成功！</strong><br />审核通过后，我们将会第一次时间发邮件通知您的。</li>');
	}
}

smarty_output($tempfile);
?>