<?php
if (!defined('IN_HANFOX')) exit('Access Denied');

function smarty_output($template, $cache_id = NULL, $compile_id = NULL) {
	global $smarty, $options;
	
	template_exists($template);
	
	if (substr($options['site_root'], -1) != '/') {
		$options['site_root'] .= '/';
	}
	
	$options = stripslashes_deep($options);
	$stats = get_stats();
	$labels = stripslashes_deep(get_labels());
	
	$smarty->assign('site_root', $options['site_root']);
	$smarty->assign('site_name', $options['site_name']);
	$smarty->assign('site_url', $options['site_url']);
	$smarty->assign('site_copyright', $options['site_copyright']);
	$smarty->assign('cfg', $options); #options
	$smarty->assign('stat', $stats); #stats
	$smarty->assign('label', $labels); #labels
	$smarty->assign('script_time', get_scripttime()); #script time
	$smarty->display($template, $cache_id, $compile_id);
	
	$buffer = ob_get_contents();
	ob_end_clean();

	$options['is_enabled_gzip'] == 'yes' ? ob_start('ob_gzhandler') : ob_start();
	if ($options['is_enabled_rewrite'] == 'yes') {
		require(APP_PATH.'include/rewrite.php');
		echo rewrite_output($buffer);
	}
	unset($options, $stats, $labels);
}

function msgbox($msg, $url = 'javascript: history.go(-1);') {
	global $smarty;
	
	$template = 'msgbox.html';
	template_exists($template);
	
	$smarty->assign('msg', $msg);
	$smarty->assign('url', $url);
	echo $smarty->fetch('msgbox.html');
	@ob_end_flush();
	exit();
}

function redirect($url) {
    header('location:'.$url, false, 301);
	exit;
}

function get_scripttime() {
	global $DB, $options, $start_time;
	
	$mtime = explode(' ', microtime());
	$end_time = $mtime[1] + $mtime[0];
	$exec_time = number_format(($end_time - $start_time), 6);
	$gzip = $options['is_enabled_gzip'] == 'yes' ? 'Enabled' : 'Disabled';
	
	return 'Processed in '.$exec_time.' second(s), '.$DB->queries.' Queries, Gzip '.$gzip.'<br />'.base64_decode('PGEgaHJlZj0iaHR0cDovL3d3dy4zNWRpci5jb20vIiB0YXJnZXQ9Il9ibGFuayI+UG93ZXJlZCBCeSAzNWRpci5jb208L2E+');
}

function insert_script_time() {
	return get_scripttime();
}

/** rss link */
function get_rssfeed($cate_id = 0) {
	global $options;
	
	return '<a href="?mod=rssfeed'.($cate_id > 0 ? '&cid='.$cate_id : '').'" target="_blank"><img src="'.$options['site_root'].'public/images/rss.gif" alt="订阅RssFeed" border="0" /></a>';
}
	
/** site path */
function get_sitepath($cate_id = 0) {
	global $options;
	
	$strpath = '当前位置：<a href="'.$options['site_url'].'">'.$options['site_name'].'</a>'.($cate_id > 0 ? get_category_path($cate_id) : '');
	
	return $strpath;
}

/** website link */
function get_weblink($web_id) {
	return '?mod=siteinfo&wid='.$web_id;
}

/** category link */
function get_catelink($cate_id, $cate_dir) {
	$cate_dir = !empty($cate_dir) ? $cate_dir : 'category';
	
	return '?mod=directory&cid='.$cate_id;
}

/** archives link */
function get_arclink($date) {
	return '?mod=archives&date='.$date;
}
	
/** thumbs link */
function get_webthumb($web_url) {
	return 'http://open.thumbshots.org/image.pxf?url='.$web_url;
}

/** format tags */
function get_format_tags($str) {
	$tags = !empty($str) && strpos($str, ',') > 0 ? explode(',', $str) : (array) $str;
	$count = count($tags);
	
	$strtags = '';
	for ($i = 0; $i < $count; $i++) {
		$tags[$i] = trim($tags[$i]);
		$strtags .= '<li><a href="?mod=search&type=tags&query='.urlencode($tags[$i]).'" target="_blank">'.htmlspecialchars($tags[$i]).'</a></li>';
	}
	unset($tags);
	
	return $strtags;
}
?>