<?php
/** rewrite output */
function rewrite_output($content) {
	$search = array(
		"/href\=\"(\.*\/*)\?mod\=(index|category|update|archives|top|feedback|addurl|rssfeed|sitemap)?\"/e",
		"/href\=\"(\.*\/*)\?mod\=directory([&amp;|&]cid\=(\d+))?([&amp;|&]page\=(\d+))?\"/e",
		"/href\=\"(\.*\/*)\?mod\=update([&amp;|&]days\=(\d+))?([&amp;|&]page\=(\d+))?\"/e",
		"/href\=\"(\.*\/*)\?mod\=archives([&amp;|&]date\=(\d+))?([&amp;|&]page\=(\d+))?\"/e",
		"/href\=\"(\.*\/*)\?mod\=search([&amp;|&]type\=(.+?))?([&amp;|&]query\=(.+?))?([&amp;|&]page\=(\d+))?\"/e",
		"/href\=\"(\.*\/*)\?mod\=siteinfo[&amp;|&]wid\=(\d+)\"/e",
		"/href\=\"(\.*\/*)\?mod\=rssfeed([&amp;|&]cid\=(\d+))?\"/e",
		"/href\=\"(\.*\/*)\?mod\=sitemap([&amp;|&]cid\=(\d+))?\"/e",
	);
		
	$replace = array(
		"rewrite_other('\\2')",
		"rewrite_directory('\\3', '\\5')",
		"rewrite_update('\\3', '\\5')",		
		"rewrite_archives('\\3', '\\5')",
		"rewrite_search('\\3', '\\5', '\\7')",
		"rewrite_siteinfo('\\2')",
		"rewrite_rssfeed('\\3')",
		"rewrite_sitemap('\\3')",
	);
	
	return preg_replace($search, $replace, $content);
}

/** other */
function rewrite_other($mod) {
	global $options;
	
	if ($mod == 'index') {
		$strurl ='href="'.$options['site_root'].'"';
	} else {
		$strurl = 'href="'.$options['site_root'].$mod.'"';
	}
		
	return $strurl;
}

/** directory */
function rewrite_directory($cate_id = 0, $page = 1) {
	global $options;
	
	$cate = get_one_category($cate_id);
	$cate_dir = !empty($cate['cate_dir']) ? $cate['cate_dir'] : 'category';
	unset($cate);
	$page = isset($page) && $page > 0 ? $page : 1;
	
	return 'href="'.$options['site_root'].$cate_dir.'/'.$cate_id.'/'.$page.'"';
}

/** update */
function rewrite_update($days, $page = 1) {
	global $options;
	
	$days = isset($days) && $days > 0 ? $days : 0;
	$page = isset($page) && $page > 0 ? $page : 1;
		
	return 'href="'.$options['site_root'].'update/'.$days.'/'.$page.'"';
}

/** archives */
function rewrite_archives($date, $page) {
	global $options;
	
	$date = isset($date) && strlen($date) == 6 ? $date : 0;
	$page = isset($page) && $page > 0 ? $page : 1;
	
	return 'href="'.$options['site_root'].'archives/'.$date.'/'.$page.'"';
}
	
/** search */
function rewrite_search($type = 'name', $query, $page = 1) {
	global $options;

	$query = isset($query) && !empty($query) ? $query : '';
	$page = isset($page) && $page > 0 ? $page : 1;
		
	return 'href="'.$options['site_root'].'search/'.$type.'/'.$query.'/'.$page.'"';
}

/** siteinfo */
function rewrite_siteinfo($web_id) {
	global $options;
	
	$web = get_one_website($web_id);
	$web_url = str_replace('http://', '', $web['web_url']);
	if (substr($web_url, 0, -1) == '/') {
		$web_url = substr($web_url, 0, -1);
	}
	$web_url = str_replace('/', '@', $web_url);
	
	return 'href="'.$options['site_root'].'siteinfo/'.$web_id.'/'.$web_url.'"';
}

/** diypage */
function rewrite_diypage($page_id) {
	global $options;
	
	return 'href="'.$options['site_root'].'page/'.$page_id.'"';
}

/** rssfeed */
function rewrite_rssfeed($cate_id) {
	global $options;
	
	$cate_id = isset($cate_id) && $cate_id > 0 ? $cate_id : '';
	
	return 'href="'.$options['site_root'].'rssfeed/'.$cate_id.'"';
}

/** sitemap */
function rewrite_sitemap($cate_id) {
	global $options;
	
	$cate_id = isset($cate_id) && $cate_id > 0 ? $cate_id : '';
	
	return 'href="'.$options['site_root'].'sitemap/'.$cate_id.'"';
}
?>