<?php
/** category path */
function get_category_path($cate_id = 0, $separator = ' &raquo; ') {
	$categories = get_all_category();
	if (!isset($categories)) return '';
		
	$strpath = '';
	$parent_ids = array_filter(explode(',', $categories[$cate_id]['cate_arrparentid'].','.$cate_id));
	foreach ($parent_ids as $cid) {
		$strpath .= $separator.'<a href="'.$categories[$cid]['cate_link'].'">'.$categories[$cid]['cate_name'].'</a>';
	}
	unset($categories);
		
	return $strpath;
}
	
/** category option */
function get_category_option($root_id = 0, $cate_id = 0, $level_id = 0) {
	global $DB;
		
	$sql = "SELECT cate_id, cate_name FROM ".$DB->table('categories')." WHERE root_id=$root_id ORDER BY cate_id ASC";
	$categories = $DB->fetch_all($sql);
	$optstr = '';
	foreach ($categories as $cate) {
		$optstr .= '<option value="'.$cate['cate_id'].'"';
		if ($cate_id > 0 && $cate_id == $cate['cate_id']) $optstr .= ' selected';
		
		if ($level_id == 0) {
			$optstr .= ' style="background: #EEF3F7;">';
			$optstr .= '├'.$cate['cate_name'];
		} else {
			$optstr .= '>';
			for ($i = 2; $i <= $level_id; $i++) {
				$optstr .= '│&nbsp;&nbsp;';
			}
			$optstr .= '│&nbsp;&nbsp;├'.$cate['cate_name'];
		}
		$optstr .= '</option>';
		$optstr .= get_category_option($cate['cate_id'], $cate_id, $level_id + 1);
	}
	unset($categories);
		
	return $optstr;
}

/** categories */
function get_categories($cate_id = 0, $top_num = 0) {
	$categories = get_all_category();
	if (!isset($categories)) return '';
	
	if ($top_num > 0) $categories = array_slice($categories, 0, $top_num);
	$newarr = array();
	foreach ($categories as $cate) {
		if ($cate['root_id'] == $cate_id) {
			$newarr[] = $cate;
		}
	}
	unset($categories);
	
	return $newarr;
}

/** all category */
function get_all_category() {
	global $DB;
	
	$categories = load_cache('categories') ? load_cache('categories') : $DB->fetch_all("SELECT cate_id, root_id, cate_name, cate_dir, cate_arrparentid, cate_arrchildid, cate_childcount, cate_postcount FROM ".$DB->table('categories')." ORDER BY cate_id ASC");
		
	$newarr = array();
	foreach ($categories as $cate) {
		$cate['cate_link'] = get_catelink($cate['cate_id'], $cate['cate_dir']);
		$newarr[$cate['cate_id']] = $cate;
	}
	unset($categories);
	
	return $newarr;
}

/** one category */
function get_one_category($cate_id) {
	global $DB;
	
	$category = load_cache('category_'.$cate_id) ? load_cache('category_'.$cate_id) : $DB->fetch_one("SELECT cate_id, root_id, cate_name, cate_dir, cate_arrparentid, cate_arrchildid, cate_childcount, cate_postcount FROM ".$DB->table('categories')." WHERE cate_id=$cate_id ORDER BY cate_id ASC LIMIT 1");
		
	return $category;
}
	
/** category name */
function get_category_name($cate_id) {
	$category = get_one_category($cate_id);
	return $category['cate_name'];
}
	
/** category count */
function get_category_count($cate_id = 0) {
	global $DB;
	
	if ($cate_id > 0) $where = array('root_id' => $cate_id);
	$count = $DB->get_count($DB->table('categories'), $where);
		
	return $count;
}
	
/** category website count */
function get_category_website_count($cate_id = 0) {
	global $DB;
	
	$count = $DB->get_count($DB->table('website'), array('cate_id' => $cate_id));
	
	return $count;
}
	
/** category parent ids */
function get_category_parent_ids($cate_id) {
	global $DB;
	
	$sql = "SELECT root_id FROM ".$DB->table('categories')." WHERE cate_id=$cate_id";
	$ids = $DB->fetch_all($sql);		
	$idstr = '';
	foreach ($ids as $id) {
		if ($id['root_id'] > 0) {
			$idstr .= get_category_parent_ids($id['root_id']);
			$idstr .= ','.$id['root_id'];
		} else {
			$idstr = '0';
		}
	}
	unset($ids);
		
	return $idstr;
}

/** category child ids */
function get_category_child_ids($cate_id) {
	global $DB;
	
	$sql = "SELECT cate_id FROM ".$DB->table('categories')." WHERE root_id=$cate_id";
	$ids = $DB->fetch_all($sql);	
	$idstr = '';
	foreach ($ids as $id) {
		$idstr .= ','.$id['cate_id'];
		$idstr .= get_category_child_ids($id['cate_id']);
	}
	unset($ids);
	
	return $idstr;
}
?>