<?php
/** website list */
function get_websites($cate_id = 0, $top_num = 10, $is_best = false, $orderby = 'ctime', $order = 'desc') {
	global $DB;
	
	$where = 'a.web_status=3';
	if (!in_array($orderby, array('instat', 'outstat', 'views', 'ctime'))) $orderby = 'ctime';
	if ($cate_id > 0) {
		$cate = get_one_category($cate_id);
		if (!empty($cate)) $where .= " AND cate_id IN ('".$cate['cate_arrchildid']."')";
	}
	if ($is_best == true) $where .= " AND a.web_isbest=1";
	switch ($orderby) {
		case 'instat' :
			$field = "b.web_instat";
			break;
		case 'outstat' :
			$field = "b.web_outstat";
			break;
		case 'views' :
			$field = "b.web_views";
			break;
		case 'ctime' :
			$field = "a.web_ctime";
			break;
		default :
			$field = "a.web_ctime";
			break;
	}
	$sql = "SELECT a.web_id, a.cate_id, a.web_name, a.web_url, a.web_intro, a.web_isbest, a.web_ctime, b.web_prank, b.web_srank, b.web_arank, b.web_instat, b.web_outstat, b.web_views FROM ".$DB->table('website')." a LEFT JOIN ".$DB->table('webdata')." b ON a.web_id=b.web_id WHERE $where ORDER BY $field DESC LIMIT $top_num";
	$query = $DB->query($sql);
	$website = array();
	while ($web = $DB->fetch_array($query)) {
		$web['web_url'] = format_url($web['web_url']);
		$web['web_thumb'] = get_webthumb($web['web_url']);
		$web['web_link'] = get_weblink($web['web_id']);
		$web['web_tags'] = get_format_tags($web['web_tags']);
		$web['web_ctime'] = date('Y-m-d', $web['web_ctime']);
		$website[] = $web;
	}
	unset($web);
	$DB->free_result($query);
	
	return $website;
}

/** website list */
function get_website_list($where = 1, $orderby = 'web_ctime', $start = 0, $pagesize = 0) {
	global $DB;
	
	$sql = "SELECT w.web_id, w.web_name, w.web_url, w.web_intro, w.web_isbest, w.web_status, w.web_ctime, c.cate_name, d.web_prank, d.web_srank, d.web_arank, d.web_instat, d.web_outstat, d.web_views FROM ".$DB->table('website')." w LEFT JOIN ".$DB->table('categories')." c ON w.cate_id=c.cate_id LEFT JOIN ".$DB->table('webdata')." d ON w.web_id=d.web_id WHERE $where ORDER BY $orderby DESC LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	$website = array();
	while ($web = $DB->fetch_array($query)) {
		$web['web_url'] = format_url($web['web_url']);
		$web['web_link'] = get_weblink($web['web_id']);
		$web['web_thumb'] = get_webthumb($web['web_url']);
		$web['web_ctime'] = date('Y-m-d', $web['web_ctime']);
		$website[] = $web;
	}
	unset($web);
	$DB->free_result($query);
		
	return $website;
}
	
/** one website */
function get_one_website($web_id) {
	global $DB;
	
	$web = $DB->fetch_one("SELECT a.cate_id, a.web_id, a.web_name, a.web_url, a.web_tags, a.web_intro, a.web_status, a.web_ctime, b.web_prank, b.web_srank, b.web_arank, b.web_instat, b.web_outstat, b.web_views, b.web_utime FROM ".$DB->table('website')." a LEFT JOIN ".$DB->table("webdata")." b ON a.web_id=b.web_id WHERE a.web_status=3 AND a.web_id=$web_id LIMIT 1");
	if ($web) {
		$web['web_url'] = format_url($web['web_url']);
	}
	
	return $web;
}
	
/** rssfeed */
function get_website_rssfeed($cate_id = 0) {
	global $DB, $options;
		
	$where = "w.web_status=3";
	$cate = get_one_category($cate_id);
	if (!empty($cate)) {
		if ($cate['cate_childcount'] > 0) {
			$where .= " AND c.cate_id IN (".$cate['cate_arrchildid'].")";
		} else {
			$where .= " AND c.cate_id=$cate_id";
		}
	}

	$sql = "SELECT w.web_id, w.web_url, w.cate_id, w.web_name, w.web_intro, w.web_ctime, c.cate_name FROM ".$DB->table('website')." w LEFT JOIN ".$DB->table('categories')." c ON w.cate_id=c.cate_id";
	$sql .= " WHERE $where ORDER BY w.web_id DESC LIMIT 30";
	$query = $DB->query($sql);
	$website = array();
	while ($web = $DB->fetch_array($query)) {
		if ($options['is_enabled_rewrite'] == 'yes') {
			$web['web_link'] = $options['site_url'].'siteinfo/'.$web['web_id'].'/'.$web['web_url'];
		} else {
			$web['web_link'] = str_replace('//', '/', str_replace('&', '&amp;', $options['site_url'].get_weblink($web['web_id'])));
		}
		$web['web_intro'] = htmlspecialchars(strip_tags($web['web_intro']));
		$web['web_ctime'] = date('Y-m-d H:i:s', $web['web_ctime']);
		$website[] = $web;
	}
	unset($web);
	$DB->free_result($query);
		
	header("Content-Type: application/xml;");
	echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
	echo "<rss version=\"2.0\">\n";
	echo "<channel>\n";
	echo "<title>".$options['site_name']."</title>\n";
	echo "<link>".$options['site_url']."</link>\n";
	echo "<description>".strip_tags($options['site_description'])."</description>\n";
	echo "<language>zh-cn</language>\n";
	echo "<copyright>".$options['site_copyright']."</copyright>\n";
	echo "<webmaster>".$options['site_name']."</webmaster>\n";
	echo "<generator>".$options['site_name']."</generator>\n";
	echo "<image>\n";
	echo "<title>".$options['site_name']."</title>\n";
	echo "<url>".$options['site_url']."logo.gif</url>\n";
	echo "<link>".$options['site_url']."</link>\n";
	echo "<description>".strip_tags($options['site_description'])."</description>\n";
	echo "</image>\n";
	
	foreach ($website as $web) {
		echo "<item>\n";
		echo "<link>".$web['web_link']."</link>\n";
		echo "<title>".$web['web_name']."</title>\n";
		echo "<author>".$options['site_name']."</author>\n";
		echo "<category>".$web['cate_name']."</category>\n";
		echo "<pubDate>".$web['web_ctime']."</pubDate>\n";
		echo "<guid>".$web['web_link']."</guid>\n";
		echo "<description>".$web['web_intro']."</description>\n";
		echo "</item>\n";
	}
	echo "</channel>\n";
	echo "</rss>";
	
	unset($options, $website);
}
	
/** sitemap */
function get_website_sitemap($cate_id = 0) {
	global $DB, $options;
	
	$where = "web_status=3";
	$cate = get_one_category($cate_id);
	if (!empty($cate)) {
		if ($cate['cate_childcount'] > 0) {
			$where .= " AND cate_id IN (".$cate['cate_arrchildid'].")";
		} else {
			$where .= " AND cate_id=$cate_id";
		}
	}

	$sql = "SELECT web_id, web_url, web_ctime FROM ".$DB->table('website');
	$sql .= " WHERE $where ORDER BY web_id DESC LIMIT 30";
	$query = $DB->query($sql);
	$website = array();
	while ($web = $DB->fetch_array($query)) {
		if ($options['is_enabled_rewrite'] == 'yes') {
			$web['web_link'] = $options['site_url'].'siteinfo/'.$web['web_id'].'/'.$web['web_url'];
		} else {
			$web['web_link'] = str_replace('//', '/', str_replace('&', '&amp;', $options['site_url'].get_weblink($web['web_id'])));
		}
		$web['web_ctime'] = date('Y-m-d H:i:s', $web['web_ctime']);
		$website[] = $web;
	}
	unset($web);
	$DB->free_result($query);
	
	header("Content-Type: application/xml;");
	echo "<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n";
	echo "<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
	echo "<url>\n";
	echo "<loc>".$options['site_url']."</loc>\n";
	echo "<lastmod>".iso8601('Y-m-d\TH:i:s\Z')."</lastmod>\n";
	echo "<changefreq>always</changefreq>\n";
	echo "<priority>0.9</priority>\n";
	echo "</url>\n";
	
	$now = time();
	foreach ($website as $web) {
		$prior = 0.5;
		
		if (datediff('h', $web['web_ctime']) < 24) {
			$freq = "hourly";
			$prior = 0.8;
		} elseif (datediff('d', $web['web_ctime']) < 7) {
			$freq = "daily";
			$prior = 0.7;
		} elseif (datediff('w', $web['web_ctime']) < 4) {
			$freq = "weekly";
		} elseif (datediff('m', $web['web_ctime']) < 12) {
			$freq = "monthly";
		} else {
			$freq = "yearly";
		}
		
		echo "<url>\n";
		echo "<loc>".$web['web_link']."</loc>\n";
		echo "<lastmod>".iso8601('Y-m-d\TH:i:s\Z', $web['web_ctime'])."</lastmod>\n";
		echo "<changefreq>".$freq."</changefreq>\n";
		if ($prior != 0.5) {
			echo "<priority>".$prior."</priority>\n";
		}
		echo "</url>\n";
	}
	echo "</urlset>";
	
	unset($options, $website);
}

/** archives */
function get_archives() {
	global $DB;
	
	$archives = array();
	if (load_cache('archives')) {
		$archives = load_cache('archives');
	} else {
		$time = array();
		$sql = "SELECT web_ctime FROM ".$DB->table('website')." WHERE web_status=3 ORDER BY web_ctime DESC";
		$query = $DB->query($sql);
		while ($row = $DB->fetch_array($query)) {
			$time[] = date('Y-m', $row['web_ctime']);
		}
		unset($row);
		$DB->free_result($query);
		
		$count = array_count_values($time);
		unset($time);
		
		foreach ($count as $key => $val) {
			list($year, $month) = explode('-', $key);
			$archives[$year][$month] = $val;
		}
	}
		
	$newarr = array();
	foreach ($archives as $year => $arr) {
		foreach ($arr as $month => $count) {
			$newarr[$year][$month]['site_count'] = $count;
			$newarr[$year][$month]['arc_link'] = get_arclink($year.$month);
		}
	}
	unset($archives);
	
	return $newarr;
}

/** rss  */
function iso8601($format, $timestamp = NULL) {
	if ($timestamp === NULL) {
		$timestamp = time() - date('Z');
	} elseif ($timestamp <= 0) {
		return '';
	}
	$timestamp += (8 * 3600);
	
	return gmdate($format, time());
}

function datediff($format, $timestamp) {
	$nowtime = time();
	$newtime = $nowtime - $timestamp;
	
	$hour = floor($newtime / 3600);
	$day = floor($newtime / (24 * 3600));
	$week = floor($newtime / (7 * 24 * 3600));
	$month = floor($newtime / (30 * 24 * 3600));

	$format = strtolower($format);
	switch ($format) {
		case 'h' :
			return $hour;
			break;
		case 'd' :
			return $day;
			break;
		case 'w' :
			return $week;
			break;
		case 'm' :
			return $month;
			break;
	}
}
?>