<?php
require('common.php');
require(APP_PATH.'module/category.php');

$fileurl = 'apply.php';
$tempfile = 'apply.html';
$table = $DB->table('apply');

if (!isset($action)) $action = 'list';

/** list */
if ($action == 'list') {
	$pagetitle = '待审站点列表';
	
	$sql = "SELECT a.app_id, a.cate_id, a.web_name, a.web_url, a.web_owner, a.web_email, a.post_time, b.cate_name FROM $table a LEFT JOIN ".$DB->table('categories')." b ON a.cate_id=b.cate_id";	
	$sql .= " ORDER BY a.post_time DESC LIMIT $start, $pagesize";
	$query = $DB->query($sql);
	$website = array();
	while ($row = $DB->fetch_array($query)) {
		$row['web_name'] = '<a href="'.$row['web_url'].'" target="_blank">'.$row['web_name'].'</a>';
		$row['post_time'] = date('Y-m-d', $row['post_time']);
		$row['web_operate'] = '<a href="'.$fileurl.'?act=add&app_id='.$row['app_id'].'">收录</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?act=view&app_id='.$row['app_id'].'">详细</a>&nbsp;|&nbsp;<a href="'.$fileurl.'?act=del&app_id='.$row['app_id'].'" onClick="return confirm(\'确认删除此内容吗？\');">删除</a>';
		$website[] = $row;
	}
	unset($row);
	$DB->free_result($query);
	
	$total = $DB->get_count($table.' a', $where);
	$showpage = showpage($pageurl, $total, $curpage, $pagesize);
	
	$smarty->assign('website', $website);
	$smarty->assign('showpage', $showpage);
	unset($website);
}

/** add */
if ($action == 'add') {
	$pagetitle = '站点收录';
	
	$app_id = intval($_GET['app_id']);
	$web = $DB->fetch_one("SELECT a.app_id, a.cate_id, a.web_name, a.web_url, a.web_tags, a.web_intro, a.web_owner, a.web_email, a.post_time, b.cate_name FROM $table a LEFT JOIN ".$DB->table('categories')." b ON a.cate_id=b.cate_id WHERE a.app_id=$app_id LIMIT 1");
	if (!$web) {
		msgbox('指定的内容不存在！');
	}
	
	$category_option = get_category_option(0, $web['cate_id'], 0);
	
	$smarty->assign('category_option', $category_option);
	$smarty->assign('web', $web);
	$smarty->assign('h_action', 'saveadd');
	unset($web);
}

/** view */
if ($action == 'view') {
	$pagetitle = '查看站点详细';
	
	$app_id = intval($_GET['app_id']);
	$web = $DB->fetch_one("SELECT a.app_id, a.cate_id, a.web_name, a.web_url, a.web_tags, a.web_intro, a.web_owner, a.web_email, a.post_time, b.cate_name FROM $table a LEFT JOIN ".$DB->table('categories')." b ON a.cate_id=b.cate_id WHERE a.app_id=$app_id LIMIT 1");
	if (!$web) {
		msgbox('指定的内容不存在！');
	}
	$smarty->assign('web', $web);
	unset($web);
}

/** del */
if ($action == 'del') {
	$app_ids = (array) ($_POST['app_id'] ? $_POST['app_id'] : $_GET['app_id']);
	
	$DB->delete($table, 'app_id IN ('.dimplode($app_ids).')');
	unset($app_ids);
	
	msgbox('网站删除成功！', $fileurl);
}

/** save data */
if ($action == 'saveadd') {
	$cate_id = intval($_POST['cate_id']);
	$web_name = trim($_POST['web_name']);
	$web_url = trim($_POST['web_url']);
	$web_tags = strtolower(addslashes(trim($_POST['web_tags'])));
	$web_intro = addslashes(trim($_POST['web_intro']));
	$web_owner = trim($_POST['web_owner']);
	$web_email = trim($_POST['web_email']);
	$post_time = time();
	
	if ($cate_id <= 0) {
		msgbox('请选择网站所属分类！');
	} else {
		$cate = get_one_category($cate_id);
		if ($cate['cate_childcount'] > 0) {
			msgbox('指定的分类下有子分类，请选择子分类进行操作！');
		}
	}
	if (empty($web_name)) {
		msgbox('请输入网站名称！');
	}
	
	if (empty($web_url)) {
		msgbox('请输入网站域名！');
	} else {
		if (!is_valid_domain($web_url)) {
			msgbox('请输入正确的网站域名！');
		}
	}
	
	if (empty($web_intro)) {
		msgbox('请输入网站简介！');
	}
	
	$web_tags = str_replace('，', ',', $web_tags);
	$web_tags = str_replace(',,', ',', $web_tags);
	if (substr($web_tags, -1) == ',') {
		$web_tags = substr($web_tags, 0, strlen($web_tags) - 1);
	}
	
    $user = $DB->fetch_one("SELECT user_id FROM ".$DB->table('users')." WHERE user_email='$web_email' LIMIT 1");
    if ($user) {
       	$user_id = $user['user_id'];
    } else {
		$user_data = array(
			'user_email' => $web_email,
			'user_pass' => random(8),
			'nick_name' => $web_owner,
			'join_time' => $post_time,
		);
		
		$DB->insert($DB->table('users'), $user_data);
		$user_id = $DB->insert_id();
	}
	
	$web_data = array(
		'user_id' => $user_id,
		'cate_id' => $cate_id,
		'web_name' => $web_name,
		'web_url' => $web_url,
		'web_tags' => $web_tags,
		'web_intro' => $web_intro,
		'web_errors' => $web_errors,
		'web_isbest' => $web_isbest,
		'web_status' => 3,
		'web_ctime' => $post_time,
	);
	
    $query = $DB->query("SELECT web_id FROM ".$DB->table('website')." WHERE web_name='$web_name' AND web_url='$web_url'");
    if ($DB->num_rows($query) > 0) {
       	msgbox('该网站已被收录！');
    }
	
	$DB->insert($DB->table('website'), $web_data);
	
	$web_id = $DB->insert_id();
	$DB->insert($DB->table('webdata'), array('web_id' => $web_id, 'web_prank' => 0, 'web_srank' => 0, 'web_arank' => 0, 'web_instat' => 0, 'web_outstat' => 0, 'web_views' => 0, 'web_utime' => $post_time));
	$DB->update($DB->table('categories'), array('cate_postcount' => 'cate_postcount+1'), array('cate_id' => $cate_id));
	update_cache('archives');
	
	//发送邮件
	if (!empty($options['smtp_host']) && !empty($options['smtp_port']) && !empty($options['smtp_auth']) && !empty($options['smtp_user'])  && !empty($options['smtp_pass'])) {
		require(APP_PATH.'include/sendmail.php');
		
		$smarty->assign('site_name', $options['site_name']);
		$smarty->assign('site_url', $options['site_url']);
		$smarty->assign('web_id', $web_id);
		$smarty->assign('web_name', $web_name);
		$smarty->assign('web_owner', $web_owner);
		$mailbody = $smarty->fetch('sendmail.html');
		sendmail($web_email, '欢迎提交网站至'.$options['web_name'].'！', $mailbody);
	}
		
	msgbox('网站收录成功！', $fileurl);
}

smarty_output($tempfile);
?>