/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTransport;

class SmbComSessionSetupAndX
extends AndXServerMessageBlock {
    private static final int BATCH_LIMIT = Config.getInt("jcifs.smb.client.SessionSetupAndX.TreeConnectAndX", 1);
    private static final boolean DISABLE_PLAIN_TEXT_PASSWORDS = Config.getBoolean("jcifs.smb.client.disablePlainTextPasswords", true);
    private byte[] lmHash;
    private byte[] ntHash;
    private byte[] blob = null;
    private int sessionKey;
    private String accountName;
    private String primaryDomain;
    SmbSession session;
    Object cred;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SmbComSessionSetupAndX(SmbSession session, ServerMessageBlock andx, Object cred) throws SmbException {
        super(andx);
        this.command = (byte)115;
        this.session = session;
        this.cred = cred;
        this.sessionKey = session.transport.sessionKey;
        if (session.transport.server.security == 1) {
            if (cred instanceof NtlmPasswordAuthentication) {
                NtlmPasswordAuthentication auth = (NtlmPasswordAuthentication)cred;
                if (auth == NtlmPasswordAuthentication.ANONYMOUS) {
                    this.lmHash = new byte[0];
                    this.ntHash = new byte[0];
                } else if (session.transport.server.encryptedPasswords) {
                    this.lmHash = auth.getAnsiHash(session.transport.server.encryptionKey);
                    this.ntHash = auth.getUnicodeHash(session.transport.server.encryptionKey);
                    if (this.lmHash.length == 0 && this.ntHash.length == 0) {
                        throw new RuntimeException("Null setup prohibited.");
                    }
                } else {
                    if (DISABLE_PLAIN_TEXT_PASSWORDS) {
                        throw new RuntimeException("Plain text passwords are disabled");
                    }
                    if (this.useUnicode) {
                        String password = auth.getPassword();
                        this.lmHash = new byte[0];
                        this.ntHash = new byte[(password.length() + 1) * 2];
                        this.writeString(password, this.ntHash, 0);
                    } else {
                        String password = auth.getPassword();
                        this.lmHash = new byte[(password.length() + 1) * 2];
                        this.ntHash = new byte[0];
                        this.writeString(password, this.lmHash, 0);
                    }
                }
                this.accountName = auth.username;
                if (this.useUnicode) {
                    this.accountName = this.accountName.toUpperCase();
                }
                this.primaryDomain = auth.domain.toUpperCase();
                return;
            } else {
                if (!(cred instanceof byte[])) throw new SmbException("Unsupported credential type");
                this.blob = (byte[])cred;
            }
            return;
        } else {
            if (session.transport.server.security != 0) throw new SmbException("Unsupported");
            if (!(cred instanceof NtlmPasswordAuthentication)) throw new SmbException("Unsupported credential type");
            NtlmPasswordAuthentication auth = (NtlmPasswordAuthentication)cred;
            this.lmHash = new byte[0];
            this.ntHash = new byte[0];
            this.accountName = auth.username;
            if (this.useUnicode) {
                this.accountName = this.accountName.toUpperCase();
            }
            this.primaryDomain = auth.domain.toUpperCase();
        }
    }

    int getBatchLimit(byte command) {
        return command == 117 ? BATCH_LIMIT : 0;
    }

    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        SmbComSessionSetupAndX.writeInt2(this.session.transport.snd_buf_size, dst, dstIndex);
        SmbComSessionSetupAndX.writeInt2(this.session.transport.maxMpxCount, dst, dstIndex += 2);
        SmbTransport cfr_ignored_0 = this.session.transport;
        SmbComSessionSetupAndX.writeInt2(1L, dst, dstIndex += 2);
        SmbComSessionSetupAndX.writeInt4(this.sessionKey, dst, dstIndex += 2);
        dstIndex += 4;
        if (this.blob != null) {
            SmbComSessionSetupAndX.writeInt2(this.blob.length, dst, dstIndex);
            dstIndex += 2;
        } else {
            SmbComSessionSetupAndX.writeInt2(this.lmHash.length, dst, dstIndex);
            SmbComSessionSetupAndX.writeInt2(this.ntHash.length, dst, dstIndex += 2);
            dstIndex += 2;
        }
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        dst[dstIndex++] = 0;
        SmbComSessionSetupAndX.writeInt4(this.session.transport.capabilities, dst, dstIndex);
        return (dstIndex += 4) - start;
    }

    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.blob != null) {
            System.arraycopy(this.blob, 0, dst, dstIndex, this.blob.length);
            dstIndex += this.blob.length;
        } else {
            System.arraycopy(this.lmHash, 0, dst, dstIndex, this.lmHash.length);
            System.arraycopy(this.ntHash, 0, dst, dstIndex += this.lmHash.length, this.ntHash.length);
            dstIndex += this.ntHash.length;
            dstIndex += this.writeString(this.accountName, dst, dstIndex);
            dstIndex += this.writeString(this.primaryDomain, dst, dstIndex);
        }
        SmbTransport cfr_ignored_0 = this.session.transport;
        dstIndex += this.writeString(SmbTransport.NATIVE_OS, dst, dstIndex);
        SmbTransport cfr_ignored_1 = this.session.transport;
        dstIndex += this.writeString(SmbTransport.NATIVE_LANMAN, dst, dstIndex);
        return dstIndex - start;
    }

    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    public String toString() {
        SmbTransport cfr_ignored_0 = this.session.transport;
        SmbTransport cfr_ignored_1 = this.session.transport;
        SmbTransport cfr_ignored_2 = this.session.transport;
        String result = new String("SmbComSessionSetupAndX[" + super.toString() + ",snd_buf_size=" + this.session.transport.snd_buf_size + ",maxMpxCount=" + this.session.transport.maxMpxCount + ",VC_NUMBER=" + 1 + ",sessionKey=" + this.sessionKey + ",lmHash.length=" + (this.lmHash == null ? 0 : this.lmHash.length) + ",ntHash.length=" + (this.ntHash == null ? 0 : this.ntHash.length) + ",capabilities=" + this.session.transport.capabilities + ",accountName=" + this.accountName + ",primaryDomain=" + this.primaryDomain + ",NATIVE_OS=" + SmbTransport.NATIVE_OS + ",NATIVE_LANMAN=" + SmbTransport.NATIVE_LANMAN + "]");
        return result;
    }
}

