/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import php.java.bridge.ThreadPool;
import php.java.bridge.Util;

public final class AppThreadPool
extends ThreadPool {
    protected ThreadPool.Delegate createDelegate(String string) {
        return new Delegate(string);
    }

    public AppThreadPool(String string, int n) {
        super(string, n);
    }

    final class Delegate
    extends ThreadPool.Delegate {
        protected ThreadGroup appGroup;

        protected Delegate(String string) {
            super(AppThreadPool.this, new Group(string), string);
            this.appGroup = null;
            ((Group)this.getThreadGroup()).lock();
        }

        public ThreadGroup getAppGroup() {
            if (this.appGroup != null) {
                return this.appGroup;
            }
            Group group = (Group)this.getThreadGroup();
            group.unlock();
            this.appGroup = new AppGroup("JavaBridgeThreadPoolAppGroup");
            group.lock();
            return this.appGroup;
        }

        public void setPersistent() {
            if (!AppThreadPool.this.checkReserve() && !this.terminate) {
                this.terminate = true;
                String string = this.getName();
                this.setName(string + ",isDaemon=true");
                if (Util.logLevel > 5) {
                    string = string + "+";
                }
                this.createThread(string);
            }
            this.end();
        }

        protected void createThread(String string) {
            Group group = (Group)this.getThreadGroup();
            group.unlock();
            super.createThread(string);
            group.lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void terminate() {
            ThreadGroup threadGroup;
            if (Util.logLevel > 4) {
                Util.logDebug("term (thread removed from pool): " + this);
            }
            if ((threadGroup = this.appGroup) != null) {
                try {
                    threadGroup.interrupt();
                }
                catch (SecurityException securityException) {
                    return;
                }
                try {
                    threadGroup.destroy();
                }
                catch (SecurityException securityException) {
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    Util.printStackTrace(illegalThreadStateException);
                }
                catch (Exception exception) {
                    Util.printStackTrace(exception);
                }
                finally {
                    this.appGroup = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void end() {
            ThreadGroup threadGroup;
            super.end();
            if (Util.logLevel > 4) {
                Util.logDebug("end (thread returned to pool): " + this);
            }
            if ((threadGroup = this.appGroup) != null) {
                try {
                    threadGroup.interrupt();
                }
                catch (SecurityException securityException) {
                }
                catch (Exception exception) {
                    Util.printStackTrace(exception);
                }
                finally {
                    this.appGroup = null;
                }
            }
        }
    }

    static final class AppGroup
    extends ThreadGroup {
        private void init() {
            this.setDaemon(true);
        }

        public AppGroup(String string) {
            super(string);
            this.init();
        }

        public AppGroup(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.init();
        }
    }

    static final class Group
    extends ThreadGroup {
        boolean isLocked = false;

        void lock() {
            this.isLocked = true;
        }

        void unlock() {
            this.isLocked = false;
        }

        private void init() {
            this.setDaemon(true);
        }

        public Group(String string) {
            super(string);
            this.init();
        }

        public Group(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
            this.init();
        }
    }
}

