/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.IOException;
import php.java.bridge.Base64EncodingOutputBuffer;
import php.java.bridge.HexOutputBuffer;
import php.java.bridge.JavaBridge;
import php.java.bridge.Response;

public class ClassicResponse
extends Response {
    protected long result;

    protected HexOutputBuffer createBase64OutputBuffer() {
        return new Base64OutputBuffer(this.bridge);
    }

    protected HexOutputBuffer createOutputBuffer() {
        return super.createOutputBuffer();
    }

    public ClassicResponse(JavaBridge javaBridge) {
        super(javaBridge);
    }

    protected ClassicResponse(JavaBridge javaBridge, HexOutputBuffer hexOutputBuffer) {
        super(javaBridge, hexOutputBuffer);
    }

    public Response copyResponse() throws IOException {
        this.flush();
        return new ClassicResponse(this.bridge, this.buf);
    }

    protected void setID(long l) {
        this.result = l;
    }

    void writeString(byte[] byArray) {
        this.buf.appendString(byArray);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeBoolean(boolean bl) {
        this.buf.append(B);
        this.buf.write(bl ? 84 : 70);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeLong(long l) {
        this.buf.appendLong(l);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeDouble(double d) {
        this.buf.append(D);
        this.buf.append(d);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeNull() {
        this.buf.append(N);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeVoid() {
        this.buf.append(V);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeObject(Object object) {
        if (object == null) {
            this.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(object));
        this.buf.append(this.getType(clazz));
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeClass(Class clazz) {
        if (clazz == null) {
            this.writeNull();
            return;
        }
        this.buf.append(O);
        this.buf.append(this.bridge.globalRef.append(clazz));
        this.buf.append(po);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeException(Object object, String string) {
        this.buf.append(E);
        this.buf.append(this.bridge.globalRef.append(object));
        this.buf.append(m);
        this.buf.appendQuoted(string);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(e);
    }

    void writeFinish(boolean bl) {
        if (bl) {
            this.buf.append(Fa);
        } else {
            this.buf.append(Fe);
        }
    }

    void writeCompositeBegin_a() {
        this.buf.append(Xa);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(c);
    }

    void writeCompositeBegin_h() {
        this.buf.append(Xh);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(c);
    }

    void writeApplyBegin(long l, String string, String string2, int n) {
        this.buf.append(A);
        this.buf.append(l);
        this.buf.append(p);
        this.buf.appendQuoted(string);
        this.buf.append(m);
        this.buf.appendQuoted(string2);
        this.buf.append(ClassicResponse.n);
        this.buf.append(n);
        this.buf.append(I);
        this.buf.append(this.result);
        this.buf.append(c);
    }

    private class Base64OutputBuffer
    extends ClassicOutputBuffer {
        Base64OutputBuffer(JavaBridge javaBridge) {
            super(javaBridge);
        }

        protected void appendQuoted(byte[] byArray) {
            this.appendBase64(byArray);
        }
    }

    private class ClassicOutputBuffer
    extends Base64EncodingOutputBuffer {
        ClassicOutputBuffer(JavaBridge javaBridge) {
            super(javaBridge);
        }

        protected void append(long l) {
            this.append(String.valueOf(l).getBytes());
        }

        protected void appendLong(long l) {
            this.append(Response.L);
            this.append(l);
        }
    }
}

