/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import php.java.bridge.DynamicHttpURLConnectionHandler;
import php.java.bridge.Util;

public class DynamicJarURLConnection
extends JarURLConnection {
    private DynamicHttpURLConnectionHandler handler;
    private Map headerFields;
    private JarFile jarFile;
    private JarEntry entry;

    protected DynamicJarURLConnection(URL uRL, DynamicHttpURLConnectionHandler dynamicHttpURLConnectionHandler) throws MalformedURLException {
        super(uRL);
        this.handler = dynamicHttpURLConnectionHandler;
        if (Util.logLevel > 4) {
            Util.logDebug("tempfile create DynamicJarURLConnection for " + dynamicHttpURLConnectionHandler);
        }
    }

    public void connect() throws IOException {
        if (!this.connected) {
            if (Util.logLevel > 4) {
                Util.logDebug("tempfile open connection for " + this.handler);
            }
            this.jarFileURLConnection = this.getJarFileURL().openConnection();
            this.jarFileURLConnection.connect();
            this.connected = true;
        }
    }

    public Map getHeaderFields() {
        if (this.headerFields != null) {
            return this.headerFields;
        }
        this.headerFields = this.handler.getHeaderFields();
        if (this.headerFields != null) {
            return this.headerFields;
        }
        try {
            if (!this.connected) {
                this.connect();
            }
            if (Util.logLevel > 4) {
                Util.logDebug("tempfile getHeaderFields for " + this.handler);
            }
            this.headerFields = new HashMap();
            Map<String, List<String>> map = this.jarFileURLConnection.getHeaderFields();
            StringBuffer stringBuffer = new StringBuffer();
            Iterator<Map.Entry<String, List<String>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                List<String> list;
                Map.Entry<String, List<String>> entry = iterator.next();
                String string = entry.getKey();
                if (string == null || (list = entry.getValue()) == null) continue;
                List<String> list2 = list;
                Iterator<String> iterator2 = list2.iterator();
                if (iterator2.hasNext()) {
                    stringBuffer.append((Object)iterator2.next());
                }
                while (iterator2.hasNext()) {
                    stringBuffer.append(", ");
                    stringBuffer.append((Object)iterator2.next());
                }
                String string2 = string;
                string2 = string2.toLowerCase();
                this.headerFields.put(string2, stringBuffer.toString());
                stringBuffer.setLength(0);
            }
            this.handler.setHeaderFields(this.headerFields);
            return this.headerFields;
        }
        catch (IOException iOException) {
            Util.printStackTrace(iOException);
            throw new RuntimeException(iOException);
        }
    }

    public String getHeaderField(String string) {
        String string2 = (String)this.getHeaderFields().get(string);
        return string2;
    }

    public JarFile getJarFile() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile;
        }
        this.jarFile = this.handler.getTempFile();
        if (this.jarFile != null) {
            return this.jarFile;
        }
        if (!this.connected) {
            this.connect();
        }
        if (Util.logLevel > 4) {
            Util.logDebug("tempfile getJarFile for " + this.handler);
        }
        InputStream inputStream = this.jarFileURLConnection.getInputStream();
        byte[] byArray = new byte[8192];
        File file = File.createTempFile("cache", "jar");
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
        JarFile jarFile = new JarFile(file, true, 1);
        this.handler.setTempFile(jarFile, file);
        this.jarFile = jarFile;
        return this.jarFile;
    }

    public InputStream getInputStream() throws IOException {
        if (this.entry != null) {
            return this.getJarFile().getInputStream(this.entry);
        }
        if (!this.connected) {
            this.connect();
        }
        this.entry = this.getJarEntry();
        long l = this.entry.getSize();
        if (l > Integer.MAX_VALUE) {
            throw new IOException("zip file too large");
        }
        int n = (int)l;
        this.getHeaderFields().put("content-length", String.valueOf(n));
        return this.getJarFile().getInputStream(this.entry);
    }

    public long getLastModified() {
        long l = 0L;
        try {
            if (!this.connected) {
                this.connect();
            }
            if (Util.logLevel > 4) {
                Util.logDebug("tempfile getLastModified for " + this.handler);
            }
            l = this.jarFileURLConnection.getLastModified();
        }
        catch (IOException iOException) {
            Util.printStackTrace(iOException);
        }
        return l;
    }
}

