/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import php.java.bridge.DynamicClassLoader;
import php.java.bridge.JarLibraryPath;
import php.java.bridge.Util;

public class DynamicJavaBridgeClassLoader
extends DynamicClassLoader {
    private static final URL[] EMPTY_URL = new URL[0];
    private static final JarLibraryPath EMPTY_PATH = new JarLibraryPath(){

        public URL[] getURLs() {
            return EMPTY_URL;
        }
    };
    static final boolean IS_GNU_JAVA = DynamicJavaBridgeClassLoader.checkVM();
    static final String LD_LIBRARY_PATH = DynamicJavaBridgeClassLoader.getLD_LIBRARY_PATH();
    static final String CLASSPATH = DynamicJavaBridgeClassLoader.getCLASSPATH();

    protected DynamicJavaBridgeClassLoader(DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader) {
        super(dynamicJavaBridgeClassLoader);
    }

    protected DynamicJavaBridgeClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    protected DynamicJavaBridgeClassLoader() {
    }

    public static JarLibraryPath checkJarLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        if (string == null || string.length() < 1) {
            return EMPTY_PATH;
        }
        return new JarLibraryPath(string, string2, string3, string4);
    }

    public void updateJarLibraryPath(String string, String string2, String string3, String string4) throws IOException {
        this.updateJarLibraryPath(DynamicJavaBridgeClassLoader.checkJarLibraryPath(string, string2, string3, string4));
    }

    public void updateJarLibraryPath(JarLibraryPath jarLibraryPath) {
        String string = jarLibraryPath.getPath();
        URL[] uRLArray = jarLibraryPath.getURLs();
        if (uRLArray.length > 0) {
            this.addURLs(string, uRLArray, false);
        }
        jarLibraryPath.addToCache();
    }

    static URL checkUrl(URL uRL) throws IOException {
        uRL.getProtocol();
        return uRL;
    }

    static void checkJarFile(File file) throws IOException {
        try {
            DynamicJavaBridgeClassLoader.doCheckJarFile(file);
        }
        catch (IOException iOException) {
            IOException iOException2 = new IOException("Could not open jar file " + file + ", reason: " + String.valueOf(iOException.getMessage()));
            iOException2.initCause(iOException);
            throw iOException2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCheckJarFile(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        try {
            Manifest manifest = jarFile.getManifest();
            if (Util.logLevel > 4 && manifest != null) {
                Set<Map.Entry<Object, Object>> set = manifest.getMainAttributes().entrySet();
                if (Util.logLevel > 5) {
                    Util.logDebug("ClassLoader: loaded file: " + file + ", main attributes: " + set);
                }
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (Exception exception) {}
        }
    }

    static void addJars(List list, File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.getName().endsWith(".jar")) continue;
            try {
                list.add(new URL("file", null, file2.getAbsolutePath()));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                Util.printStackTrace(malformedURLException);
            }
        }
    }

    public DynamicJavaBridgeClassLoader clearVMLoader() {
        DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader = new DynamicJavaBridgeClassLoader(this);
        this.copyInto(dynamicJavaBridgeClassLoader);
        return dynamicJavaBridgeClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.clearLoader();
            DynamicJavaBridgeClassLoader.clearCache();
        }
    }

    public void clear() {
        this.clearLoader();
    }

    private static final boolean checkVM() {
        try {
            return "libgcj".equals(System.getProperty("gnu.classpath.vm.shortname"));
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static final String getLD_LIBRARY_PATH() {
        try {
            return System.getProperty("java.library.path");
        }
        catch (Throwable throwable) {
            return "[error: no java.library.path set]";
        }
    }

    private static final String getCLASSPATH() {
        try {
            return System.getProperty("java.ext.dirs");
        }
        catch (Throwable throwable) {
            return "[error: no java.ext.dirs set]";
        }
    }

    protected String resolveLibraryName(String string) {
        URL uRL = this.findResource("lib" + string + ".so");
        if (uRL == null) {
            uRL = this.findResource(string + ".dll");
        }
        if (uRL != null) {
            return new File(uRL.getPath()).getAbsolutePath();
        }
        throw new UnsatisfiedLinkError("Native library " + string + " could not be found in java_require() path.");
    }

    protected DynamicClassLoader.URLClassLoaderFactory getUrlClassLoaderFactory() {
        return new DynamicClassLoader.URLClassLoaderFactory(){

            public URLClassLoader createUrlClassLoader(String string, URL[] uRLArray, ClassLoader classLoader) {
                URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, classLoader){
                    private Map cache;
                    {
                        this.cache = new HashMap();
                    }

                    public String toString() {
                        return String.valueOf(DynamicJavaBridgeClassLoader.this.arrayToString(this.getURLs()));
                    }

                    public Class loadClass(String string) throws ClassNotFoundException {
                        Class clazz = null;
                        Object var3_3 = null;
                        if (Util.logLevel > 4) {
                            Util.logDebug("trying to load class: " + string + " from: " + "LOADER-ID" + System.identityHashCode(this));
                        }
                        if ((var3_3 = this.cache.get(string)) != "not found") {
                            if (var3_3 != null) {
                                return var3_3;
                            }
                            try {
                                clazz = this.doLoadClass(string);
                                this.cache.put(string, clazz);
                                return clazz;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                this.cache.put(string, "not found");
                            }
                        }
                        throw new ClassNotFoundException(string);
                    }

                    private Class doLoadClass(String string) throws ClassNotFoundException {
                        Class<?> clazz = null;
                        try {
                            ClassLoader classLoader = this.getParent();
                            if (classLoader != null) {
                                try {
                                    clazz = classLoader.loadClass(string);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    // empty catch block
                                }
                            }
                            if (clazz == null) {
                                clazz = super.findClass(string);
                            }
                            if (clazz != null) {
                                return clazz;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw classNotFoundException;
                        }
                        catch (Exception exception) {
                            throw new ClassNotFoundException("Class " + string + " not found due to exception: " + exception + ".", exception);
                        }
                        throw new ClassNotFoundException(string);
                    }

                    public URL findResource(String string) {
                        return super.findResource(string);
                    }

                    protected String findLibrary(String string) {
                        if (Util.logLevel > 4) {
                            Util.logDebug("trying to load library: " + string + " from: " + "LOADER-ID" + System.identityHashCode(this));
                        }
                        if (!IS_GNU_JAVA) {
                            throw new UnsatisfiedLinkError("This java VM can only load pure java libraries. Either use GNU java instead or move the java library to " + CLASSPATH + " and the shared library " + string + " to " + LD_LIBRARY_PATH);
                        }
                        String string2 = super.findLibrary(string);
                        if (string2 != null) {
                            return string2;
                        }
                        return DynamicJavaBridgeClassLoader.this.resolveLibraryName(string);
                    }
                };
                if (Util.logLevel > 4) {
                    Util.logDebug("Added LOADER-ID" + System.identityHashCode(uRLClassLoader) + "\nOrigPath: " + string + "\nTranslated: " + DynamicJavaBridgeClassLoader.this.arrayToString(uRLArray));
                }
                return uRLClassLoader;
            }
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.classPaths.iterator();
        DynamicClassLoader.URLClassLoaderEntry uRLClassLoaderEntry = null;
        while (iterator.hasNext()) {
            uRLClassLoaderEntry = (DynamicClassLoader.URLClassLoaderEntry)this.classLoaders.get(iterator.next());
            stringBuffer.append(uRLClassLoaderEntry.toString());
            stringBuffer.append(";");
        }
        ClassLoader classLoader = this.getParent();
        if (classLoader != null && classLoader instanceof URLClassLoader) {
            stringBuffer.append(String.valueOf(this.arrayToString(((URLClassLoader)classLoader).getURLs())));
            stringBuffer.append(";");
        }
        return stringBuffer.toString();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        try {
            return super.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClassNotFoundException("Could not find " + string + " in java_require() path. Please check the path and the SEL and File permissions.", classNotFoundException);
        }
    }

    public static synchronized DynamicJavaBridgeClassLoader newInstance(ClassLoader classLoader) {
        try {
            DynamicJavaBridgeClassLoader dynamicJavaBridgeClassLoader = new DynamicJavaBridgeClassLoader(classLoader);
            dynamicJavaBridgeClassLoader.setUrlClassLoaderFactory(dynamicJavaBridgeClassLoader.getUrlClassLoaderFactory());
            return dynamicJavaBridgeClassLoader;
        }
        catch (AccessControlException accessControlException) {
            return null;
        }
    }
}

