/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import php.java.bridge.ILogger;
import php.java.bridge.Util;

public class FileLogger
implements ILogger {
    static boolean haveDateFormat = true;
    private static Object _form;
    private boolean isInit = false;

    private void init() {
        if (Util.logStream == null) {
            if (Util.DEFAULT_LOG_FILE.trim().length() == 0) {
                Util.logStream = System.err;
            } else {
                try {
                    Util.logStream = new PrintStream(new FileOutputStream(Util.DEFAULT_LOG_FILE));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Util.logStream = System.err;
                }
            }
        }
        this.isInit = true;
    }

    public String now() {
        if (!haveDateFormat) {
            return String.valueOf(System.currentTimeMillis());
        }
        try {
            if (_form == null) {
                _form = new SimpleDateFormat("MMM dd HH:mm:ss", Locale.ENGLISH);
            }
            return ((SimpleDateFormat)_form).format(new Date());
        }
        catch (Throwable throwable) {
            haveDateFormat = false;
            return this.now();
        }
    }

    public void log(String string) {
        if (!this.isInit) {
            this.init();
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Util.printStackTrace(unsupportedEncodingException);
            byArray = string.getBytes();
        }
        Util.logStream.write(byArray, 0, byArray.length);
        Util.logStream.println("");
        Util.logStream.flush();
    }

    public void printStackTrace(Throwable throwable) {
        if (!this.isInit) {
            this.init();
        }
        if (Util.logLevel > 0) {
            if (throwable instanceof Error) {
                Util.println(1, "An error occured: " + throwable);
            } else if (Util.logLevel > 1) {
                Util.println(2, "An exception occured: " + throwable);
            }
            throwable.printStackTrace(Util.logStream);
        }
    }

    public void log(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer(this.now());
        stringBuffer.append(" ");
        stringBuffer.append(Util.EXTENSION_NAME);
        stringBuffer.append(" ");
        switch (n) {
            case 1: {
                stringBuffer.append("FATAL");
                break;
            }
            case 2: {
                stringBuffer.append("ERROR");
                break;
            }
            case 3: {
                stringBuffer.append("INFO ");
                break;
            }
            case 4: {
                stringBuffer.append("DEBUG");
                break;
            }
            default: {
                stringBuffer.append(n);
            }
        }
        stringBuffer.append(": ");
        stringBuffer.append(string);
        this.log(stringBuffer.toString());
    }

    public void warn(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.now());
        stringBuffer.append(" ");
        stringBuffer.append(Util.EXTENSION_NAME);
        stringBuffer.append(" ");
        stringBuffer.append("WARNING");
        stringBuffer.append(": ");
        stringBuffer.append(string);
        this.log(stringBuffer.toString());
    }

    public String toString() {
        return "DefaultLogger";
    }
}

