/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import php.java.bridge.JavaBridge;

class GlobalRef {
    public static final int DEFAULT_SIZE = 1021;
    private int threshold;
    private Entry[] globalRef;
    private int id = 1;
    private int count = 0;

    public GlobalRef(int n) {
        this.globalRef = new Entry[n];
        this.threshold = (n >>> 2) * 3;
    }

    public GlobalRef() {
        this(1021);
    }

    public Object get(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.globalRef.length;
        Entry entry = this.globalRef[n2];
        while (entry != null) {
            if (entry.id == n) {
                return entry.value;
            }
            entry = entry.next;
        }
        throw new NullPointerException();
    }

    public void remove(int n) {
        int n2 = (n & Integer.MAX_VALUE) % this.globalRef.length;
        Entry entry = this.globalRef[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.id == n) {
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    this.globalRef[n2] = entry.next;
                }
                --this.count;
            }
            entry2 = entry;
            entry = entry.next;
        }
    }

    public String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.count; ++i) {
            if (this.globalRef[i] == null) continue;
            Entry entry = this.globalRef[i];
            while (entry != null) {
                stringBuffer.append("globalRef[" + i + "]=" + JavaBridge.objectDebugDescription(entry.value) + "\n");
                entry = entry.next;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "GlobalRef: " + this.dump();
    }

    public int append(Object object) {
        return this.put(this.id++, object);
    }

    private int put(int n, Object object) {
        int n2 = (n & Integer.MAX_VALUE) % this.globalRef.length;
        Entry entry = this.globalRef[n2];
        while (entry != null) {
            if (entry.id == n) {
                entry.value = object;
                return n;
            }
            entry = entry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(n, object);
        }
        this.globalRef[n2] = new Entry(n, object, this.globalRef[n2]);
        ++this.count;
        return n;
    }

    private void rehash() {
        int n = this.globalRef.length;
        Entry[] entryArray = this.globalRef;
        int n2 = (n << 1) + 1;
        Entry[] entryArray2 = new Entry[n2];
        this.threshold = (n2 >>> 2) * 3;
        this.globalRef = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.id & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    class Entry {
        int id;
        Object value;
        Entry next;

        public Entry(int n, Object object, Entry entry) {
            this.id = n;
            this.value = object;
            this.next = entry;
        }
    }
}

