/*
 * Decompiled with CFR 0.152.
 */
package php.java.bridge;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import php.java.bridge.ISocketFactory;
import php.java.bridge.JavaBridge;
import php.java.bridge.Request;
import php.java.bridge.Util;
import php.java.bridge.http.AbstractChannelName;
import php.java.bridge.http.ContextFactory;
import php.java.bridge.http.ContextServer;
import php.java.bridge.http.HttpRequest;
import php.java.bridge.http.HttpResponse;
import php.java.bridge.http.HttpServer;
import php.java.bridge.http.IContextFactory;

public class JavaBridgeRunner
extends HttpServer {
    private static Class JavaInc;
    private boolean isStandalone = false;
    protected static JavaBridgeRunner runner;
    private static ContextServer ctxServer;
    private byte[] cache;

    protected JavaBridgeRunner(String string) throws IOException {
        super(string);
        ctxServer = new ContextServer("");
    }

    protected JavaBridgeRunner() throws IOException {
        ctxServer = new ContextServer("");
    }

    public static synchronized JavaBridgeRunner getInstance(String string) throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner(string);
        return runner;
    }

    public static synchronized JavaBridgeRunner getRequiredInstance(String string) {
        if (runner != null) {
            return runner;
        }
        try {
            runner = new JavaBridgeRunner(string);
        }
        catch (IOException iOException) {
            Util.printStackTrace(iOException);
        }
        return runner;
    }

    public static synchronized JavaBridgeRunner getInstance() throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner();
        return runner;
    }

    public static synchronized JavaBridgeRunner getStandaloneInstance(String string) throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner(string);
        JavaBridgeRunner.runner.isStandalone = true;
        return runner;
    }

    public static synchronized JavaBridgeRunner getRequiredStandaloneInstance(String string) {
        if (runner != null) {
            return runner;
        }
        try {
            runner = new JavaBridgeRunner(string);
        }
        catch (IOException iOException) {
            Util.printStackTrace(iOException);
        }
        JavaBridgeRunner.runner.isStandalone = true;
        return runner;
    }

    public static synchronized JavaBridgeRunner getStandaloneInstance() throws IOException {
        if (runner != null) {
            return runner;
        }
        runner = new JavaBridgeRunner();
        JavaBridgeRunner.runner.isStandalone = true;
        return runner;
    }

    public ISocketFactory bind(String string) throws IOException {
        this.socket = JavaBridge.bind(string);
        return this.socket;
    }

    private static IContextFactory getContextFactory(HttpRequest httpRequest, HttpResponse httpResponse, ContextFactory.ICredentials iCredentials) {
        String string = JavaBridgeRunner.getHeader("X_JAVABRIDGE_CONTEXT", httpRequest);
        IContextFactory iContextFactory = ContextFactory.get(string, iCredentials);
        if (iContextFactory == null) {
            iContextFactory = ContextFactory.addNew();
        }
        httpResponse.setHeader("X_JAVABRIDGE_CONTEXT", iContextFactory.getId());
        return iContextFactory;
    }

    private static String getHeader(String string, HttpRequest httpRequest) {
        String string2 = httpRequest.getHeader(string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            string2 = null;
        }
        return string2;
    }

    protected void doPut(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        String string = JavaBridgeRunner.getHeader("X_JAVABRIDGE_CHANNEL", httpRequest);
        ContextFactory.ICredentials iCredentials = ctxServer.getCredentials(string);
        IContextFactory iContextFactory = JavaBridgeRunner.getContextFactory(httpRequest, httpResponse, iCredentials);
        JavaBridge javaBridge = iContextFactory.getBridge();
        javaBridge.in = inputStream = httpRequest.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        javaBridge.out = byteArrayOutputStream;
        javaBridge.request = new Request(javaBridge);
        Request request = javaBridge.request;
        if (request.init(inputStream, byteArrayOutputStream)) {
            AbstractChannelName abstractChannelName = ctxServer.getFallbackChannelName(string, iContextFactory);
            httpResponse.setHeader("X_JAVABRIDGE_REDIRECT", abstractChannelName.getName());
            request.handleRequests();
            if (javaBridge.logLevel > 3) {
                javaBridge.logDebug("re-directing to port# " + abstractChannelName);
            }
            httpResponse.setContentLength(byteArrayOutputStream.size());
            outputStream = httpResponse.getOutputStream();
            byteArrayOutputStream.writeTo(outputStream);
            outputStream.close();
            ctxServer.start(abstractChannelName);
            if (javaBridge.logLevel > 3) {
                javaBridge.logDebug("waiting for context: " + iContextFactory.getId());
            }
            try {
                iContextFactory.waitFor();
            }
            catch (InterruptedException interruptedException) {
                Util.printStackTrace(interruptedException);
            }
        } else {
            iContextFactory.destroy();
        }
    }

    protected boolean showDirectory(String string, File file, int n, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        File file2;
        if (!file.isDirectory()) {
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8")));
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<title>Directory Listing for " + string + "/</title>");
        printWriter.println("<STYLE><!--H1{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} H3{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} BODY{font-family : sans-serif,Arial,Tahoma;color : black;background-color : white;} B{color : white;background-color : #0086b2;} A{color : black;} HR{color : #0086b2;} --></STYLE> </head>");
        File file3 = file.getParentFile();
        String string2 = file3 == null ? "/" : file3.getName();
        printWriter.println("<body><h1>Directory Listing for " + string + " - <a href=\"../\"><b>Up To " + string2 + "</b></a></h1><HR size=\"1\" noshade><table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">");
        printWriter.println("<tr>");
        printWriter.println("<td align=\"left\"><font size=\"+1\"><strong>Filename</strong></font></td>");
        printWriter.println("<td align=\"left\"><font size=\"+1\"><strong>Type</strong></font></td>");
        printWriter.println("<td align=\"center\"><font size=\"+1\"><strong>Size</strong></font></td>");
        printWriter.println("<td align=\"right\"><font size=\"+1\"><strong>Last Modified</strong></font></td>");
        printWriter.println("");
        printWriter.println("</tr>");
        File[] fileArray = file.listFiles();
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            boolean bl;
            file2 = fileArray[i];
            if (file2.isHidden()) continue;
            boolean bl2 = bl = n2++ % 2 == 0;
            if (bl) {
                printWriter.println("<tr>");
            } else {
                printWriter.println("<tr bgcolor=\"eeeeee\">");
            }
            if (string.length() != 0 && !string.endsWith("/")) {
                stringBuffer.append(file.getName());
                stringBuffer.append("/");
            }
            stringBuffer.append(file2.getName());
            if (file2.isDirectory()) {
                stringBuffer.append("/");
            }
            printWriter.println("<td align=\"left\">&nbsp;&nbsp;");
            if (file2.isDirectory()) {
                printWriter.println("<a href=\"" + stringBuffer.toString() + "\"><tt>" + file2.getName() + "/</tt></a></td>");
                printWriter.println("<td align=\"left\">&nbsp;&nbsp;");
                printWriter.println("<a href=\"" + stringBuffer.toString() + "?edit\"><tt>directory</tt></a></td>");
            } else {
                printWriter.println("<a href=\"" + stringBuffer.toString() + "\"><tt>" + file2.getName() + "</tt></a></td>");
                printWriter.println("<td align=\"left\">&nbsp;&nbsp;");
                printWriter.println("<a href=\"" + stringBuffer.toString() + "?show\"><tt>file</tt></a></td>");
            }
            printWriter.println("<td align=\"right\"><tt>" + file2.length() + "</tt></td>");
            printWriter.println("<td align=\"right\"><tt>" + Util.formatDateTime(file2.lastModified()) + "</tt></td>");
            printWriter.println("</tr>");
            stringBuffer.setLength(0);
        }
        printWriter.println("</table>");
        printWriter.println("<HR size=\"1\" noshade><h3>Simple JSR 223 enabled web server version 0.0.1</h3>");
        printWriter.println("<h4>Available script engines</h4><ul>");
        try {
            Class<?> clazz = Class.forName("javax.script.ScriptEngineManager");
            file2 = clazz.newInstance();
            Method method = clazz.getMethod("getEngineFactories", new Class[0]);
            List list = (List)method.invoke((Object)file2, new Object[0]);
            StringBuffer stringBuffer2 = new StringBuffer();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                file2 = iterator.next();
                Method method2 = file2.getClass().getMethod("getEngineName", new Class[0]);
                Method method3 = file2.getClass().getMethod("getEngineVersion", new Class[0]);
                Method method4 = file2.getClass().getMethod("getNames", new Class[0]);
                Method method5 = file2.getClass().getMethod("getExtensions", new Class[0]);
                stringBuffer2.append("<li>");
                stringBuffer2.append(method2.invoke((Object)file2, new Object[0]));
                stringBuffer2.append(", ");
                stringBuffer2.append("ver.: ");
                stringBuffer2.append(method3.invoke((Object)file2, new Object[0]));
                stringBuffer2.append(", ");
                stringBuffer2.append("alias: ");
                stringBuffer2.append(method4.invoke((Object)file2, new Object[0]));
                stringBuffer2.append(", ");
                stringBuffer2.append(".ext: ");
                stringBuffer2.append(method5.invoke((Object)file2, new Object[0]));
                stringBuffer2.append("</li>");
                printWriter.println(stringBuffer2);
                stringBuffer2.setLength(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        printWriter.println("</font></ul>");
        printWriter.println("</body>");
        printWriter.println("</html>");
        httpResponse.addHeader("Content-Type", "text/html; charset=UTF-8");
        httpResponse.addHeader("Last-Modified", Util.formatDateTime(file.lastModified()));
        printWriter.close();
        int n3 = byteArrayOutputStream.size();
        httpResponse.setContentLength(n3);
        byteArrayOutputStream.writeTo(httpResponse.getOutputStream());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean handleScriptContent(String string, String string2, File file, int n, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        if ("show".equals(string2)) {
            return false;
        }
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return false;
        }
        String string3 = string.substring(n2 + 1);
        try {
            PrintWriter printWriter;
            ByteArrayOutputStream byteArrayOutputStream;
            block27: {
                Object object;
                Class<?> clazz = Class.forName("javax.script.ScriptEngineManager");
                Object obj = clazz.newInstance();
                Method method = clazz.getMethod("getEngineByExtension", String.class);
                if ("php".equals(string3)) {
                    string3 = "phtml";
                }
                if ((object = method.invoke(obj, (Object[])new String[]{string3})) == null) {
                    method = clazz.getMethod("getEngineByName", String.class);
                    object = method.invoke(obj, (Object[])new String[]{string3});
                }
                if (object == null) {
                    return false;
                }
                byteArrayOutputStream = new ByteArrayOutputStream();
                Method method2 = object.getClass().getMethod("getContext", new Class[0]);
                Method method3 = object.getClass().getMethod("eval", Reader.class);
                Object object2 = method2.invoke(object, new Object[0]);
                Method method4 = object2.getClass().getMethod("setWriter", Writer.class);
                Method method5 = object2.getClass().getMethod("setErrorWriter", Writer.class);
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8"));
                method4.invoke(object2, printWriter);
                method5.invoke(object2, printWriter);
                Method method6 = object.getClass().getMethod("getBindings", Integer.TYPE);
                Object object3 = method6.invoke(object, new Integer(200));
                Method method7 = object3.getClass().getMethod("put", Object.class, Object.class);
                StringBuffer stringBuffer = new StringBuffer("/");
                stringBuffer.append(string);
                if (string2 != null) {
                    stringBuffer.append("?");
                    stringBuffer.append(string2);
                }
                method7.invoke(object3, "REQUEST_URI", stringBuffer.toString());
                method7.invoke(object3, "SCRIPT_FILENAME", file.getAbsolutePath());
                InputStreamReader inputStreamReader = null;
                Object[] objectArray = new Object[1];
                inputStreamReader = new FileReader(file);
                objectArray[0] = inputStreamReader;
                method3.invoke(object, objectArray);
                try {
                    method3.invoke(object, new Object[]{null});
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (inputStreamReader != null) {
                    try {
                        inputStreamReader.close();
                    }
                    catch (Exception exception) {}
                }
                break block27;
                catch (Throwable throwable) {
                    try {
                        throwable.printStackTrace(printWriter);
                        Util.printStackTrace(throwable);
                    }
                    catch (Throwable throwable2) {
                        try {
                            method3.invoke(object, new Object[]{null});
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (inputStreamReader != null) {
                            try {
                                inputStreamReader.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        throw throwable2;
                    }
                    try {
                        method3.invoke(object, new Object[]{null});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            httpResponse.addHeader("Content-Type", "text/html; charset=UTF-8");
            httpResponse.setContentLength(byteArrayOutputStream.size());
            OutputStream outputStream = httpResponse.getOutputStream();
            printWriter.close();
            byteArrayOutputStream.writeTo(outputStream);
        }
        catch (Exception exception) {
            Util.printStackTrace(exception);
            return false;
        }
        return true;
    }

    protected void showTextFile(String string, String string2, File file, int n, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        int n2;
        boolean bl = "show".equals(string2);
        if (Util.logLevel > 4) {
            Util.logDebug("web server: show text file:" + string);
        }
        httpResponse.addHeader("Last-Modified", Util.formatDateTime(file.lastModified()));
        if (bl) {
            httpResponse.addHeader("Content-Type", "text/plain");
        }
        httpResponse.setContentLength(n);
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[8192];
        OutputStream outputStream = httpResponse.getOutputStream();
        while ((n2 = ((InputStream)fileInputStream).read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
        }
        ((InputStream)fileInputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        boolean bl = false;
        String string = httpRequest.getRequestURI();
        if (string == null) {
            super.doGet(httpRequest, httpResponse);
            return;
        }
        if (!string.startsWith("/JavaBridge")) {
            File file;
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            String string2 = null;
            int n = string.indexOf(63);
            if (n != -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            if ((file = new File(Util.HOME_DIR, string)) == null || !file.exists()) {
                file = new File(string);
            }
            if (file == null || !file.exists()) {
                return;
            }
            if (file.isHidden()) {
                return;
            }
            long l = file.length();
            if (l >= Integer.MAX_VALUE) {
                throw new IOException("file " + string + " too large");
            }
            int n2 = (int)l;
            if (this.showDirectory(string, file, n2, httpRequest, httpResponse)) {
                return;
            }
            if (this.handleScriptContent(string, string2, file, n2, httpRequest, httpResponse)) {
                return;
            }
            this.showTextFile(string, string2, file, n2, httpRequest, httpResponse);
            return;
        }
        if (this.cache != null) {
            httpResponse.setContentLength(this.cache.length);
            httpResponse.getOutputStream().write(this.cache);
            return;
        }
        if (JavaInc != null && string.endsWith("Java.inc")) {
            try {
                Field field = JavaInc.getField("bytes");
                byte[] byArray = (byte[])field.get(JavaInc);
                this.cache = byArray;
                httpResponse.setContentLength(byArray.length);
                OutputStream outputStream = httpResponse.getOutputStream();
                outputStream.write(byArray);
                return;
            }
            catch (SecurityException securityException) {
            }
            catch (Exception exception) {
                Util.printStackTrace(exception);
            }
        } else {
            bl = true;
        }
        string = string.replaceFirst("/JavaBridge", "META-INF");
        InputStream inputStream = JavaBridgeRunner.class.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            string = string.replaceFirst("Java\\.inc", "JavaBridge.inc");
            bl = true;
            inputStream = JavaBridgeRunner.class.getClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                httpResponse.setContentLength(ERROR.length);
                httpResponse.getOutputStream().write(ERROR);
                return;
            }
            if (Util.logLevel > 4) {
                Util.logDebug("Java.inc not found, using JavaBridge.inc instead");
            }
        }
        try {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            httpResponse.addHeader("Last-Modified", "Wed, 17 Jan 2007 19:52:43 GMT");
            httpResponse.setContentLength(byteArrayOutputStream.size());
            OutputStream outputStream = httpResponse.getOutputStream();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            outputStream.write(byArray2);
            if (!bl) {
                this.cache = byArray2;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public boolean isStandalone() {
        return this.isStandalone;
    }

    public static void main(String[] stringArray) throws InterruptedException, IOException {
        String string = null;
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            string = (Util.JAVABRIDGE_PROMISCUOUS ? "INET:" : "INET_LOCAL:") + stringArray[0];
        }
        Util.logMessage("JavaBridgeRunner started on port " + string);
        JavaBridgeRunner javaBridgeRunner = JavaBridgeRunner.getStandaloneInstance(string);
        javaBridgeRunner.httpServer.join();
        javaBridgeRunner.destroy();
    }

    static {
        try {
            JavaInc = Class.forName("php.java.bridge.JavaInc");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ctxServer = null;
    }
}

